/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest;
import kafka.log.LogConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\r%h\u0001B,Y\u0001uCQA\u0019\u0001\u0005\u0002\rDQ!\u001a\u0001\u0005\u0002\u00194q!\u001f\u0001\u0011\u0002\u0007\u0005!\u0010\u0003\u0004\u0002*\r!\tA\u001a\u0005\n\u0003W\u0019\u0001\u0019!C\u0001\u0003[A\u0011\"!\u000e\u0004\u0001\u0004%\t!a\u000e\t\u000f\u0005u2\u0001\"\u0011\u0002@!9\u0011qN\u0002\u0005B\u0005E\u0004BBAS\u0007\u0011\u0005c\rC\u0004\u0002>\r!\t%a*\u0007\u0013\u00055\u0006\u0001%A\u0002\u0002\u0005=\u0006BBA\u0015\u0017\u0011\u0005a\rC\u0005\u00028.\u0001\r\u0011\"\u0001\u0002:\"I\u0011\u0011Y\u0006A\u0002\u0013\u0005\u00111\u0019\u0005\b\u0003\u000f\\A\u0011IAe\u0011\u001d\tyg\u0003C!\u0003#Da!!*\f\t\u00032\u0007bBAd\u0017\u0011\u0005\u0013\u0011\u001d\u0005\b\u0003O\u0004A\u0011BAu\u0011\u0019\ty\u000f\u0001C\u0001M\"1!q\u0001\u0001\u0005\u0002\u0019DaAa\u0003\u0001\t\u00031\u0007B\u0002B\b\u0001\u0011\u0005a\r\u0003\u0004\u0003\u0014\u0001!\tA\u001a\u0005\u0007\u0005/\u0001A\u0011\u00014\t\r\tm\u0001\u0001\"\u0001g\u0011\u0019\u0011y\u0002\u0001C\u0001M\"1!1\u0005\u0001\u0005\u0002\u0019DaAa\n\u0001\t\u00031\u0007B\u0002B\u0016\u0001\u0011\u0005a\r\u0003\u0004\u00030\u0001!\tA\u001a\u0005\u0007\u0005g\u0001A\u0011\u00014\t\r\t]\u0002\u0001\"\u0001g\u0011\u0019\u0011Y\u0004\u0001C\u0001M\"1!q\b\u0001\u0005\u0002\u0019DaAa\u0011\u0001\t\u00031\u0007B\u0002B$\u0001\u0011\u0005a\r\u0003\u0004\u0003L\u0001!\tA\u001a\u0005\u0007\u0005\u001f\u0002A\u0011\u00014\t\r\tM\u0003\u0001\"\u0001g\u0011\u001d\u00119\u0006\u0001C\u0005\u00053BaA!\u001d\u0001\t\u00031\u0007B\u0002B;\u0001\u0011\u0005a\r\u0003\u0004\u0003z\u0001!\tA\u001a\u0005\u0007\u0005{\u0002A\u0011\u00014\t\u000f\t\u0005\u0005\u0001\"\u0003\u0003\u0004\"1!\u0011\u0012\u0001\u0005\u0002\u0019DqA!$\u0001\t\u0013\u0011y\t\u0003\u0004\u0003\u0016\u0002!\tA\u001a\u0005\u0007\u00053\u0003A\u0011\u00014\t\r\tu\u0005\u0001\"\u0001g\u0011\u0019\u0011\t\u000b\u0001C\u0001M\"1!Q\u0015\u0001\u0005\u0002\u0019DaA!+\u0001\t\u00031\u0007B\u0002BW\u0001\u0011\u0005a\r\u0003\u0004\u00032\u0002!\tA\u001a\u0005\u0007\u0005k\u0003A\u0011\u00014\t\r\te\u0006\u0001\"\u0001g\u0011\u0019\u0011i\f\u0001C\u0001M\"1!\u0011\u0019\u0001\u0005\u0002\u0019DaA!2\u0001\t\u00031\u0007B\u0002Be\u0001\u0011\u0005a\r\u0003\u0004\u0003N\u0002!\tA\u001a\u0005\u0007\u0005#\u0004A\u0011\u00014\t\r\tU\u0007\u0001\"\u0001g\u0011\u0019\u0011I\u000e\u0001C\u0001M\"1!Q\u001c\u0001\u0005\u0002\u0019DaA!9\u0001\t\u00031\u0007B\u0002Bs\u0001\u0011\u0005a\r\u0003\u0004\u0003j\u0002!\tA\u001a\u0005\u0007\u0005[\u0004A\u0011\u00014\t\r\tE\b\u0001\"\u0001g\u0011\u0019\u0011)\u0010\u0001C\u0001M\"1!\u0011 \u0001\u0005\u0002\u0019DaA!@\u0001\t\u00031\u0007BBB\u0001\u0001\u0011\u0005a\rC\u0004\u0004\u0006\u0001!\taa\u0002\t\u000f\r5\u0001\u0001\"\u0001\u0004\u0010!91\u0011\f\u0001\u0005\u0002\rm\u0003bBB:\u0001\u0011\u00051Q\u000f\u0005\b\u0007\u007f\u0002A\u0011ABA\u0011\u001d\u0019I\u000b\u0001C\u0005\u0007WCqa!2\u0001\t\u0013\u00199\r\u0003\u0004\u0004^\u0002!\tA\u001a\u0005\u0007\u0007C\u0004A\u0011\u00014\t\r\r\u0015\b\u0001\"\u0001g\u0005U\u0001F.Y5oi\u0016DHoQ8ogVlWM\u001d+fgRT!!\u0017.\u0002\u0007\u0005\u0004\u0018NC\u0001\\\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u00010\u0011\u0005}\u0003W\"\u0001-\n\u0005\u0005D&\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\r\u0005\u0002`\u0001\u0005YA/Z:u\u0011\u0016\fG-\u001a:t)\u00059\u0007C\u00015l\u001b\u0005I'\"\u00016\u0002\u000bM\u001c\u0017\r\\1\n\u00051L'\u0001B+oSRD#A\u00018\u0011\u0005=<X\"\u00019\u000b\u0005e\u000b(B\u0001:t\u0003\u001dQW\u000f]5uKJT!\u0001^;\u0002\u000b),h.\u001b;\u000b\u0003Y\f1a\u001c:h\u0013\tA\bO\u0001\u0003UKN$(AD*fe&\fG.\u001b>fe&k\u0007\u000f\\\n\u0005\u0007m\f9\u0001E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\fA\u0001\\1oO*\u0011\u0011\u0011A\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0006u\u0014aa\u00142kK\u000e$\bCBA\u0005\u00033\ti\"\u0004\u0002\u0002\f)!\u0011QBA\b\u00035\u0019XM]5bY&T\u0018\r^5p]*!\u0011\u0011CA\n\u0003\u0019\u0019w.\\7p]*\u00191,!\u0006\u000b\u0007\u0005]Q/\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u00037\tYA\u0001\u0006TKJL\u0017\r\\5{KJ\u0004R\u0001[A\u0010\u0003GI1!!\tj\u0005\u0015\t%O]1z!\rA\u0017QE\u0005\u0004\u0003OI'\u0001\u0002\"zi\u0016\fa\u0001J5oSR$\u0013AC:fe&\fG.\u001b>feV\u0011\u0011q\u0006\t\u0005\u0003\u0013\t\t$\u0003\u0003\u00024\u0005-!a\u0005\"zi\u0016\f%O]1z'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018AD:fe&\fG.\u001b>fe~#S-\u001d\u000b\u0004O\u0006e\u0002\"CA\u001e\r\u0005\u0005\t\u0019AA\u0018\u0003\rAH%M\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$\u0002\"!\b\u0002B\u0005m\u00131\u000e\u0005\b\u0003\u0007:\u0001\u0019AA#\u0003\u0015!x\u000e]5d!\u0011\t9%!\u0016\u000f\t\u0005%\u0013\u0011\u000b\t\u0004\u0003\u0017JWBAA'\u0015\r\ty\u0005X\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M\u0013.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\nIF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'J\u0007bBA/\u000f\u0001\u0007\u0011qL\u0001\bQ\u0016\fG-\u001a:t!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$\u0002BA3\u0003\u001f\ta\u0001[3bI\u0016\u0014\u0018\u0002BA5\u0003G\u0012q\u0001S3bI\u0016\u00148\u000fC\u0004\u0002n\u001d\u0001\r!!\b\u0002\t\u0011\fG/Y\u0001\nG>tg-[4ve\u0016$RaZA:\u00037Cq!!\u001e\t\u0001\u0004\t9(A\u0004d_:4\u0017nZ:1\t\u0005e\u0014\u0011\u0012\t\t\u0003w\n\t)!\u0012\u0002\u00066\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fz\u0018\u0001B;uS2LA!a!\u0002~\t\u0019Q*\u00199\u0011\t\u0005\u001d\u0015\u0011\u0012\u0007\u0001\t1\tY)a\u001d\u0002\u0002\u0003\u0005)\u0011AAG\u0005\ryF%M\t\u0005\u0003\u001f\u000b)\nE\u0002i\u0003#K1!a%j\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001[AL\u0013\r\tI*\u001b\u0002\u0004\u0003:L\bbBAO\u0011\u0001\u0007\u0011qT\u0001\u0006SN\\U-\u001f\t\u0004Q\u0006\u0005\u0016bAARS\n9!i\\8mK\u0006t\u0017!B2m_N,GCBA\u000f\u0003S\u000bY\u000bC\u0004\u0002D)\u0001\r!!\u0012\t\u000f\u00055$\u00021\u0001\u0002\u001e\t\u0001B)Z:fe&\fG.\u001b>fe&k\u0007\u000f\\\n\u0005\u0017m\f\t\f\u0005\u0004\u0002\n\u0005M\u0016QD\u0005\u0005\u0003k\u000bYA\u0001\u0007EKN,'/[1mSj,'/\u0001\u0007eKN,'/[1mSj,'/\u0006\u0002\u0002<B!\u0011\u0011BA_\u0013\u0011\ty,a\u0003\u0003+\tKH/Z!se\u0006LH)Z:fe&\fG.\u001b>fe\u0006\u0001B-Z:fe&\fG.\u001b>fe~#S-\u001d\u000b\u0004O\u0006\u0015\u0007\"CA\u001e\u001d\u0005\u0005\t\u0019AA^\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0011\u0005u\u00111ZAg\u0003\u001fDq!a\u0011\u0010\u0001\u0004\t)\u0005C\u0004\u0002^=\u0001\r!a\u0018\t\u000f\u00055t\u00021\u0001\u0002\u001eQ)q-a5\u0002`\"9\u0011Q\u000f\tA\u0002\u0005U\u0007\u0007BAl\u00037\u0004\u0002\"a\u001f\u0002\u0002\u0006\u0015\u0013\u0011\u001c\t\u0005\u0003\u000f\u000bY\u000e\u0002\u0007\u0002^\u0006M\u0017\u0011!A\u0001\u0006\u0003\tiIA\u0002`IIBq!!(\u0011\u0001\u0004\ty\n\u0006\u0004\u0002\u001e\u0005\r\u0018Q\u001d\u0005\b\u0003\u0007\u0012\u0002\u0019AA#\u0011\u001d\tiG\u0005a\u0001\u0003;\tq\u0004^3ti\"+\u0017\rZ3sgN+'/[1mSj,G)Z:fe&\fG.\u001b>f)\u00159\u00171^Aw\u0011\u001d\tYc\u0005a\u0001\u0003\u000fAq!a.\u0014\u0001\u0004\t\t,A\u0013uKN$H)\u001a9sK\u000e\fG/\u001a3Q_2d'\t\\8dWN4uN]!tg&<g.\\3oi\"\u0012AC\u001c\u0015\f)\u0005U\u00181`A\u007f\u0005\u0003\u0011\u0019\u0001E\u0002i\u0003oL1!!?j\u0005)!W\r\u001d:fG\u0006$X\rZ\u0001\b[\u0016\u001c8/Y4fC\t\ty0A\u0011q_2d\u0007\u0006R;sCRLwN\\\u0015!SN\u0004C\u000f[3!e\u0016\u0004H.Y2f[\u0016tG/A\u0003tS:\u001cW-\t\u0002\u0003\u0006\u0005\u0019!G\f\u0019\u0002CQ,7\u000f\u001e%fC\u0012,'o]*fe&\fG.\u001b>fe\u0012+7/\u001a:jC2L'0\u001a:)\u0005Uq\u0017A\u0005;fgRl\u0015\r\u001f)pY2\u0014VmY8sIND#A\u00068\u0002+Q,7\u000f^'bqB{G\u000e\\%oi\u0016\u0014h/\u00197Ng\"\u0012qC\\\u0001'i\u0016\u001cH/T1y!>dG.\u00138uKJ4\u0018\r\\'t\t\u0016d\u0017-_%o%\u00164xnY1uS>t\u0007F\u0001\ro\u0003\u0019\"Xm\u001d;NCb\u0004v\u000e\u001c7J]R,'O^1m\u001bN$U\r\\1z\u0013:\f5o]5h]6,g\u000e\u001e\u0015\u000339\fQ\u0003^3ti\u0006+Ho\\\"p[6LGo\u00148DY>\u001cX\r\u000b\u0002\u001b]\u0006\u0001C/Z:u\u0003V$xnQ8n[&$xJ\\\"m_N,\u0017I\u001a;fe^\u000b7.Z;qQ\tYb.A\nuKN$\u0018)\u001e;p\u001f\u001a47/\u001a;SKN,G\u000f\u000b\u0002\u001d]\u0006!B/Z:u\u000fJ|W\u000f]\"p]N,X\u000e\u001d;j_:D#!\b8\u0002/Q,7\u000f\u001e)biR,'O\\*vEN\u001c'/\u001b9uS>t\u0007F\u0001\u0010o\u0003\u0005\"Xm\u001d;Tk\n\u001cX-];f]R\u0004\u0016\r\u001e;fe:\u001cVOY:de&\u0004H/[8oQ\tyb.A\ruKN$\b+\u0019;uKJtWK\\:vEN\u001c'/\u001b9uS>t\u0007F\u0001\u0011o\u0003I!Xm\u001d;D_6l\u0017\u000e^'fi\u0006$\u0017\r^1)\u0005\u0005r\u0017a\u0004;fgR\f5/\u001f8d\u0007>lW.\u001b;)\u0005\tr\u0017a\b;fgR,\u0005\u0010]1oI&tw\rV8qS\u000e\u001cVOY:de&\u0004H/[8og\"\u00121E\\\u0001 i\u0016\u001cHo\u00155sS:\\\u0017N\\4U_BL7mU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\bF\u0001\u0013o\u0003E!Xm\u001d;QCJ$\u0018\u000e^5p]N4uN\u001d\u0015\u0003K9\f1\u0004^3tiB\u000b'\u000f^5uS>t7OR8s\u0003V$xn\u0011:fCR,\u0007F\u0001\u0014o\u0003u!Xm\u001d;QCJ$\u0018\u000e^5p]N4uN]%om\u0006d\u0017\u000e\u001a+pa&\u001c\u0007FA\u0014o\u0003!!Xm\u001d;TK\u0016\\\u0007F\u0001\u0015o\u0003Y\u0019XM\u001c3D_6\u0004(/Z:tK\u0012lUm]:bO\u0016\u001cH#B4\u0003\\\t\u0015\u0004b\u0002B/S\u0001\u0007!qL\u0001\u000b]Vl'+Z2pe\u0012\u001c\bc\u00015\u0003b%\u0019!1M5\u0003\u0007%sG\u000fC\u0004\u0003h%\u0002\rA!\u001b\u0002\u0005Q\u0004\b\u0003\u0002B6\u0005[j!!a\u0004\n\t\t=\u0014q\u0002\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003U!Xm\u001d;Q_NLG/[8o\u0003:$7i\\7nSRD#A\u000b8\u00027Q,7\u000f\u001e)beRLG/[8o!\u0006,8/Z!oIJ+7/^7fQ\tYc.\u0001\fuKN$h)\u001a;dQ&sg/\u00197jI>3gm]3uQ\tac.\u0001\u0014uKN$h)\u001a;dQJ+7m\u001c:e\u0019\u0006\u0014x-\u001a:UQ\u0006tg)\u001a;dQ6\u000b\u0007PQ=uKND#!\f8\u0002!\rDWmY6MCJ<WMU3d_J$GcA4\u0003\u0006\"9!q\u0011\u0018A\u0002\t}\u0013A\u00059s_\u0012,8-\u001a:SK\u000e|'\u000fZ*ju\u0016\fa\u0006^3ti\u001a+Go\u00195I_:|WO]:GKR\u001c\u0007nU5{K&3G*\u0019:hKJ+7m\u001c:e\u001d>$h)\u001b:ti\"\u0012qF\\\u0001+G\",7m\u001b$fi\u000eD\u0007j\u001c8pkJ\u001c8+\u001b>f\u0013\u001ad\u0015M]4f%\u0016\u001cwN\u001d3O_R4\u0015N]:u)\r9'\u0011\u0013\u0005\b\u0005'\u0003\u0004\u0019\u0001B0\u0003]a\u0017M]4f!J|G-^2feJ+7m\u001c:e'&TX-A\u001euKN$h)\u001a;dQ\"{gn\\;sg6\u000b\u0007\u0010U1si&$\u0018n\u001c8GKR\u001c\u0007NQ=uKNLe\rT1sO\u0016\u0014VmY8sI:{GOR5sgRD#!\r8\u0002_Q,7\u000f\u001e$fi\u000eD'+Z2pe\u0012d\u0015M]4feRC\u0017M\\'bqB\u000b'\u000f^5uS>tg)\u001a;dQ\nKH/Z:)\u0005Ir\u0017!\u000b;fgRdun^'bq\u001a+Go\u00195TSj,gi\u001c:SKF,Xm\u001d;B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u000b\u00024]\u0006AB/Z:u%>,h\u000e\u001a*pE&t\u0017i]:jO:lWM\u001c;)\u0005Qr\u0017a\t;fgRlU\u000f\u001c;j\u0007>t7/^7feJ{WO\u001c3S_\nLg.Q:tS\u001etwN\u001d\u0015\u0003k9\fq\u0004^3ti6+H\u000e^5D_:\u001cX/\\3s'RL7m[=BgNLwM\\8sQ\t1d.\u0001\u0011uKN$X*\u001e7uS\u000e{gn];nKJ$UMZ1vYR\f5o]5h]>\u0014\bFA\u001co\u0003M\"Xm\u001d;Nk2$\u0018nQ8ogVlWM\u001d#fM\u0006,H\u000e^!tg&<gn\u001c:B]\u00124VM]5gs\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u00029]\u0006aC/Z:u\u001bVdG/[\"p]N,X.\u001a:TKN\u001c\u0018n\u001c8US6,w.\u001e;P]N#x\u000e\u001d)pY2Lgn\u001a\u0015\u0003s9\fa\u0005^3ti6+H\u000e^5D_:\u001cX/\\3s'\u0016\u001c8/[8o)&lWm\\;u\u001f:\u001cEn\\:fQ\tQd.\u0001\tuKN$\u0018J\u001c;fe\u000e,\u0007\u000f^8sg\"\u00121H\\\u0001\u0018i\u0016\u001cH/Q;u_\u000e{W.\\5u\u0013:$XM]2faRD#\u0001\u00108\u0002CQ,7\u000f^%oi\u0016\u00148-\u001a9u_J\u001cx+\u001b;i/J|gnZ&fsZ\u000bG.^3)\u0005ur\u0017!\t;fgR\u001cuN\\:v[\u0016lUm]:bO\u0016\u001cx+\u001b;i\u0007J,\u0017\r^3US6,\u0007F\u0001 o\u0003\u0011\"Xm\u001d;D_:\u001cX/\\3NKN\u001c\u0018mZ3t/&$\b\u000eT8h\u0003B\u0004XM\u001c3US6,\u0007FA o\u00039!Xm\u001d;MSN$Hk\u001c9jGND#\u0001\u00118\u0002)Q,7\u000f^+ogV\u00147o\u0019:jE\u0016$v\u000e]5dQ\t\te.A\u0013uKN$\b+Y;tKN#\u0018\r^3O_R\u0004&/Z:feZ,GMQ=SK\n\fG.\u00198dK\"\u0012!I\\\u0001\u001bi\u0016\u001cHoQ8n[&$8\u000b]3dS\u001aLW\rZ(gMN,Go\u001d\u0015\u0003\u0007:\f\u0011\u0004^3ti\u0006+Ho\\\"p[6LGo\u00148SK\n\fG.\u00198dK\"\u0012AI\\\u00010i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:dU-\u00193NKR\u0014\u0018nY:DY\u0016\fg.\u00169XSRD7+\u001e2tGJL'-\u001a\u0015\u0003\u000b:\fa\u0006^3tiB+'\u000fU1si&$\u0018n\u001c8MC\u001elU\r\u001e:jGN\u001cE.Z1o+B<\u0016\u000e\u001e5Tk\n\u001c8M]5cK\"\u0012aI\\\u0001-i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:dU-\u00193NKR\u0014\u0018nY:DY\u0016\fg.\u00169XSRD\u0017i]:jO:D#a\u00128\u0002WQ,7\u000f\u001e)feB\u000b'\u000f^5uS>tG*Y4NKR\u0014\u0018nY:DY\u0016\fg.\u00169XSRD\u0017i]:jO:D#\u0001\u00138\u0002WQ,7\u000f\u001e)feB\u000b'\u000f^5uS>tG*Y4NKR\u0014\u0018nY:XQ\u0016t'+Z1e\u0007>lW.\u001b;uK\u0012D#!\u00138\u0002MQ,7\u000f\u001e)feB\u000b'\u000f^5uS>tG*Z1e/&$\b.T1y!>dGNU3d_J$7\u000f\u000b\u0002K]\u0006)C/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c'bO^KG\u000f['bqB{G\u000e\u001c*fG>\u0014Hm\u001d\u0015\u0003\u0017:\fa\u0006^3tiF+x\u000e^1NKR\u0014\u0018nY:O_R\u001c%/Z1uK\u0012LeMT8Rk>$\u0018m]\"p]\u001aLw-\u001e:fI\"\u0012AJ\\\u0001#eVtW*\u001e7uS\u000e{gn];nKJ\u001cVm]:j_:$\u0016.\\3pkR$Vm\u001d;\u0015\u0007\u001d\u001cI\u0001C\u0004\u0004\f5\u0003\r!a(\u0002\u001b\rdwn]3D_:\u001cX/\\3s\u0003I\u0019XOY:de&\u0014WmQ8ogVlWM]:\u0015\r\rE1QFB\"!\u0019\u0019\u0019b!\b\u0004\"5\u00111Q\u0003\u0006\u0005\u0007/\u0019I\"A\u0004nkR\f'\r\\3\u000b\u0007\rm\u0011.\u0001\u0006d_2dWm\u0019;j_:LAaa\b\u0004\u0016\t1!)\u001e4gKJ\u0004Baa\t\u0004&5\t\u0001!\u0003\u0003\u0004(\r%\"\u0001G\"p]N,X.\u001a:BgNLwM\\7f]R\u0004v\u000e\u001c7fe&\u001911\u0006-\u0003)\u0005\u00137\u000f\u001e:bGR\u001cuN\\:v[\u0016\u0014H+Z:u\u0011\u001d\u0019yC\u0014a\u0001\u0007c\tQbY8ogVlWM]$s_V\u0004\bCBB\n\u0007;\u0019\u0019\u0004\u0005\u0005\u00046\r}\u0012QDA\u000f\u001b\t\u00199D\u0003\u0003\u0004:\rm\u0012\u0001C2p]N,X.\u001a:\u000b\t\ru\u00121C\u0001\bG2LWM\u001c;t\u0013\u0011\u0019\tea\u000e\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s\u0011\u001d\u0019)E\u0014a\u0001\u0007\u000f\n\u0011\u0003^8qS\u000e\u001cHk\\*vEN\u001c'/\u001b2f!\u0019\u0019Iea\u0015\u0002F9!11JB(\u001d\u0011\tYe!\u0014\n\u0003)L1a!\u0015j\u0003\u001d\u0001\u0018mY6bO\u0016LAa!\u0016\u0004X\t!A*[:u\u0015\r\u0019\t&[\u0001(GJ,\u0017\r^3D_:\u001cX/\\3s\u000fJ|W\u000f]!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u0004^\r\r4qMB5!\u001dA7qLB\u0019\u0007#I1a!\u0019j\u0005\u0019!V\u000f\u001d7fe!91QM(A\u0002\t}\u0013!D2p]N,X.\u001a:D_VtG\u000fC\u0004\u0004F=\u0003\raa\u0012\t\u000f\r-t\n1\u0001\u0004n\u0005i1/\u001e2tGJL\u0007\u000f^5p]N\u0004b!a\u0012\u0004p\t%\u0014\u0002BB9\u00033\u00121aU3u\u0003Q\u001a\u0007.\u00198hK\u000e{gn];nKJ<%o\\;q'V\u00147o\u0019:jaRLwN\\!oIZ\u000bG.\u001b3bi\u0016\f5o]5h]6,g\u000e\u001e\u000b\bO\u000e]41PB?\u0011\u001d\u0019I\b\u0015a\u0001\u0007#\tqbY8ogVlWM\u001d)pY2,'o\u001d\u0005\b\u0007\u000b\u0002\u0006\u0019AB$\u0011\u001d\u0019Y\u0007\u0015a\u0001\u0007[\nqf\u00195b]\u001e,7i\u001c8tk6,'oU;cg\u000e\u0014\u0018\u000e\u001d;j_:\fe\u000e\u001a,bY&$\u0017\r^3BgNLwM\\7f]R,baa!\u0004\u0010\u000eUE#C4\u0004\u0006\u000ee51TBP\u0011\u001d\u0019I$\u0015a\u0001\u0007\u000f\u0003\u0002b!\u000e\u0004\n\u000e551S\u0005\u0005\u0007\u0017\u001b9D\u0001\u0005D_:\u001cX/\\3s!\u0011\t9ia$\u0005\u000f\rE\u0015K1\u0001\u0002\u000e\n\t1\n\u0005\u0003\u0002\b\u000eUEaBBL#\n\u0007\u0011Q\u0012\u0002\u0002-\"91QI)A\u0002\r\u001d\u0003bBBO#\u0002\u00071QN\u0001\u0013Kb\u0004Xm\u0019;fI\u0006\u001b8/[4o[\u0016tG\u000fC\u0004\u0004\"F\u0003\raa)\u0002#I,'-\u00197b]\u000e,G*[:uK:,'\u000f\u0005\u0003\u00046\r\u0015\u0016\u0002BBT\u0007o\u0011\u0011dQ8ogVlWM\u001d*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8fe\u0006!\u0012m^1ji:{g.R7qif\u0014VmY8sIN,ba!,\u00048\u000emFCBBX\u0007{\u001b\t\r\u0005\u0005\u00046\rE6QWB]\u0013\u0011\u0019\u0019la\u000e\u0003\u001f\r{gn];nKJ\u0014VmY8sIN\u0004B!a\"\u00048\u001291\u0011\u0013*C\u0002\u00055\u0005\u0003BAD\u0007w#qaa&S\u0005\u0004\ti\tC\u0004\u0004:I\u0003\raa0\u0011\u0011\rU2\u0011RB[\u0007sCqaa1S\u0001\u0004\u0011I'A\u0005qCJ$\u0018\u000e^5p]\u0006y\u0011m^1ji\u0006\u001b8/[4o[\u0016tG\u000fF\u0003h\u0007\u0013\u001cY\u000eC\u0004\u0004:M\u0003\raa31\r\r57\u0011[Bl!!\u0019)d!#\u0004P\u000eU\u0007\u0003BAD\u0007#$Aba5\u0004J\u0006\u0005\t\u0011!B\u0001\u0003\u001b\u00131a\u0018\u00134!\u0011\t9ia6\u0005\u0019\re7\u0011ZA\u0001\u0002\u0003\u0015\t!!$\u0003\u0007}#C\u0007C\u0004\u0004\u001eN\u0003\ra!\u001c\u00029Q,7\u000f^\"p]N,X.\u001b8h/&$\bNT;mY\u001e\u0013x.\u001e9JI\"\u0012AK\\\u0001\u001ei\u0016\u001cHoQ8ogVl\u0017N\\4XSRDW)\u001c9us\u001e\u0013x.\u001e9JI\"\u0012QK\\\u00019i\u0016\u001cHo\u0015;bi&\u001c7i\u001c8tk6,'\u000fR3uK\u000e$8OT3x!\u0006\u0014H/\u001b;j_:\u001c%/Z1uK\u0012\fe\r^3s%\u0016\u001cH/\u0019:uQ\t1f\u000e")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testHeaders() {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        record.headers().add("headerKey", "headerValue".getBytes());
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Header header = ((ConsumerRecord)records.apply(i)).headers().lastHeader("headerKey");
            Assertions.assertEquals((Object)"headerValue", (Object)(header == null ? null : new String(header.value())));
        });
    }

    private void testHeadersSerializeDeserialize(Serializer<byte[]> serializer, Deserializer<byte[]> deserializer) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.createProducer(new ByteArraySerializer(), serializer, this.createProducer$default$3()).send(record);
        KafkaConsumer consumer = this.createConsumer(new ByteArrayDeserializer(), deserializer, this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
    }

    @Test
    public void testDeprecatedPollBlocksForAssignment() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        consumer.poll(0L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(consumer.assignment()).asScala());
    }

    @Test
    public void testHeadersSerializerDeserializer() {
        SerializerImpl extendedSerializer = new SerializerImpl(this){
            private ByteArraySerializer serializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return SerializerImpl.serialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                SerializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                SerializerImpl.close$(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return SerializerImpl.serialize$(this, topic, data);
            }

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                SerializerImpl.$init$(this);
            }
        };
        DeserializerImpl extendedDeserializer = new DeserializerImpl(this){
            private ByteArrayDeserializer deserializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                DeserializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                DeserializerImpl.close$(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, data);
            }

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                DeserializerImpl.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize(extendedSerializer, extendedDeserializer);
    }

    @Test
    public void testMaxPollRecords() {
        int maxPollRecords = 2;
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        int x$6 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$7 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$8 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, x$6, startingTimestamp, x$7, x$8, maxPollRecords);
    }

    @Test
    public void testMaxPollIntervalMs() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(2000));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)0, (int)listener.callsToRevoked());
        Thread.sleep(3000L);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((int)2, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)1, (int)listener.callsToRevoked());
    }

    @Test
    public void testMaxPollIntervalMsDelayInRevocation() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        BooleanRef commitCompleted = BooleanRef.create((boolean)false);
        LongRef committedPosition = LongRef.create((long)-1L);
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this, committedPosition, consumer, commitCompleted){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final LongRef committedPosition$1;
            private final KafkaConsumer consumer$1;
            private final BooleanRef commitCompleted$1;

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (!partitions.isEmpty() && partitions.contains(this.$outer.tp())) {
                    Utils.sleep((long)1500L);
                    this.committedPosition$1.elem = this.consumer$1.position(this.$outer.tp());
                    this.consumer$1.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata(this.committedPosition$1.elem))}))).asJava());
                    this.commitCompleted$1.elem = true;
                }
                super.onPartitionsRevoked(partitions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.committedPosition$1 = committedPosition$1;
                this.consumer$1 = consumer$1;
                this.commitCompleted$1 = commitCompleted$1;
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"otherTopic"}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((long)0L, (long)committedPosition.elem);
        Assertions.assertTrue((boolean)commitCompleted.elem);
    }

    @Test
    public void testMaxPollIntervalMsDelayInAssignment() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this){

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                Utils.sleep((long)1500L);
                super.onPartitionsAssigned(partitions);
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        this.ensureNoRebalance((Consumer<?, ?>)consumer, listener);
    }

    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.wakeup();
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, x$5, startingTimestamp, x$6, x$7, x$8);
    }

    @Test
    public void testGroupConsumption() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 10, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, x$5, startingTimestamp, x$6, x$7, x$8);
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 1), this.sendRecords$default$4());
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 1), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        consumer.subscribe(pattern, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        String topic4 = "tsomec";
        this.createTopic(topic4, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 1), this.sendRecords$default$4());
        assignment = (scala.collection.immutable.Set)assignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testSubsequentPatternSubscription() {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String fooTopic = "foo";
        this.createTopic(fooTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(fooTopic, 0), this.sendRecords$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer.subscribe(pattern1, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        String barTopic = "bar";
        this.createTopic(barTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(barTopic, 0), this.sendRecords$default$4());
        Pattern pattern2 = Pattern.compile("...");
        consumer.subscribe(pattern2, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        assignment = (scala.collection.immutable.Set)assignment.$minus$minus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        assignment = (scala.collection.immutable.Set)assignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, Optional.of(Predef$.MODULE$.int2Integer(15)), "foo");
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assertions.assertEquals((Object)syncMetadata, consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)asyncMetadata)}))));
        Assertions.assertEquals((Object)asyncMetadata, consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata nullMetadata = new OffsetAndMetadata(5L, null);
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)nullMetadata)}))).asJava());
        Assertions.assertEquals((Object)nullMetadata, consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    @Test
    public void testAsyncCommit() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        AbstractConsumerTest.CountConsumerCommitCallback callback = new AbstractConsumerTest.CountConsumerCommitCallback();
        int count = 5;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> consumer.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata((long)i))}))).asJava(), (OffsetCommitCallback)callback));
        long pollUntilTrue_waitTimeMs = 10000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (PlaintextConsumerTest.$anonfun$testAsyncCommit$2(callback, count)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to observe commit callback before timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)None$.MODULE$, callback.lastError());
        Assertions.assertEquals((int)count, (int)callback.successCount());
        Assertions.assertEquals((Object)new OffsetAndMetadata((long)count), consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set initialAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)initialAssignment);
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        scala.collection.immutable.Set expandedAssignment = (scala.collection.immutable.Set)initialAssignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expandedAssignment);
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        scala.collection.immutable.Set initialAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), otherTopic}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)initialAssignment);
        scala.collection.immutable.Set shrunkenAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)shrunkenAssignment);
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        this.createTopic("part-test", numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        java.util.List parts = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).partitionsFor("part-test");
        Assertions.assertNotNull((Object)parts);
        Assertions.assertEquals((int)2, (int)parts.size());
    }

    @Test
    public void testPartitionsForAutoCreate() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.partitionsFor("non-exist-topic");
        Assertions.assertFalse((boolean)consumer.partitionsFor("non-exist-topic").isEmpty());
    }

    @Test
    public void testPartitionsForInvalidTopic() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(InvalidTopicException.class, () -> consumer.partitionsFor(";3# ads,{234"));
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()));
        long x$4 = startingTimestamp;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, x$5, x$4, x$6, x$7, x$8);
        consumer.seek(this.tp(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp2()));
        TopicPartition x$12 = this.tp2();
        int x$13 = this.consumeAndVerifyRecords$default$4();
        long x$14 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, 0, x$13, x$14, x$15, x$12, x$16);
        consumer.seek(this.tp2(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        int x$19 = (int)mid;
        int x$20 = (int)mid;
        TopicPartition x$22 = this.tp2();
        TimestampType x$23 = this.consumeAndVerifyRecords$default$6();
        int x$24 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, x$19, x$20, mid, x$23, x$22, x$24);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", Integer.toString(Integer.MAX_VALUE));
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, producerProps);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes())));
        producer.close();
    }

    @Test
    public void testPositionAndCommit() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertNull(consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))).asJava()).get(topicPartition));
        Assertions.assertThrows(IllegalStateException.class, () -> consumer.position(topicPartition));
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()), (String)"position() on a partition that we are subscribed to should reset the offset");
        consumer.commitSync();
        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        Assertions.assertEquals((long)5L, (long)consumer.position(this.tp()), (String)"After consuming 5 records, position should be 5");
        consumer.commitSync();
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset(), (String)"Committed offset should be returned");
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp);
        KafkaConsumer otherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        otherConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)otherConsumer, 1, 5, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testPartitionPauseAndResume() {
        java.util.List partitions = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)partitions);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        consumer.pause((Collection)partitions);
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(100L)).isEmpty());
        consumer.resume((Collection)partitions);
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 5, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int totalRecords = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, totalRecords, this.tp(), this.sendRecords$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertThrows(NoOffsetForPartitionException.class, () -> consumer.poll(Duration.ofMillis(15000L)));
        int outOfRangePos = totalRecords + 1;
        consumer.seek(this.tp(), (long)outOfRangePos);
        java.util.Map outOfRangePartitions = ((OffsetOutOfRangeException)Assertions.assertThrows(OffsetOutOfRangeException.class, () -> consumer.poll(Duration.ofMillis(20000L)))).offsetOutOfRangePartitions();
        Assertions.assertNotNull((Object)outOfRangePartitions);
        Assertions.assertEquals((int)1, (int)outOfRangePartitions.size());
        Assertions.assertEquals((long)outOfRangePos, (Long)((Long)outOfRangePartitions.get(this.tp())));
    }

    @Test
    public void testFetchRecordLargerThanFetchMaxBytes() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkLargeRecord(maxFetchBytes + 1);
    }

    private void checkLargeRecord(int producerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[producerRecordSize]);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])record.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])record.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursFetchSizeIfLargeRecordNotFirst() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxFetchBytes);
    }

    private void checkFetchHonoursSizeIfLargeRecordNotFirst(int largeProducerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord smallRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"small".getBytes(), (Object)"value".getBytes());
        ProducerRecord largeRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"large".getBytes(), (Object)new byte[largeProducerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(smallRecord).get();
        producer.send(largeRecord).get();
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursMaxPartitionFetchBytesIfLargeRecordNotFirst() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxPartitionFetchBytes);
    }

    @Test
    public void testFetchRecordLargerThanMaxPartitionFetchBytes() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkLargeRecord(maxPartitionFetchBytes + 1);
    }

    @Test
    public void testLowMaxFetchSizeForRequestAndPartition() {
        this.consumerConfig().setProperty("fetch.max.bytes", "500");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(20000));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        int partitionCount = 30;
        scala.collection.immutable.Seq topics = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}));
        topics.foreach((Function1 & Serializable)topicName -> this.createTopic((String)topicName, partitionCount, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5()));
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)topics.flatMap((Function1 & Serializable)topic -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitionCount).map((Function1 & Serializable)x$1 -> PlaintextConsumerTest.$anonfun$testLowMaxFetchSizeForRequestAndPartition$3(topic, BoxesRunTime.unboxToInt((Object)x$1))));
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)partitions.toSet());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Seq producerRecords = (scala.collection.immutable.Seq)partitions.flatMap((Function1 & Serializable)x$2 -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, partitionCount, (TopicPartition)x$2, this.sendRecords$default$4()));
        ArrayBuffer consumerRecords = this.consumeRecords(consumer, producerRecords.size(), this.consumeRecords$default$3());
        scala.collection.immutable.Set expected = ((IterableOnceOps)producerRecords.map((Function1 & Serializable)record -> new Tuple5((Object)record.topic(), (Object)record.partition(), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)record.timestamp()))).toSet();
        scala.collection.immutable.Set actual = ((IterableOnceOps)consumerRecords.map((Function1 & Serializable)record -> new Tuple5((Object)record.topic(), (Object)BoxesRunTime.boxToInteger((int)record.partition()), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)BoxesRunTime.boxToLong((long)record.timestamp())))).toSet();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 2, 100));
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        String topic3 = "topic3";
        this.createTopicAndSendRecords(producer, topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)newExpectedAssignment);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerRoundRobinAssignor() {
        void var7_7;
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        try {
            void var6_6;
            this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var7_7, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)var6_6, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var7_7, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))), (scala.collection.immutable.Set<TopicPartition>)subscriptions, "roundrobin-group");
        }
        finally {
            var7_7.foreach((Function1 & Serializable)x$4 -> {
                x$4.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerStickyAssignor() {
        void var6_6;
        void var7_7;
        this.consumerConfig().setProperty("group.id", "sticky-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", StickyAssignor.class.getName());
        String topic = "single-topic";
        int rand = 1 + Random$.MODULE$.nextInt(10);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicAndSendRecords(producer, topic, rand * 10, 100);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(9, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var7_7, partitions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        scala.collection.immutable.Map prePartition2PollerId = PlaintextConsumerTest.reverse$1(((IterableOnceOps)var7_7.map((Function1 & Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)var6_6, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var7_7, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), partitions, "sticky-group");
        scala.collection.immutable.Map postPartition2PollerId = PlaintextConsumerTest.reverse$1(((IterableOnceOps)var7_7.map((Function1 & Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        scala.collection.immutable.Set keys = (scala.collection.immutable.Set)prePartition2PollerId.keySet().union((Set)postPartition2PollerId.keySet());
        IntRef changes = IntRef.create((int)0);
        keys.foreach((Function1 & Serializable)key -> {
            PlaintextConsumerTest.$anonfun$testMultiConsumerStickyAssignor$5(prePartition2PollerId, postPartition2PollerId, changes, key);
            return BoxedUnit.UNIT;
        });
        var7_7.foreach((Function1 & Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)rand, (int)changes.elem, (String)"Expected only two topic partitions that have switched to other consumers.");
    }

    @Test
    public void testMultiConsumerDefaultAssignor() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 5, 100));
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))));
        try {
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
            this.addConsumersToGroupAndWaitForGroupAssignment(2, (Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, consumerPollers, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))), (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.addConsumersToGroupAndWaitForGroupAssignment$default$6());
            String topic2 = "topic2";
            scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(producer, topic2, 3, 100));
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1, topic2}))), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable)x$8 -> {
                x$8.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testMultiConsumerDefaultAssignorAndVerifyAssignment() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic2, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        TopicPartition tp1_0 = new TopicPartition(topic1, 0);
        TopicPartition tp1_1 = new TopicPartition(topic1, 1);
        TopicPartition tp1_2 = new TopicPartition(topic1, 2);
        TopicPartition tp2_0 = new TopicPartition(topic2, 0);
        TopicPartition tp2_1 = new TopicPartition(topic2, 1);
        TopicPartition tp2_2 = new TopicPartition(topic2, 2);
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0, tp1_1, tp1_2, tp2_0, tp2_1, tp2_2}));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))));
        Buffer expectedAssignment = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{(scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0, tp1_1, tp2_0, tp2_1})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_2, tp2_2}))}));
        try {
            Option<String> x$4 = this.validateGroupAssignment$default$3();
            long x$5 = this.validateGroupAssignment$default$4();
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, x$4, x$5, (Buffer<scala.collection.immutable.Set<TopicPartition>>)expectedAssignment);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable)x$9 -> {
                x$9.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @Test
    public void testInterceptors() {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("interceptor.classes", MockProducerInterceptor.class.getName());
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), producerProps);
        int numRecords = 10;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString()))).foreach((Function1 & Serializable)x$10 -> (RecordMetadata)x$10.get());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        Assertions.assertThrows(Throwable.class, () -> testProducer.send(null), () -> "Should not allow sending a null record");
        Assertions.assertEquals((int)1, (int)MockProducerInterceptor.ON_ERROR_COUNT.intValue(), (String)"Interceptor should be notified about exception");
        Assertions.assertEquals((int)0, (int)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue(), (String)"Interceptor should not receive metadata with an exception when record is null");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            Assertions.assertEquals((Object)new StringBuilder(4).append("key ").append(i).toString(), (Object)new String((String)record.key()));
            Assertions.assertEquals((Object)new StringBuilder(6).append("value ").append(i).append(appendStr).toString().toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
        });
        int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 1), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        this.sendAndAwaitAsyncCommit(testConsumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata(5L))}))));
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 2), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        testConsumer.close();
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
    }

    @Test
    public void testAutoCommitIntercept() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        int numRecords = 100;
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString()))).foreach((Function1 & Serializable)x$11 -> (RecordMetadata)x$11.get());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, testConsumer){
            private final KafkaConsumer testConsumer$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.testConsumer$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.testConsumer$1 = testConsumer$1;
            }
        };
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))), rebalanceListener);
        testConsumer.seek(this.tp(), 10L);
        testConsumer.seek(this.tp2(), 20L);
        int commitCountBeforeRebalance = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), rebalanceListener);
        Assertions.assertEquals((long)10L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)20L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        Assertions.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeRebalance ? 1 : 0) != 0);
        int commitCountBeforeClose = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.close();
        Assertions.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeClose ? 1 : 0) != 0);
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
    }

    @Test
    public void testInterceptorsWithWrongKeyValue() {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)"value will not be modified".getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        testConsumer.seek(this.tp(), 0L);
        ConsumerRecord record = (ConsumerRecord)this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3()).head();
        Assertions.assertEquals((Object)"value will not be modified", (Object)new String((byte[])record.value()));
    }

    @Test
    public void testConsumeMessagesWithCreateTime() {
        int numRecords = 50;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        this.sendCompressedMessages(numRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        TopicPartition x$11 = this.tp2();
        int x$13 = this.consumeAndVerifyRecords$default$4();
        long x$14 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, x$13, x$14, x$15, x$11, x$16);
    }

    @Test
    public void testConsumeMessagesWithLogAppendTime() {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
        this.createTopic(topicName, 2, 2, topicProps, this.createTopic$default$5());
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, tp1, this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1}))).asJava());
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, 0, startTime, TimestampType.LOG_APPEND_TIME, tp1, x$8);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2}))).asJava());
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, 0, startTime, TimestampType.LOG_APPEND_TIME, tp2, x$16);
    }

    @Test
    public void testListTopics() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic2, numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        java.util.Map topics = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).listTopics();
        Assertions.assertNotNull((Object)topics);
        Assertions.assertEquals((int)5, (int)topics.size());
        Assertions.assertEquals((int)5, (int)topics.keySet().size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic1)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic2)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic3)).size());
    }

    @Test
    public void testUnsubscribeTopic() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testPauseStateNotPreservedByRebalance() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 5, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        consumer.pause((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic2"}))).asJava());
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 0, 5, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testCommitSpecifiedOffsets() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 7, this.tp2(), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).asJava());
        long pos1 = consumer.position(this.tp());
        long pos2 = consumer.position(this.tp2());
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava());
        Assertions.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertNull(consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2()));
        Assertions.assertEquals((long)pos1, (long)consumer.position(this.tp()));
        Assertions.assertEquals((long)pos2, (long)consumer.position(this.tp2()));
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(5L))}))).asJava());
        Assertions.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)new OffsetAndMetadata(7L))}))));
        Assertions.assertEquals((long)7L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoCommitOnRebalance() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, consumer){
            private final KafkaConsumer consumer$6;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.consumer$6.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.consumer$6 = consumer$6;
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), rebalanceListener);
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), rebalanceListener);
        scala.collection.immutable.Set newAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)newAssignment);
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLead0 = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLead0);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead0.metricValue(), (String)new StringBuilder(19).append("The lead should be ").append(records.count()).toString());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLag0 = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLag0);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag0.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLead);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead.metricValue(), (String)new StringBuilder(19).append("The lead should be ").append(records.count()).toString());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp2());
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLag);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp2());
        Assertions.assertNull(consumer.metrics().get(new MetricName(new StringBuilder(12).append(this.tp().toString()).append(".records-lag").toString(), "consumer-fetch-manager-metrics", "", tags)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsWhenReadCommitted() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("isolation.level", "read_committed");
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Assertions.assertNotNull((Object)((Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags))));
    }

    @Test
    public void testPerPartitionLeadWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)maxPollRecords, (double)BoxesRunTime.unboxToDouble((Object)lead.metricValue()), (String)new StringBuilder(19).append("The lead should be ").append(maxPollRecords).toString());
    }

    @Test
    public void testPerPartitionLagWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)(numMessages - records.count()), (double)BoxesRunTime.unboxToDouble((Object)lag.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(numMessages - records.count()).toString());
    }

    @Test
    public void testQuotaMetricsNotCreatedIfNoQuotasConfigured() {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        consumer.seek(this.tp(), 0L);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        this.servers().foreach((Function1 & Serializable)x$12 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$12, "byte-rate", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$13 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$13, "throttle-time", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$14 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$14, "byte-rate", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$15 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$15, "throttle-time", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$16 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$16, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$17 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$17, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$18 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$18, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$19 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$19, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)broker -> {
            PlaintextConsumerTest.assertNoExemptRequestMetric$1(broker);
            return BoxedUnit.UNIT;
        });
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))), this.subscribeConsumerAndStartPolling$default$3()));
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))), this.subscribeConsumerAndStartPolling$default$3()));
        KafkaConsumer timeoutConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic1}))), this.subscribeConsumerAndStartPolling$default$3());
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        timeoutPoller.shutdown();
        consumerPollers.$minus$eq((Object)timeoutPoller);
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, (Option<String>)new Some((Object)new StringBuilder(68).append("Did not get valid assignment for partitions ").append(CollectionConverters$.MODULE$.SetHasAsJava((Set)subscriptions).asJava()).append(" after one consumer left").toString()), 3L * this.groupMaxSessionTimeoutMs(), this.validateGroupAssignment$default$5());
        consumerPollers.foreach((Function1 & Serializable)poller -> {
            poller.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> subscribeConsumers(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe) {
        void var3_3;
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1 & Serializable)consumer -> (Buffer)consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, topicsToSubscribe, this.subscribeConsumerAndStartPolling$default$3())));
        return var3_3;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assertions.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1 & Serializable)x$20 -> PlaintextConsumerTest.$anonfun$createConsumerGroupAndWaitForAssignment$1(this, consumerGroup, BoxesRunTime.unboxToInt((Object)x$20)));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1 & Serializable)poller -> {
            poller.subscribe((List<String>)topicsToSubscribe);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 1000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!consumerPollers.forall((Function1 & Serializable)poller -> BoxesRunTime.boxToBoolean((boolean)poller.isSubscribeRequestProcessed()))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$changeConsumerGroupSubscriptionAndValidateAssignment$4(subscriptions));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        this.validateGroupAssignment(consumerPollers, subscriptions, (Option<String>)new Some((Object)new StringBuilder(74).append("Did not get valid assignment for partitions ").append(CollectionConverters$.MODULE$.SetHasAsJava(subscriptions).asJava()).append(" after we changed subscription").toString()), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
    }

    public <K, V> void changeConsumerSubscriptionAndValidateAssignment(Consumer<K, V> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> expectedAssignment, ConsumerRebalanceListener rebalanceListener) {
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(topicsToSubscribe).asJava(), rebalanceListener);
        this.awaitAssignment(consumer, expectedAssignment);
    }

    private <K, V> ConsumerRecords<K, V> awaitNonEmptyRecords(Consumer<K, V> consumer, TopicPartition partition) {
        Object object = new Object();
        try {
            ConsumerRecords consumerRecords;
            long l = 15000L;
            long pollRecordsUntilTrue_waitUntilTrue_pause = 0L;
            long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!PlaintextConsumerTest.$anonfun$awaitNonEmptyRecords$1(partition, object, consumerRecords = consumer.poll(Duration.ofMillis(100L)))) {
                if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + l) {
                    Assertions.fail((String)PlaintextConsumerTest.$anonfun$awaitNonEmptyRecords$2(partition));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), pollRecordsUntilTrue_waitUntilTrue_pause));
            }
            throw new IllegalStateException("Should have timed out before reaching here");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (ConsumerRecords)ex.value();
            }
            throw ex;
        }
    }

    private void awaitAssignment(Consumer<?, ?> consumer, scala.collection.immutable.Set<TopicPartition> expectedAssignment) {
        long l = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (PlaintextConsumerTest.$anonfun$awaitAssignment$1(consumer, expectedAssignment)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + l) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$awaitAssignment$2(expectedAssignment, consumer));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), pollUntilTrue_waitUntilTrue_pause));
        }
    }

    @Test
    public void testConsumingWithNullGroupId() {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testConsumingWithNullGroupId$1(this, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Failed to create topic");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k3".getBytes(), (Object)"v3".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        List x$2 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"group.id"}));
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        KafkaConsumer consumer1 = this.createConsumer(x$3, x$4, consumer1Config, (List<String>)x$2);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("client.id", "consumer2");
        List x$6 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"group.id"}));
        ByteArrayDeserializer x$7 = this.createConsumer$default$1();
        ByteArrayDeserializer x$8 = this.createConsumer$default$2();
        KafkaConsumer consumer2 = this.createConsumer(x$7, x$8, consumer2Config, (List<String>)x$6);
        Properties consumer3Config = new Properties(this.consumerConfig());
        consumer3Config.put("client.id", "consumer3");
        List x$10 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"group.id"}));
        ByteArrayDeserializer x$11 = this.createConsumer$default$1();
        ByteArrayDeserializer x$12 = this.createConsumer$default$2();
        KafkaConsumer consumer3 = this.createConsumer(x$11, x$12, consumer3Config, (List<String>)x$10);
        consumer1.assign(Arrays.asList(tp));
        consumer2.assign(Arrays.asList(tp));
        consumer3.assign(Arrays.asList(tp));
        consumer3.seek(tp, 1L);
        int numRecords1 = consumer1.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer1.commitSync());
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer2.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()));
        int numRecords2 = consumer2.poll(Duration.ofMillis(5000L)).count();
        int numRecords3 = consumer3.poll(Duration.ofMillis(5000L)).count();
        consumer1.unsubscribe();
        consumer2.unsubscribe();
        consumer3.unsubscribe();
        consumer1.close();
        consumer2.close();
        consumer3.close();
        Assertions.assertEquals((int)3, (int)numRecords1, (String)"Expected consumer1 to consume from earliest offset");
        Assertions.assertEquals((int)0, (int)numRecords2, (String)"Expected consumer2 to consume from latest offset");
        Assertions.assertEquals((int)2, (int)numRecords3, (String)"Expected consumer3 to consume from offset 1");
    }

    @Test
    public void testConsumingWithEmptyGroupId() {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testConsumingWithEmptyGroupId$1(this, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Failed to create topic");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("group.id", "");
        consumer1Config.put("client.id", "consumer1");
        consumer1Config.put("max.poll.records", "1");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer1 = this.createConsumer(x$2, x$3, consumer1Config, x$4);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("group.id", "");
        consumer2Config.put("client.id", "consumer2");
        consumer2Config.put("max.poll.records", "1");
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        KafkaConsumer consumer2 = this.createConsumer(x$6, x$7, consumer2Config, x$8);
        consumer1.assign(Arrays.asList(tp));
        consumer2.assign(Arrays.asList(tp));
        ConsumerRecords records1 = consumer1.poll(Duration.ofMillis(5000L));
        consumer1.commitSync();
        ConsumerRecords records2 = consumer2.poll(Duration.ofMillis(5000L));
        consumer2.commitSync();
        consumer1.close();
        consumer2.close();
        Assertions.assertTrue((records1.count() == 1 && ((ConsumerRecord)CollectionConverters$.MODULE$.ListHasAsScala(records1.records(tp)).asScala().head()).offset() == 0L ? 1 : 0) != 0, (String)"Expected consumer1 to consume one message from offset 0");
        Assertions.assertTrue((records2.count() == 1 && ((ConsumerRecord)CollectionConverters$.MODULE$.ListHasAsScala(records2.records(tp)).asScala().head()).offset() == 1L ? 1 : 0) != 0, (String)"Expected consumer2 to consume one message from offset 1, which is the committed offset of consumer1");
    }

    @Test
    public void testStaticConsumerDetectsNewPartitionCreatedAfterRestart() {
        String foo = "foo";
        TopicPartition foo0 = new TopicPartition(foo, 0);
        TopicPartition foo1 = new TopicPartition(foo, 1);
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        admin.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(foo, 1, (short)1)}))).asJava()).all().get();
        Properties consumerConfig = new Properties();
        consumerConfig.put("group.id", "my-group-id");
        consumerConfig.put("group.instance.id", "my-instance-id");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer1 = this.createConsumer(x$2, x$3, consumerConfig, x$4);
        consumer1.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{foo}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer1, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0}))));
        consumer1.close();
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        KafkaConsumer consumer2 = this.createConsumer(x$6, x$7, consumerConfig, x$8);
        consumer2.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{foo}))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0}))));
        admin.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo), (Object)NewPartitions.increaseTo((int)2))}))).asJava()).all().get();
        this.awaitAssignment((Consumer<?, ?>)consumer2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0, foo1}))));
        consumer2.close();
    }

    public static final /* synthetic */ boolean $anonfun$testAsyncCommit$2(AbstractConsumerTest.CountConsumerCommitCallback callback$1, int count$1) {
        return callback$1.successCount() >= count$1 || callback$1.lastError().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAsyncCommit$3() {
        return "Failed to observe commit callback before timeout";
    }

    public static final /* synthetic */ TopicPartition $anonfun$testLowMaxFetchSizeForRequestAndPartition$3(String topic$1, int x$1) {
        return new TopicPartition(topic$1, x$1);
    }

    private static final scala.collection.immutable.Map reverse$1(scala.collection.immutable.Map m) {
        return ((IterableOnceOps)((IterableOps)m.values().toSet().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)v -> new Tuple2(v, ((IterableOps)m.keys().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$5 -> ((SetOps)m.apply((Object)BoxesRunTime.boxToLong((long)x$5))).contains(v))).head()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ void $anonfun$testMultiConsumerStickyAssignor$5(scala.collection.immutable.Map prePartition2PollerId$1, scala.collection.immutable.Map postPartition2PollerId$1, IntRef changes$1, TopicPartition key) {
        Option preVal = prePartition2PollerId$1.get((Object)key);
        Option postVal = postPartition2PollerId$1.get((Object)key);
        if (preVal.nonEmpty() && postVal.nonEmpty()) {
            if (BoxesRunTime.unboxToLong((Object)preVal.get()) != BoxesRunTime.unboxToLong((Object)postVal.get())) {
                ++changes$1.elem;
                return;
            }
        } else {
            ++changes$1.elem;
        }
    }

    private static final void assertNoMetric$1(KafkaServer broker, String name, QuotaType quotaType, String clientId) {
        MetricName metricName = broker.metrics().metricName("throttle-time", quotaType.toString(), "", new String[]{"user", "", "client-id", clientId});
        Assertions.assertNull((Object)broker.metrics().metric(metricName), (String)new StringBuilder(36).append("Metric should not have been created ").append(metricName).toString());
    }

    private static final void assertNoExemptRequestMetric$1(KafkaServer broker) {
        MetricName metricName = broker.metrics().metricName("exempt-request-time", "Request", "");
        Assertions.assertNull((Object)broker.metrics().metric(metricName), (String)new StringBuilder(36).append("Metric should not have been created ").append(metricName).toString());
    }

    public static final /* synthetic */ Buffer $anonfun$createConsumerGroupAndWaitForAssignment$1(PlaintextConsumerTest $this, Buffer consumerGroup$1, int x$20) {
        return (Buffer)consumerGroup$1.$plus$eq($this.createConsumer($this.createConsumer$default$1(), $this.createConsumer$default$2(), $this.createConsumer$default$3(), $this.createConsumer$default$4()));
    }

    public static final /* synthetic */ String $anonfun$changeConsumerGroupSubscriptionAndValidateAssignment$4(scala.collection.immutable.Set subscriptions$1) {
        return new StringBuilder(72).append("Failed to call subscribe on all consumers in the group for subscription ").append(subscriptions$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$awaitNonEmptyRecords$1(TopicPartition partition$1, Object nonLocalReturnKey1$1, ConsumerRecords polledRecords) {
        if (CollectionConverters$.MODULE$.ListHasAsScala(polledRecords.records(partition$1)).asScala().nonEmpty()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)polledRecords);
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$awaitNonEmptyRecords$2(TopicPartition partition$1) {
        return new StringBuilder(68).append("Consumer did not consume any messages for partition ").append(partition$1).append(" before timeout.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$awaitAssignment$1(Consumer consumer$7, scala.collection.immutable.Set expectedAssignment$1) {
        java.util.Set set = consumer$7.assignment();
        java.util.Set set2 = CollectionConverters$.MODULE$.SetHasAsJava((Set)expectedAssignment$1).asJava();
        return !(set != null ? !((Object)set).equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$awaitAssignment$2(scala.collection.immutable.Set expectedAssignment$1, Consumer consumer$7) {
        return new StringBuilder(0).append(new StringBuilder(47).append("Timed out while awaiting expected assignment ").append(expectedAssignment$1).append(". ").toString()).append(new StringBuilder(26).append("The current assignment is ").append(consumer$7.assignment()).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumingWithNullGroupId$1(PlaintextConsumerTest $this, String topic$2) {
        return $this.zkClient().topicExists(topic$2);
    }

    public static final /* synthetic */ String $anonfun$testConsumingWithNullGroupId$2() {
        return "Failed to create topic";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumingWithEmptyGroupId$1(PlaintextConsumerTest $this, String topic$3) {
        return $this.zkClient().topicExists(topic$3);
    }

    public static final /* synthetic */ String $anonfun$testConsumingWithEmptyGroupId$2() {
        return "Failed to create topic";
    }

    public static final /* synthetic */ Object $anonfun$awaitNonEmptyRecords$1$adapted(TopicPartition partition$1, Object nonLocalReturnKey1$1, ConsumerRecords polledRecords) {
        return BoxesRunTime.boxToBoolean((boolean)PlaintextConsumerTest.$anonfun$awaitNonEmptyRecords$1(partition$1, nonLocalReturnKey1$1, polledRecords));
    }

    public interface DeserializerImpl
    extends Deserializer<byte[]> {
        public ByteArrayDeserializer deserializer();

        public void deserializer_$eq(ByteArrayDeserializer var1);

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.deserialize(topic, headers, data);
        }

        default public byte[] deserialize(String topic, Headers headers, byte[] data) {
            Header header = headers.lastHeader("content-type");
            Assertions.assertEquals((Object)"application/octet-stream", (Object)(header == null ? null : new String(header.value())));
            return this.deserializer().deserialize(topic, data);
        }

        public static /* synthetic */ void configure$(DeserializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.deserializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(DeserializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.deserializer().close();
        }

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, byte[] data) {
            return $this.deserialize(topic, data);
        }

        default public byte[] deserialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer();

        public static void $init$(DeserializerImpl $this) {
            $this.deserializer_$eq(new ByteArrayDeserializer());
        }
    }

    public interface SerializerImpl
    extends Serializer<byte[]> {
        public ByteArraySerializer serializer();

        public void serializer_$eq(ByteArraySerializer var1);

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.serialize(topic, headers, data);
        }

        default public byte[] serialize(String topic, Headers headers, byte[] data) {
            headers.add("content-type", "application/octet-stream".getBytes());
            return this.serializer().serialize(topic, data);
        }

        public static /* synthetic */ void configure$(SerializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.serializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(SerializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.serializer().close();
        }

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, byte[] data) {
            return $this.serialize(topic, data);
        }

        default public byte[] serialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer();

        public static void $init$(SerializerImpl $this) {
            $this.serializer_$eq(new ByteArraySerializer());
        }
    }
}

