/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.Defaults$;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.LogTestUtils$;
import kafka.log.SegmentDeletionReason;
import kafka.server.FetchDataInfo;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00115b\u0001\u00025j\u00019DQ!\u001e\u0001\u0005\u0002YDq!\u001f\u0001A\u0002\u0013\u0005!\u0010C\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0001\u0002\u0006!9\u0011\u0011\u0003\u0001!B\u0013Y\b\"CA\n\u0001\t\u0007I\u0011AA\u000b\u0011!\t9\u0003\u0001Q\u0001\n\u0005]\u0001\"CA\u0015\u0001\t\u0007I\u0011AA\u000b\u0011!\tY\u0003\u0001Q\u0001\n\u0005]\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\u0018\u0011!\t9\u0005\u0001Q\u0001\n\u0005E\u0002\"CA%\u0001\t\u0007I\u0011AA&\u0011!\t\u0019\u0006\u0001Q\u0001\n\u00055\u0003\"CA+\u0001\t\u0007I\u0011AA,\u0011!\t)\u0007\u0001Q\u0001\n\u0005e\u0003\u0002\u00036\u0001\u0005\u0004%\t!a\u001a\t\u0011\u0005=\u0004\u0001)A\u0005\u0003SBq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002\f\u0002!\t!a\u001d\u0007\r\u0005U\u0005\u0001QAL\u0011)\t9l\u0005BK\u0002\u0013\u0005\u0011\u0011\u0018\u0005\u000b\u0003\u0017\u001c\"\u0011#Q\u0001\n\u0005m\u0006BCAg'\tU\r\u0011\"\u0001\u0002:\"Q\u0011qZ\n\u0003\u0012\u0003\u0006I!a/\t\rU\u001cB\u0011AAi\u0011\u001d\tYn\u0005C\u0001\u0003;D\u0011\"a?\u0014#\u0003%\t!!@\t\u0013\tM1#!A\u0005\u0002\tU\u0001\"\u0003B\u000e'E\u0005I\u0011\u0001B\u000f\u0011%\u0011\tcEI\u0001\n\u0003\u0011i\u0002C\u0005\u0003$M\t\t\u0011\"\u0011\u0003&!I!\u0011G\n\u0002\u0002\u0013\u0005!1\u0007\u0005\n\u0005w\u0019\u0012\u0011!C\u0001\u0005{A\u0011Ba\u0012\u0014\u0003\u0003%\tE!\u0013\t\u0013\t]3#!A\u0005\u0002\te\u0003\"\u0003B2'\u0005\u0005I\u0011\tB3\u0011%\u0011IgEA\u0001\n\u0003\u0012Y\u0007C\u0005\u0003nM\t\t\u0011\"\u0011\u0003p!I!\u0011O\n\u0002\u0002\u0013\u0005#1O\u0004\b\u0005o\u0002\u0001\u0012\u0001B=\r\u001d\t)\n\u0001E\u0001\u0005wBa!\u001e\u0015\u0005\u0002\t\u0005\u0005b\u0002BBQ\u0011\u0005!Q\u0011\u0005\n\u0005\u001fC\u0013\u0011!CA\u0005#C\u0011Ba&)\u0003\u0003%\tI!'\t\u000f\t-\u0006\u0001\"\u0003\u0003.\"9!1\u0018\u0001\u0005\n\tu\u0006b\u0002Bc\u0001\u0011%!q\u0019\u0005\n\u0005#\u0004\u0011\u0013!C\u0005\u0005'D\u0011Ba6\u0001#\u0003%I!!@\t\u000f\te\u0007\u0001\"\u0003\u0003\\\"I11\u0001\u0001\u0012\u0002\u0013%!1\u001b\u0005\n\u0007\u000b\u0001\u0011\u0013!C\u0005\u0003{D\u0011ba\u0002\u0001#\u0003%Ia!\u0003\t\u0013\r5\u0001!%A\u0005\n\r=\u0001\"CB\n\u0001E\u0005I\u0011BB\u000b\u0011%\u0019I\u0002AI\u0001\n\u0013\u0019y\u0001C\u0004\u0004\u001c\u0001!\t!a\u001d\t\u000f\r\u0015\u0002\u0001\"\u0001\u0002t!91\u0011\u0006\u0001\u0005\u0002\u0005M\u0004bBB\u0017\u0001\u0011\u0005\u00111\u000f\u0005\b\u0007c\u0001A\u0011AA:\u0011\u001d\u0019)\u0004\u0001C\u0001\u0003gBqa!\u000f\u0001\t\u0003\t\u0019\bC\u0004\u0004>\u0001!\t!a\u001d\t\u000f\r\u0005\u0003\u0001\"\u0001\u0002t!91Q\t\u0001\u0005\u0002\u0005M\u0004bBB%\u0001\u0011\u0005\u00111\u000f\u0005\b\u0007\u001b\u0002A\u0011AA:\u0011\u001d\u0019\t\u0006\u0001C\u0005\u0007'Bqa!\u0017\u0001\t\u0003\t\u0019\bC\u0004\u0004^\u0001!\t!a\u001d\t\u000f\r\u0005\u0004\u0001\"\u0003\u0004d!91q\r\u0001\u0005\u0002\u0005M\u0004bBB6\u0001\u0011\u0005\u00111\u000f\u0005\b\u0007_\u0002A\u0011AA:\u0011\u001d\u0019\u0019\b\u0001C\u0001\u0003gBqaa\u001e\u0001\t\u0003\t\u0019\bC\u0004\u0004|\u0001!\t!a\u001d\t\u000f\r}\u0004\u0001\"\u0001\u0002t!911\u0011\u0001\u0005\n\r\u0015\u0005bBBH\u0001\u0011\u0005\u00111\u000f\u0005\b\u0007'\u0003A\u0011AA:\u0011\u001d\u00199\n\u0001C\u0001\u0003gBqaa'\u0001\t\u0003\t\u0019\bC\u0004\u0004 \u0002!\t!a\u001d\t\u000f\r\r\u0006\u0001\"\u0001\u0002t!91q\u0015\u0001\u0005\u0002\u0005M\u0004bBBV\u0001\u0011\u0005\u00111\u000f\u0005\b\u0007_\u0003A\u0011AA:\u0011\u001d\u0019\u0019\f\u0001C\u0001\u0003gBqaa.\u0001\t\u0003\t\u0019\bC\u0004\u0004<\u0002!\t!a\u001d\t\u000f\r}\u0006\u0001\"\u0001\u0002t!911\u0019\u0001\u0005\u0002\u0005M\u0004bBBd\u0001\u0011%1\u0011\u001a\u0005\n\t\u000b\u0001\u0011\u0013!C\u0005\t\u000fA\u0011\u0002b\u0003\u0001#\u0003%I\u0001\"\u0004\t\u0013\u0011E\u0001!%A\u0005\n\u0005u\b\"\u0003C\n\u0001E\u0005I\u0011BB\u000b\u0011%!)\u0002AI\u0001\n\u0013!9\u0002C\u0005\u0005\u001c\u0001\t\n\u0011\"\u0003\u0005\u001e!IA\u0011\u0005\u0001\u0012\u0002\u0013%A1\u0005\u0005\n\tO\u0001\u0011\u0013!C\u0005\tS\u0011A\u0002T8dC2dun\u001a+fgRT!A[6\u0002\u00071|wMC\u0001m\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A8\u0011\u0005A\u001cX\"A9\u000b\u0003I\fQa]2bY\u0006L!\u0001^9\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u000f\u0005\u0002y\u00015\t\u0011.\u0001\u0004d_:4\u0017nZ\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011ap[\u0001\u0007g\u0016\u0014h/\u001a:\n\u0007\u0005\u0005QPA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR!\u0011qAA\u0007!\r\u0001\u0018\u0011B\u0005\u0004\u0003\u0017\t(\u0001B+oSRD\u0001\"a\u0004\u0004\u0003\u0003\u0005\ra_\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\u0007i6\u0004H)\u001b:\u0016\u0005\u0005]\u0001\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u0003S>T!!!\t\u0002\t)\fg/Y\u0005\u0005\u0003K\tYB\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA\u0019!\u0011\t\u0019$a\u0011\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\taaY8n[>t'b\u00017\u0002<)!\u0011QHA \u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011I\u0001\u0004_J<\u0017\u0002BA#\u0003k\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYV\u0011\u0011Q\n\t\u0004y\u0006=\u0013bAA){\n!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\fQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007%\u0001\u0005n_\u000e\\G+[7f+\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\tyf[\u0001\u0006kRLGn]\u0005\u0005\u0003G\niF\u0001\u0005N_\u000e\\G+[7f\u0003%iwnY6US6,\u0007%\u0006\u0002\u0002jA\u0019\u00010a\u001b\n\u0007\u00055\u0014N\u0001\u0005M_\u000e\fG\u000eT8h\u0003\u0011awn\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005\u001d\u0001fA\t\u0002xA!\u0011\u0011PAD\u001b\t\tYH\u0003\u0003\u0002~\u0005}\u0014aA1qS*!\u0011\u0011QAB\u0003\u001dQW\u000f]5uKJTA!!\"\u0002@\u0005)!.\u001e8ji&!\u0011\u0011RA>\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a!#a$\u0011\t\u0005e\u0014\u0011S\u0005\u0005\u0003'\u000bYHA\u0005BMR,'/R1dQ\nA1*Z=WC2,Xm\u0005\u0004\u0014_\u0006e\u0015q\u0014\t\u0004a\u0006m\u0015bAAOc\n9\u0001K]8ek\u000e$\b\u0003BAQ\u0003csA!a)\u0002.:!\u0011QUAV\u001b\t\t9KC\u0002\u0002*6\fa\u0001\u0010:p_Rt\u0014\"\u0001:\n\u0007\u0005=\u0016/A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0016Q\u0017\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003_\u000b\u0018aA6fsV\u0011\u00111\u0018\t\u0005\u0003{\u000b)M\u0004\u0003\u0002@\u0006\u0005\u0007cAASc&\u0019\u00111Y9\u0002\rA\u0013X\rZ3g\u0013\u0011\t9-!3\u0003\rM#(/\u001b8h\u0015\r\t\u0019-]\u0001\u0005W\u0016L\b%A\u0003wC2,X-\u0001\u0004wC2,X\r\t\u000b\u0007\u0003'\f9.!7\u0011\u0007\u0005U7#D\u0001\u0001\u0011\u001d\t9\f\u0007a\u0001\u0003wCq!!4\u0019\u0001\u0004\tY,\u0001\u0005u_J+7m\u001c:e)\u0011\ty.a;\u0011\t\u0005\u0005\u0018q]\u0007\u0003\u0003GTA!!:\u00026\u00051!/Z2pe\u0012LA!!;\u0002d\na1+[7qY\u0016\u0014VmY8sI\"I\u0011Q^\r\u0011\n\u0003\u0007\u0011q^\u0001\ni&lWm\u001d;b[B\u0004R\u0001]Ay\u0003kL1!a=r\u0005!a$-\u001f8b[\u0016t\u0004c\u00019\u0002x&\u0019\u0011\u0011`9\u0003\t1{gnZ\u0001\u0013i>\u0014VmY8sI\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0000*\"\u0011Q\u001fB\u0001W\t\u0011\u0019\u0001\u0005\u0003\u0003\u0006\t=QB\u0001B\u0004\u0015\u0011\u0011IAa\u0003\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0007c\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tE!q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001B2paf$b!a5\u0003\u0018\te\u0001\"CA\\7A\u0005\t\u0019AA^\u0011%\tim\u0007I\u0001\u0002\u0004\tY,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t}!\u0006BA^\u0005\u0003\tabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005O\u0001BA!\u000b\u000305\u0011!1\u0006\u0006\u0005\u0005[\ty\"\u0001\u0003mC:<\u0017\u0002BAd\u0005W\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u000e\u0011\u0007A\u00149$C\u0002\u0003:E\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0010\u0003FA\u0019\u0001O!\u0011\n\u0007\t\r\u0013OA\u0002B]fD\u0011\"a\u0004!\u0003\u0003\u0005\rA!\u000e\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0013\u0011\r\t5#1\u000bB \u001b\t\u0011yEC\u0002\u0003RE\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Fa\u0014\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00057\u0012\t\u0007E\u0002q\u0005;J1Aa\u0018r\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0004#\u0003\u0003\u0005\rAa\u0010\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005O\u00119\u0007C\u0005\u0002\u0010\r\n\t\u00111\u0001\u00036\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00036\u0005AAo\\*ue&tw\r\u0006\u0002\u0003(\u00051Q-];bYN$BAa\u0017\u0003v!I\u0011q\u0002\u0014\u0002\u0002\u0003\u0007!qH\u0001\t\u0017\u0016Lh+\u00197vKB\u0019\u0011Q\u001b\u0015\u0014\t!z'Q\u0010\t\u0005\u00033\u0011y(\u0003\u0003\u00024\u0006mAC\u0001B=\u0003)1'o\\7SK\u000e|'\u000f\u001a\u000b\u0005\u0003'\u00149\tC\u0004\u0002f*\u0002\rA!#\u0011\t\u0005\u0005(1R\u0005\u0005\u0005\u001b\u000b\u0019O\u0001\u0004SK\u000e|'\u000fZ\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003'\u0014\u0019J!&\t\u000f\u0005]6\u00061\u0001\u0002<\"9\u0011QZ\u0016A\u0002\u0005m\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u00057\u00139\u000bE\u0003q\u0005;\u0013\t+C\u0002\u0003 F\u0014aa\u00149uS>t\u0007c\u00029\u0003$\u0006m\u00161X\u0005\u0004\u0005K\u000b(A\u0002+va2,'\u0007C\u0005\u0003*2\n\t\u00111\u0001\u0002T\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019-48\u000fV8SK\u000e|'\u000fZ:\u0015\t\t=&Q\u0017\t\u0007\u0003C\u0013\t,a8\n\t\tM\u0016Q\u0017\u0002\t\u0013R,'/\u00192mK\"9!qW\u0017A\u0002\te\u0016!C6fsZ\u000bG.^3t!\u0019\t\tK!-\u0002T\u0006a!/Z2pe\u0012\u001cHk\\&wgR!!\u0011\u0018B`\u0011\u001d\u0011\tM\fa\u0001\u0005\u0007\fqA]3d_J$7\u000f\u0005\u0004\u0002\"\nE&\u0011R\u0001\u000eCB\u0004XM\u001c3SK\u000e|'\u000fZ:\u0015\u0011\u0005\u001d!\u0011\u001aBf\u0005\u001bDqA!10\u0001\u0004\u0011y\u000b\u0003\u0005k_A\u0005\t\u0019AA5\u0011%\u0011ym\fI\u0001\u0002\u0004\t)0A\u0007j]&$\u0018.\u00197PM\u001a\u001cX\r^\u0001\u0018CB\u0004XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uII*\"A!6+\t\u0005%$\u0011A\u0001\u0018CB\u0004XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM\n1B]3bIJ+7m\u001c:egRq!Q\u001cBr\u0005K\u0014IOa<\u0003t\n}\bc\u0001?\u0003`&\u0019!\u0011]?\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011!Q'\u0007%AA\u0002\u0005%\u0004\"\u0003BteA\u0005\t\u0019AA{\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u0013\t-(\u0007%CA\u0002\t5\u0018!C7bq2+gn\u001a;i!\u0015\u0001\u0018\u0011\u001fB\u001b\u0011%\u0011\tP\rI\u0001\u0002\u0004\u0011Y&A\u0007nS:|e.Z'fgN\fw-\u001a\u0005\n\u0005k\u0014\u0004\u0013\"a\u0001\u0005o\f\u0011#\\1y\u001f\u001a47/\u001a;NKR\fG-\u0019;b!\u0015\u0001\u0018\u0011\u001fB}!\ra(1`\u0005\u0004\u0005{l(!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\"I1\u0011\u0001\u001a\u0011\u0002\u0003\u0007!1L\u0001\u0013S:\u001cG.\u001e3f\u0003\n|'\u000f^3e)bt7/A\u000bsK\u0006$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002+I,\u0017\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001aTCAB\u0006U\u0011\u0011)D!\u0001\u0002+I,\u0017\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111\u0011\u0003\u0016\u0005\u00057\u0012\t!A\u000bsK\u0006$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r]!\u0006\u0002B}\u0005\u0003\tQC]3bIJ+7m\u001c:eg\u0012\"WMZ1vYR$c'\u0001\u000fuKN$Hj\\4EK2,G/Z*fO6,g\u000e^:Tk\u000e\u001cWm]:)\u0007e\u001ay\u0002\u0005\u0003\u0002z\r\u0005\u0012\u0002BB\u0012\u0003w\u0012A\u0001V3ti\u00061D/Z:u\u0019><G)\u001a7fi\u0016$\u0015N]*vG\u000e,7o],iK:,U\u000e\u001d;z\u0003:$g)Y5mkJ,w\u000b[3o\u001d>tW)\u001c9us\"\u001a!ha\b\u0002!Q,7\u000f^+qI\u0006$XmQ8oM&<\u0007fA\u001e\u0004 \u0005AB/Z:u\u0019><G)\u001b:SK:\fW.\u001a+p\u001d\u0016<H)\u001b:)\u0007q\u001ay\"A\u000fuKN$Hj\\4ESJ\u0014VM\\1nKR{W\t_5ti&tw\rR5sQ\ri4qD\u0001\ri\u0016\u001cH\u000fT8h\r2,8\u000f\u001b\u0015\u0004}\r}\u0011!\u0004;fgRdunZ!qa\u0016tG\rK\u0002@\u0007?\t1\u0003^3ti2{wm\u00117pg\u0016\u001cVoY2fgND3\u0001QB\u0010\u0003Y!Xm\u001d;M_\u001e\u001cEn\\:f\u0013\u0012,W\u000e]8uK:$\bfA!\u0004 \u0005YC/Z:u\u0019><7\t\\8tK\u001a\u000b\u0017\u000e\\;sK^CWM\\%o\u001b\u0016lwN]=Ck\u001a4WM]\"m_N,G\rK\u0002C\u0007?\tA\u0003^3ti2{wm\u00117pg\u0016D\u0015M\u001c3mKJ\u001c\bfA\"\u0004 \u0005qB/Z:u\u0019><7\t\\8tK\"\u000bg\u000e\u001a7feNLE-Z7q_R,g\u000e\u001e\u0015\u0004\t\u000e}\u0011a\u0007;fgR\u0014V-\\8wK\u0006sG\rR3mKR,7+Z4nK:$8\u000f\u0006\u0003\u0002\b\rU\u0003bBB,\u000b\u0002\u0007!1L\u0001\fCNLhn\u0019#fY\u0016$X-A\u0010uKN$(+Z7pm\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tGo]*z]\u000eD3ARB\u0010\u0003\u0001\"Xm\u001d;SK6|g/Z!oI\u0012+G.\u001a;f'\u0016<W.\u001a8ug\u0006\u001b\u0018P\\2)\u0007\u001d\u001by\"\u0001\fuKN$H)\u001a7fi\u0016\u001cVmZ7f]R4\u0015\u000e\\3t)\u0011\t9a!\u001a\t\u000f\r]\u0003\n1\u0001\u0003\\\u0005QB/Z:u\t\u0016dW\r^3TK\u001elWM\u001c;GS2,7oU=oG\"\u001a\u0011ja\b\u00027Q,7\u000f\u001e#fY\u0016$XmU3h[\u0016tGOR5mKN\f5/\u001f8dQ\rQ5qD\u0001\u001ci\u0016\u001cH\u000fR3mKR\f'\r\\3TK\u001elWM\u001c;t\r&dG/\u001a:)\u0007-\u001by\"\u0001\u0010uKN$H)\u001a7fi\u0006\u0014G.Z*fO6,g\u000e^:Ji\u0016\u0014\u0018\r^5p]\"\u001aAja\b\u00027Q,7\u000f\u001e+sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!uQ\ri5qD\u0001\u000fi\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a+pQ\rq5qD\u0001\u001ai\u0016\u001cHOT8o\u0003\u000e$\u0018N^3TK\u001elWM\u001c;t\rJ|W\u000eK\u0002P\u0007?\t!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nKR1\u00111XBD\u0007\u0017Cqa!#Q\u0001\u0004\tY,A\u0003u_BL7\rC\u0004\u0004\u000eB\u0003\r!a/\u0002\u0013A\f'\u000f^5uS>t\u0017a\u0007;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lW\rK\u0002R\u0007?\tA\u0007^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,w+\u001b;i!\u0016\u0014\u0018n\u001c3G_J$U\r\\3uK\u0012$v\u000e]5dQ\r\u00116qD\u0001(i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_J,U\u000e\u001d;z\u001d\u0006lW\rK\u0002T\u0007?\t!\u0005^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:Ok2d\u0007f\u0001+\u0004 \u0005qC/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]'jgNLgnZ*fa\u0006\u0014\u0018\r^8sQ\r)6qD\u0001+i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_Jl\u0015n]:j]\u001e$v\u000e]5dQ\r16qD\u0001/i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_Jl\u0015n]:j]\u001e\u0004\u0016M\u001d;ji&|g\u000eK\u0002X\u0007?\ta\u0006^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:J]Z\fG.\u001b3QCJ$\u0018\u000e^5p]\"\u001a\u0001la\b\u0002aQ,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X\t_5ti&tw-\u00138wC2LG\rR5sQ\rI6qD\u0001\u0015i\u0016\u001cH\u000fT8h\t\u0016dW\r^3ESJt\u0015-\\3)\u0007i\u001by\"\u0001\nuKN$xJ\u001a4tKR4%o\\7GS2,\u0007fA.\u0004 \u0005\u0001C/Z:u%>dGnU3h[\u0016tG\u000f\u00165bi\u0006c'/Z1es\u0016C\u0018n\u001d;tQ\ra6qD\u0001\u0019i\u0016\u001cHOT3x'\u0016<W.\u001a8ug\u00063G/\u001a:S_2d\u0007fA/\u0004 \u0005YC/Z:u%>dGnU3h[\u0016tG/\u0012:s_J<\u0006.\u001a8OKb$xJ\u001a4tKRL5/\u00137mK\u001e\fG\u000eK\u0002_\u0007?\tqd\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8u)Q\tIga3\u0004P\u000e]7\u0011]Bs\u0007S\u001c\u0019\u0010\"\u0001\u0005\u0004!I1QZ0\u0011\u0002\u0003\u0007\u0011qC\u0001\u0004I&\u0014\bBB=`\u0001\u0004\u0019\t\u000eE\u0002y\u0007'L1a!6j\u0005%aunZ\"p]\u001aLw\rC\u0005\u0004Z~\u0003\n\u00111\u0001\u0004\\\u0006A1/Z4nK:$8\u000fE\u0002y\u0007;L1aa8j\u0005-aunZ*fO6,g\u000e^:\t\u0013\r\rx\f%AA\u0002\u0005U\u0018!\u0004:fG>4XM]=Q_&tG\u000fC\u0005\u0004h~\u0003\n\u00111\u0001\u0003z\u0006\u0011b.\u001a=u\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011%\u0019Yo\u0018I\u0001\u0002\u0004\u0019i/A\u0005tG\",G-\u001e7feB!\u00111LBx\u0013\u0011\u0019\t0!\u0018\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\b\"CB{?B\u0005\t\u0019AB|\u0003\u0011!\u0018.\\3\u0011\t\re8Q`\u0007\u0003\u0007wTA!a\u0018\u00026%!1q`B~\u0005\u0011!\u0016.\\3\t\u0013\u00055r\f%AA\u0002\u0005E\u0002\"CA%?B\u0005\t\u0019AA'\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%cU\u0011A\u0011\u0002\u0016\u0005\u0003/\u0011\t!A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$HeM\u000b\u0003\t\u001fQCaa7\u0003\u0002\u0005I3M]3bi\u0016dunY1m\u0019><w+\u001b;i\u0003\u000e$\u0018N^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uIQ\n\u0011f\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012*\u0014!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$c'\u0006\u0002\u0005\u001a)\"1Q\u001eB\u0001\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%oU\u0011Aq\u0004\u0016\u0005\u0007o\u0014\t!A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H\u0005O\u000b\u0003\tKQC!!\r\u0003\u0002\u0005I3M]3bi\u0016dunY1m\u0019><w+\u001b;i\u0003\u000e$\u0018N^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uIe*\"\u0001b\u000b+\t\u00055#\u0011\u0001")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config = null;
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "127.0.0.1:1", bl, bl2, -1, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> kv.toRecord$default$1()));
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable)r -> this.KeyValue().fromRecord((Record)r));
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        boolean bl = false;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var5_6 = null;
        simpleRecordArray = null;
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((byte)2, (long)initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}))), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        List segmentsBeforeDelete = (List)((IterableOps)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)this.log().segments().values());
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}))), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        String string;
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = Predef$.MODULE$.Integer2int(oldConfig.segmentSize()) + 1;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$6 = string2;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(l, x$1, l2, l3, l4, x$6, n, n2, n3, l5);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}))), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testLogDirRenameToNewDir$1(newLogDir, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}))), this.log(), 0L);
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    @Test
    public void testLogAppend() {
        FetchDataInfo fetchDataInfo;
        FetchDataInfo fetchDataInfo2;
        LocalLog localLog;
        LocalLog localLog2 = localLog = this.log();
        localLog = null;
        LocalLog x$2 = localLog2;
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        FetchDataInfo fetchDataInfo3 = fetchDataInfo2 = x$2.read(l, 1, bl, this.readRecords$default$5(), bl2);
        fetchDataInfo2 = null;
        FetchDataInfo fetchDataInfoBeforeAppend = fetchDataInfo3;
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfoBeforeAppend.records().records()).asScala().isEmpty());
        this.mockTime().sleep(1L);
        Seq keyValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyValue[]{new KeyValue(this, "abc", "ABC"), new KeyValue(this, "de", "DE")}));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        long l2 = 0L;
        boolean bl3 = false;
        boolean bl4 = false;
        LocalLog readRecords_log = this.log();
        FetchDataInfo fetchDataInfo4 = fetchDataInfo = readRecords_log.read(l2, this.readRecords$default$3(), bl3, this.readRecords$default$5(), bl4);
        Object var6_12 = null;
        fetchDataInfo = null;
        FetchDataInfo fetchDataInfo5 = fetchDataInfo4;
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo5.records().records()).asScala().size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo5.records().records()).asScala()));
    }

    @Test
    public void testLogCloseSuccess() {
        Seq keyValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyValue[]{new KeyValue(this, "abc", "ABC"), new KeyValue(this, "de", "DE")}));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> {
            LocalLog localLog;
            Iterable<SimpleRecord> x$1 = this.kvsToRecords((Iterable<KeyValue>)keyValues);
            LocalLog localLog2 = localLog = this.log();
            localLog = null;
            LocalLog x$3 = localLog2;
            this.appendRecords(x$1, x$3, 2L);
        });
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        Seq keyValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyValue[]{new KeyValue(this, "abc", "ABC"), new KeyValue(this, "de", "DE")}));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        Seq keyValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyValue[]{new KeyValue(this, "abc", "ABC"), new KeyValue(this, "de", "DE")}));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> {
            LocalLog localLog;
            Iterable<SimpleRecord> x$1 = this.kvsToRecords((Iterable<KeyValue>)keyValues);
            LocalLog localLog2 = localLog = this.log();
            localLog = null;
            LocalLog x$3 = localLog2;
            this.appendRecords(x$1, x$3, 2L);
        });
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)((IterableOps)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)).$plus$plus(toDelete)));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = (Iterable)package$.MODULE$.List().apply((Seq)Nil$.MODULE$);
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        List toDelete = (List)((IterableOps)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)this.log().segments().values());
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(Predef$.MODULE$.Long2long(this.log().config().fileDeleteDelayMs()) + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        List toDelete = (List)((IterableOps)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)this.log().segments().values());
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(Predef$.MODULE$.Long2long(this.log().config().fileDeleteDelayMs()) + 1L);
        }
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testDeletableSegmentsFilter() {
        LocalLog localLog;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsFilter$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)10, (int)this.log().segments().numberOfSegments());
        Iterable deletable = this.log().deletableSegments((Function2 & Serializable)(segment, x$1) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$2(segment, x$1)));
        List expected = ((IterableOnceOps)this.log().segments().nonActiveLogSegmentsFrom(0L).filter((Function1 & Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$3(segment)))).toList();
        Assertions.assertEquals((int)6, (int)expected.length());
        Assertions.assertEquals((Object)expected, (Object)deletable.toList());
        Iterable deletable2 = this.log().deletableSegments((Function2 & Serializable)(x$2, x$3) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$4(x$2, x$3)));
        List expected2 = this.log().segments().nonActiveLogSegmentsFrom(0L).toList();
        Assertions.assertEquals((int)9, (int)expected2.length());
        Assertions.assertEquals((Object)expected2, (Object)deletable2.toList());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        List x$42 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}));
        LocalLog localLog2 = localLog = this.log();
        localLog = null;
        LocalLog x$6 = localLog2;
        this.appendRecords((Iterable<SimpleRecord>)x$42, x$6, 9L);
        Iterable deletable3 = this.log().deletableSegments((Function2 & Serializable)(x$4, x$5) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$5(x$4, x$5)));
        List expected3 = this.log().segments().values().toList();
        Assertions.assertEquals((int)10, (int)expected3.length());
        Assertions.assertEquals((Object)expected3, (Object)deletable3.toList());
    }

    @Test
    public void testDeletableSegmentsIteration() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsIteration$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        IntRef offset2 = IntRef.create((int)0);
        Iterable deletableSegments = this.log().deletableSegments((Function2 & Serializable)(segment, nextSegmentOpt) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsIteration$2(this, offset2, segment, nextSegmentOpt)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)this.log().segments().nonActiveLogSegmentsFrom(0L).toSeq(), (Object)deletableSegments.toSeq());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        FetchDataInfo fetchDataInfo;
        LocalLog localLog;
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            LocalLog localLog;
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            List x$4 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}));
            long x$5 = offset;
            LocalLog localLog2 = localLog = this.log();
            localLog = null;
            LocalLog x$6 = localLog2;
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        List expected = (List)((IterableOps)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)this.log().segments().values());
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        LocalLog localLog2 = localLog = this.log();
        localLog = null;
        LocalLog x$8 = localLog2;
        boolean bl = false;
        boolean bl2 = false;
        long readRecords_startOffset = 10L;
        FetchDataInfo fetchDataInfo2 = fetchDataInfo = x$8.read(readRecords_startOffset, this.readRecords$default$3(), bl, this.readRecords$default$5(), bl2);
        fetchDataInfo = null;
        FetchDataInfo fetchDataInfo3 = fetchDataInfo2;
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo3.records().records()).asScala().isEmpty());
    }

    @Test
    public void testTruncateTo() {
        LocalLog localLog;
        FetchDataInfo fetchDataInfo;
        LocalLog localLog2;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        List expected = (List)((IterableOps)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)this.log().segments().values(9L, this.log().logEndOffset() + 1L));
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        LocalLog localLog3 = localLog2 = this.log();
        localLog2 = null;
        LocalLog x$5 = localLog3;
        boolean bl = false;
        boolean bl2 = false;
        long readRecords_startOffset = 6L;
        FetchDataInfo fetchDataInfo2 = fetchDataInfo = x$5.read(readRecords_startOffset, this.readRecords$default$3(), bl, this.readRecords$default$5(), bl2);
        fetchDataInfo = null;
        FetchDataInfo fetchDataInfo3 = fetchDataInfo2;
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo3.records().records()).asScala().size());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyValue[]{new KeyValue(this, "", "a")})), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo3.records().records()).asScala()));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        List x$10 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}));
        LocalLog localLog4 = localLog = this.log();
        localLog = null;
        LocalLog x$12 = localLog4;
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, 7L);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile = LocalLog$.MODULE$.logFile(this.tmpDir(), offset, "");
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(logFile));
        File offsetIndexFile = LocalLog$.MODULE$.offsetIndexFile(this.tmpDir(), offset, "");
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(offsetIndexFile));
        File timeIndexFile = LocalLog$.MODULE$.timeIndexFile(this.tmpDir(), offset, "");
        Assertions.assertEquals((long)offset, (long)LocalLog$.MODULE$.offsetFromFile(timeIndexFile));
    }

    @Test
    public void testRollSegmentThatAlreadyExists() {
        FetchDataInfo fetchDataInfo;
        LocalLog localLog;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        List keyValues1 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyValue[]{new KeyValue(this, "k1", "v1")}));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        List keyValues2 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyValue[]{new KeyValue(this, "k2", "v2")}));
        List x$1 = keyValues2.map((Function1 & Serializable)x$7 -> x$7.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> this.mockTime().milliseconds() + 10L));
        LocalLog localLog2 = localLog = this.log();
        localLog = null;
        LocalLog x$3 = localLog2;
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, 1L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        LocalLog readRecords_log = this.log();
        FetchDataInfo fetchDataInfo2 = fetchDataInfo = readRecords_log.read(l, this.readRecords$default$3(), bl, this.readRecords$default$5(), bl2);
        Object var6_9 = null;
        fetchDataInfo = null;
        FetchDataInfo readResult = fetchDataInfo2;
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records().records()).asScala().size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((IterableOnce)keyValues2), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records().records()).asScala()));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        LocalLog localLog;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        Object[] objectArray = new SimpleRecord[1];
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable x$1 = (JFunction0.mcJ.sp & Serializable)() -> qual$1.toRecord$default$1();
        objectArray[0] = qual$1.toRecord((Function0<Object>)x$1);
        this.appendRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), this.log(), 0L);
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        Object[] objectArray2 = new SimpleRecord[1];
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable x$2 = (JFunction0.mcJ.sp & Serializable)() -> qual$2.toRecord$default$1();
        objectArray2[0] = qual$2.toRecord((Function0<Object>)x$2);
        List x$3 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        LocalLog localLog2 = localLog = this.log();
        localLog = null;
        LocalLog x$5 = localLog2;
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, 1L);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        List keyValues = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyValue[]{new KeyValue(this, "k1", "v1"), new KeyValue(this, "k2", "v2"), new KeyValue(this, "k3", "v3")}));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        String string;
        int x$5 = config.initFileSize();
        boolean x$6 = Predef$.MODULE$.Boolean2boolean(config.preallocate());
        boolean bl = false;
        String string2 = string = "";
        string = null;
        String x$8 = string2;
        segments.add(LogSegment$.MODULE$.open(dir, 0L, config, time, bl, x$5, x$6, x$8));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler();
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testLogDirRenameToNewDir$1(File newLogDir$1, LogSegment segment) {
        Assertions.assertEquals((Object)newLogDir$1.getPath(), (Object)segment.log().file().getParentFile().getPath());
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        LocalLog localLog;
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        List x$1 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}));
        long x$2 = offset;
        LocalLog localLog2 = localLog = $this.log();
        localLog = null;
        LocalLog x$3 = localLog2;
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        LocalLog localLog;
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        List x$1 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}));
        long x$2 = offset;
        LocalLog localLog2 = localLog = $this.log();
        localLog = null;
        LocalLog x$3 = localLog2;
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsFilter$1(LocalLogTest $this, int offset) {
        LocalLog localLog;
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        List x$1 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}));
        long x$2 = offset;
        LocalLog localLog2 = localLog = $this.log();
        localLog = null;
        LocalLog x$3 = localLog2;
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$2(LogSegment segment, Option x$1) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$3(LogSegment segment) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$4(LogSegment x$2, Option x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$5(LogSegment x$4, Option x$5) {
        return true;
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsIteration$1(LocalLogTest $this, int offset) {
        LocalLog localLog;
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        List x$1 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}));
        long x$2 = offset;
        LocalLog localLog2 = localLog = $this.log();
        localLog = null;
        LocalLog x$3 = localLog2;
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsIteration$2(LocalLogTest $this, IntRef offset$1, LogSegment segment, Option nextSegmentOpt) {
        Assertions.assertEquals((long)offset$1.elem, (long)segment.baseOffset());
        Option floorSegmentOpt = $this.log().segments().floorSegment((long)offset$1.elem);
        Assertions.assertTrue((boolean)floorSegmentOpt.isDefined());
        Assertions.assertEquals((Object)floorSegmentOpt.get(), (Object)segment);
        if ((long)offset$1.elem == $this.log().logEndOffset()) {
            Assertions.assertFalse((boolean)nextSegmentOpt.isDefined());
        } else {
            Assertions.assertTrue((boolean)nextSegmentOpt.isDefined());
            Option higherSegmentOpt = $this.log().segments().higherSegment(segment.baseOffset());
            Assertions.assertTrue((boolean)higherSegmentOpt.isDefined());
            Assertions.assertEquals((long)(segment.baseOffset() + 1L), (long)((LogSegment)higherSegmentOpt.get()).baseOffset());
            Assertions.assertEquals((Object)higherSegmentOpt.get(), (Object)nextSegmentOpt.get());
        }
        ++offset$1.elem;
        return true;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        LocalLog localLog;
        List x$1 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record$1}));
        long x$2 = offset;
        LocalLog localLog2 = localLog = $this.log();
        localLog = null;
        LocalLog x$3 = localLog2;
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        LocalLog localLog;
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        List x$1 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}));
        long x$2 = offset;
        LocalLog localLog2 = localLog = $this.log();
        localLog = null;
        LocalLog x$3 = localLog2;
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        LocalLog localLog;
        Seq keyValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeyValue[]{new KeyValue($this, Integer.toString(i), Integer.toString(i))}));
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog localLog2 = localLog = $this.log();
        localLog = null;
        LocalLog x$3 = localLog2;
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((IterableOnceOps)this.log().segments().nonActiveLogSegmentsFrom(startOffset).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()))).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogDirFailureChannel logDirFailureChannel;
        TopicPartition topicPartition;
        MockTime mockTime;
        File file;
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(Defaults$.MODULE$.SegmentMs(), Defaults$.MODULE$.SegmentSize(), Defaults$.MODULE$.RetentionMs(), Defaults$.MODULE$.RetentionSize(), Defaults$.MODULE$.SegmentJitterMs(), Defaults$.MODULE$.CleanupPolicy(), Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.IndexInterval(), Defaults$.MODULE$.MaxIndexSize(), Defaults$.MODULE$.FileDeleteDelayMs());
        File file2 = file = this.logDir();
        file = null;
        File x$2 = file2;
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long l = 0L;
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$7 = mockTime2;
        TopicPartition topicPartition2 = topicPartition = this.topicPartition();
        topicPartition = null;
        TopicPartition x$8 = topicPartition2;
        LogDirFailureChannel logDirFailureChannel2 = logDirFailureChannel = this.logDirFailureChannel();
        logDirFailureChannel = null;
        LogDirFailureChannel x$9 = logDirFailureChannel2;
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, l, x$5, x$6, (Time)x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "value";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof KeyValue)) return false;
            if (((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() != this.kafka$log$LocalLogTest$KeyValue$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            KeyValue keyValue = (KeyValue)x$1;
            String string = this.key();
            String string2 = keyValue.key();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.value();
            String string4 = keyValue.value();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!keyValue.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

