/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.Kafka$;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.BaseAuthorizerTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r=c\u0001B+W\u0001uCQ\u0001\u001b\u0001\u0005\u0002%Dqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004{\u0001\u0001\u0006I!\u001c\u0005\bw\u0002\u0011\r\u0011\"\u0003m\u0011\u0019a\b\u0001)A\u0005[\"9Q\u0010\u0001b\u0001\n\u0013a\u0007B\u0002@\u0001A\u0003%Q\u000e\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0011!\ty\u0001\u0001Q\u0001\n\u0005\r\u0001\"CA\t\u0001\t\u0007I\u0011BA\u0001\u0011!\t\u0019\u0002\u0001Q\u0001\n\u0005\r\u0001\"CA\u000b\u0001\t\u0007I\u0011BA\u0001\u0011!\t9\u0002\u0001Q\u0001\n\u0005\r\u0001\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\tY\u0003\u0001Q\u0001\n\u0005u\u0001\"CA\u0017\u0001\t\u0007I\u0011BA\u0018\u0011!\t9\u0004\u0001Q\u0001\n\u0005E\u0002\"CA\u001d\u0001\t\u0007I\u0011BA\u0018\u0011!\tY\u0004\u0001Q\u0001\n\u0005EbABA\u001f\u0001\u0001\ty\u0004\u0003\u0006\u0002BQ\u0011\t\u0011)A\u0005\u0003\u0007B!\"!\u0018\u0015\u0005\u0003\u0005\u000b\u0011BA\"\u0011\u0019AG\u0003\"\u0001\u0002`!9\u0011\u0011\u000e\u000b\u0005B\u0005-\u0004BB,\u0001\t\u0003\ny\bC\u0004\u0002\u000e\u0002!\t%a$\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\"9\u00111\u0019\u0001\u0005\u0002\u0005e\u0006bBAg\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003#\u0004A\u0011AA]\u0011\u001d\t)\u000e\u0001C\u0001\u0003sCq!!7\u0001\t\u0003\tI\fC\u0004\u0002^\u0002!\t!!/\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002:\"9\u0011Q\u001d\u0001\u0005\u0002\u0005e\u0006bBAu\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003[\u0004A\u0011AA]\u0011\u001d\t\t\u0010\u0001C\u0001\u0003sCq!!>\u0001\t\u0003\tI\fC\u0004\u0002z\u0002!\t!!/\t\u000f\u0005u\b\u0001\"\u0001\u0002:\"9!\u0011\u0001\u0001\u0005\u0002\u0005e\u0006b\u0002B\u0003\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0005\u0013\u0001A\u0011AA]\u0011\u001d\u0011i\u0001\u0001C\u0001\u0003sCqA!\u0005\u0001\t\u0003\tI\fC\u0004\u0003\u0016\u0001!IAa\u0006\t\u000f\t5\u0002\u0001\"\u0003\u00030!9!q\u0007\u0001\u0005\u0002\u0005e\u0006b\u0002B\u001e\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0005\u007f\u0001A\u0011AA]\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0003sCqAa\u0012\u0001\t\u0003\tI\fC\u0004\u0003L\u0001!\t!!/\t\u000f\t=\u0003\u0001\"\u0001\u0002:\"9!1\u000b\u0001\u0005\u0002\u0005e\u0006b\u0002B,\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u00057\u0002A\u0011AA]\u0011\u001d\u0011y\u0006\u0001C\u0001\u0003sCqAa\u0019\u0001\t\u0003\tI\fC\u0004\u0003h\u0001!\t!!/\t\u000f\t-\u0004\u0001\"\u0001\u0002:\"9!q\u000e\u0001\u0005\u0002\u0005e\u0006b\u0002B:\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0005o\u0002A\u0011AA]\u0011\u001d\u0011Y\b\u0001C\u0001\u0003sCqAa \u0001\t\u0003\tI\fC\u0004\u0003\u0004\u0002!\t!!/\t\u000f\t\u001d\u0005\u0001\"\u0001\u0002:\"9!1\u0012\u0001\u0005\u0002\u0005e\u0006b\u0002BH\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0005'\u0003A\u0011AA]\u0011\u001d\u00119\n\u0001C\u0001\u0003sCqAa'\u0001\t\u0013\u0011i\nC\u0004\u00034\u0002!IA!.\t\u000f\t=\u0007\u0001\"\u0003\u0003R\"I!1\u001d\u0001\u0012\u0002\u0013%!Q\u001d\u0005\b\u0005w\u0004A\u0011\u0002B\u007f\u0011\u001d\u00199\u0002\u0001C\u0005\u00073Aqaa\u0006\u0001\t\u0013\u0019\t\u0003C\u0004\u0004\u0018\u0001!Ia!\r\t\u000f\rU\u0002\u0001\"\u0003\u00048!91Q\b\u0001\u0005\n\r}\u0002bBB!\u0001\u0011%11\t\u0002\u0012\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:UKN$(BA,Y\u0003)\tW\u000f\u001e5pe&TXM\u001d\u0006\u00033j\u000b\u0001b]3dkJLG/\u001f\u0006\u00027\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001_IB\u0011qLY\u0007\u0002A*\u0011\u0011MW\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\r\u0004'!E)v_J,X\u000eV3ti\"\u000b'O\\3tgB\u0011QMZ\u0007\u0002-&\u0011qM\u0016\u0002\u0013\u0005\u0006\u001cX-Q;uQ>\u0014\u0018N_3s)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002UB\u0011Q\rA\u0001\rC2dwn\u001e*fC\u0012\f5\r\\\u000b\u0002[B\u0011a\u000e_\u0007\u0002_*\u0011\u0001/]\u0001\u0004C\u000ed'B\u0001:t\u0003\u0019\u0019w.\\7p]*\u00111\f\u001e\u0006\u0003kZ\fa!\u00199bG\",'\"A<\u0002\u0007=\u0014x-\u0003\u0002z_\n\u0011\u0012iY2fgN\u001cuN\u001c;s_2,e\u000e\u001e:z\u00035\tG\u000e\\8x%\u0016\fG-Q2mA\u0005i\u0011\r\u001c7po^\u0013\u0018\u000e^3BG2\fa\"\u00197m_^<&/\u001b;f\u0003\u000ed\u0007%A\u0006eK:L(+Z1e\u0003\u000ed\u0017\u0001\u00043f]f\u0014V-\u00193BG2\u0004\u0013\u0001E<jY\u0012\u001c\u0015M\u001d3SKN|WO]2f+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI!]\u0001\te\u0016\u001cx.\u001e:dK&!\u0011QBA\u0004\u0005=\u0011Vm]8ve\u000e,\u0007+\u0019;uKJt\u0017!E<jY\u0012\u001c\u0015M\u001d3SKN|WO]2fA\u0005\u0001\u0002O]3gSb,GMU3t_V\u00148-Z\u0001\u0012aJ,g-\u001b=fIJ+7o\\;sG\u0016\u0004\u0013aD2mkN$XM\u001d*fg>,(oY3\u0002!\rdWo\u001d;feJ+7o\\;sG\u0016\u0004\u0013!E<jY\u0012\u001c\u0017M\u001d3Qe&t7-\u001b9bYV\u0011\u0011Q\u0004\t\u0005\u0003?\t9#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\u0011\tW\u000f\u001e5\u000b\u0005e\u000b\u0018\u0002BA\u0015\u0003C\u0011abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\nxS2$7-\u0019:e!JLgnY5qC2\u0004\u0013!D1dY\u0006+H\u000f[8sSj,'/\u0006\u0002\u00022A\u0019Q-a\r\n\u0007\u0005UbKA\u0007BG2\fU\u000f\u001e5pe&TXM]\u0001\u000fC\u000ed\u0017)\u001e;i_JL'0\u001a:!\u00039\t7\r\\!vi\"|'/\u001b>feJ\nq\"Y2m\u0003V$\bn\u001c:ju\u0016\u0014(\u0007\t\u0002\u0010\u0007V\u001cHo\\7Qe&t7-\u001b9bYN\u0019A#!\b\u0002\u001bA\u0014\u0018N\\2ja\u0006dG+\u001f9f!\u0011\t)%a\u0016\u000f\t\u0005\u001d\u00131\u000b\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011Q\n/\u0002\rq\u0012xn\u001c;?\u0015\t\t\t&A\u0003tG\u0006d\u0017-\u0003\u0003\u0002V\u0005=\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002Z\u0005m#AB*ue&twM\u0003\u0003\u0002V\u0005=\u0013\u0001\u00028b[\u0016$b!!\u0019\u0002f\u0005\u001d\u0004cAA2)5\t\u0001\u0001C\u0004\u0002B]\u0001\r!a\u0011\t\u000f\u0005us\u00031\u0001\u0002D\u00051Q-];bYN$B!!\u001c\u0002vA!\u0011qNA9\u001b\t\ty%\u0003\u0003\u0002t\u0005=#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003oB\u0002\u0019AA=\u0003\u0005y\u0007\u0003BA8\u0003wJA!! \u0002P\t\u0019\u0011I\\=\u0016\u0005\u0005\u0005\u0005\u0003BAB\u0003\u0013k!!!\"\u000b\u0007]\u000b9I\u0003\u0002bg&!\u00111RAC\u0005)\tU\u000f\u001e5pe&TXM]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003#\u000b9\n\u0005\u0003\u0002p\u0005M\u0015\u0002BAK\u0003\u001f\u0012A!\u00168ji\"9\u0011\u0011\u0014\u000eA\u0002\u0005m\u0015\u0001\u0003;fgRLeNZ8\u0011\t\u0005u\u00151V\u0007\u0003\u0003?SA!!)\u0002$\u0006\u0019\u0011\r]5\u000b\t\u0005\u0015\u0016qU\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tIK^\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003[\u000byJ\u0001\u0005UKN$\u0018J\u001c4pQ\rQ\u0012\u0011\u0017\t\u0005\u0003;\u000b\u0019,\u0003\u0003\u00026\u0006}%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u0006\u0002\u0002\u0012\"\u001a1$!0\u0011\t\u0005u\u0015qX\u0005\u0005\u0003\u0003\fyJA\u0005BMR,'/R1dQ\u00069C/Z:u\u0003V$\bn\u001c:ju\u0016$\u0006N]8xg>sgj\u001c8MSR,'/\u00197SKN|WO]2fQ\ra\u0012q\u0019\t\u0005\u0003;\u000bI-\u0003\u0003\u0002L\u0006}%\u0001\u0002+fgR\f!\u0005^3ti\u0006+H\u000f[8sSj,w+\u001b;i\u000b6\u0004H/\u001f*fg>,(oY3OC6,\u0007fA\u000f\u0002H\u0006YB/Z:u\u000b6\u0004H/_!dYRC'o\\<t\u000bb\u001cW\r\u001d;j_:D3AHAd\u00031!Xm\u001d;U_BL7-Q2mQ\ry\u0012qY\u0001#i\u0016\u001cH/\u00117m_^\f5mY3tg^KG\u000f[\"vgR|W\u000e\u0015:j]\u000eL\u0007/\u00197)\u0007\u0001\n9-A\fuKN$H)\u001a8z)\u0006\\Wm\u001d)sK\u000e,G-\u001a8dK\"\u001a\u0011%a2\u0002%Q,7\u000f^!mY><\u0018\t\u001c7BG\u000e,7o\u001d\u0015\u0004E\u0005\u001d\u0017A\u0006;fgR\u001cV\u000f]3s+N,'\u000fS1t\u0003\u000e\u001cWm]:)\u0007\r\n9-A\u0015uKN$8+\u001e9feV\u001bXM],ji\"\u001cUo\u001d;p[B\u0013\u0018N\\2ja\u0006d\u0007*Y:BG\u000e,7o\u001d\u0015\u0004I\u0005\u001d\u0017\u0001\u0005;fgR<\u0016\u000e\u001c3DCJ$\u0017i\u00197tQ\r)\u0013qY\u0001\u000fi\u0016\u001cHOT8BG24u.\u001e8eQ\r1\u0013qY\u0001\u0017i\u0016\u001cHOT8BG24u.\u001e8e\u001fZ,'O]5eK\"\u001aq%a2\u0002+Q,7\u000f^!dY6\u000bg.Y4f[\u0016tG/\u0011)Jg\"\u001a\u0001&a2\u0002\u001bQ,7\u000f\u001e'pC\u0012\u001c\u0015m\u00195fQ\rI\u0013qY\u0001\u0019i\u0016\u001cHo\u00115b]\u001e,G*[:uK:,'\u000fV5nS:<\u0007f\u0001\u0016\u0002H\u0006iC/Z:u\u0019>\u001c\u0017\r\\\"p]\u000e,(O]3oi6{G-\u001b4jG\u0006$\u0018n\u001c8PMJ+7o\\;sG\u0016\f5\r\\:)\u0007-\n9-A\u001auKN$H)[:ue&\u0014W\u000f^3e\u0007>t7-\u001e:sK:$Xj\u001c3jM&\u001c\u0017\r^5p]>3'+Z:pkJ\u001cW-Q2mg\"\u001aA&a2\u0002[Q,7\u000f\u001e%jO\"\u001cuN\\2veJ,gnY=N_\u0012Lg-[2bi&|gn\u00144SKN|WO]2f\u0003\u000ed7\u000fK\u0002.\u0003\u000f\f!\u0003^3ti\u0006\u001bG.\u00138iKJLG/\u00198dK\"\u001aa&a2\u0002/Q,7\u000f^%na2L7-\u0019;j_:\u001cxJZ!mY><HCBAI\u00053\u0011\u0019\u0003C\u0004\u0003\u001c=\u0002\rA!\b\u0002\u0011A\f'/\u001a8u\u001fB\u00042A\u001cB\u0010\u0013\r\u0011\tc\u001c\u0002\r\u0003\u000edw\n]3sCRLwN\u001c\u0005\b\u0005Ky\u0003\u0019\u0001B\u0014\u0003)\tG\u000e\\8xK\u0012|\u0005o\u001d\t\u0007\u0003\u000b\u0012IC!\b\n\t\t-\u00121\f\u0002\u0004'\u0016$\u0018A\u0006;fgRLU\u000e\u001d7jG\u0006$\u0018n\u001c8t\u001f\u001a$UM\\=\u0015\r\u0005E%\u0011\u0007B\u001a\u0011\u001d\u0011Y\u0002\ra\u0001\u0005;AqA!\u000e1\u0001\u0004\u00119#A\u0005eK:LW\rZ(qg\u0006IC/Z:u\u0011&<\u0007nQ8oGV\u0014(/\u001a8ds\u0012+G.\u001a;j_:|eMU3t_V\u00148-Z!dYND3!MAd\u0003M\"Xm\u001d;BG\u000e,7o]!mY><X\rZ%g\u00032dwn^!dY\u0016C\u0018n\u001d;t\u001f:<\u0016\u000e\u001c3dCJ$'+Z:pkJ\u001cW\rK\u00023\u0003\u000f\fq\u0004^3ti\u0012+G.\u001a;f\u0003\u000edwJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\r\u0019\u0014qY\u0001#i\u0016\u001cH\u000fR3mKR,\u0017\t\u001c7BG2|enV5mI\u000e\f'\u000f\u001a*fg>,(oY3)\u0007Q\n9-A\u001auKN$\u0018iY2fgN\fE\u000e\\8xK\u0012Le-\u00117m_^\f5\r\\#ySN$8o\u00148Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\"\u001aQ'a2\u0002?Q,7\u000f\u001e#fY\u0016$X-Q2m\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cW\rK\u00027\u0003\u000f\f!\u0005^3ti\u0012+G.\u001a;f\u00032d\u0017i\u00197P]B\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007fA\u001c\u0002H\u0006aB/Z:u\u0003\u0012$\u0017i\u00197t\u001f:d\u0015\u000e^3sC2\u0014Vm]8ve\u000e,\u0007f\u0001\u001d\u0002H\u0006iB/Z:u\u0003\u0012$\u0017i\u00197t\u001f:<\u0016\u000e\u001c3dCJ$'+Z:pkJ\u001cW\rK\u0002:\u0003\u000f\fQ\u0004^3ti\u0006#G-Q2mg>s\u0007K]3gSb,GMU3t_V\u00148-\u001a\u0015\u0004u\u0005\u001d\u0017!\t;fgR\fU\u000f\u001e5pe&TXmV5uQB\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007fA\u001e\u0002H\u0006yB/Z:u'&tw\r\\3DQ\u0006\u0014\u0018m\u0019;feJ+7o\\;sG\u0016\f5\r\\:)\u0007q\n9-\u0001\u000buKN$x)\u001a;BG2\u001c\bK]5oG&\u0004\u0018\r\u001c\u0015\u0004{\u0005\u001d\u0017A\u0004;fgR\f5\r\\:GS2$XM\u001d\u0015\u0004}\u0005\u001d\u0017\u0001\u0010;fgR$\u0006N]8xg>s\u0017\t\u001a3Qe\u00164\u0017\u000e_3e\u0003\u000ed\u0017JZ%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dg+\u001a:tS>tGk\\8M_^D3aPAd\u0003m\"Xm\u001d;Xe&$Xm]#yi\u0016tG-\u001a3BG2\u001c\u0005.\u00198hK\u00163XM\u001c;JM&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7O_R\u001cV\r\u001e\u0015\u0004\u0001\u0006\u001d\u0017!\u0012;fgR<&/\u001b;fg\u0016CH/\u001a8eK\u0012\f5\r\\\"iC:<W-\u0012<f]R<\u0006.\u001a8J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|G.\u0011;MK\u0006\u001cHoS1gW\u00064&\u0007K\u0002B\u0003\u000f\f\u0001\u0010^3ti^\u0013\u0018\u000e^3t\u0019&$XM]1m/JLG/Z:MSR,'/\u00197BG2\u001c\u0005.\u00198hK\u00163XM\u001c;XQ\u0016t\u0017J\u001c;fe\n\u0013xn[3s!J|Go\\2pY2+7o\u001d+iC:\\\u0015MZ6b-J*'/\u00197BG2\u001c\u0005.\u00198hKN4uN](mI\u0016\u0014\bK]8u_\u000e|GNV3sg&|gn\u001d\u0015\u0004\u0005\u0006\u001d\u0017a\u0010;fgR<&/\u001b;fg2KG/\u001a:bY\u0006\u001bGn\u00115b]\u001e,WI^3oi^CWM\\%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d\u0017j]&bM.\fgK\r\u0015\u0004\u0007\u0006\u001d\u0017\u0001\u0007;fgR\fU\u000f\u001e5pe&TXM\u001d(p5.\u001cuN\u001c4jO\"\u001aA)a2\u0002cQ,7\u000f^!vi\"|'/\u001b>fej[7i\u001c8gS\u001e4%o\\7LC\u001a\\\u0017mQ8oM&<w+\u001b;i\t\u00164\u0017-\u001e7ug\"\u001aQ)a2\u0002KQ,7\u000f^!vi\"|'/\u001b>fej[7i\u001c8gS\u001e4%o\\7LC\u001a\\\u0017mQ8oM&<\u0007f\u0001$\u0002H\u0006IC/Z:u\u0003V$\bn\u001c:ju\u0016\u0014(l[\"p]\u001aLwM\u0012:p[B\u0013XMZ5y\u001fZ,'O]5eKND3aRAd\u0003Y!Xm\u001d;De\u0016\fG/\u001a#fY\u0016$X\rV5nS:<\u0007f\u0001%\u0002H\u0006iC/Z:u\u0003V$\bn\u001c:ju\u0016\u0014\u0015PU3t_V\u00148-\u001a+za\u0016tu.Q2m\r>,h\u000eZ(wKJ\u0014\u0018\u000eZ3)\u0007%\u000b9-\u0001\u0012hSZ,g.Q;uQ>\u0014\u0018N_3s/&$\b\u000e\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c\u000b\u0005\u0003#\u0013y\nC\u0004\u0003\"*\u0003\rAa)\u0002\u001fA\u0014x\u000e^8d_24VM]:j_:\u0004b!a\u001c\u0003&\n%\u0016\u0002\u0002BT\u0003\u001f\u0012aa\u00149uS>t\u0007\u0003\u0002BV\u0005_k!A!,\u000b\u0007\u0005\u0005&,\u0003\u0003\u00032\n5&AC!qSZ+'o]5p]\u0006Ir-\u001a;BG2\u001c\u0005.\u00198hK\u00163XM\u001c;BgN#(/\u001b8h)\u0011\u00119L!2\u0011\t\te&1Y\u0007\u0003\u0005wSAA!0\u0003@\u0006!A.\u00198h\u0015\t\u0011\t-\u0001\u0003kCZ\f\u0017\u0002BA-\u0005wCqAa2L\u0001\u0004\u0011I-A\u0006qCR$XM\u001d8UsB,\u0007\u0003BA\u0003\u0005\u0017LAA!4\u0002\b\tY\u0001+\u0019;uKJtG+\u001f9f\u0003I\u0019\u0007.\u00198hK\u0006\u001bG.\u00118e-\u0016\u0014\u0018NZ=\u0015\u0015\tM'Q\u001bBm\u0005;\u0014\t\u000fE\u0003\u0002F\t%R\u000eC\u0004\u0003X2\u0003\rAa5\u0002\u0019=\u0014\u0018nZ5oC2\f5\r\\:\t\u000f\tmG\n1\u0001\u0003T\u0006I\u0011\r\u001a3fI\u0006\u001bGn\u001d\u0005\b\u0005?d\u0005\u0019\u0001Bj\u0003-\u0011X-\\8wK\u0012\f5\r\\:\t\u0013\u0005%A\n%AA\u0002\u0005\r\u0011\u0001H2iC:<W-Q2m\u0003:$g+\u001a:jMf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005OTC!a\u0001\u0003j.\u0012!1\u001e\t\u0005\u0005[\u001490\u0004\u0002\u0003p*!!\u0011\u001fBz\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003v\u0006=\u0013AC1o]>$\u0018\r^5p]&!!\u0011 Bx\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\nCV$\bn\u001c:ju\u0016$\"\"!\u001c\u0003\u0000\u000e\u00051\u0011CB\u000b\u0011\u00199f\n1\u0001\u00022!911\u0001(A\u0002\r\u0015\u0011A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0007\u000f\u0019i!\u0004\u0002\u0004\n)\u001911B9\u0002\u0011I,\u0017/^3tiNLAaa\u0004\u0004\n\tq!+Z9vKN$8i\u001c8uKb$\bbBB\n\u001d\u0002\u0007!QD\u0001\n_B,'/\u0019;j_:Dq!!\u0003O\u0001\u0004\t\u0019!A\u0004hKR\f5\r\\:\u0015\r\tM71DB\u000f\u0011\u00199v\n1\u0001\u00022!91qD(A\u0002\u0005\r\u0011a\u0004:fg>,(oY3QCR$XM\u001d8\u0015\r\r\r21FB\u0017!\u0019\t)E!\u000b\u0004&A\u0019ana\n\n\u0007\r%rN\u0001\u0006BG2\u0014\u0015N\u001c3j]\u001eDaa\u0016)A\u0002\u0005E\u0002bBB\u0018!\u0002\u0007\u0011QD\u0001\naJLgnY5qC2$Baa\t\u00044!1q+\u0015a\u0001\u0003c\tqA^1mS\u0012|\u0005\u000f\u0006\u0003\u0002n\re\u0002bBB\u001e%\u0002\u0007!QD\u0001\u0003_B\fA\u0003\u001d:fa\u0006\u0014X\rR3gCVdGoQ8oM&<WCAA\"\u00035\u0001(/\u001a9be\u0016\u001cuN\u001c4jOR!\u00111IB#\u0011\u001d\u00199\u0005\u0016a\u0001\u0007\u0013\nQ\u0001\\5oKN\u0004b!a\u001c\u0004L\u0005\r\u0013\u0002BB'\u0003\u001f\u0012Q!\u0011:sCf\u0004")
public class AclAuthorizerTest
extends QuorumTestHarness
implements BaseAuthorizerTest {
    private final AccessControlEntry allowReadAcl;
    private final AccessControlEntry allowWriteAcl;
    private final AccessControlEntry denyReadAcl;
    private final ResourcePattern wildCardResource;
    private final ResourcePattern prefixedResource;
    private final ResourcePattern clusterResource;
    private final KafkaPrincipal wildcardPrincipal;
    private final AclAuthorizer aclAuthorizer;
    private final AclAuthorizer aclAuthorizer2;
    private String superUsers;
    private String username;
    private KafkaPrincipal principal;
    private RequestContext requestContext;
    private String superUserName;
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;
    private ResourcePattern resource;

    @Override
    @Test
    public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeMultipleAddAndRemove$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeDenyTakesPrecedence$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypePrefixedResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWildcardResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllOperationAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllOperationAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllHostAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllHostAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllPrincipalAce$(this);
    }

    @Override
    @Test
    public void testAuthorzeByResourceTypeSuperUserHasAccess() {
        BaseAuthorizerTest.testAuthorzeByResourceTypeSuperUserHasAccess$(this);
    }

    @Override
    public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return BaseAuthorizerTest.newRequestContext$(this, principal, clientAddress, apiKey);
    }

    @Override
    public ApiKeys newRequestContext$default$3() {
        return BaseAuthorizerTest.newRequestContext$default$3$(this);
    }

    @Override
    public boolean authorizeByResourceType(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return BaseAuthorizerTest.authorizeByResourceType$(this, authorizer, requestContext, operation, resourceType);
    }

    @Override
    public void addAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        BaseAuthorizerTest.addAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public boolean removeAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        return BaseAuthorizerTest.removeAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public String superUsers() {
        return this.superUsers;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @Override
    public RequestContext requestContext() {
        return this.requestContext;
    }

    @Override
    public String superUserName() {
        return this.superUserName;
    }

    @Override
    public KafkaConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    public ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    @Override
    public void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    public ResourcePattern resource() {
        return this.resource;
    }

    @Override
    public void resource_$eq(ResourcePattern x$1) {
        this.resource = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String x$1) {
        this.superUsers = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String x$1) {
        this.username = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal x$1) {
        this.principal = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext x$1) {
        this.requestContext = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String x$1) {
        this.superUserName = x$1;
    }

    private AccessControlEntry allowReadAcl() {
        return this.allowReadAcl;
    }

    private AccessControlEntry allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private AccessControlEntry denyReadAcl() {
        return this.denyReadAcl;
    }

    private ResourcePattern wildCardResource() {
        return this.wildCardResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    private KafkaPrincipal wildcardPrincipal() {
        return this.wildcardPrincipal;
    }

    private AclAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    private AclAuthorizer aclAuthorizer2() {
        return this.aclAuthorizer2;
    }

    @Override
    public Authorizer authorizer() {
        return this.aclAuthorizer();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.aclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.aclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
        this.aclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "AclAuthorizerTest", new ZKClientConfig(), "AclAuthorizerTest"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.aclAuthorizer().close();
        this.aclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test
    public void testAuthorizeThrowsOnNonLiteralResource() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "something", PatternType.PREFIXED)));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @Test
    public void testEmptyAclThrowsException() {
        ApiException e = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException), (String)new StringBuilder(21).append("Unexpected exception ").append((Object)e).toString());
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl7 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should have WRITE access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host2 as no allow acl is defined");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should not have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should have DESCRIBE access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host2");
        RequestContext user2Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        RequestContext user3Context = this.newRequestContext(user3, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.DESCRIBE, this.resource()), (String)"User2 should have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.DESCRIBE, this.resource()), (String)"User3 should have DESCRIBE access from host2");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.READ, this.resource()), (String)"User2 should have READ access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.WRITE, this.resource()), (String)"User3 should have WRITE access from host2");
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext host1Context = this.newRequestContext(customUserPrincipal, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(customUserPrincipal, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestContext session = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry allowAll = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(user.toString(), host.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAll, denyAcl}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()), (String)"deny should take precedence over allow.");
    }

    @Test
    public void testAllowAllAccess() {
        AccessControlEntry allowAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext context = this.newRequestContext(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), context, AclOperation.READ, this.resource()), (String)"allow all acl should allow access to all.");
    }

    @Test
    public void testSuperUserHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext session1 = this.newRequestContext(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        RequestContext session2 = this.newRequestContext(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session1, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session2, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext session = this.newRequestContext(new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()), (String)"superuser with custom principal always has access, no matter what acls.");
    }

    @Test
    public void testWildCardAcls() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should fail close.");
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        AccessControlEntry readAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{readAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host1");
        AccessControlEntry writeAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry denyWriteOnWildCardResourceAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWriteOnWildCardResourceAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host1");
    }

    @Test
    public void testNoAclFound() {
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should deny op.");
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer testAuthorizer = new AclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.");
        }
    }

    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl4 = new AccessControlEntry(user2.toString(), host2, AclOperation.WRITE, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry acl5 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        acls = this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$1(this, acl1, acl2, user1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"changes not propagated in timeout period");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$4(this, acl3, acl4, acl5, user2)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)"changes not propagated in timeout period");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        scala.collection.immutable.Map resourceToAcls = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL)), acls), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "test-ConsumerGroup", PatternType.LITERAL)), acls)}));
        resourceToAcls.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ResourcePattern key = (ResourcePattern)x0$1._1();
            Set value = (Set)x0$1._2();
            Set<AccessControlEntry> set = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)value, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), key);
            return set;
        });
        Set expectedAcls = ((IterableOnceOps)resourceToAcls.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), acls)).flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            ResourcePattern res = (ResourcePattern)x0$2._1();
            Set set = (Set)((Set)x0$2._2()).map((Function1 & Serializable)acl -> new AclBinding(res, acl));
            return set;
        })).toSet();
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$10(this, expectedAcls)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                Assertions.fail((String)"changes not propagated in timeout period.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl5}))), this.resource());
        acls = null;
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), AccessControlEntryFilter.ANY);
        Assertions.assertFalse((boolean)this.zkClient().resourceExists(this.resource()));
        acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), acls, this.resource());
        Assertions.assertFalse((boolean)this.zkClient().resourceExists(this.resource()));
    }

    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), "host3", AclOperation.READ, AclPermissionType.DENY);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assertions.assertEquals((Object)acls, this.getAcls(authorizer, this.resource()));
            Assertions.assertEquals((Object)acls1, this.getAcls(authorizer, resource1));
        }
    }

    @Test
    public void testChangeListenerTiming() {
        Semaphore configureSemaphore = new Semaphore(0);
        Semaphore listenerSemaphore = new Semaphore(0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AclAuthorizer aclAuthorizer3 = new AclAuthorizer(null, configureSemaphore, listenerSemaphore){
            private final Semaphore configureSemaphore$1;
            private final Semaphore listenerSemaphore$1;

            public void startZkChangeListeners() {
                this.configureSemaphore$1.release();
                this.listenerSemaphore$1.acquireUninterruptibly();
                super.startZkChangeListeners();
            }
            {
                this.configureSemaphore$1 = configureSemaphore$1;
                this.listenerSemaphore$1 = listenerSemaphore$1;
            }
        };
        try {
            Future<?> future = executor.submit(() -> aclAuthorizer3.configure(this.config().originals()));
            configureSemaphore.acquire();
            KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
            Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.DENY)}));
            this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
            listenerSemaphore.release();
            future.get(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)acls, this.getAcls(aclAuthorizer3, this.resource()));
        }
        finally {
            aclAuthorizer3.close();
            executor.shutdownNow();
        }
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource, AccessControlEntryFilter.ANY);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        AccessControlEntry acl3 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource);
        Assertions.assertTrue((boolean)this.removeAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource), (String)"The authorizer should see a value that needs to be deleted");
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.aclAuthorizer2(), commonResource, AccessControlEntryFilter.ANY);
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        IndexedSeq acls = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable)i -> AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            AccessControlEntry acl = (AccessControlEntry)x0$1._1();
            int aclId = x0$1._2$mcI$sp();
            Function0 & Serializable intersect = (Function0 & Serializable)() -> {
                if (aclId % 2 == 0) {
                    this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                } else {
                    this.addAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource);
                }
                if (aclId % 10 == 0) {
                    return BoxesRunTime.boxToBoolean((boolean)this.removeAcls((Authorizer)this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), commonResource));
                }
                return BoxedUnit.UNIT;
            };
            return intersect;
        });
        Set expectedAcls = ((IterableOnceOps)((IndexedSeqOps)acls.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(x0$2)))).map((Function1 & Serializable)x$1 -> (AccessControlEntry)x$1._1())).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer(), commonResource, AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer2(), commonResource, AccessControlEntryFilter.ANY);
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE}))));
        this.testImplicationsOfDeny(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE}))));
        this.testImplicationsOfAllow(AclOperation.READ, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.WRITE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.DELETE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.ALTER, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow(AclOperation.ALTER_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE_CONFIGS}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(AclOperation parentOp, Set<AclOperation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestContext hostContext = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry acl = new AccessControlEntry(user.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values()), (Function1 & Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op)))), (Function1 & Serializable)op -> {
            AclAuthorizerTest.$anonfun$testImplicationsOfAllow$2(this, hostContext, allowedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
    }

    private void testImplicationsOfDeny(AclOperation parentOp, Set<AclOperation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.DENY), new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW)}));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values()), (Function1 & Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op)))), (Function1 & Serializable)op -> {
            AclAuthorizerTest.$anonfun$testImplicationsOfDeny$2(this, host1Context, deniedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        AccessControlEntry acl = new AccessControlEntry(new KafkaPrincipal("User", this.username()).toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        IndexedSeq concurrentFuctions = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable)x$2 -> AclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)x$2)));
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer(), this.resource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.aclAuthorizer2(), this.resource(), AccessControlEntryFilter.ANY);
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer()));
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.resource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.resource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.aclAuthorizer(), this.resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.LITERAL));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(8).append("foo-").append(UUID.randomUUID()).append("-zzz").toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(5).append("fooo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("fo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fop-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fon-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fon-", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL)));
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "_", PatternType.PREFIXED));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_foo", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        AccessControlEntry aclOnSpecificPrincipal = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnSpecificPrincipal}))), this.resource());
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size(), (String)"acl on specific should not be returned for wildcard request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size(), (String)"acl on specific should be returned for different principal instance");
        this.removeAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry aclOnWildcardPrincipal = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnWildcardPrincipal}))), this.resource());
        Assertions.assertEquals((int)1, (int)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size(), (String)"acl on wildcard should be returned for wildcard request");
        Assertions.assertEquals((int)0, (int)this.getAcls(this.aclAuthorizer(), this.principal()).size(), (String)"acl on wildcard should not be returned for specific request");
    }

    @Test
    public void testAclsFilter() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(this.wildcardPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.aclAuthorizer().createAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4}))).asJava());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.aclAuthorizer().acls(AclBindingFilter.ANY)).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.aclAuthorizer().acls(new AclBindingFilter(resource1.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.aclAuthorizer().acls(new AclBindingFilter(prefixedResource.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet());
        AclBindingFilter matchingFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resource2.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.aclAuthorizer().acls(matchingFilter)).asScala().toSet());
        List filters = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{matchingFilter, acl1.toFilter(), new AclBindingFilter(resource2.toFilter(), AccessControlEntryFilter.ANY), new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "baz", PatternType.ANY), AccessControlEntryFilter.ANY)}));
        Buffer deleteResults = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.aclAuthorizer().deleteAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)filters).asJava())).asScala().map((Function1 & Serializable)x$3 -> (AclDeleteResult)x$3.toCompletableFuture().get());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), (Object)deleteResults.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$2(x$4))));
        filters.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(i)).aclBindingDeleteResults()).asScala().toSet().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$4(x$5)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(0)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$6 -> x$6.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(1)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$7 -> x$7.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(2)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$8 -> x$8.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(3)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$9 -> x$9.aclBinding())).toSet());
    }

    @Test
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ApiException e = (ApiException)Assertions.assertThrows(ApiException.class, () -> this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED)));
        Assertions.assertTrue((boolean)(e.getCause() instanceof UnsupportedVersionException), (String)new StringBuilder(21).append("Unexpected exception ").append((Object)e).toString());
    }

    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.empty());
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        this.addAcls((Authorizer)this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAuthorizerNoZkConfig() {
        Properties noTlsProps = Kafka$.MODULE$.getPropsFromArgs(new String[]{this.prepareDefaultConfig()});
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(noTlsProps), CollectionConverters$.MODULE$.MapHasAsScala((Map)noTlsProps).asScala());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)propName -> {
            AclAuthorizerTest.$anonfun$testAuthorizerNoZkConfig$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAuthorizerZkConfigFromKafkaConfigWithDefaults() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue)}));
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value);
            return object;
        });
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAuthorizerZkConfigFromKafkaConfig() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslProtocolProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCrlEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslOcspEnableProp()), (Object)"false")}));
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfig$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAuthorizerZkConfigFromPrefixOverrides() {
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        String prefixedValue = "prefixedValue";
        String prefix = "authorizer.";
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somewhere"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslClientEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslProtocolProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()), (Object)kafkaValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslCrlEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkSslOcspEnableProp()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).toString()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslProtocolProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()).toString()), (Object)prefixedValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()).toString()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCrlEnableProp()).toString()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslOcspEnableProp()).toString()), (Object)"true")}));
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        ZKClientConfig zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(zkClientConfig, prefixedValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateDeleteTiming() {
        ResourcePattern literalResource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        ResourcePattern wildcardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        AccessControlEntry ace = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        Semaphore updateSemaphore = new Semaphore(1);
        try (AclAuthorizer deleteAuthorizer = new AclAuthorizer(null, updateSemaphore){
            private final Semaphore updateSemaphore$1;

            public void processAclChangeNotification(ResourcePattern resource) {
                this.updateSemaphore$1.acquire();
                try {
                    super.processAclChangeNotification(resource);
                }
                finally {
                    this.updateSemaphore$1.release();
                }
            }
            {
                this.updateSemaphore$1 = updateSemaphore$1;
            }
        };){
            deleteAuthorizer.configure(this.config().originals());
            ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{literalResource, prefixedResource, wildcardResource}))).foreach((Function1 & Serializable)resource -> {
                AclAuthorizerTest.$anonfun$testCreateDeleteTiming$9(this, deleteAuthorizer, updateSemaphore, ace, resource);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testAuthorizeByResourceTypeNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer aclAuthorizer = new AclAuthorizer();){
            aclAuthorizer.configure(cfg.originals());
            Assertions.assertTrue((boolean)this.authorizeByResourceType((Authorizer)aclAuthorizer, this.requestContext(), AclOperation.READ, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have read access to at least one topic");
            Assertions.assertTrue((boolean)this.authorizeByResourceType((Authorizer)aclAuthorizer, this.requestContext(), AclOperation.WRITE, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have write access to at least one topic");
        }
    }

    private void givenAuthorizerWithProtocolVersion(Option<ApiVersion> protocolVersion) {
        this.aclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        protocolVersion.foreach((Function1 & Serializable)version -> props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), version.toString()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), true, (Option)None$.MODULE$));
        children.maybeThrow();
        Assertions.assertEquals((int)1, (int)children.children().size(), (String)"Expecting 1 change event");
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringBuilder(1).append(store.changeStore().aclChangePath()).append("/").append(children.children().head()).toString(), (Option)None$.MODULE$));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    private Set<AccessControlEntry> changeAclAndVerify(Set<AccessControlEntry> originalAcls, Set<AccessControlEntry> addedAcls, Set<AccessControlEntry> removedAcls, ResourcePattern resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.addAcls((Authorizer)this.aclAuthorizer(), addedAcls, resource);
            acls = (Set)originalAcls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.removeAcls((Authorizer)this.aclAuthorizer(), removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls, (Authorizer)this.aclAuthorizer(), resource, AccessControlEntryFilter.ANY);
        return acls;
    }

    private ResourcePattern changeAclAndVerify$default$4() {
        return this.resource();
    }

    private boolean authorize(AclAuthorizer authorizer, RequestContext requestContext, AclOperation operation, ResourcePattern resource) {
        Action action = new Action(operation, resource, 1, true, true);
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(authorizer.authorize((AuthorizableRequestContext)requestContext, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Action[]{action}))).asJava())).asScala().head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private Set<AccessControlEntry> getAcls(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        return (Set)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet().map((Function1 & Serializable)x$14 -> x$14.entry());
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer, KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(filter)).asScala().toSet();
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(AclBindingFilter.ANY)).asScala().toSet();
    }

    private boolean validOp(AclOperation op) {
        AclOperation aclOperation = op;
        AclOperation aclOperation2 = AclOperation.ANY;
        if (aclOperation == null ? aclOperation2 != null : !aclOperation.equals(aclOperation2)) {
            AclOperation aclOperation3 = op;
            AclOperation aclOperation4 = AclOperation.UNKNOWN;
            if (aclOperation3 == null ? aclOperation4 != null : !aclOperation3.equals(aclOperation4)) {
                return true;
            }
        }
        return false;
    }

    private String prepareDefaultConfig() {
        return this.prepareConfig(new String[]{"broker.id=1", "zookeeper.connect=somewhere"});
    }

    private String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])lines), (Function1 & Serializable)l -> {
                AclAuthorizerTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$1(AclAuthorizerTest $this, AccessControlEntry acl1$1, AccessControlEntry acl2$1, KafkaPrincipal user1$1) {
        Object object = ((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1$1, acl2$1}))).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user1$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$3() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$4(AclAuthorizerTest $this, AccessControlEntry acl3$1, AccessControlEntry acl4$1, AccessControlEntry acl5$1, KafkaPrincipal user2$1) {
        Object object = ((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3$1, acl4$1, acl5$1}))).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user2$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$6() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$10(AclAuthorizerTest $this, Set expectedAcls$1) {
        Set set = expectedAcls$1;
        Set<AclBinding> set2 = $this.getAcls($this.aclAuthorizer());
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$11() {
        return "changes not propagated in timeout period.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", Integer.toString(i));
        return new Tuple2((Object)new AccessControlEntry(useri.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$2._2$mcI$sp() % 10 != 0;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$2(AclAuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), hostContext$1, op, $this.clusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$1) : parentOp$1 != null) break block3;
            }
            Assertions.assertTrue((boolean)authorized, (String)new StringBuilder(26).append("ALLOW ").append(parentOp$1).append(" should imply ALLOW ").append(op).toString());
            return;
        }
        Assertions.assertFalse((boolean)authorized, (String)new StringBuilder(30).append("ALLOW ").append(parentOp$1).append(" should not imply ALLOW ").append(op).toString());
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$2(AclAuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), host1Context$1, op, $this.clusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$2) : parentOp$2 != null) break block3;
            }
            Assertions.assertFalse((boolean)authorized, (String)new StringBuilder(24).append("DENY ").append(parentOp$2).append(" should imply DENY ").append(op).toString());
            return;
        }
        Assertions.assertTrue((boolean)authorized, (String)new StringBuilder(28).append("DENY ").append(parentOp$2).append(" should not imply DENY ").append(op).toString());
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(AclAuthorizerTest $this, AccessControlEntry acl$2, int x$2) {
        return (JFunction0.mcZ.sp & Serializable)() -> {
            $this.addAcls((Authorizer)$this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
            return $this.removeAcls((Authorizer)$this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2}))), $this.resource());
        };
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$2(AclDeleteResult x$4) {
        return x$4.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$4(AclDeleteResult.AclBindingDeleteResult x$5) {
        return x$5.exception().isPresent();
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerNoZkConfig$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(ZKClientConfig zkClientConfig$2, String kafkaValue$1, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        if (!(string5 != null ? !string5.equals(prop) : prop != null)) {
            Assertions.assertEquals((Object)"TLSv1.2", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)kafkaValue$1, (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$2, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfig$2(ZKClientConfig zkClientConfig$3, String kafkaValue$2, String prop) {
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$3, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string3 != null ? !string3.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string4 != null ? !string4.equals(prop) : prop != null);
        }
        if (bl) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$3, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)kafkaValue$2, (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$3, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(ZKClientConfig zkClientConfig$4, String prefixedValue$1, String prop) {
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(prop) : prop != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(prop) : prop != null);
            }
        }
        if (bl) {
            Assertions.assertEquals((Object)"true", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$4, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        String string4 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string4 != null ? !string4.equals(prop) : prop != null)) {
            Assertions.assertEquals((Object)"false", (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$4, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
            return;
        }
        Assertions.assertEquals((Object)prefixedValue$1, (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(zkClientConfig$4, prop).getOrElse((Function0 & Serializable)() -> "<None>"));
    }

    private final AclBinding createAcl$1(AclAuthorizer createAuthorizer, ResourcePattern resource, AccessControlEntry ace$1) {
        AclBinding acl = new AclBinding(resource, ace$1);
        CollectionConverters$.MODULE$.ListHasAsScala(createAuthorizer.createAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(acl))).asScala().foreach((Function1 & Serializable)x$10 -> (AclCreateResult)x$10.toCompletableFuture().get(15L, TimeUnit.SECONDS));
        return acl;
    }

    private final List deleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType) {
        AclBindingFilter filter = new AclBindingFilter(new ResourcePatternFilter(resource.resourceType(), resource.name(), deletePatternType), AccessControlEntryFilter.ANY);
        return ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(deleteAuthorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), Collections.singletonList(filter))).asScala().map((Function1 & Serializable)x$11 -> (AclDeleteResult)x$11.toCompletableFuture().get(15L, TimeUnit.SECONDS))).flatMap((Function1 & Serializable)x$12 -> CollectionConverters$.MODULE$.CollectionHasAsScala(x$12.aclBindingDeleteResults()).asScala())).map((Function1 & Serializable)x$13 -> x$13.aclBinding())).toList();
    }

    private static final List listAcls$1(AclAuthorizer authorizer) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(AclBindingFilter.ANY)).asScala().toList();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$5(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$6() {
        return "ACL not propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateDeleteTiming$7(AclAuthorizer deleteAuthorizer$1) {
        return AclAuthorizerTest.listAcls$1(deleteAuthorizer$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateDeleteTiming$8() {
        return "ACL delete not propagated";
    }

    private final void verifyCreateDeleteAcl$1(AclAuthorizer deleteAuthorizer, ResourcePattern resource, PatternType deletePatternType, Semaphore updateSemaphore$1, AccessControlEntry ace$1) {
        updateSemaphore$1.acquire();
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), (Object)AclAuthorizerTest.listAcls$1(deleteAuthorizer));
        AclBinding acl = this.createAcl$1(this.aclAuthorizer(), resource, ace$1);
        List deleted = this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType);
        PatternType patternType = deletePatternType;
        PatternType patternType2 = PatternType.MATCH;
        if (patternType == null ? patternType2 != null : !patternType.equals(patternType2)) {
            Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl})), (Object)deleted);
        } else {
            Assertions.assertEquals((Object)package$.MODULE$.List().empty(), (Object)deleted);
        }
        updateSemaphore$1.release();
        PatternType patternType3 = deletePatternType;
        PatternType patternType4 = PatternType.MATCH;
        if (!(patternType3 != null ? !patternType3.equals(patternType4) : patternType4 != null)) {
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$5(deleteAuthorizer)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"ACL not propagated");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl})), (Object)this.deleteAcl$1(deleteAuthorizer, resource, deletePatternType));
        }
        long l = 15000L;
        long l3 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testCreateDeleteTiming$7(deleteAuthorizer)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"ACL delete not propagated");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l3));
        }
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTiming$9(AclAuthorizerTest $this, AclAuthorizer deleteAuthorizer$2, Semaphore updateSemaphore$1, AccessControlEntry ace$1, ResourcePattern resource) {
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, resource.patternType(), updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.ANY, updateSemaphore$1, ace$1);
        $this.verifyCreateDeleteAcl$1(deleteAuthorizer$2, resource, PatternType.MATCH, updateSemaphore$1, ace$1);
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public AclAuthorizerTest() {
        BaseAuthorizerTest.$init$(this);
        this.allowReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.allowWriteAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.denyReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.wildCardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        this.prefixedResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.PREFIXED);
        this.clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        this.aclAuthorizer = new AclAuthorizer();
        this.aclAuthorizer2 = new AclAuthorizer();
        Statics.releaseFence();
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$CustomPrincipal$$$outer() {
            return AclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (AclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

