/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchManager;
import kafka.server.FetchSession;
import kafka.server.FetchSessionCache;
import kafka.server.FetchSessionTest$;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\t\u001dd\u0001\u0002\u0014(\u00011BQa\r\u0001\u0005\u0002QBQa\u000e\u0001\u0005\u0002aBQ!\u0013\u0001\u0005\u0002)CQ\u0001\u0017\u0001\u0005\neCQa\u0019\u0001\u0005\u0002aBQ!\u001a\u0001\u0005\u0002aBqa\u001a\u0001C\u0002\u0013%\u0001\u000e\u0003\u0004{\u0001\u0001\u0006I!\u001b\u0005\u0006w\u0002!\t\u0001 \u0005\n\u0003\u000f\u0002\u0011\u0013!C\u0001\u0003\u0013Bq!a\u0018\u0001\t\u0003\t\t\u0007\u0003\u0004\u0002l\u0001!\t\u0001\u000f\u0005\u0007\u0003_\u0002A\u0011\u0001\u001d\t\r\u0005M\u0004\u0001\"\u00019\u0011\u001d\t9\b\u0001C\u0001\u0003sBa!a)\u0001\t\u0003A\u0004BBAT\u0001\u0011\u0005\u0001\b\u0003\u0004\u0002,\u0002!\t\u0001\u000f\u0005\u0007\u0003_\u0003A\u0011\u0001\u001d\t\r\u0005M\u0006\u0001\"\u00019\u0011\u001d\t9\f\u0001C\u0005\u0003sCq!!4\u0001\t\u0013\ty\r\u0003\u0004\u0002V\u0002!\t\u0001\u000f\u0005\b\u00033\u0004A\u0011AAn\u0011\u0019\t9\u0010\u0001C\u0001q!1\u00111 \u0001\u0005\u0002aBa!a@\u0001\t\u0003A\u0004B\u0002B\u0002\u0001\u0011\u0005\u0001\b\u0003\u0004\u0003\b\u0001!\t\u0001\u000f\u0005\u0007\u0005\u0017\u0001A\u0011\u0001\u001d\t\r\t=\u0001\u0001\"\u00019\u0011\u0019\u0011\u0019\u0002\u0001C\u0001q!9!q\u0003\u0001\u0005\n\teqa\u0002B&O!\u0005!Q\n\u0004\u0007M\u001dB\tAa\u0014\t\rM\u001aC\u0011\u0001B)\u0011\u001d\t\u0019p\tC\u0001\u0005'\u0012\u0001CR3uG\"\u001cVm]:j_:$Vm\u001d;\u000b\u0005!J\u0013AB:feZ,'OC\u0001+\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\u0007\u0005\u00027\u00015\tq%\u0001\tuKN$h*Z<TKN\u001c\u0018n\u001c8JIR\t\u0011\b\u0005\u0002/u%\u00111h\f\u0002\u0005+:LG\u000f\u000b\u0002\u0003{A\u0011ahR\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0004CBL'B\u0001\"D\u0003\u001dQW\u000f]5uKJT!\u0001R#\u0002\u000b),h.\u001b;\u000b\u0003\u0019\u000b1a\u001c:h\u0013\tAuH\u0001\u0003UKN$\u0018aE1tg\u0016\u0014HoQ1dQ\u0016\u001cuN\u001c;bS:\u001cHcA\u001dL!\")Aj\u0001a\u0001\u001b\u0006)1-Y2iKB\u0011aGT\u0005\u0003\u001f\u001e\u0012\u0011CR3uG\"\u001cVm]:j_:\u001c\u0015m\u00195f\u0011\u0015\t6\u00011\u0001S\u0003)\u0019Xm]:j_:LEm\u001d\t\u0004]M+\u0016B\u0001+0\u0005)a$/\u001a9fCR,GM\u0010\t\u0003]YK!aV\u0018\u0003\u0007%sG/A\u0006ek6l\u0017p\u0011:fCR,GC\u0001.b!\tYfL\u0004\u000279&\u0011QlJ\u0001\r\r\u0016$8\r[*fgNLwN\\\u0005\u0003?\u0002\u0014\u0011bQ!D\u0011\u0016{V*\u0011)\u000b\u0005u;\u0003\"\u00022\u0005\u0001\u0004)\u0016\u0001B:ju\u0016\f\u0001\u0003^3tiN+7o]5p]\u000e\u000b7\r[3)\u0005\u0015i\u0014\u0001\u0007;fgR\u0014Vm]5{K\u000e\u000b7\r[3e'\u0016\u001c8/[8og\"\u0012a!P\u0001\u0010\u000b6\u0003F+W0Q\u0003J#v\fT%T)V\t\u0011\u000eE\u0002k_Fl\u0011a\u001b\u0006\u0003Y6\fA!\u001e;jY*\ta.\u0001\u0003kCZ\f\u0017B\u00019l\u0005\u0011a\u0015n\u001d;\u0011\u0005IDX\"A:\u000b\u0005Q,\u0018AB2p[6|gN\u0003\u0002+m*\u0011q/R\u0001\u0007CB\f7\r[3\n\u0005e\u001c(\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003A)U\n\u0015+Z?B\u000b%\u000bV0M\u0013N#\u0006%A\u0007de\u0016\fG/\u001a*fcV,7\u000f\u001e\u000b\f{\u0006\u001d\u0011\u0011CA\u0018\u0003g\ti\u0004E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003\u0019\u0018\u0001\u0003:fcV,7\u000f^:\n\u0007\u0005\u0015qP\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH\u000fC\u0004\u0002\n%\u0001\r!a\u0003\u0002\u00115,G/\u00193bi\u0006\u00042A`A\u0007\u0013\r\tya \u0002\u000e\r\u0016$8\r['fi\u0006$\u0017\r^1\t\u000f\u0005M\u0011\u00021\u0001\u0002\u0016\u0005Ia-\u001a;dQ\u0012\u000bG/\u0019\t\bU\u0006]\u00111DA\u0011\u0013\r\tIb\u001b\u0002\u0004\u001b\u0006\u0004\bc\u0001:\u0002\u001e%\u0019\u0011qD:\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B!\u00111EA\u0015\u001d\rq\u0018QE\u0005\u0004\u0003Oy\u0018\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0002BA\u0016\u0003[\u0011Q\u0002U1si&$\u0018n\u001c8ECR\f'bAA\u0014\u007f\"1\u0011\u0011G\u0005A\u0002%\f\u0001\u0002^8G_J<W\r\u001e\u0005\b\u0003kI\u0001\u0019AA\u001c\u00039I7O\u0012:p[\u001a{G\u000e\\8xKJ\u00042ALA\u001d\u0013\r\tYd\f\u0002\b\u0005>|G.Z1o\u0011%\ty$\u0003I\u0001\u0002\u0004\t\t%A\u0004wKJ\u001c\u0018n\u001c8\u0011\u00079\n\u0019%C\u0002\u0002F=\u0012Qa\u00155peR\fqc\u0019:fCR,'+Z9vKN$H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005-#\u0006BA!\u0003\u001bZ#!a\u0014\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033z\u0013AC1o]>$\u0018\r^5p]&!\u0011QLA*\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001dGJ,\u0017\r^3SKF,Xm\u001d;XSRDw.\u001e;U_BL7-\u00133t)%i\u00181MA3\u0003O\nI\u0007C\u0004\u0002\n-\u0001\r!a\u0003\t\u000f\u0005M1\u00021\u0001\u0002\u0016!1\u0011\u0011G\u0006A\u0002%Dq!!\u000e\f\u0001\u0004\t9$A\u000buKN$8)Y2iK\u0012dU-\u00193fe\u0016\u0003xn\u00195)\u00051i\u0014\u0001\u0006;fgRd\u0015m\u001d;GKR\u001c\u0007.\u001a3Fa>\u001c\u0007\u000e\u000b\u0002\u000e{\u0005\tB/Z:u\r\u0016$8\r\u001b*fcV,7\u000f^:)\u00059i\u0014a\u0007;fgRLen\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nU3tg&|g\u000eF\u0002:\u0003wBq!! \u0010\u0001\u0004\t9$\u0001\u0007vg\u0016\u001cHk\u001c9jG&#7\u000fK\u0004\u0010\u0003\u0003\u000b\t*a%\u0011\t\u0005\r\u0015QR\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006A\u0001O]8wS\u0012,'OC\u0002\u0002\f\u0006\u000ba\u0001]1sC6\u001c\u0018\u0002BAH\u0003\u000b\u00131BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0003\u0002\u0016\u0006]\u0015$A\u0001\u001a\u0003\u0001A3aDAN!\u0011\ti*a(\u000e\u0005\u0005%\u0015\u0002BAQ\u0003\u0013\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u00039\"Xm\u001d;GKR\u001c\u0007nU3tg&|gnV5uQVs7N\\8x]&#w\n\u001c3SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8)\u0005Ai\u0014!\b;fgR4U\r^2i'\u0016\u001c8/[8o/&$\b.\u00168l]><h.\u00133)\u0005Ei\u0014A\u000f;fgRLen\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nU3tg&|gnV5uQ&#7o\u00165f]N+7o]5p]\u0012{Wm\u001d(piV\u001bX-\u00133tQ\t\u0011R(A\u001cuKN$\u0018J\\2sK6,g\u000e^1m\r\u0016$8\r[*fgNLwN\\,ji\"|W\u000f^%eg^CWM\\*fgNLwN\\+tKNLEm\u001d\u0015\u0003'u\n\u0001\u0006^3ti\u001a+Go\u00195TKN\u001c\u0018n\u001c8Va\u0012\fG/\u001a+pa&\u001c\u0017\nZ:Ce>\\WM]*jI\u0016D#\u0001F\u001f\u0002\u001f9|WI\u001d:peJ+7\u000f]8og\u0016,\"!a/\u0011\t\u0005u\u0016\u0011\u001a\b\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*\u0019\u00111Y:\u0002\u000f5,7o]1hK&!\u0011qYAa\u0003E1U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003W\tYM\u0003\u0003\u0002H\u0006\u0005\u0017!D3se>\u0014(+Z:q_:\u001cX\r\u0006\u0003\u0002<\u0006E\u0007bBAj-\u0001\u0007\u0011\u0011I\u0001\nKJ\u0014xN]\"pI\u0016\fA\u0004^3tiJ+7o\u001c7wKVs7N\\8x]B\u000b'\u000f^5uS>t7\u000f\u000b\u0002\u0018{\u00051B/Z:u)>4uN]4fiB\u000b'\u000f^5uS>t7\u000fF\u0003:\u0003;\f\t\u000fC\u0004\u0002`b\u0001\r!a\u000e\u0002#\u0019|wn\u0015;beR\u001c(+Z:pYZ,G\rC\u0004\u0002db\u0001\r!a\u000e\u0002\u001f\u0019|w.\u00128egJ+7o\u001c7wK\u0012Ds\u0001GAt\u0003[\fy\u000f\u0005\u0003\u0002\u0004\u0006%\u0018\u0002BAv\u0003\u000b\u0013A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d#!!=\"\u0005\u0005M\u0018aE5e+N\fw-Z\"p[\nLg.\u0019;j_:\u001c\bf\u0001\r\u0002\u001c\u0006\tC/Z:u+B$\u0017\r^3B]\u0012<UM\\3sCR,'+Z:q_:\u001cX\rR1uC\"\u0012\u0011$P\u0001\u001bi\u0016\u001cHOR3uG\"\u001cVm]:j_:,\u0005\u0010]5sCRLwN\u001c\u0015\u00035u\nQ\u0004^3tiB\u0013\u0018N^5mK\u001e,GmU3tg&|g\u000eS1oI2Lgn\u001a\u0015\u00037u\n\u0001\u0004^3tij+'o\\*ju\u00164U\r^2i'\u0016\u001c8/[8oQ\taR(\u0001\nuKN$H)\u001b<fe\u001eLgnZ#q_\u000eD\u0007FA\u000f>\u0003)\"Xm\u001d;EKB\u0014\u0018n\u001c:ji&TXm\u001d)beRLG/[8og^KG\u000f\u001b*fG>\u0014Hm](oYfD#AH\u001f\u0002IQ,7\u000f^\"bG\",G\rU1si&$\u0018n\u001c8FcV\fGn]!oI\"\u000b7\u000f[\"pI\u0016D#aH\u001f\u00027Q,7\u000f^'bs\n,'+Z:pYZ,WK\\6o_^tg*Y7fQ\t\u0001S(A\u000bbgN,'\u000f\u001e)beRLG/[8og>\u0013H-\u001a:\u0015\u000be\u0012YB!\n\t\u000f\tu\u0011\u00051\u0001\u0003 \u000591m\u001c8uKb$\bc\u0001\u001c\u0003\"%\u0019!1E\u0014\u0003\u0019\u0019+Go\u00195D_:$X\r\u001f;\t\u000f\t\u001d\u0012\u00051\u0001\u0003*\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000b\t-\"1H9\u000f\t\t5\"q\u0007\b\u0005\u0005_\u0011)$\u0004\u0002\u00032)\u0019!1G\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0014b\u0001B\u001d_\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u001f\u0005\u007f\u00111aU3r\u0015\r\u0011Id\f\u0015\b\u0001\t\r\u0013Q\u001eB%!\rq$QI\u0005\u0004\u0005\u000fz$a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002q\u0006\u0001b)\u001a;dQN+7o]5p]R+7\u000f\u001e\t\u0003m\r\u001a\"aI\u0017\u0015\u0005\t5SC\u0001B+!\u0019\u00119F!\u0018\u0003b5\u0011!\u0011\f\u0006\u0004\u00057Z\u0017AB:ue\u0016\fW.\u0003\u0003\u0003`\te#AB*ue\u0016\fW\u000e\u0005\u0003\u0002\u0004\n\r\u0014\u0002\u0002B3\u0003\u000b\u0013\u0011\"\u0011:hk6,g\u000e^:")
public class FetchSessionTest {
    private final List<TopicIdPartition> EMPTY_PART_LIST = Collections.unmodifiableList(new ArrayList());

    public static Stream<Arguments> idUsageCombinations() {
        return FetchSessionTest$.MODULE$.idUsageCombinations();
    }

    @Test
    public void testNewSessionId() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> Assertions.assertTrue((cache.newSessionId() > 0 ? 1 : 0) != 0));
    }

    public void assertCacheContains(FetchSessionCache cache, scala.collection.immutable.Seq<Object> sessionIds) {
        IntRef i = IntRef.create((int)0);
        sessionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)sessionId -> {
            ++i$1.elem;
            Assertions.assertTrue((boolean)cache.get(sessionId).isDefined(), (String)new StringBuilder(26).append("Missing session ").append(i$1.elem).append(" out of ").append(sessionIds.size()).append("(").append(sessionId).append(")").toString());
        });
        Assertions.assertEquals((int)sessionIds.size(), (int)cache.size());
    }

    /*
     * WARNING - void declaration
     */
    private ImplicitLinkedHashCollection<CachedPartition> dummyCreate(int size) {
        void var2_2;
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection(size);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> cacheMap.add((ImplicitLinkedHashCollection.Element)new CachedPartition("test", Uuid.randomUuid(), i)));
        return var2_2;
    }

    @Test
    public void testSessionCache() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        Assertions.assertEquals((int)0, (int)cache.size());
        int id1 = cache.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable)() -> this.dummyCreate(10));
        int id2 = cache.maybeCreateSession(10L, false, 20, true, (Function0 & Serializable)() -> this.dummyCreate(20));
        int id3 = cache.maybeCreateSession(20L, false, 30, true, (Function0 & Serializable)() -> this.dummyCreate(30));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(30L, false, 40, true, (Function0 & Serializable)() -> this.dummyCreate(40)));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(40L, false, 5, true, (Function0 & Serializable)() -> this.dummyCreate(5)));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id2, id3}));
        cache.touch((FetchSession)cache.get(id1).get(), 200L);
        int id4 = cache.maybeCreateSession(210L, false, 11, true, (Function0 & Serializable)() -> this.dummyCreate(11));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 400L);
        cache.touch((FetchSession)cache.get(id3).get(), 390L);
        cache.touch((FetchSession)cache.get(id4).get(), 400L);
        int id5 = cache.maybeCreateSession(410L, false, 50, true, (Function0 & Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id3, id4, id5}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(410L, false, 5, true, (Function0 & Serializable)() -> this.dummyCreate(5)));
        int id6 = cache.maybeCreateSession(410L, true, 5, true, (Function0 & Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
    }

    @Test
    public void testResizeCachedSessions() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assertions.assertEquals((long)0L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)0, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, true, (Function0 & Serializable)() -> this.dummyCreate(2));
        Assertions.assertTrue((id1 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assertions.assertEquals((int)2, (int)session1.size());
        Assertions.assertEquals((long)2L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, true, (Function0 & Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        Assertions.assertTrue((id2 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assertions.assertEquals((long)6L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(200L, false, 5, true, (Function0 & Serializable)() -> this.dummyCreate(5));
        Assertions.assertTrue((id3 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assertions.assertEquals((long)9L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        cache.remove(id3);
        this.assertCacheContains(cache, (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id2}));
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)4L, (long)cache.totalPartitions());
        java.util.Iterator iter = session2.partitionMap().iterator();
        iter.next();
        iter.remove();
        Assertions.assertEquals((int)3, (int)session2.size());
        Assertions.assertEquals((int)4, (int)session2.cachedSize());
        cache.touch(session2, session2.lastUsedMs());
        Assertions.assertEquals((long)3L, (long)cache.totalPartitions());
    }

    private List<TopicIdPartition> EMPTY_PART_LIST() {
        return this.EMPTY_PART_LIST;
    }

    public FetchRequest createRequest(FetchMetadata metadata, java.util.Map<TopicPartition, FetchRequest.PartitionData> fetchData, List<TopicIdPartition> toForget, boolean isFromFollower, short version) {
        return (FetchRequest)new FetchRequest.Builder(version, version, isFromFollower ? 1 : -1, 0, 0, fetchData).metadata(metadata).removed(toForget).build();
    }

    public short createRequest$default$5() {
        return ApiKeys.FETCH.latestVersion();
    }

    public FetchRequest createRequestWithoutTopicIds(FetchMetadata metadata, java.util.Map<TopicPartition, FetchRequest.PartitionData> fetchData, List<TopicIdPartition> toForget, boolean isFromFollower) {
        return (FetchRequest)new FetchRequest.Builder(12, 12, isFromFollower ? 1 : -1, 0, 0, fetchData).metadata(metadata).removed(toForget).build();
    }

    @Test
    public void testCachedLeaderEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())}))).asJava();
        TopicIdPartition tp0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$2 -> x$2.swap())).asJava();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        requestData1.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.empty()));
        requestData1.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1))));
        requestData1.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(2))));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, requestData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        scala.collection.immutable.Map epochs1 = FetchSessionTest.cachedLeaderEpochs$1(context1);
        Assertions.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)tp0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs1.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs1.apply((Object)tp2));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        response.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(tp0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequest(new FetchMetadata(sessionId, 1), requestData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        scala.collection.immutable.Map epochs2 = FetchSessionTest.cachedLeaderEpochs$1(context2);
        Assertions.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)tp0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs2.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs2.apply((Object)tp2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        requestData3.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(6))));
        requestData3.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.empty()));
        requestData3.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(3))));
        FetchRequest request3 = this.createRequest(new FetchMetadata(sessionId, 2), requestData3, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        scala.collection.immutable.Map epochs3 = FetchSessionTest.cachedLeaderEpochs$1(fetchManager.newContext(request3.version(), request3.metadata(), request3.isFromFollower(), request3.fetchData(topicNames), request3.forgottenTopics(topicNames), topicNames));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)6)), (Object)epochs3.apply((Object)tp0));
        Assertions.assertEquals(Optional.empty(), (Object)epochs3.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)3)), (Object)epochs3.apply((Object)tp2));
    }

    @Test
    public void testLastFetchedEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())}))).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$3 -> x$3.swap())).asJava();
        TopicIdPartition tp0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        requestData1.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.empty(), Optional.empty()));
        requestData1.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()));
        requestData1.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(2)), Optional.of(Predef$.MODULE$.int2Integer(1))));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, requestData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context1));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context1));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        response.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(tp0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequest(new FetchMetadata(sessionId, 1), requestData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        requestData3.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(6)), Optional.of(Predef$.MODULE$.int2Integer(5))));
        requestData3.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.empty(), Optional.empty()));
        requestData3.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(3)), Optional.of(Predef$.MODULE$.int2Integer(3))));
        FetchRequest request3 = this.createRequest(new FetchMetadata(sessionId, 2), requestData3, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context3 = fetchManager.newContext(request3.version(), request3.metadata(), request3.isFromFollower(), request3.fetchData(topicNames), request3.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.of(BoxesRunTime.boxToInteger((int)6))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.of(BoxesRunTime.boxToInteger((int)5))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
    }

    @Test
    public void testFetchRequests() {
        FetchResponse resp8;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicNames).asScala().map((Function1 & Serializable)x$4 -> x$4.swap())).asJava();
        TopicIdPartition tp0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 0));
        TopicIdPartition tp3 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        FetchRequest request = this.createRequest(FetchMetadata.LEGACY, new HashMap<TopicPartition, FetchRequest.PartitionData>(), this.EMPTY_PART_LIST(), true, this.createRequest$default$5());
        FetchContext context = fetchManager.newContext(request.version(), request.metadata(), request.isFromFollower(), request.fetchData(topicNames), request.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionlessFetchContext.class, context.getClass());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.empty()));
        reqData2.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.empty()));
        FetchRequest request2 = this.createRequest(FetchMetadata.INITIAL, reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context2.getClass());
        java.util.Iterator<Map.Entry<TopicPartition, FetchRequest.PartitionData>> reqData2Iter = reqData2.entrySet().iterator();
        context2.foreachPartition((Function2 & Serializable)(topicIdPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$2(reqData2Iter, topicIds, topicIdPart, data);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(tp0).get()));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(tp1).get()));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData2.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(respData2).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition tp = (TopicIdPartition)x0$1._1();
            FetchResponseData.PartitionData data = (FetchResponseData.PartitionData)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)tp.topicPartition(), (Object)data);
            return tuple2;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava(), (Object)resp2.responseData(topicNames, request2.version()));
        FetchRequest request3 = this.createRequest(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context3 = fetchManager.newContext(request3.version(), request3.metadata(), request3.isFromFollower(), request3.fetchData(topicNames), request3.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context3.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context3.updateAndGenerateResponseData(respData2).error());
        FetchRequest request4 = this.createRequest(new FetchMetadata(resp2.sessionId() + 1, 1), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context4 = fetchManager.newContext(request4.version(), request4.metadata(), request4.isFromFollower(), request4.fetchData(topicNames), request4.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_ID_NOT_FOUND, (Object)context4.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData5 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request5 = this.createRequest(new FetchMetadata(resp2.sessionId(), 1), reqData5, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context5 = fetchManager.newContext(request5.version(), request5.metadata(), request5.isFromFollower(), request5.fetchData(topicNames), request5.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        java.util.Iterator<Map.Entry<TopicPartition, FetchRequest.PartitionData>> reqData5Iter = reqData2.entrySet().iterator();
        context5.foreachPartition((Function2 & Serializable)(topicIdPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$4(reqData5Iter, topicIds, topicIdPart, data);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(tp1).get()));
        FetchResponse resp5 = context5.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp5.sessionId());
        Assertions.assertEquals((int)0, (int)resp5.responseData(topicNames, request5.version()).size());
        FetchRequest request6 = this.createRequest(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context6 = fetchManager.newContext(request6.version(), request6.metadata(), request6.isFromFollower(), request6.fetchData(topicNames), request6.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context6.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context6.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData7 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request7 = this.createRequest(new FetchMetadata(resp2.sessionId(), 2), reqData7, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchResponse resp7 = fetchManager.newContext(request7.version(), request7.metadata(), request7.isFromFollower(), request7.fetchData(topicNames), request7.forgottenTopics(topicNames), topicNames).getThrottledResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp7.sessionId());
        Assertions.assertEquals((int)100, (int)resp7.throttleTimeMs());
        int prevSessionId = resp5.sessionId();
        do {
            LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData8 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
            reqData8.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 0L, 0L, 100, Optional.empty()));
            reqData8.put(tp3.topicPartition(), new FetchRequest.PartitionData(tp3.topicId(), 10L, 0L, 100, Optional.empty()));
            FetchRequest request8 = this.createRequest(new FetchMetadata(prevSessionId, -1), reqData8, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
            FetchContext context8 = fetchManager.newContext(request8.version(), request8.metadata(), request8.isFromFollower(), request8.fetchData(topicNames), request8.forgottenTopics(topicNames), topicNames);
            Assertions.assertEquals(SessionlessFetchContext.class, context8.getClass());
            Assertions.assertEquals((int)0, (int)cache.size());
            LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData8 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
            respData8.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            respData8.put(tp3, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            resp8 = context8.updateAndGenerateResponseData(respData8);
            Assertions.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        } while (resp8.sessionId() == prevSessionId);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testIncrementalFetchSession(boolean usesTopicIds) {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = usesTopicIds ? CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava() : CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicNames).asScala().map((Function1 & Serializable)x$5 -> x$5.swap())).asJava();
        short version = usesTopicIds ? ApiKeys.FETCH.latestVersion() : (short)12;
        Uuid fooId = topicIds.getOrDefault("foo", Uuid.ZERO_UUID);
        Uuid barId = topicIds.getOrDefault("bar", Uuid.ZERO_UUID);
        TopicIdPartition tp0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition(barId, new TopicPartition("bar", 0));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(tp0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        reqData1.put(tp1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false, version);
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, request1.version()).size());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(tp2.topicPartition(), new FetchRequest.PartitionData(barId, 15L, 0L, 0, Optional.empty()));
        ArrayList<TopicIdPartition> removed2 = new ArrayList<TopicIdPartition>();
        removed2.add(tp0);
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false, version);
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        Iterator reqData2Iter = ((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp1, tp2}))).iterator();
        context2.foreachPartition((Function2 & Serializable)(topicIdPart, x$6) -> {
            FetchSessionTest.$anonfun$testIncrementalFetchSession$2(reqData2Iter, topicIdPart, x$6);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(tp0));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(tp1).get()));
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(tp2).get()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicIdPartition(barId, new TopicPartition("bar", 2))));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData2.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)1, (int)resp2.responseData(topicNames, request2.version()).size());
        Assertions.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchSessionWithUnknownIdOldRequestVersion() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicNames).asScala().map((Function1 & Serializable)x$7 -> x$7.swap())).asJava();
        TopicIdPartition tp0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.empty()));
        reqData1.put(tp1.topicPartition(), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 10L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequestWithoutTopicIds(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        java.util.Map topicNamesOnlyBar = Collections.singletonMap(topicIds.get("bar"), "bar");
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNamesOnlyBar), request1.forgottenTopics(topicNamesOnlyBar), topicNamesOnlyBar);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, request1.version()).size());
        resp1.responseData(topicNames, request1.version()).forEach((x$8, resp) -> Assertions.assertEquals((short)Errors.NONE.code(), (short)resp.errorCode()));
    }

    @Test
    public void testFetchSessionWithUnknownId() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        Uuid barId = Uuid.randomUuid();
        Uuid zarId = Uuid.randomUuid();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)barId), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zarId), (Object)"zar")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        TopicIdPartition zar0 = new TopicIdPartition(zarId, new TopicPartition("zar", 0));
        TopicIdPartition emptyFoo0 = new TopicIdPartition(fooId, new TopicPartition(null, 0));
        TopicIdPartition emptyFoo1 = new TopicIdPartition(fooId, new TopicPartition(null, 1));
        TopicIdPartition emptyZar0 = new TopicIdPartition(zarId, new TopicPartition(null, 0));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(foo0.topicPartition(), new FetchRequest.PartitionData(foo0.topicId(), 0L, 0L, 100, Optional.empty()));
        reqData1.put(foo1.topicPartition(), new FetchRequest.PartitionData(foo1.topicId(), 10L, 0L, 100, Optional.empty()));
        reqData1.put(zar0.topicPartition(), new FetchRequest.PartitionData(zar0.topicId(), 10L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        java.util.Map<Uuid, String> topicNamesOnlyBar = Collections.singletonMap(barId, "bar");
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNamesOnlyBar), request1.forgottenTopics(topicNamesOnlyBar), topicNamesOnlyBar);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{emptyFoo0, emptyFoo1, emptyZar0}))));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(emptyFoo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        respData1.put(emptyFoo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        respData1.put(emptyZar0, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)resp1.responseData(topicNames, request1.version())).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            return tuple2;
        }));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        java.util.Map topicNamesNoZar = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)barId), (Object)"bar")}))).asJava();
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNamesNoZar), request2.forgottenTopics(topicNamesNoZar), topicNamesNoZar);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo0, foo1, emptyZar0}))));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData2.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData2.put(emptyZar0, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)resp2.responseData(topicNames, request2.version()).size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)resp2.responseData(topicNames, request2.version())).asScala().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            return tuple2;
        }));
    }

    @Test
    public void testIncrementalFetchSessionWithIdsWhenSessionDoesNotUseIds() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        TopicIdPartition foo0 = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 0));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(foo0.topicPartition(), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequestWithoutTopicIds(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Uuid fooId = Uuid.randomUuid();
        topicNames.put(fooId, "foo");
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_TOPIC_ID_ERROR, (Object)context2.updateAndGenerateResponseData(respData2).error());
    }

    @Test
    public void testIncrementalFetchSessionWithoutIdsWhenSessionUsesIds() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        topicNames.put(fooId, "foo");
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        topicNames.remove(fooId);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequestWithoutTopicIds(new FetchMetadata(resp1.sessionId(), 1), reqData2, this.EMPTY_PART_LIST(), false);
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_TOPIC_ID_ERROR, (Object)context2.updateAndGenerateResponseData(respData2).error());
    }

    @Test
    public void testFetchSessionUpdateTopicIdsBrokerSide() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicNames).asScala().map((Function1 & Serializable)x$9 -> x$9.swap())).asJava();
        TopicIdPartition tp0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(tp0.topicPartition(), new FetchRequest.PartitionData(tp0.topicId(), 0L, 0L, 100, Optional.empty()));
        reqData1.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 10L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData1.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, request1.version()).size());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData2, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        java.util.Map topicNamesFooChanged = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicIds.get("bar")), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo")}))).asJava();
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNamesFooChanged), request2.forgottenTopics(topicNamesFooChanged), topicNamesFooChanged);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(tp0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(Errors.INCONSISTENT_TOPIC_ID.code()));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
        LinkedHashMap responseData2 = resp2.responseData(topicNames, request2.version());
        Assertions.assertEquals((short)Errors.INCONSISTENT_TOPIC_ID.code(), (short)((FetchResponseData.PartitionData)responseData2.get(tp0.topicPartition())).errorCode());
    }

    private FetchResponseData.PartitionData noErrorResponse() {
        return new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L);
    }

    private FetchResponseData.PartitionData errorResponse(short errorCode) {
        return new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(errorCode);
    }

    @Test
    public void testResolveUnknownPartitions() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        TopicIdPartition zar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("zar", 0));
        TopicIdPartition fooUnresolved = new TopicIdPartition(foo.topicId(), new TopicPartition(null, foo.partition()));
        TopicIdPartition barUnresolved = new TopicIdPartition(bar.topicId(), new TopicPartition(null, bar.partition()));
        TopicIdPartition zarUnresolved = new TopicIdPartition(zar.topicId(), new TopicPartition(null, zar.partition()));
        FetchContext context1 = this.newContext$1(FetchMetadata.INITIAL, (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar, zar})), Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{fooUnresolved, barUnresolved, zarUnresolved}))));
        int sessionId = this.updateAndGenerateResponseData$1(context1);
        FetchContext context2 = this.newContext$1(new FetchMetadata(sessionId, 1), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, barUnresolved, zarUnresolved}))));
        this.updateAndGenerateResponseData$1(context2);
        FetchContext context3 = this.newContext$1(new FetchMetadata(sessionId, 2), (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{bar})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context3.getClass());
        this.assertPartitionsOrder(context3, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar, zarUnresolved}))));
        this.updateAndGenerateResponseData$1(context3);
        FetchContext context4 = this.newContext$1(new FetchMetadata(sessionId, 3), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar.topicId()), (Object)zar.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context4.getClass());
        this.assertPartitionsOrder(context4, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar, zar}))));
        this.updateAndGenerateResponseData$1(context4);
        FetchContext context5 = this.newContext$1(new FetchMetadata(sessionId, 4), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        this.assertPartitionsOrder(context4, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar, zar}))));
    }

    @ParameterizedTest
    @MethodSource(value={"idUsageCombinations"})
    public void testToForgetPartitions(boolean fooStartsResolved, boolean fooEndsResolved) {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        TopicIdPartition fooUnresolved = new TopicIdPartition(foo.topicId(), new TopicPartition(null, foo.partition()));
        TopicIdPartition barUnresolved = new TopicIdPartition(bar.topicId(), new TopicPartition(null, bar.partition()));
        scala.collection.immutable.Map context1Names = fooStartsResolved ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})) : Predef$.MODULE$.Map().empty();
        TopicIdPartition fooContext1 = fooStartsResolved ? foo : fooUnresolved;
        FetchContext context1 = this.newContext$2(FetchMetadata.INITIAL, (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{fooContext1, bar})), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), context1Names, fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{fooContext1, barUnresolved}))));
        int sessionId = this.updateAndGenerateResponseData$2(context1);
        scala.collection.immutable.Map context2Names = fooEndsResolved ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})) : Predef$.MODULE$.Map().empty();
        TopicIdPartition fooContext2 = fooEndsResolved ? foo : fooUnresolved;
        FetchContext context2 = this.newContext$2(new FetchMetadata(sessionId, 1), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{fooContext2})), context2Names, fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{barUnresolved}))));
        this.updateAndGenerateResponseData$2(context2);
        FetchContext context3 = this.newContext$2(new FetchMetadata(sessionId, 2), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{bar})), Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(SessionlessFetchContext.class, context3.getClass());
        this.assertPartitionsOrder(context3, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
    }

    @Test
    public void testUpdateAndGenerateResponseData() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        scala.collection.immutable.Map receivingBrokerTopicNames = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())}));
        scala.collection.immutable.Map sendingTopicNames = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic())}));
        FetchContext context1 = this.newContext$3(FetchMetadata.LEGACY, (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar})), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(SessionlessFetchContext.class, context1.getClass());
        FetchSessionTest.checkResponseData$1(this.updateAndGenerateResponseData$3(context1), foo, bar, sendingTopicNames);
        FetchContext context2 = this.newContext$3(FetchMetadata.INITIAL, (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar})), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context2.getClass());
        FetchResponse response2 = this.updateAndGenerateResponseData$3(context2);
        int sessionId = response2.sessionId();
        FetchSessionTest.checkResponseData$1(response2, foo, bar, sendingTopicNames);
        FetchContext context3 = this.newContext$3(new FetchMetadata(sessionId, 1), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context3.getClass());
        FetchSessionTest.checkResponseData$1(this.updateAndGenerateResponseData$3(context3), foo, bar, sendingTopicNames);
        FetchContext context4 = this.newContext$3(new FetchMetadata(sessionId, 1), (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(SessionErrorContext.class, context4.getClass());
        Assertions.assertEquals(Collections.emptyList(), (Object)this.updateAndGenerateResponseData$3(context4).data().responses());
    }

    @Test
    public void testFetchSessionExpiration() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session1req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session1req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session1req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest session1request1 = this.createRequest(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext session1context1 = fetchManager.newContext(session1request1.version(), session1request1.metadata(), session1request1.isFromFollower(), session1request1.fetchData(topicNames), session1request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session1context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData(topicNames, session1request1.version()).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session2req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session2req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session2req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest session2request1 = this.createRequest(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext session2context = fetchManager.newContext(session2request1.version(), session2request1.metadata(), session2request1.isFromFollower(), session2request1.fetchData(topicNames), session2request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        session2RespData.put(foo0.topicPartition(), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(foo1.topicPartition(), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData(topicNames, session2request1.version()).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        time.sleep(500L);
        FetchRequest session1request2 = this.createRequest(new FetchMetadata(session1resp.sessionId(), 1), new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>(), new ArrayList<TopicIdPartition>(), false, this.createRequest$default$5());
        FetchContext context1v2 = fetchManager.newContext(session1request2.version(), session1request2.metadata(), session1request2.isFromFollower(), session1request2.fetchData(topicNames), session1request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context1v2.getClass());
        time.sleep(501L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session3req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session3req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session3req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        FetchRequest session3request1 = this.createRequest(FetchMetadata.INITIAL, session3req, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext session3context = fetchManager.newContext(session3request1.version(), session3request1.metadata(), session3request1.isFromFollower(), session3request1.fetchData(topicNames), session3request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(new TopicIdPartition(fooId, new TopicPartition("foo", 0)), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(new TopicIdPartition(fooId, new TopicPartition("foo", 1)), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData(topicNames, session3request1.version()).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by latest session, as session 1 was used more recently");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
    }

    @Test
    public void testPrivilegedSessionHandling() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session1req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session1req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session1req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest session1request = this.createRequest(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), true, this.createRequest$default$5());
        FetchContext session1context = fetchManager.newContext(session1request.version(), session1request.metadata(), session1request.isFromFollower(), session1request.fetchData(topicNames), session1request.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session1context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData(topicNames, session1request.version()).size());
        Assertions.assertEquals((int)1, (int)cache.size());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session2req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session2req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session2req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest session2request = this.createRequest(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext session2context = fetchManager.newContext(session2request.version(), session2request.metadata(), session2request.isFromFollower(), session2request.fetchData(topicNames), session2request.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        session2RespData.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(session2RespData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData(topicNames, session2request.version()).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session3req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session3req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session3req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        FetchRequest session3request = this.createRequest(FetchMetadata.INITIAL, session3req, this.EMPTY_PART_LIST(), true, this.createRequest$default$5());
        FetchContext session3context = fetchManager.newContext(session3request.version(), session3request.metadata(), session3request.isFromFollower(), session3request.fetchData(topicNames), session3request.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData(topicNames, session3request.version()).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by session 3");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(501L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session4req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session4req.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        session4req.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        FetchRequest session4request = this.createRequest(FetchMetadata.INITIAL, session4req, this.EMPTY_PART_LIST(), true, this.createRequest$default$5());
        FetchContext session4context = fetchManager.newContext(session4request.version(), session4request.metadata(), session4request.isFromFollower(), session4request.fetchData(topicNames), session4request.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, session4context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData4 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData4.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData4.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session4resp = session3context.updateAndGenerateResponseData(respData4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session4resp.error());
        Assertions.assertTrue((session4resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session4resp.responseData(topicNames, session4request.version()).size());
        Assertions.assertFalse((boolean)cache.get(session1resp.sessionId()).isDefined(), (String)"session 1 should have been evicted by session 4 even though it is privileged as it has hit eviction time");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session4resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
    }

    @Test
    public void testZeroSizeFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(foo0.topicPartition(), new FetchRequest.PartitionData(fooId, 0L, 0L, 100, Optional.empty()));
        reqData1.put(foo1.topicPartition(), new FetchRequest.PartitionData(fooId, 10L, 0L, 100, Optional.empty()));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, request1.version()).size());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        ArrayList<TopicIdPartition> removed2 = new ArrayList<TopicIdPartition>();
        removed2.add(foo0);
        removed2.add(foo1);
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(SessionlessFetchContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((int)0, (int)resp2.sessionId());
        Assertions.assertTrue((boolean)resp2.responseData(topicNames, request2.version()).isEmpty());
        Assertions.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testDivergingEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicNames).asScala().map((Function1 & Serializable)x$13 -> x$13.swap())).asJava();
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 2));
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData.put(tp1.topicPartition(), new FetchRequest.PartitionData(tp1.topicId(), 100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        reqData.put(tp2.topicPartition(), new FetchRequest.PartitionData(tp2.topicId(), 100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        FetchRequest request1 = this.createRequest(FetchMetadata.INITIAL, reqData, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context1 = fetchManager.newContext(request1.version(), request1.metadata(), request1.isFromFollower(), request1.fetchData(topicNames), request1.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L));
        FetchResponseData.EpochEndOffset divergingEpoch = new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(90L);
        respData.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp1.responseData(topicNames, request1.version()).keySet());
        FetchRequest request2 = this.createRequest(new FetchMetadata(resp1.sessionId(), 1), reqData, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        FetchContext context2 = fetchManager.newContext(request2.version(), request2.metadata(), request2.isFromFollower(), request2.fetchData(topicNames), request2.forgottenTopics(topicNames), topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.singleton(tp2.topicPartition()), resp2.responseData(topicNames, request2.version()).keySet());
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp3.responseData(topicNames, request2.version()).keySet());
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(110L).setLastStableOffset(110L).setLogStartOffset(0L));
        FetchResponse resp4 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp4.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp4.responseData(topicNames, request2.version()).keySet());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeprioritizesPartitionsWithRecordsOnly() {
        void withRecords_records;
        void withRecords_timestampType;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zar"), (Object)Uuid.randomUuid())}))).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$14 -> x$14.swap())).asJava();
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 2));
        TopicIdPartition tp3 = new TopicIdPartition((Uuid)topicIds.get("zar"), new TopicPartition("zar", 3));
        LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData> reqData = new LinkedHashMap<TopicIdPartition, FetchRequest.PartitionData>();
        reqData.put(tp1, new FetchRequest.PartitionData(tp1.topicId(), 100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        reqData.put(tp2, new FetchRequest.PartitionData(tp2.topicId(), 100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        reqData.put(tp3, new FetchRequest.PartitionData(tp3.topicId(), 100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        FetchContext context1 = fetchManager.newContext(ApiKeys.FETCH.latestVersion(), FetchMetadata.INITIAL, false, reqData, Collections.emptyList(), topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.topicPartition().partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.topicPartition().partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(tp3, new FetchResponseData.PartitionData().setPartitionIndex(tp3.topicPartition().partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition(), tp3.topicPartition()}), resp1.responseData(topicNames, ApiKeys.FETCH.latestVersion()).keySet());
        FetchContext context2 = fetchManager.newContext(ApiKeys.FETCH.latestVersion(), new FetchMetadata(resp1.sessionId(), 1), false, reqData, Collections.emptyList(), topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp1, tp2, tp3}))));
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.emptySet(), resp2.responseData(topicNames, ApiKeys.FETCH.latestVersion()).keySet());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.topicPartition().partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(100L, null)};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var18_18 = null;
        simpleRecordArray = null;
        respData3.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.topicPartition().partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L).setRecords((BaseRecords)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records)));
        respData3.put(tp3, new FetchResponseData.PartitionData().setPartitionIndex(tp3.topicPartition().partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp3.responseData(topicNames, ApiKeys.FETCH.latestVersion()).keySet());
        this.assertPartitionsOrder(context2, (scala.collection.immutable.Seq<TopicIdPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp1, tp3, tp2}))));
    }

    @Test
    public void testCachedPartitionEqualsAndHashCode() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic";
        int partition = 0;
        CachedPartition cachedPartitionWithIdAndName = new CachedPartition(topicName, topicId, partition);
        CachedPartition cachedPartitionWithIdAndNoName = new CachedPartition(null, topicId, partition);
        CachedPartition cachedPartitionWithDifferentIdAndName = new CachedPartition(topicName, Uuid.randomUuid(), partition);
        CachedPartition cachedPartitionWithZeroIdAndName = new CachedPartition(topicName, Uuid.ZERO_UUID, partition);
        CachedPartition cachedPartitionWithZeroIdAndOtherName = new CachedPartition("otherTopic", Uuid.ZERO_UUID, partition);
        Assertions.assertEquals((Object)cachedPartitionWithIdAndName, (Object)cachedPartitionWithIdAndNoName);
        Assertions.assertEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithIdAndNoName.hashCode());
        Assertions.assertNotEquals((Object)cachedPartitionWithIdAndName, (Object)cachedPartitionWithDifferentIdAndName);
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithDifferentIdAndName.hashCode());
        Assertions.assertNotEquals((Object)cachedPartitionWithIdAndName, (Object)cachedPartitionWithZeroIdAndName);
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
        Assertions.assertEquals((Object)cachedPartitionWithIdAndNoName, (Object)cachedPartitionWithIdAndName);
        Assertions.assertEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithIdAndName.hashCode());
        Assertions.assertNotEquals((Object)cachedPartitionWithIdAndNoName, (Object)cachedPartitionWithDifferentIdAndName);
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithDifferentIdAndName.hashCode());
        Assertions.assertNotEquals((Object)cachedPartitionWithIdAndNoName, (Object)cachedPartitionWithZeroIdAndName);
        Assertions.assertNotEquals((int)cachedPartitionWithIdAndNoName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
        Assertions.assertNotEquals((Object)cachedPartitionWithZeroIdAndName, (Object)cachedPartitionWithZeroIdAndOtherName);
        Assertions.assertNotEquals((int)cachedPartitionWithZeroIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndOtherName.hashCode());
        Assertions.assertEquals((Object)cachedPartitionWithZeroIdAndName, (Object)cachedPartitionWithZeroIdAndName);
        Assertions.assertEquals((int)cachedPartitionWithZeroIdAndName.hashCode(), (int)cachedPartitionWithZeroIdAndName.hashCode());
    }

    @Test
    public void testMaybeResolveUnknownName() {
        CachedPartition namedPartition = new CachedPartition("topic", Uuid.randomUuid(), 0);
        CachedPartition nullNamePartition1 = new CachedPartition(null, Uuid.randomUuid(), 0);
        CachedPartition nullNamePartition2 = new CachedPartition(null, Uuid.randomUuid(), 0);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)namedPartition.topicId()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nullNamePartition1.topicId()), (Object)"bar")}))).asJava();
        namedPartition.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals((Object)"topic", (Object)namedPartition.topic());
        nullNamePartition1.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals((Object)"bar", (Object)nullNamePartition1.topic());
        nullNamePartition2.maybeResolveUnknownName(topicNames);
        Assertions.assertEquals(null, (Object)nullNamePartition2.topic());
    }

    private void assertPartitionsOrder(FetchContext context, scala.collection.immutable.Seq<TopicIdPartition> partitions) {
        ArrayBuffer partitionsInContext = ArrayBuffer$.MODULE$.empty();
        context.foreachPartition((Function2 & Serializable)(tp, x$15) -> {
            partitionsInContext.$plus$eq((Object)tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(partitions, (Object)partitionsInContext.toSeq());
    }

    private static final scala.collection.immutable.Map cachedLeaderEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    private static final scala.collection.immutable.Map cachedLeaderEpochs$2(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    private static final scala.collection.immutable.Map cachedLastFetchedEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.lastFetchedEpoch));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$2(java.util.Iterator reqData2Iter$1, java.util.Map topicIds$1, TopicIdPartition topicIdPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData2Iter$1.next();
        Assertions.assertEquals(entry.getKey(), (Object)topicIdPart.topicPartition());
        Assertions.assertEquals(topicIds$1.get(((TopicPartition)entry.getKey()).topic()), (Object)topicIdPart.topicId());
        Assertions.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$4(java.util.Iterator reqData5Iter$1, java.util.Map topicIds$1, TopicIdPartition topicIdPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData5Iter$1.next();
        Assertions.assertEquals(entry.getKey(), (Object)topicIdPart.topicPartition());
        Assertions.assertEquals(topicIds$1.get(((TopicPartition)entry.getKey()).topic()), (Object)topicIdPart.topicId());
        Assertions.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testIncrementalFetchSession$2(Iterator reqData2Iter$2, TopicIdPartition topicIdPart, FetchRequest.PartitionData x$6) {
        Assertions.assertEquals((Object)reqData2Iter$2.next(), (Object)topicIdPart);
    }

    private final FetchContext newContext$1(FetchMetadata metadata, scala.collection.immutable.Seq partitions, scala.collection.immutable.Map topicNames, FetchManager fetchManager$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        return fetchManager$1.newContext(fetchRequest.version(), fetchRequest.metadata(), fetchRequest.isFromFollower(), fetchRequest.fetchData(CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava()), fetchRequest.forgottenTopics(CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava()), CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava());
    }

    private final int updateAndGenerateResponseData$1(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable)(topicIdPartition, x$10) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.noErrorResponse());
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data).sessionId();
    }

    private final FetchContext newContext$2(FetchMetadata metadata, scala.collection.immutable.Seq partitions, scala.collection.immutable.Seq toForget, scala.collection.immutable.Map topicNames, FetchManager fetchManager$2) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)toForget.toList()).asJava(), false, this.createRequest$default$5());
        return fetchManager$2.newContext(fetchRequest.version(), fetchRequest.metadata(), fetchRequest.isFromFollower(), fetchRequest.fetchData(CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava()), fetchRequest.forgottenTopics(CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava()), CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava());
    }

    private final int updateAndGenerateResponseData$2(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable)(topicIdPartition, x$11) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.noErrorResponse());
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data).sessionId();
    }

    private final FetchContext newContext$3(FetchMetadata metadata, scala.collection.immutable.Seq partitions, scala.collection.immutable.Map topicNames, FetchManager fetchManager$3) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        return fetchManager$3.newContext(fetchRequest.version(), fetchRequest.metadata(), fetchRequest.isFromFollower(), fetchRequest.fetchData(CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava()), fetchRequest.forgottenTopics(CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava()), CollectionConverters$.MODULE$.MapHasAsJava((Map)topicNames).asJava());
    }

    private final FetchResponse updateAndGenerateResponseData$3(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable)(topicIdPartition, x$12) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.errorResponse(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data);
    }

    private static final void checkResponseData$1(FetchResponse response, TopicIdPartition foo$1, TopicIdPartition bar$1, scala.collection.immutable.Map sendingTopicNames$1) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo$1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar$1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)response.responseData(CollectionConverters$.MODULE$.MapHasAsJava((Map)sendingTopicNames$1).asJava(), ApiKeys.FETCH.latestVersion())).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            return tuple2;
        }));
    }
}

