/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.QuorumImplementation;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00114A\u0001D\u0007\u0001%!AQ\u0004\u0001BC\u0002\u0013\u0005a\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003 \u0011!1\u0003A!b\u0001\n\u00039\u0003\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u00111\u0002!Q1A\u0005\u00025B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\f\u0005\te\u0001\u0011)\u0019!C\u0001g!A!\b\u0001B\u0001B\u0003%A\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003C\u0001\u0011\u00053\tC\u0003`\u0001\u0011\u0005\u0003MA\u000f[_>\\U-\u001a9feF+xN];n\u00136\u0004H.Z7f]R\fG/[8o\u0015\tqq\"\u0001\u0004tKJ4XM\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u00143A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"AG\u000e\u000e\u00035I!\u0001H\u0007\u0003)E+xN];n\u00136\u0004H.Z7f]R\fG/[8o\u0003%Qxn\\6fKB,'/F\u0001 !\t\u00013%D\u0001\"\u0015\t\u0011s\"\u0001\u0002{W&\u0011A%\t\u0002\u0012\u000b6\u0014W\r\u001a3fIj{wn[3fa\u0016\u0014\u0018A\u0003>p_.,W\r]3sA\u0005A!p[\"mS\u0016tG/F\u0001)!\t\u0001\u0013&\u0003\u0002+C\ti1*\u00194lCj[7\t\\5f]R\f\u0011B_6DY&,g\u000e\u001e\u0011\u0002\u001b\u0005$W.\u001b8[W\u000ec\u0017.\u001a8u+\u0005q\u0003C\u0001\u00110\u0013\t\u0001\u0014EA\u0007BI6LgNW6DY&,g\u000e^\u0001\u000fC\u0012l\u0017N\u001c.l\u00072LWM\u001c;!\u0003\rawnZ\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\u0011qgD\u0001\u0006kRLGn]\u0005\u0003sY\u0012q\u0001T8hO&tw-\u0001\u0003m_\u001e\u0004\u0013A\u0002\u001fj]&$h\bF\u0003>}}\u0002\u0015\t\u0005\u0002\u001b\u0001!)Q$\u0003a\u0001?!)a%\u0003a\u0001Q!)A&\u0003a\u0001]!)!'\u0003a\u0001i\u0005a1M]3bi\u0016\u0014%o\\6feR!Ai\u0012'[!\tQR)\u0003\u0002G\u001b\tY1*\u00194lC\n\u0013xn[3s\u0011\u0015A%\u00021\u0001J\u0003\u0019\u0019wN\u001c4jOB\u0011!DS\u0005\u0003\u00176\u00111bS1gW\u0006\u001cuN\u001c4jO\")QJ\u0003a\u0001\u001d\u0006!A/[7f!\ty\u0005,D\u0001Q\u0015\t9\u0014K\u0003\u0002S'\u000611m\\7n_:T!\u0001\u0005+\u000b\u0005U3\u0016AB1qC\u000eDWMC\u0001X\u0003\ry'oZ\u0005\u00033B\u0013A\u0001V5nK\")1L\u0003a\u00019\u000691\u000f^1siV\u0004\bC\u0001\u000b^\u0013\tqVCA\u0004C_>dW-\u00198\u0002\u0011MDW\u000f\u001e3po:$\u0012!\u0019\t\u0003)\tL!aY\u000b\u0003\tUs\u0017\u000e\u001e")
public class ZooKeeperQuorumImplementation
implements QuorumImplementation {
    private final EmbeddedZookeeper zookeeper;
    private final KafkaZkClient zkClient;
    private final AdminZkClient adminZkClient;
    private final Logging log;

    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    public Logging log() {
        return this.log;
    }

    @Override
    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup) {
        KafkaServer server = new KafkaServer(config, time, (Option)None$.MODULE$, false);
        if (startup) {
            server.startup();
        }
        return server;
    }

    @Override
    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.zkClient().close(), this.log(), Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.zookeeper().shutdown(), this.log(), Level.WARN);
    }

    public ZooKeeperQuorumImplementation(EmbeddedZookeeper zookeeper, KafkaZkClient zkClient, AdminZkClient adminZkClient, Logging log) {
        this.zookeeper = zookeeper;
        this.zkClient = zkClient;
        this.adminZkClient = adminZkClient;
        this.log = log;
    }
}

