/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.CorruptIndexException;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog$;
import kafka.log.LogConfig;
import kafka.log.LogLoader$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.ProducerStateManager;
import kafka.log.SplitSegmentResult;
import kafka.log.UnifiedLog$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005=v!B\u000e\u001d\u0011\u0003\tc!B\u0012\u001d\u0011\u0003!\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007{\u0005\u0001\u000b\u0011B\u001b\u0007\t\rb\u0002A\u0010\u0005\t\u007f\u0015\u0011\t\u0011)A\u0005\u0001\"Aa)\u0002B\u0001B\u0003%q\t\u0003\u0005S\u000b\t\u0005\t\u0015!\u0003T\u0011!1VA!A!\u0002\u00139\u0006\u0002\u0003.\u0006\u0005\u0003\u0005\u000b\u0011B.\t\u0011\u0001,!\u0011!Q\u0001\n\u0005D\u0001bZ\u0003\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tW\u0016\u0011\t\u0011)A\u0005Y\"Aq.\u0002B\u0001B\u0003%\u0001\u000f\u0003\u0005t\u000b\t\u0005\t\u0015!\u0003q\u0011!!XA!A!\u0002\u0013)\b\u0002\u0003@\u0006\u0005\u0003\u0005\u000b\u0011B@\t\rE*A\u0011AA\u0003\u0011\u001d\t\t#\u0002C\u0001\u0003GAq!a\u000b\u0006\t\u0013\ti\u0003C\u0004\u0002<\u0015!I!!\u0010\t\u000f\u0005\u0005T\u0001\"\u0003\u0002d!9\u00111N\u0003\u0005\n\u00055\u0004\u0002CA@\u000b\u0011\u0005A$!!\t\u000f\u0005%U\u0001\"\u0003\u0002\f\"9\u0011\u0011V\u0003\u0005\n\u0005-\u0016!\u0003'pO2{\u0017\rZ3s\u0015\tib$A\u0002m_\u001eT\u0011aH\u0001\u0006W\u000647.Y\u0002\u0001!\t\u0011\u0013!D\u0001\u001d\u0005%aun\u001a'pC\u0012,'oE\u0002\u0002K-\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u001f\u0003\u0015)H/\u001b7t\u0013\t\u0001TFA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\t\u0013!E\"mK\u0006t7\u000b[;uI><hNR5mKV\tQ\u0007\u0005\u00027w5\tqG\u0003\u00029s\u0005!A.\u00198h\u0015\u0005Q\u0014\u0001\u00026bm\u0006L!\u0001P\u001c\u0003\rM#(/\u001b8h\u0003I\u0019E.Z1o'\",H\u000fZ8x]\u001aKG.\u001a\u0011\u0014\u0007\u0015)3&A\u0002eSJ\u0004\"!\u0011#\u000e\u0003\tS!aQ\u001d\u0002\u0005%|\u0017BA#C\u0005\u00111\u0015\u000e\\3\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001\nU\u0007\u0002\u0013*\u0011!jS\u0001\u0007G>lWn\u001c8\u000b\u0005}a%BA'O\u0003\u0019\t\u0007/Y2iK*\tq*A\u0002pe\u001eL!!U%\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u000611m\u001c8gS\u001e\u0004\"A\t+\n\u0005Uc\"!\u0003'pO\u000e{gNZ5h\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002-1&\u0011\u0011,\f\u0002\n'\u000eDW\rZ;mKJ\fA\u0001^5nKB\u0011ALX\u0007\u0002;*\u0011a&S\u0005\u0003?v\u0013A\u0001V5nK\u0006!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0010\u0002\rM,'O^3s\u0013\t17M\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0011Q\u0006$7\t\\3b]NCW\u000f\u001e3po:\u0004\"AJ5\n\u0005)<#a\u0002\"p_2,\u0017M\\\u0001\tg\u0016<W.\u001a8ugB\u0011!%\\\u0005\u0003]r\u00111\u0002T8h'\u0016<W.\u001a8ug\u0006ABn\\4Ti\u0006\u0014Ho\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;\u0011\u0005\u0019\n\u0018B\u0001:(\u0005\u0011auN\\4\u0002/I,7m\u001c<fef\u0004v.\u001b8u\u0007\",7m\u001b9pS:$\u0018\u0001\u00057fC\u0012,'/\u00129pG\"\u001c\u0015m\u00195f!\r1c\u000f_\u0005\u0003o\u001e\u0012aa\u00149uS>t\u0007CA=}\u001b\u0005Q(BA>d\u0003\u0015)\u0007o\\2i\u0013\ti(P\u0001\u000bMK\u0006$WM]#q_\u000eDg)\u001b7f\u0007\u0006\u001c\u0007.Z\u0001\u0015aJ|G-^2feN#\u0018\r^3NC:\fw-\u001a:\u0011\u0007\t\n\t!C\u0002\u0002\u0004q\u0011A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014HCGA\u0004\u0003\u0013\tY!!\u0004\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0001C\u0001\u0012\u0006\u0011\u0015y$\u00031\u0001A\u0011\u00151%\u00031\u0001H\u0011\u0015\u0011&\u00031\u0001T\u0011\u00151&\u00031\u0001X\u0011\u0015Q&\u00031\u0001\\\u0011\u0015\u0001'\u00031\u0001b\u0011\u00159'\u00031\u0001i\u0011\u0015Y'\u00031\u0001m\u0011\u0015y'\u00031\u0001q\u0011\u0015\u0019(\u00031\u0001q\u0011\u0015!(\u00031\u0001v\u0011\u0015q(\u00031\u0001\u0000\u0003\u0011aw.\u00193\u0015\u0005\u0005\u0015\u0002c\u0001\u0012\u0002(%\u0019\u0011\u0011\u0006\u000f\u0003!1{\u0017\rZ3e\u0019><wJ\u001a4tKR\u001c\u0018A\t:f[>4X\rV3na\u001aKG.Z:B]\u0012\u001cu\u000e\u001c7fGR\u001cv/\u00199GS2,7\u000f\u0006\u0002\u00020A)\u0011\u0011GA\u001c\u00016\u0011\u00111\u0007\u0006\u0004\u0003k9\u0013AC2pY2,7\r^5p]&!\u0011\u0011HA\u001a\u0005\r\u0019V\r^\u0001\u0016e\u0016$(/_(o\u001f\u001a47/\u001a;Pm\u0016\u0014h\r\\8x+\u0011\ty$!\u0012\u0015\t\u0005\u0005\u0013q\u000b\t\u0005\u0003\u0007\n)\u0005\u0004\u0001\u0005\u000f\u0005\u001dSC1\u0001\u0002J\t\tA+\u0005\u0003\u0002L\u0005E\u0003c\u0001\u0014\u0002N%\u0019\u0011qJ\u0014\u0003\u000f9{G\u000f[5oOB\u0019a%a\u0015\n\u0007\u0005UsEA\u0002B]fDq!!\u0017\u0016\u0001\u0004\tY&\u0001\u0002g]B)a%!\u0018\u0002B%\u0019\u0011qL\u0014\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014\u0001\u00057pC\u0012\u001cVmZ7f]R4\u0015\u000e\\3t)\t\t)\u0007E\u0002'\u0003OJ1!!\u001b(\u0005\u0011)f.\u001b;\u0002\u001dI,7m\u001c<feN+w-\\3oiR!\u0011qNA;!\r1\u0013\u0011O\u0005\u0004\u0003g:#aA%oi\"9\u0011qO\fA\u0002\u0005e\u0014aB:fO6,g\u000e\u001e\t\u0004E\u0005m\u0014bAA?9\tQAj\\4TK\u001elWM\u001c;\u0002\u0015I,7m\u001c<fe2{w\r\u0006\u0002\u0002\u0004B)a%!\"qa&\u0019\u0011qQ\u0014\u0003\rQ+\b\u000f\\33\u0003q\u0011X-\\8wK\u0006sG\rR3mKR,7+Z4nK:$8/Q:z]\u000e$B!!\u001a\u0002\u000e\"9\u0011qR\rA\u0002\u0005E\u0015\u0001E:fO6,g\u000e^:U_\u0012+G.\u001a;f!\u0019\t\u0019*a)\u0002z9!\u0011QSAP\u001d\u0011\t9*!(\u000e\u0005\u0005e%bAANA\u00051AH]8pizJ\u0011\u0001K\u0005\u0004\u0003C;\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003K\u000b9K\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t\tkJ\u0001\u001dI\u0016dW\r^3Qe>$WoY3s':\f\u0007o\u001d5piN\f5/\u001f8d)\u0011\t)'!,\t\r-T\u0002\u0019AAI\u0001")
public class LogLoader
implements Logging {
    private final File dir;
    private final TopicPartition topicPartition;
    private final LogConfig config;
    private final Scheduler scheduler;
    private final Time time;
    private final LogDirFailureChannel logDirFailureChannel;
    private final boolean hadCleanShutdown;
    private final LogSegments segments;
    private final long logStartOffsetCheckpoint;
    private final long recoveryPointCheckpoint;
    private final Option<LeaderEpochFileCache> leaderEpochCache;
    private final ProducerStateManager producerStateManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String CleanShutdownFile() {
        return LogLoader$.MODULE$.CleanShutdownFile();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public LoadedLogOffsets load() {
        long l;
        long l2;
        Object var19_7;
        SplitSegmentResult splitSegmentResult;
        LogSegments logSegments;
        File file2;
        TopicPartition topicPartition;
        LogConfig logConfig;
        Scheduler scheduler;
        LogDirFailureChannel logDirFailureChannel;
        String string;
        Set<File> swapFiles = this.removeTempFilesAndCollectSwapFiles();
        LongRef minSwapFileOffset = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxSwapFileOffset = LongRef.create((long)Long.MIN_VALUE);
        ((IterableOnceOps)swapFiles.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$load$1(f)))).foreach((Function1 & Serializable)f -> {
            LogLoader.$anonfun$load$2(this, minSwapFileOffset, maxSwapFileOffset, f);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            Object object;
            block6: {
                try {
                    if (!file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                        long l = LocalLog$.MODULE$.offsetFromFile((File)file);
                        if (l >= minSwapFileOffset$1.elem && l < maxSwapFileOffset$1.elem) {
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Deleting segment files ").append(file.getName()).append(" that is compacted but has not been deleted yet.").toString());
                            object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        break block6;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return BoxedUnit.UNIT;
                }
                catch (NumberFormatException numberFormatException) {
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Recovering file ").append(file.getName()).append(" by renaming from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files.").toString());
                return BoxesRunTime.boxToBoolean((boolean)file.renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.SwapFileSuffix(), ""))));
            }
            return BoxedUnit.UNIT;
        });
        while (true) {
            try {
                LogLoader.$anonfun$load$10(this);
            }
            catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                void retryOnOffsetOverflow_splitOverflowedSegment_logPrefix;
                void retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel;
                void retryOnOffsetOverflow_splitOverflowedSegment_scheduler;
                void retryOnOffsetOverflow_splitOverflowedSegment_config;
                void retryOnOffsetOverflow_splitOverflowedSegment_topicPartition;
                void retryOnOffsetOverflow_splitOverflowedSegment_dir;
                void retryOnOffsetOverflow_splitOverflowedSegment_existingSegments;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                string = this.logIdent();
                logDirFailureChannel = this.logDirFailureChannel;
                scheduler = this.scheduler;
                logConfig = this.config;
                topicPartition = this.topicPartition;
                file2 = this.dir;
                logSegments = this.segments;
                LogSegment retryOnOffsetOverflow_splitOverflowedSegment_segment = retryOnOffsetOverflow_e.segment();
                SplitSegmentResult splitSegmentResult2 = splitSegmentResult = LocalLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_splitOverflowedSegment_segment, (LogSegments)retryOnOffsetOverflow_splitOverflowedSegment_existingSegments, (File)retryOnOffsetOverflow_splitOverflowedSegment_dir, (TopicPartition)retryOnOffsetOverflow_splitOverflowedSegment_topicPartition, (LogConfig)retryOnOffsetOverflow_splitOverflowedSegment_config, (Scheduler)retryOnOffsetOverflow_splitOverflowedSegment_scheduler, (LogDirFailureChannel)retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel, (String)retryOnOffsetOverflow_splitOverflowedSegment_logPrefix);
                var19_7 = null;
                logSegments = null;
                file2 = null;
                topicPartition = null;
                logConfig = null;
                scheduler = null;
                logDirFailureChannel = null;
                string = null;
                splitSegmentResult = null;
                SplitSegmentResult retryOnOffsetOverflow_result = splitSegmentResult2;
                this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                continue;
            }
            break;
        }
        Object var17_5 = null;
        Object var18_6 = null;
        var19_7 = null;
        logSegments = null;
        file2 = null;
        topicPartition = null;
        logConfig = null;
        scheduler = null;
        logDirFailureChannel = null;
        string = null;
        splitSegmentResult = null;
        if (!this.dir.getAbsolutePath().endsWith(UnifiedLog$.MODULE$.DeleteDirSuffix())) {
            void var7_32;
            void var5_31;
            Object var30_19;
            SplitSegmentResult splitSegmentResult3;
            LogSegments logSegments2;
            File file3;
            TopicPartition topicPartition2;
            LogConfig logConfig2;
            Scheduler scheduler2;
            LogDirFailureChannel logDirFailureChannel2;
            String string2;
            Tuple2<Object, Object> tuple2;
            while (true) {
                try {
                    Tuple2<Object, Object> tuple22;
                    Tuple2<Object, Object> tuple23 = tuple22 = this.recoverLog();
                    tuple22 = null;
                    tuple2 = tuple23;
                }
                catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                    void retryOnOffsetOverflow_splitOverflowedSegment_logPrefix;
                    void retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel;
                    void retryOnOffsetOverflow_splitOverflowedSegment_scheduler;
                    void retryOnOffsetOverflow_splitOverflowedSegment_config;
                    void retryOnOffsetOverflow_splitOverflowedSegment_topicPartition;
                    void retryOnOffsetOverflow_splitOverflowedSegment_dir;
                    void retryOnOffsetOverflow_splitOverflowedSegment_existingSegments;
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                    string2 = this.logIdent();
                    logDirFailureChannel2 = this.logDirFailureChannel;
                    scheduler2 = this.scheduler;
                    logConfig2 = this.config;
                    topicPartition2 = this.topicPartition;
                    file3 = this.dir;
                    logSegments2 = this.segments;
                    LogSegment retryOnOffsetOverflow_splitOverflowedSegment_segment = retryOnOffsetOverflow_e.segment();
                    SplitSegmentResult splitSegmentResult4 = splitSegmentResult3 = LocalLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_splitOverflowedSegment_segment, (LogSegments)retryOnOffsetOverflow_splitOverflowedSegment_existingSegments, (File)retryOnOffsetOverflow_splitOverflowedSegment_dir, (TopicPartition)retryOnOffsetOverflow_splitOverflowedSegment_topicPartition, (LogConfig)retryOnOffsetOverflow_splitOverflowedSegment_config, (Scheduler)retryOnOffsetOverflow_splitOverflowedSegment_scheduler, (LogDirFailureChannel)retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel, (String)retryOnOffsetOverflow_splitOverflowedSegment_logPrefix);
                    var30_19 = null;
                    logSegments2 = null;
                    file3 = null;
                    topicPartition2 = null;
                    logConfig2 = null;
                    scheduler2 = null;
                    logDirFailureChannel2 = null;
                    string2 = null;
                    splitSegmentResult3 = null;
                    SplitSegmentResult retryOnOffsetOverflow_result = splitSegmentResult4;
                    this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                    continue;
                }
                break;
            }
            Tuple2<Object, Object> tuple24 = tuple2;
            Object var28_17 = null;
            Object var29_18 = null;
            var30_19 = null;
            logSegments2 = null;
            file3 = null;
            topicPartition2 = null;
            logConfig2 = null;
            scheduler2 = null;
            logDirFailureChannel2 = null;
            string2 = null;
            splitSegmentResult3 = null;
            tuple2 = null;
            Tuple2<Object, Object> tuple25 = tuple24;
            if (tuple25 == null) {
                throw new MatchError(null);
            }
            long newRecoveryPoint = tuple25._1$mcJ$sp();
            long nextOffset = tuple25._2$mcJ$sp();
            ((LogSegment)this.segments.lastSegment().get()).resizeIndexes(Predef$.MODULE$.Integer2int(this.config.maxIndexSize()));
            l2 = var5_31;
            l = var7_32;
        } else {
            if (this.segments.isEmpty()) {
                String string3;
                File x$9 = this.dir;
                LogConfig x$11 = this.config;
                Time x$12 = this.time;
                int x$13 = this.config.initFileSize();
                boolean bl = false;
                boolean bl2 = false;
                String string4 = string3 = "";
                string3 = null;
                String x$16 = string4;
                this.segments.add(LogSegment$.MODULE$.open(x$9, 0L, x$11, x$12, bl, x$13, bl2, x$16));
            }
            l2 = 0L;
            l = 0L;
        }
        long l3 = l;
        long l4 = l2;
        this.leaderEpochCache.foreach((Function1 & Serializable)x$3 -> {
            x$3.truncateFromEnd(l3);
            return BoxedUnit.UNIT;
        });
        long newLogStartOffset = package$.MODULE$.max(this.logStartOffsetCheckpoint, ((LogSegment)this.segments.firstSegment().get()).baseOffset());
        this.leaderEpochCache.foreach((Function1 & Serializable)x$4 -> {
            x$4.truncateFromStart(this.logStartOffsetCheckpoint);
            return BoxedUnit.UNIT;
        });
        if (!this.producerStateManager.isEmpty()) {
            throw new IllegalStateException("Producer state must be empty during log initialization");
        }
        this.producerStateManager.removeStraySnapshots((Seq<Object>)this.segments.baseOffsets().toSeq());
        UnifiedLog$.MODULE$.rebuildProducerState(this.producerStateManager, this.segments, newLogStartOffset, l3, this.config.recordVersion(), this.time, this.hadCleanShutdown, this.logIdent());
        LogSegment activeSegment = (LogSegment)this.segments.lastSegment().get();
        return new LoadedLogOffsets(newLogStartOffset, l4, new LogOffsetMetadata(l3, activeSegment.baseOffset(), activeSegment.size()));
    }

    /*
     * WARNING - void declaration
     */
    private Set<File> removeTempFilesAndCollectSwapFiles() {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Set swapFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set cleanedFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        LongRef minCleanedFileOffset = LongRef.create((long)Long.MAX_VALUE);
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (!file.canRead()) {
                throw new IOException(new StringBuilder(20).append("Could not read file ").append(file).toString());
            }
            String filename = file.getName();
            if (filename.endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix())) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Deleting stray temporary file ").append(file.getAbsolutePath()).toString());
                return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.CleanedFileSuffix())) {
                minCleanedFileOffset$1.elem = Math.min(LocalLog$.MODULE$.offsetFromFile((File)file), minCleanedFileOffset$1.elem);
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                return swapFiles.$plus$eq(file);
            }
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = swapFiles.partition((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$4(minCleanedFileOffset, file)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Set invalidSwapFiles = (scala.collection.mutable.Set)tuple2._1();
        scala.collection.mutable.Set validSwapFiles = (scala.collection.mutable.Set)tuple2._2();
        var5_5.foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$5(this, minCleanedFileOffset, file)));
        cleanedFiles.foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$7(this, file)));
        return var6_6;
    }

    /*
     * WARNING - void declaration
     */
    private <T> T retryOnOffsetOverflow(Function0<T> fn) {
        while (true) {
            try {
                return (T)fn.apply();
            }
            catch (LogSegmentOffsetOverflowException e) {
                void splitOverflowedSegment_logPrefix;
                void splitOverflowedSegment_logDirFailureChannel;
                void splitOverflowedSegment_scheduler;
                void splitOverflowedSegment_config;
                void splitOverflowedSegment_topicPartition;
                void splitOverflowedSegment_dir;
                void splitOverflowedSegment_existingSegments;
                SplitSegmentResult splitSegmentResult;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                String string = this.logIdent();
                LogDirFailureChannel logDirFailureChannel = this.logDirFailureChannel;
                Scheduler scheduler = this.scheduler;
                LogConfig logConfig = this.config;
                TopicPartition topicPartition = this.topicPartition;
                File file = this.dir;
                LogSegments logSegments = this.segments;
                LogSegment splitOverflowedSegment_segment = e.segment();
                SplitSegmentResult splitSegmentResult2 = splitSegmentResult = LocalLog$.MODULE$.splitOverflowedSegment(splitOverflowedSegment_segment, (LogSegments)splitOverflowedSegment_existingSegments, (File)splitOverflowedSegment_dir, (TopicPartition)splitOverflowedSegment_topicPartition, (LogConfig)splitOverflowedSegment_config, (Scheduler)splitOverflowedSegment_scheduler, (LogDirFailureChannel)splitOverflowedSegment_logDirFailureChannel, (String)splitOverflowedSegment_logPrefix);
                Object var4_4 = null;
                logSegments = null;
                file = null;
                topicPartition = null;
                logConfig = null;
                scheduler = null;
                logDirFailureChannel = null;
                string = null;
                splitSegmentResult = null;
                SplitSegmentResult result = splitSegmentResult2;
                this.deleteProducerSnapshotsAsync(result.deletedSegments());
                continue;
            }
            break;
        }
    }

    private void loadSegmentFiles() {
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)x$6 -> x$6.getName(), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (LocalLog$.MODULE$.isIndexFile((File)file)) {
                void logFile_suffix;
                String string;
                long l = LocalLog$.MODULE$.offsetFromFile((File)file);
                String string2 = string = "";
                string = null;
                String string3 = string2;
                File logFile_dir = $this.dir;
                Object var7_5 = null;
                string3 = null;
                if (!LocalLog$.MODULE$.logFile(logFile_dir, l, (String)logFile_suffix).exists()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Found an orphaned index file ").append(file.getAbsolutePath()).append(", with no corresponding log file.").toString());
                    return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
                }
                return BoxedUnit.UNIT;
            }
            if (LocalLog$.MODULE$.isLogFile((File)file)) {
                void timeIndexFile_suffix;
                String string;
                long l = LocalLog$.MODULE$.offsetFromFile((File)file);
                String string4 = string = "";
                string = null;
                String string5 = string4;
                File timeIndexFile_dir = $this.dir;
                Object var11_9 = null;
                string5 = null;
                boolean timeIndexFileNewlyCreated = !LocalLog$.MODULE$.timeIndexFile(timeIndexFile_dir, l, (String)timeIndexFile_suffix).exists();
                LogSegment segment = LogSegment$.MODULE$.open($this.dir, l, $this.config, $this.time, true, 0, false, "");
                try {
                    segment.sanityCheck(timeIndexFileNewlyCreated);
                }
                catch (NoSuchFileException noSuchFileException) {
                    if ($this.hadCleanShutdown || segment.baseOffset() < $this.recoveryPointCheckpoint) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Could not find offset index file corresponding to log file").append(new StringBuilder(51).append(" ").append(segment.log().file().getAbsolutePath()).append(", recovering segment and rebuilding index files...").toString()).toString());
                    }
                    this.recoverSegment(segment);
                }
                catch (CorruptIndexException e) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Found a corrupted index file corresponding to log file").append(new StringBuilder(34).append(" ").append(segment.log().file().getAbsolutePath()).append(" due to ").append(e.getMessage()).append("}, recovering segment and").toString()).append(" rebuilding index files...").toString());
                    this.recoverSegment(segment);
                }
                return $this.segments.add(segment);
            }
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private int recoverSegment(LogSegment segment) {
        void var3_3;
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition, this.dir, this.producerStateManager.maxTransactionTimeoutMs(), this.producerStateManager.maxProducerIdExpirationMs(), this.time);
        UnifiedLog$.MODULE$.rebuildProducerState(producerStateManager, this.segments, this.logStartOffsetCheckpoint, segment.baseOffset(), this.config.recordVersion(), this.time, false, this.logIdent());
        int bytesTruncated = segment.recover(producerStateManager, this.leaderEpochCache);
        producerStateManager.takeSnapshot();
        return (int)var3_3;
    }

    public Tuple2<Object, Object> recoverLog() {
        Tuple2.mcJJ.sp sp2;
        boolean bl;
        if (!this.hadCleanShutdown) {
            Iterator unflushed = this.segments.values(this.recoveryPointCheckpoint, Long.MAX_VALUE).iterator();
            boolean truncated = false;
            while (unflushed.hasNext() && !truncated) {
                int n;
                LogSegment segment = (LogSegment)unflushed.next();
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Recovering unflushed segment ").append(segment.baseOffset()).toString());
                try {
                    n = this.recoverSegment(segment);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    long startOffset = segment.baseOffset();
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Found invalid offset during recovery. Deleting the").append(new StringBuilder(64).append(" corrupt segment and creating an empty one with starting offset ").append(startOffset).toString()).toString());
                    n = segment.truncateTo(startOffset);
                }
                if (n <= 0) continue;
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(29).append("Corruption found in segment ").append(segment.baseOffset()).append(",").toString()).append(new StringBuilder(22).append(" truncating to offset ").append(segment.readNextOffset()).toString()).toString());
                this.removeAndDeleteSegmentsAsync((Iterable<LogSegment>)unflushed.toList());
                truncated = true;
            }
        }
        Option logEndOffsetOption = this.deleteSegmentsIfLogStartGreaterThanLogEnd$1();
        if (this.segments.isEmpty()) {
            String string;
            File x$1 = this.dir;
            long x$2 = this.logStartOffsetCheckpoint;
            LogConfig x$3 = this.config;
            Time x$4 = this.time;
            int x$5 = this.config.initFileSize();
            boolean x$6 = Predef$.MODULE$.Boolean2boolean(this.config.preallocate());
            boolean bl2 = false;
            String string2 = string = "";
            string = null;
            String x$8 = string2;
            this.segments.add(LogSegment$.MODULE$.open(x$1, x$2, x$3, x$4, bl2, x$5, x$6, x$8));
        }
        if ((bl = this.hadCleanShutdown) && logEndOffsetOption instanceof Some) {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)logEndOffsetOption).value());
            sp2 = new Tuple2.mcJJ.sp(logEndOffset, logEndOffset);
        } else {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)logEndOffsetOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> ((LogSegment)$this.segments.lastSegment().get()).readNextOffset()));
            sp2 = new Tuple2.mcJJ.sp(Math.min(this.recoveryPointCheckpoint, logEndOffset), logEndOffset);
        }
        return sp2;
    }

    /*
     * WARNING - void declaration
     */
    private void removeAndDeleteSegmentsAsync(Iterable<LogSegment> segmentsToDelete) {
        if (segmentsToDelete.nonEmpty()) {
            void deleteSegmentFiles_logPrefix;
            void deleteSegmentFiles_logDirFailureChannel;
            void deleteSegmentFiles_scheduler;
            void deleteSegmentFiles_config;
            void deleteSegmentFiles_topicPartition;
            void deleteSegmentFiles_dir;
            List toDelete = segmentsToDelete.toList();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Deleting segments as part of log recovery: ").append(toDelete.mkString(",")).toString());
            toDelete.foreach((Function1 & Serializable)segment -> {
                this.segments.remove(segment.baseOffset());
                return BoxedUnit.UNIT;
            });
            String string = this.logIdent();
            LogDirFailureChannel logDirFailureChannel = this.logDirFailureChannel;
            Scheduler scheduler = this.scheduler;
            LogConfig logConfig = this.config;
            TopicPartition topicPartition = this.topicPartition;
            File file = this.dir;
            boolean deleteSegmentFiles_asyncDelete = true;
            LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)toDelete, deleteSegmentFiles_asyncDelete, (File)deleteSegmentFiles_dir, (TopicPartition)deleteSegmentFiles_topicPartition, (LogConfig)deleteSegmentFiles_config, (Scheduler)deleteSegmentFiles_scheduler, (LogDirFailureChannel)deleteSegmentFiles_logDirFailureChannel, (String)deleteSegmentFiles_logPrefix);
            file = null;
            topicPartition = null;
            logConfig = null;
            scheduler = null;
            logDirFailureChannel = null;
            string = null;
            this.deleteProducerSnapshotsAsync(segmentsToDelete);
        }
    }

    private void deleteProducerSnapshotsAsync(Iterable<LogSegment> segments) {
        UnifiedLog$.MODULE$.deleteProducerSnapshots(segments, this.producerStateManager, true, this.scheduler, this.config, this.logDirFailureChannel, this.dir.getParent(), this.topicPartition);
    }

    public static final /* synthetic */ boolean $anonfun$load$1(File f) {
        File isLogFile_file = new File(CoreUtils$.MODULE$.replaceSuffix(f.getPath(), UnifiedLog$.MODULE$.SwapFileSuffix(), ""));
        return LocalLog$.MODULE$.isLogFile(isLogFile_file);
    }

    public static final /* synthetic */ void $anonfun$load$2(LogLoader $this, LongRef minSwapFileOffset$1, LongRef maxSwapFileOffset$1, File f) {
        long l = LocalLog$.MODULE$.offsetFromFile(f);
        File x$1 = f.getParentFile();
        LogConfig x$3 = $this.config;
        Time x$4 = $this.time;
        String x$5 = UnifiedLog$.MODULE$.SwapFileSuffix();
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        LogSegment segment = LogSegment$.MODULE$.open(x$1, l, x$3, x$4, bl, n, bl2, x$5);
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(94).append("Found log file ").append(f.getPath()).append(" from interrupted swap operation, which is recoverable from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files by renaming.").toString());
        minSwapFileOffset$1.elem = Math.min(segment.baseOffset(), minSwapFileOffset$1.elem);
        maxSwapFileOffset$1.elem = Math.max(segment.readNextOffset(), maxSwapFileOffset$1.elem);
    }

    public static final /* synthetic */ void $anonfun$load$10(LogLoader $this) {
        $this.segments.close();
        $this.segments.clear();
        $this.loadSegmentFiles();
    }

    public static final /* synthetic */ Tuple2 $anonfun$load$11(LogLoader $this) {
        return $this.recoverLog();
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$4(LongRef minCleanedFileOffset$1, File file) {
        return LocalLog$.MODULE$.offsetFromFile(file) >= minCleanedFileOffset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$5(LogLoader $this, LongRef minCleanedFileOffset$1, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Deleting invalid swap file ").append(file.getAbsoluteFile()).append(" minCleanedFileOffset: ").append(minCleanedFileOffset$1.elem).toString());
        return Files.deleteIfExists(file.toPath());
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$7(LogLoader $this, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Deleting stray .clean file ").append(file.getAbsolutePath()).toString());
        return Files.deleteIfExists(file.toPath());
    }

    private final Option deleteSegmentsIfLogStartGreaterThanLogEnd$1() {
        if (this.segments.nonEmpty()) {
            long logEndOffset = ((LogSegment)this.segments.lastSegment().get()).readNextOffset();
            if (logEndOffset >= this.logStartOffsetCheckpoint) {
                return new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append(new StringBuilder(46).append("Deleting all segments because logEndOffset (").append(logEndOffset).append(") ").toString()).append(new StringBuilder(33).append("is smaller than logStartOffset ").append($this.logStartOffsetCheckpoint).append(". ").toString()).append("This could happen if segment files were deleted from the file system.").toString());
            this.removeAndDeleteSegmentsAsync(this.segments.values());
            this.leaderEpochCache.foreach((Function1 & Serializable)x$7 -> {
                x$7.clearAndFlush();
                return BoxedUnit.UNIT;
            });
            this.producerStateManager.truncateFullyAndStartAt(this.logStartOffsetCheckpoint);
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public LogLoader(File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, Time time, LogDirFailureChannel logDirFailureChannel, boolean hadCleanShutdown, LogSegments segments, long logStartOffsetCheckpoint, long recoveryPointCheckpoint, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager) {
        this.dir = dir;
        this.topicPartition = topicPartition;
        this.config = config;
        this.scheduler = scheduler;
        this.time = time;
        this.logDirFailureChannel = logDirFailureChannel;
        this.hadCleanShutdown = hadCleanShutdown;
        this.segments = segments;
        this.logStartOffsetCheckpoint = logStartOffsetCheckpoint;
        this.recoveryPointCheckpoint = recoveryPointCheckpoint;
        this.leaderEpochCache = leaderEpochCache;
        this.producerStateManager = producerStateManager;
        this.logIdent_$eq(new StringBuilder(29).append("[LogLoader partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
    }
}

