/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.ControlPlaneAcceptor;
import kafka.network.ControlPlaneAcceptor$;
import kafka.network.DataPlaneAcceptor;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r5e\u0001\u0002)R\u0001YC\u0001b\u001c\u0001\u0003\u0006\u0004%\t\u0001\u001d\u0005\ti\u0002\u0011\t\u0011)A\u0005c\"Aa\r\u0001BC\u0002\u0013\u0005Q\u000fC\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005m\"Q\u0011q\u0001\u0001\u0003\u0006\u0004%\t!!\u0003\t\u0015\u0005U\u0001A!A!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u0018\u0001\u0011)\u0019!C\u0001\u00033A!\"a\n\u0001\u0005\u0003\u0005\u000b\u0011BA\u000e\u0011)\tI\u0003\u0001BC\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003g\u0001!\u0011!Q\u0001\n\u00055\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\n\u0003\u000f\u0002!\u0019!C\u0005\u0003\u0013B\u0001\"a\u0017\u0001A\u0003%\u00111\n\u0005\n\u0003;\u0002!\u0019!C\t\u0003?B\u0001\"a\u001a\u0001A\u0003%\u0011\u0011\r\u0005\n\u0003S\u0002!\u0019!C\u0005\u0003WB\u0001\"a\u001d\u0001A\u0003%\u0011Q\u000e\u0005\n\u0003k\u0002!\u0019!C\u0005\u0003oB\u0001\"a \u0001A\u0003%\u0011\u0011\u0010\u0005\n\u0003\u0003\u0003!\u0019!C\u0005\u0003\u0007C\u0001\"!$\u0001A\u0003%\u0011Q\u0011\u0005\n\u0003\u001f\u0003!\u0019!C\u0005\u0003\u0007C\u0001\"!%\u0001A\u0003%\u0011Q\u0011\u0005\n\u0003'\u0003!\u0019!C\u0005\u0003+C\u0001\"a)\u0001A\u0003%\u0011q\u0013\u0005\u000b\u0003K\u0003!\u0019!C\u0001#\u0006\u001d\u0006\u0002CAf\u0001\u0001\u0006I!!+\t\u0013\u00055\u0007A1A\u0005\u0002\u0005=\u0007\u0002CAl\u0001\u0001\u0006I!!5\t\u0015\u0005e\u0007\u00011A\u0005\u0002E\u000bY\u000e\u0003\u0006\u0002j\u0002\u0001\r\u0011\"\u0001R\u0003WD\u0001\"a>\u0001A\u0003&\u0011Q\u001c\u0005\n\u0003s\u0004!\u0019!C\u0001\u0003wD\u0001\"a@\u0001A\u0003%\u0011Q \u0005\t\u0005\u0003\u0001\u0001\u0015!\u0003\u0003\u0004!I!q\u0002\u0001C\u0002\u0013\u0005!\u0011\u0003\u0005\t\u00053\u0001\u0001\u0015!\u0003\u0003\u0014!I!1\u0004\u0001A\u0002\u0013%!Q\u0004\u0005\n\u0005K\u0001\u0001\u0019!C\u0005\u0005OA\u0001Ba\u000b\u0001A\u0003&!q\u0004\u0005\n\u0005[\u0001\u0001\u0019!C\u0005\u0005;A\u0011Ba\f\u0001\u0001\u0004%IA!\r\t\u0011\tU\u0002\u0001)Q\u0005\u0005?AqA!\u0001\u0001\t\u0003\u00119\u0004C\u0004\u0003:\u0001!\tAa\u000f\t\u0013\t]\u0003!%A\u0005\u0002\te\u0003\"\u0003B8\u0001E\u0005I\u0011\u0001B9\u0011%\u0011)\bAI\u0001\n\u0003\u00119\bC\u0004\u0003@\u0001!\tAa\u001f\t\u0013\te\u0005!%A\u0005\u0002\tm\u0005b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\n\u0005_\u0003\u0011\u0013!C\u0005\u00057CqA!-\u0001\t\u0013\u0011\u0019\fC\u0004\u00038\u0002!IA!/\t\u000f\tu\u0006\u0001\"\u0003\u0003@\"9!Q\u001b\u0001\u0005\u0002\t]\u0007b\u0002Bn\u0001\u0011%!Q\u001c\u0005\b\u0005G\u0004A\u0011\u0003Bs\u0011\u001d\u0011\u0019\u0010\u0001C\u0005\u0005kDqAa?\u0001\t\u0003\u0011i\u0010C\u0004\u0003\u0000\u0002!\tA!@\t\u000f\r\u0005\u0001\u0001\"\u0001\u0004\u0004!91\u0011\u0002\u0001\u0005\u0002\r-\u0001bBB\t\u0001\u0011\u000511\u0003\u0005\b\u00073\u0001A\u0011IB\u000e\u0011\u001d\u0019I\u0004\u0001C!\u0007wAqa!\u0011\u0001\t\u0003\u001a\u0019\u0005C\u0004\u0004L\u0001!Ia!\u0014\t\u0011\rM\u0003\u0001\"\u0001R\u0007+Bqaa\u001a\u0001\t\u0003\u0019IgB\u0004\u0004pEC\ta!\u001d\u0007\rA\u000b\u0006\u0012AB:\u0011\u001d\t)\u0004\u0013C\u0001\u0007kB\u0011ba\u001eI\u0005\u0004%\ta!\u001f\t\u0011\r}\u0004\n)A\u0005\u0007wB\u0011b!!I\u0005\u0004%\taa!\t\u0011\r\u001d\u0005\n)A\u0005\u0007\u000bC\u0011b!#I\u0005\u0004%\taa!\t\u0011\r-\u0005\n)A\u0005\u0007\u000b\u0013AbU8dW\u0016$8+\u001a:wKJT!AU*\u0002\u000f9,Go^8sW*\tA+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u000b\u00019VlY5\u0011\u0005a[V\"A-\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0003\r\u0005s\u0017PU3g!\tq\u0016-D\u0001`\u0015\t\u00017+A\u0003vi&d7/\u0003\u0002c?\n9Aj\\4hS:<\u0007C\u00013h\u001b\u0005)'B\u00014T\u0003\u001diW\r\u001e:jGNL!\u0001[3\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0005\u0002k[6\t1N\u0003\u0002m'\u000611/\u001a:wKJL!A\\6\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003\u0019\u0019wN\u001c4jOV\t\u0011\u000f\u0005\u0002ke&\u00111o\u001b\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0016\u0003Y\u00042a^A\u0001\u001b\u0005A(B\u00014z\u0015\tQ80\u0001\u0004d_6lwN\u001c\u0006\u0003)rT!! @\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0018aA8sO&\u0019\u00111\u0001=\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0003uS6,WCAA\u0006!\u0011\ti!!\u0005\u000e\u0005\u0005=!B\u00011z\u0013\u0011\t\u0019\"a\u0004\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0013GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/\u0006\u0002\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"M\u000b\u0001b]3dkJLG/_\u0005\u0005\u0003K\tyB\u0001\nDe\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\u0018aE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\u0004\u0013!E1qSZ+'o]5p]6\u000bg.Y4feV\u0011\u0011Q\u0006\t\u0004U\u0006=\u0012bAA\u0019W\n\t\u0012\t]5WKJ\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002%\u0005\u0004\u0018NV3sg&|g.T1oC\u001e,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u0005e\u0012QHA \u0003\u0003\n\u0019%!\u0012\u0011\u0007\u0005m\u0002!D\u0001R\u0011\u0015y7\u00021\u0001r\u0011\u001517\u00021\u0001w\u0011\u001d\t9a\u0003a\u0001\u0003\u0017Aq!a\u0006\f\u0001\u0004\tY\u0002C\u0004\u0002*-\u0001\r!!\f\u0002#5\f\u00070U;fk\u0016$'+Z9vKN$8/\u0006\u0002\u0002LA!\u0011QJA,\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013\u0001\u00027b]\u001eT!!!\u0016\u0002\t)\fg/Y\u0005\u0005\u00033\nyEA\u0004J]R,w-\u001a:\u0002%5\f\u00070U;fk\u0016$'+Z9vKN$8\u000fI\u0001\u0007]>$W-\u00133\u0016\u0005\u0005\u0005\u0004c\u0001-\u0002d%\u0019\u0011QM-\u0003\u0007%sG/A\u0004o_\u0012,\u0017\n\u001a\u0011\u0002\u00151|wmQ8oi\u0016DH/\u0006\u0002\u0002nA!\u0011QBA8\u0013\u0011\t\t(a\u0004\u0003\u00151{wmQ8oi\u0016DH/A\u0006m_\u001e\u001cuN\u001c;fqR\u0004\u0013\u0001E7f[>\u0014\u0018\u0010U8pYN+gn]8s+\t\tI\bE\u0002x\u0003wJ1!! y\u0005\u0019\u0019VM\\:pe\u0006\tR.Z7pef\u0004vn\u001c7TK:\u001cxN\u001d\u0011\u0002G5,Wn\u001c:z!>|G\u000eR3qY\u0016$X\r\u001a)fe\u000e,g\u000e^'fiJL7MT1nKV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000bI)D\u0001z\u0013\r\tY)\u001f\u0002\u000b\u001b\u0016$(/[2OC6,\u0017\u0001J7f[>\u0014\u0018\u0010U8pY\u0012+\u0007\u000f\\3uK\u0012\u0004VM]2f]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002A5,Wn\u001c:z!>|G\u000eR3qY\u0016$X\r\u001a+j[\u0016lU\r\u001e:jG:\u000bW.Z\u0001\"[\u0016lwN]=Q_>dG)\u001a9mKR,G\rV5nK6+GO]5d\u001d\u0006lW\rI\u0001\u000b[\u0016lwN]=Q_>dWCAAL!\u0011\tI*a(\u000e\u0005\u0005m%bAAOs\u00061Q.Z7pefLA!!)\u0002\u001c\nQQ*Z7pef\u0004vn\u001c7\u0002\u00175,Wn\u001c:z!>|G\u000eI\u0001\u0013I\u0006$\u0018\r\u00157b]\u0016\f5mY3qi>\u00148/\u0006\u0002\u0002*BA\u00111VA[\u0003s\u000b)-\u0004\u0002\u0002.*!\u0011qVAY\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003g\u000b\u0019&\u0001\u0003vi&d\u0017\u0002BA\\\u0003[\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\tY,!1\u000e\u0005\u0005u&bAA`'\u000691\r\\;ti\u0016\u0014\u0018\u0002BAb\u0003{\u0013\u0001\"\u00128e!>Lg\u000e\u001e\t\u0005\u0003w\t9-C\u0002\u0002JF\u0013\u0011\u0003R1uCBc\u0017M\\3BG\u000e,\u0007\u000f^8s\u0003M!\u0017\r^1QY\u0006tW-Q2dKB$xN]:!\u0003]!\u0017\r^1QY\u0006tWMU3rk\u0016\u001cHo\u00115b]:,G.\u0006\u0002\u0002RB!\u00111HAj\u0013\r\t).\u0015\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0003a!\u0017\r^1QY\u0006tWMU3rk\u0016\u001cHo\u00115b]:,G\u000eI\u0001\u0018G>tGO]8m!2\fg.Z!dG\u0016\u0004Ho\u001c:PaR,\"!!8\u0011\u000ba\u000by.a9\n\u0007\u0005\u0005\u0018L\u0001\u0004PaRLwN\u001c\t\u0005\u0003w\t)/C\u0002\u0002hF\u0013AcQ8oiJ|G\u000e\u00157b]\u0016\f5mY3qi>\u0014\u0018aG2p]R\u0014x\u000e\u001c)mC:,\u0017iY2faR|'o\u00149u?\u0012*\u0017\u000f\u0006\u0003\u0002n\u0006M\bc\u0001-\u0002p&\u0019\u0011\u0011_-\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003k|\u0012\u0011!a\u0001\u0003;\f1\u0001\u001f\u00132\u0003a\u0019wN\u001c;s_2\u0004F.\u00198f\u0003\u000e\u001cW\r\u001d;pe>\u0003H\u000fI\u0001\u001eG>tGO]8m!2\fg.\u001a*fcV,7\u000f^\"iC:tW\r\\(qiV\u0011\u0011Q \t\u00061\u0006}\u0017\u0011[\u0001\u001fG>tGO]8m!2\fg.\u001a*fcV,7\u000f^\"iC:tW\r\\(qi\u0002\nqB\\3yiB\u0013xnY3tg>\u0014\u0018\n\u001a\t\u0005\u0005\u000b\u0011Y!\u0004\u0002\u0003\b)!!\u0011BAW\u0003\u0019\tGo\\7jG&!!Q\u0002B\u0004\u00055\tEo\\7jG&sG/Z4fe\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u000b\u0003\u0005'\u0001B!a\u000f\u0003\u0016%\u0019!qC)\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\u0018!E2p]:,7\r^5p]F+x\u000e^1tA\u0005I2\u000f^1si\u0016$\u0007K]8dKN\u001c\u0018N\\4SKF,Xm\u001d;t+\t\u0011y\u0002E\u0002Y\u0005CI1Aa\tZ\u0005\u001d\u0011un\u001c7fC:\fQd\u001d;beR,G\r\u0015:pG\u0016\u001c8/\u001b8h%\u0016\fX/Z:ug~#S-\u001d\u000b\u0005\u0003[\u0014I\u0003C\u0005\u0002v\u001e\n\t\u00111\u0001\u0003 \u0005Q2\u000f^1si\u0016$\u0007K]8dKN\u001c\u0018N\\4SKF,Xm\u001d;tA\u0005I2\u000f^8qa\u0016$\u0007K]8dKN\u001c\u0018N\\4SKF,Xm\u001d;t\u0003u\u0019Ho\u001c9qK\u0012\u0004&o\\2fgNLgn\u001a*fcV,7\u000f^:`I\u0015\fH\u0003BAw\u0005gA\u0011\"!>+\u0003\u0003\u0005\rAa\b\u00025M$x\u000e\u001d9fIB\u0013xnY3tg&twMU3rk\u0016\u001cHo\u001d\u0011\u0015\u0005\u0005\u0005\u0014aB:uCJ$X\u000f\u001d\u000b\t\u0003[\u0014iD!\u0011\u0003H!I!qH\u0017\u0011\u0002\u0003\u0007!qD\u0001\u0018gR\f'\u000f\u001e)s_\u000e,7o]5oOJ+\u0017/^3tiND\u0011Ba\u0011.!\u0003\u0005\rA!\u0012\u0002)\r|g\u000e\u001e:pYBc\u0017M\\3MSN$XM\\3s!\u0015A\u0016q\\A]\u0011%\u0011I%\fI\u0001\u0002\u0004\u0011Y%\u0001\neCR\f\u0007\u000b\\1oK2K7\u000f^3oKJ\u001c\bC\u0002B'\u0005'\nI,\u0004\u0002\u0003P)\u0019!\u0011K-\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003V\t=#aA*fc\u0006\t2\u000f^1siV\u0004H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tm#\u0006\u0002B\u0010\u0005;Z#Aa\u0018\u0011\t\t\u0005$1N\u0007\u0003\u0005GRAA!\u001a\u0003h\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005SJ\u0016AC1o]>$\u0018\r^5p]&!!Q\u000eB2\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012gR\f'\u000f^;qI\u0011,g-Y;mi\u0012\u0012TC\u0001B:U\u0011\u0011)E!\u0018\u0002#M$\u0018M\u001d;va\u0012\"WMZ1vYR$3'\u0006\u0002\u0003z)\"!1\nB/)\u0011\tiO! \t\u0013\t}\u0014\u0007%AA\u0002\t\u0005\u0015!E1vi\"|'/\u001b>fe\u001a+H/\u001e:fgBA!Q\nBB\u0005\u000f\u0013i)\u0003\u0003\u0003\u0006\n=#aA'baB!\u0011q\u0011BE\u0013\r\u0011Y)\u001f\u0002\t\u000b:$\u0007o\\5oiB1\u00111\u0016BH\u0005'KAA!%\u0002.\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\u00055#QS\u0005\u0005\u0005/\u000byE\u0001\u0003W_&$\u0017!I:uCJ$\bK]8dKN\u001c\u0018N\\4SKF,Xm\u001d;tI\u0011,g-Y;mi\u0012\nTC\u0001BOU\u0011\u0011\tI!\u0018\u00025M$\u0018M\u001d;BG\u000e,\u0007\u000f^8s\u0003:$\u0007K]8dKN\u001cxN]:\u0015\r\u00055(1\u0015BW\u0011\u001d\u0011)k\ra\u0001\u0005O\u000b\u0001\"Y2dKB$xN\u001d\t\u0005\u0003w\u0011I+C\u0002\u0003,F\u0013\u0001\"Q2dKB$xN\u001d\u0005\n\u0005\u007f\u001a\u0004\u0013!a\u0001\u0005\u0003\u000bAe\u001d;beR\f5mY3qi>\u0014\u0018I\u001c3Qe>\u001cWm]:peN$C-\u001a4bk2$HEM\u0001%gR\f'\u000f\u001e#bi\u0006\u0004F.\u00198f!J|7-Z:t_J\u001c\u0018I\u001c3BG\u000e,\u0007\u000f^8sgR!\u0011Q\u001eB[\u0011\u001d\u0011y(\u000ea\u0001\u0005\u0003\u000bQe\u001d;beR\u001cuN\u001c;s_2\u0004F.\u00198f!J|7-Z:t_J\fe\u000eZ!dG\u0016\u0004Ho\u001c:\u0015\t\u00055(1\u0018\u0005\b\u0005\u007f2\u0004\u0019\u0001BA\u0003%)g\u000e\u001a9pS:$8/\u0006\u0002\u0003BBA!1\u0019Be\u0005\u0017\fI,\u0004\u0002\u0003F*!!q\u0019B(\u0003%IW.\\;uC\ndW-\u0003\u0003\u0003\u0006\n\u0015\u0007\u0003\u0002Bg\u0005#l!Aa4\u000b\u0005IK\u0018\u0002\u0002Bj\u0005\u001f\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016\fQe\u0019:fCR,G)\u0019;b!2\fg.Z!dG\u0016\u0004Ho\u001c:t\u0003:$\u0007K]8dKN\u001cxN]:\u0015\t\u00055(\u0011\u001c\u0005\b\u0005{C\u0004\u0019\u0001B&\u0003\u0019\u001a'/Z1uK\u000e{g\u000e\u001e:pYBc\u0017M\\3BG\u000e,\u0007\u000f^8s\u0003:$\u0007K]8dKN\u001cxN\u001d\u000b\u0005\u0003[\u0014y\u000eC\u0004\u0003bf\u0002\rA!\u0012\u0002\u0017\u0015tG\r]8j]R|\u0005\u000f^\u0001\u0018GJ,\u0017\r^3ECR\f\u0007\u000b\\1oK\u0006\u001b7-\u001a9u_J$\u0002\"!2\u0003h\n-(q\u001e\u0005\b\u0005ST\u0004\u0019AA]\u0003!)g\u000e\u001a)pS:$\bb\u0002Bwu\u0001\u0007!qD\u0001\u0015SN\u0004&/\u001b<jY\u0016<W\r\u001a'jgR,g.\u001a:\t\u000f\tE(\b1\u0001\u0002R\u0006q!/Z9vKN$8\t[1o]\u0016d\u0017AG2sK\u0006$XmQ8oiJ|G\u000e\u00157b]\u0016\f5mY3qi>\u0014HCBAr\u0005o\u0014I\u0010C\u0004\u0003jn\u0002\r!!/\t\u000f\tE8\b1\u0001\u0002R\u000612\u000f^8q!J|7-Z:tS:<'+Z9vKN$8\u000f\u0006\u0002\u0002n\u0006A1\u000f[;uI><h.A\u0005c_VtG\rU8siR!\u0011\u0011MB\u0003\u0011\u001d\u00199A\u0010a\u0001\u0005\u0017\fA\u0002\\5ti\u0016tWM\u001d(b[\u0016\fA\"\u00193e\u0019&\u001cH/\u001a8feN$B!!<\u0004\u000e!91qB A\u0002\t-\u0013A\u00047jgR,g.\u001a:t\u0003\u0012$W\rZ\u0001\u0010e\u0016lwN^3MSN$XM\\3sgR!\u0011Q^B\u000b\u0011\u001d\u00199\u0002\u0011a\u0001\u0005\u0017\n\u0001\u0003\\5ti\u0016tWM]:SK6|g/\u001a3\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u00111Q\u0004\t\u0007\u0005\u001b\u001ayba\t\n\t\r\u0005\"q\n\u0002\u0004'\u0016$\b\u0003BB\u0013\u0007gqAaa\n\u00040A\u00191\u0011F-\u000e\u0005\r-\"bAB\u0017+\u00061AH]8pizJ1a!\rZ\u0003\u0019\u0001&/\u001a3fM&!1QGB\u001c\u0005\u0019\u0019FO]5oO*\u00191\u0011G-\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tG\u0003BAw\u0007{Aaaa\u0010C\u0001\u0004\t\u0018!\u00038fo\u000e{gNZ5h\u0003-\u0011XmY8oM&<WO]3\u0015\r\u000558QIB%\u0011\u0019\u00199e\u0011a\u0001c\u0006Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\u0007\u0007\u007f\u0019\u0005\u0019A9\u0002/]\f\u0017\u000e\u001e$pe\u0006+H\u000f[8sSj,'OR;ukJ,GCBAw\u0007\u001f\u001a\t\u0006C\u0004\u0003&\u0012\u0003\rAa*\t\u000f\t}D\t1\u0001\u0003\u0002\u0006y1m\u001c8oK\u000e$\u0018n\u001c8D_VtG\u000f\u0006\u0003\u0002b\r]\u0003bBB-\u000b\u0002\u000711L\u0001\bC\u0012$'/Z:t!\u0011\u0019ifa\u0019\u000e\u0005\r}#\u0002BB1\u0003'\n1A\\3u\u0013\u0011\u0019)ga\u0018\u0003\u0017%sW\r^!eIJ,7o]\u0001\u0012I\u0006$\u0018\r\u00157b]\u0016\f5mY3qi>\u0014H\u0003BB6\u0007[\u0002R\u0001WAp\u0003\u000bDqaa\u0002G\u0001\u0004\u0019\u0019#\u0001\u0007T_\u000e\\W\r^*feZ,'\u000fE\u0002\u0002<!\u001b\"\u0001S,\u0015\u0005\rE\u0014\u0001D'fiJL7m]$s_V\u0004XCAB>!\u0011\tie! \n\t\rU\u0012qJ\u0001\u000e\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\u0011\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u00111Q\u0011\t\u0007\u0005\u001b\u001ayba\u001f\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0002\nQ\u0004T5ti\u0016tWM\u001d*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u0001\u001f\u0019&\u001cH/\u001a8feJ+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0002\u0002")
public class SocketServer
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final CredentialProvider credentialProvider;
    private final ApiVersionManager apiVersionManager;
    private final Integer maxQueuedRequests;
    private final int nodeId;
    private final LogContext logContext;
    private final Sensor memoryPoolSensor;
    private final MetricName memoryPoolDepletedPercentMetricName;
    private final MetricName memoryPoolDepletedTimeMetricName;
    private final MemoryPool memoryPool;
    private final ConcurrentHashMap<EndPoint, DataPlaneAcceptor> dataPlaneAcceptors;
    private final RequestChannel dataPlaneRequestChannel;
    private Option<ControlPlaneAcceptor> controlPlaneAcceptorOpt;
    private final Option<RequestChannel> controlPlaneRequestChannelOpt;
    private final AtomicInteger nextProcessorId;
    private final ConnectionQuotas connectionQuotas;
    private boolean startedProcessingRequests;
    private boolean stoppedProcessingRequests;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> ListenerReconfigurableConfigs() {
        return SocketServer$.MODULE$.ListenerReconfigurableConfigs();
    }

    public static Set<String> ReconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    public static String MetricsGroup() {
        return SocketServer$.MODULE$.MetricsGroup();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(com.yammer.metrics.core.MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Time time() {
        return this.time;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    private Integer maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public int nodeId() {
        return this.nodeId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private Sensor memoryPoolSensor() {
        return this.memoryPoolSensor;
    }

    private MetricName memoryPoolDepletedPercentMetricName() {
        return this.memoryPoolDepletedPercentMetricName;
    }

    private MetricName memoryPoolDepletedTimeMetricName() {
        return this.memoryPoolDepletedTimeMetricName;
    }

    private MemoryPool memoryPool() {
        return this.memoryPool;
    }

    public ConcurrentHashMap<EndPoint, DataPlaneAcceptor> dataPlaneAcceptors() {
        return this.dataPlaneAcceptors;
    }

    public RequestChannel dataPlaneRequestChannel() {
        return this.dataPlaneRequestChannel;
    }

    public Option<ControlPlaneAcceptor> controlPlaneAcceptorOpt() {
        return this.controlPlaneAcceptorOpt;
    }

    public void controlPlaneAcceptorOpt_$eq(Option<ControlPlaneAcceptor> x$1) {
        this.controlPlaneAcceptorOpt = x$1;
    }

    public Option<RequestChannel> controlPlaneRequestChannelOpt() {
        return this.controlPlaneRequestChannelOpt;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private boolean startedProcessingRequests() {
        return this.startedProcessingRequests;
    }

    private void startedProcessingRequests_$eq(boolean x$1) {
        this.startedProcessingRequests = x$1;
    }

    private boolean stoppedProcessingRequests() {
        return this.stoppedProcessingRequests;
    }

    private void stoppedProcessingRequests_$eq(boolean x$1) {
        this.stoppedProcessingRequests = x$1;
    }

    public int nextProcessorId() {
        return this.nextProcessorId.getAndIncrement();
    }

    public void startup(boolean startProcessingRequests, Option<EndPoint> controlPlaneListener, Seq<EndPoint> dataPlaneListeners) {
        synchronized (this) {
            this.createControlPlaneAcceptorAndProcessor(controlPlaneListener);
            this.createDataPlaneAcceptorsAndProcessors(dataPlaneListeners);
            if (startProcessingRequests) {
                this.startProcessingRequests(this.startProcessingRequests$default$1());
            }
        }
        Iterable dataPlaneProcessors = (Iterable)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().values().flatMap((Function1 & Serializable)a -> a.processors());
        Option controlPlaneProcessorOpt = this.controlPlaneAcceptorOpt().map((Function1 & Serializable)a -> (Processor)a.processors().apply(0));
        this.newGauge(new StringBuilder(30).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("NetworkProcessorAvgIdlePercent").toString(), new Gauge<Object>(this, dataPlaneProcessors){
            private final /* synthetic */ SocketServer $outer;
            private final Iterable dataPlaneProcessors$1;

            public final double value() {
                return this.$outer.kafka$network$SocketServer$$$anonfun$startup$3(this.dataPlaneProcessors$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataPlaneProcessors$1 = dataPlaneProcessors$1;
            }
        }, this.newGauge$default$3());
        this.newGauge(new StringBuilder(30).append(ControlPlaneAcceptor$.MODULE$.MetricPrefix()).append("NetworkProcessorAvgIdlePercent").toString(), new Gauge<Object>(this, controlPlaneProcessorOpt){
            private final /* synthetic */ SocketServer $outer;
            private final Option controlPlaneProcessorOpt$1;

            public final double value() {
                return this.$outer.kafka$network$SocketServer$$$anonfun$startup$9(this.controlPlaneProcessorOpt$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.controlPlaneProcessorOpt$1 = controlPlaneProcessorOpt$1;
            }
        }, this.newGauge$default$3());
        this.newGauge("MemoryPoolAvailable", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public final long value() {
                return this.$outer.kafka$network$SocketServer$$$anonfun$startup$16();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("MemoryPoolUsed", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public final long value() {
                return this.$outer.kafka$network$SocketServer$$$anonfun$startup$18();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge(new StringBuilder(29).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("ExpiredConnectionsKilledCount").toString(), new Gauge<Object>(this, dataPlaneProcessors){
            private final /* synthetic */ SocketServer $outer;
            private final Iterable dataPlaneProcessors$1;

            public final double value() {
                return this.$outer.kafka$network$SocketServer$$$anonfun$startup$20(this.dataPlaneProcessors$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataPlaneProcessors$1 = dataPlaneProcessors$1;
            }
        }, this.newGauge$default$3());
        this.newGauge(new StringBuilder(29).append(ControlPlaneAcceptor$.MODULE$.MetricPrefix()).append("ExpiredConnectionsKilledCount").toString(), new Gauge<Object>(this, controlPlaneProcessorOpt){
            private final /* synthetic */ SocketServer $outer;
            private final Option controlPlaneProcessorOpt$1;

            public final double value() {
                return this.$outer.kafka$network$SocketServer$$$anonfun$startup$26(this.controlPlaneProcessorOpt$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.controlPlaneProcessorOpt$1 = controlPlaneProcessorOpt$1;
            }
        }, this.newGauge$default$3());
    }

    public boolean startup$default$1() {
        return true;
    }

    public Option<EndPoint> startup$default$2() {
        return this.config().controlPlaneListener();
    }

    public Seq<EndPoint> startup$default$3() {
        return this.config().dataPlaneListeners();
    }

    public void startProcessingRequests(Map<Endpoint, CompletableFuture<Void>> authorizerFutures) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting socket server acceptors and processors");
        synchronized (this) {
            if (!this.startedProcessingRequests()) {
                this.startControlPlaneProcessorAndAcceptor(authorizerFutures);
                this.startDataPlaneProcessorsAndAcceptors(authorizerFutures);
                this.startedProcessingRequests_$eq(true);
            } else {
                this.info((Function0<String>)(Function0 & Serializable)() -> "Socket server acceptors and processors already started");
            }
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Started socket server acceptors and processors");
    }

    public Map<Endpoint, CompletableFuture<Void>> startProcessingRequests$default$1() {
        return (Map)Map$.MODULE$.empty();
    }

    private void startAcceptorAndProcessors(Acceptor acceptor, Map<Endpoint, CompletableFuture<Void>> authorizerFutures) {
        EndPoint endpoint = acceptor.endPoint();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Wait for authorizer to complete start up on listener ").append(endpoint.listenerName()).toString());
        this.waitForAuthorizerFuture(acceptor, authorizerFutures);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Start processors on listener ").append(endpoint.listenerName()).toString());
        acceptor.startProcessors();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Start acceptor thread on listener ").append(endpoint.listenerName()).toString());
        if (!acceptor.isStarted()) {
            String nonDaemon_name = new StringBuilder(25).append(acceptor.threadPrefix()).append("-kafka-socket-acceptor-").append(endpoint.listenerName()).append("-").append(endpoint.securityProtocol()).append("-").append(endpoint.port()).toString();
            Object var4_4 = null;
            new KafkaThread(nonDaemon_name, (Runnable)acceptor, false).start();
            acceptor.awaitStartup();
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Started ").append(acceptor.threadPrefix()).append(" acceptor and processor(s) for endpoint : ").append(endpoint.listenerName()).toString());
    }

    private Map<Endpoint, CompletableFuture<Void>> startAcceptorAndProcessors$default$2() {
        return (Map)Map$.MODULE$.empty();
    }

    private void startDataPlaneProcessorsAndAcceptors(Map<Endpoint, CompletableFuture<Void>> authorizerFutures) {
        Iterable iterable;
        Option interBrokerListener = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().keySet().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SocketServer.$anonfun$startDataPlaneProcessorsAndAcceptors$1(this, x$2)));
        if (interBrokerListener instanceof Some) {
            EndPoint interBrokerListener2 = (EndPoint)((Some)interBrokerListener).value();
            iterable = (Iterable)((IterableOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataPlaneAcceptor[]{this.dataPlaneAcceptors().get(interBrokerListener2)}))).$plus$plus((IterableOnce)((MapOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SocketServer.$anonfun$startDataPlaneProcessorsAndAcceptors$2(interBrokerListener2, x0$1)))).values());
        } else if (None$.MODULE$.equals(interBrokerListener)) {
            iterable = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().values();
        } else {
            throw new MatchError((Object)interBrokerListener);
        }
        iterable.foreach((Function1 & Serializable)acceptor -> {
            this.startAcceptorAndProcessors(acceptor, (Map<Endpoint, CompletableFuture<Void>>)authorizerFutures);
            return BoxedUnit.UNIT;
        });
    }

    private void startControlPlaneProcessorAndAcceptor(Map<Endpoint, CompletableFuture<Void>> authorizerFutures) {
        this.controlPlaneAcceptorOpt().foreach((Function1 & Serializable)controlPlaneAcceptor -> {
            this.startAcceptorAndProcessors(controlPlaneAcceptor, (Map<Endpoint, CompletableFuture<Void>>)authorizerFutures);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endpoints() {
        return ((IterableOnceOps)this.config().listeners().map((Function1 & Serializable)l -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)l.listenerName()), l))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void createDataPlaneAcceptorsAndProcessors(Seq<EndPoint> endpoints) {
        endpoints.foreach((Function1 & Serializable)endpoint -> {
            SocketServer.$anonfun$createDataPlaneAcceptorsAndProcessors$1(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    private void createControlPlaneAcceptorAndProcessor(Option<EndPoint> endpointOpt) {
        endpointOpt.foreach((Function1 & Serializable)endpoint -> {
            SocketServer.$anonfun$createControlPlaneAcceptorAndProcessor$1(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    public DataPlaneAcceptor createDataPlaneAcceptor(EndPoint endPoint, boolean isPrivilegedListener, RequestChannel requestChannel) {
        return new DataPlaneAcceptor(this, endPoint, this.config(), this.nodeId(), this.connectionQuotas(), this.time(), isPrivilegedListener, requestChannel, this.metrics(), this.credentialProvider(), this.logContext(), this.memoryPool(), this.apiVersionManager());
    }

    private ControlPlaneAcceptor createControlPlaneAcceptor(EndPoint endPoint, RequestChannel requestChannel) {
        return new ControlPlaneAcceptor(this, endPoint, this.config(), this.nodeId(), this.connectionQuotas(), this.time(), requestChannel, this.metrics(), this.credentialProvider(), this.logContext(), this.memoryPool(), this.apiVersionManager());
    }

    public void stopProcessingRequests() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopping socket server request processors");
        synchronized (this) {
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().values().foreach((Function1 & Serializable)x$3 -> {
                x$3.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().values().foreach((Function1 & Serializable)x$4 -> {
                x$4.awaitShutdown();
                return BoxedUnit.UNIT;
            });
            this.controlPlaneAcceptorOpt().foreach((Function1 & Serializable)x$5 -> {
                x$5.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            this.controlPlaneAcceptorOpt().foreach((Function1 & Serializable)x$6 -> {
                x$6.awaitShutdown();
                return BoxedUnit.UNIT;
            });
            this.dataPlaneRequestChannel().clear();
            this.controlPlaneRequestChannelOpt().foreach((Function1 & Serializable)x$7 -> {
                x$7.clear();
                return BoxedUnit.UNIT;
            });
            this.stoppedProcessingRequests_$eq(true);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopped socket server request processors");
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down socket server");
        synchronized (this) {
            if (!this.stoppedProcessingRequests()) {
                this.stopProcessingRequests();
            }
            this.dataPlaneRequestChannel().shutdown();
            this.controlPlaneRequestChannelOpt().foreach((Function1 & Serializable)x$8 -> {
                x$8.shutdown();
                return BoxedUnit.UNIT;
            });
            this.connectionQuotas().close();
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown completed");
    }

    public int boundPort(ListenerName listenerName) {
        int n;
        try {
            DataPlaneAcceptor acceptor = this.dataPlaneAcceptors().get(this.endpoints().apply((Object)listenerName));
            if (acceptor == null) {
                return BoxesRunTime.unboxToInt((Object)this.controlPlaneAcceptorOpt().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)SocketServer.$anonfun$boundPort$1(x$9))).getOrElse((Function0 & Serializable)() -> {
                    throw new KafkaException(new StringBuilder(61).append("Could not find listenerName : ").append(listenerName).append(" in data-plane or control-plane").toString());
                }));
            }
            n = acceptor.serverChannel().socket().getLocalPort();
        }
        catch (Exception e) {
            throw new KafkaException("Tried to check server's port before server was started or checked for port of non-existing protocol", (Throwable)e);
        }
        return n;
    }

    public synchronized void addListeners(Seq<EndPoint> listenersAdded) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Adding data-plane listeners for endpoints ").append(listenersAdded).toString());
        this.createDataPlaneAcceptorsAndProcessors(listenersAdded);
        listenersAdded.foreach((Function1 & Serializable)endpoint -> {
            SocketServer.$anonfun$addListeners$2(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeListeners(Seq<EndPoint> listenersRemoved) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Removing data-plane listeners for endpoints ").append(listenersRemoved).toString());
        listenersRemoved.foreach((Function1 & Serializable)endpoint -> {
            SocketServer.$anonfun$removeListeners$2(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Integer maxConnectionRate;
        Integer maxConnections;
        Map<String, Object> maxConnectionsPerIpOverrides;
        Integer maxConnectionsPerIp;
        Integer n = maxConnectionsPerIp = newConfig.maxConnectionsPerIp();
        Integer n2 = oldConfig.maxConnectionsPerIp();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Updating maxConnectionsPerIp: ").append(maxConnectionsPerIp).toString());
            this.connectionQuotas().updateMaxConnectionsPerIp(Predef$.MODULE$.Integer2int(maxConnectionsPerIp));
        }
        Map<String, Object> map = maxConnectionsPerIpOverrides = newConfig.maxConnectionsPerIpOverrides();
        Map<String, Object> map2 = oldConfig.maxConnectionsPerIpOverrides();
        if (map == null ? map2 != null : !map.equals(map2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Updating maxConnectionsPerIpOverrides: ").append(((IterableOnceOps)maxConnectionsPerIpOverrides.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String k = (String)x0$1._1();
                int v = x0$1._2$mcI$sp();
                String string = new StringBuilder(1).append(k).append("=").append(v).toString();
                return string;
            })).mkString(",")).toString());
            this.connectionQuotas().updateMaxConnectionsPerIpOverride(maxConnectionsPerIpOverrides);
        }
        Integer n3 = maxConnections = newConfig.maxConnections();
        Integer n4 = oldConfig.maxConnections();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Updating broker-wide maxConnections: ").append(maxConnections).toString());
            this.connectionQuotas().updateBrokerMaxConnections(Predef$.MODULE$.Integer2int(maxConnections));
        }
        Integer n5 = maxConnectionRate = newConfig.maxConnectionCreationRate();
        Integer n6 = oldConfig.maxConnectionCreationRate();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Updating broker-wide maxConnectionCreationRate: ").append(maxConnectionRate).toString());
            this.connectionQuotas().updateBrokerMaxConnectionRate(Predef$.MODULE$.Integer2int(maxConnectionRate));
        }
    }

    private void waitForAuthorizerFuture(Acceptor acceptor, Map<Endpoint, CompletableFuture<Void>> authorizerFutures) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(endpoint, future) -> {
            Optional optional = endpoint.listenerName();
            Optional<String> optional2 = Optional.of(acceptor.endPoint().listenerName().value());
            if (!(optional != null ? !((Object)optional).equals(optional2) : optional2 != null)) {
                return future.join();
            }
            return BoxedUnit.UNIT;
        };
        authorizerFutures.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    public int connectionCount(InetAddress address) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.connectionQuotas()).fold((Function0)(JFunction0.mcI.sp & Serializable)() -> 0, (Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.get(address))));
    }

    public Option<DataPlaneAcceptor> dataPlaneAcceptor(String listenerName) {
        Object object = new Object();
        try {
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().foreach((Function1 & Serializable)x0$1 -> {
                SocketServer.$anonfun$dataPlaneAcceptor$1(listenerName, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ double $anonfun$startup$7(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public static final /* synthetic */ double $anonfun$startup$5(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$startup$7(m))));
    }

    public final synchronized /* synthetic */ double kafka$network$SocketServer$$$anonfun$startup$3(Iterable dataPlaneProcessors$1) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((Iterable)dataPlaneProcessors$1.map((Function1 & Serializable)p -> this.metrics().metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), p.metricTags()))).map((Function1 & Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$startup$5(this, metricName)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)dataPlaneProcessors$1.size();
    }

    public static final /* synthetic */ double $anonfun$startup$13(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public static final /* synthetic */ double $anonfun$startup$11(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$startup$13(m))));
    }

    public final synchronized /* synthetic */ double kafka$network$SocketServer$$$anonfun$startup$9(Option controlPlaneProcessorOpt$1) {
        return BoxesRunTime.unboxToDouble((Object)controlPlaneProcessorOpt$1.map((Function1 & Serializable)p -> this.metrics().metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), p.metricTags())).map((Function1 & Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$startup$11(this, metricName))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> Double.NaN));
    }

    public final /* synthetic */ long kafka$network$SocketServer$$$anonfun$startup$16() {
        return this.memoryPool().availableMemory();
    }

    public final /* synthetic */ long kafka$network$SocketServer$$$anonfun$startup$18() {
        return this.memoryPool().size() - this.memoryPool().availableMemory();
    }

    public static final /* synthetic */ double $anonfun$startup$24(KafkaMetric m) {
        return BoxesRunTime.unboxToDouble((Object)m.metricValue());
    }

    public static final /* synthetic */ double $anonfun$startup$22(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$startup$24(m))));
    }

    public final synchronized /* synthetic */ double kafka$network$SocketServer$$$anonfun$startup$20(Iterable dataPlaneProcessors$1) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((Iterable)dataPlaneProcessors$1.map((Function1 & Serializable)p -> this.metrics().metricName("expired-connections-killed-count", SocketServer$.MODULE$.MetricsGroup(), p.metricTags()))).map((Function1 & Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$startup$22(this, metricName)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final /* synthetic */ double $anonfun$startup$30(KafkaMetric m) {
        return BoxesRunTime.unboxToDouble((Object)m.metricValue());
    }

    public static final /* synthetic */ double $anonfun$startup$28(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$startup$30(m))));
    }

    public final synchronized /* synthetic */ double kafka$network$SocketServer$$$anonfun$startup$26(Option controlPlaneProcessorOpt$1) {
        return BoxesRunTime.unboxToDouble((Object)controlPlaneProcessorOpt$1.map((Function1 & Serializable)p -> this.metrics().metricName("expired-connections-killed-count", SocketServer$.MODULE$.MetricsGroup(), p.metricTags())).map((Function1 & Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$startup$28(this, metricName))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
    }

    public static final /* synthetic */ boolean $anonfun$startDataPlaneProcessorsAndAcceptors$1(SocketServer $this, EndPoint x$2) {
        ListenerName listenerName = x$2.listenerName();
        ListenerName listenerName2 = $this.config().interBrokerListenerName();
        return !(listenerName != null ? !listenerName.equals(listenerName2) : listenerName2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$startDataPlaneProcessorsAndAcceptors$2(EndPoint interBrokerListener$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        EndPoint endPoint = (EndPoint)x0$1._1();
        boolean bl = endPoint == null ? interBrokerListener$1 != null : !((Object)endPoint).equals(interBrokerListener$1);
        return bl;
    }

    public static final /* synthetic */ String $anonfun$createDataPlaneAcceptorsAndProcessors$2(EndPoint endpoint$2) {
        return new StringBuilder(58).append("Created data-plane acceptor and processors for endpoint : ").append(endpoint$2.listenerName()).toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$createDataPlaneAcceptorsAndProcessors$1(SocketServer $this, EndPoint endpoint) {
        parsedConfigs = $this.config().valuesFromThisConfigWithPrefixOverride(endpoint.listenerName().configPrefix());
        $this.connectionQuotas().addListener($this.config(), endpoint.listenerName());
        if (!$this.controlPlaneRequestChannelOpt().isEmpty()) ** GOTO lbl-1000
        v0 = $this.config().interBrokerListenerName();
        var4_3 = endpoint.listenerName();
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isPrivilegedListener = v1;
        dataPlaneAcceptor = $this.createDataPlaneAcceptor(endpoint, isPrivilegedListener, $this.dataPlaneRequestChannel());
        $this.config().addReconfigurable((Reconfigurable)dataPlaneAcceptor);
        dataPlaneAcceptor.configure(parsedConfigs);
        $this.dataPlaneAcceptors().put(endpoint, dataPlaneAcceptor);
        $this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$createDataPlaneAcceptorsAndProcessors$2(kafka.cluster.EndPoint ), ()Ljava/lang/String;)((EndPoint)endpoint));
    }

    public static final /* synthetic */ void $anonfun$createControlPlaneAcceptorAndProcessor$1(SocketServer $this, EndPoint endpoint) {
        $this.connectionQuotas().addListener($this.config(), endpoint.listenerName());
        ControlPlaneAcceptor controlPlaneAcceptor = $this.createControlPlaneAcceptor(endpoint, (RequestChannel)$this.controlPlaneRequestChannelOpt().get());
        controlPlaneAcceptor.addProcessors(1);
        $this.controlPlaneAcceptorOpt_$eq((Option<ControlPlaneAcceptor>)new Some((Object)controlPlaneAcceptor));
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Created control-plane acceptor and processor for endpoint : ").append(endpoint.listenerName()).toString());
    }

    public static final /* synthetic */ int $anonfun$boundPort$1(ControlPlaneAcceptor x$9) {
        return x$9.serverChannel().socket().getLocalPort();
    }

    public static final /* synthetic */ void $anonfun$addListeners$2(SocketServer $this, EndPoint endpoint) {
        DataPlaneAcceptor acceptor = $this.dataPlaneAcceptors().get(endpoint);
        $this.startAcceptorAndProcessors(acceptor, (Map<Endpoint, CompletableFuture<Void>>)((Map)Map$.MODULE$.empty()));
    }

    public static final /* synthetic */ void $anonfun$removeListeners$3(DataPlaneAcceptor acceptor) {
        acceptor.initiateShutdown();
        acceptor.awaitShutdown();
    }

    public static final /* synthetic */ void $anonfun$removeListeners$2(SocketServer $this, EndPoint endpoint) {
        $this.connectionQuotas().removeListener($this.config(), endpoint.listenerName());
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.dataPlaneAcceptors()).asScala().remove((Object)endpoint).foreach((Function1 & Serializable)acceptor -> {
            SocketServer.$anonfun$removeListeners$3(acceptor);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$dataPlaneAcceptor$1(String listenerName$2, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        block7: {
            block4: {
                DataPlaneAcceptor acceptor;
                block6: {
                    String string;
                    block5: {
                        if (x0$1 == null) break block4;
                        EndPoint endPoint = (EndPoint)x0$1._1();
                        acceptor = (DataPlaneAcceptor)x0$1._2();
                        string = endPoint.listenerName().value();
                        if (string != null) break block5;
                        if (listenerName$2 != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!string.equals(listenerName$2)) break block7;
                }
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)acceptor));
            }
            throw new MatchError(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SocketServer(KafkaConfig config, Metrics metrics, Time time, CredentialProvider credentialProvider, ApiVersionManager apiVersionManager) {
        void add_stat;
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.credentialProvider = credentialProvider;
        this.apiVersionManager = apiVersionManager;
        this.maxQueuedRequests = config.queuedMaxRequests();
        this.nodeId = config.brokerId();
        this.logContext = new LogContext(new StringBuilder(38).append("[SocketServer listenerType=").append(apiVersionManager.listenerType()).append(", nodeId=").append(this.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.memoryPoolSensor = metrics.sensor("MemoryPoolUtilization");
        this.memoryPoolDepletedPercentMetricName = metrics.metricName("MemoryPoolAvgDepletedPercent", SocketServer$.MODULE$.MetricsGroup());
        this.memoryPoolDepletedTimeMetricName = metrics.metricName("MemoryPoolDepletedTimeTotal", SocketServer$.MODULE$.MetricsGroup());
        Sensor sensor = this.memoryPoolSensor();
        org.apache.kafka.common.metrics.stats.Meter meter = new org.apache.kafka.common.metrics.stats.Meter(TimeUnit.MILLISECONDS, this.memoryPoolDepletedPercentMetricName(), this.memoryPoolDepletedTimeMetricName());
        if (sensor == null) {
            throw null;
        }
        sensor.add((CompoundStat)add_stat, null);
        meter = null;
        this.memoryPool = Predef$.MODULE$.Long2long(config.queuedMaxBytes()) > 0L ? new SimpleMemoryPool(Predef$.MODULE$.Long2long(config.queuedMaxBytes()), Predef$.MODULE$.Integer2int(config.socketRequestMaxBytes()), false, this.memoryPoolSensor()) : MemoryPool.NONE;
        this.dataPlaneAcceptors = new ConcurrentHashMap();
        this.dataPlaneRequestChannel = new RequestChannel(Predef$.MODULE$.Integer2int(this.maxQueuedRequests()), DataPlaneAcceptor$.MODULE$.MetricPrefix(), time, apiVersionManager.newRequestMetrics());
        this.controlPlaneAcceptorOpt = None$.MODULE$;
        this.controlPlaneRequestChannelOpt = config.controlPlaneListenerName().map((Function1 & Serializable)x$1 -> new RequestChannel(20, ControlPlaneAcceptor$.MODULE$.MetricPrefix(), this.time(), this.apiVersionManager().newRequestMetrics()));
        this.nextProcessorId = new AtomicInteger(0);
        this.connectionQuotas = new ConnectionQuotas(config, time, metrics);
        this.startedProcessingRequests = false;
        this.stoppedProcessingRequests = false;
    }
}

