/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigAdminManager$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.FinalizedFeatureCache;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MetadataPublisher;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.AclsDelta;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0005\rx!B\u000e\u001d\u0011\u0003\u0019c!B\u0013\u001d\u0011\u00031\u0003\"B\u001a\u0002\t\u0003!\u0004\"B\u001b\u0002\t\u00031\u0004\"\u0002/\u0002\t\u0003if!B\u0013\u001d\u0001\u0005\u0005\u0001BCA\u0005\u000b\t\u0005\t\u0015!\u0003\u0002\f!Q\u00111C\u0003\u0003\u0002\u0003\u0006I!!\u0006\t\u0015\u0005mQA!A!\u0002\u0013\ti\u0002\u0003\u0006\u0002$\u0015\u0011\t\u0011)A\u0005\u0003KA!\"a\u000b\u0006\u0005\u0003\u0005\u000b\u0011BA\u0017\u0011)\ti$\u0002B\u0001B\u0003%\u0011q\b\u0005\u000b\u0003\u0017*!\u0011!Q\u0001\n\u00055\u0003BCA*\u000b\t\u0005\t\u0015!\u0003\u0002V!Q\u00111L\u0003\u0003\u0002\u0003\u0006I!!\u0018\t\u0015\u0005%TA!b\u0001\n\u0013\tY\u0007\u0003\u0006\u0002~\u0015\u0011\t\u0011)A\u0005\u0003[BaaM\u0003\u0005\u0002\u0005}\u0004\u0002\u00038\u0006\u0005\u0004%\t!a&\t\u000f\u0005eU\u0001)A\u0005_\"I\u00111T\u0003A\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0003K+\u0001\u0019!C\u0001\u0003OC\u0001\"a-\u0006A\u0003&\u0011q\u0014\u0005\b\u0003k+A\u0011IA\\\u0011\u001d\ti,\u0002C\u0005\u0003\u007fCq!!7\u0006\t\u0013\tY\u000eC\u0004\u0002^\u0016!I!a8\u0002/\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014(BA\u000f\u001f\u0003!iW\r^1eCR\f'BA\u0010!\u0003\u0019\u0019XM\u001d<fe*\t\u0011%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u0011\nQ\"\u0001\u000f\u0003/\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u00148cA\u0001([A\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u0011\u0002\u000bU$\u0018\u000e\\:\n\u0005Iz#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\nQbZ3u)>\u0004\u0018n\u0019#fYR\fG\u0003B\u001cF%^\u00032\u0001\u000b\u001d;\u0013\tI\u0014F\u0001\u0004PaRLwN\u001c\t\u0003w\rk\u0011\u0001\u0010\u0006\u0003{y\nQ![7bO\u0016T!!I \u000b\u0005\u0001\u000b\u0015AB1qC\u000eDWMC\u0001C\u0003\ry'oZ\u0005\u0003\tr\u0012!\u0002V8qS\u000e$U\r\u001c;b\u0011\u001515\u00011\u0001H\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0002I\u001f:\u0011\u0011*\u0014\t\u0003\u0015&j\u0011a\u0013\u0006\u0003\u0019\n\na\u0001\u0010:p_Rt\u0014B\u0001(*\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059K\u0003\"B*\u0004\u0001\u0004!\u0016\u0001\u00038fo&k\u0017mZ3\u0011\u0005m*\u0016B\u0001,=\u00055iU\r^1eCR\f\u0017*\\1hK\")\u0001l\u0001a\u00013\u0006)A-\u001a7uCB\u00111HW\u0005\u00037r\u0012Q\"T3uC\u0012\fG/\u0019#fYR\f\u0017a\u00054j]\u0012\u001cFO]1z!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u00020ne^\u00042a\u00183h\u001d\t\u0001'M\u0004\u0002KC&\t!&\u0003\u0002dS\u00059\u0001/Y2lC\u001e,\u0017BA3g\u0005!IE/\u001a:bE2,'BA2*!\tA7.D\u0001j\u0015\tQg(\u0001\u0004d_6lwN\\\u0005\u0003Y&\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003o\t\u0001\u0007q.\u0001\u0005ce>\\WM]%e!\tA\u0003/\u0003\u0002rS\t\u0019\u0011J\u001c;\t\u000bM$\u0001\u0019\u0001;\u0002\u001d9,w\u000fV8qS\u000e\u001c\u0018*\\1hKB\u00111(^\u0005\u0003mr\u00121\u0002V8qS\u000e\u001c\u0018*\\1hK\")\u0001\u0010\u0002a\u0001s\u0006!An\\4t!\ryFM\u001f\t\u0003wzl\u0011\u0001 \u0006\u0003{\u0002\n1\u0001\\8h\u0013\tyHP\u0001\u0006V]&4\u0017.\u001a3M_\u001e\u001cR!B\u0014\u0002\u00045\u00022\u0001JA\u0003\u0013\r\t9\u0001\b\u0002\u0012\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014\u0018\u0001B2p]\u001a\u0004B!!\u0004\u0002\u00105\ta$C\u0002\u0002\u0012y\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u00042\u0001JA\f\u0013\r\tI\u0002\b\u0002\u0013\u0017J\u000bg\r^'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\u0006m_\u001el\u0015M\\1hKJ\u00042a_A\u0010\u0013\r\t\t\u0003 \u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0005\u0003\u001b\t9#C\u0002\u0002*y\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\the>,\boQ8pe\u0012Lg.\u0019;peB!\u0011qFA\u001d\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012!B4s_V\u0004(bAA\u001cA\u0005Y1m\\8sI&t\u0017\r^8s\u0013\u0011\tY$!\r\u0003!\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018A\u0004;y]\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)!\u0011QIA\u001b\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005%\u00131\t\u0002\u0017)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\u0006Q2\r\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4feB\u0019A%a\u0014\n\u0007\u0005ECD\u0001\u000eDY&,g\u000e^)v_R\fW*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\u0007gK\u0006$XO]3DC\u000eDW\r\u0005\u0003\u0002\u000e\u0005]\u0013bAA-=\t)b)\u001b8bY&TX\r\u001a$fCR,(/Z\"bG\",\u0017!\u00063z]\u0006l\u0017nY\"p]\u001aLw\rS1oI2,'o\u001d\t\u0007\u0011\u0006}s)a\u0019\n\u0007\u0005\u0005\u0014KA\u0002NCB\u0004B!!\u0004\u0002f%\u0019\u0011q\r\u0010\u0003\u001b\r{gNZ5h\u0011\u0006tG\r\\3s\u0003-y\u0016-\u001e;i_JL'0\u001a:\u0016\u0005\u00055\u0004\u0003\u0002\u00159\u0003_\u0002B!!\u001d\u0002z5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(\u0001\u0006bkRDwN]5{KJT!a\b \n\t\u0005m\u00141\u000f\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018\u0001D0bkRDwN]5{KJ\u0004CCFAA\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0015QRAH\u0003#\u000b\u0019*!&\u0011\u0005\u0011*\u0001bBA\u0005#\u0001\u0007\u00111\u0002\u0005\b\u0003'\t\u0002\u0019AA\u000b\u0011\u001d\tY\"\u0005a\u0001\u0003;Aq!a\t\u0012\u0001\u0004\t)\u0003C\u0004\u0002,E\u0001\r!!\f\t\u000f\u0005u\u0012\u00031\u0001\u0002@!9\u00111J\tA\u0002\u00055\u0003bBA*#\u0001\u0007\u0011Q\u000b\u0005\b\u00037\n\u0002\u0019AA/\u0011\u001d\tI'\u0005a\u0001\u0003[*\u0012a\\\u0001\nEJ|7.\u001a:JI\u0002\nQb\u00184jeN$\b+\u001e2mSNDWCAAP!\rA\u0013\u0011U\u0005\u0004\u0003GK#a\u0002\"p_2,\u0017M\\\u0001\u0012?\u001aL'o\u001d;Qk\nd\u0017n\u001d5`I\u0015\fH\u0003BAU\u0003_\u00032\u0001KAV\u0013\r\ti+\u000b\u0002\u0005+:LG\u000fC\u0005\u00022V\t\t\u00111\u0001\u0002 \u0006\u0019\u0001\u0010J\u0019\u0002\u001d}3\u0017N]:u!V\u0014G.[:iA\u00059\u0001/\u001e2mSNDGCBAU\u0003s\u000bY\fC\u0003Y/\u0001\u0007\u0011\fC\u0003T/\u0001\u0007A+A\tva\u0012\fG/Z\"p_J$\u0017N\\1u_J$B\"!+\u0002B\u0006\r\u0017QYAd\u0003#DQ!\u0010\rA\u0002QCQ\u0001\u0017\rA\u0002eCQA\u0012\rA\u0002\u001dCq!!3\u0019\u0001\u0004\tY-\u0001\u0005fY\u0016\u001cG/[8o!\u001dA\u0013QZ8p\u0003SK1!a4*\u0005%1UO\\2uS>t'\u0007C\u0004\u0002Tb\u0001\r!!6\u0002\u0017I,7/[4oCRLwN\u001c\t\tQ\u00055w.a6\u0002*B\u0019\u0001\u0006O8\u0002%%t\u0017\u000e^5bY&TX-T1oC\u001e,'o\u001d\u000b\u0003\u0003S\u000b\u0001EZ5oSND\u0017J\\5uS\u0006d\u0017N_5oOJ+\u0007\u000f\\5dC6\u000bg.Y4feR!\u0011\u0011VAq\u0011\u0015\u0019&\u00041\u0001U\u0001")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig conf;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ClientQuotaMetadataManager clientQuotaMetadataManager;
    private final FinalizedFeatureCache featureCache;
    private final Map<String, ConfigHandler> dynamicConfigHandlers;
    private final Option<Authorizer> _authorizer;
    private final int brokerId;
    private boolean _firstPublish;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Iterable<TopicPartition> findStrayPartitions(int brokerId, TopicsImage newTopicsImage, Iterable<UnifiedLog> logs) {
        return BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, newTopicsImage, logs);
    }

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Option<Authorizer> _authorizer() {
        return this._authorizer;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    @Override
    public void publish(MetadataDelta delta, MetadataImage newImage) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        try {
            try {
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                this.metadataCache.setImage(newImage);
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(".").toString());
                    this.initializeManagers();
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.featuresDelta()).foreach((Function1 & Serializable)featuresDelta -> {
                    this.featureCache.update(featuresDelta, highestOffsetAndEpoch.offset);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$5(this, newImage, delta, topicsDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.configsDelta()).foreach((Function1 & Serializable)configsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$12(this, newImage, configsDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.clientQuotasDelta()).foreach((Function1 & Serializable)clientQuotasDelta -> {
                    this.clientQuotaMetadataManager.update(clientQuotasDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.aclsDelta()).foreach((Function1 & Serializable)aclsDelta -> {
                    BrokerMetadataPublisher.$anonfun$publish$18(this, newImage, aclsDelta);
                    return BoxedUnit.UNIT;
                });
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager(newImage);
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Error publishing broker metadata at ").append(highestOffsetAndEpoch).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw t;
            }
        }
        finally {
            this._firstPublish_$eq(false);
        }
    }

    private void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$1(this, topicName, resignation, topicsDelta);
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$3(this, resignation, election, topicDelta);
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers() {
        this.logManager.startup(this.metadataCache.getAllTopics());
        Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable)reconfigurable -> {
            BrokerMetadataPublisher.$anonfun$initializeManagers$1(this, reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.replicaManager.startup();
        this.groupCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.offsetsTopicPartitions()))), this.groupCoordinator.startup$default$2());
        this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
    }

    private void finishInitializingReplicaManager(MetadataImage newImage) {
        Iterable<TopicPartition> strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(this.brokerId(), newImage.topics(), this.logManager.allLogs());
        if (strayPartitions.nonEmpty()) {
            this.replicaManager.deleteStrayReplicas(strayPartitions);
        }
        this.replicaManager.startHighWatermarkCheckPointThread();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$publish$5(BrokerMetadataPublisher $this, MetadataImage newImage$1, MetadataDelta delta$2, TopicsDelta topicsDelta) {
        void updateCoordinator_election;
        void updateCoordinator_resignation;
        void updateCoordinator_election2;
        void updateCoordinator_resignation2;
        $this.replicaManager.applyDelta(topicsDelta, newImage$1);
        Function2 & Serializable intersect = (Function2 & Serializable)(offsetTopicPartitionId, coordinatorEpoch) -> {
            $this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)offsetTopicPartitionId), (Option<Object>)coordinatorEpoch);
            return BoxedUnit.UNIT;
        };
        JFunction2.mcVII.sp & Serializable intersect2 = (JFunction2.mcVII.sp & Serializable)(offsetTopicPartitionId, coordinatorEpoch) -> $this.groupCoordinator.onElection(offsetTopicPartitionId, coordinatorEpoch);
        String updateCoordinator_topicName = "__consumer_offsets";
        Option$.MODULE$.apply((Object)delta$2.topicsDelta()).foreach(arg_0 -> BrokerMetadataPublisher.$anonfun$updateCoordinator$1$adapted($this, updateCoordinator_topicName, (Function2)updateCoordinator_resignation2, arg_0));
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(updateCoordinator_topicName, newImage$1, delta$2).foreach(arg_0 -> BrokerMetadataPublisher.$anonfun$updateCoordinator$3$adapted($this, (Function2)updateCoordinator_resignation2, (Function2)updateCoordinator_election2, arg_0));
        Object var5_6 = null;
        intersect2 = null;
        intersect = null;
        Function2 & Serializable intersect3 = (Function2 & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
            $this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
            return BoxedUnit.UNIT;
        };
        JFunction2.mcVII.sp & Serializable intersect4 = (JFunction2.mcVII.sp & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch);
        String updateCoordinator_topicName2 = "__transaction_state";
        Option$.MODULE$.apply((Object)delta$2.topicsDelta()).foreach(arg_0 -> BrokerMetadataPublisher.$anonfun$updateCoordinator$1$adapted($this, updateCoordinator_topicName2, (Function2)updateCoordinator_resignation, arg_0));
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(updateCoordinator_topicName2, newImage$1, delta$2).foreach(arg_0 -> BrokerMetadataPublisher.$anonfun$updateCoordinator$3$adapted($this, (Function2)updateCoordinator_resignation, (Function2)updateCoordinator_election, arg_0));
        Object var8_9 = null;
        intersect4 = null;
        intersect3 = null;
        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
        topicsDelta.deletedTopicIds().forEach(id2 -> {
            TopicImage topicImage = topicsDelta.image().getTopic(id2);
            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
        });
        if (deletedTopicPartitions.nonEmpty()) {
            $this.groupCoordinator.handleDeletedPartitions((Seq<TopicPartition>)deletedTopicPartitions, RequestLocal$.MODULE$.NoCaching());
        }
    }

    public static final /* synthetic */ void $anonfun$publish$12(BrokerMetadataPublisher $this, MetadataImage newImage$1, ConfigurationsDelta configsDelta) {
        configsDelta.changes().keySet().forEach(resource -> {
            Properties props = newImage$1.configs().configProperties(resource);
            ConfigResource.Type type = resource.type();
            if (ConfigResource.Type.TOPIC.equals(type)) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(41).append("Updating topic ").append(resource.name()).append(" with new configuration : ").toString()).append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Topic())).processConfigChanges(resource.name(), props);
                $this.conf.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
                return;
            }
            if (ConfigResource.Type.BROKER.equals(type)) {
                if (resource.name().isEmpty()) {
                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Updating cluster configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                    ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Broker())).processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
                    return;
                }
                if (resource.name().equals(Integer.toString($this.brokerId()))) {
                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Updating broker ").append($this.brokerId()).append(" with new configuration : ").toString()).append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                    ((ConfigHandler)$this.dynamicConfigHandlers.apply((Object)ConfigType$.MODULE$.Broker())).processConfigChanges(resource.name(), props);
                    return;
                }
            }
        });
    }

    public static final /* synthetic */ void $anonfun$publish$18(BrokerMetadataPublisher $this, MetadataImage newImage$1, AclsDelta aclsDelta) {
        Authorizer authorizer;
        Option<Authorizer> option = $this._authorizer();
        if (option instanceof Some && (authorizer = (Authorizer)((Some)option).value()) instanceof ClusterMetadataAuthorizer) {
            ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)authorizer;
            if (aclsDelta.isSnapshotDelta()) {
                clusterMetadataAuthorizer.loadSnapshot(newImage$1.acls().acls());
                return;
            }
            aclsDelta.changes().entrySet().forEach(e -> {
                if (((Optional)e.getValue()).isPresent()) {
                    clusterMetadataAuthorizer.addAcl((Uuid)e.getKey(), (StandardAcl)((Optional)e.getValue()).get());
                    return;
                }
                clusterMetadataAuthorizer.removeAcl((Uuid)e.getKey());
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                }
            });
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> election$1.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$1(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.conf.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(KafkaConfig conf, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ClientQuotaMetadataManager clientQuotaMetadataManager, FinalizedFeatureCache featureCache, Map<String, ConfigHandler> dynamicConfigHandlers, Option<Authorizer> _authorizer) {
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.clientQuotaMetadataManager = clientQuotaMetadataManager;
        this.featureCache = featureCache;
        this.dynamicConfigHandlers = dynamicConfigHandlers;
        this._authorizer = _authorizer;
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(conf.nodeId()).append("] ").toString());
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
    }
}

