/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.Partition;
import kafka.cluster.PendingShrinkIsr;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader;
import kafka.log.LogManager;
import kafka.log.LogSegments;
import kafka.log.ProducerStateManager;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t-h\u0001\u0002\u001c8\u0001qBQ!\u0013\u0001\u0005\u0002)Cq!\u0014\u0001C\u0002\u0013\u0005a\n\u0003\u0004S\u0001\u0001\u0006Ia\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0001O\u0011\u0019!\u0006\u0001)A\u0005\u001f\"9Q\u000b\u0001b\u0001\n\u0003q\u0005B\u0002,\u0001A\u0003%q\nC\u0004X\u0001\t\u0007I\u0011\u0001-\t\rq\u0003\u0001\u0015!\u0003Z\u0011\u001di\u0006A1A\u0005\u0002yCaa\u001a\u0001!\u0002\u0013y\u0006b\u00025\u0001\u0005\u0004%\tA\u0018\u0005\u0007S\u0002\u0001\u000b\u0011B0\t\u000f)\u0004!\u0019!C\u0001W\"1A\u000f\u0001Q\u0001\n1Dq!\u001e\u0001C\u0002\u0013\u0005a\u000f\u0003\u0004{\u0001\u0001\u0006Ia\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0001w\u0011\u0019a\b\u0001)A\u0005o\"9Q\u0010\u0001b\u0001\n\u0003q\bbBA\u0018\u0001\u0001\u0006Ia \u0005\f\u0003c\u0001\u0001\u0019!a\u0001\n\u0003\t\u0019\u0004C\u0006\u0002B\u0001\u0001\r\u00111A\u0005\u0002\u0005\r\u0003bCA(\u0001\u0001\u0007\t\u0011)Q\u0005\u0003kA1\"!\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002T!Y\u00111\f\u0001A\u0002\u0003\u0007I\u0011AA/\u0011-\t\t\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u0016\t\u0013\u0005\r\u0004A1A\u0005\n\u0005\u0015\u0004\u0002CA8\u0001\u0001\u0006I!a\u001a\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u00111\u0012\u0001\u0005\u0002\u0005M\u0004bBAK\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003?\u0003A\u0011AA:\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003gBq!a*\u0001\t\u0003\t\u0019\bC\u0004\u0002,\u0002!I!a\u001d\t\u000f\u00055\u0006\u0001\"\u0003\u0002t!9\u0011q\u0016\u0001\u0005\n\u0005E\u0006bBAu\u0001\u0011%\u00111\u001e\u0005\b\u0003{\u0004A\u0011BA\u0000\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005OAqAa\u000b\u0001\t\u0013\u0011i\u0003C\u0004\u0003R\u0001!IAa\u0015\t\u000f\tu\u0003\u0001\"\u0003\u0003`\u00191!Q\u000e\u0001\u0005\u0005_B!\"a\u000f.\u0005\u0003\u0005\u000b\u0011\u0002B9\u0011)\u00119(\fB\u0001B\u0003%!q\u0004\u0005\u000b\u0005sj#\u0011!Q\u0001\n\tm\u0004B\u0003BA[\t\u0005\t\u0015!\u0003\u0003\u0004\"a!\u0011T\u0017\u0003\u0002\u0003\u0006IAa'\u0003\"\"AQ/\fB\u0001B\u0003%q\u000f\u0003\u0004J[\u0011\u0005!1\u0015\u0005\b\u0005kkC\u0011\tB\\\u0005E\u0001\u0016M\u001d;ji&|g\u000eT8dWR+7\u000f\u001e\u0006\u0003qe\nqa\u00197vgR,'OC\u0001;\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u001fD!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0019\te.\u001f*fMB\u0011AiR\u0007\u0002\u000b*\u0011a)O\u0001\u0006kRLGn]\u0005\u0003\u0011\u0016\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017B\u0011A\nA\u0007\u0002o\u0005\u0011b.^7SKBd\u0017nY1GKR\u001c\u0007.\u001a:t+\u0005y\u0005C\u0001 Q\u0013\t\tvHA\u0002J]R\f1C\\;n%\u0016\u0004H.[2b\r\u0016$8\r[3sg\u0002\nAB\\;n!J|G-^2feN\fQB\\;n!J|G-^2feN\u0004\u0013!\u00068v[J+7m\u001c:egB+'\u000f\u0015:pIV\u001cWM]\u0001\u0017]Vl'+Z2pe\u0012\u001c\b+\u001a:Qe>$WoY3sA\u0005AQn\\2l)&lW-F\u0001Z!\t!%,\u0003\u0002\\\u000b\nAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u00051A/\u001c9ESJ,\u0012a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\f!![8\u000b\u0003\u0011\fAA[1wC&\u0011a-\u0019\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nq\"\u001a=fGV$xN]*feZL7-Z\u000b\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\u000bG>t7-\u001e:sK:$(BA9d\u0003\u0011)H/\u001b7\n\u0005Mt'aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002!\u0015DXmY;u_J\u001cVM\u001d<jG\u0016\u0004\u0013aD1qa\u0016tGmU3nCBDwN]3\u0016\u0003]\u0004\"!\u001c=\n\u0005et'!C*f[\u0006\u0004\bn\u001c:f\u0003A\t\u0007\u000f]3oIN+W.\u00199i_J,\u0007%\u0001\ntQJLgn[%teN+W.\u00199i_J,\u0017aE:ie&t7.S:s'\u0016l\u0017\r\u001d5pe\u0016\u0004\u0013A\u00044pY2|w/\u001a:Rk\u0016,Xm]\u000b\u0002\u007fB1\u0011\u0011AA\u0006\u0003\u001fi!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\nS6lW\u000f^1cY\u0016T1!!\u0003@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\t\u0019A\u0001\u0006J]\u0012,\u00070\u001a3TKF\u0004R!\\A\t\u0003+I1!a\u0005o\u0005I\t%O]1z\u00052|7m[5oOF+X-^3\u0011\t\u0005]\u00111F\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u00051!/Z2pe\u0012TA!a\b\u0002\"\u000511m\\7n_:T1AOA\u0012\u0015\u0011\t)#a\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI#A\u0002pe\u001eLA!!\f\u0002\u001a\tiQ*Z7pef\u0014VmY8sIN\fqBZ8mY><XM])vKV,7\u000fI\u0001\u000bY><W*\u00198bO\u0016\u0014XCAA\u001b!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001es\u0005\u0019An\\4\n\t\u0005}\u0012\u0011\b\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003\u000b\nY\u0005E\u0002?\u0003\u000fJ1!!\u0013@\u0005\u0011)f.\u001b;\t\u0013\u00055s#!AA\u0002\u0005U\u0012a\u0001=%c\u0005YAn\\4NC:\fw-\u001a:!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002VA\u0019A*a\u0016\n\u0007\u0005esGA\u0005QCJ$\u0018\u000e^5p]\u0006i\u0001/\u0019:uSRLwN\\0%KF$B!!\u0012\u0002`!I\u0011Q\n\u000e\u0002\u0002\u0003\u0007\u0011QK\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003O\u0002B!!\u001b\u0002l5\u0011\u0011QD\u0005\u0005\u0003[\niB\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nQa]3u+B$\"!!\u0012)\u0007y\t9\b\u0005\u0003\u0002z\u0005\u001dUBAA>\u0015\u0011\ti(a \u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0002\u0006\r\u0015a\u00026va&$XM\u001d\u0006\u0005\u0003\u000b\u000b9#A\u0003kk:LG/\u0003\u0003\u0002\n\u0006m$A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002 \u0003\u001f\u0003B!!\u001f\u0002\u0012&!\u00111SA>\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0013uKN$hj\u001c'pG.\u001cuN\u001c;f]RLwN\\,ji\"|W\u000f^%teV\u0003H-\u0019;fQ\r\u0001\u0013\u0011\u0014\t\u0005\u0003s\nY*\u0003\u0003\u0002\u001e\u0006m$\u0001\u0002+fgR\fA\u0007^3ti\u0006\u0003\b/\u001a8e%\u0016\u0004H.[2b\r\u0016$8\r[,ji\"\u001c6\r[3ek2,'o\u00115fG.4uN]*ie&t7.S:sQ\r\t\u0013\u0011T\u0001$i\u0016\u001cH/\u00119qK:$'+\u001a9mS\u000e\fg)\u001a;dQ^KG\u000f[+qI\u0006$X-S:sQ\r\u0011\u0013\u0011T\u0001)i\u0016\u001cHoR3u%\u0016\u0004H.[2b/&$\b.\u00169eCR,\u0017i]:jO:lWM\u001c;B]\u0012L5O\u001d\u0015\u0004G\u0005e\u0015AJ2p]\u000e,(O]3oiB\u0013x\u000eZ;dK\u001a+Go\u00195XSRD'+Z1e\u0019>\u001c7n\u00148ms\u0006\u00193m\u001c8dkJ\u0014XM\u001c;Qe>$WoY3GKR\u001c\u0007nV5uQ^\u0013\u0018\u000e^3M_\u000e\\\u0017aD:dQ\u0016$W\u000f\\3BaB,g\u000eZ:\u0015\u0005\u0005M\u0006CBA[\u0003\u000b\fYM\u0004\u0003\u00028\u0006\u0005g\u0002BA]\u0003\u007fk!!a/\u000b\u0007\u0005u6(\u0001\u0004=e>|GOP\u0005\u0002\u0001&\u0019\u00111Y \u0002\u000fA\f7m[1hK&!\u0011qYAe\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0007|\u0004\u0007BAg\u0003/\u0004R!\\Ah\u0003'L1!!5o\u0005\u00191U\u000f^;sKB!\u0011Q[Al\u0019\u0001!1\"!7'\u0003\u0003\u0005\tQ!\u0001\u0002\\\n\u0019q\fJ\u0019\u0012\t\u0005u\u00171\u001d\t\u0004}\u0005}\u0017bAAq\u007f\t9aj\u001c;iS:<\u0007c\u0001 \u0002f&\u0019\u0011q] \u0003\u0007\u0005s\u00170A\ftG\",G-\u001e7f+B$\u0017\r^3G_2dwn^3sgR!\u0011Q^A}!\u0019\t),!2\u0002pB\"\u0011\u0011_A{!\u0015i\u0017qZAz!\u0011\t).!>\u0005\u0017\u0005]x%!A\u0001\u0002\u000b\u0005\u00111\u001c\u0002\u0004?\u0012\u0012\u0004BBA~O\u0001\u0007q*\u0001\u0006ok6\u0014VmY8sIN\f\u0011c]2iK\u0012,H.Z*ie&t7.S:s)\u0019\u0011\tAa\u0003\u0003\u001cA\"!1\u0001B\u0004!\u0015i\u0017q\u001aB\u0003!\u0011\t)Na\u0002\u0005\u0017\t%\u0001&!A\u0001\u0002\u000b\u0005\u00111\u001c\u0002\u0004?\u0012\u001a\u0004b\u0002B\u0007Q\u0001\u0007!qB\u0001\u000bC\u000e$\u0018N^3GY\u0006<\u0007\u0003\u0002B\t\u0005/i!Aa\u0005\u000b\u0007\tUa.\u0001\u0004bi>l\u0017nY\u0005\u0005\u00053\u0011\u0019BA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\b\u0005;A\u0003\u0019\u0001B\u0010\u0003=iwnY6US6,7\u000b\\3fa6\u001b\bc\u0001 \u0003\"%\u0019!1E \u0003\t1{gnZ\u0001\u0018g\u0016$X\u000f\u001d)beRLG/[8o/&$\b.T8dWN$B!!\u0016\u0003*!9\u0011\u0011G\u0015A\u0002\u0005U\u0012aE2sK\u0006$X\rT8h!J|\u0007/\u001a:uS\u0016\u001cH\u0003\u0002B\u0018\u0005o\u0001BA!\r\u000345\t\u0001/C\u0002\u00036A\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0011ID\u000ba\u0001\u0005w\t\u0011b\u001c<feJLG-Z:\u0011\u0011\tu\"Q\tB&\u0005\u0017rAAa\u0010\u0003BA\u0019\u0011\u0011X \n\u0007\t\rs(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u000f\u0012IEA\u0002NCBT1Aa\u0011@!\u0011\u0011iD!\u0014\n\t\t=#\u0011\n\u0002\u0007'R\u0014\u0018N\\4\u0002\r\u0005\u0004\b/\u001a8e)!\t)E!\u0016\u0003X\te\u0003bBA)W\u0001\u0007\u0011Q\u000b\u0005\u0007\u0003w\\\u0003\u0019A(\t\ru\\\u0003\u0019\u0001B.!\u0019\t),!2\u0002\u0010\u0005AR\u000f\u001d3bi\u00164u\u000e\u001c7po\u0016\u0014h)\u001a;dQN#\u0018\r^3\u0015\u0015\u0005\u0015#\u0011\rB2\u0005O\u0012I\u0007C\u0004\u0002R1\u0002\r!!\u0016\t\r\t\u0015D\u00061\u0001P\u0003)1w\u000e\u001c7po\u0016\u0014\u0018\n\u001a\u0005\u0007\u0003wd\u0003\u0019A(\t\u000f\t-D\u00061\u0001\u0002\u0010\u0005iam\u001c7m_^,'/U;fk\u0016\u0014qa\u00157po2{wmE\u0002.\u0005c\u0002B!a\u000e\u0003t%!!QOA\u001d\u0005))f.\u001b4jK\u0012dunZ\u0001\u000fY><7\u000b^1si>3gm]3u\u0003!awnY1m\u0019><\u0007\u0003BA\u001c\u0005{JAAa \u0002:\tAAj\\2bY2{w-\u0001\tmK\u0006$WM]#q_\u000eD7)Y2iKB)aH!\"\u0003\n&\u0019!qQ \u0003\r=\u0003H/[8o!\u0011\u0011YI!&\u000e\u0005\t5%\u0002\u0002BH\u0005#\u000bQ!\u001a9pG\"T1Aa%:\u0003\u0019\u0019XM\u001d<fe&!!q\u0013BG\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK\u0006!\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u0004B!a\u000e\u0003\u001e&!!qTA\u001d\u0005Q\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe&!!\u0011\u0014B:)9\u0011)K!+\u0003,\n5&q\u0016BY\u0005g\u00032Aa*.\u001b\u0005\u0001\u0001bBA\u001ei\u0001\u0007!\u0011\u000f\u0005\b\u0005o\"\u0004\u0019\u0001B\u0010\u0011\u001d\u0011I\b\u000ea\u0001\u0005wBqA!!5\u0001\u0004\u0011\u0019\tC\u0004\u0003\u001aR\u0002\rAa'\t\u000bU$\u0004\u0019A<\u0002\u001d\u0005\u0004\b/\u001a8e\u0003NdU-\u00193feRa!\u0011\u0018B`\u0005\u0007\u00149M!5\u0003`B!\u0011q\u0007B^\u0013\u0011\u0011i,!\u000f\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\u0011\t-\u000ea\u0001\u0003+\tqA]3d_J$7\u000f\u0003\u0004\u0003FV\u0002\raT\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0005\u0003JV\u0002\n\u00111\u0001\u0003L\u00061qN]5hS:\u0004B!a\u000e\u0003N&!!qZA\u001d\u00051\t\u0005\u000f]3oI>\u0013\u0018nZ5o\u0011%\u0011\u0019.\u000eI\u0001\u0002\u0004\u0011).\u0001\u000ej]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNV3sg&|g\u000e\u0005\u0003\u0003X\nmWB\u0001Bm\u0015\r\ti(O\u0005\u0005\u0005;\u0014IN\u0001\u0006Ba&4VM]:j_:D\u0011B!96!\u0003\u0005\rAa9\u0002\u0019I,\u0017/^3ti2{7-\u00197\u0011\t\t\u0015(q]\u0007\u0003\u0005#KAA!;\u0003\u0012\na!+Z9vKN$Hj\\2bY\u0002")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime = new MockTime();
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final ExecutorService executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
    private final Semaphore appendSemaphore = new Semaphore(0);
    private final Semaphore shrinkIsrSemaphore = new Semaphore(0);
    private final IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable)x$1 -> PartitionLockTest.$anonfun$followerQueues$1(BoxesRunTime.unboxToInt((Object)x$1)));
    private LogManager logManager;
    private Partition partition;
    private final TopicPartition kafka$cluster$PartitionLockTest$$topicPartition = new TopicPartition("test-topic", 0);
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues() {
        return this.followerQueues;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition kafka$cluster$PartitionLockTest$$topicPartition() {
        return this.kafka$cluster$PartitionLockTest$$topicPartition;
    }

    @BeforeEach
    public void setUp() {
        String string;
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.kafka$cluster$PartitionLockTest$$topicPartition().topic(), this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}))), logConfig, configRepository, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), this.mockTime(), ApiVersion$.MODULE$.latestVersion()));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"shrinkIsr not invoked");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    @Test
    public void testGetReplicaWithUpdateAssignmentAndIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        int replicaToCheck = 3;
        java.util.List firstReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5)}))).asJava();
        java.util.List secondReplicaSet = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}))).asJava();
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        this.partition().makeLeader(PartitionLockTest.partitionState$1(secondReplicaSet), offsetCheckpoints, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        Future<?> future = this.executorService().submit(() -> {
            int i = 0;
            while (active.get()) {
                java.util.List replicas = i % 2 == 0 ? firstReplicaSet : secondReplicaSet;
                this.partition().makeLeader(PartitionLockTest.partitionState$1(replicas), offsetCheckpoints, (Option)None$.MODULE$);
                ++i;
                Thread.sleep(1L);
            }
        });
        Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds().fromNow();
        while (deadline.hasTimeLeft()) {
            Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
        }
        active.set(false);
        future.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.partition().getReplica(replicaToCheck).isDefined(), (String)new StringBuilder(31).append("Expected replica ").append(replicaToCheck).append(" to be defined").toString());
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable)x$4 -> x$4.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleUpdateFollowers(1).foreach((Function1 & Serializable)x$5 -> x$5.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$6 -> x$6.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        scala.collection.immutable.Seq<Future<?>> appendFutures = this.scheduleAppends();
        scala.collection.immutable.Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assertions.assertFalse((boolean)appendFutures.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable)x$9 -> x$9.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable)x$10 -> x$10.get(15L, TimeUnit.SECONDS));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleAppends() {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numProducers()).map((Function1 & Serializable)x$11 -> PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)x$11)));
    }

    private scala.collection.immutable.Seq<Future<?>> scheduleUpdateFollowers(int numRecords) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.numReplicaFetchers()).map((Function1 & Serializable)index -> PartitionLockTest.$anonfun$scheduleUpdateFollowers$1(this, numRecords, BoxesRunTime.unboxToInt((Object)index)));
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(() -> {
            while (activeFlag.get()) {
                if (mockTimeSleepMs > 0L) {
                    this.mockTime().sleep(mockTimeSleepMs);
                }
                this.partition().maybeShrinkIsr();
                Thread.sleep(1L);
            }
        });
    }

    private Partition setupPartitionWithMocks(LogManager logManager) {
        int leaderEpoch = 1;
        int brokerId = 0;
        IsrChangeListener isrChangeListener = (IsrChangeListener)Mockito.mock(IsrChangeListener.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        AlterIsrManager alterIsrManager = (AlterIsrManager)Mockito.mock(AlterIsrManager.class);
        logManager.startup((Set)Predef$.MODULE$.Set().empty());
        Partition partition = new Partition(this, brokerId, isrChangeListener, delayedOperations, metadataCache, logManager, alterIsrManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public PendingShrinkIsr prepareIsrShrink(scala.collection.immutable.Set<Object> outOfSyncReplicaIds) {
                PendingShrinkIsr pendingShrinkIsr;
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    pendingShrinkIsr = super.prepareIsrShrink(outOfSyncReplicaIds);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
                return pendingShrinkIsr;
            }

            public UnifiedLog createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId) {
                UnifiedLog log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, (Option)None$.MODULE$);
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                LogSegments segments = new LogSegments(log.topicPartition());
                Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(log.dir(), log.topicPartition(), logDirFailureChannel, log.config().recordVersion(), "");
                int maxTransactionTimeout = 300000;
                int maxProducerIdExpirationMs = 3600000;
                ProducerStateManager producerStateManager = new ProducerStateManager(log.topicPartition(), log.dir(), maxTransactionTimeout, maxProducerIdExpirationMs, (Time)this.$outer.mockTime());
                LoadedLogOffsets offsets = new LogLoader(log.dir(), log.topicPartition(), log.config(), (Scheduler)this.$outer.mockTime().scheduler(), (Time)this.$outer.mockTime(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager).load();
                LocalLog localLog = new LocalLog(log.dir(), log.config(), segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.$outer.mockTime().scheduler(), (Time)this.$outer.mockTime(), log.topicPartition(), logDirFailureChannel);
                return new SlowLog(this.$outer, log, offsets.logStartOffset(), localLog, (Option<LeaderEpochFileCache>)leaderEpochCache, producerStateManager, this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.kafka$cluster$PartitionLockTest$$topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), brokerId$1, (Time)$outer.mockTime(), isrChangeListener$1, delayedOperations$1, metadataCache$1, logManager$1, alterIsrManager$1);
            }
        };
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)alterIsrManager.submit((TopicPartition)ArgumentMatchers.eq((Object)this.kafka$cluster$PartitionLockTest$$topicPartition()), (LeaderAndIsr)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn(new CompletableFuture());
        partition.createLogIfNotExists(false, false, offsetCheckpoints, (Option)None$.MODULE$);
        int controllerEpoch = 0;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.numReplicaFetchers()).map((Function1 & Serializable)i -> PartitionLockTest.$anonfun$setupPartitionWithMocks$1(brokerId, BoxesRunTime.unboxToInt((Object)i))).toList()).asJava();
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), offsetCheckpoints, (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    private void append(Partition partition, int numRecords, scala.collection.immutable.Seq<ArrayBlockingQueue<MemoryRecords>> followerQueues) {
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> {
            MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
            partition.appendRecordsToLeader(batch, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
            followerQueues.foreach((Function1 & Serializable)x$13 -> {
                x$13.put(batch);
                return BoxedUnit.UNIT;
            });
        });
    }

    private void updateFollowerFetchState(Partition partition, int followerId, int numRecords, ArrayBlockingQueue<MemoryRecords> followerQueue) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRecords).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> {
            MemoryRecords batch = (MemoryRecords)followerQueue.poll(15L, TimeUnit.SECONDS);
            if (batch == null) {
                throw new RuntimeException(new StringBuilder(33).append("Timed out waiting for next batch ").append(i).toString());
            }
            List batches = CollectionConverters$.MODULE$.IteratorHasAsScala(batch.batches().iterator()).asScala().toList();
            Assertions.assertEquals((int)1, (int)batches.size());
            MutableRecordBatch recordBatch = (MutableRecordBatch)batches.head();
            return partition.updateFollowerFetchState(followerId, new LogOffsetMetadata(recordBatch.lastOffset() + 1L, UnifiedLog$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.mockTime().milliseconds(), partition.localLogOrException().logEndOffset());
        });
    }

    public static final /* synthetic */ ArrayBlockingQueue $anonfun$followerQueues$1(int x$1) {
        return new ArrayBlockingQueue(2);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    private static final LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState$1(java.util.List replicas) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(1).setLeader(Predef$.MODULE$.Integer2int((Integer)replicas.get(0))).setLeaderEpoch(1).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true);
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$11) {
        return $this.executorService().submit(() -> {
            try {
                $this.append($this.partition(), $this.numRecordsPerProducer(), (scala.collection.immutable.Seq<ArrayBlockingQueue<MemoryRecords>>)$this.followerQueues());
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleUpdateFollowers$1(PartitionLockTest $this, int numRecords$1, int index) {
        return $this.executorService().submit(() -> {
            try {
                $this.updateFollowerFetchState($this.partition(), index, numRecords$1, (ArrayBlockingQueue)$this.followerQueues().apply(index - 1));
                return;
            }
            catch (Throwable e) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw e;
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$1(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public PartitionLockTest() {
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
    }

    private class SlowLog
    extends UnifiedLog {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionLockTest $outer;

        public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin, ApiVersion interBrokerProtocolVersion, RequestLocal requestLocal) {
            LogAppendInfo appendInfo = super.appendAsLeader(records, leaderEpoch, origin, interBrokerProtocolVersion, requestLocal);
            this.appendSemaphore.acquire();
            return appendInfo;
        }

        public /* synthetic */ PartitionLockTest kafka$cluster$PartitionLockTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionLockTest $outer, UnifiedLog log, long logStartOffset, LocalLog localLog, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(logStartOffset, localLog, new BrokerTopicStats(), log.producerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true);
        }
    }
}

