/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_3_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterIsrManager;
import kafka.server.AlterIsrManagerTest$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAlterIsrManager;
import kafka.server.ZkIsrManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t5f\u0001B\u001b7\u0001mBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013\u0005q\t\u0003\u0004Q\u0001\u0001\u0006I\u0001\u0013\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u0019I\u0006\u0001)A\u0005'\"9!\f\u0001b\u0001\n\u0003Y\u0006B\u00025\u0001A\u0003%A\fC\u0004j\u0001\t\u0007I\u0011\u00016\t\r9\u0004\u0001\u0015!\u0003l\u0011%y\u0007\u00011AA\u0002\u0013\u0005\u0001\u000fC\u0005u\u0001\u0001\u0007\t\u0019!C\u0001k\"I1\u0010\u0001a\u0001\u0002\u0003\u0006K!\u001d\u0005\by\u0002\u0011\r\u0011\"\u0001~\u0011\u001d\t)\u0001\u0001Q\u0001\nyD\u0001\"a\u0002\u0001\u0005\u0004%\t! \u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003\u007f\u0011!\tY\u0001\u0001b\u0001\n\u0003i\bbBA\u0007\u0001\u0001\u0006IA \u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\"9\u0011q\u0013\u0001\u0005\u0002\u0005E\u0001bBAQ\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003K\u0003A\u0011AA\t\u0011\u001d\tI\u000b\u0001C\u0001\u0003#Aq!!,\u0001\t\u0003\t\t\u0002C\u0004\u00022\u0002!\t!!\u0005\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0007bBAo\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003C\u0004A\u0011AA\t\u0011\u001d\t)\u000f\u0001C\u0001\u0003#Aq!!;\u0001\t\u0003\t\t\u0002C\u0004\u0002n\u0002!I!a<\t\u000f\u0005M\b\u0001\"\u0003\u0002v\"9!1\u0001\u0001\u0005\u0002\t\u0015\u0001b\u0002B\b\u0001\u0011\u0005!\u0011\u0003\u0005\b\u00057\u0001A\u0011AA\t\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CA\u0011Ba\u0017\u0001#\u0003%IA!\u0018\t\u0013\tM\u0004!%A\u0005\n\tU\u0004\"\u0003B=\u0001E\u0005I\u0011\u0002B>\u0011%\u0011y\bAI\u0001\n\u0013\u0011Y\bC\u0005\u0003\u0002\u0002\t\n\u0011\"\u0003\u0003|!I!1\u0011\u0001\u0012\u0002\u0013%!QQ\u0004\b\u0005\u00133\u0004\u0012\u0001BF\r\u0019)d\u0007#\u0001\u0003\u000e\"1!)\rC\u0001\u0005\u001fCq!a\u00152\t\u0003\u0011\t\nC\u0004\u0002|E\"\tAa)\u0003'\u0005cG/\u001a:JgJl\u0015M\\1hKJ$Vm\u001d;\u000b\u0005]B\u0014AB:feZ,'OC\u0001:\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\t\u0005\u0002F\u00015\ta'A\u0003u_BL7-F\u0001I!\tIe*D\u0001K\u0015\tYE*\u0001\u0003mC:<'\"A'\u0002\t)\fg/Y\u0005\u0003\u001f*\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0003uS6,W#A*\u0011\u0005Q;V\"A+\u000b\u0005YC\u0014!B;uS2\u001c\u0018B\u0001-V\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013aB7fiJL7m]\u000b\u00029B\u0011QLZ\u0007\u0002=*\u0011!l\u0018\u0006\u0003A\u0006\faaY8n[>t'BA\u001dc\u0015\t\u0019G-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0006\u0019qN]4\n\u0005\u001dt&aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005A!M]8lKJLE-F\u0001l!\tiD.\u0003\u0002n}\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013A\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ,\u0012!\u001d\t\u0003\u000bJL!a\u001d\u001c\u0003A\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0017EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u0018\u0013fcR\u0011a/\u001f\t\u0003{]L!\u0001\u001f \u0003\tUs\u0017\u000e\u001e\u0005\bu.\t\t\u00111\u0001r\u0003\rAH%M\u0001\u0014EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'\u000fI\u0001\u0004iB\u0004T#\u0001@\u0011\u0007}\f\t!D\u0001`\u0013\r\t\u0019a\u0018\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0011!\b\u000f\r\u0011\u0002\u0007Q\u0004\u0018'\u0001\u0003uaF\u0002\u0013a\u0001;qe\u0005!A\u000f\u001d\u001a!\u0003\u0015\u0019X\r^;q)\u00051\bfA\n\u0002\u0016A!\u0011qCA\u0013\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011aA1qS*!\u0011qDA\u0011\u0003\u001dQW\u000f]5uKJT1!a\te\u0003\u0015QWO\\5u\u0013\u0011\t9#!\u0007\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0005uKN$()Y:jGR\u0019a/!\f\t\u000f\u0005=B\u00031\u0001\u00022\u0005Q\u0011\r]5WKJ\u001c\u0018n\u001c8\u0011\t\u0005M\u0012qG\u0007\u0003\u0003kQ1!a\u00079\u0013\u0011\tI$!\u000e\u0003\u0015\u0005\u0003\u0018NV3sg&|g\u000eK\u0004\u0015\u0003{\ti%a\u0014\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005A\u0001O]8wS\u0012,'O\u0003\u0003\u0002H\u0005u\u0011A\u00029be\u0006l7/\u0003\u0003\u0002L\u0005\u0005#\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,GFAA)C\t\t\u0019&\u0001\nqe>4\u0018\u000eZ3Ba&4VM]:j_:\u001c\bf\u0001\u000b\u0002XA!\u0011\u0011LA.\u001b\t\t)%\u0003\u0003\u0002^\u0005\u0015#!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006\u0001C/Z:u\u0005\u0006\u001c\u0018nY*f]RdU-\u00193feJ+7m\u001c<fef\u001cF/\u0019;f)\u00151\u00181MA3\u0011\u001d\ty#\u0006a\u0001\u0003cAq!a\u001a\u0016\u0001\u0004\tI'A\nmK\u0006$WM\u001d*fG>4XM]=Ti\u0006$X\r\u0005\u0003\u0002l\u0005ETBAA7\u0015\r\ty'Y\u0001\t[\u0016$\u0018\rZ1uC&!\u00111OA7\u0005MaU-\u00193feJ+7m\u001c<fef\u001cF/\u0019;fQ\u001d)\u0012QHA'\u0003ob#!!\u001f\"\u0005\u0005m\u0014A\u00079s_ZLG-\u001a'fC\u0012,'OU3d_Z,'/_*uCR,\u0007fA\u000b\u0002X\u0005AB/Z:u\u001fZ,'o\u001e:ji\u0016<\u0016\u000e\u001e5j]\n\u000bGo\u00195\u0015\u0007Y\f\u0019\tC\u0004\u00020Y\u0001\r!!\r)\u000fY\ti$!\u0014\u0002\b2\u0012\u0011\u0011\u000b\u0015\u0004-\u0005]\u0013a\u0004;fgR\u001c\u0016N\\4mK\n\u000bGo\u00195\u0015\u0007Y\fy\tC\u0004\u00020]\u0001\r!!\r)\u000f]\ti$!\u0014\u0002\u00142\u0012\u0011\u0011\u000b\u0015\u0004/\u0005]\u0013A\u0006;fgR\u001cVOY7ji\u001a\u0013x.\\\"bY2\u0014\u0017mY6)\u0007a\tY\n\u0005\u0003\u0002\u0018\u0005u\u0015\u0002BAP\u00033\u0011A\u0001V3ti\u00069B/Z:u\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8GC&dW\r\u001a\u0015\u00043\u0005m\u0015\u0001\u0006;fgR\u001cF/\u00197f\u0005J|7.\u001a:Fa>\u001c\u0007\u000eK\u0002\u001b\u00037\u000b\u0011\u0003^3tiVs7N\\8x]N+'O^3sQ\rY\u00121T\u0001!i\u0016\u001cHOU3uef|e.Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X\rK\u0002\u001d\u00037\u000b!\u0005^3tiJ+GO]=P]Vs7/\u001e9q_J$X\r\u001a,feNLwN\\#se>\u0014\bfA\u000f\u0002\u001c\u0006AB/Z:u%\u0016$(/_(o)>\u0004H*\u001a<fY\u0016\u0013(o\u001c:\u0015\u0007Y\fI\fC\u0004\u0002<z\u0001\r!!0\u0002\u000b\u0015\u0014(o\u001c:\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1`\u0003!\u0001(o\u001c;pG>d\u0017\u0002BAd\u0003\u0003\u0014a!\u0012:s_J\u001c\u0018\u0001\u0007;fgR\u0014V\r\u001e:z\u001f:,%O]8s%\u0016\u001c\bo\u001c8tKR\u0019a/!4\t\u000f\u0005=w\u00041\u0001\u0002R\u0006A!/Z:q_:\u001cX\r\u0005\u0003\u0002T\u0006eWBAAk\u0015\r\t9.Y\u0001\bG2LWM\u001c;t\u0013\u0011\tY.!6\u0003\u001d\rc\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\u0006AB/Z:u\u0013:4\u0018\r\\5e+B$\u0017\r^3WKJ\u001c\u0018n\u001c8)\u0007\u0001\nY*A\ruKN$XK\\6o_^tGk\u001c9jGB\u000b'\u000f^5uS>t\u0007fA\u0011\u0002\u001c\u00069B/Z:u\u001d>$H*Z1eKJ|%OR8mY><XM\u001d\u0015\u0004E\u0005m\u0015A\u0005;fgRLeN^1mS\u0012\u0014V-];fgRD3aIAN\u0003M\u0019\u0007.Z2l!\u0006\u0014H/\u001b;j_:,%O]8s)\r1\u0018\u0011\u001f\u0005\b\u0003w#\u0003\u0019AA_\u0003I!Xm\u001d;QCJ$\u0018\u000e^5p]\u0016\u0013(o\u001c:\u0015\r\u0005]\u0018Q B\u0001!\r)\u0015\u0011`\u0005\u0004\u0003w4$aD!mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:\t\r\u0005}X\u00051\u0001\u007f\u0003\t!\b\u000fC\u0004\u0002<\u0016\u0002\r!!0\u0002\u001fQ,7\u000f^(oK&sg\t\\5hQR$2A\u001eB\u0004\u0011\u001d\tyC\na\u0001\u0003cAsAJA\u001f\u0003\u001b\u0012Y\u0001\f\u0002\u0002R!\u001aa%a\u0016\u0002=Q,7\u000f\u001e)beRLG/[8o\u001b&\u001c8/\u001b8h\u0013:\u0014Vm\u001d9p]N,Gc\u0001<\u0003\u0014!9\u0011qF\u0014A\u0002\u0005E\u0002fB\u0014\u0002>\u00055#q\u0003\u0017\u0003\u0003#B3aJA,\u0003-!Xm\u001d;[W\n\u000b7/[2)\u0007!\nY*A\tqCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$bBa\t\u00030\tE\"1\u0007B\u001c\u0005w\u0011y\u0004\u0005\u0003\u0003&\t-RB\u0001B\u0014\u0015\r\u0011IcX\u0001\te\u0016\fX/Z:ug&!!Q\u0006B\u0014\u0005Y\tE\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,\u0007\u0002CA\u0000SA\u0005\t\u0019\u0001@\t\u0013\u0005m\u0016\u0006%AA\u0002\u0005u\u0006\u0002\u0003B\u001bSA\u0005\t\u0019A6\u0002\u001dA\f'\u000f^5uS>tW\t]8dQ\"A!\u0011H\u0015\u0011\u0002\u0003\u00071.\u0001\u0005mK\u0006$WM]%e\u0011!\u0011i$\u000bI\u0001\u0002\u0004Y\u0017a\u00037fC\u0012,'/\u00129pG\"D\u0011B!\u0011*!\u0003\u0005\rAa\u0011\u0002\u0007%\u001c(\u000fE\u0003\u0003F\tU3N\u0004\u0003\u0003H\tEc\u0002\u0002B%\u0005\u001fj!Aa\u0013\u000b\u0007\t5#(\u0001\u0004=e>|GOP\u0005\u0002\u007f%\u0019!1\u000b \u0002\u000fA\f7m[1hK&!!q\u000bB-\u0005\u0011a\u0015n\u001d;\u000b\u0007\tMc(A\u000eqCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0005?R3A B1W\t\u0011\u0019\u0007\u0005\u0003\u0003f\t=TB\u0001B4\u0015\u0011\u0011IGa\u001b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B7}\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tE$q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$#'\u0006\u0002\u0003x)\"\u0011Q\u0018B1\u0003m\u0001\u0018M\u001d;ji&|gNU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0010\u0016\u0004W\n\u0005\u0014a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$C'A\u000eqCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$C-\u001a4bk2$H%N\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t\u001d%\u0006\u0002B\"\u0005C\n1#\u00117uKJL5O]'b]\u0006<WM\u001d+fgR\u0004\"!R\u0019\u0014\u0005EbDC\u0001BF)\t\u0011\u0019\n\u0005\u0004\u0003\u0016\n}\u0015\u0011G\u0007\u0003\u0005/SAA!'\u0003\u001c\u000611\u000f\u001e:fC6T1A!(M\u0003\u0011)H/\u001b7\n\t\t\u0005&q\u0013\u0002\u0007'R\u0014X-Y7\u0015\u0005\t\u0015\u0006C\u0002BK\u0005?\u00139\u000b\u0005\u0003\u0002@\t%\u0016\u0002\u0002BV\u0003\u0003\u0012\u0011\"\u0011:hk6,g\u000e^:")
public class AlterIsrManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private BrokerToControllerChannelManager brokerToController;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);
    private final TopicPartition tp2 = new TopicPartition(this.topic(), 2);

    public static Stream<Arguments> provideLeaderRecoveryState() {
        return AlterIsrManagerTest$.MODULE$.provideLeaderRecoveryState();
    }

    public static Stream<ApiVersion> provideApiVersions() {
        return AlterIsrManagerTest$.MODULE$.provideApiVersions();
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testBasic(ApiVersion apiVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLeaderRecoveryState"})
    public void testBasicSentLeaderRecoveryState(ApiVersion apiVersion, LeaderRecoveryState leaderRecoveryState) {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), leaderRecoveryState, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)requestCapture.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)requestCapture.getValue()).build();
        Assertions.assertEquals((byte)(apiVersion.$greater$eq((Object)KAFKA_3_2_IV0$.MODULE$) ? leaderRecoveryState : LeaderRecoveryState.RECOVERED).value(), (byte)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).leaderRecoveryState());
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testOverwriteWithinBatch(ApiVersion apiVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        Assertions.assertFalse((boolean)alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
        CompletableFuture failedSubmitFuture = alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), LeaderRecoveryState.RECOVERED, 10), 0);
        Assertions.assertTrue((boolean)failedSubmitFuture.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)failedSubmitFuture, OperationNotAttemptedException.class);
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertFalse((boolean)alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testSingleBatch(ApiVersion apiVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(new TopicPartition(this.topic(), 0), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1 & Serializable)i -> alterIsrManager.submit(new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)i)), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0));
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testSubmitFromCallback() {
        AlterPartitionResponse alterPartitionRespWithPartitionError = this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse errorResponse = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionRespWithPartitionError);
        int leaderId = 1;
        int leaderEpoch = 1;
        int partitionEpoch = 10;
        List isr = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(leaderId, leaderEpoch, isr, LeaderRecoveryState.RECOVERED, partitionEpoch);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterPartitionManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (ApiVersion)KAFKA_3_2_IV0$.MODULE$);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0);
        CompletableFuture finalFuture = new CompletableFuture();
        future.whenComplete((x$2, e2) -> {
            if (e2 != null) {
                alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0).whenComplete((result, e) -> {
                    if (e != null) {
                        finalFuture.completeExceptionally((Throwable)e);
                        return;
                    }
                    finalFuture.complete(result);
                });
                return;
            }
            finalFuture.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Expected the future to be failed")));
        });
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(errorResponse);
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, partitionEpoch, leaderId, leaderEpoch, (List<Object>)isr);
        ClientResponse retryResponse = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)retryAlterPartitionResponse);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertEquals((Object)leaderAndIsr, finalFuture.get(200L, TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0()));
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData().setErrorCode(error.code()));
        ClientResponse response = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (ApiVersion)KAFKA_3_2_IV0$.MODULE$);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), leaderAndIsr, 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse retryResponse = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)retryAlterPartitionResponse);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertFalse((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void testInvalidRequest() {
        this.checkPartitionError(Errors.INVALID_REQUEST);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertFalse((boolean)this.testPartitionError(this.tp0(), error).submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
    }

    private AlterIsrManager testPartitionError(TopicPartition tp, Errors error) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, (ApiVersion)KAFKA_3_2_IV0$.MODULE$);
        alterIsrManager.start();
        CompletableFuture future = alterIsrManager.submit(tp, new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(tp, error, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
        return alterIsrManager;
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testOneInFlight(ApiVersion apiVersion) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        alterIsrManager.submit(this.tp1(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        alterIsrManager.submit(this.tp2(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testPartitionMissingInResponse(ApiVersion apiVersion) {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> brokerEpoch, apiVersion);
        alterIsrManager.start();
        CompletableFuture future1 = alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ControllerRequestCompletionHandler callback1 = this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0()})));
        CompletableFuture future2 = alterIsrManager.submit(this.tp1(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        CompletableFuture future3 = alterIsrManager.submit(this.tp2(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        callback1.onComplete(this.clientResponse$1(this.tp0(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future1, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.tp2()}))).onComplete(this.clientResponse$1(this.tp2(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future3, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()}))).onComplete(this.clientResponse$1(this.tp1(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future2, UnknownServerException.class);
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$3 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$4 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any());
        ZkIsrManager zkIsrManager = new ZkIsrManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        CompletableFuture future1 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 1), 0);
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertEquals((Object)new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 2), future1.get());
        CompletableFuture future2 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 3), 0);
        Assertions.assertTrue((boolean)future2.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future2, InvalidUpdateVersionException.class);
    }

    private AlterPartitionResponse partitionResponse(TopicPartition tp, Errors error, int partitionEpoch, int leaderId, int leaderEpoch, List<Object> isr) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setName(tp.topic()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(tp.partition()).setPartitionIndex(tp.partition()).setPartitionEpoch(partitionEpoch).setLeaderEpoch(leaderEpoch).setLeaderId(leaderId).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)isr.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setErrorCode(error.code()))))));
    }

    private TopicPartition partitionResponse$default$1() {
        return this.tp0();
    }

    private Errors partitionResponse$default$2() {
        return Errors.NONE;
    }

    private int partitionResponse$default$3() {
        return 0;
    }

    private int partitionResponse$default$4() {
        return 0;
    }

    private int partitionResponse$default$5() {
        return 0;
    }

    private List<Object> partitionResponse$default$6() {
        return package$.MODULE$.List().empty();
    }

    private static final AbstractRequest.Builder matchesAlterIsr$1(Set topicPartitions) {
        return (AbstractRequest.Builder)ArgumentMatchers.argThat(request -> {
            Assertions.assertEquals((Object)ApiKeys.ALTER_PARTITION, (Object)request.apiKey());
            AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)((AlterPartitionRequest.Builder)request).build();
            Set requestTopicPartitions = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(alterPartitionRequest.data().topics()).asScala().flatMap((Function1 & Serializable)topicData -> {
                String topic = topicData.name();
                return (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicData.partitions()).asScala().map((Function1 & Serializable)partitionData -> new TopicPartition(topic, partitionData.partitionIndex()));
            })).toSet();
            Set set = topicPartitions;
            return !(set != null ? !set.equals(requestTopicPartitions) : requestTopicPartitions != null);
        });
    }

    private final ControllerRequestCompletionHandler verifySendAlterIsr$1(Set topicPartitions) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest(AlterIsrManagerTest.matchesAlterIsr$1(topicPartitions), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        return (ControllerRequestCompletionHandler)callbackCapture.getValue();
    }

    private final ClientResponse clientResponse$1(TopicPartition topicPartition, Errors error) {
        AlterPartitionResponse alterIsrResponse = this.partitionResponse(topicPartition, error, 0, 0, 0, this.partitionResponse$default$6());
        return new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResponse);
    }

    public AlterIsrManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }
}

