/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.network.ConnectionQuotas;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.network.ListenerName;
import org.slf4j.event.Level;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005%aA\u0002\u000b\u0016\u0003\u00039\u0012\u0004\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u001d)\u0004A1A\u0005\nYBaa\u0010\u0001!\u0002\u00139\u0004b\u0002!\u0001\u0001\u0004%IA\u000e\u0005\b\u0003\u0002\u0001\r\u0011\"\u0003C\u0011\u0019Y\u0005\u0001)Q\u0005o!9\u0001\u000b\u0001b\u0001\n\u0013\t\u0006B\u0002-\u0001A\u0003%!\u000bC\u0003Z\u0001\u0019\u0005!\fC\u0003\\\u0001\u0011\u0005!\fC\u0003]\u0001\u0011\u0005!\fC\u0003^\u0001\u0011\u0005a\fC\u0003c\u0001\u0011\u0005!\fC\u0003d\u0001\u0011E!\fC\u0003e\u0001\u0011E!\fC\u0003f\u0001\u0011Ea\rC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0004\u0002\u0004\u0001!\t\"!\u0002\u0003)\u0005\u00137\u000f\u001e:bGR\u001cVM\u001d<feRC'/Z1e\u0015\t1r#A\u0004oKR<xN]6\u000b\u0003a\tQa[1gW\u0006\u001cB\u0001\u0001\u000e#KA\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0005Y\u0006twMC\u0001 \u0003\u0011Q\u0017M^1\n\u0005\u0005b\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001cG%\u0011A\u0005\b\u0002\t%Vtg.\u00192mKB\u0011a%K\u0007\u0002O)\u0011\u0001fF\u0001\u0006kRLGn]\u0005\u0003U\u001d\u0012q\u0001T8hO&tw-\u0001\td_:tWm\u0019;j_:\fVo\u001c;bg\u000e\u0001\u0001C\u0001\u00180\u001b\u0005)\u0012B\u0001\u0019\u0016\u0005A\u0019uN\u001c8fGRLwN\\)v_R\f7/\u0001\u0004=S:LGO\u0010\u000b\u0003gQ\u0002\"A\f\u0001\t\u000b-\u0012\u0001\u0019A\u0017\u0002\u0019M$\u0018M\u001d;va2\u000bGo\u00195\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002==\u0005!Q\u000f^5m\u0013\tq\u0014H\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\u0002\u001bM$\u0018M\u001d;va2\u000bGo\u00195!\u00035\u0019\b.\u001e;e_^tG*\u0019;dQ\u0006\t2\u000f[;uI><h\u000eT1uG\"|F%Z9\u0015\u0005\rK\u0005C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%\u0001B+oSRDqA\u0013\u0004\u0002\u0002\u0003\u0007q'A\u0002yIE\nab\u001d5vi\u0012|wO\u001c'bi\u000eD\u0007\u0005\u000b\u0002\b\u001bB\u0011AIT\u0005\u0003\u001f\u0016\u0013\u0001B^8mCRLG.Z\u0001\u0006C2Lg/Z\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011Q+O\u0001\u0007CR|W.[2\n\u0005]#&!D!u_6L7MQ8pY\u0016\fg.\u0001\u0004bY&4X\rI\u0001\u0007o\u0006\\W-\u001e9\u0015\u0003\r\u000b\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0003%I7o\u0015;beR,G\rF\u0001`!\t!\u0005-\u0003\u0002b\u000b\n9!i\\8mK\u0006t\u0017\u0001D1xC&$8\u000b^1siV\u0004\u0018aD:uCJ$X\u000f]\"p[BdW\r^3\u0002!MDW\u000f\u001e3po:\u001cu.\u001c9mKR,\u0017!C5t%Vtg.\u001b8h+\u0005y\u0016!B2m_N,GcA\"jo\")!N\u0005a\u0001W\u0006aA.[:uK:,'OT1nKB\u0011A.^\u0007\u0002[*\u0011aC\u001c\u0006\u0003_B\faaY8n[>t'B\u0001\rr\u0015\t\u00118/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0006\u0019qN]4\n\u0005Yl'\u0001\u0004'jgR,g.\u001a:OC6,\u0007\"\u0002=\u0013\u0001\u0004I\u0018aB2iC:tW\r\u001c\t\u0003u~l\u0011a\u001f\u0006\u0003yv\f\u0001b\u00195b]:,Gn\u001d\u0006\u0003}z\t1A\\5p\u0013\r\t\ta\u001f\u0002\u000e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0002\u0017\rdwn]3T_\u000e\\W\r\u001e\u000b\u0004\u0007\u0006\u001d\u0001\"\u0002=\u0014\u0001\u0004I\b")
public abstract class AbstractServerThread
implements Runnable,
Logging {
    private final ConnectionQuotas connectionQuotas;
    private final CountDownLatch startupLatch;
    private volatile CountDownLatch shutdownLatch;
    private final AtomicBoolean alive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private CountDownLatch startupLatch() {
        return this.startupLatch;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    private void shutdownLatch_$eq(CountDownLatch x$1) {
        this.shutdownLatch = x$1;
    }

    private AtomicBoolean alive() {
        return this.alive;
    }

    public abstract void wakeup();

    public void initiateShutdown() {
        if (this.alive().getAndSet(false)) {
            this.wakeup();
        }
    }

    public void awaitShutdown() {
        this.shutdownLatch().await();
    }

    public boolean isStarted() {
        return this.startupLatch().getCount() == 0L;
    }

    public void awaitStartup() {
        this.startupLatch().await();
    }

    public void startupComplete() {
        this.shutdownLatch_$eq(new CountDownLatch(1));
        this.startupLatch().countDown();
    }

    public void shutdownComplete() {
        this.shutdownLatch().countDown();
    }

    public boolean isRunning() {
        return this.alive().get();
    }

    public void close(ListenerName listenerName, SocketChannel channel) {
        if (channel != null) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Closing connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
            this.connectionQuotas.dec(listenerName, channel.socket().getInetAddress());
            this.closeSocket(channel);
        }
    }

    public void closeSocket(SocketChannel channel) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> channel.socket().close(), this, Level.ERROR);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> channel.close(), this, Level.ERROR);
    }

    public AbstractServerThread(ConnectionQuotas connectionQuotas) {
        this.connectionQuotas = connectionQuotas;
        this.startupLatch = new CountDownLatch(1);
        this.shutdownLatch = new CountDownLatch(0);
        this.alive = new AtomicBoolean(true);
    }
}

