/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_3_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001B\r\u001b\u0001}A\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003?\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t/\u0002\u0011)\u0019!C\u00011\"Aq\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011\u00159\u0007\u0001\"\u0001i\u0011!\u0001\bA1A\u0005\u0002i\t\bbBA\u0002\u0001\u0001\u0006IA\u001d\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"!\u0007\u0001A\u0003%\u0011\u0011\u0002\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\t)\u0003\u0001C!\u0003;Aq!a\n\u0001\t\u0003\nI\u0003\u0003\u0005\u0002F\u0001!\tAGA\u000f\u0011!\t9\u0005\u0001C\u00015\u0005u\u0001bBA%\u0001\u0011%\u00111\n\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\tY\b\u0001C\u0001\u0003{\u0012a\u0003R3gCVdG/\u00117uKJL5O]'b]\u0006<WM\u001d\u0006\u00037q\taa]3sm\u0016\u0014(\"A\u000f\u0002\u000b-\fgm[1\u0004\u0001M)\u0001\u0001\t\u0014+aA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0015\u000e\u0003iI!!\u000b\u000e\u0003\u001f\u0005cG/\u001a:JgJl\u0015M\\1hKJ\u0004\"a\u000b\u0018\u000e\u00031R!!\f\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005=b#a\u0002'pO\u001eLgn\u001a\t\u0003cQj\u0011A\r\u0006\u0003gq\tq!\\3ue&\u001c7/\u0003\u00026e\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u00021\r|g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/F\u00019!\t9\u0013(\u0003\u0002;5\t\u0001#I]8lKJ$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003e\u0019wN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001 \u0011\u0005-z\u0014B\u0001!-\u0005%\u00196\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\nA\u0001^5nKV\tA\t\u0005\u0002F\u001d6\taI\u0003\u0002.\u000f*\u0011\u0001*S\u0001\u0007G>lWn\u001c8\u000b\u0005uQ%BA&M\u0003\u0019\t\u0007/Y2iK*\tQ*A\u0002pe\u001eL!a\u0014$\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\tEJ|7.\u001a:JIV\t1\u000b\u0005\u0002\")&\u0011QK\t\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003M\u0011'o\\6fe\u0016\u0003xn\u00195TkB\u0004H.[3s+\u0005I\u0006cA\u0011[9&\u00111L\t\u0002\n\rVt7\r^5p]B\u0002\"!I/\n\u0005y\u0013#\u0001\u0002'p]\u001e\fAC\u0019:pW\u0016\u0014X\t]8dQN+\b\u000f\u001d7jKJ\u0004\u0013AC5caZ+'o]5p]B\u0011!-Z\u0007\u0002G*\u0011A\rH\u0001\u0004CBL\u0017B\u00014d\u0005)\t\u0005/\u001b,feNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f%T7\u000e\\7o_B\u0011q\u0005\u0001\u0005\u0006m1\u0001\r\u0001\u000f\u0005\u0006y1\u0001\rA\u0010\u0005\u0006\u00052\u0001\r\u0001\u0012\u0005\u0006#2\u0001\ra\u0015\u0005\u0006/2\u0001\r!\u0017\u0005\u0006A2\u0001\r!Y\u0001\u0011k:\u001cXM\u001c;JgJ,\u0006\u000fZ1uKN,\u0012A\u001d\t\u0005gbTh0D\u0001u\u0015\t)h/\u0001\u0003vi&d'\"A<\u0002\t)\fg/Y\u0005\u0003sR\u00141!T1q!\tYH0D\u0001H\u0013\tixI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005\u001dz\u0018bAA\u00015\ta\u0011\t\u001c;fe&\u001b(/\u0013;f[\u0006\tRO\\:f]RL5O]+qI\u0006$Xm\u001d\u0011\u0002\u001f%tg\r\\5hQR\u0014V-];fgR,\"!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u00051\u0011\r^8nS\u000eT1!a\u0005u\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003/\tiAA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0011S:4G.[4iiJ+\u0017/^3ti\u0002\nQa\u001d;beR$\"!a\b\u0011\u0007\u0005\n\t#C\u0002\u0002$\t\u0012A!\u00168ji\u0006A1\u000f[;uI><h.\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\t\u0003W\tI$!\u0010\u0002BA1\u0011QFA\u0018\u0003gi!!!\u0005\n\t\u0005E\u0012\u0011\u0003\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007c\u00012\u00026%\u0019\u0011qG2\u0003\u00191+\u0017\rZ3s\u0003:$\u0017j\u001d:\t\r\u0005m2\u00031\u0001{\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a\u0010\u0014\u0001\u0004\t\u0019$\u0001\u0007mK\u0006$WM]!oI&\u001b(\u000f\u0003\u0004\u0002DM\u0001\raU\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\u0006AR.Y=cKB\u0013x\u000e]1hCR,\u0017j\u001d:DQ\u0006tw-Z:\u0002)\rdW-\u0019:J]\u001ac\u0017n\u001a5u%\u0016\fX/Z:u\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\t\u0005}\u0011Q\n\u0005\b\u0003\u001f2\u0002\u0019AA)\u0003UIgN\u001a7jO\"$\u0018\t\u001c;fe&\u001b(/\u0013;f[N\u0004R!a\u0015\u0002dytA!!\u0016\u0002`9!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\y\ta\u0001\u0010:p_Rt\u0014\"A\u0012\n\u0007\u0005\u0005$%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0014q\r\u0002\u0004'\u0016\f(bAA1E\u0005a!-^5mIJ+\u0017/^3tiR!\u0011QNA=!\u0011\ty'!\u001e\u000e\u0005\u0005E$bAA:\u000f\u00069Q.Z:tC\u001e,\u0017\u0002BA<\u0003c\u0012\u0011$\u00117uKJ\u0004\u0016M\u001d;ji&|gNU3rk\u0016\u001cH\u000fR1uC\"9\u0011qJ\fA\u0002\u0005E\u0013\u0001\b5b]\u0012dW-\u00117uKJ\u0004\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u000b\t\u0003\u007f\nY)a'\u0002 B!\u0011\u0011QAD\u001b\t\t\u0019IC\u0002\u0002\u0006\u001e\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003\u0013\u000b\u0019I\u0001\u0004FeJ|'o\u001d\u0005\b\u0003\u001bC\u0002\u0019AAH\u0003I\tG\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'S1!!&H\u0003!\u0011X-];fgR\u001c\u0018\u0002BAM\u0003'\u0013a#\u00117uKJ\u0004\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0005\u0007\u0003;C\u0002\u0019\u0001/\u0002\u001fM,g\u000e\u001e\"s_.,'/\u00129pG\"Dq!a\u0014\u0019\u0001\u0004\t\t\u0006")
public class DefaultAlterIsrManager
implements AlterIsrManager,
KafkaMetricsGroup {
    private final BrokerToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final ApiVersion ibpVersion;
    private final java.util.Map<TopicPartition, AlterIsrItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public BrokerToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    public java.util.Map<TopicPartition, AlterIsrItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    @Override
    public void start() {
        this.controllerChannelManager().start();
    }

    @Override
    public void shutdown() {
        this.controllerChannelManager().shutdown();
    }

    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicPartition topicPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch) {
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        AlterIsrItem alterIsrItem = new AlterIsrItem(topicPartition, leaderAndIsr, future, controllerEpoch);
        if (this.unsentIsrUpdates().putIfAbsent(alterIsrItem.topicPartition(), alterIsrItem) == null) {
            this.maybePropagateIsrChanges();
        } else {
            future.completeExceptionally((Throwable)new OperationNotAttemptedException(new StringBuilder(50).append("Failed to enqueue ISR change state ").append(leaderAndIsr).append(" for partition ").append(topicPartition).toString()));
        }
        return future;
    }

    public void maybePropagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterIsrItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterIsrItems.append(item));
            this.sendRequest((scala.collection.immutable.Seq<AlterIsrItem>)inflightAlterIsrItems.toSeq());
        }
    }

    public void clearInFlightRequest() {
        if (!this.inflightRequest().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Attempting to clear AlterPartition in-flight flag when no apparent request is in-flight");
        }
    }

    private void sendRequest(scala.collection.immutable.Seq<AlterIsrItem> inflightAlterIsrItems) {
        AlterPartitionRequestData message = this.buildRequest(inflightAlterIsrItems);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Sending AlterPartition to controller ").append(message).toString());
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)new AlterPartitionRequest.Builder(message), new ControllerRequestCompletionHandler(this, message, inflightAlterIsrItems){
            private final /* synthetic */ DefaultAlterIsrManager $outer;
            private final AlterPartitionRequestData message$1;
            private final scala.collection.immutable.Seq inflightAlterIsrItems$2;

            public void onComplete(ClientResponse response) {
                Errors errors;
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Received AlterPartition response ").append(response).toString());
                try {
                    if (response.authenticationException() != null) {
                        errors = Errors.NETWORK_EXCEPTION;
                    } else if (response.versionMismatch() != null) {
                        errors = Errors.UNSUPPORTED_VERSION;
                    } else {
                        AlterPartitionResponse body = (AlterPartitionResponse)response.responseBody();
                        errors = this.$outer.handleAlterPartitionResponse(body, this.message$1.brokerEpoch(), (scala.collection.immutable.Seq<AlterIsrItem>)this.inflightAlterIsrItems$2);
                    }
                }
                finally {
                    this.$outer.clearInFlightRequest();
                }
                Errors error = errors;
                if (Errors.NONE.equals(error)) {
                    this.$outer.maybePropagateIsrChanges();
                    return;
                }
                this.$outer.scheduler().schedule("send-alter-partition", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.$outer.maybePropagateIsrChanges(), 50L, -1L, TimeUnit.MILLISECONDS);
            }

            public void onTimeout() {
                throw new IllegalStateException("Encountered unexpected timeout when sending AlterPartition to the controller");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.message$1 = message$1;
                this.inflightAlterIsrItems$2 = inflightAlterIsrItems$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse ), $anonfun$onComplete$2(kafka.server.DefaultAlterIsrManager$$anon$1 )}, serializedLambda);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private AlterPartitionRequestData buildRequest(scala.collection.immutable.Seq<AlterIsrItem> inflightAlterIsrItems) {
        void var2_2;
        AlterPartitionRequestData message = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(this.brokerEpochSupplier().apply$mcJ$sp());
        inflightAlterIsrItems.groupBy((Function1 & Serializable)x$1 -> x$1.topicPartition().topic()).foreach((Function1 & Serializable)x0$1 -> {
            DefaultAlterIsrManager.$anonfun$buildRequest$2(this, message, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Errors handleAlterPartitionResponse(AlterPartitionResponse alterPartitionResp, long sentBrokerEpoch, scala.collection.immutable.Seq<AlterIsrItem> inflightAlterIsrItems) {
        AlterPartitionResponseData data = alterPartitionResp.data();
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Broker had a stale broker epoch (").append(sentBrokerEpoch).append("), retrying.").toString());
        } else if (Errors.CLUSTER_AUTHORIZATION_FAILED.equals(errors)) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Broker is not authorized to send AlterPartition to controller", (Function0<Throwable>)(Function0 & Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterPartition to controller"));
        } else if (Errors.NONE.equals(errors)) {
            HashMap partitionResponses = new HashMap();
            data.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                Errors apiError = Errors.forCode((short)partition.errorCode());
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Controller successfully handled AlterPartition request for ").append(tp).append(": ").append(partition).toString());
                Errors errors = apiError;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(LeaderRecoveryState.optionalOf((byte)partition.leaderRecoveryState())));
                    if (option instanceof Some) {
                        LeaderRecoveryState leaderRecoveryState = (LeaderRecoveryState)((Some)option).value();
                        partitionResponses.update((Object)tp, (Object)package$.MODULE$.Right().apply((Object)new LeaderAndIsr(partition.leaderId(), partition.leaderEpoch(), (List<Object>)CollectionConverters$.MODULE$.ListHasAsScala(partition.isr()).asScala().toList().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2))), leaderRecoveryState, partition.partitionEpoch())));
                        return;
                    }
                    if (None$.MODULE$.equals(option)) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Controller returned an invalid leader recovery state (").append(partition.leaderRecoveryState()).append(") for ").append(tp).append(": ").append(partition).toString());
                        partitionResponses.update((Object)tp, (Object)package$.MODULE$.Left().apply((Object)Errors.UNKNOWN_SERVER_ERROR));
                        return;
                    }
                    throw new MatchError((Object)option);
                }
                partitionResponses.update((Object)tp, (Object)package$.MODULE$.Left().apply((Object)apiError));
            }));
            inflightAlterIsrItems.foreach((Function1 & Serializable)inflightAlterIsr -> {
                Object object;
                Option option = partitionResponses.get((Object)inflightAlterIsr.topicPartition());
                if (option instanceof Some) {
                    boolean bl;
                    Either leaderAndIsrOrError = (Either)((Some)option).value();
                    this.unsentIsrUpdates().remove(inflightAlterIsr.topicPartition());
                    if (leaderAndIsrOrError instanceof Left) {
                        Errors error = (Errors)((Left)leaderAndIsrOrError).value();
                        bl = inflightAlterIsr.future().completeExceptionally((Throwable)error.exception());
                    } else if (leaderAndIsrOrError instanceof Right) {
                        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Right)leaderAndIsrOrError).value();
                        bl = inflightAlterIsr.future().complete(leaderAndIsr);
                    } else {
                        throw new MatchError((Object)leaderAndIsrOrError);
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)bl);
                } else if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Partition ").append(inflightAlterIsr.topicPartition()).append(" was sent but not included in the response").toString());
                    object = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
                return object;
            });
        } else {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(88).append("Controller returned an unexpected top-level error when handling AlterPartition request: ").append(errors).toString());
        }
        return Errors.forCode((short)data.errorCode());
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(DefaultAlterIsrManager $this, AlterPartitionRequestData.TopicData topicData$1, AlterIsrItem item) {
        AlterPartitionRequestData.PartitionData partitionData = new AlterPartitionRequestData.PartitionData().setPartitionIndex(item.topicPartition().partition()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch()).setNewIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)item.leaderAndIsr().isr().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setPartitionEpoch(item.leaderAndIsr().zkVersion());
        if ($this.ibpVersion.$greater$eq(KAFKA_3_2_IV0$.MODULE$)) {
            partitionData.setLeaderRecoveryState(item.leaderAndIsr().leaderRecoveryState().value());
        }
        return topicData$1.partitions().add(partitionData);
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(DefaultAlterIsrManager $this, AlterPartitionRequestData message$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            scala.collection.immutable.Seq items = (scala.collection.immutable.Seq)x0$1._2();
            AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setName(topic);
            message$2.topics().add(topicData);
            items.foreach((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DefaultAlterIsrManager.$anonfun$buildRequest$3($this, topicData, item)));
            return;
        }
        throw new MatchError(null);
    }

    public DefaultAlterIsrManager(BrokerToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier, ApiVersion ibpVersion) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.ibpVersion = ibpVersion;
        this.unsentIsrUpdates = new ConcurrentHashMap<TopicPartition, AlterIsrItem>();
        this.inflightRequest = new AtomicBoolean(false);
    }
}

