/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Optional;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005I2Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C\u0001-!)!\u0006\u0001C\u0001-!)A\u0006\u0001C\u0001-!)a\u0006\u0001C\u0001-!)\u0001\u0007\u0001C\u0001-\t)B*[:u\u0007>t7/^7fe\u001e\u0013x.\u001e9UKN$(BA\u0005\u000b\u0003\u0015\tG-\\5o\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003!I!!\u0005\u0005\u00031\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011q\u0002A\u0001\u0017i\u0016\u001cH\u000fT5ti\u000e{gn];nKJ<%o\\;qgR\tq\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0003V]&$\bF\u0001\u0002\u001f!\ty\u0002&D\u0001!\u0015\t\t#%A\u0002ba&T!a\t\u0013\u0002\u000f),\b/\u001b;fe*\u0011QEJ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002O\u0005\u0019qN]4\n\u0005%\u0002#\u0001\u0002+fgR\f\u0011\u0006^3ti2K7\u000f^,ji\",fN]3d_\u001et\u0017N_3e\u001d\u0016<8i\u001c8tk6,'o\u00149uS>t\u0007FA\u0002\u001f\u0003\u0001\"Xm\u001d;MSN$8i\u001c8tk6,'o\u0012:pkB\u001cx+\u001b;i'R\fG/Z:)\u0005\u0011q\u0012!\t;fgR\u001cuN\\:v[\u0016\u0014xI]8vaN#\u0018\r^3t\rJ|Wn\u0015;sS:<\u0007FA\u0003\u001f\u0003Q!Xm\u001d;MSN$xI]8va\u000e{W.\\1oI\"\u0012aA\b")
public class ListConsumerGroupTest
extends ConsumerGroupCommandTest {
    @Test
    public void testListConsumerGroups() {
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list"};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Set expectedGroups = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.group(), simpleGroup}));
        Predef$.MODULE$.Set().empty();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Set set = service.listConsumerGroups().toSet();
            Set set2 = expectedGroups;
            if (!(set2 != null ? !set2.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(44).append("Expected --list to show groups ").append(expectedGroups).append(", but found ").append(set).append(".").toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testListWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = new String[]{"--new-consumer", "--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list"};
        Assertions.assertThrows(OptionException.class, () -> this.getConsumerGroupService(cgcArgs));
    }

    @Test
    public void testListConsumerGroupsWithStates() {
        Set set;
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list", "--state"};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Set expectedListing = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupListing[]{new ConsumerGroupListing(simpleGroup, true, Optional.of(ConsumerGroupState.EMPTY)), new ConsumerGroupListing(this.group(), false, Optional.of(ConsumerGroupState.STABLE))}));
        Predef$.MODULE$.Set().empty();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            set = service.listConsumerGroupsWithState(Predef$.MODULE$.wrapRefArray((Object[])ConsumerGroupState.values()).toSet()).toSet();
            Set set2 = expectedListing;
            if (!(set2 != null ? !set2.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(36).append("Expected to show groups ").append(expectedListing).append(", but found ").append(set).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Set expectedListingStable = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupListing[]{new ConsumerGroupListing(this.group(), false, Optional.of(ConsumerGroupState.STABLE))}));
        Predef$.MODULE$.Set().empty();
        set = null;
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            set = service.listConsumerGroupsWithState((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE}))).toSet();
            Set set3 = expectedListingStable;
            if (!(set3 != null ? !set3.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)new StringBuilder(36).append("Expected to show groups ").append(expectedListingStable).append(", but found ").append(set).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
    }

    @Test
    public void testConsumerGroupStatesFromString() {
        Set result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Stable");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE})), (Object)result);
        result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Stable, PreparingRebalance");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE, ConsumerGroupState.PREPARING_REBALANCE})), (Object)result);
        result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Dead,CompletingRebalance,");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.DEAD, ConsumerGroupState.COMPLETING_REBALANCE})), (Object)result);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("bad, wrong"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("stable"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("  bad, Stable"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("   ,   ,"));
    }

    @Test
    public void testListGroupCommand() {
        String string;
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        ObjectRef cgcArgs = ObjectRef.create((Object)new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list"});
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(!(string = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem))).contains("STATE") && string.contains(simpleGroup) && string.contains(this.group()))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(45).append("Expected to find ").append(simpleGroup).append(", ").append(this.group()).append(" and no header, but found ").append(string).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        cgcArgs.elem = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list", "--state"};
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((string = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem))).contains("STATE") && string.contains(simpleGroup) && string.contains(this.group()))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)new StringBuilder(46).append("Expected to find ").append(simpleGroup).append(", ").append(this.group()).append(" and the header, but found ").append(string).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        cgcArgs.elem = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--list", "--state", "Stable"};
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!((string = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem))).contains("STATE") && string.contains(this.group()) && string.contains("Stable"))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                Assertions.fail((String)new StringBuilder(60).append("Expected to find ").append(this.group()).append(" in state Stable and the header, but found ").append(string).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l5), l6));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroups$1(ObjectRef foundGroups$1, ConsumerGroupCommand.ConsumerGroupService service$1, Set expectedGroups$1) {
        foundGroups$1.elem = service$1.listConsumerGroups().toSet();
        Set set = expectedGroups$1;
        Set set2 = (Set)foundGroups$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroups$2(Set expectedGroups$1, ObjectRef foundGroups$1) {
        return new StringBuilder(44).append("Expected --list to show groups ").append(expectedGroups$1).append(", but found ").append((Set)foundGroups$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroupsWithStates$1(ObjectRef foundListing$1, ConsumerGroupCommand.ConsumerGroupService service$2, Set expectedListing$1) {
        foundListing$1.elem = service$2.listConsumerGroupsWithState(Predef$.MODULE$.wrapRefArray((Object[])ConsumerGroupState.values()).toSet()).toSet();
        Set set = expectedListing$1;
        Set set2 = (Set)foundListing$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroupsWithStates$2(Set expectedListing$1, ObjectRef foundListing$1) {
        return new StringBuilder(36).append("Expected to show groups ").append(expectedListing$1).append(", but found ").append((Set)foundListing$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroupsWithStates$3(ObjectRef foundListing$1, ConsumerGroupCommand.ConsumerGroupService service$2, Set expectedListingStable$1) {
        foundListing$1.elem = service$2.listConsumerGroupsWithState((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE}))).toSet();
        Set set = expectedListingStable$1;
        Set set2 = (Set)foundListing$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroupsWithStates$4(Set expectedListingStable$1, ObjectRef foundListing$1) {
        return new StringBuilder(36).append("Expected to show groups ").append(expectedListingStable$1).append(", but found ").append((Set)foundListing$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$1(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$2, String simpleGroup$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem));
        return !((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains(simpleGroup$1) && ((String)out$1.elem).contains($this.group());
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$3(ListConsumerGroupTest $this, String simpleGroup$1, ObjectRef out$1) {
        return new StringBuilder(45).append("Expected to find ").append(simpleGroup$1).append(", ").append($this.group()).append(" and no header, but found ").append((String)out$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$4(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$2, String simpleGroup$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem));
        return ((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains(simpleGroup$1) && ((String)out$1.elem).contains($this.group());
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$6(ListConsumerGroupTest $this, String simpleGroup$1, ObjectRef out$1) {
        return new StringBuilder(46).append("Expected to find ").append(simpleGroup$1).append(", ").append($this.group()).append(" and the header, but found ").append((String)out$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$7(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$2) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$2.elem));
        return ((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains($this.group()) && ((String)out$1.elem).contains("Stable");
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$9(ListConsumerGroupTest $this, ObjectRef out$1) {
        return new StringBuilder(60).append("Expected to find ").append($this.group()).append(" in state Stable and the header, but found ").append((String)out$1.elem).toString();
    }
}

