/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.log.CleanerConfig;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogMetricNames$;
import kafka.log.LogSegment;
import kafka.log.TimeIndex;
import kafka.log.UnifiedLog;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.directory.api.util.FileUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t%d\u0001B\u001d;\u0001}BQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013\u00051\n\u0003\u0004S\u0001\u0001\u0006I\u0001\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0001U\u0011\u0019A\u0006\u0001)A\u0005+\"9\u0011\f\u0001b\u0001\n\u0003!\u0006B\u0002.\u0001A\u0003%Q\u000bC\u0004\\\u0001\t\u0007I\u0011\u0001/\t\r\u0015\u0004\u0001\u0015!\u0003^\u0011\u001d1\u0007A1A\u0005\u0002\u001dDaa\u001b\u0001!\u0002\u0013A\u0007b\u00027\u0001\u0001\u0004%\t!\u001c\u0005\bi\u0002\u0001\r\u0011\"\u0001v\u0011\u0019Y\b\u0001)Q\u0005]\"9A\u0010\u0001a\u0001\n\u0003i\b\"CA\u0002\u0001\u0001\u0007I\u0011AA\u0003\u0011\u001d\tI\u0001\u0001Q!\nyD\u0011\"a\u0003\u0001\u0005\u0004%\t!!\u0004\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u001fA\u0011\"!\b\u0001\u0005\u0004%\t!a\b\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u0003CAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002H\u0001!\t!a\u000b\t\u000f\u0005E\u0003\u0001\"\u0001\u0002,!9\u00111\f\u0001\u0005\u0002\u0005-\u0002bBA0\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003G\u0002A\u0011AA\u0016\u0011\u001d\t9\u0007\u0001C\u0001\u0003WAq!a\u001b\u0001\t\u0003\tY\u0003C\u0004\u0002p\u0001!\t!a\u000b\t\u000f\u0005M\u0004\u0001\"\u0001\u0002,!9\u0011q\u000f\u0001\u0005\u0002\u0005-\u0002bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003/\u0003A\u0011AA\u0016\u0011\u001d\tY\n\u0001C\u0001\u0003WAq!a(\u0001\t\u0003\tY\u0003C\u0004\u0002$\u0002!\t!a\u000b\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002,!9\u00111\u0016\u0001\u0005\u0002\u0005-\u0002bBAX\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0003?\u0004A\u0011BAq\u0011%\ti\u0010AI\u0001\n\u0013\ty\u0010C\u0005\u0003\u0016\u0001\t\n\u0011\"\u0003\u0003\u0018!9!1\u0004\u0001\u0005\u0002\u0005-\u0002b\u0002B\u0010\u0001\u0011\u0005\u00111\u0006\u0005\b\u0005G\u0001A\u0011AA\u0016\u0011\u001d\u00119\u0003\u0001C\u0005\u0005SA\u0011Ba\u0011\u0001#\u0003%IA!\u0012\t\u000f\t%\u0003\u0001\"\u0001\u0002,!9!Q\n\u0001\u0005\u0002\u0005-\u0002b\u0002B)\u0001\u0011\u0005\u00111\u0006\u0005\b\u0005+\u0002A\u0011AA\u0016\u0011\u001d\u0011I\u0006\u0001C\u0001\u0003WAqA!\u0018\u0001\t\u0003\tY\u0003C\u0004\u0003b\u0001!\t!a\u000b\t\u000f\t\u0015\u0004\u0001\"\u0001\u0002,\tqAj\\4NC:\fw-\u001a:UKN$(BA\u001e=\u0003\rawn\u001a\u0006\u0002{\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001A!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0013\t\u0003\u0013\u0002i\u0011AO\u0001\u0005i&lW-F\u0001M!\ti\u0005+D\u0001O\u0015\tyE(A\u0003vi&d7/\u0003\u0002R\u001d\nAQj\\2l)&lW-A\u0003uS6,\u0007%A\bnCb\u0014v\u000e\u001c7J]R,'O^1m+\u0005)\u0006CA!W\u0013\t9&IA\u0002J]R\f\u0001#\\1y%>dG.\u00138uKJ4\u0018\r\u001c\u0011\u0002\u00175\f\u0007\u0010T8h\u0003\u001e,Wj]\u0001\r[\u0006DHj\\4BO\u0016l5\u000fI\u0001\tY><\u0007K]8qgV\tQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006!Q\u000f^5m\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\u0015A\u0013x\u000e]3si&,7/A\u0005m_\u001e\u0004&o\u001c9tA\u0005IAn\\4D_:4\u0017nZ\u000b\u0002QB\u0011\u0011*[\u0005\u0003Uj\u0012\u0011\u0002T8h\u0007>tg-[4\u0002\u00151|wmQ8oM&<\u0007%\u0001\u0004m_\u001e$\u0015N]\u000b\u0002]B\u0011qN]\u0007\u0002a*\u0011\u0011/Y\u0001\u0003S>L!a\u001d9\u0003\t\u0019KG.Z\u0001\u000bY><G)\u001b:`I\u0015\fHC\u0001<z!\t\tu/\u0003\u0002y\u0005\n!QK\\5u\u0011\u001dQX\"!AA\u00029\f1\u0001\u001f\u00132\u0003\u001dawn\u001a#je\u0002\n!\u0002\\8h\u001b\u0006t\u0017mZ3s+\u0005q\bCA%\u0000\u0013\r\t\tA\u000f\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0004m\u0006\u001d\u0001b\u0002>\u0011\u0003\u0003\u0005\rA`\u0001\fY><W*\u00198bO\u0016\u0014\b%\u0001\u0003oC6,WCAA\b!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000bC\u0006!A.\u00198h\u0013\u0011\tI\"a\u0005\u0003\rM#(/\u001b8h\u0003\u0015q\u0017-\\3!\u0003e1XM]=MCJ<W\rT8h\r2,8\u000f[%oi\u0016\u0014h/\u00197\u0016\u0005\u0005\u0005\u0002cA!\u0002$%\u0019\u0011Q\u0005\"\u0003\t1{gnZ\u0001\u001bm\u0016\u0014\u0018\u0010T1sO\u0016dun\u001a$mkND\u0017J\u001c;feZ\fG\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002m\"\u001aa#a\f\u0011\t\u0005E\u00121I\u0007\u0003\u0003gQA!!\u000e\u00028\u0005\u0019\u0011\r]5\u000b\t\u0005e\u00121H\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\ti$a\u0010\u0002\u000b),h.\u001b;\u000b\u0005\u0005\u0005\u0013aA8sO&!\u0011QIA\u001a\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001aq#a\u0013\u0011\t\u0005E\u0012QJ\u0005\u0005\u0003\u001f\n\u0019DA\u0005BMR,'/R1dQ\u0006iA/Z:u\u0007J,\u0017\r^3M_\u001eD3\u0001GA+!\u0011\t\t$a\u0016\n\t\u0005e\u00131\u0007\u0002\u0005)\u0016\u001cH/\u0001\u0013uKN$\b*\u00198eY&tw-\u0012=dKB$\u0018n\u001c8t\tV\u0014\u0018N\\4TQV$Hm\\<oQ\rI\u0012QK\u0001\u001fi\u0016\u001cHo\u0011:fCR,Gj\\4XSRD\u0017J\u001c<bY&$Gj\\4ESJD3AGA+\u0003}!Xm\u001d;De\u0016\fG/\u001a'pO^KG\u000f\u001b'pO\u0012K'OR1mY\n\f7m\u001b\u0015\u00047\u0005U\u0013!\u0006;fgR<U\r\u001e(p]\u0016C\u0018n\u001d;f]Rdun\u001a\u0015\u00049\u0005U\u0013A\u0007;fgR\u001cE.Z1okB,\u0005\u0010]5sK\u0012\u001cVmZ7f]R\u001c\bfA\u000f\u0002V\u0005\tC/Z:u\u00072,\u0017M\\;q'\u0016<W.\u001a8ugR{W*Y5oi\u0006LgnU5{K\"\u001aa$!\u0016\u0002UQ,7\u000f\u001e#pKNtGo\u00117fC:dunZ:XSRD7i\\7qC\u000e$H)\u001a7fi\u0016\u0004v\u000e\\5ds\"\u001aq$!\u0016\u0002IQ,7\u000f\u001e#pKNtGo\u00117fC:dunZ:XSRD7i\\7qC\u000e$\bk\u001c7jGfD3\u0001IA+\u0003M!Xm\u001d;E_\u0016\u001ch\u000e^\"mK\u0006tGj\\4t)\r1\u0018q\u0010\u0005\b\u0003\u0003\u000b\u0003\u0019AAB\u0003\u0019\u0001x\u000e\\5dsB!\u0011QQAJ\u001d\u0011\t9)a$\u0011\u0007\u0005%%)\u0004\u0002\u0002\f*\u0019\u0011Q\u0012 \u0002\rq\u0012xn\u001c;?\u0013\r\t\tJQ\u0001\u0007!J,G-\u001a4\n\t\u0005e\u0011Q\u0013\u0006\u0004\u0003#\u0013\u0015A\u0005;fgR$\u0016.\\3CCN,GM\u00127vg\"D3AIA+\u0003e!Xm\u001d;MK\u0006\u001cH\u000fT8bI\u0016$\u0017i]:jO:lWM\u001c;)\u0007\r\n)&A\u0012uKN$Hk^8M_\u001el\u0015M\\1hKJ\u001cXk]5oON\u000bW.\u001a#je\u001a\u000b\u0017\u000e\\:)\u0007\u0011\n)&\u0001\u000fuKN$8\t[3dWB|\u0017N\u001c;SK\u000e|g/\u001a:z!>Lg\u000e^:)\u0007\u0015\n)&A\u0017uKN$(+Z2pm\u0016\u0014\u0018\u0010R5sK\u000e$xN]=NCB\u0004\u0018N\\4XSRDGK]1jY&twm\u00157bg\"D3AJA+\u0003E\"Xm\u001d;SK\u000e|g/\u001a:z\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001e<\u0016\u000e\u001e5SK2\fG/\u001b<f\t&\u0014Xm\u0019;pefD3aJA+\u0003a1XM]5gs\u000eCWmY6q_&tGOU3d_Z,'/\u001f\u000b\bm\u0006M\u00161\\Ao\u0011\u001d\t)\f\u000ba\u0001\u0003o\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0003s\u000b\u0019-!3\u000f\t\u0005m\u0016q\u0018\b\u0005\u0003\u0013\u000bi,C\u0001D\u0013\r\t\tMQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)-a2\u0003\u0007M+\u0017OC\u0002\u0002B\n\u0003B!a3\u0002X6\u0011\u0011Q\u001a\u0006\u0005\u0003\u001f\f\t.\u0001\u0004d_6lwN\u001c\u0006\u0004{\u0005M'\u0002BAk\u0003\u007f\ta!\u00199bG\",\u0017\u0002BAm\u0003\u001b\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003}Q\u0001\u0007a\u0010C\u0003mQ\u0001\u0007a.\u0001\tde\u0016\fG/\u001a'pO6\u000bg.Y4feR)a0a9\u0002j\"I\u0011Q]\u0015\u0011\u0002\u0003\u0007\u0011q]\u0001\bY><G)\u001b:t!\u0015\tI,a1o\u0011%\tY/\u000bI\u0001\u0002\u0004\ti/\u0001\td_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ssB!\u0011q^A}\u001b\t\t\tP\u0003\u0003\u0002t\u0006U\u0018\u0001C7fi\u0006$\u0017\r^1\u000b\u0007\u0005]H(\u0001\u0004tKJ4XM]\u0005\u0005\u0003w\f\tP\u0001\tD_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0006Q2M]3bi\u0016dunZ'b]\u0006<WM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0001\u0016\u0005\u0003O\u0014\u0019a\u000b\u0002\u0003\u0006A!!q\u0001B\t\u001b\t\u0011IA\u0003\u0003\u0003\f\t5\u0011!C;oG\",7m[3e\u0015\r\u0011yAQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\n\u0005\u0013\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i\u0019'/Z1uK2{w-T1oC\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IB\u000b\u0003\u0002n\n\r\u0011A\t;fgR4\u0015\u000e\\3SK\u001a,'/\u001a8dKN\fe\r^3s\u0003NLhn\u0019#fY\u0016$X\rK\u0002-\u0003+\n!\u0005^3ti\u000e\u0013X-\u0019;f\u0003:$G)\u001a7fi\u0016|e/\u001a:ms2{gn\u001a+pa&\u001c\u0007fA\u0017\u0002V\u0005\tC/Z:u\u0007\",7m\u001b9pS:$hi\u001c:P]2L\u0018I\u001a4fGR,G\rT8hg\"\u001aa&!\u0016\u0002\u000fI,\u0017\r\u001a'pORA!1\u0006B\u001a\u0005w\u0011y\u0004\u0005\u0003\u0003.\t=RBAA{\u0013\u0011\u0011\t$!>\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011\u0019Yt\u00061\u0001\u00036A\u0019\u0011Ja\u000e\n\u0007\te\"H\u0001\u0006V]&4\u0017.\u001a3M_\u001eDqA!\u00100\u0001\u0004\t\t#\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\t\u0005\u0003z\u0003\u0013!a\u0001+\u0006IQ.\u0019=MK:<G\u000f[\u0001\u0012e\u0016\fG\rT8hI\u0011,g-Y;mi\u0012\u001aTC\u0001B$U\r)&1A\u0001&i\u0016\u001cH\u000fV8qS\u000e\u001cuN\u001c4jO\u000eC\u0017M\\4f+B$\u0017\r^3t\u0019><7i\u001c8gS\u001eD3!MA+\u0003u!Xm\u001d;D_:4\u0017nZ\"iC:<WmR3ug\u000ecW-\u00198fIV\u0003\bf\u0001\u001a\u0002V\u0005AC/Z:u\u0005J|7.\u001a:D_:4\u0017nZ\"iC:<W\rR3mSZ,'/\u001a3U_\u0006cG\u000eT8hg\"\u001a1'!\u0016\u0002gQ,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKN#x\u000e]\"mK\u0006t\u0017N\\4JM\u000e{W\u000e]1di&\u001b(+Z7pm\u0016$\u0007f\u0001\u001b\u0002V\u0005aC/Z:u\u0007>tg-[4DQ\u0006tw-Z:XSRDgj\u001c'pO\u001e+G\u000f^5oO&s\u0017\u000e^5bY&TX\r\u001a\u0015\u0004k\u0005U\u0013\u0001\r;fgRlU\r\u001e:jGN,\u00050[:u/\",g\u000eT8h\u0013N\u0014Vm\u0019:fCR,GMQ3g_J,G)\u001a7fi&|g\u000eK\u00027\u0003+\n\u0011\u0007^3ti6+GO]5dg\u0006\u0013XMU3n_Z,Gm\u00165f]6{g/\u001b8h\u0007V\u0014(/\u001a8u)>4U\u000f^;sK2{w\rK\u00028\u0003+\n\u0001\u0004^3ti^\u000b\u0017\u000e\u001e$pe\u0006cG\u000eV8D_6\u0004H.\u001a;fQ\rA\u0014Q\u000b")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
    }

    @AfterEach
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        if (this.logManager() != null) {
            this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
                LogManagerTest.$anonfun$tearDown$1(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testHandlingExceptionsDuringShutdown() {
        File file;
        File file2;
        File file3;
        File file4;
        File file5;
        File file6;
        File file7 = file6 = TestUtils.tempDirectory(null, null);
        file6 = null;
        File file8 = file5 = file7;
        file5 = null;
        File file9 = file4 = file8;
        file4 = null;
        File logDir1 = file9;
        File file10 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file11 = file2 = file10;
        file2 = null;
        File file12 = file = file11;
        file = null;
        File logDir2 = file12;
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{logDir1, logDir2}))), new MockConfigRepository()));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            ((LogManager)logManagerForTest.get()).startup((Set)Predef$.MODULE$.Set().empty());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            TopicPartition x$1 = new TopicPartition(this.name(), 0);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            UnifiedLog log1 = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$5 = new TopicPartition(this.name(), 1);
            None$ x$6 = None$.MODULE$;
            boolean x$7 = qual$2.getOrCreateLog$default$2();
            boolean x$8 = qual$2.getOrCreateLog$default$3();
            UnifiedLog log2 = qual$2.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
            File logFile1 = new File(logDir1, new StringBuilder(2).append(this.name()).append("-0").toString());
            Assertions.assertTrue((boolean)logFile1.exists());
            Assertions.assertTrue((boolean)new File(logDir2, new StringBuilder(2).append(this.name()).append("-1").toString()).exists());
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log1.takeProducerSnapshot();
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            log2.takeProducerSnapshot();
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            FileUtils.deleteDirectory((File)logFile1);
            ((LogManager)logManagerForTest.get()).shutdown();
            Assertions.assertFalse((boolean)Files.exists(new File(logDir1, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable)manager -> {
                LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        scala.collection.immutable.Seq dirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir(), new File("\u0000")}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, true, x$4, (Option)x$3);
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$1 -> LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$1))).map((Function1 & Serializable)x$2 -> this.logDir().toPath().resolve((String)x$2).toFile());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository())));
        scala.collection.mutable.Set brokenDirs = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = new TopicPartition(this.name(), 0);
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$12, true, x$4, (Option)x$3);
        Assertions.assertEquals((int)(dirs.length() / 2), (int)brokenDirs.size());
        Function1 & Serializable containsLogFile = (Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$4(this, dir));
        Assertions.assertEquals((int)1, (int)dirs.count((Function1)containsLogFile), (String)"More than one log file created");
        Assertions.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log, (String)"No log should be found.");
        Assertions.assertFalse((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$32 = qual$1.getOrCreateLog$default$2();
        boolean x$42 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$32, x$42, (Option)x$2);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$1.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        log.logSegments().foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$4)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        log.logSegments().foreach((Function1 & Serializable)s -> {
            s.lazyOffsetIndex().get();
            return (TimeIndex)s.lazyTimeIndex().get();
        });
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        int n = 1024;
        long readLog_offset = offset.elem + 1L;
        Assertions.assertEquals((int)0, (int)log.read(readLog_offset, n, (FetchIsolation)FetchLogEnd$.MODULE$, true).records().sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> {
            int n = 1024;
            long readLog_offset = 0L;
            log.read(readLog_offset, n, (FetchIsolation)FetchLogEnd$.MODULE$, true);
        }, () -> "Should get exception from fetching earlier.");
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes();
        this.logManager().shutdown();
        int segmentBytes = 10 * setSize;
        Properties properties = new Properties();
        properties.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(segmentBytes));
        properties.put(LogConfig$.MODULE$.RetentionBytesProp(), Long.toString(50L * (long)setSize + 10L));
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), properties);
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, configRepository));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$3 = new TopicPartition(this.name(), 0);
        None$ x$4 = None$.MODULE$;
        boolean x$52 = qual$1.getOrCreateLog$default$2();
        boolean x$6 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$3, x$52, x$6, (Option)x$4);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$2.elem = ((LogOffsetMetadata)info.firstOffset().get()).messageOffset();
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)6, (int)log.numberOfSegments(), (String)"Now there should be exactly 6 segments");
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        int n = 1024;
        long readLog_offset = offset.elem + 1L;
        Assertions.assertEquals((int)0, (int)log.read(readLog_offset, n, (FetchIsolation)FetchLogEnd$.MODULE$, true).records().sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> {
            int n = 1024;
            long readLog_offset = 0L;
            log.read(readLog_offset, n, (FetchIsolation)FetchLogEnd$.MODULE$, true);
        });
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, configRepository));
        LogManager qual$1 = this.logManager();
        TopicPartition x$3 = new TopicPartition(this.name(), 0);
        None$ x$4 = None$.MODULE$;
        boolean x$5 = qual$1.getOrCreateLog$default$2();
        boolean x$62 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$3, x$5, x$62, (Option)x$4);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$3.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.logSegments().foreach((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$2(this, x$7)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"number of segments shouldn't have changed");
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), LogConfig$.MODULE$.FlushMsProp(), "1000");
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, configRepository));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$3 = new TopicPartition(this.name(), 0);
        None$ x$4 = None$.MODULE$;
        boolean x$5 = qual$1.getOrCreateLog$default$2();
        boolean x$6 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$3, x$5, x$6, (Option)x$4);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable)x$8 -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)x$8)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((lastFlush != log.lastFlushTime() ? 1 : 0) != 0, (String)"Time based flush should have been triggered");
    }

    @Test
    public void testLeastLoadedAssignment() {
        Object[] objectArray = new File[3];
        objectArray[0] = TestUtils.tempDirectory(null, null);
        objectArray[1] = TestUtils.tempDirectory(null, null);
        objectArray[2] = TestUtils.tempDirectory(null, null);
        scala.collection.immutable.Seq dirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = new TopicPartition("test", partition);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            Assertions.assertEquals((int)(partition + 1), (int)this.logManager().allLogs().size(), (String)"We should have created the right number of logs");
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable)x$9 -> x$9.dir().getParent()).values().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()));
            Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0, (String)"Load should balance evenly");
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        Assertions.assertThrows(KafkaException.class, () -> this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository()));
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1), new TopicPartition("test-b", 1)}))), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        Object[] objectArray = new File[1];
        objectArray[0] = new File(new StringBuilder(0).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append(File.separator).toString());
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), LogConfig$.MODULE$.apply(), new MockConfigRepository(), TestUtils$.MODULE$.createLogManager$default$4(), new MockTime(), ApiVersion$.MODULE$.latestVersion()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{new File("data", this.logDir().getName()).getAbsoluteFile()}))), new MockConfigRepository()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(scala.collection.immutable.Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        scala.collection.immutable.Seq logs = (scala.collection.immutable.Seq)topicPartitions.map((Function1 & Serializable)x$11 -> {
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$11, x$3, x$4, (Option)x$2);
        });
        logs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)topicPartitions.zip((IterableOnce)logs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(scala.collection.immutable.Seq<File> logDirs, ConfigRepository configRepository) {
        ApiVersion apiVersion;
        LogConfig x$1 = this.logConfig();
        MockTime x$4 = this.time();
        CleanerConfig x$5 = TestUtils$.MODULE$.createLogManager$default$4();
        ApiVersion apiVersion2 = apiVersion = ApiVersion$.MODULE$.latestVersion();
        apiVersion = null;
        ApiVersion x$6 = apiVersion2;
        return TestUtils$.MODULE$.createLogManager((Seq<File>)logDirs, x$1, configRepository, x$5, x$4, x$6);
    }

    private scala.collection.immutable.Seq<File> createLogManager$default$1() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}));
    }

    private ConfigRepository createLogManager$default$2() {
        return new MockConfigRepository();
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        Object[] indexFilesOnDiskBeforeDelete = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles()), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$13)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(x$5, x$6, x$7).get();
        LogSegment removedSegment = removedLog.activeSegment();
        scala.collection.immutable.Seq indexFilesAfterDelete = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{removedSegment.lazyOffsetIndex().file(), removedSegment.lazyTimeIndex().file(), removedSegment.txnIndex().file()}));
        Assertions.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(indexFilesOnDiskBeforeDelete), (Function1 & Serializable)fileBeforeDelete -> {
            LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete, fileBeforeDelete);
            return BoxedUnit.UNIT;
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs deleted too early");
        this.time().sleep(Predef$.MODULE$.Long2long(this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assertions.assertFalse((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs not deleted");
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(invalidTopicName, 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        qual$2.asyncDelete(x$5, x$6, x$7);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        scala.collection.immutable.Seq tps = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 0), new TopicPartition("test-a", 1), new TopicPartition("test-a", 2), new TopicPartition("test-b", 0), new TopicPartition("test-b", 1)}));
        scala.collection.immutable.Seq allLogs = (scala.collection.immutable.Seq)tps.map((Function1 & Serializable)x$16 -> {
            LogManager qual$1 = this.logManager();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            return qual$1.getOrCreateLog(x$16, x$3, x$4, (Option)x$2);
        });
        allLogs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsInDir(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)tps.zip((IterableOnce)allLogs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(UnifiedLog log, long offset, int maxLength) {
        return log.read(offset, maxLength, (FetchIsolation)FetchLogEnd$.MODULE$, true);
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.topicConfigUpdated(testTopicOne);
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        spyLogManager.initializingLog(testTopicPartition);
        spyLogManager.finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicPartition.topic());
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        UnifiedLog mockLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.brokerConfigUpdated();
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicTwo);
    }

    @Test
    public void testTopicConfigChangeStopCleaningIfCompactIsRemoved() {
        this.logManager().shutdown();
        MockConfigRepository x$1 = new MockConfigRepository();
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$2, x$1));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        String topic = "topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Properties oldProperties = new Properties();
        oldProperties.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig oldLogConfig = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), oldProperties);
        None$ x$4 = None$.MODULE$;
        boolean x$5 = spyLogManager.getOrCreateLog$default$2();
        boolean x$6 = spyLogManager.getOrCreateLog$default$3();
        UnifiedLog log0 = spyLogManager.getOrCreateLog(tp0, x$5, x$6, (Option)x$4);
        log0.updateConfig(oldLogConfig);
        None$ x$8 = None$.MODULE$;
        boolean x$9 = spyLogManager.getOrCreateLog$default$2();
        boolean x$10 = spyLogManager.getOrCreateLog$default$3();
        UnifiedLog log1 = spyLogManager.getOrCreateLog(tp1, x$9, x$10, (Option)x$8);
        log1.updateConfig(oldLogConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnifiedLog[]{log0, log1})), (Object)spyLogManager.logsByTopic(topic).toSet());
        Properties newProperties = new Properties();
        newProperties.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        spyLogManager.updateTopicConfig(topic, newProperties);
        Assertions.assertTrue((boolean)log0.config().delete());
        Assertions.assertTrue((boolean)log1.config().delete());
        Assertions.assertFalse((boolean)log0.config().compact());
        Assertions.assertFalse((boolean)log1.config().compact());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).topicConfigUpdated(topic);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp0);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp1);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        UnifiedLog removedLog = (UnifiedLog)qual$2.asyncDelete(tp, x$6, x$7).get();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$1(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        None$ x$9 = None$.MODULE$;
        boolean x$10 = qual$3.getOrCreateLog$default$2();
        boolean x$11 = qual$3.getOrCreateLog$default$3();
        qual$3.getOrCreateLog(tp, x$10, x$11, (Option)x$9);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        Assertions.assertTrue((boolean)removedLog.logSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File file;
        File file2;
        File file3;
        File file4;
        File file5;
        File file6;
        File file7 = file6 = TestUtils.tempDirectory(null, null);
        file6 = null;
        File file8 = file5 = file7;
        file5 = null;
        File file9 = file4 = file8;
        file4 = null;
        File dir1 = file9;
        File file10 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file11 = file2 = file10;
        file2 = null;
        File file12 = file = file11;
        file = null;
        File dir2 = file12;
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{dir1, dir2}))), new MockConfigRepository()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.getOrCreateLog$default$2();
        qual$2.getOrCreateLog(tp, x$8, true, (Option)x$7);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    @Test
    public void testWaitForAllToComplete() {
        IntRef invokedCount = IntRef.create((int)0);
        Future success = (Future)Mockito.mock(Future.class);
        Mockito.when(success.get()).thenAnswer(x$18 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testWaitForAllToComplete$1(invokedCount, x$18)));
        Future failure = (Future)Mockito.mock(Future.class);
        Mockito.when(failure.get()).thenAnswer(x$19 -> {
            ++invokedCount$1.elem;
            throw new RuntimeException();
        });
        IntRef failureCount = IntRef.create((int)0);
        boolean bl = ((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{success, failure}))).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$20 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$3(failureCount, x$20);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl);
        Assertions.assertEquals((int)2, (int)invokedCount.elem);
        Assertions.assertEquals((int)1, (int)failureCount.elem);
        boolean bl2 = ((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{failure, success}))).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$21 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$4(failureCount, x$21);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl2);
        Assertions.assertEquals((int)4, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        boolean bl3 = ((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{success, success}))).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$22 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$5(failureCount, x$22);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0;
        Assertions.assertTrue((boolean)bl3);
        Assertions.assertEquals((int)6, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        boolean bl4 = ((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{failure, failure}))).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$23 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$6(failureCount, x$23);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl4);
        Assertions.assertEquals((int)8, (int)invokedCount.elem);
        Assertions.assertEquals((int)4, (int)failureCount.elem);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$4(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$4) {
        return x$4.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$2(LogManagerTest $this, LogSegment x$7) {
        return x$7.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(UnifiedLog log$4, int x$8) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4(), log$4.appendAsLeader$default$5());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$12 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$13) {
        return x$13.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$14) {
        String string = x$14.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$14)));
        Assertions.assertEquals((Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable)x$15 -> x$15.getName()), (String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString());
        Assertions.assertNotEquals((Object)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (String)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(UnifiedLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$17 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$4(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            UnifiedLog log = (UnifiedLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$1);
    }

    private static final scala.collection.mutable.Set logMetrics$1(String topicName$1) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$1, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$1) {
        Assertions.assertEquals((int)LogMetricNames$.MODULE$.allMetricNames().size(), (int)LogManagerTest.logMetrics$1(topicName$1).size());
        LogManagerTest.logMetrics$1(topicName$1).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final scala.collection.mutable.Set logMetrics$2(String topicName$2) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$2) {
        Assertions.assertEquals((int)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (int)LogManagerTest.logMetrics$2(topicName$2).size());
        LogManagerTest.logMetrics$2(topicName$2).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testWaitForAllToComplete$1(IntRef invokedCount$1, InvocationOnMock x$18) {
        ++invokedCount$1.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$3(IntRef failureCount$1, Throwable x$20) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$4(IntRef failureCount$1, Throwable x$21) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$5(IntRef failureCount$1, Throwable x$22) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$6(IntRef failureCount$1, Throwable x$23) {
        ++failureCount$1.elem;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Long.toString(Long.MAX_VALUE));
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }
}

