/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.MockTime;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LazyZip2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.View;
import scala.collection.WithFilter;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001B\f\u0019\u0001uAQA\t\u0001\u0005\u0002\rB\u0001\"\n\u0001\t\u0006\u0004%IA\n\u0005\u0006[\u0001!\tE\f\u0005\u0006k\u0001!\tF\u000e\u0005\u0006s\u0001!\tF\u000f\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0006C\u0002!\t!\u0013\u0005\u0006I\u0002!\t!\u0013\u0005\u0006M\u0002!\t!\u0013\u0005\u0006Q\u0002!\t!\u0013\u0005\u0006U\u0002!\t!\u0013\u0005\u0006Y\u0002!\t!\u0013\u0005\u0006]\u0002!\t!\u0013\u0005\u0006g\u0002!\t!\u0013\u0005\u0006m\u0002!\t!\u0013\u0005\u0006q\u0002!\t!\u0013\u0005\u00063\u0001!IA\u001f\u0005\u0006}\u0002!Ia \u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!!$\u0001\t\u0013\ty\tC\u0004\u0002<\u0002!I!!0\u0003\u001b1{wm\u00144gg\u0016$H+Z:u\u0015\tI\"$\u0001\u0004tKJ4XM\u001d\u0006\u00027\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001f!\ty\u0002%D\u0001\u0019\u0013\t\t\u0003DA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002 \u0001\u0005!A/[7f+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u001b\u0003\u0015)H/\u001b7t\u0013\ta\u0013F\u0001\u0005N_\u000e\\G+[7f\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u00121!\u00138u\u0003)\u0011'o\\6feRKW.\u001a\u000b\u0003O]BQ\u0001\u000f\u0003A\u0002=\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$\"a\u000f \u0011\u0005Ab\u0014BA\u001f2\u0005\u0011)f.\u001b;\t\u000b}*\u0001\u0019\u0001!\u0002\u000bA\u0014x\u000e]:\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015\u0001B;uS2T\u0011!R\u0001\u0005U\u00064\u0018-\u0003\u0002H\u0005\nQ\u0001K]8qKJ$\u0018.Z:\u0002;Q,7\u000f^$fi>3gm]3ug\u001a{'/\u00168l]><h\u000eV8qS\u000e$\u0012a\u000f\u0015\u0003\r-\u0003\"\u0001T+\u000e\u00035S!AT(\u0002\u0007\u0005\u0004\u0018N\u0003\u0002Q#\u00069!.\u001e9ji\u0016\u0014(B\u0001*T\u0003\u0015QWO\\5u\u0015\u0005!\u0016aA8sO&\u0011a+\u0014\u0002\u0005)\u0016\u001cH\u000f\u000b\u0004\u00071ncfl\u0018\t\u0003aeK!AW\u0019\u0003\u0015\u0011,\u0007O]3dCR,G-A\u0004nKN\u001c\u0018mZ3\"\u0003u\u000bQ\u0003T5ti>3gm]3ugJ+\u0017/^3ti\u00022\u0006'A\u0003tS:\u001cW-I\u0001a\u0003\u0001\t\u0001\u0005^3ti\u001e+Go\u00144gg\u0016$8/\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\u0012qa\u0013\u0015\u0007\u000fa[FLX0\u0002mQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9G_Jl\u0015\r\u001f+j[\u0016\u001cH/Y7q\u0003\u001a$XM\u001d+sk:\u001c\u0017\r^3)\u0005!Y\u0015\u0001\u0011;fgR4U\r^2i\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004hi\u001c:NCb$\u0016.\\3ti\u0006l\u0007oV5uQVswN\u001d3fe\u0016$G+[7fgR\fW\u000e]:)\u0005%Y\u0015A\b;fgR<U\r^(gMN,Go\u001d\"fM>\u0014X\rT1uKN$H+[7fQ\tQ1*A\fuKN$X)\u001c9us2{wm]$fi>3gm]3ug\"\u00121bS\u00016i\u0016\u001cHOR3uG\"|eMZ:fi\nKH+[7fgR\fW\u000e\u001d$pe6\u000b\u0007\u0010V5nKN$\u0018-\u001c9XSRDW)\u001c9us2{w\r\u000b\u0002\r\u0017\u00069B/Z:u\u000f\u0016$xJ\u001a4tKR\u001c()\u001a4pe\u0016tun\u001e\u0015\u0003\u001b-Cc!\u0004-\\cz{\u0016%\u0001:\u000211,w-Y2z\r\u0016$8\r[(gMN,Go\u001d\"fM>\u0014X-\u0001\u0011uKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/Z#be2LWm\u001d;US6,\u0007F\u0001\bLQ\u0019q\u0001lW9_?\u0006iC/Z:u\r\u0016$8\r[(gMN,Go\u001d\"fM>\u0014XmV5uQ\u000eC\u0017M\\4j]\u001e\u001cVmZ7f]R\u001c\u0016N_3)\u0005=Y\u0015A\u000b;fgR4U\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3XSRD7\t[1oO&twmU3h[\u0016tGo\u001d\u0015\u0003!-+\u0012a\u001f\t\u0003?qL!! \r\u0003\u0017-\u000bgm[1TKJ4XM]\u0001\u0017g\u0016tG\rT5ti>3gm]3ugJ+\u0017/^3tiR!\u0011\u0011AA\f!\u0011\t\u0019!a\u0005\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0005\u0003\u0017\ti!\u0001\u0004d_6lwN\u001c\u0006\u00047\u0005=!bAA\t'\u00061\u0011\r]1dQ\u0016LA!!\u0006\u0002\u0006\t\u0019B*[:u\u001f\u001a47/\u001a;t%\u0016\u001c\bo\u001c8tK\"9\u0011\u0011\u0004\nA\u0002\u0005m\u0011a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u0007\ti\"\u0003\u0003\u0002 \u0005\u0015!A\u0005'jgR|eMZ:fiN\u0014V-];fgR\f\u0001c]3oI\u001a+Go\u00195SKF,Xm\u001d;\u0015\t\u0005\u0015\u00121\u0006\t\u0005\u0003\u0007\t9#\u0003\u0003\u0002*\u0005\u0015!!\u0004$fi\u000eD'+Z:q_:\u001cX\rC\u0004\u0002\u001aM\u0001\r!!\f\u0011\t\u0005\r\u0011qF\u0005\u0005\u0003c\t)A\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0001\tck&dG\rV1sO\u0016$H+[7fgRA\u0011qGA:\u0003\u007f\nI\t\u0005\u0004\u0002:\u0005%\u0013q\n\b\u0005\u0003w\t)E\u0004\u0003\u0002>\u0005\rSBAA \u0015\r\t\t\u0005H\u0001\u0007yI|w\u000e\u001e \n\u0003IJ1!a\u00122\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0013\u0002N\t!A*[:u\u0015\r\t9%\r\t\u0005\u0003#\niG\u0004\u0003\u0002T\u0005\u001dd\u0002BA+\u0003KrA!a\u0016\u0002d9!\u0011\u0011LA1\u001d\u0011\tY&a\u0018\u000f\t\u0005u\u0012QL\u0005\u0002)&\u0019\u0011\u0011C*\n\u0007m\ty!\u0003\u0003\u0002\f\u00055\u0011bA.\u0002\n%!\u0011\u0011NA6\u0003Ya\u0015n\u001d;PM\u001a\u001cX\r^:SKF,Xm\u001d;ECR\f'bA.\u0002\n%!\u0011qNA9\u0005Aa\u0015n\u001d;PM\u001a\u001cX\r^:U_BL7M\u0003\u0003\u0002j\u0005-\u0004bBA;)\u0001\u0007\u0011qO\u0001\u0003iB\u0004B!!\u001f\u0002|5\u0011\u0011\u0011B\u0005\u0005\u0003{\nIA\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005\u0005E\u00031\u0001\u0002\u0004\u0006IA/[7fgR\fW\u000e\u001d\t\u0004a\u0005\u0015\u0015bAADc\t!Aj\u001c8h\u0011\u0019\tY\t\u0006a\u0001_\u0005iQ.\u0019=Ok6|eMZ:fiN\fQBZ5oIB\u000b'\u000f^5uS>tGCBAI\u0003?\u000bI\f\u0005\u0003\u0002\u0014\u0006ee\u0002BA*\u0003+KA!a&\u0002l\u00059B*[:u\u001f\u001a47/\u001a;t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u00037\u000biJ\u0001\u000fMSN$xJ\u001a4tKR\u001c\b+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\t\u0005]\u00151\u000e\u0005\b\u0003C+\u0002\u0019AAR\u0003\u0019!x\u000e]5dgB1\u0011QUAX\u0003gk!!a*\u000b\t\u0005%\u00161V\u0001\b[V$\u0018M\u00197f\u0015\r\ti+M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAY\u0003O\u0013aAQ;gM\u0016\u0014\b\u0003BAJ\u0003kKA!a.\u0002\u001e\nAB*[:u\u001f\u001a47/\u001a;t)>\u0004\u0018n\u0019*fgB|gn]3\t\u000f\u0005UT\u00031\u0001\u0002x\u0005!2M]3bi\u0016$v\u000e]5d\u0003:$w)\u001a;M_\u001e$b!a0\u0002L\u0006}\u0007\u0003BAa\u0003\u000fl!!a1\u000b\u0007\u0005\u0015'$A\u0002m_\u001eLA!!3\u0002D\nQQK\\5gS\u0016$Gj\\4\t\u000f\u00055g\u00031\u0001\u0002P\u0006)Ao\u001c9jGB!\u0011\u0011[Am\u001d\u0011\t\u0019.!6\u0011\u0007\u0005u\u0012'C\u0002\u0002XF\na\u0001\u0015:fI\u00164\u0017\u0002BAn\u0003;\u0014aa\u0015;sS:<'bAAlc!9\u0011\u0011\u001d\fA\u0002\u0005]\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c")
public class LogOffsetTest
extends BaseRequestTest {
    private MockTime time;
    private volatile boolean bitmap$0;

    private MockTime time$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.time = new MockTime();
                this.bitmap$0 = true;
            }
        }
        return this.time;
    }

    private MockTime time() {
        if (!this.bitmap$0) {
            return this.time$lzycompute();
        }
        return this.time;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    public MockTime brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
        props.put("log.segment.bytes", "140");
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala(), topicPartition).errorCode());
    }

    @Test
    public void testGetOffsetsAfterDeleteRecords() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$1 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), (KafkaBroker)this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetByTimestampForMaxTimestampAfterTruncate() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(log, BoxesRunTime.unboxToInt((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option firstOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).offset);
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).timestamp);
        log.truncateTo(0L);
        Option secondOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)0L, (long)((FileRecords.TimestampAndOffset)secondOffset.get()).offset);
        Assertions.assertEquals((long)-1L, (long)((FileRecords.TimestampAndOffset)secondOffset.get()).timestamp);
    }

    @Test
    public void testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 6L, 5L}))).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(log, BoxesRunTime.unboxToLong((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)7L, (long)log.logEndOffset());
        Assertions.assertEquals((long)5L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)6L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    @Test
    public void testGetOffsetsBeforeLatestTime() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$2 -> x$2.swap())).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$3 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, 0, (KafkaBroker)this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(topicId, Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava()).build();
        Assertions.assertFalse((boolean)FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition))).batches().iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
            if (BoxesRunTime.equals((Object)CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala().head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                offsetChanged$1.elem = true;
                return;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @Test
    public void testFetchOffsetByTimestampForMaxTimestampWithEmptyLog() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L);
        Assertions.assertEquals((long)0L, (long)log.logEndOffset());
        Assertions.assertEquals((long)0L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)-1L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    @Test
    public void testGetOffsetsBeforeNow() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5());
        LogManager logManager = this.server().getLogManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$5 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), (KafkaBroker)this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5());
        LogManager logManager = this.server().getLogManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$6 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
        Seq offsets = log.legacyFetchOffsetsBefore(-2L, 10);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), (KafkaBroker)this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L, 10)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegmentSize() {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenAnswer(x$7 -> BoxesRunTime.boxToInteger((int)LogOffsetTest.$anonfun$testFetchOffsetsBeforeWithChangingSegmentSize$1(x$7)));
        scala.collection.immutable.Seq logSegments = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment}));
        Mockito.when((Object)log.logSegments()).thenReturn((Object)logSegments);
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegments() {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)log.logSegments()).thenAnswer(x$8 -> LogOffsetTest.answer$2(logSegment));
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaServer server() {
        return (KafkaServer)this.servers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private FetchResponse sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsTopic[]{new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsPartition[]{new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets)}))).asJava())}));
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$9))).get()).partitions()).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$10))).get();
    }

    private UnifiedLog createTopicAndGetLog(String topic, TopicPartition topicPartition) {
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        LogManager logManager = this.server().getLogManager();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$createTopicAndGetLog$1(logManager, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Log for partition [topic,0] should be created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        return (UnifiedLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(UnifiedLog log$2, int timestamp) {
        CompressionType compressionType;
        byte[] x$1 = Integer.toString(42).getBytes();
        long x$2 = timestamp;
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, by), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(UnifiedLog log$3, long timestamp) {
        CompressionType compressionType;
        byte[] x$1 = Integer.toString(42).getBytes();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, timestamp, by), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5());
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$3() {
        return "Leader should be elected";
    }

    private static final int answer$1(AtomicInteger value$1) {
        return value$1.getAndIncrement();
    }

    public static final /* synthetic */ int $anonfun$testFetchOffsetsBeforeWithChangingSegmentSize$1(InvocationOnMock x$7) {
        return new AtomicInteger(0).getAndIncrement();
    }

    private static final Iterable answer$2(LogSegment logSegment$1) {
        return new Iterable<LogSegment>(null, logSegment$1){
            private final LogSegment logSegment$1;

            public final Iterable<LogSegment> toIterable() {
                return Iterable.toIterable$((Iterable)this);
            }

            public final Iterable<LogSegment> coll() {
                return Iterable.coll$((Iterable)this);
            }

            public IterableFactory<Iterable> iterableFactory() {
                return Iterable.iterableFactory$((Iterable)this);
            }

            public Iterable<LogSegment> seq() {
                return Iterable.seq$((Iterable)this);
            }

            public String className() {
                return Iterable.className$((Iterable)this);
            }

            public final String collectionClassName() {
                return Iterable.collectionClassName$((Iterable)this);
            }

            public String stringPrefix() {
                return Iterable.stringPrefix$((Iterable)this);
            }

            public String toString() {
                return Iterable.toString$((Iterable)this);
            }

            public <B> LazyZip2<LogSegment, B, Iterable> lazyZip(Iterable<B> that) {
                return Iterable.lazyZip$((Iterable)this, that);
            }

            public IterableOps fromSpecific(IterableOnce coll) {
                return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
            }

            public Builder<LogSegment, Iterable<LogSegment>> newSpecificBuilder() {
                return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
            }

            public IterableOps empty() {
                return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
            }

            public final Iterable<LogSegment> toTraversable() {
                return IterableOps.toTraversable$((IterableOps)this);
            }

            public boolean isTraversableAgain() {
                return IterableOps.isTraversableAgain$((IterableOps)this);
            }

            public final Object repr() {
                return IterableOps.repr$((IterableOps)this);
            }

            public IterableFactory<Iterable> companion() {
                return IterableOps.companion$((IterableOps)this);
            }

            public Object head() {
                return IterableOps.head$((IterableOps)this);
            }

            public Option<LogSegment> headOption() {
                return IterableOps.headOption$((IterableOps)this);
            }

            public Object last() {
                return IterableOps.last$((IterableOps)this);
            }

            public Option<LogSegment> lastOption() {
                return IterableOps.lastOption$((IterableOps)this);
            }

            public View<LogSegment> view() {
                return IterableOps.view$((IterableOps)this);
            }

            public int sizeCompare(int otherSize) {
                return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
            }

            public final IterableOps sizeIs() {
                return IterableOps.sizeIs$((IterableOps)this);
            }

            public int sizeCompare(Iterable<?> that) {
                return IterableOps.sizeCompare$((IterableOps)this, that);
            }

            public View<LogSegment> view(int from, int until) {
                return IterableOps.view$((IterableOps)this, (int)from, (int)until);
            }

            public Object transpose(Function1 asIterable) {
                return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
            }

            public Object filter(Function1 pred) {
                return IterableOps.filter$((IterableOps)this, (Function1)pred);
            }

            public Object filterNot(Function1 pred) {
                return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
            }

            public WithFilter<LogSegment, Iterable> withFilter(Function1<LogSegment, Object> p) {
                return IterableOps.withFilter$((IterableOps)this, p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                return IterableOps.partition$((IterableOps)this, p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                return IterableOps.splitAt$((IterableOps)this, (int)n);
            }

            public Object take(int n) {
                return IterableOps.take$((IterableOps)this, (int)n);
            }

            public Object takeRight(int n) {
                return IterableOps.takeRight$((IterableOps)this, (int)n);
            }

            public Object takeWhile(Function1 p) {
                return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
            }

            public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                return IterableOps.span$((IterableOps)this, p);
            }

            public Object drop(int n) {
                return IterableOps.drop$((IterableOps)this, (int)n);
            }

            public Object dropRight(int n) {
                return IterableOps.dropRight$((IterableOps)this, (int)n);
            }

            public Object dropWhile(Function1 p) {
                return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
            }

            public Iterator<Iterable<LogSegment>> grouped(int size) {
                return IterableOps.grouped$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<LogSegment>> sliding(int size) {
                return IterableOps.sliding$((IterableOps)this, (int)size);
            }

            public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
            }

            public Object tail() {
                return IterableOps.tail$((IterableOps)this);
            }

            public Object init() {
                return IterableOps.init$((IterableOps)this);
            }

            public Object slice(int from, int until) {
                return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
            }

            public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                return IterableOps.groupBy$((IterableOps)this, f);
            }

            public <K, B> scala.collection.immutable.Map<K, Iterable<B>> groupMap(Function1<LogSegment, K> key, Function1<LogSegment, B> f) {
                return IterableOps.groupMap$((IterableOps)this, key, f);
            }

            public <K, B> scala.collection.immutable.Map<K, B> groupMapReduce(Function1<LogSegment, K> key, Function1<LogSegment, B> f, Function2<B, B, B> reduce) {
                return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
            }

            public Object scan(Object z, Function2 op) {
                return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanLeft(Object z, Function2 op) {
                return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object scanRight(Object z, Function2 op) {
                return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
            }

            public Object map(Function1 f) {
                return IterableOps.map$((IterableOps)this, (Function1)f);
            }

            public Object flatMap(Function1 f) {
                return IterableOps.flatMap$((IterableOps)this, (Function1)f);
            }

            public Object flatten(Function1 asIterable) {
                return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
            }

            public Object collect(PartialFunction pf) {
                return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<LogSegment, Either<A1, A2>> f) {
                return IterableOps.partitionMap$((IterableOps)this, f);
            }

            public Object concat(IterableOnce suffix) {
                return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
            }

            public final Object $plus$plus(IterableOnce suffix) {
                return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
            }

            public Object zip(IterableOnce that) {
                return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
            }

            public Object zipWithIndex() {
                return IterableOps.zipWithIndex$((IterableOps)this);
            }

            public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
                return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
            }

            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                return IterableOps.unzip$((IterableOps)this, asPair);
            }

            public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                return IterableOps.unzip3$((IterableOps)this, asTriple);
            }

            public Iterator<Iterable<LogSegment>> tails() {
                return IterableOps.tails$((IterableOps)this);
            }

            public Iterator<Iterable<LogSegment>> inits() {
                return IterableOps.inits$((IterableOps)this);
            }

            public Object tapEach(Function1 f) {
                return IterableOps.tapEach$((IterableOps)this, (Function1)f);
            }

            public Object $plus$plus$colon(IterableOnce that) {
                return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
            }

            public boolean hasDefiniteSize() {
                return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<LogSegment, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<LogSegment, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<LogSegment, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<LogSegment, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean isEmpty() {
                return IterableOnceOps.isEmpty$((IterableOnceOps)this);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<LogSegment> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<LogSegment> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<LogSegment> maxByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<LogSegment> minByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<LogSegment, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<LogSegment, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<LogSegment> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<LogSegment> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<LogSegment> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<LogSegment, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public scala.collection.immutable.Seq<LogSegment> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<LogSegment> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<LogSegment> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<LogSegment> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<LogSegment, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public int size() {
                return 2;
            }

            public Iterator<LogSegment> iterator() {
                return package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{this.logSegment$1})).iterator();
            }
            {
                this.logSegment$1 = logSegment$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$9) {
        String string = x$9.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$10) {
        return x$10.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndGetLog$1(LogManager logManager$1, TopicPartition topicPartition$4) {
        return logManager$1.getLog(topicPartition$4, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTopicAndGetLog$2() {
        return "Log for partition [topic,0] should be created";
    }
}

