/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.cluster.AbstractPartitionTest$;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.log.CleanerConfig;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.AlterPartitionManager;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\ter!B\u001b7\u0011\u0003Yd!B\u001f7\u0011\u0003q\u0004\"B#\u0002\t\u00031\u0005bB$\u0002\u0005\u0004%\t\u0001\u0013\u0005\u0007\u0019\u0006\u0001\u000b\u0011B%\u0007\tu2\u0004!\u0014\u0005\u0006\u000b\u0016!\tA\u0014\u0005\b\u000f\u0016\u0011\r\u0011\"\u0001I\u0011\u0019aU\u0001)A\u0005\u0013\"9\u0001+\u0002b\u0001\n\u0003A\u0005BB)\u0006A\u0003%\u0011\nC\u0004S\u000b\t\u0007I\u0011A*\t\r}+\u0001\u0015!\u0003U\u0011\u001d\u0001WA1A\u0005\u0002\u0005Da\u0001[\u0003!\u0002\u0013\u0011\u0007\"C5\u0006\u0001\u0004\u0005\r\u0011\"\u0001k\u0011%\u0019X\u00011AA\u0002\u0013\u0005A\u000fC\u0005{\u000b\u0001\u0007\t\u0011)Q\u0005W\"I10\u0002a\u0001\u0002\u0004%\tA\u001b\u0005\ny\u0016\u0001\r\u00111A\u0005\u0002uD\u0011b`\u0003A\u0002\u0003\u0005\u000b\u0015B6\t\u0015\u0005\u0005Q\u00011AA\u0002\u0013\u0005!\u000eC\u0006\u0002\u0004\u0015\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0001BCA\u0005\u000b\u0001\u0007\t\u0011)Q\u0005W\"Y\u00111B\u0003A\u0002\u0003\u0007I\u0011AA\u0007\u0011-\tY\"\u0002a\u0001\u0002\u0004%\t!!\b\t\u0017\u0005\u0005R\u00011A\u0001B\u0003&\u0011q\u0002\u0005\f\u0003G)\u0001\u0019!a\u0001\n\u0003\t)\u0003C\u0006\u0002D\u0015\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0003bCA%\u000b\u0001\u0007\t\u0011)Q\u0005\u0003OA1\"a\u0013\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002N!Y\u0011QK\u0003A\u0002\u0003\u0007I\u0011AA,\u0011-\tY&\u0002a\u0001\u0002\u0003\u0006K!a\u0014\t\u0017\u0005uS\u00011AA\u0002\u0013\u0005\u0011q\f\u0005\f\u0003O*\u0001\u0019!a\u0001\n\u0003\tI\u0007C\u0006\u0002n\u0015\u0001\r\u0011!Q!\n\u0005\u0005\u0004bCA8\u000b\u0001\u0007\t\u0019!C\u0001\u0003cB1\"a!\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0006\"Y\u0011\u0011R\u0003A\u0002\u0003\u0005\u000b\u0015BA:\u0011%\tY)\u0002b\u0001\n\u0003\ti\t\u0003\u0005\u0002\u0016\u0016\u0001\u000b\u0011BAH\u0011%\t9*\u0002b\u0001\n\u0003\tI\n\u0003\u0005\u0002$\u0016\u0001\u000b\u0011BAN\u0011%\t)+\u0002b\u0001\n\u0003\t9\u000b\u0003\u0005\u00026\u0016\u0001\u000b\u0011BAU\u0011-\t9,\u0002a\u0001\u0002\u0004%\t!!/\t\u0017\u0005\u0005W\u00011AA\u0002\u0013\u0005\u00111\u0019\u0005\f\u0003\u000f,\u0001\u0019!A!B\u0013\tY\fC\u0004\u0002J\u0016!\t!a3\t\u000f\u0005\rX\u0001\"\u0005\u0002f\"9\u00111_\u0003\u0005\u0002\u0005U\bb\u0002B\u000f\u000b\u0011\u0005\u00111\u001a\u0005\b\u0005O)A\u0011\u0003B\u0015\u0003U\t%m\u001d;sC\u000e$\b+\u0019:uSRLwN\u001c+fgRT!a\u000e\u001d\u0002\u000f\rdWo\u001d;fe*\t\u0011(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005q\nQ\"\u0001\u001c\u0003+\u0005\u00137\u000f\u001e:bGR\u0004\u0016M\u001d;ji&|g\u000eV3tiN\u0011\u0011a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0014\u0001\u00032s_.,'/\u00133\u0016\u0003%\u0003\"\u0001\u0011&\n\u0005-\u000b%aA%oi\u0006I!M]8lKJLE\rI\n\u0003\u000b}\"\u0012a\u0014\t\u0003y\u0015\tqB]3n_R,'+\u001a9mS\u000e\f\u0017\nZ\u0001\u0011e\u0016lw\u000e^3SKBd\u0017nY1JI\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001U!\t)V,D\u0001W\u0015\t9\u0006,\u0001\u0004d_6lwN\u001c\u0006\u0003seS!AW.\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0016aA8sO&\u0011aL\u0016\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001\u0002;j[\u0016,\u0012A\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003Kb\nQ!\u001e;jYNL!a\u001a3\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\na\u0001^7q\t&\u0014X#A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017AA5p\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\t\u0019KG.Z\u0001\u000bi6\u0004H)\u001b:`I\u0015\fHCA;y!\t\u0001e/\u0003\u0002x\u0003\n!QK\\5u\u0011\u001dI\b#!AA\u0002-\f1\u0001\u001f\u00132\u0003\u001d!X\u000e\u001d#je\u0002\nq\u0001\\8h\t&\u0014\u0018'A\u0006m_\u001e$\u0015N]\u0019`I\u0015\fHCA;\u007f\u0011\u001dI8#!AA\u0002-\f\u0001\u0002\\8h\t&\u0014\u0018\u0007I\u0001\bY><G)\u001b:3\u0003-awn\u001a#jeJzF%Z9\u0015\u0007U\f9\u0001C\u0004z-\u0005\u0005\t\u0019A6\u0002\u00111|w\rR5se\u0001\n!\u0002\\8h\u001b\u0006t\u0017mZ3s+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002O\u0001\u0004Y><\u0017\u0002BA\r\u0003'\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u00039awnZ'b]\u0006<WM]0%KF$2!^A\u0010\u0011!I\u0018$!AA\u0002\u0005=\u0011a\u00037pO6\u000bg.Y4fe\u0002\nQ#\u00197uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'/\u0006\u0002\u0002(A!\u0011\u0011FA\u001f\u001d\u0011\tY#!\u000f\u000f\t\u00055\u0012q\u0007\b\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111\u0007\u001e\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0014BA39\u0013\r\tY\u0004Z\u0001\n)\u0016\u001cH/\u0016;jYNLA!a\u0010\u0002B\tIRj\\2l\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0015\r\tY\u0004Z\u0001\u001aC2$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002v\u0003\u000fB\u0001\"\u001f\u000f\u0002\u0002\u0003\u0007\u0011qE\u0001\u0017C2$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3sA\u00051\u0012\r\u001c;feB\u000b'\u000f^5uS>tG*[:uK:,'/\u0006\u0002\u0002PA!\u0011\u0011FA)\u0013\u0011\t\u0019&!\u0011\u000355{7m[!mi\u0016\u0014\b+\u0019:uSRLwN\u001c'jgR,g.\u001a:\u00025\u0005dG/\u001a:QCJ$\u0018\u000e^5p]2K7\u000f^3oKJ|F%Z9\u0015\u0007U\fI\u0006\u0003\u0005z?\u0005\u0005\t\u0019AA(\u0003]\tG\u000e^3s!\u0006\u0014H/\u001b;j_:d\u0015n\u001d;f]\u0016\u0014\b%A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u0011\u0011\r\t\u0005\u0003#\t\u0019'\u0003\u0003\u0002f\u0005M!!\u0003'pO\u000e{gNZ5h\u00035awnZ\"p]\u001aLwm\u0018\u0013fcR\u0019Q/a\u001b\t\u0011e\u0014\u0013\u0011!a\u0001\u0003C\n!\u0002\\8h\u0007>tg-[4!\u0003A\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u00180\u0006\u0002\u0002tA!\u0011QOA@\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014\u0001C7fi\u0006$\u0017\r^1\u000b\u0007\u0005u\u0004(\u0001\u0004tKJ4XM]\u0005\u0005\u0003\u0003\u000b9H\u0001\u000bN_\u000e\\7i\u001c8gS\u001e\u0014V\r]8tSR|'/_\u0001\u0015G>tg-[4SKB|7/\u001b;pef|F%Z9\u0015\u0007U\f9\t\u0003\u0005zK\u0005\u0005\t\u0019AA:\u0003E\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0012I\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u001cXCAAH!\ra\u0014\u0011S\u0005\u0004\u0003'3$!\u0005#fY\u0006LX\rZ(qKJ\fG/[8og\u0006\u0011B-\u001a7bs\u0016$w\n]3sCRLwN\\:!\u00035iW\r^1eCR\f7)Y2iKV\u0011\u00111\u0014\t\u0005\u0003;\u000by*\u0004\u0002\u0002|%!\u0011\u0011UA>\u00055iU\r^1eCR\f7)Y2iK\u0006qQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013!E8gMN,Go\u00115fG.\u0004x.\u001b8ugV\u0011\u0011\u0011\u0016\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*!\u0011qVA>\u0003-\u0019\u0007.Z2la>Lg\u000e^:\n\t\u0005M\u0016Q\u0016\u0002\u0012\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R\u001c\u0018AE8gMN,Go\u00115fG.\u0004x.\u001b8ug\u0002\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0005\u0005m\u0006c\u0001\u001f\u0002>&\u0019\u0011q\u0018\u001c\u0003\u0013A\u000b'\u000f^5uS>t\u0017!\u00049beRLG/[8o?\u0012*\u0017\u000fF\u0002v\u0003\u000bD\u0001\"\u001f\u0018\u0002\u0002\u0003\u0007\u00111X\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013!B:fiV\u0004H#A;)\u0007A\ny\r\u0005\u0003\u0002R\u0006}WBAAj\u0015\u0011\t).a6\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002Z\u0006m\u0017a\u00026va&$XM\u001d\u0006\u0004\u0003;\\\u0016!\u00026v]&$\u0018\u0002BAq\u0003'\u0014!BQ3g_J,W)Y2i\u0003iIg\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m-\u0016\u00148/[8o+\t\t9\u000f\u0005\u0003\u0002j\u0006=XBAAv\u0015\r9\u0016Q\u001e\u0006\u0004\u0003{B\u0016\u0002BAy\u0003W\u0014q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u0014GJ,\u0017\r^3M_\u001e\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0003o\u0014\u0019\u0001\u0005\u0003\u0002z\u0006}XBAA~\u0015\r\tip\\\u0001\u0005kRLG.\u0003\u0003\u0003\u0002\u0005m(A\u0003)s_B,'\u000f^5fg\"9!Q\u0001\u001aA\u0002\t\u001d\u0011!C8wKJ\u0014\u0018\u000eZ3t!!\u0011IA!\u0005\u0003\u0018\t]a\u0002\u0002B\u0006\u0005\u001b\u00012!a\fB\u0013\r\u0011y!Q\u0001\u0007!J,G-\u001a4\n\t\tM!Q\u0003\u0002\u0004\u001b\u0006\u0004(b\u0001B\b\u0003B!!\u0011\u0002B\r\u0013\u0011\u0011YB!\u0006\u0003\rM#(/\u001b8h\u0003!!X-\u0019:E_^t\u0007fA\u001a\u0003\"A!\u0011\u0011\u001bB\u0012\u0013\u0011\u0011)#a5\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017aF:fiV\u0004\b+\u0019:uSRLwN\\,ji\"lunY6t)\u0019\tYLa\u000b\u00030!1!Q\u0006\u001bA\u0002%\u000b1\u0002\\3bI\u0016\u0014X\t]8dQ\"9!\u0011\u0007\u001bA\u0002\tM\u0012\u0001C5t\u0019\u0016\fG-\u001a:\u0011\u0007\u0001\u0013)$C\u0002\u00038\u0005\u0013qAQ8pY\u0016\fg\u000e")
public class AbstractPartitionTest {
    private final int brokerId = AbstractPartitionTest$.MODULE$.brokerId();
    private final int remoteReplicaId = this.brokerId() + 1;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private LogManager logManager;
    private TestUtils.MockAlterPartitionManager alterPartitionManager;
    private TestUtils.MockAlterPartitionListener alterPartitionListener;
    private LogConfig logConfig;
    private MockConfigRepository configRepository;
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;

    public int brokerId() {
        return this.brokerId;
    }

    public int remoteReplicaId() {
        return this.remoteReplicaId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterPartitionManager() {
        return this.alterPartitionManager;
    }

    public void alterPartitionManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterPartitionManager = x$1;
    }

    public TestUtils.MockAlterPartitionListener alterPartitionListener() {
        return this.alterPartitionListener;
    }

    public void alterPartitionListener_$eq(TestUtils.MockAlterPartitionListener x$1) {
        this.alterPartitionListener = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public void configRepository_$eq(MockConfigRepository x$1) {
        this.configRepository = x$1;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @BeforeEach
    public void setup() {
        String string;
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.configRepository_$eq(MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProps));
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), this.configRepository(), new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), this.time(), this.interBrokerProtocolVersion(), 4));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.alterPartitionManager_$eq(new TestUtils.MockAlterPartitionManager());
        this.alterPartitionListener_$eq(new TestUtils.MockAlterPartitionListener());
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.interBrokerProtocolVersion(), this.brokerId(), (Time)this.time(), (AlterPartitionListener)this.alterPartitionListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterPartitionManager)this.alterPartitionManager()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    public MetadataVersion interBrokerProtocolVersion() {
        return MetadataVersion.latest();
    }

    /*
     * WARNING - void declaration
     */
    public Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    @AfterEach
    public void tearDown() {
        if (this.tmpDir().exists()) {
            this.logManager().shutdown();
            Utils.delete((File)this.tmpDir());
            TestUtils$.MODULE$.clearYammerMetrics();
        }
    }

    public Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader) {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        int controllerEpoch = 0;
        List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.remoteReplicaId())}))).asJava();
        if (isLeader) {
            Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        } else {
            Assertions.assertTrue((boolean)this.partition().makeFollower(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.remoteReplicaId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become follower transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }
}

