/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import kafka.tools.ConsumerPerformance;
import kafka.tools.ConsumerPerformance$;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00154Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003B\u0002\u0016\u0001A\u0003%!\u0005C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\t\rM\u0002\u0001\u0015!\u0003.\u0011\u0015!\u0004\u0001\"\u00016\u0011\u00151\u0005\u0001\"\u00016\u0011\u0015A\u0005\u0001\"\u00016\u0011\u0015Q\u0005\u0001\"\u00016\u0011\u0015a\u0005\u0001\"\u00016\u0011\u0015q\u0005\u0001\"\u00016\u0011\u0015\u0001\u0006\u0001\"\u00016\u0011\u0015\u0011\u0006\u0001\"\u00016\u0011\u0015!\u0006\u0001\"\u0003V\u0005]\u0019uN\\:v[\u0016\u0014\b+\u001a:g_Jl\u0017M\\2f)\u0016\u001cHO\u0003\u0002\u0012%\u0005)Ao\\8mg*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002!\u0005Qq.\u001e;D_:$XM\u001c;\u0016\u0003\t\u0002\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u0005%|'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u0012QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.A\u0006pkR\u001cuN\u001c;f]R\u0004\u0013A\u00033bi\u00164uN]7biV\tQ\u0006\u0005\u0002/c5\tqF\u0003\u00021M\u0005!A/\u001a=u\u0013\t\u0011tF\u0001\tTS6\u0004H.\u001a#bi\u00164uN]7bi\u0006YA-\u0019;f\r>\u0014X.\u0019;!\u0003m!Xm\u001d;EKR\f\u0017\u000e\\3e\u0011\u0016\fG-\u001a:NCR\u001c\u0007NQ8esR\ta\u0007\u0005\u0002\u0018o%\u0011\u0001\b\u0007\u0002\u0005+:LG\u000f\u000b\u0002\u0007uA\u00111\bR\u0007\u0002y)\u0011QHP\u0001\u0004CBL'BA A\u0003\u001dQW\u000f]5uKJT!!\u0011\"\u0002\u000b),h.\u001b;\u000b\u0003\r\u000b1a\u001c:h\u0013\t)EH\u0001\u0003UKN$\u0018A\b;fgRtuN\u001c#fi\u0006LG.\u001a3IK\u0006$WM]'bi\u000eD'i\u001c3zQ\t9!(\u0001\u000buKN$8i\u001c8gS\u001e\u0014%o\\6fe2K7\u000f\u001e\u0015\u0003\u0011i\n\u0011\u0004^3ti\u000e{gNZ5h\u0005>|Go\u0015;sCB\u001cVM\u001d<fe\"\u0012\u0011BO\u0001\u0017i\u0016\u001cHO\u0011:pW\u0016\u0014H*[:u\u001fZ,'O]5eK\"\u0012!BO\u0001!i\u0016\u001cHoQ8oM&<w+\u001b;i+:\u0014XmY8h]&TX\rZ(qi&|g\u000e\u000b\u0002\fu\u0005!B/Z:u\u00072LWM\u001c;JI>3XM\u001d:jI\u0016D#\u0001\u0004\u001e\u0002'Q,7\u000f\u001e#fM\u0006,H\u000e^\"mS\u0016tG/\u00133)\u00055Q\u0014A\u0006;fgRDU-\u00193fe6\u000bGo\u00195D_:$XM\u001c;\u0015\tY26\f\u0019\u0005\u0006/:\u0001\r\u0001W\u0001\tI\u0016$\u0018-\u001b7fIB\u0011q#W\u0005\u00035b\u0011qAQ8pY\u0016\fg\u000eC\u0003]\u001d\u0001\u0007Q,A\ffqB,7\r^3e\u001fV$\b/\u001e;MS:,7i\\;oiB\u0011qCX\u0005\u0003?b\u00111!\u00138u\u0011\u0015\tg\u00021\u0001c\u0003\r1WO\u001c\t\u0004/\r4\u0014B\u00013\u0019\u0005%1UO\\2uS>t\u0007\u0007")
public class ConsumerPerformanceTest {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    private ByteArrayOutputStream outContent() {
        return this.outContent;
    }

    private SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDetailedHeaderMatchBody() {
        void testHeaderMatchContent_fun;
        JFunction0.mcV.sp & Serializable intersect = (JFunction0.mcV.sp & Serializable)() -> ConsumerPerformance$.MODULE$.printConsumerProgress(1, 0x100000L, 0L, 1L, 0L, 0L, 1L, this.dateFormat(), 1L);
        int testHeaderMatchContent_expectedOutputLineCount = 2;
        boolean testHeaderMatchContent_detailed = true;
        Console$.MODULE$.withOut((OutputStream)this.outContent(), (Function0)((JFunction0.mcV.sp & Serializable)() -> ConsumerPerformanceTest.$anonfun$testHeaderMatchContent$1(this, testHeaderMatchContent_detailed, (Function0)testHeaderMatchContent_fun, testHeaderMatchContent_expectedOutputLineCount)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNonDetailedHeaderMatchBody() {
        void testHeaderMatchContent_fun;
        JFunction0.mcV.sp & Serializable intersect = (JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.println((Object)new StringBuilder(0).append(new StringBuilder(2).append(this.dateFormat().format(BoxesRunTime.boxToLong((long)System.currentTimeMillis()))).append(", ").toString()).append(new StringBuilder(34).append(this.dateFormat().format(BoxesRunTime.boxToLong((long)System.currentTimeMillis()))).append(", 1.0, 1.0, 1, 1.0, 1, 1, 1.1, 1.1").toString()).toString());
        int testHeaderMatchContent_expectedOutputLineCount = 2;
        boolean testHeaderMatchContent_detailed = false;
        Console$.MODULE$.withOut((OutputStream)this.outContent(), (Function0)((JFunction0.mcV.sp & Serializable)() -> ConsumerPerformanceTest.$anonfun$testHeaderMatchContent$1(this, testHeaderMatchContent_detailed, (Function0)testHeaderMatchContent_fun, testHeaderMatchContent_expectedOutputLineCount)));
    }

    @Test
    public void testConfigBrokerList() {
        String[] args = new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10"};
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertEquals((Object)"test", (Object)config.topic());
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test
    public void testConfigBootStrapServer() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10", "--print-metrics"};
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertEquals((Object)"test", (Object)config.topic());
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test
    public void testBrokerListOverride() {
        String[] args = new String[]{"--broker-list", "localhost:9094", "--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10"};
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertEquals((Object)"test", (Object)config.topic());
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test
    public void testConfigWithUnrecognizedOption() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$1, message) -> ConsumerPerformanceTest.$anonfun$testConfigWithUnrecognizedOption$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var3_1 = null;
        String[] args = new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10", "--new-consumer"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsumerPerformance.ConsumerPerfConfig(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testClientIdOverride() {
        File consumerConfigFile = File.createTempFile("test_consumer_config", ".conf");
        consumerConfigFile.deleteOnExit();
        new PrintWriter(null, consumerConfigFile){
            {
                this.write("client.id=consumer-1");
                this.close();
            }
        };
        String[] args = new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10", "--consumer.config", consumerConfigFile.getPath()};
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"consumer-1", (Object)config.props().getProperty("client.id"));
    }

    @Test
    public void testDefaultClientId() {
        String[] args = new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10"};
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"perf-consumer-client", (Object)config.props().getProperty("client.id"));
    }

    private void testHeaderMatchContent(boolean detailed, int expectedOutputLineCount, Function0<BoxedUnit> fun) {
        Console$.MODULE$.withOut((OutputStream)this.outContent(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ConsumerPerformance$.MODULE$.printHeader(detailed);
            fun.apply$mcV$sp();
            String[] contents = this.outContent().toString().split("\n");
            Assertions.assertEquals((int)expectedOutputLineCount, (int)contents.length);
            String header = contents[0];
            String body = contents[1];
            Assertions.assertEquals((int)header.split(",").length, (int)body.split(",").length);
        });
    }

    public static final /* synthetic */ Nothing$ $anonfun$testConfigWithUnrecognizedOption$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }
}

