/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.ZkProducerIdManager$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.server.common.ProducerIdsBlock;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u001d<Q\u0001E\t\t\u0002a1QAG\t\t\u0002mAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005\u0002\u00152AAG\t\u0001\u0011\"AA\u0007\u0002B\u0001B\u0003%Q\u0007\u0003\u0005:\t\t\u0005\t\u0015!\u0003;\u0011\u0015\u0011C\u0001\"\u0001M\u0011\u001d\u0001F\u00011A\u0005\nECqA\u0015\u0003A\u0002\u0013%1\u000b\u0003\u0004Z\t\u0001\u0006KA\n\u0005\n5\u0012\u0001\r\u00111A\u0005\nmC\u0011b\u0018\u0003A\u0002\u0003\u0007I\u0011\u00021\t\u0013\t$\u0001\u0019!A!B\u0013a\u0006\"B2\u0005\t\u0013!\u0007\"B3\u0005\t\u00031\u0017a\u0005.l!J|G-^2fe&#W*\u00198bO\u0016\u0014(B\u0001\n\u0014\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005Q)\u0012aC2p_J$\u0017N\\1u_JT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001!\tI\u0012!D\u0001\u0012\u0005MQ6\u000e\u0015:pIV\u001cWM]%e\u001b\u0006t\u0017mZ3s'\t\tA\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\tQcZ3u\u001d\u0016<\bK]8ek\u000e,'/\u00133CY>\u001c7\u000e\u0006\u0003'ga\u0002\u0005CA\u00142\u001b\u0005A#BA\u0015+\u0003\u0019\u0019w.\\7p]*\u00111\u0006L\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005Yi#B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001eL!A\r\u0015\u0003!A\u0013x\u000eZ;dKJLEm\u001d\"m_\u000e\\\u0007\"\u0002\u001b\u0004\u0001\u0004)\u0014\u0001\u00032s_.,'/\u00133\u0011\u0005u1\u0014BA\u001c\u001f\u0005\rIe\u000e\u001e\u0005\u0006s\r\u0001\rAO\u0001\tu.\u001cE.[3oiB\u00111HP\u0007\u0002y)\u0011Q(F\u0001\u0003u.L!a\u0010\u001f\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011\u0015\t5\u00011\u0001C\u0003\u0019awnZ4feB\u00111IR\u0007\u0002\t*\u0011Q)F\u0001\u0006kRLGn]\u0005\u0003\u000f\u0012\u0013q\u0001T8hO&twm\u0005\u0003\u00059%\u0013\u0005CA\rK\u0013\tY\u0015CA\tQe>$WoY3s\u0013\u0012l\u0015M\\1hKJ$2!\u0014(P!\tIB\u0001C\u00035\u000f\u0001\u0007Q\u0007C\u0003:\u000f\u0001\u0007!(\u0001\fdkJ\u0014XM\u001c;Qe>$WoY3s\u0013\u0012\u0014En\\2l+\u00051\u0013AG2veJ,g\u000e\u001e)s_\u0012,8-\u001a:JI\ncwnY6`I\u0015\fHC\u0001+X!\tiR+\u0003\u0002W=\t!QK\\5u\u0011\u001dA\u0016\"!AA\u0002\u0019\n1\u0001\u001f\u00132\u0003]\u0019WO\u001d:f]R\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\"m_\u000e\\\u0007%\u0001\boKb$\bK]8ek\u000e,'/\u00133\u0016\u0003q\u0003\"!H/\n\u0005ys\"\u0001\u0002'p]\u001e\f!C\\3yiB\u0013x\u000eZ;dKJLEm\u0018\u0013fcR\u0011A+\u0019\u0005\b12\t\t\u00111\u0001]\u0003=qW\r\u001f;Qe>$WoY3s\u0013\u0012\u0004\u0013AG1mY>\u001c\u0017\r^3OK^\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\"m_\u000e\\G#\u0001+\u0002%\u001d,g.\u001a:bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\u00029\u0002")
public class ZkProducerIdManager
implements ProducerIdManager,
Logging {
    private final int brokerId;
    private final KafkaZkClient zkClient;
    private ProducerIdsBlock currentProducerIdBlock;
    private long nextProducerId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ProducerIdsBlock getNewProducerIdBlock(int brokerId, KafkaZkClient zkClient, Logging logger) {
        return ZkProducerIdManager$.MODULE$.getNewProducerIdBlock(brokerId, zkClient, logger);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        ProducerIdManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ProducerIdsBlock currentProducerIdBlock() {
        return this.currentProducerIdBlock;
    }

    private void currentProducerIdBlock_$eq(ProducerIdsBlock x$1) {
        this.currentProducerIdBlock = x$1;
    }

    private long nextProducerId() {
        return this.nextProducerId;
    }

    private void nextProducerId_$eq(long x$1) {
        this.nextProducerId = x$1;
    }

    private synchronized void allocateNewProducerIdBlock() {
        this.currentProducerIdBlock_$eq(ZkProducerIdManager$.MODULE$.getNewProducerIdBlock(this.brokerId, this.zkClient, this));
    }

    @Override
    public synchronized long generateProducerId() {
        if (this.nextProducerId() > this.currentProducerIdBlock().lastProducerId()) {
            this.allocateNewProducerIdBlock();
            this.nextProducerId_$eq(this.currentProducerIdBlock().firstProducerId());
        }
        this.nextProducerId_$eq(this.nextProducerId() + 1L);
        return this.nextProducerId() - 1L;
    }

    public ZkProducerIdManager(int brokerId, KafkaZkClient zkClient) {
        this.brokerId = brokerId;
        this.zkClient = zkClient;
        this.logIdent_$eq(new StringBuilder(26).append("[ZK ProducerId Manager ").append(brokerId).append("]: ").toString());
        this.currentProducerIdBlock = ProducerIdsBlock.EMPTY;
        synchronized (this) {
            this.allocateNewProducerIdBlock();
            this.nextProducerId_$eq(this.currentProducerIdBlock().firstProducerId());
            return;
        }
    }
}

