/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.CorruptIndexException;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog$;
import kafka.log.LogConfig;
import kafka.log.LogLoader$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.ProducerStateManager;
import kafka.log.SplitSegmentResult;
import kafka.log.UnifiedLog$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.snapshot.Snapshots;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00055x!B\u000f\u001f\u0011\u0003\u0019c!B\u0013\u001f\u0011\u00031\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%\tA\u000e\u0005\u0007\u007f\u0005\u0001\u000b\u0011B\u001c\t\u000f\u0001\u000b\u0011\u0013!C\u0001\u0003\u001a!QE\b\u0001b\u0011!\u0011gA!A!\u0002\u0013\u0019\u0007\u0002C5\u0007\u0005\u0003\u0005\u000b\u0011\u00026\t\u0011U4!\u0011!Q\u0001\nYD\u0001\"\u001f\u0004\u0003\u0002\u0003\u0006IA\u001f\u0005\t{\u001a\u0011\t\u0011)A\u0005}\"Q\u0011q\u0001\u0004\u0003\u0002\u0003\u0006I!!\u0003\t\u0015\u0005UaA!A!\u0002\u0013\t9\u0002\u0003\u0006\u0002\u001e\u0019\u0011\t\u0011)A\u0005\u0003?A!\"!\n\u0007\u0005\u0003\u0005\u000b\u0011BA\u0014\u0011)\tiC\u0002B\u0001B\u0003%\u0011q\u0005\u0005\u000b\u0003_1!\u0011!Q\u0001\n\u0005E\u0002BCA\"\r\t\u0005\t\u0015!\u0003\u0002F!I\u00111\n\u0004\u0003\u0002\u0003\u0006Ia\u0011\u0005\u0007g\u0019!\t!!\u0014\t\u000f\u0005-d\u0001\"\u0001\u0002n!9\u0011Q\u000f\u0004\u0005\n\u0005]\u0004bBAC\r\u0011%\u0011q\u0011\u0005\b\u0003W3A\u0011BAW\u0011\u001d\t)L\u0002C\u0005\u0003oC\u0001\"a1\u0007\t\u0003q\u0012Q\u0019\u0005\b\u0003\u001b4A\u0011BAh\u0011\u001d\t9O\u0002C\u0005\u0003S\f\u0011\u0002T8h\u0019>\fG-\u001a:\u000b\u0005}\u0001\u0013a\u00017pO*\t\u0011%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u0011\nQ\"\u0001\u0010\u0003\u00131{w\rT8bI\u0016\u00148cA\u0001([A\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u0011\u0002\u000bU$\u0018\u000e\\:\n\u0005Iz#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\n\u0011c\u00117fC:\u001c\u0006.\u001e;e_^tg)\u001b7f+\u00059\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0011a\u0017M\\4\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002%\rcW-\u00198TQV$Hm\\<o\r&dW\rI\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00194+\u0005\u0011%FA\"Y!\u0011!\u0015jS+\u000e\u0003\u0015S!AR$\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002Iw\u0005!Q\u000f^5m\u0013\tQUIA\u0007D_:\u001cWO\u001d:f]Rl\u0015\r\u001d\t\u0003\u0019Ns!!T)\u0011\u00059KS\"A(\u000b\u0005A\u0013\u0013A\u0002\u001fs_>$h(\u0003\u0002SS\u00051\u0001K]3eK\u001aL!A\u0010+\u000b\u0005IK\u0003C\u0001\u0015W\u0013\t9\u0016FA\u0002J]R\\\u0013!\u0017\t\u00035~k\u0011a\u0017\u0006\u00039v\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005yK\u0013AC1o]>$\u0018\r^5p]&\u0011\u0001m\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,7c\u0001\u0004([\u0005\u0019A-\u001b:\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019\\\u0014AA5p\u0013\tAWM\u0001\u0003GS2,\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003WNl\u0011\u0001\u001c\u0006\u0003[:\faaY8n[>t'BA\u0011p\u0015\t\u0001\u0018/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0006\u0019qN]4\n\u0005Qd'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0007G>tg-[4\u0011\u0005\u0011:\u0018B\u0001=\u001f\u0005%aunZ\"p]\u001aLw-A\u0005tG\",G-\u001e7feB\u0011af_\u0005\u0003y>\u0012\u0011bU2iK\u0012,H.\u001a:\u0002\tQLW.\u001a\t\u0004\u007f\u0006\rQBAA\u0001\u0015\t\u0001D.\u0003\u0003\u0002\u0006\u0005\u0005!\u0001\u0002+j[\u0016\fA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=\u0001%\u0001\u0004tKJ4XM]\u0005\u0005\u0003'\tiA\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0011Q\u0006$7\t\\3b]NCW\u000f\u001e3po:\u00042\u0001KA\r\u0013\r\tY\"\u000b\u0002\b\u0005>|G.Z1o\u0003!\u0019XmZ7f]R\u001c\bc\u0001\u0013\u0002\"%\u0019\u00111\u0005\u0010\u0003\u00171{wmU3h[\u0016tGo]\u0001\u0019Y><7\u000b^1si>3gm]3u\u0007\",7m\u001b9pS:$\bc\u0001\u0015\u0002*%\u0019\u00111F\u0015\u0003\t1{gnZ\u0001\u0018e\u0016\u001cwN^3ssB{\u0017N\u001c;DQ\u0016\u001c7\u000e]8j]R\f\u0001\u0003\\3bI\u0016\u0014X\t]8dQ\u000e\u000b7\r[3\u0011\u000b!\n\u0019$a\u000e\n\u0007\u0005U\u0012F\u0001\u0004PaRLwN\u001c\t\u0005\u0003s\ty$\u0004\u0002\u0002<)!\u0011QHA\u0007\u0003\u0015)\u0007o\\2i\u0013\u0011\t\t%a\u000f\u0003)1+\u0017\rZ3s\u000bB|7\r\u001b$jY\u0016\u001c\u0015m\u00195f\u0003Q\u0001(o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4feB\u0019A%a\u0012\n\u0007\u0005%cD\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\u0001\u0015]Vl'+Z7bS:LgnZ*fO6,g\u000e^:\u00159\u0005=\u0013\u0011KA*\u0003+\n9&!\u0017\u0002\\\u0005u\u0013qLA1\u0003G\n)'a\u001a\u0002jA\u0011AE\u0002\u0005\u0006ER\u0001\ra\u0019\u0005\u0006SR\u0001\rA\u001b\u0005\u0006kR\u0001\rA\u001e\u0005\u0006sR\u0001\rA\u001f\u0005\u0006{R\u0001\rA \u0005\b\u0003\u000f!\u0002\u0019AA\u0005\u0011\u001d\t)\u0002\u0006a\u0001\u0003/Aq!!\b\u0015\u0001\u0004\ty\u0002C\u0004\u0002&Q\u0001\r!a\n\t\u000f\u00055B\u00031\u0001\u0002(!9\u0011q\u0006\u000bA\u0002\u0005E\u0002bBA\")\u0001\u0007\u0011Q\t\u0005\t\u0003\u0017\"\u0002\u0013!a\u0001\u0007\u0006!An\\1e)\t\ty\u0007E\u0002%\u0003cJ1!a\u001d\u001f\u0005Aau.\u00193fI2{wm\u00144gg\u0016$8/\u0001\u0012sK6|g/\u001a+f[B4\u0015\u000e\\3t\u0003:$7i\u001c7mK\u000e$8k^1q\r&dWm\u001d\u000b\u0003\u0003s\u0002R!a\u001f\u0002\u0002\u000el!!! \u000b\u0007\u0005}\u0014&\u0001\u0006d_2dWm\u0019;j_:LA!a!\u0002~\t\u00191+\u001a;\u0002+I,GO]=P]>3gm]3u\u001fZ,'O\u001a7poV!\u0011\u0011RAH)\u0011\tY)!)\u0011\t\u00055\u0015q\u0012\u0007\u0001\t\u001d\t\tj\u0006b\u0001\u0003'\u0013\u0011\u0001V\t\u0005\u0003+\u000bY\nE\u0002)\u0003/K1!!'*\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001KAO\u0013\r\ty*\u000b\u0002\u0004\u0003:L\bbBAR/\u0001\u0007\u0011QU\u0001\u0003M:\u0004R\u0001KAT\u0003\u0017K1!!+*\u0005%1UO\\2uS>t\u0007'\u0001\tm_\u0006$7+Z4nK:$h)\u001b7fgR\u0011\u0011q\u0016\t\u0004Q\u0005E\u0016bAAZS\t!QK\\5u\u00039\u0011XmY8wKJ\u001cVmZ7f]R$2!VA]\u0011\u001d\tY,\u0007a\u0001\u0003{\u000bqa]3h[\u0016tG\u000fE\u0002%\u0003\u007fK1!!1\u001f\u0005)aunZ*fO6,g\u000e^\u0001\u000be\u0016\u001cwN^3s\u0019><GCAAd!\u001dA\u0013\u0011ZA\u0014\u0003OI1!a3*\u0005\u0019!V\u000f\u001d7fe\u0005a\"/Z7pm\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tGo]!ts:\u001cG\u0003BAX\u0003#Dq!a5\u001c\u0001\u0004\t).\u0001\ttK\u001elWM\u001c;t)>$U\r\\3uKB1\u0011q[Aq\u0003{sA!!7\u0002^:\u0019a*a7\n\u0003)J1!a8*\u0003\u001d\u0001\u0018mY6bO\u0016LA!a9\u0002f\nA\u0011\n^3sC\ndWMC\u0002\u0002`&\nA\u0004Z3mKR,\u0007K]8ek\u000e,'o\u00158baNDw\u000e^:Bgft7\r\u0006\u0003\u00020\u0006-\bbBA\u000f9\u0001\u0007\u0011Q\u001b")
public class LogLoader
implements Logging {
    private final File dir;
    private final TopicPartition topicPartition;
    private final LogConfig config;
    private final Scheduler scheduler;
    private final Time time;
    private final LogDirFailureChannel logDirFailureChannel;
    private final boolean hadCleanShutdown;
    private final LogSegments segments;
    private final long logStartOffsetCheckpoint;
    private final long recoveryPointCheckpoint;
    private final Option<LeaderEpochFileCache> leaderEpochCache;
    private final ProducerStateManager producerStateManager;
    private final ConcurrentMap<String, Object> numRemainingSegments;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ConcurrentMap<String, Object> $lessinit$greater$default$13() {
        return new ConcurrentHashMap<String, Object>();
    }

    public static String CleanShutdownFile() {
        return LogLoader$.MODULE$.CleanShutdownFile();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public LoadedLogOffsets load() {
        long l;
        long l2;
        Object var19_7;
        SplitSegmentResult splitSegmentResult;
        LogSegments logSegments;
        File file2;
        TopicPartition topicPartition;
        LogConfig logConfig;
        Scheduler scheduler;
        LogDirFailureChannel logDirFailureChannel;
        String string;
        Set<File> swapFiles = this.removeTempFilesAndCollectSwapFiles();
        LongRef minSwapFileOffset = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxSwapFileOffset = LongRef.create((long)Long.MIN_VALUE);
        ((IterableOnceOps)swapFiles.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$load$1(f)))).foreach((Function1 & Serializable)f -> {
            LogLoader.$anonfun$load$2(this, minSwapFileOffset, maxSwapFileOffset, f);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            Object object;
            block6: {
                try {
                    if (!file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                        long l = LocalLog$.MODULE$.offsetFromFile((File)file);
                        if (l >= minSwapFileOffset$1.elem && l < maxSwapFileOffset$1.elem) {
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Deleting segment files ").append(file.getName()).append(" that is compacted but has not been deleted yet.").toString());
                            object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        break block6;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return BoxedUnit.UNIT;
                }
                catch (NumberFormatException numberFormatException) {
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Recovering file ").append(file.getName()).append(" by renaming from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files.").toString());
                return BoxesRunTime.boxToBoolean((boolean)file.renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.SwapFileSuffix(), ""))));
            }
            return BoxedUnit.UNIT;
        });
        while (true) {
            try {
                LogLoader.$anonfun$load$10(this);
            }
            catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                void retryOnOffsetOverflow_splitOverflowedSegment_logPrefix;
                void retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel;
                void retryOnOffsetOverflow_splitOverflowedSegment_scheduler;
                void retryOnOffsetOverflow_splitOverflowedSegment_config;
                void retryOnOffsetOverflow_splitOverflowedSegment_topicPartition;
                void retryOnOffsetOverflow_splitOverflowedSegment_dir;
                void retryOnOffsetOverflow_splitOverflowedSegment_existingSegments;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                string = this.logIdent();
                logDirFailureChannel = this.logDirFailureChannel;
                scheduler = this.scheduler;
                logConfig = this.config;
                topicPartition = this.topicPartition;
                file2 = this.dir;
                logSegments = this.segments;
                LogSegment retryOnOffsetOverflow_splitOverflowedSegment_segment = retryOnOffsetOverflow_e.segment();
                SplitSegmentResult splitSegmentResult2 = splitSegmentResult = LocalLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_splitOverflowedSegment_segment, (LogSegments)retryOnOffsetOverflow_splitOverflowedSegment_existingSegments, (File)retryOnOffsetOverflow_splitOverflowedSegment_dir, (TopicPartition)retryOnOffsetOverflow_splitOverflowedSegment_topicPartition, (LogConfig)retryOnOffsetOverflow_splitOverflowedSegment_config, (Scheduler)retryOnOffsetOverflow_splitOverflowedSegment_scheduler, (LogDirFailureChannel)retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel, (String)retryOnOffsetOverflow_splitOverflowedSegment_logPrefix);
                var19_7 = null;
                logSegments = null;
                file2 = null;
                topicPartition = null;
                logConfig = null;
                scheduler = null;
                logDirFailureChannel = null;
                string = null;
                splitSegmentResult = null;
                SplitSegmentResult retryOnOffsetOverflow_result = splitSegmentResult2;
                this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                continue;
            }
            break;
        }
        Object var17_5 = null;
        Object var18_6 = null;
        var19_7 = null;
        logSegments = null;
        file2 = null;
        topicPartition = null;
        logConfig = null;
        scheduler = null;
        logDirFailureChannel = null;
        string = null;
        splitSegmentResult = null;
        if (!this.dir.getAbsolutePath().endsWith(UnifiedLog$.MODULE$.DeleteDirSuffix())) {
            void var7_32;
            void var5_31;
            Object var30_19;
            SplitSegmentResult splitSegmentResult3;
            LogSegments logSegments2;
            File file3;
            TopicPartition topicPartition2;
            LogConfig logConfig2;
            Scheduler scheduler2;
            LogDirFailureChannel logDirFailureChannel2;
            String string2;
            Tuple2<Object, Object> tuple2;
            while (true) {
                try {
                    Tuple2<Object, Object> tuple22;
                    Tuple2<Object, Object> tuple23 = tuple22 = this.recoverLog();
                    tuple22 = null;
                    tuple2 = tuple23;
                }
                catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                    void retryOnOffsetOverflow_splitOverflowedSegment_logPrefix;
                    void retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel;
                    void retryOnOffsetOverflow_splitOverflowedSegment_scheduler;
                    void retryOnOffsetOverflow_splitOverflowedSegment_config;
                    void retryOnOffsetOverflow_splitOverflowedSegment_topicPartition;
                    void retryOnOffsetOverflow_splitOverflowedSegment_dir;
                    void retryOnOffsetOverflow_splitOverflowedSegment_existingSegments;
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                    string2 = this.logIdent();
                    logDirFailureChannel2 = this.logDirFailureChannel;
                    scheduler2 = this.scheduler;
                    logConfig2 = this.config;
                    topicPartition2 = this.topicPartition;
                    file3 = this.dir;
                    logSegments2 = this.segments;
                    LogSegment retryOnOffsetOverflow_splitOverflowedSegment_segment = retryOnOffsetOverflow_e.segment();
                    SplitSegmentResult splitSegmentResult4 = splitSegmentResult3 = LocalLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_splitOverflowedSegment_segment, (LogSegments)retryOnOffsetOverflow_splitOverflowedSegment_existingSegments, (File)retryOnOffsetOverflow_splitOverflowedSegment_dir, (TopicPartition)retryOnOffsetOverflow_splitOverflowedSegment_topicPartition, (LogConfig)retryOnOffsetOverflow_splitOverflowedSegment_config, (Scheduler)retryOnOffsetOverflow_splitOverflowedSegment_scheduler, (LogDirFailureChannel)retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel, (String)retryOnOffsetOverflow_splitOverflowedSegment_logPrefix);
                    var30_19 = null;
                    logSegments2 = null;
                    file3 = null;
                    topicPartition2 = null;
                    logConfig2 = null;
                    scheduler2 = null;
                    logDirFailureChannel2 = null;
                    string2 = null;
                    splitSegmentResult3 = null;
                    SplitSegmentResult retryOnOffsetOverflow_result = splitSegmentResult4;
                    this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                    continue;
                }
                break;
            }
            Tuple2<Object, Object> tuple24 = tuple2;
            Object var28_17 = null;
            Object var29_18 = null;
            var30_19 = null;
            logSegments2 = null;
            file3 = null;
            topicPartition2 = null;
            logConfig2 = null;
            scheduler2 = null;
            logDirFailureChannel2 = null;
            string2 = null;
            splitSegmentResult3 = null;
            tuple2 = null;
            Tuple2<Object, Object> tuple25 = tuple24;
            if (tuple25 == null) {
                throw new MatchError(null);
            }
            long newRecoveryPoint = tuple25._1$mcJ$sp();
            long nextOffset = tuple25._2$mcJ$sp();
            ((LogSegment)this.segments.lastSegment().get()).resizeIndexes(Predef$.MODULE$.Integer2int(this.config.maxIndexSize()));
            l2 = var5_31;
            l = var7_32;
        } else {
            if (this.segments.isEmpty()) {
                String string3;
                File x$9 = this.dir;
                LogConfig x$11 = this.config;
                Time x$12 = this.time;
                int x$13 = this.config.initFileSize();
                boolean bl = false;
                boolean bl2 = false;
                String string4 = string3 = "";
                string3 = null;
                String x$16 = string4;
                this.segments.add(LogSegment$.MODULE$.open(x$9, 0L, x$11, x$12, bl, x$13, bl2, x$16));
            }
            l2 = 0L;
            l = 0L;
        }
        long l3 = l;
        long l4 = l2;
        this.leaderEpochCache.foreach((Function1 & Serializable)x$3 -> {
            x$3.truncateFromEnd(l3);
            return BoxedUnit.UNIT;
        });
        long newLogStartOffset = package$.MODULE$.max(this.logStartOffsetCheckpoint, ((LogSegment)this.segments.firstSegment().get()).baseOffset());
        this.leaderEpochCache.foreach((Function1 & Serializable)x$4 -> {
            x$4.truncateFromStart(this.logStartOffsetCheckpoint);
            return BoxedUnit.UNIT;
        });
        if (!this.producerStateManager.isEmpty()) {
            throw new IllegalStateException("Producer state must be empty during log initialization");
        }
        this.producerStateManager.removeStraySnapshots((Seq<Object>)this.segments.baseOffsets().toSeq());
        UnifiedLog$.MODULE$.rebuildProducerState(this.producerStateManager, this.segments, newLogStartOffset, l3, this.config.recordVersion(), this.time, this.hadCleanShutdown, this.logIdent());
        LogSegment activeSegment = (LogSegment)this.segments.lastSegment().get();
        return new LoadedLogOffsets(newLogStartOffset, l4, new LogOffsetMetadata(l3, activeSegment.baseOffset(), activeSegment.size()));
    }

    /*
     * WARNING - void declaration
     */
    private Set<File> removeTempFilesAndCollectSwapFiles() {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Set swapFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set cleanedFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        LongRef minCleanedFileOffset = LongRef.create((long)Long.MAX_VALUE);
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (!file.canRead()) {
                throw new IOException(new StringBuilder(20).append("Could not read file ").append(file).toString());
            }
            String filename = file.getName();
            if (filename.endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix()) && !filename.endsWith(Snapshots.DELETE_SUFFIX)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Deleting stray temporary file ").append(file.getAbsolutePath()).toString());
                return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.CleanedFileSuffix())) {
                minCleanedFileOffset$1.elem = Math.min(LocalLog$.MODULE$.offsetFromFile((File)file), minCleanedFileOffset$1.elem);
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                return swapFiles.$plus$eq(file);
            }
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = swapFiles.partition((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$4(minCleanedFileOffset, file)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Set invalidSwapFiles = (scala.collection.mutable.Set)tuple2._1();
        scala.collection.mutable.Set validSwapFiles = (scala.collection.mutable.Set)tuple2._2();
        var5_5.foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$5(this, minCleanedFileOffset, file)));
        cleanedFiles.foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$7(this, file)));
        return var6_6;
    }

    /*
     * WARNING - void declaration
     */
    private <T> T retryOnOffsetOverflow(Function0<T> fn) {
        while (true) {
            try {
                return (T)fn.apply();
            }
            catch (LogSegmentOffsetOverflowException e) {
                void splitOverflowedSegment_logPrefix;
                void splitOverflowedSegment_logDirFailureChannel;
                void splitOverflowedSegment_scheduler;
                void splitOverflowedSegment_config;
                void splitOverflowedSegment_topicPartition;
                void splitOverflowedSegment_dir;
                void splitOverflowedSegment_existingSegments;
                SplitSegmentResult splitSegmentResult;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                String string = this.logIdent();
                LogDirFailureChannel logDirFailureChannel = this.logDirFailureChannel;
                Scheduler scheduler = this.scheduler;
                LogConfig logConfig = this.config;
                TopicPartition topicPartition = this.topicPartition;
                File file = this.dir;
                LogSegments logSegments = this.segments;
                LogSegment splitOverflowedSegment_segment = e.segment();
                SplitSegmentResult splitSegmentResult2 = splitSegmentResult = LocalLog$.MODULE$.splitOverflowedSegment(splitOverflowedSegment_segment, (LogSegments)splitOverflowedSegment_existingSegments, (File)splitOverflowedSegment_dir, (TopicPartition)splitOverflowedSegment_topicPartition, (LogConfig)splitOverflowedSegment_config, (Scheduler)splitOverflowedSegment_scheduler, (LogDirFailureChannel)splitOverflowedSegment_logDirFailureChannel, (String)splitOverflowedSegment_logPrefix);
                Object var4_4 = null;
                logSegments = null;
                file = null;
                topicPartition = null;
                logConfig = null;
                scheduler = null;
                logDirFailureChannel = null;
                string = null;
                splitSegmentResult = null;
                SplitSegmentResult result = splitSegmentResult2;
                this.deleteProducerSnapshotsAsync(result.deletedSegments());
                continue;
            }
            break;
        }
    }

    private void loadSegmentFiles() {
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)x$6 -> x$6.getName(), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (LocalLog$.MODULE$.isIndexFile((File)file)) {
                void logFile_suffix;
                String string;
                long l = LocalLog$.MODULE$.offsetFromFile((File)file);
                String string2 = string = "";
                string = null;
                String string3 = string2;
                File logFile_dir = $this.dir;
                Object var7_5 = null;
                string3 = null;
                if (!LocalLog$.MODULE$.logFile(logFile_dir, l, (String)logFile_suffix).exists()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Found an orphaned index file ").append(file.getAbsolutePath()).append(", with no corresponding log file.").toString());
                    return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
                }
                return BoxedUnit.UNIT;
            }
            if (LocalLog$.MODULE$.isLogFile((File)file)) {
                void timeIndexFile_suffix;
                String string;
                long l = LocalLog$.MODULE$.offsetFromFile((File)file);
                String string4 = string = "";
                string = null;
                String string5 = string4;
                File timeIndexFile_dir = $this.dir;
                Object var11_9 = null;
                string5 = null;
                boolean timeIndexFileNewlyCreated = !LocalLog$.MODULE$.timeIndexFile(timeIndexFile_dir, l, (String)timeIndexFile_suffix).exists();
                LogSegment segment = LogSegment$.MODULE$.open($this.dir, l, $this.config, $this.time, true, 0, false, "");
                try {
                    segment.sanityCheck(timeIndexFileNewlyCreated);
                }
                catch (NoSuchFileException noSuchFileException) {
                    if ($this.hadCleanShutdown || segment.baseOffset() < $this.recoveryPointCheckpoint) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Could not find offset index file corresponding to log file").append(new StringBuilder(51).append(" ").append(segment.log().file().getAbsolutePath()).append(", recovering segment and rebuilding index files...").toString()).toString());
                    }
                    this.recoverSegment(segment);
                }
                catch (CorruptIndexException e) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Found a corrupted index file corresponding to log file").append(new StringBuilder(34).append(" ").append(segment.log().file().getAbsolutePath()).append(" due to ").append(e.getMessage()).append("}, recovering segment and").toString()).append(" rebuilding index files...").toString());
                    this.recoverSegment(segment);
                }
                return $this.segments.add(segment);
            }
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private int recoverSegment(LogSegment segment) {
        void var3_3;
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition, this.dir, this.producerStateManager.maxTransactionTimeoutMs(), this.producerStateManager.maxProducerIdExpirationMs(), this.time);
        UnifiedLog$.MODULE$.rebuildProducerState(producerStateManager, this.segments, this.logStartOffsetCheckpoint, segment.baseOffset(), this.config.recordVersion(), this.time, false, this.logIdent());
        int bytesTruncated = segment.recover(producerStateManager, this.leaderEpochCache);
        producerStateManager.takeSnapshot();
        return (int)var3_3;
    }

    public Tuple2<Object, Object> recoverLog() {
        Tuple2.mcJJ.sp sp2;
        boolean bl;
        if (!this.hadCleanShutdown) {
            Iterable<LogSegment> unflushed = this.segments.values(this.recoveryPointCheckpoint, Long.MAX_VALUE);
            int numUnflushed = unflushed.size();
            Iterator unflushedIter = unflushed.iterator();
            boolean truncated = false;
            IntRef numFlushed = IntRef.create((int)0);
            String threadName = Thread.currentThread().getName();
            this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)numUnflushed));
            while (unflushedIter.hasNext() && !truncated) {
                int n;
                LogSegment segment = (LogSegment)unflushedIter.next();
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Recovering unflushed segment ").append(segment.baseOffset()).append(". ").append(numFlushed$1.elem).append("/").append(numUnflushed).append(" recovered for ").append($this.topicPartition).append(".").toString());
                try {
                    n = this.recoverSegment(segment);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    long startOffset = segment.baseOffset();
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Found invalid offset during recovery. Deleting the").append(new StringBuilder(64).append(" corrupt segment and creating an empty one with starting offset ").append(startOffset).toString()).toString());
                    n = segment.truncateTo(startOffset);
                }
                if (n > 0) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(29).append("Corruption found in segment ").append(segment.baseOffset()).append(",").toString()).append(new StringBuilder(22).append(" truncating to offset ").append(segment.readNextOffset()).toString()).toString());
                    this.removeAndDeleteSegmentsAsync((Iterable<LogSegment>)unflushedIter.toList());
                    truncated = true;
                    this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)0));
                    continue;
                }
                ++numFlushed.elem;
                this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)(numUnflushed - numFlushed.elem)));
            }
        }
        Option logEndOffsetOption = this.deleteSegmentsIfLogStartGreaterThanLogEnd$1();
        if (this.segments.isEmpty()) {
            String string;
            File x$1 = this.dir;
            long x$2 = this.logStartOffsetCheckpoint;
            LogConfig x$3 = this.config;
            Time x$4 = this.time;
            int x$5 = this.config.initFileSize();
            boolean x$6 = Predef$.MODULE$.Boolean2boolean(this.config.preallocate());
            boolean bl2 = false;
            String string2 = string = "";
            string = null;
            String x$8 = string2;
            this.segments.add(LogSegment$.MODULE$.open(x$1, x$2, x$3, x$4, bl2, x$5, x$6, x$8));
        }
        if ((bl = this.hadCleanShutdown) && logEndOffsetOption instanceof Some) {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)logEndOffsetOption).value());
            sp2 = new Tuple2.mcJJ.sp(logEndOffset, logEndOffset);
        } else {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)logEndOffsetOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> ((LogSegment)$this.segments.lastSegment().get()).readNextOffset()));
            sp2 = new Tuple2.mcJJ.sp(Math.min(this.recoveryPointCheckpoint, logEndOffset), logEndOffset);
        }
        return sp2;
    }

    /*
     * WARNING - void declaration
     */
    private void removeAndDeleteSegmentsAsync(Iterable<LogSegment> segmentsToDelete) {
        if (segmentsToDelete.nonEmpty()) {
            void deleteSegmentFiles_logPrefix;
            void deleteSegmentFiles_logDirFailureChannel;
            void deleteSegmentFiles_scheduler;
            void deleteSegmentFiles_config;
            void deleteSegmentFiles_topicPartition;
            void deleteSegmentFiles_dir;
            List toDelete = segmentsToDelete.toList();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Deleting segments as part of log recovery: ").append(toDelete.mkString(",")).toString());
            toDelete.foreach((Function1 & Serializable)segment -> {
                this.segments.remove(segment.baseOffset());
                return BoxedUnit.UNIT;
            });
            String string = this.logIdent();
            LogDirFailureChannel logDirFailureChannel = this.logDirFailureChannel;
            Scheduler scheduler = this.scheduler;
            LogConfig logConfig = this.config;
            TopicPartition topicPartition = this.topicPartition;
            File file = this.dir;
            boolean deleteSegmentFiles_asyncDelete = true;
            LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)toDelete, deleteSegmentFiles_asyncDelete, (File)deleteSegmentFiles_dir, (TopicPartition)deleteSegmentFiles_topicPartition, (LogConfig)deleteSegmentFiles_config, (Scheduler)deleteSegmentFiles_scheduler, (LogDirFailureChannel)deleteSegmentFiles_logDirFailureChannel, (String)deleteSegmentFiles_logPrefix);
            file = null;
            topicPartition = null;
            logConfig = null;
            scheduler = null;
            logDirFailureChannel = null;
            string = null;
            this.deleteProducerSnapshotsAsync(segmentsToDelete);
        }
    }

    private void deleteProducerSnapshotsAsync(Iterable<LogSegment> segments) {
        UnifiedLog$.MODULE$.deleteProducerSnapshots(segments, this.producerStateManager, true, this.scheduler, this.config, this.logDirFailureChannel, this.dir.getParent(), this.topicPartition);
    }

    public static final /* synthetic */ boolean $anonfun$load$1(File f) {
        File isLogFile_file = new File(CoreUtils$.MODULE$.replaceSuffix(f.getPath(), UnifiedLog$.MODULE$.SwapFileSuffix(), ""));
        return LocalLog$.MODULE$.isLogFile(isLogFile_file);
    }

    public static final /* synthetic */ void $anonfun$load$2(LogLoader $this, LongRef minSwapFileOffset$1, LongRef maxSwapFileOffset$1, File f) {
        long l = LocalLog$.MODULE$.offsetFromFile(f);
        File x$1 = f.getParentFile();
        LogConfig x$3 = $this.config;
        Time x$4 = $this.time;
        String x$5 = UnifiedLog$.MODULE$.SwapFileSuffix();
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        LogSegment segment = LogSegment$.MODULE$.open(x$1, l, x$3, x$4, bl, n, bl2, x$5);
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(94).append("Found log file ").append(f.getPath()).append(" from interrupted swap operation, which is recoverable from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files by renaming.").toString());
        minSwapFileOffset$1.elem = Math.min(segment.baseOffset(), minSwapFileOffset$1.elem);
        maxSwapFileOffset$1.elem = Math.max(segment.readNextOffset(), maxSwapFileOffset$1.elem);
    }

    public static final /* synthetic */ void $anonfun$load$10(LogLoader $this) {
        $this.segments.close();
        $this.segments.clear();
        $this.loadSegmentFiles();
    }

    public static final /* synthetic */ Tuple2 $anonfun$load$11(LogLoader $this) {
        return $this.recoverLog();
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$4(LongRef minCleanedFileOffset$1, File file) {
        return LocalLog$.MODULE$.offsetFromFile(file) >= minCleanedFileOffset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$5(LogLoader $this, LongRef minCleanedFileOffset$1, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Deleting invalid swap file ").append(file.getAbsoluteFile()).append(" minCleanedFileOffset: ").append(minCleanedFileOffset$1.elem).toString());
        return Files.deleteIfExists(file.toPath());
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$7(LogLoader $this, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Deleting stray .clean file ").append(file.getAbsolutePath()).toString());
        return Files.deleteIfExists(file.toPath());
    }

    private final Option deleteSegmentsIfLogStartGreaterThanLogEnd$1() {
        if (this.segments.nonEmpty()) {
            long logEndOffset = ((LogSegment)this.segments.lastSegment().get()).readNextOffset();
            if (logEndOffset >= this.logStartOffsetCheckpoint) {
                return new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append(new StringBuilder(46).append("Deleting all segments because logEndOffset (").append(logEndOffset).append(") ").toString()).append(new StringBuilder(33).append("is smaller than logStartOffset ").append($this.logStartOffsetCheckpoint).append(". ").toString()).append("This could happen if segment files were deleted from the file system.").toString());
            this.removeAndDeleteSegmentsAsync(this.segments.values());
            this.leaderEpochCache.foreach((Function1 & Serializable)x$7 -> {
                x$7.clearAndFlush();
                return BoxedUnit.UNIT;
            });
            this.producerStateManager.truncateFullyAndStartAt(this.logStartOffsetCheckpoint);
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public LogLoader(File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, Time time, LogDirFailureChannel logDirFailureChannel, boolean hadCleanShutdown, LogSegments segments, long logStartOffsetCheckpoint, long recoveryPointCheckpoint, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, ConcurrentMap<String, Object> numRemainingSegments) {
        this.dir = dir;
        this.topicPartition = topicPartition;
        this.config = config;
        this.scheduler = scheduler;
        this.time = time;
        this.logDirFailureChannel = logDirFailureChannel;
        this.hadCleanShutdown = hadCleanShutdown;
        this.segments = segments;
        this.logStartOffsetCheckpoint = logStartOffsetCheckpoint;
        this.recoveryPointCheckpoint = recoveryPointCheckpoint;
        this.leaderEpochCache = leaderEpochCache;
        this.producerStateManager = producerStateManager;
        this.numRemainingSegments = numRemainingSegments;
        this.logIdent_$eq(new StringBuilder(29).append("[LogLoader partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
    }
}

