/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001\u0002\u0016,\u0001ABQ!\u000e\u0001\u0005\u0002YBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004J\u0001\u0001\u0006IA\u000f\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003:\u0011\u0019Y\u0005\u0001)A\u0005u!9A\n\u0001b\u0001\n\u0013I\u0004BB'\u0001A\u0003%!\bC\u0004O\u0001\t\u0007I\u0011B\u001d\t\r=\u0003\u0001\u0015!\u0003;\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015\u0011\u0007\u0001\"\u0001R\u0011\u0015!\u0007\u0001\"\u0001R\u0011\u00151\u0007\u0001\"\u0001R\u0011\u0015A\u0007\u0001\"\u0001R\u0011\u0015Q\u0007\u0001\"\u0001R\u0011\u0015a\u0007\u0001\"\u0001R\u0011\u0015q\u0007\u0001\"\u0001R\u0011\u0015\u0001\b\u0001\"\u0001R\u0011\u0015\u0011\b\u0001\"\u0001R\u0011\u0015!\b\u0001\"\u0001R\u0011\u00151\b\u0001\"\u0001R\u0011\u0015A\b\u0001\"\u0001R\u0011\u0015Q\b\u0001\"\u0001R\u0011\u0015a\b\u0001\"\u0001R\u0011\u0015q\b\u0001\"\u0001R\u0011\u0019\t\t\u0001\u0001C\u0001#\"1\u0011Q\u0001\u0001\u0005\u0002ECa!!\u0003\u0001\t\u0003\t\u0006BBA\u0007\u0001\u0011\u0005\u0011\u000b\u0003\u0004\u0002\u0012\u0001!\t!\u0015\u0005\u0007\u0003+\u0001A\u0011A)\t\r\u0005e\u0001\u0001\"\u0001R\u0011\u0019\ti\u0002\u0001C\u0001#\"1\u0011\u0011\u0005\u0001\u0005\u0002ECa!!\n\u0001\t\u0003\t\u0006BBA\u0015\u0001\u0011\u0005\u0011\u000b\u0003\u0004\u0002.\u0001!\t!\u0015\u0005\u0007\u0003c\u0001A\u0011A)\t\r\u0005U\u0002\u0001\"\u0001R\u0011\u0019\tI\u0004\u0001C\u0001#\"1\u0011Q\b\u0001\u0005\u0002E\u0013\u0011\u0004R3tGJL'-Z\"p]N,X.\u001a:He>,\b\u000fV3ti*\u0011A&L\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002]\u0005)1.\u00194lC\u000e\u00011C\u0001\u00012!\t\u00114'D\u0001,\u0013\t!4F\u0001\rD_:\u001cX/\\3s\u000fJ|W\u000f]\"p[6\fg\u000e\u001a+fgR\fa\u0001P5oSRtD#A\u001c\u0011\u0005I\u0002\u0011a\u00053fg\u000e\u0014\u0018NY3UsB,wJ\u001a4tKR\u001cX#\u0001\u001e\u0011\u0007mr\u0004)D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0015\t%O]1z!\rYd(\u0011\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA\u0001\\1oO*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005\u0019\u0019FO]5oO\u0006!B-Z:de&\u0014W\rV=qK>3gm]3ug\u0002\n1\u0003Z3tGJL'-\u001a+za\u0016lU-\u001c2feN\fA\u0003Z3tGJL'-\u001a+za\u0016lU-\u001c2feN\u0004\u0013!\u00053fg\u000e\u0014\u0018NY3UsB,7\u000b^1uK\u0006\u0011B-Z:de&\u0014W\rV=qKN#\u0018\r^3!\u00035!Wm]2sS\n,G+\u001f9fg\u0006qA-Z:de&\u0014W\rV=qKN\u0004\u0013\u0001\b;fgR$Um]2sS\n,gj\u001c8Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u000b\u0002%B\u00111hU\u0005\u0003)r\u0012A!\u00168ji\"\u0012!B\u0016\t\u0003/\u0002l\u0011\u0001\u0017\u0006\u00033j\u000b1!\u00199j\u0015\tYF,A\u0004kkBLG/\u001a:\u000b\u0005us\u0016!\u00026v]&$(\"A0\u0002\u0007=\u0014x-\u0003\u0002b1\n!A+Z:u\u0003\t\"Xm\u001d;EKN\u001c'/\u001b2f/&$\b.T;mi&\u0004H.Z*vE\u0006\u001bG/[8og\"\u00121BV\u0001\u001bi\u0016\u001cH\u000fR3tGJL'-Z,ji\"\u001cF/\u0019;f-\u0006dW/\u001a\u0015\u0003\u0019Y\u000bQ\u0005^3ti\u0012+7o\u0019:jE\u0016|eMZ:fiN|eMT8o\u000bbL7\u000f^5oO\u001e\u0013x.\u001e9)\u000551\u0016!\n;fgR$Um]2sS\n,W*Z7cKJ\u001cxJ\u001a(p]\u0016C\u0018n\u001d;j]\u001e<%o\\;qQ\tqa+A\u0012uKN$H)Z:de&\u0014Wm\u0015;bi\u0016|eMT8o\u000bbL7\u000f^5oO\u001e\u0013x.\u001e9)\u0005=1\u0016!\u0007;fgR$Um]2sS\n,W\t_5ti&twm\u0012:pkBD#\u0001\u0005,\u00025Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3Fq&\u001cH/\u001b8h\u000fJ|W\u000f]:)\u0005E1\u0016!\b;fgR$Um]2sS\n,\u0017\t\u001c7Fq&\u001cH/\u001b8h\u000fJ|W\u000f]:)\u0005I1\u0016A\t;fgR$Um]2sS\n,wJ\u001a4tKR\u001cxJZ#ySN$\u0018N\\4He>,\b\u000f\u000b\u0002\u0014-\u0006\u0011C/Z:u\t\u0016\u001c8M]5cK6+WNY3sg>3W\t_5ti&twm\u0012:pkBD#\u0001\u0006,\u0002AQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3Ti\u0006$Xm\u00144Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u0015\u0003+Y\u000ba\u0007^3ti\u0012+7o\u0019:jE\u0016\u001cF/\u0019;f\u001f\u001a,\u00050[:uS:<wI]8va^KG\u000f\u001b*pk:$'k\u001c2j]\u0006\u001b8/[4o_JD#A\u0006,\u0002MQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3Fq&\u001cH/\u001b8h\u000fJ|W\u000f],ji\"tu.T3nE\u0016\u00148\u000f\u000b\u0002\u0018-\u0006yC/Z:u\t\u0016\u001c8M]5cK>3gm]3ug>3W\t_5ti&twm\u0012:pkB<\u0016\u000e\u001e5O_6+WNY3sg\"\u0012\u0001DV\u00010i\u0016\u001cH\u000fR3tGJL'-Z'f[\n,'o](g\u000bbL7\u000f^5oO\u001e\u0013x.\u001e9XSRDgj\\'f[\n,'o\u001d\u0015\u00033Y\u000bQ\u0006^3ti\u0012+7o\u0019:jE\u0016\u001cF/\u0019;f\u001f\u001a,\u00050[:uS:<wI]8va^KG\u000f\u001b(p\u001b\u0016l'-\u001a:tQ\tQb+\u0001\u001auKN$H)Z:de&\u0014WmV5uQ\u000e{gn];nKJ\u001cx+\u001b;i_V$\u0018i]:jO:,G\rU1si&$\u0018n\u001c8tQ\tYb+A\u001duKN$H)Z:de&\u0014Wm\u00144gg\u0016$8oV5uQ\u000e{gn];nKJ\u001cx+\u001b;i_V$\u0018i]:jO:,G\rU1si&$\u0018n\u001c8tQ\tab+A\u001duKN$H)Z:de&\u0014W-T3nE\u0016\u00148oV5uQ\u000e{gn];nKJ\u001cx+\u001b;i_V$\u0018i]:jO:,G\rU1si&$\u0018n\u001c8tQ\tib+A\u001cuKN$H)Z:de&\u0014Wm\u0015;bi\u0016<\u0016\u000e\u001e5D_:\u001cX/\\3sg^KG\u000f[8vi\u0006\u001b8/[4oK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003=Y\u000bq\u0007^3ti\u0012+7o\u0019:jE\u0016<\u0016\u000e\u001e5Nk2$\u0018\u000eU1si&$\u0018n\u001c8U_BL7-\u00118e\u001bVdG/\u001b9mK\u000e{gn];nKJ\u001c\bFA\u0010W\u0003y\"Xm\u001d;EKN\u001c'/\u001b2f\u001f\u001a47/\u001a;t/&$\b.T;mi&\u0004\u0016M\u001d;ji&|g\u000eV8qS\u000e\fe\u000eZ'vYRL\u0007\u000f\\3D_:\u001cX/\\3sg\"\u0012\u0001EV\u0001?i\u0016\u001cH\u000fR3tGJL'-Z'f[\n,'o],ji\"lU\u000f\u001c;j!\u0006\u0014H/\u001b;j_:$v\u000e]5d\u0003:$W*\u001e7uSBdWmQ8ogVlWM]:)\u0005\u00052\u0016\u0001\u0010;fgR$Um]2sS\n,7\u000b^1uK^KG\u000f['vYRL\u0007+\u0019:uSRLwN\u001c+pa&\u001c\u0017I\u001c3Nk2$\u0018\u000e\u001d7f\u0007>t7/^7feND#A\t,\u0002?Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3TS6\u0004H.Z\"p]N,X.\u001a:He>,\b\u000f\u000b\u0002$-\u0006yC/Z:u\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9XSRD7\u000b[8si&s\u0017\u000e^5bY&T\u0018\r^5p]RKW.Z8vi\"\u0012AEV\u00017i\u0016\u001cH\u000fR3tGJL'-Z$s_V\u0004xJ\u001a4tKR\u001cx+\u001b;i'\"|'\u000f^%oSRL\u0017\r\\5{CRLwN\u001c+j[\u0016|W\u000f\u001e\u0015\u0003KY\u000ba\u0007^3ti\u0012+7o\u0019:jE\u0016<%o\\;q\u001b\u0016l'-\u001a:t/&$\bn\u00155peRLe.\u001b;jC2L'0\u0019;j_:$\u0016.\\3pkRD#A\n,\u0002iQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3He>,\bo\u0015;bi\u0016<\u0016\u000e\u001e5TQ>\u0014H/\u00138ji&\fG.\u001b>bi&|g\u000eV5nK>,H\u000f\u000b\u0002(-\u0006iC/Z:u\t\u0016\u001c8M]5cK^KG\u000f[+oe\u0016\u001cwn\u001a8ju\u0016$g*Z<D_:\u001cX/\\3s\u001fB$\u0018n\u001c8)\u0005!2\u0016\u0001\t;fgR$Um]2sS\n,gj\u001c8PM\u001a\u001cX\r^\"p[6LGo\u0012:pkBD#!\u000b,")
public class DescribeConsumerGroupTest
extends ConsumerGroupCommandTest {
    private final String[][] describeTypeOffsets = new String[][]{{""}, {"--offsets"}};
    private final String[][] describeTypeMembers = new String[][]{{"--members"}, {"--members", "--verbose"}};
    private final String[][] describeTypeState = new String[][]{{"--state"}};
    private final String[][] describeTypes = (String[][])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.describeTypeOffsets()), (Object)this.describeTypeMembers(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Object)this.describeTypeState(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));

    private String[][] describeTypeOffsets() {
        return this.describeTypeOffsets;
    }

    private String[][] describeTypeMembers() {
        return this.describeTypeMembers;
    }

    private String[][] describeTypeState() {
        return this.describeTypeState;
    }

    private String[][] describeTypes() {
        return this.describeTypes;
    }

    @Test
    public void testDescribeNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String missingGroup = "missing.group";
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes()), (Function1 & Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeNonExistingGroup$1(this, missingGroup, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeWithMultipleSubActions() {
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef exitMessage = ObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, err) -> DescribeConsumerGroupTest.$anonfun$testDescribeWithMultipleSubActions$1(exitStatus, exitMessage, BoxesRunTime.unboxToInt((Object)status), err);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var5_3 = null;
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group(), "--members", "--state"};
        try {
            try {
                ConsumerGroupCommand$.MODULE$.main(cgcArgs);
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit.resetExitProcedure();
        }
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
        Assertions.assertTrue((boolean)((String)((Option)exitMessage.elem).get()).contains("Option [describe] takes at most one of these options"));
    }

    @Test
    public void testDescribeWithStateValue() {
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef exitMessage = ObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, err) -> DescribeConsumerGroupTest.$anonfun$testDescribeWithStateValue$1(exitStatus, exitMessage, BoxesRunTime.unboxToInt((Object)status), err);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var5_3 = null;
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--all-groups", "--state", "Stable"};
        try {
            try {
                ConsumerGroupCommand$.MODULE$.main(cgcArgs);
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit.resetExitProcedure();
        }
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
        Assertions.assertTrue((boolean)((String)((Option)exitMessage.elem).get()).contains("Option [describe] does not take a value for [state]"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeOffsetsOfNonExistingGroup() {
        void var5_5;
        void var4_4;
        String group = "missing.group";
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", group};
        Tuple2 tuple2 = this.getConsumerGroupService(cgcArgs).collectGroupOffsets(group);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Assertions.assertTrue((var4_4.contains((Object)"Dead") && var5_5.contains(package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)) ? 1 : 0) != 0, (String)new StringBuilder(65).append("Expected the state to be 'Dead', with no members in the group '").append(group).append("'.").toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeMembersOfNonExistingGroup() {
        void var9_9;
        void var8_8;
        void var6_6;
        void var5_5;
        String group = "missing.group";
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", group};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Tuple2 tuple2 = service.collectGroupMembers(group, false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Assertions.assertTrue((var5_5.contains((Object)"Dead") && var6_6.contains(package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)) ? 1 : 0) != 0, (String)new StringBuilder(65).append("Expected the state to be 'Dead', with no members in the group '").append(group).append("'.").toString());
        Tuple2 tuple22 = service.collectGroupMembers(group, true);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Option state2 = (Option)tuple22._1();
        Option assignments2 = (Option)tuple22._2();
        Assertions.assertTrue((var8_8.contains((Object)"Dead") && var9_9.contains(package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)) ? 1 : 0) != 0, (String)new StringBuilder(82).append("Expected the state to be 'Dead', with no members in the group '").append(group).append("' (verbose option).").toString());
    }

    @Test
    public void testDescribeStateOfNonExistingGroup() {
        String group = "missing.group";
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", group};
        ConsumerGroupCommand.GroupState state = this.getConsumerGroupService(cgcArgs).collectGroupState(group);
        String string = state.state();
        String string2 = "Dead";
        Assertions.assertTrue((string != null && string.equals(string2) && state.numMembers() == 0 && state.coordinator() != null && ((IterableOnceOps)this.servers().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfNonExistingGroup$1(x$4)))).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id())) ? 1 : 0) != 0, (String)new StringBuilder(65).append("Expected the state to be 'Dead', with no members in the group '").append(group).append("'.").toString());
    }

    @Test
    public void testDescribeExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes()), (Function1 & Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroup$1(this, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeExistingGroups() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String[] groups = (String[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes()), (Function1 & Serializable)describeType -> {
            String group = new StringBuilder(0).append(this.group()).append(Predef$.MODULE$.wrapRefArray((Object[])describeType).mkString("")).toString();
            String x$3 = this.addConsumerGroupExecutor$default$2();
            String x$4 = this.addConsumerGroupExecutor$default$4();
            Option<Properties> x$5 = this.addConsumerGroupExecutor$default$5();
            boolean x$6 = this.addConsumerGroupExecutor$default$6();
            this.addConsumerGroupExecutor(1, x$3, group, x$4, x$5, x$6);
            return new String[]{"--group", group};
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class));
        int expectedNumLines = this.describeTypes().length * 2;
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes()), (Function1 & Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroups$3(this, groups, expectedNumLines, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeAllExistingGroups() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes()), (Function1 & Serializable)describeType -> {
            String group = new StringBuilder(0).append(this.group()).append(Predef$.MODULE$.wrapRefArray((Object[])describeType).mkString("")).toString();
            String x$3 = this.addConsumerGroupExecutor$default$2();
            String x$4 = this.addConsumerGroupExecutor$default$4();
            Option<Properties> x$5 = this.addConsumerGroupExecutor$default$5();
            boolean x$6 = this.addConsumerGroupExecutor$default$6();
            return this.addConsumerGroupExecutor(1, x$3, group, x$4, x$5, x$6);
        });
        int expectedNumLines = this.describeTypes().length * 2;
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes()), (Function1 & Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeAllExistingGroups$2(this, expectedNumLines, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeOffsetsOfExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$9(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeMembersOfExistingGroup() {
        void var4_7;
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$6(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Tuple2 tuple2 = service.collectGroupMembers(this.group(), true);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option assignments = (Option)tuple2._2();
        if (None$.MODULE$.equals(var4_7)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(52).append("Expected partition assignments for members of group ").append(this.group()).toString());
            return;
        }
        if (var4_7 instanceof Some) {
            Seq memberAssignments = (Seq)((Some)var4_7).value();
            Assertions.assertTrue((memberAssignments.size() == 1 && ((ConsumerGroupCommand.MemberAssignmentState)memberAssignments.head()).assignment().size() == 1 ? 1 : 0) != 0, (String)new StringBuilder(73).append("Expected a topic partition assigned to the single group member for group ").append(this.group()).toString());
            return;
        }
        throw new MatchError((Object)var4_7);
    }

    @Test
    public void testDescribeStateOfExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroup$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroup$3(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testDescribeStateOfExistingGroupWithRoundRobinAssignor() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String x$2 = RoundRobinAssignor.class.getName();
        String x$3 = this.addConsumerGroupExecutor$default$2();
        String x$4 = this.addConsumerGroupExecutor$default$3();
        Option<Properties> x$5 = this.addConsumerGroupExecutor$default$5();
        boolean x$6 = this.addConsumerGroupExecutor$default$6();
        this.addConsumerGroupExecutor(1, x$3, x$4, x$2, x$5, x$6);
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithRoundRobinAssignor$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithRoundRobinAssignor$3(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testDescribeExistingGroupWithNoMembers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes()), (Function1 & Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembers$1(this, describeType);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeOffsetsOfExistingGroupWithNoMembers() {
        void var7_16;
        void var6_15;
        void var5_13;
        Tuple2 tuple2;
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected the group to initially become stable, and to find group in assignments after initial offset commit.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        executor.shutdown();
        long l3 = 15000L;
        long l4 = 100L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Tuple2 computeUntilTrue_result;
            if (DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$6(this, computeUntilTrue_result = service.collectGroupOffsets(this.group()))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + l3) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        Tuple2 tuple22 = tuple2;
        Object var12_10 = null;
        tuple2 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Tuple2 result = (Tuple2)tuple23._1();
        boolean bl = tuple23._2$mcZ$sp();
        if (var5_13 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)var5_13._1();
        Option assignments = (Option)var5_13._2();
        Assertions.assertTrue((boolean)bl, (String)new StringBuilder(75).append("Expected no active member in describe group results, state: ").append(var6_15).append(", assignments: ").append(var7_16).toString());
    }

    @Test
    public void testDescribeMembersOfExistingGroupWithNoMembers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroupWithNoMembers$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected the group to initially become stable, and to find group in assignments after initial offset commit.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        executor.shutdown();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroupWithNoMembers$5(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroupWithNoMembers$6(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
    }

    @Test
    public void testDescribeStateOfExistingGroupWithNoMembers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithNoMembers$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithNoMembers$3(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        executor.shutdown();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithNoMembers$4(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithNoMembers$5(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
    }

    @Test
    public void testDescribeWithConsumersWithoutAssignedPartitions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes()), (Function1 & Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeWithConsumersWithoutAssignedPartitions$1(this, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeOffsetsWithConsumersWithoutAssignedPartitions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        this.addConsumerGroupExecutor(2, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected rows for consumers with no assigned partitions in describe group results");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeMembersWithConsumersWithoutAssignedPartitions() {
        void var5_8;
        void var4_7;
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        this.addConsumerGroupExecutor(2, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected rows for consumers with no assigned partitions in describe group results");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Tuple2 tuple2 = service.collectGroupMembers(this.group(), true);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Assertions.assertTrue((var4_7.contains((Object)"Stable") && ((IterableOnceOps)var5_8.get()).count((Function1 & Serializable)x$46 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$7(x$46))) > 0 ? 1 : 0) != 0, (String)"Expected additional columns in verbose version of describe members");
    }

    @Test
    public void testDescribeStateWithConsumersWithoutAssignedPartitions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        this.addConsumerGroupExecutor(2, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeStateWithConsumersWithoutAssignedPartitions$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected two consumers in describe group results");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testDescribeWithMultiPartitionTopicAndMultipleConsumers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String topic2 = "foo2";
        this.createTopic(topic2, 2, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes()), (Function1 & Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumers$1(this, topic2, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String topic2 = "foo2";
        this.createTopic(topic2, 2, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.addConsumerGroupExecutor(2, topic2, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected two rows (one row per consumer) in describe group results.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers() {
        void var6_9;
        void var5_8;
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String topic2 = "foo2";
        this.createTopic(topic2, 2, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.addConsumerGroupExecutor(2, topic2, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected two rows (one row per consumer) in describe group members results.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Tuple2 tuple2 = service.collectGroupMembers(this.group(), true);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Assertions.assertTrue((var5_8.contains((Object)"Stable") && ((IterableOnceOps)var6_9.get()).count((Function1 & Serializable)x$53 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$6(x$53))) == 0 ? 1 : 0) != 0, (String)"Expected additional columns in verbose version of describe members");
    }

    @Test
    public void testDescribeStateWithMultiPartitionTopicAndMultipleConsumers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String topic2 = "foo2";
        this.createTopic(topic2, 2, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.addConsumerGroupExecutor(2, topic2, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeStateWithMultiPartitionTopicAndMultipleConsumers$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected a stable group with two members in describe group state result.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testDescribeSimpleConsumerGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        String topic2 = "foo2";
        this.createTopic(topic2, 2, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.addSimpleGroupExecutor((Iterable<TopicPartition>)((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), this.addSimpleGroupExecutor$default$2());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeSimpleConsumerGroup$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected a stable group with two members in describe group state result.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    @Test
    public void testDescribeGroupWithShortInitializationTimeout() {
        Object[] describeType = this.describeTypes()[Random$.MODULE$.nextInt(this.describeTypes().length)];
        String group = new StringBuilder(0).append(this.group()).append(Predef$.MODULE$.wrapRefArray(describeType).mkString("")).toString();
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--timeout", "1", "--group", group}), (Object)describeType, ClassTag$.MODULE$.apply(String.class));
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            JFunction0.mcV.sp & Serializable grabConsoleOutputAndError_f = (JFunction0.mcV.sp & Serializable)() -> service.describeGroups();
            ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
            ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
            }
            finally {
                Console$.MODULE$.out().flush();
                Console$.MODULE$.err().flush();
            }
            grabConsoleOutputAndError_out.toString();
            grabConsoleOutputAndError_err.toString();
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
    }

    @Test
    public void testDescribeGroupOffsetsWithShortInitializationTimeout() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group(), "--timeout", "1"};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> service.collectGroupOffsets(this.group()));
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
    }

    @Test
    public void testDescribeGroupMembersWithShortInitializationTimeout() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group(), "--timeout", "1"};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> service.collectGroupMembers(this.group(), false));
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> service.collectGroupMembers(this.group(), true));
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
    }

    @Test
    public void testDescribeGroupStateWithShortInitializationTimeout() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group(), "--timeout", "1"};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> service.collectGroupState(this.group()));
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
    }

    @Test
    public void testDescribeWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = new String[]{"--new-consumer", "--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        Assertions.assertThrows(OptionException.class, () -> this.getConsumerGroupService(cgcArgs));
    }

    @Test
    public void testDescribeNonOffsetCommitGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
        Properties customProps = new Properties();
        customProps.setProperty("enable.auto.commit", "false");
        Some x$2 = new Some((Object)customProps);
        String x$3 = this.addConsumerGroupExecutor$default$2();
        String x$4 = this.addConsumerGroupExecutor$default$3();
        String x$5 = this.addConsumerGroupExecutor$default$4();
        boolean x$6 = this.addConsumerGroupExecutor$default$6();
        this.addConsumerGroupExecutor(1, x$3, x$4, x$5, (Option<Properties>)x$2, x$6);
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$1(this, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$9(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ void $anonfun$testDescribeNonExistingGroup$1(DescribeConsumerGroupTest $this, String missingGroup$1, String[] describeType) {
        String[] cgcArgs = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.bootstrapServers($this.bootstrapServers$default$1()), "--describe", "--group", missingGroup$1}), (Object)describeType, ClassTag$.MODULE$.apply(String.class));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service.describeGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_5 = null;
        Object var6_6 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(new StringBuilder(33).append("Consumer group '").append(missingGroup$1).append("' does not exist.").toString()), (String)new StringBuilder(54).append("Expected error was not detected for describe option '").append(Predef$.MODULE$.wrapRefArray((Object[])describeType).mkString(" ")).append("'").toString());
    }

    public static final /* synthetic */ Nothing$ $anonfun$testDescribeWithMultipleSubActions$1(ObjectRef exitStatus$1, ObjectRef exitMessage$1, int status, Option err) {
        exitStatus$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
        exitMessage$1.elem = err;
        throw new RuntimeException();
    }

    public static final /* synthetic */ Nothing$ $anonfun$testDescribeWithStateValue$1(ObjectRef exitStatus$2, ObjectRef exitMessage$2, int status, Option err) {
        exitStatus$2.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
        exitMessage$2.elem = err;
        throw new RuntimeException();
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfNonExistingGroup$1(KafkaServer x$4) {
        return x$4.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroup$2(ConsumerGroupCommand.ConsumerGroupService service$2) {
        JFunction0.mcV.sp & Serializable grabConsoleOutputAndError_f = (JFunction0.mcV.sp & Serializable)() -> service$2.describeGroups();
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        String string = grabConsoleOutputAndError_err.toString();
        String string2 = grabConsoleOutputAndError_out.toString();
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        return string2.trim().split("\n").length == 2 && string.isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeExistingGroup$4(String[] describeType$1) {
        return new StringBuilder(73).append("Expected a data row and no error in describe results with describe type ").append(Predef$.MODULE$.wrapRefArray((Object[])describeType$1).mkString(" ")).append(".").toString();
    }

    public static final /* synthetic */ void $anonfun$testDescribeExistingGroup$1(DescribeConsumerGroupTest $this, String[] describeType) {
        String group = new StringBuilder(0).append($this.group()).append(Predef$.MODULE$.wrapRefArray((Object[])describeType).mkString("")).toString();
        String x$3 = $this.addConsumerGroupExecutor$default$2();
        String x$4 = $this.addConsumerGroupExecutor$default$4();
        Option<Properties> x$5 = $this.addConsumerGroupExecutor$default$5();
        boolean x$6 = $this.addConsumerGroupExecutor$default$6();
        $this.addConsumerGroupExecutor(1, x$3, group, x$4, x$5, x$6);
        String[] cgcArgs = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.bootstrapServers($this.bootstrapServers$default$1()), "--describe", "--group", group}), (Object)describeType, ClassTag$.MODULE$.apply(String.class));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroup$2(service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroup$4(describeType));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroups$4(ConsumerGroupCommand.ConsumerGroupService service$3, int expectedNumLines$1) {
        JFunction0.mcV.sp & Serializable grabConsoleOutputAndError_f = (JFunction0.mcV.sp & Serializable)() -> service$3.describeGroups();
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        String string = grabConsoleOutputAndError_err.toString();
        String string2 = grabConsoleOutputAndError_out.toString();
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        return ((String[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])string2.trim().split("\n")), (Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)line.isEmpty()))).length == expectedNumLines$1 && string.isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeExistingGroups$7(String[] describeType$2) {
        return new StringBuilder(73).append("Expected a data row and no error in describe results with describe type ").append(Predef$.MODULE$.wrapRefArray((Object[])describeType$2).mkString(" ")).append(".").toString();
    }

    public static final /* synthetic */ void $anonfun$testDescribeExistingGroups$3(DescribeConsumerGroupTest $this, String[] groups$1, int expectedNumLines$1, String[] describeType) {
        String[] cgcArgs = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.bootstrapServers($this.bootstrapServers$default$1()), "--describe"}), (Object)groups$1, ClassTag$.MODULE$.apply(String.class))), (Object)describeType, ClassTag$.MODULE$.apply(String.class));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroups$4(service, expectedNumLines$1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroups$7(describeType));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeAllExistingGroups$3(ConsumerGroupCommand.ConsumerGroupService service$4, int expectedNumLines$2) {
        JFunction0.mcV.sp & Serializable grabConsoleOutputAndError_f = (JFunction0.mcV.sp & Serializable)() -> service$4.describeGroups();
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        String string = grabConsoleOutputAndError_err.toString();
        String string2 = grabConsoleOutputAndError_out.toString();
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        return ((String[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])string2.trim().split("\n")), (Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)line.isEmpty()))).length == expectedNumLines$2 && string.isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeAllExistingGroups$6(String[] describeType$3) {
        return new StringBuilder(73).append("Expected a data row and no error in describe results with describe type ").append(Predef$.MODULE$.wrapRefArray((Object[])describeType$3).mkString(" ")).append(".").toString();
    }

    public static final /* synthetic */ void $anonfun$testDescribeAllExistingGroups$2(DescribeConsumerGroupTest $this, int expectedNumLines$2, String[] describeType) {
        String[] cgcArgs = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.bootstrapServers($this.bootstrapServers$default$1()), "--describe", "--all-groups"}), (Object)describeType, ClassTag$.MODULE$.apply(String.class));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeAllExistingGroups$3(service, expectedNumLines$2)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeAllExistingGroups$6(describeType));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$9) {
        String string = x$9.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$10) {
        String string = x$10.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$4(String x$11) {
        String string = x$11.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$5(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$12) {
        String string = x$12.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$6(String x$13) {
        String string = x$13.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$7(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$14) {
        String string = x$14.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$8(String x$15) {
        String string = x$15.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$5) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = service$5.collectGroupOffsets($this.group());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        return var3_3.contains((Object)"Stable") && var4_4.isDefined() && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$2($this, x$9))) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableOps)((IterableOps)var4_4.get()).filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$3($this, x$10)))).head()).consumerId().exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$4(x$11))) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableOps)((IterableOps)var4_4.get()).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$5($this, x$12)))).head()).clientId().exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$6(x$13))) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableOps)((IterableOps)var4_4.get()).filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$7($this, x$14)))).head()).host().exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$8(x$15)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeOffsetsOfExistingGroup$9(DescribeConsumerGroupTest $this) {
        return new StringBuilder(130).append("Expected a 'Stable' group status, rows and valid values for consumer id / client id / host columns in describe results for group ").append($this.group()).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$17) {
        String string = x$17.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$18) {
        String string = x$18.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$19) {
        String string = x$19.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$5(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$20) {
        String string = x$20.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$6) {
        void var5_4;
        void var4_3;
        Tuple2 tuple2 = service$6.collectGroupMembers($this.group(), false);
        if (tuple2 == null) throw new MatchError(null);
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        if (!var4_3.contains((Object)"Stable")) return false;
        if (var5_4 instanceof Some) {
            Seq memberAssignments = (Seq)((Some)var5_4).value();
            if (memberAssignments.count((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$2($this, x$17))) != 1) return false;
            String string = ((ConsumerGroupCommand.MemberAssignmentState)((IterableOps)memberAssignments.filter((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$3($this, x$18)))).head()).consumerId();
            String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
            if (string == null) {
                if (string2 == null) return false;
            } else if (string.equals(string2)) return false;
            String string3 = ((ConsumerGroupCommand.MemberAssignmentState)((IterableOps)memberAssignments.filter((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$4($this, x$19)))).head()).clientId();
            String string4 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
            if (string3 == null) {
                if (string4 == null) return false;
            } else if (string3.equals(string4)) return false;
            String string5 = ((ConsumerGroupCommand.MemberAssignmentState)((IterableOps)memberAssignments.filter((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$5($this, x$20)))).head()).host();
            String string6 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
            if (string5 == null) {
                if (string6 == null) return false;
                return true;
            } else if (string5.equals(string6)) return false;
            return true;
        }
        if (!None$.MODULE$.equals(var5_4)) throw new MatchError((Object)var5_4);
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDescribeMembersOfExistingGroup$6(DescribeConsumerGroupTest $this) {
        return new StringBuilder(79).append("Expected a 'Stable' group status, rows and valid member information for group ").append($this.group()).append(".").toString();
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfExistingGroup$2(KafkaServer x$21) {
        return x$21.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeStateOfExistingGroup$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$7) {
        ConsumerGroupCommand.GroupState state = service$7.collectGroupState($this.group());
        String string = state.state();
        String string2 = "Stable";
        if (string != null && string.equals(string2) && state.numMembers() == 1) {
            String string3 = state.assignmentStrategy();
            String string4 = "range";
            if (string3 != null && string3.equals(string4) && state.coordinator() != null && ((IterableOnceOps)$this.servers().map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroup$2(x$21)))).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id()))) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDescribeStateOfExistingGroup$3(DescribeConsumerGroupTest $this) {
        return new StringBuilder(97).append("Expected a 'Stable' group status, with one member and round robin assignment strategy for group ").append($this.group()).append(".").toString();
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfExistingGroupWithRoundRobinAssignor$2(KafkaServer x$22) {
        return x$22.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeStateOfExistingGroupWithRoundRobinAssignor$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$8) {
        ConsumerGroupCommand.GroupState state = service$8.collectGroupState($this.group());
        String string = state.state();
        String string2 = "Stable";
        if (string != null && string.equals(string2) && state.numMembers() == 1) {
            String string3 = state.assignmentStrategy();
            String string4 = "roundrobin";
            if (string3 != null && string3.equals(string4) && state.coordinator() != null && ((IterableOnceOps)$this.servers().map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithRoundRobinAssignor$2(x$22)))).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id()))) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDescribeStateOfExistingGroupWithRoundRobinAssignor$3(DescribeConsumerGroupTest $this) {
        return new StringBuilder(97).append("Expected a 'Stable' group status, with one member and round robin assignment strategy for group ").append($this.group()).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroupWithNoMembers$2(ConsumerGroupCommand.ConsumerGroupService service$9) {
        JFunction0.mcV.sp & Serializable grabConsoleOutputAndError_f = (JFunction0.mcV.sp & Serializable)() -> service$9.describeGroups();
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        String string = grabConsoleOutputAndError_err.toString();
        String string2 = grabConsoleOutputAndError_out.toString();
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        return string2.trim().split("\n").length == 2 && string.isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeExistingGroupWithNoMembers$4(String[] describeType$4) {
        return new StringBuilder(70).append("Expected describe group results with one data row for describe type '").append(Predef$.MODULE$.wrapRefArray((Object[])describeType$4).mkString(" ")).append("'").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroupWithNoMembers$5(ConsumerGroupCommand.ConsumerGroupService service$9, String group$1) {
        JFunction0.mcV.sp & Serializable grabConsoleError_f = (JFunction0.mcV.sp & Serializable)() -> service$9.describeGroups();
        ByteArrayOutputStream grabConsoleError_err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withErr((OutputStream)grabConsoleError_err, (Function0)grabConsoleError_f);
        }
        finally {
            Console$.MODULE$.err().flush();
        }
        Object var2_2 = null;
        Object var3_3 = null;
        return grabConsoleError_err.toString().contains(new StringBuilder(40).append("Consumer group '").append(group$1).append("' has no active members.").toString());
    }

    public static final /* synthetic */ String $anonfun$testDescribeExistingGroupWithNoMembers$7(String[] describeType$4) {
        return new StringBuilder(71).append("Expected no active member in describe group results with describe type ").append(Predef$.MODULE$.wrapRefArray((Object[])describeType$4).mkString(" ")).toString();
    }

    public static final /* synthetic */ void $anonfun$testDescribeExistingGroupWithNoMembers$1(DescribeConsumerGroupTest $this, String[] describeType) {
        String group = new StringBuilder(0).append($this.group()).append(Predef$.MODULE$.wrapRefArray((Object[])describeType).mkString("")).toString();
        String x$3 = $this.addConsumerGroupExecutor$default$2();
        String x$4 = $this.addConsumerGroupExecutor$default$4();
        Option<Properties> x$5 = $this.addConsumerGroupExecutor$default$5();
        boolean x$6 = $this.addConsumerGroupExecutor$default$6();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, x$3, group, x$4, x$5, x$6);
        String[] cgcArgs = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.bootstrapServers($this.bootstrapServers$default$1()), "--describe", "--group", group}), (Object)describeType, ClassTag$.MODULE$.apply(String.class));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembers$2(service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembers$4(describeType));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        executor.shutdown();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembers$5(service, group)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembers$7(describeType));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$26) {
        String string = x$26.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$10) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = service$10.collectGroupOffsets($this.group());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        return var3_3.contains((Object)"Stable") && var4_4.exists((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)x$25.exists((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$3($this, x$26)))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$4() {
        return "Expected the group to initially become stable, and to find group in assignments after initial offset commit.";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$8(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$28) {
        String string = x$28.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final ConsumerGroupCommand.PartitionAssignmentState assignment$1(scala.collection.immutable.Seq testGroupAssignments$1) {
        return (ConsumerGroupCommand.PartitionAssignmentState)testGroupAssignments$1.head();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$9(String x$29) {
        String string = x$29.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$10(String x$30) {
        String string = x$30.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$11(String x$31) {
        String string = x$31.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$6(DescribeConsumerGroupTest $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)x0$1._1();
        Option assignments = (Option)x0$1._2();
        scala.collection.immutable.Seq testGroupAssignments = (scala.collection.immutable.Seq)Option$.MODULE$.option2Iterable(assignments).toSeq().flatMap((Function1 & Serializable)x$27 -> (Seq)x$27.filter((Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$8($this, x$28))));
        boolean bl = state.contains((Object)"Empty") && testGroupAssignments.size() == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)testGroupAssignments.head()).consumerId().exists((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$9(x$29))) && ((ConsumerGroupCommand.PartitionAssignmentState)testGroupAssignments.head()).clientId().exists((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$10(x$30))) && ((ConsumerGroupCommand.PartitionAssignmentState)testGroupAssignments.head()).host().exists((Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$11(x$31)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroupWithNoMembers$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$36) {
        String string = x$36.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroupWithNoMembers$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$11) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = service$11.collectGroupMembers($this.group(), false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        return var3_3.contains((Object)"Stable") && var4_4.exists((Function1 & Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)x$35.exists((Function1 & Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroupWithNoMembers$3($this, x$36)))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeMembersOfExistingGroupWithNoMembers$4() {
        return "Expected the group to initially become stable, and to find group in assignments after initial offset commit.";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroupWithNoMembers$5(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$11) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = service$11.collectGroupMembers($this.group(), false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        return var3_3.contains((Object)"Empty") && var4_4.isDefined() && ((SeqOps)var4_4.get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeMembersOfExistingGroupWithNoMembers$6(DescribeConsumerGroupTest $this) {
        return new StringBuilder(65).append("Expected no member in describe group members results for group '").append($this.group()).append("'").toString();
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfExistingGroupWithNoMembers$2(KafkaServer x$38) {
        return x$38.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeStateOfExistingGroupWithNoMembers$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$12) {
        ConsumerGroupCommand.GroupState state = service$12.collectGroupState($this.group());
        String string = state.state();
        String string2 = "Stable";
        return string != null && string.equals(string2) && state.numMembers() == 1 && state.coordinator() != null && ((IterableOnceOps)$this.servers().map((Function1 & Serializable)x$38 -> BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithNoMembers$2(x$38)))).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id()));
    }

    public static final /* synthetic */ String $anonfun$testDescribeStateOfExistingGroupWithNoMembers$3(DescribeConsumerGroupTest $this) {
        return new StringBuilder(75).append("Expected the group '").append($this.group()).append("' to initially become stable, and have a single member.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeStateOfExistingGroupWithNoMembers$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$12) {
        ConsumerGroupCommand.GroupState state = service$12.collectGroupState($this.group());
        String string = state.state();
        String string2 = "Empty";
        if (string != null && string.equals(string2) && state.numMembers() == 0) {
            String string3 = state.assignmentStrategy();
            String string4 = "";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDescribeStateOfExistingGroupWithNoMembers$5(DescribeConsumerGroupTest $this) {
        return new StringBuilder(68).append("Expected the group '").append($this.group()).append("' to become empty after the only member leaving.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeWithConsumersWithoutAssignedPartitions$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$13, String[] describeType$5) {
        int expectedNumRows;
        JFunction0.mcV.sp & Serializable grabConsoleOutputAndError_f = (JFunction0.mcV.sp & Serializable)() -> service$13.describeGroups();
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        String string = grabConsoleOutputAndError_err.toString();
        String string2 = grabConsoleOutputAndError_out.toString();
        Object var4_3 = null;
        Object var5_4 = null;
        Object var6_5 = null;
        int n = expectedNumRows = ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])$this.describeTypeMembers()), (Object)describeType$5) ? 3 : 2;
        return string.isEmpty() && ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])string2.trim().split("\n"))) == expectedNumRows;
    }

    public static final /* synthetic */ String $anonfun$testDescribeWithConsumersWithoutAssignedPartitions$4(String[] describeType$5) {
        return new StringBuilder(73).append("Expected a single data row in describe group result with describe type '").append(Predef$.MODULE$.wrapRefArray((Object[])describeType$5).mkString(" ")).append("'").toString();
    }

    public static final /* synthetic */ void $anonfun$testDescribeWithConsumersWithoutAssignedPartitions$1(DescribeConsumerGroupTest $this, String[] describeType) {
        String group = new StringBuilder(0).append($this.group()).append(Predef$.MODULE$.wrapRefArray((Object[])describeType).mkString("")).toString();
        String x$3 = $this.addConsumerGroupExecutor$default$2();
        String x$4 = $this.addConsumerGroupExecutor$default$4();
        Option<Properties> x$5 = $this.addConsumerGroupExecutor$default$5();
        boolean x$6 = $this.addConsumerGroupExecutor$default$6();
        $this.addConsumerGroupExecutor(2, x$3, group, x$4, x$5, x$6);
        String[] cgcArgs = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.bootstrapServers($this.bootstrapServers$default$1()), "--describe", "--group", group}), (Object)describeType, ClassTag$.MODULE$.apply(String.class));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeWithConsumersWithoutAssignedPartitions$2($this, service, describeType)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeWithConsumersWithoutAssignedPartitions$4(describeType));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$41) {
        String string = x$41.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isDefined();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$14) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = service$14.collectGroupOffsets($this.group());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        return var3_3.contains((Object)"Stable") && var4_4.isDefined() && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$2($this, x$41))) == 1 && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$3($this, x))) == 1;
    }

    public static final /* synthetic */ String $anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$4() {
        return "Expected rows for consumers with no assigned partitions in describe group results";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$43) {
        String string = x$43.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$5(ConsumerGroupCommand.MemberAssignmentState x$44) {
        return x$44.assignment().nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$15) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = service$15.collectGroupMembers($this.group(), false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        return var3_3.contains((Object)"Stable") && var4_4.isDefined() && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$2($this, x$43))) == 2 && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$3($this, x))) == 1 && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$4($this, x))) == 1 && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$5(x$44))) == 0;
    }

    public static final /* synthetic */ String $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$6() {
        return "Expected rows for consumers with no assigned partitions in describe group results";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$7(ConsumerGroupCommand.MemberAssignmentState x$46) {
        return x$46.assignment().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeStateWithConsumersWithoutAssignedPartitions$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$16) {
        ConsumerGroupCommand.GroupState state = service$16.collectGroupState($this.group());
        String string = state.state();
        String string2 = "Stable";
        return string != null && string.equals(string2) && state.numMembers() == 2;
    }

    public static final /* synthetic */ String $anonfun$testDescribeStateWithConsumersWithoutAssignedPartitions$2() {
        return "Expected two consumers in describe group results";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumers$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$17, String[] describeType$6) {
        int expectedNumRows;
        JFunction0.mcV.sp & Serializable grabConsoleOutputAndError_f = (JFunction0.mcV.sp & Serializable)() -> service$17.describeGroups();
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        String string = grabConsoleOutputAndError_err.toString();
        String string2 = grabConsoleOutputAndError_out.toString();
        Object var4_3 = null;
        Object var5_4 = null;
        Object var6_5 = null;
        int n = expectedNumRows = ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])$this.describeTypeState()), (Object)describeType$6) ? 2 : 3;
        return string.isEmpty() && ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])string2.trim().split("\n"))) == expectedNumRows;
    }

    public static final /* synthetic */ String $anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumers$4(String[] describeType$6) {
        return new StringBuilder(73).append("Expected a single data row in describe group result with describe type '").append(Predef$.MODULE$.wrapRefArray((Object[])describeType$6).mkString(" ")).append("'").toString();
    }

    public static final /* synthetic */ void $anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumers$1(DescribeConsumerGroupTest $this, String topic2$1, String[] describeType) {
        String group = new StringBuilder(0).append($this.group()).append(Predef$.MODULE$.wrapRefArray((Object[])describeType).mkString("")).toString();
        $this.addConsumerGroupExecutor(2, topic2$1, group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5(), $this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.bootstrapServers($this.bootstrapServers$default$1()), "--describe", "--group", group}), (Object)describeType, ClassTag$.MODULE$.apply(String.class));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DescribeConsumerGroupTest.$anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumers$2($this, service, describeType)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DescribeConsumerGroupTest.$anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumers$4(describeType));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$49) {
        String string = x$49.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$18) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = service$18.collectGroupOffsets($this.group());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        return var3_3.contains((Object)"Stable") && var4_4.isDefined() && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$2($this, x$49))) == 2 && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$3($this, x))) == 2 && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$4($this, x))) == 0;
    }

    public static final /* synthetic */ String $anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$5() {
        return "Expected two rows (one row per consumer) in describe group results.";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$51) {
        String string = x$51.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$19) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = service$19.collectGroupMembers($this.group(), false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        return var3_3.contains((Object)"Stable") && var4_4.isDefined() && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x$51 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$2($this, x$51))) == 2 && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$3($this, x))) == 2 && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$4($this, x))) == 0;
    }

    public static final /* synthetic */ String $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$5() {
        return "Expected two rows (one row per consumer) in describe group members results.";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$6(ConsumerGroupCommand.MemberAssignmentState x$53) {
        return x$53.assignment().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeStateWithMultiPartitionTopicAndMultipleConsumers$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$20) {
        ConsumerGroupCommand.GroupState state = service$20.collectGroupState($this.group());
        String string = state.state();
        String string2 = "Stable";
        if (string != null && string.equals(string2)) {
            String string3 = state.group();
            String string4 = $this.group();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null) && state.numMembers() == 2) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDescribeStateWithMultiPartitionTopicAndMultipleConsumers$2() {
        return "Expected a stable group with two members in describe group state result.";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeSimpleConsumerGroup$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$55) {
        String string = x$55.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeSimpleConsumerGroup$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$21) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = service$21.collectGroupOffsets($this.group());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        return var3_3.contains((Object)"Empty") && var4_4.isDefined() && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x$55 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeSimpleConsumerGroup$2($this, x$55))) == 2;
    }

    public static final /* synthetic */ String $anonfun$testDescribeSimpleConsumerGroup$3() {
        return "Expected a stable group with two members in describe group state result.";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$2(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$57) {
        String string = x$57.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$58) {
        String string = x$58.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$4(String x$59) {
        String string = x$59.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$5(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$60) {
        String string = x$60.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$6(String x$61) {
        String string = x$61.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$7(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$62) {
        String string = x$62.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$8(String x$63) {
        String string = x$63.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeNonOffsetCommitGroup$1(DescribeConsumerGroupTest $this, ConsumerGroupCommand.ConsumerGroupService service$26) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = service$26.collectGroupOffsets($this.group());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        return var3_3.contains((Object)"Stable") && var4_4.isDefined() && ((IterableOnceOps)var4_4.get()).count((Function1 & Serializable)x$57 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$2($this, x$57))) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableOps)((IterableOps)var4_4.get()).filter((Function1 & Serializable)x$58 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$3($this, x$58)))).head()).consumerId().exists((Function1 & Serializable)x$59 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$4(x$59))) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableOps)((IterableOps)var4_4.get()).filter((Function1 & Serializable)x$60 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$5($this, x$60)))).head()).clientId().exists((Function1 & Serializable)x$61 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$6(x$61))) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableOps)((IterableOps)var4_4.get()).filter((Function1 & Serializable)x$62 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$7($this, x$62)))).head()).host().exists((Function1 & Serializable)x$63 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeNonOffsetCommitGroup$8(x$63)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeNonOffsetCommitGroup$9(DescribeConsumerGroupTest $this) {
        return new StringBuilder(152).append("Expected a 'Stable' group status, rows and valid values for consumer id / client id / host columns in describe results for non-offset-committing group ").append($this.group()).append(".").toString();
    }

    public static final /* synthetic */ Object $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$6$adapted(DescribeConsumerGroupTest $this, Tuple2 x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$6($this, x0$1));
    }
}

