/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\b\u0011\u0001UAQ\u0001\b\u0001\u0005\u0002uAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u0004+\u0001\u0001\u0006IA\t\u0005\bW\u0001\u0001\r\u0011\"\u0001-\u0011\u001dI\u0004\u00011A\u0005\u0002iBaa\u0011\u0001!B\u0013i\u0003\"\u0002#\u0001\t\u0003*\u0005\"\u0002,\u0001\t\u0003:\u0006\"\u0002/\u0001\t\u00039\u0006\"B1\u0001\t\u00039\u0006\"B2\u0001\t\u00039\u0006\"B3\u0001\t\u00131\u0007\"\u0002;\u0001\t\u00039\u0006\"B;\u0001\t\u00031(A\u0007'jgR|eMZ:fiNLe\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\t\u0013\u0003\u0015\tG-\\5o\u0015\u0005\u0019\u0012!B6bM.\f7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\n\u0002\u0017%tG/Z4sCRLwN\\\u0005\u00037a\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"a\b\u0001\u000e\u0003A\t\u0011\u0002^8qS\u000et\u0015-\\3\u0016\u0003\t\u0002\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\t1\fgn\u001a\u0006\u0002O\u0005!!.\u0019<b\u0013\tICE\u0001\u0004TiJLgnZ\u0001\u000bi>\u0004\u0018n\u0019(b[\u0016\u0004\u0013aC1e[&t7\t\\5f]R,\u0012!\f\t\u0003]]j\u0011a\f\u0006\u0003#AR!!\r\u001a\u0002\u000f\rd\u0017.\u001a8ug*\u00111c\r\u0006\u0003iU\na!\u00199bG\",'\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029_\t)\u0011\tZ7j]\u0006y\u0011\rZ7j]\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002<\u0003B\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t!QK\\5u\u0011\u001d\u0011U!!AA\u00025\n1\u0001\u001f\u00132\u00031\tG-\\5o\u00072LWM\u001c;!\u0003\u0015\u0019X\r^+q)\tYd\tC\u0003H\u000f\u0001\u0007\u0001*\u0001\u0005uKN$\u0018J\u001c4p!\tI\u0005+D\u0001K\u0015\tYE*A\u0002ba&T!!\u0014(\u0002\u000f),\b/\u001b;fe*\u0011q*N\u0001\u0006UVt\u0017\u000e^\u0005\u0003#*\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0003\u000fM\u0003\"!\u0013+\n\u0005US%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u0001<Q\tA\u0011\f\u0005\u0002J5&\u00111L\u0013\u0002\n\u0003\u001a$XM]#bG\"\f!\u0003^3ti\u0016\u000b'\u000f\\5fgR|eMZ:fi\"\u0012\u0011B\u0018\t\u0003\u0013~K!\u0001\u0019&\u0003\tQ+7\u000f^\u0001\u0011i\u0016\u001cH\u000fT1uKN$xJ\u001a4tKRD#A\u00030\u0002-Q,7\u000f^'bqRKW.Z:uC6\u0004xJ\u001a4tKRD#a\u00030\u0002\u001fI,hNR3uG\"|eMZ:fiN$2a\u001a8p!\tA7N\u0004\u0002/S&\u0011!nL\u0001\u0012\u0019&\u001cHo\u00144gg\u0016$8OU3tk2$\u0018B\u00017n\u0005Ua\u0015n\u001d;PM\u001a\u001cX\r^:SKN,H\u000e^%oM>T!A[\u0018\t\u000b-b\u0001\u0019A\u0017\t\u000bAd\u0001\u0019A9\u0002\u0015=4gm]3u'B,7\r\u0005\u0002/e&\u00111o\f\u0002\u000b\u001f\u001a47/\u001a;Ta\u0016\u001c\u0017a\u00049s_\u0012,8-Z'fgN\fw-Z:\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012a\u001e\t\u0004qnlX\"A=\u000b\u0005il\u0014AC2pY2,7\r^5p]&\u0011A0\u001f\u0002\u0004'\u0016\f\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002I\taa]3sm\u0016\u0014\u0018bAA\u0003\u007f\nY1*\u00194lC\u000e{gNZ5h\u0001")
public class ListOffsetsIntegrationTest
extends KafkaServerTestHarness {
    private final String topicName;
    private Admin adminClient = null;

    public String topicName() {
        return this.topicName;
    }

    public Admin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topicName(), 1, (short)1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.produceMessages();
        this.adminClient_$eq(Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(this.bootstrapServers$default$1()))}))).asJava()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"ListOffsetsAdminClient");
        super.tearDown();
    }

    @Test
    public void testEarliestOffset() {
        ListOffsetsResult.ListOffsetsResultInfo earliestOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.EarliestSpec());
        Assertions.assertEquals((long)0L, (long)earliestOffset.offset());
    }

    @Test
    public void testLatestOffset() {
        ListOffsetsResult.ListOffsetsResultInfo latestOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.LatestSpec());
        Assertions.assertEquals((long)3L, (long)latestOffset.offset());
    }

    @Test
    public void testMaxTimestampOffset() {
        ListOffsetsResult.ListOffsetsResultInfo maxTimestampOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.MaxTimestampSpec());
        Assertions.assertEquals((long)1L, (long)maxTimestampOffset.offset());
    }

    private ListOffsetsResult.ListOffsetsResultInfo runFetchOffsets(Admin adminClient, OffsetSpec offsetSpec) {
        TopicPartition tp = new TopicPartition(this.topicName(), 0);
        return (ListOffsetsResult.ListOffsetsResultInfo)((java.util.Map)adminClient.listOffsets(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetSpec)}))).asJava(), new ListOffsetsOptions()).all().get()).get(tp);
    }

    public void produceMessages() {
        .colon.colon records = new .colon.colon((Object)new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(100L), null, (Object)new byte[10000]), (List)new .colon.colon((Object)new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(999L), null, (Object)new byte[10000]), (List)new .colon.colon((Object)new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(200L), null, (Object)new byte[10000]), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.produceMessages(this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, -1);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    public ListOffsetsIntegrationTest() {
        this.topicName = "foo";
    }
}

