/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import kafka.admin.LogDirsCommand$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a2A\u0001B\u0003\u0001\u0015!)\u0011\u0003\u0001C\u0001%!)Q\u0003\u0001C\u0001-!)Q\u0005\u0001C\u0001M\t\u0011Bj\\4ESJ\u001c8i\\7nC:$G+Z:u\u0015\t1q!A\u0003bI6LgNC\u0001\t\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0006\u0011\u00051yQ\"A\u0007\u000b\u000599\u0011aC5oi\u0016<'/\u0019;j_:L!\u0001E\u0007\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"A\u0003\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012a\u0006\t\u00041uyR\"A\r\u000b\u0005iY\u0012AC2pY2,7\r^5p]*\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f3\t\u00191+Z9\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t:\u0011AB:feZ,'/\u0003\u0002%C\tY1*\u00194lC\u000e{gNZ5h\u0003e\u0019\u0007.Z2l\u0019><G)\u001b:t\u0007>lW.\u00198e\u001fV$\b/\u001e;\u0015\u0003\u001d\u0002\"\u0001K\u0015\u000e\u0003mI!AK\u000e\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u00071\u0002\"!\f\u001c\u000e\u00039R!a\f\u0019\u0002\u0007\u0005\u0004\u0018N\u0003\u00022e\u00059!.\u001e9ji\u0016\u0014(BA\u001a5\u0003\u0015QWO\\5u\u0015\u0005)\u0014aA8sO&\u0011qG\f\u0002\u0005)\u0016\u001cH\u000f")
public class LogDirsCommandTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    @Test
    public void checkLogDirsCommandOutput() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)byteArrayOutputStream, false, StandardCharsets.UTF_8.name());
        LogDirsCommand$.MODULE$.describe(new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--broker-list", "0", "--describe"}, printStream);
        String existingBrokersContent = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        Iterator existingBrokersLineIter = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])existingBrokersContent.split("\n")));
        Assertions.assertTrue((boolean)existingBrokersLineIter.hasNext());
        Assertions.assertTrue((boolean)((String)existingBrokersLineIter.next()).contains("Querying brokers for log directories information"));
        byteArrayOutputStream.reset();
        LogDirsCommand$.MODULE$.describe(new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--broker-list", "0,1,2", "--describe"}, printStream);
        String nonExistingBrokersContent = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        Iterator nonExistingBrokersLineIter = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])nonExistingBrokersContent.split("\n")));
        Assertions.assertTrue((boolean)nonExistingBrokersLineIter.hasNext());
        Assertions.assertTrue((boolean)((String)nonExistingBrokersLineIter.next()).contains("ERROR: The given brokers do not exist from --broker-list: 1,2. Current existent brokers: 0"));
        byteArrayOutputStream.reset();
        LogDirsCommand$.MODULE$.describe(new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--broker-list", "0,0,1,2,2", "--describe"}, printStream);
        String duplicateBrokersContent = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        Iterator duplicateBrokersLineIter = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])duplicateBrokersContent.split("\n")));
        Assertions.assertTrue((boolean)duplicateBrokersLineIter.hasNext());
        Assertions.assertTrue((boolean)((String)duplicateBrokersLineIter.next()).contains("ERROR: The given brokers do not exist from --broker-list: 1,2. Current existent brokers: 0"));
        byteArrayOutputStream.reset();
        LogDirsCommand$.MODULE$.describe(new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--describe"}, printStream);
        String allBrokersContent = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        Iterator allBrokersLineIter = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])allBrokersContent.split("\n")));
        Assertions.assertTrue((boolean)allBrokersLineIter.hasNext());
        Assertions.assertTrue((boolean)((String)allBrokersLineIter.next()).contains("Querying brokers for log directories information"));
    }
}

