/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005h\u0001B A\u0001\u0015CQA\u0016\u0001\u0005\u0002]CQ!\u0017\u0001\u0005BiCq!\u001b\u0001C\u0002\u0013%!\u000e\u0003\u0004p\u0001\u0001\u0006Ia\u001b\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0011\u0019)\b\u0001)A\u0005e\"Ia\u000f\u0001a\u0001\u0002\u0004%Ia\u001e\u0005\f\u0003\u001b\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0001\u0003\u0006\u0002\u001c\u0001\u0001\r\u0011!Q!\naD1\"!\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002 !Y\u0011\u0011\b\u0001A\u0002\u0003\u0007I\u0011BA\u001e\u0011-\ty\u0004\u0001a\u0001\u0002\u0003\u0006K!!\t\t\u0017\u0005\u0005\u0003\u00011AA\u0002\u0013%\u00111\t\u0005\f\u0003+\u0002\u0001\u0019!a\u0001\n\u0013\t9\u0006C\u0006\u0002\\\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0003\u0002CA/\u0001\u0001&I!a\u0018\t\u0011\u0005-\u0004\u0001)C\u0005\u0003[B\u0011\"a\u001e\u0001#\u0003%I!!\u001f\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0012\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003k\u0004A\u0011AA|\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007AqA!\u0004\u0001\t\u0003\u0011y\u0001C\u0004\u0003\u001a\u0001!\tAa\u0007\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(!9!\u0011\u0007\u0001\u0005\u0002\tM\u0002b\u0002B\u001f\u0001\u0011\u0005!q\b\u0005\b\u0005\u0013\u0002A\u0011\u0001B&\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005/BqA!\u0019\u0001\t\u0003\u0011\u0019\u0007C\u0004\u0003n\u0001!\tAa\u001c\t\u000f\te\u0004\u0001\"\u0001\u0003|!9!Q\u0011\u0001\u0005\u0002\t\u001d\u0005b\u0002BI\u0001\u0011\u0005!1\u0013\u0005\b\u0005;\u0003A\u0011\u0001BP\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005WCqA!.\u0001\t\u0003\u00119\fC\u0004\u0003B\u0002!\tAa1\t\u000f\t5\u0007\u0001\"\u0001\u0003P\"9!\u0011\u001c\u0001\u0005\u0002\tm\u0007b\u0002Bs\u0001\u0011\u0005!q\u001d\u0005\b\u0005c\u0004A\u0011\u0001Bz\u0011\u001d\u0011i\u0010\u0001C\u0001\u0005\u007fDqa!\u0003\u0001\t\u0003\u0019Y\u0001C\u0004\u0004\u0016\u0001!\taa\u0006\t\u000f\r\u0005\u0002\u0001\"\u0001\u0004$!91Q\u0006\u0001\u0005\u0002\r=\u0002bBB\u001d\u0001\u0011\u000511\b\u0005\b\u0007\u000b\u0002A\u0011AB$\u0011\u001d\u0019\t\u0006\u0001C\u0001\u0007'Bqa!\u0018\u0001\t\u0003\u0019y\u0006C\u0004\u0004j\u0001!\taa\u001b\t\u000f\rU\u0004\u0001\"\u0001\u0004x!91\u0011\u0011\u0001\u0005\u0002\r\r\u0005bBBG\u0001\u0011\u00051q\u0012\u0005\b\u00073\u0003A\u0011ABN\u0011\u001d\u0019)\u000b\u0001C\u0001\u0007OCqa!-\u0001\t\u0003\u0019\u0019\fC\u0004\u0004>\u0002!\taa0\t\u000f\r%\u0007\u0001\"\u0001\u0004L\"91Q\u001b\u0001\u0005\u0002\r]'a\u0007+pa&\u001c7i\\7nC:$\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002B\u0005\u0006)\u0011\rZ7j]*\t1)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u00011EJ\u0015\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\n\u000b1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u00111\n\u0013\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tgB\u0011Q\nU\u0007\u0002\u001d*\u0011qJQ\u0001\u0006kRLGn]\u0005\u0003#:\u0013q\u0001T8hO&tw\r\u0005\u0002T)6\t\u0001)\u0003\u0002V\u0001\ni!+Y2l\u0003^\f'/\u001a+fgR\fa\u0001P5oSRtD#\u0001-\u0011\u0005M\u0003\u0011aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003m\u00032\u0001X1d\u001b\u0005i&B\u00010`\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002A\u0006)1oY1mC&\u0011!-\u0018\u0002\u0004'\u0016\f\bC\u00013h\u001b\u0005)'B\u00014C\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001.\u001a\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002WB\u0011A.\\\u0007\u0002?&\u0011an\u0018\u0002\u0004\u0013:$\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0019I\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|gNR1di>\u0014X#\u0001:\u0011\u00051\u001c\u0018B\u0001;`\u0005\u0015\u0019\u0006n\u001c:u\u0003e!WMZ1vYR\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0011\u0002\u0019Q|\u0007/[2TKJ4\u0018nY3\u0016\u0003a\u00042!_A\u0004\u001d\rQ\u00181\u0001\b\u0004w\u0006\u0005aB\u0001?\u0000\u001b\u0005i(B\u0001@E\u0003\u0019a$o\\8u}%\t1)\u0003\u0002B\u0005&\u0019\u0011Q\u0001!\u0002\u0019Q{\u0007/[2D_6l\u0017M\u001c3\n\t\u0005%\u00111\u0002\u0002\r)>\u0004\u0018nY*feZL7-\u001a\u0006\u0004\u0003\u000b\u0001\u0015\u0001\u0005;pa&\u001c7+\u001a:wS\u000e,w\fJ3r)\u0011\t\t\"a\u0006\u0011\u00071\f\u0019\"C\u0002\u0002\u0016}\u0013A!\u00168ji\"A\u0011\u0011\u0004\u0005\u0002\u0002\u0003\u0007\u00010A\u0002yIE\nQ\u0002^8qS\u000e\u001cVM\u001d<jG\u0016\u0004\u0013aC1e[&t7\t\\5f]R,\"!!\t\u0011\t\u0005\r\u0012QG\u0007\u0003\u0003KQ1!QA\u0014\u0015\u0011\tI#a\u000b\u0002\u000f\rd\u0017.\u001a8ug*\u00191)!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0007CB\f7\r[3\u000b\u0005\u0005M\u0012aA8sO&!\u0011qGA\u0013\u0005\u0015\tE-\\5o\u0003=\tG-\\5o\u00072LWM\u001c;`I\u0015\fH\u0003BA\t\u0003{A\u0011\"!\u0007\f\u0003\u0003\u0005\r!!\t\u0002\u0019\u0005$W.\u001b8DY&,g\u000e\u001e\u0011\u0002\u001bQ,7\u000f\u001e+pa&\u001cg*Y7f+\t\t)\u0005\u0005\u0003\u0002H\u0005=c\u0002BA%\u0003\u0017\u0002\"\u0001`0\n\u0007\u00055s,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\n\u0019F\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001bz\u0016!\u0005;fgR$v\u000e]5d\u001d\u0006lWm\u0018\u0013fcR!\u0011\u0011CA-\u0011%\tIBDA\u0001\u0002\u0004\t)%\u0001\buKN$Hk\u001c9jG:\u000bW.\u001a\u0011\u0002%\r\u0014X-\u0019;f\u0003:$w+Y5u)>\u0004\u0018n\u0019\u000b\u0005\u0003#\t\t\u0007C\u0004\u0002dA\u0001\r!!\u001a\u0002\t=\u0004Ho\u001d\t\u0004s\u0006\u001d\u0014\u0002BA5\u0003\u0017\u00111\u0003V8qS\u000e\u001cu.\\7b]\u0012|\u0005\u000f^5p]N\f1c^1ji\u001a{'\u000fV8qS\u000e\u001c%/Z1uK\u0012$b!!\u0005\u0002p\u0005M\u0004bBA9#\u0001\u0007\u0011QI\u0001\ni>\u0004\u0018n\u0019(b[\u0016D\u0001\"!\u001e\u0012!\u0003\u0005\ra[\u0001\bi&lWm\\;u\u0003u9\u0018-\u001b;G_J$v\u000e]5d\u0007J,\u0017\r^3eI\u0011,g-Y;mi\u0012\u0012TCAA>U\rY\u0017QP\u0016\u0003\u0003\u007f\u0002B!!!\u0002\f6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011R0\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u000e\u0006\r%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)1/\u001a;VaR!\u0011\u0011CAJ\u0011\u001d\t)j\u0005a\u0001\u0003/\u000bA!\u001b8g_B!\u0011\u0011TAT\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015aA1qS*!\u0011\u0011UAR\u0003\u001dQW\u000f]5uKJTA!!*\u00022\u0005)!.\u001e8ji&!\u0011\u0011VAN\u0005!!Vm\u001d;J]\u001a|\u0007fA\n\u0002.B!\u0011\u0011TAX\u0013\u0011\t\t,a'\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0003dY>\u001cX\r\u0006\u0002\u0002\u0012!\u001aA#!/\u0011\t\u0005e\u00151X\u0005\u0005\u0003{\u000bYJA\u0005BMR,'/R1dQ\u0006QA/Z:u\u0007J,\u0017\r^3\u0015\t\u0005E\u00111\u0019\u0005\b\u0003\u000b,\u0002\u0019AA#\u0003\u0019\tXo\u001c:v[\":Q#!3\u0002Z\u0006m\u0007\u0003BAf\u0003+l!!!4\u000b\t\u0005=\u0017\u0011[\u0001\taJ|g/\u001b3fe*!\u00111[AP\u0003\u0019\u0001\u0018M]1ng&!\u0011q[Ag\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u0011Q\\AqC\t\ty.\u0001\u0002{W\u0006\u0012\u00111]\u0001\u0006WJ\fg\r\u001e\u0015\b+\u0005\u001d\u0018q^Ay!\u0011\tI/a;\u000e\u0005\u0005E\u0017\u0002BAw\u0003#\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u0005M\u0018\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u00061B/Z:u\u0007J,\u0017\r^3XSRDG)\u001a4bk2$8\u000f\u0006\u0003\u0002\u0012\u0005e\bbBAc-\u0001\u0007\u0011Q\t\u0015\b-\u0005%\u0017\u0011\\A\u007fY\u0011\ti.!9)\u000fY\t9/a<\u0002r\u0006\u0001C/Z:u\u0007J,\u0017\r^3XSRDG)\u001a4bk2$(+\u001a9mS\u000e\fG/[8o)\u0011\t\tB!\u0002\t\u000f\u0005\u0015w\u00031\u0001\u0002F!:q#!3\u0002Z\n%A\u0006BAo\u0003CDsaFAt\u0003_\f\t0A\u0010uKN$8I]3bi\u0016<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;QCJ$\u0018\u000e^5p]N$B!!\u0005\u0003\u0012!9\u0011Q\u0019\rA\u0002\u0005\u0015\u0003f\u0002\r\u0002J\u0006e'Q\u0003\u0017\u0005\u0003;\f\t\u000fK\u0004\u0019\u0003O\fy/!=\u0002+Q,7\u000f^\"sK\u0006$XmV5uQ\u000e{gNZ5hgR!\u0011\u0011\u0003B\u000f\u0011\u001d\t)-\u0007a\u0001\u0003\u000bBs!GAe\u00033\u0014\t\u0003\f\u0003\u0002^\u0006\u0005\bfB\r\u0002h\u0006=\u0018\u0011_\u0001\u001ci\u0016\u001cHo\u0011:fCR,w\u000b[3o\u00032\u0014X-\u00193z\u000bbL7\u000f^:\u0015\t\u0005E!\u0011\u0006\u0005\b\u0003\u000bT\u0002\u0019AA#Q\u001dQ\u0012\u0011ZAm\u0005[aC!!8\u0002b\":!$a:\u0002p\u0006E\u0018A\u000b;fgR\u001c%/Z1uK^CWM\\!me\u0016\fG-_#ySN$8oV5uQ&3gj\u001c;Fq&\u001cHo\u001d\u000b\u0005\u0003#\u0011)\u0004C\u0004\u0002Fn\u0001\r!!\u0012)\u000fm\tI-!7\u0003:1\"\u0011Q\\AqQ\u001dY\u0012q]Ax\u0003c\fq\u0004^3ti\u000e\u0013X-\u0019;f/&$\bNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u0011\t\tB!\u0011\t\u000f\u0005\u0015G\u00041\u0001\u0002F!:A$!3\u0002Z\n\u0015C\u0006BAo\u0003CDs\u0001HAt\u0003_\f\t0\u0001\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]Z\fG.\u001b3SKBd\u0017nY1uS>tg)Y2u_J$B!!\u0005\u0003N!9\u0011QY\u000fA\u0002\u0005\u0015\u0003fB\u000f\u0002J\u0006e'\u0011\u000b\u0017\u0005\u0003;\f\t\u000fK\u0004\u001e\u0003O\fy/!=\u0002OQ,7\u000f^\"sK\u0006$XmV5uQ:+w-\u0019;jm\u0016\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u000b\u0005\u0003#\u0011I\u0006C\u0004\u0002Fz\u0001\r!!\u0012)\u000fy\tI-!7\u0003^1\"\u0011Q\\AqQ\u001dq\u0012q]Ax\u0003c\fA\u0005^3ti\u000e\u0013X-\u0019;f/&$\bNT3hCRLg/\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u000b\u0005\u0003#\u0011)\u0007C\u0004\u0002F~\u0001\r!!\u0012)\u000f}\tI-!7\u0003j1\"\u0011Q\\AqQ\u001dy\u0012q]Ax\u0003c\f1\u0004^3ti&sg/\u00197jIR{\u0007/[2MKZ,GnQ8oM&<G\u0003BA\t\u0005cBq!!2!\u0001\u0004\t)\u0005K\u0004!\u0003\u0013\fIN!\u001e-\t\u0005u\u0017\u0011\u001d\u0015\bA\u0005\u001d\u0018q^Ay\u00039!Xm\u001d;MSN$Hk\u001c9jGN$B!!\u0005\u0003~!9\u0011QY\u0011A\u0002\u0005\u0015\u0003fB\u0011\u0002J\u0006e'\u0011\u0011\u0017\u0005\u0003;\f\t\u000fK\u0004\"\u0003O\fy/!=\u0002;Q,7\u000f\u001e'jgR$v\u000e]5dg^KG\u000f[%oG2,H-\u001a'jgR$B!!\u0005\u0003\n\"9\u0011Q\u0019\u0012A\u0002\u0005\u0015\u0003f\u0002\u0012\u0002J\u0006e'Q\u0012\u0017\u0005\u0003;\f\t\u000fK\u0004#\u0003O\fy/!=\u0002CQ,7\u000f\u001e'jgR$v\u000e]5dg^KG\u000f[#yG2,H-Z%oi\u0016\u0014h.\u00197\u0015\t\u0005E!Q\u0013\u0005\b\u0003\u000b\u001c\u0003\u0019AA#Q\u001d\u0019\u0013\u0011ZAm\u00053cC!!8\u0002b\":1%a:\u0002p\u0006E\u0018a\u0006;fgR\fE\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u)\u0011\t\tB!)\t\u000f\u0005\u0015G\u00051\u0001\u0002F!:A%!3\u0002Z\n\u0015F\u0006BAo\u0003CDs\u0001JAt\u0003_\f\t0A\nuKN$\u0018\t\u001c;fe\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0003\u0002\u0012\t5\u0006bBAcK\u0001\u0007\u0011Q\t\u0015\bK\u0005%\u0017\u0011\u001cBYY\u0011\ti.!9)\u000f\u0015\n9/a<\u0002r\u0006\u0019D/Z:u\u00032$XM]!tg&<g.\\3oi^KG\u000f['pe\u0016\f5o]5h]6,g\u000e\u001e+iC:\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003#\u0011I\fC\u0004\u0002F\u001a\u0002\r!!\u0012)\u000f\u0019\nI-!7\u0003>2\"\u0011Q\\AqQ\u001d1\u0013q]Ax\u0003c\f1\u0007^3ti\u0006cG/\u001a:BgNLwM\\7f]R<\u0016\u000e\u001e5N_J,\u0007+\u0019:uSRLwN\\:UQ\u0006t\u0017i]:jO:lWM\u001c;\u0015\t\u0005E!Q\u0019\u0005\b\u0003\u000b<\u0003\u0019AA#Q\u001d9\u0013\u0011ZAm\u0005\u0013dC!!8\u0002b\":q%a:\u0002p\u0006E\u0018A\t;fgR\fE\u000e^3s/&$\b.\u00138wC2LG\rU1si&$\u0018n\u001c8D_VtG\u000f\u0006\u0003\u0002\u0012\tE\u0007bBAcQ\u0001\u0007\u0011Q\t\u0015\bQ\u0005%\u0017\u0011\u001cBkY\u0011\ti.!9)\u000f!\n9/a<\u0002r\u0006iB/Z:u\u00032$XM],iK:$v\u000e]5d\t>,7O\u001c;Fq&\u001cH\u000f\u0006\u0003\u0002\u0012\tu\u0007bBAcS\u0001\u0007\u0011Q\t\u0015\bS\u0005%\u0017\u0011\u001cBqY\u0011\ti.!9)\u000f%\n9/a<\u0002r\u0006IC/Z:u\u00032$XM],iK:$v\u000e]5d\t>,7O\u001c;Fq&\u001cHoV5uQ&3W\t_5tiN$B!!\u0005\u0003j\"9\u0011Q\u0019\u0016A\u0002\u0005\u0015\u0003f\u0002\u0016\u0002J\u0006e'Q\u001e\u0017\u0005\u0003;\f\t\u000fK\u0004+\u0003O\fy/!=\u0002CQ,7\u000f^\"sK\u0006$X-\u00117uKJ$v\u000e]5d/&$\bNU1dW\u0006;\u0018M]3\u0015\t\u0005E!Q\u001f\u0005\b\u0003\u000b\\\u0003\u0019AA#Q\u001dY\u0013\u0011ZAm\u0005sdC!!8\u0002b\":1&a:\u0002p\u0006E\u0018a\f;fgR\u001cuN\u001c4jOB\u0013Xm]3sm\u0006$\u0018n\u001c8BGJ|7o\u001d)beRLG/[8o\u00032$XM]1uS>tG\u0003BA\t\u0007\u0003Aq!!2-\u0001\u0004\t)\u0005K\u0004-\u0003\u0013\fIn!\u0002-\t\u0005u\u0017\u0011\u001d\u0015\bY\u0005\u001d\u0018q^Ay\u0003E!Xm\u001d;U_BL7\rR3mKRLwN\u001c\u000b\u0005\u0003#\u0019i\u0001C\u0004\u0002F6\u0002\r!!\u0012)\u000f5\nI-!7\u0004\u00121\"\u0011Q\\AqQ\u001di\u0013q]Ax\u0003c\f\u0001\u0007^3tiR{\u0007/[2XSRD7i\u001c7mS\u0012LgnZ\"iCJ$U\r\\3uS>t\u0017I\u001c3De\u0016\fG/Z!hC&tG\u0003BA\t\u00073Aq!!2/\u0001\u0004\t)\u0005K\u0004/\u0003\u0013\fIn!\b-\t\u0005u\u0017\u0011\u001d\u0015\b]\u0005\u001d\u0018q^Ay\u0003]!Xm\u001d;EK2,G/Z%oi\u0016\u0014h.\u00197U_BL7\r\u0006\u0003\u0002\u0012\r\u0015\u0002bBAc_\u0001\u0007\u0011Q\t\u0015\b_\u0005%\u0017\u0011\\B\u0015Y\u0011\ti.!9)\u000f=\n9/a<\u0002r\u0006qB/Z:u\t\u0016dW\r^3XQ\u0016tGk\u001c9jG\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u000b\u0005\u0003#\u0019\t\u0004C\u0004\u0002FB\u0002\r!!\u0012)\u000fA\nI-!7\u000461\"\u0011Q\\AqQ\u001d\u0001\u0014q]Ax\u0003c\f!\u0006^3ti\u0012+G.\u001a;f/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;XSRD\u0017JZ#ySN$8\u000f\u0006\u0003\u0002\u0012\ru\u0002bBAcc\u0001\u0007\u0011Q\t\u0015\bc\u0005%\u0017\u0011\\B!Y\u0011\ti.!9)\u000fE\n9/a<\u0002r\u0006aA/Z:u\t\u0016\u001c8M]5cKR!\u0011\u0011CB%\u0011\u001d\t)M\ra\u0001\u0003\u000bBsAMAe\u00033\u001ci\u0005\f\u0003\u0002^\u0006\u0005\bf\u0002\u001a\u0002h\u0006=\u0018\u0011_\u0001!i\u0016\u001cH\u000fR3tGJL'-Z,iK:$v\u000e]5d\t>,7O\u001c;Fq&\u001cH\u000f\u0006\u0003\u0002\u0012\rU\u0003bBAcg\u0001\u0007\u0011Q\t\u0015\bg\u0005%\u0017\u0011\\B-Y\u0011\ti.!9)\u000fM\n9/a<\u0002r\u0006aC/Z:u\t\u0016\u001c8M]5cK^CWM\u001c+pa&\u001cGi\\3t]R,\u00050[:u/&$\b.\u00134Fq&\u001cHo\u001d\u000b\u0005\u0003#\u0019\t\u0007C\u0004\u0002FR\u0002\r!!\u0012)\u000fQ\nI-!7\u0004f1\"\u0011Q\\AqQ\u001d!\u0014q]Ax\u0003c\f\u0011\u0005^3ti\u0012+7o\u0019:jE\u0016,f.\u0019<bS2\f'\r\\3QCJ$\u0018\u000e^5p]N$B!!\u0005\u0004n!9\u0011QY\u001bA\u0002\u0005\u0015\u0003fB\u001b\u0002J\u0006e7\u0011\u000f\u0017\u0005\u0003;\f\t\u000fK\u00046\u0003O\fy/!=\u0002KQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u0012,'OU3qY&\u001c\u0017\r^3e!\u0006\u0014H/\u001b;j_:\u001cH\u0003BA\t\u0007sBq!!27\u0001\u0004\t)\u0005K\u00047\u0003\u0013\fIn! -\t\u0005u\u0017\u0011\u001d\u0015\bm\u0005\u001d\u0018q^Ay\u0003\u0005\"Xm\u001d;EKN\u001c'/\u001b2f+:$WM]'j]&\u001b(\u000fU1si&$\u0018n\u001c8t)\u0011\t\tb!\"\t\u000f\u0005\u0015w\u00071\u0001\u0002F!:q'!3\u0002Z\u000e%E\u0006BAo\u0003CDsaNAt\u0003_\f\t0A!uKN$H)Z:de&\u0014W-\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a)beRLG/[8og^CWM\u001c*fCN\u001c\u0018n\u001a8nK:$\u0018j]%o!J|wM]3tgR!\u0011\u0011CBI\u0011\u001d\t)\r\u000fa\u0001\u0003\u000bBs\u0001OAe\u00033\u001c)\n\f\u0003\u0002^\u0006\u0005\bf\u0002\u001d\u0002h\u0006=\u0018\u0011_\u0001\u001fi\u0016\u001cH\u000fR3tGJL'-Z!u\u001b&t\u0017j\u001d:QCJ$\u0018\u000e^5p]N$B!!\u0005\u0004\u001e\"9\u0011QY\u001dA\u0002\u0005\u0015\u0003fB\u001d\u0002J\u0006e7\u0011\u0015\u0017\u0005\u0003;\f\t\u000fK\u0004:\u0003O\fy/!=\u0002MQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u0012,'/T5o\u0013N\u0014\b+\u0019:uSRLwN\\:NSb,G\r\u0006\u0003\u0002\u0012\r%\u0006bBAcu\u0001\u0007\u0011Q\t\u0015\bu\u0005%\u0017\u0011\\BWY\u0011\ti.!9)\u000fi\n9/a<\u0002r\u0006\u0019C/Z:u\t\u0016\u001c8M]5cKJ+\u0007o\u001c:u\u001fZ,'O]5eI\u0016t7i\u001c8gS\u001e\u001cH\u0003BA\t\u0007kCq!!2<\u0001\u0004\t)\u0005K\u0004<\u0003\u0013\fIn!/-\t\u0005u\u0017\u0011\u001d\u0015\bw\u0005\u001d\u0018q^Ay\u00039\"Xm\u001d;EKN\u001c'/\u001b2f\u0003:$G*[:u)>\u0004\u0018nY:XSRDw.\u001e;J]R,'O\\1m)>\u0004\u0018nY:\u0015\t\u0005E1\u0011\u0019\u0005\b\u0003\u000bd\u0004\u0019AA#Q\u001da\u0014\u0011ZAm\u0007\u000bdC!!8\u0002b\":A(a:\u0002p\u0006E\u0018\u0001\u0010;fgR$Um]2sS\n,Gi\\3t\u001d>$h)Y5m/\",g\u000eT5ti&twMU3bgNLwM\\7f]RL5/\u00168bkRDwN]5{K\u0012$B!!\u0005\u0004N\"9\u0011QY\u001fA\u0002\u0005\u0015\u0003fB\u001f\u0002J\u0006e7\u0011\u001b\u0017\u0005\u0003;\f\t\u000fK\u0004>\u0003O\fy/!=\u0002AQ,7\u000f^\"sK\u0006$XmV5uQR{\u0007/[2OC6,7i\u001c7mSNLwN\u001c\u000b\u0005\u0003#\u0019I\u000eC\u0004\u0002Fz\u0002\r!!\u0012)\u000fy\nI-!7\u0004^2\"\u0011Q\\AqQ\u001dq\u0014q]Ax\u0003c\u0004")
public class TopicCommandIntegrationTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor = (short)1;
    private TopicCommand.TopicService topicService;
    private Admin adminClient;
    private String testTopicName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        String x$2 = this.zkConnectOrNull();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$6;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 1;
        boolean bl7 = false;
        int n2 = 0;
        boolean bl8 = false;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(6, x$2, bl, bl2, (Option<SecurityProtocol>)x$8, (Option<File>)x$9, (Option<Properties>)x$10, bl3, bl4, bl5, bl6, (Map<Object, String>)x$3, n, bl7, x$4, x$5, n2, bl8).map((Function1 & Serializable)props -> {
            props.put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "1");
            return KafkaConfig$.MODULE$.fromProps(props);
        });
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.TopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.TopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), 10000);
    }

    private void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), topicName, 0, timeout);
    }

    private int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        super.setUp(info);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.adminClient_$eq(Admin.create((Properties)props));
        Admin apply_adminClient = this.adminClient();
        Object var3_3 = null;
        this.topicService_$eq(new TopicCommand.TopicService(apply_adminClient));
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @AfterEach
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreate(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()}));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaults(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaultReplication(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "2"}));
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)2);
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaultPartitions(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"}));
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithConfigs(String quorum) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"}));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertEquals((int)1000, (Integer)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWhenAlreadyExists(String quorum) {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Assertions.assertThrows(TopicExistsException.class, () -> this.topicService().createTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWhenAlreadyExistsWithIfNotExists(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-not-exists"});
        this.createAndWaitTopic(createOpts);
        this.topicService().createTopic(createOpts);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithReplicaAssignment(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)3, (int)partitions.size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithInvalidReplicationFactor(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", Integer.toString(32768), "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithNegativeReplicationFactor(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithNegativePartitionCount(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidTopicLevelConfig(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"});
        Assertions.assertThrows(ConfigException.class, () -> this.topicService().createTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopics(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_2 = null;
        Object var3_3 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopicsWithIncludeList(String quorum) {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, (short)2), new NewTopic(topic2, 2, (short)2), new NewTopic(topic3, 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, 10000);
        this.waitForTopicCreated(topic2, 10000);
        this.waitForTopicCreated(topic3, 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "kafka.*"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_5 = null;
        Object var7_6 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(topic1));
        Assertions.assertTrue((boolean)output.contains(topic2));
        Assertions.assertFalse((boolean)output.contains(topic3));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopicsWithExcludeInternal(String quorum) {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, (short)2), new NewTopic("__consumer_offsets", 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var4_3 = null;
        Object var5_4 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(topic1));
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterPartitionCount(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"}));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testAlterPartitionCount$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignment(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"}));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testAlterAssignment$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get();
        Assertions.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignmentWithMoreAssignmentThanPartitions(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignmentWithMorePartitionsThanAssignment(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWithInvalidPartitionCount(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWhenTopicDoesntExist(String quorum) {
        TopicCommand.TopicService topicService;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1"});
        Admin apply_adminClient = this.adminClient();
        TopicCommand.TopicService topicService2 = topicService = new TopicCommand.TopicService(apply_adminClient);
        Object var4_3 = null;
        topicService = null;
        TopicCommand.TopicService topicService3 = topicService2;
        Assertions.assertThrows(IllegalArgumentException.class, () -> topicService3.alterTopic(alterOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"}));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateAlterTopicWithRackAware(String quorum) {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", Integer.toString(replicationFactor), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        scala.collection.immutable.Map assignment = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions()).asScala().map((Function1 & Serializable)info -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)info.partition())), CollectionConverters$.MODULE$.ListHasAsScala(info.replicas()).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(alteredNumPartitions), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testCreateAlterTopicWithRackAware$3(this, alteredNumPartitions)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        assignment = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions()).asScala().map((Function1 & Serializable)info -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)info.partition())), CollectionConverters$.MODULE$.ListHasAsScala(info.replicas()).asScala().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigPreservationAcrossPartitionAlteration(String quorum) {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        Config props = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertNotNull((Object)props.get(cleanupKey), (String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString());
        Assertions.assertEquals((Object)cleanupVal, (Object)props.get(cleanupKey).value(), (String)"Properties after creation have incorrect value");
        if (!this.isKRaftTest()) {
            this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        }
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsModified), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Config newProps = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertNotNull((Object)newProps.get(cleanupKey), (String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString());
        Assertions.assertEquals((Object)cleanupVal, (Object)newProps.get(cleanupKey).value(), (String)"Updated properties have incorrect value");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletion(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        if (!this.isKRaftTest()) {
            String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), this.testTopicName(), 1, this.brokers());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicWithCollidingCharDeletionAndCreateAgain(String quorum) {
        String topicWithCollidingChar = "test.a";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", topicWithCollidingChar});
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", topicWithCollidingChar});
        if (!this.isKRaftTest()) {
            String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(topicWithCollidingChar);
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topicWithCollidingChar, 1, this.brokers());
        Assertions.assertDoesNotThrow(() -> this.createAndWaitTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteInternalTopic(String quorum) {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"});
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", "__consumer_offsets"});
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        if (!this.isKRaftTest()) {
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deleteOffsetTopicPath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), "__consumer_offsets", 1, this.brokers());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWhenTopicDoesntExist(String quorum) {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().deleteTopic(deleteOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribe(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        Object[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)3, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(rows)));
        Assertions.assertTrue((boolean)((String)rows[0]).startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeWhenTopicDoesntExist(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnavailablePartitions(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            TopicDescription testTopicDescription = (TopicDescription)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).asScala().apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(testTopicDescription.partitions()).asScala().find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$1(x$13))).get()).partition();
            this.killBroker(0);
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$7(this));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var8_7 = null;
            Object var9_8 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderReplicatedPartitions(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                TestUtils$.MODULE$.waitForPartitionMetadata(this.aliveBrokers(), this.testTopicName(), 0, 15000L);
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_2 = null;
            Object var5_3 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(rows[0]).toString());
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderMinIsrPartitions(String quorum) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = 15000L;
                long l2 = 100L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$1(this)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                        Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$3(this));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var6_6 = null;
            Object var7_7 = null;
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress(String quorum) {
        String string;
        HashMap configMap = new HashMap();
        short replicationFactor = 1;
        int partitions = 1;
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), partitions, replicationFactor).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.testTopicName(), 10, -1);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.brokers().map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$18)));
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).allTopicNames().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(testTopicDesc.partitions()).asScala().head();
        Buffer replicasOfFirstPartition = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(firstPartition.replicas()).asScala().map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.id()));
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableOps)brokerIds.diff((Seq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(targetReplica)))))).all().get();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Reassignment didn't add the second node");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var16_14 = null;
        Object var17_15 = null;
        Object[] simpleDescribeOutputRows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
        Assertions.assertEquals((int)2, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(simpleDescribeOutputRows)));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out2.toString();
        Object var19_18 = null;
        Object var20_19 = null;
        string = null;
        String underReplicatedOutput = string2;
        Assertions.assertEquals((Object)"", (Object)underReplicatedOutput, (String)new StringBuilder(59).append("--under-replicated-partitions shouldn't return anything: '").append(underReplicatedOutput).append("'").toString());
        PartitionReassignment reassignments = (PartitionReassignment)((java.util.Map)this.adminClient().listPartitionReassignments(Collections.singleton(tp)).reassignments().get()).get(tp);
        Assertions.assertFalse((boolean)Option$.MODULE$.apply((Object)reassignments).forall((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(x$20))));
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), 100L);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeAtMinIsrPartitions(String quorum) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            this.killBroker(1);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = 15000L;
                long l2 = 100L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$1(this)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                        Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$3(this));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--at-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var7_6 = null;
            Object var8_7 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertEquals((int)1, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderMinIsrPartitionsMixed(String quorum) {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList(new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))))).all().get();
        this.waitForTopicCreated(underMinIsrTopic, 10000);
        this.waitForTopicCreated(notUnderMinIsrTopic, 10000);
        this.waitForTopicCreated(offlineTopic, 10000);
        this.waitForTopicCreated(fullyReplicatedTopic, 10000);
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = 15000L;
                long l2 = 100L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(this, underMinIsrTopic, offlineTopic)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                        Assertions.fail((String)"Timeout waiting for partition metadata propagating to brokers for underMinIsrTopic topic");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var11_10 = null;
            Object var12_11 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assertions.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assertions.assertEquals((int)2, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeReportOverriddenConfigs(String quorum) {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_3 = null;
        Object var4_4 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(config), (String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeAndListTopicsWithoutInternalTopics(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--describe", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(this.testTopicName()), (String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString());
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--list", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_6 = null;
        Object var7_7 = null;
        output = grabConsoleOutput_out2.toString();
        Assertions.assertTrue((boolean)output.contains(this.testTopicName()));
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeDoesNotFailWhenListingReassignmentIsUnauthorized(String quorum) {
        this.adminClient_$eq((Admin)Mockito.spy((Object)this.adminClient()));
        Admin apply_adminClient = this.adminClient();
        Object var6_2 = null;
        this.topicService_$eq(new TopicCommand.TopicService(apply_adminClient));
        ((Admin)Mockito.doReturn((Object)AdminClientTestUtils.listPartitionReassignmentsResult((Throwable)new ClusterAuthorizationException("Unauthorized")), (Object[])new Object[]{null}).when((Object)this.adminClient())).listPartitionReassignments(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.testTopicName(), 0)}))).asJava());
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_3 = null;
        Object var4_4 = null;
        Object[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)2, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(rows)));
        Assertions.assertTrue((boolean)((String)rows[0]).startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithTopicNameCollision(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic("foo_bar", 1, (short)6))).all().get();
        this.waitForTopicCreated("foo_bar", 10000);
        Assertions.assertThrows(InvalidTopicException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "foo.bar"})));
    }

    public static final /* synthetic */ boolean $anonfun$testAlterPartitionCount$2(TopicCommandIntegrationTest $this, KafkaBroker x$7) {
        return x$7.metadataCache().getTopicPartitions($this.testTopicName()).size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterPartitionCount$1(TopicCommandIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testAlterPartitionCount$2($this, x$7)));
    }

    public static final /* synthetic */ String $anonfun$testAlterPartitionCount$3() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAssignment$2(TopicCommandIntegrationTest $this, KafkaBroker x$8) {
        return x$8.metadataCache().getTopicPartitions($this.testTopicName()).size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAssignment$1(TopicCommandIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testAlterAssignment$2($this, x$8)));
    }

    public static final /* synthetic */ String $anonfun$testAlterAssignment$3() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAlterTopicWithRackAware$4(TopicCommandIntegrationTest $this, int alteredNumPartitions$1, KafkaBroker x$11) {
        return x$11.metadataCache().getTopicPartitions($this.testTopicName()).size() == alteredNumPartitions$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAlterTopicWithRackAware$3(TopicCommandIntegrationTest $this, int alteredNumPartitions$1) {
        return $this.brokers().forall((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testCreateAlterTopicWithRackAware$4($this, alteredNumPartitions$1, x$11)));
    }

    public static final /* synthetic */ String $anonfun$testCreateAlterTopicWithRackAware$5() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$13) {
        return x$13.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaBroker x$14) {
        return x$14.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandIntegrationTest $this, MetadataResponseData.MetadataResponseTopic x$15) {
        return x$15.name().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponseData.MetadataResponsePartition x$16) {
        return x$16.partitionIndex() == partitionOnBroker0$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandIntegrationTest $this, int partitionOnBroker0$1, boolean result, KafkaBroker server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        scala.collection.immutable.Set x$1;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)(x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()}))), x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponseData.MetadataResponseTopic)topicMetadatas.find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$15))).get()).partitions()).asScala().find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$16)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw new AssertionError((Object)"Partition metadata is not found in metadata cache");
        }
        if (!(testPartitionMetadata instanceof Some)) {
            throw new MatchError((Object)testPartitionMetadata);
        }
        MetadataResponseData.MetadataResponsePartition metadata = (MetadataResponseData.MetadataResponsePartition)((Some)testPartitionMetadata).value();
        boolean bl = result && metadata.errorCode() == Errors.LEADER_NOT_AVAILABLE.code();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandIntegrationTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)$this.brokers().filterNot((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$3(x$14)))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandIntegrationTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$2(TopicCommandIntegrationTest $this, KafkaBroker x$17) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$17.metadataCache().getPartitionInfo($this.testTopicName(), 0).get()).isr().size() == 5;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(TopicCommandIntegrationTest $this) {
        return $this.aliveBrokers().forall((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$2($this, x$17)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderMinIsrPartitions$3(TopicCommandIntegrationTest $this) {
        return new StringBuilder(72).append("Timeout waiting for partition metadata propagating to brokers for ").append($this.testTopicName()).append(" topic").toString();
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaBroker x$18) {
        return x$18.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandIntegrationTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(PartitionReassignment x$20) {
        return x$20.addingReplicas().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeAtMinIsrPartitions$2(TopicCommandIntegrationTest $this, KafkaBroker x$21) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$21.metadataCache().getPartitionInfo($this.testTopicName(), 0).get()).isr().size() == 4;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeAtMinIsrPartitions$1(TopicCommandIntegrationTest $this) {
        return $this.aliveBrokers().forall((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$2($this, x$21)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeAtMinIsrPartitions$3(TopicCommandIntegrationTest $this) {
        return new StringBuilder(72).append("Timeout waiting for partition metadata propagating to brokers for ").append($this.testTopicName()).append(" topic").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$2(String underMinIsrTopic$1, String offlineTopic$1, KafkaBroker broker) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)broker.metadataCache().getPartitionInfo(underMinIsrTopic$1, 0).get()).isr().size() < 6 && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)broker.metadataCache().getPartitionInfo(offlineTopic$1, 0).get()).leader() == -1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(TopicCommandIntegrationTest $this, String underMinIsrTopic$1, String offlineTopic$1) {
        return $this.aliveBrokers().forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$2(underMinIsrTopic$1, offlineTopic$1, broker)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderMinIsrPartitionsMixed$3() {
        return "Timeout waiting for partition metadata propagating to brokers for underMinIsrTopic topic";
    }

    public TopicCommandIntegrationTest() {
        this.numPartitions = 1;
    }
}

