/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.$less$colon$less$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\u0004\t\u0001=AQA\u0006\u0001\u0005\u0002]AQA\u0007\u0001\u0005\u0002mAQ\u0001\u000e\u0001\u0005\u0002UBQ\u0001\u001b\u0001\u0005\u0002%DQA\u001d\u0001\u0005\nMDQ!\u001e\u0001\u0005\nY\u0014!\u0004\u0015:pIV\u001cWM]%eg&sG/Z4sCRLwN\u001c+fgRT!!\u0003\u0006\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u00171\t1bY8pe\u0012Lg.\u0019;pe*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00021A\u0011\u0011\u0004A\u0007\u0002\u0011\u0005)1/\u001a;vaR\u0011Ad\b\t\u0003#uI!A\b\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006A\t\u0001\r!I\u0001\u000eG2,8\u000f^3s\u0007>tg-[4\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011b\u0011\u0001\u0002;fgRL!AJ\u0012\u0003\u001b\rcWo\u001d;fe\u000e{gNZ5hQ\t\u0011\u0001\u0006\u0005\u0002*e5\t!F\u0003\u0002,Y\u0005\u0019\u0011\r]5\u000b\u00055r\u0013a\u00026va&$XM\u001d\u0006\u0003_A\nQA[;oSRT\u0011!M\u0001\u0004_J<\u0017BA\u001a+\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0016i\u0016\u001cH/\u00168jcV,\u0007K]8ek\u000e,'/\u00133t)\tab\u0007C\u00038\u0007\u0001\u0007\u0001(A\bdYV\u001cH/\u001a:J]N$\u0018M\\2f!\t\u0011\u0013(\u0003\u0002;G\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW\r\u000b\u0003\u0004y\t\u001b\u0005CA\u001fA\u001b\u0005q$BA $\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0003z\u0012Ab\u00117vgR,'\u000fV3tiN\fQA^1mk\u0016d3\u0001R/bW\u001d)\u0005*\u0013(P!F\u0003\"!\u0010$\n\u0005\u001ds$aC\"mkN$XM\u001d+fgR\f1b\u00197vgR,'\u000fV=qK\u0012\n!*\u0003\u0002L\u0019\u0006\u0011!l\u0013\u0006\u0003\u001bz\nA\u0001V=qK\u00069!M]8lKJ\u001cX$A\u0002\u0002\u001f5,G/\u00193bi\u00064VM]:j_:$\u0013AU\u0005\u0003'R\u000b1\"\u0013\"Q?Jz\u0006hX%Wc)\u0011QKV\u0001\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]*\u0011q\u000bW\u0001\u0007G>lWn\u001c8\u000b\u0005eS\u0016AB:feZ,'O\u0003\u0002\u000e7*\u0011A\fM\u0001\u0007CB\f7\r[3,\u000f\u0015C\u0015JT(Q=\u0012\nq,\u0003\u0002a)\u0006Y\u0011J\u0011)`g}\u0003t,\u0013,1W\u001d)\u0005J\u0019(P!\u0016$\u0013aY\u0005\u0003I2\u000bQa\u0013*B\rR#\u0013AZ\u0005\u0003OR\u000b1\"\u0013\"Q?Nz6gX%Wa\u0005aB/Z:u+:L\u0017/^3Qe>$WoY3s\u0013\u0012\u001c()^7q\u0013\n\u0003FC\u0001\u000fk\u0011\u00159D\u00011\u00019Q!!Q\tS%O\u001f2l\u0017!C1vi>\u001cF/\u0019:uI\u0005q\u0017BA8q\u0003\tquJ\u0003\u0002r}\u0005I\u0011)\u001e;p'R\f'\u000f^\u0001\u0010m\u0016\u0014\u0018NZ=V]&\fX/Z%egR\u0011A\u0004\u001e\u0005\u0006o\u0015\u0001\r\u0001O\u0001\u000f]\u0016DH\u000f\u0015:pIV\u001cWM]%e)\u00119(0!\u0002\u0011\u0005EA\u0018BA=\u0013\u0005\u0011auN\\4\t\u000bm4\u0001\u0019\u0001?\u0002\r\t\u0014xn[3s!\ri\u0018\u0011A\u0007\u0002}*\u0011q\u0010D\u0001\b]\u0016$xo\u001c:l\u0013\r\t\u0019A \u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0005\b\u0003\u000f1\u0001\u0019AA\u0005\u0003!a\u0017n\u001d;f]\u0016\u0014\b\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007}\fyA\u0003\u0002X5&!\u00111CA\u0007\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7fQ\u0019\u0001\u0011q\u0003\"\u0002$A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e)\n\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\t\u0005\u0005\u00121\u0004\u0002\u000b\u000bb$XM\u001c3XSRDGFAA\u0013G\t\t9\u0003\u0005\u0003\u0002*\u00055RBAA\u0016\u0015\ty3%\u0003\u0003\u00020\u0005-\"!F\"mkN$XM\u001d+fgR,\u0005\u0010^3og&|gn\u001d")
public class ProducerIdsIntegrationTest {
    @BeforeEach
    public void setup(ClusterConfig clusterConfig) {
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), "1");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "3");
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_2_8_IV1), @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_0_IV0), @ClusterTest(clusterType=Type.KRAFT, brokers=3, metadataVersion=MetadataVersion.IBP_3_3_IV0)})
    public void testUniqueProducerIds(ClusterInstance clusterInstance) {
        this.verifyUniqueIds(clusterInstance);
    }

    @ClusterTest(clusterType=Type.ZK, brokers=3, autoStart=AutoStart.NO)
    public void testUniqueProducerIdsBumpIBP(ClusterInstance clusterInstance) {
        clusterInstance.config().serverProperties().put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
        clusterInstance.config().brokerServerProperties(0).put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "3.0-IV0");
        clusterInstance.start();
        this.verifyUniqueIds(clusterInstance);
        clusterInstance.stop();
    }

    private void verifyUniqueIds(ClusterInstance clusterInstance) {
        Seq ids = CollectionConverters$.MODULE$.ListHasAsScala(clusterInstance.brokerSocketServers().stream().flatMap(broker -> IntStream.range(0, 1001).parallel().mapToObj(x$1 -> BoxesRunTime.boxToLong((long)this.nextProducerId(broker, clusterInstance.clientListener())))).collect(Collectors.toList())).asScala().toSeq();
        Assertions.assertEquals((int)3003, (int)ids.size(), (String)"Expected exactly 3003 IDs");
        Assertions.assertEquals((int)ids.size(), (int)((SeqOps)ids.distinct()).size(), (String)"Found duplicate producer IDs");
    }

    private long nextProducerId(SocketServer broker, ListenerName listener) {
        InitProducerIdRequestData data = new InitProducerIdRequestData().setProducerEpoch((short)-1).setProducerId(-1L).setTransactionalId(null).setTransactionTimeoutMs(10);
        InitProducerIdRequest request = (InitProducerIdRequest)new InitProducerIdRequest.Builder(data).build();
        return ((InitProducerIdResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, broker, listener, ClassTag$.MODULE$.apply(InitProducerIdResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).data().producerId();
    }
}

