/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.ProducerState;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.errors.TransactionalIdNotFoundException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\u0010 \u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u0004:\u0001\u0001\u0006I!\r\u0005\bu\u0001\u0011\r\u0011\"\u00011\u0011\u0019Y\u0004\u0001)A\u0005c!9A\b\u0001b\u0001\n\u0003i\u0004B\u0002#\u0001A\u0003%a\bC\u0004F\u0001\t\u0007I\u0011A\u001f\t\r\u0019\u0003\u0001\u0015!\u0003?\u0011\u001d9\u0005A1A\u0005\u0002!Ca\u0001\u0016\u0001!\u0002\u0013I\u0005\"C+\u0001\u0001\u0004\u0005\r\u0011\"\u0001W\u0011%!\u0007\u00011AA\u0002\u0013\u0005Q\rC\u0005l\u0001\u0001\u0007\t\u0011)Q\u0005/\"IA\u000e\u0001a\u0001\u0002\u0004%\t!\u001c\u0005\ng\u0002\u0001\r\u00111A\u0005\u0002QD\u0011B\u001e\u0001A\u0002\u0003\u0005\u000b\u0015\u00028\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0003A\b\"\u0003@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0000\u0011)\t\u0019\u0001\u0001a\u0001\u0002\u0003\u0006K!\u001f\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!a\u0011\u0001\t\u0003\n)\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0006bBAa\u0001\u0011%\u0011Q\t\u0005\b\u0003\u0007\u0004A\u0011BA#\u0011\u001d\t)\r\u0001C\u0005\u0003\u000f\u0014!\u0004\u0016:b]N\f7\r^5p]N,\u0005\u0010]5sCRLwN\u001c+fgRT!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018NC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\n\u0013aC5oi\u0016<'/\u0019;j_:L!AK\u0014\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\u0010\u0002\rQ|\u0007/[22+\u0005\t\u0004C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011a\u0017M\\4\u000b\u0003Y\nAA[1wC&\u0011\u0001h\r\u0002\u0007'R\u0014\u0018N\\4\u0002\u000fQ|\u0007/[22A\u00051Ao\u001c9jGJ\nq\u0001^8qS\u000e\u0014\u0004%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002}A\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n\u0019\u0011J\u001c;\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0002%I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fI\u0001\u0004iB\u0004T#A%\u0011\u0005)\u0013V\"A&\u000b\u00051k\u0015AB2p[6|gN\u0003\u0002#\u001d*\u0011q\nU\u0001\u0007CB\f7\r[3\u000b\u0003E\u000b1a\u001c:h\u0013\t\u00196J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\tQ\u0004\b\u0007I\u0001\taJ|G-^2feV\tq\u000b\u0005\u0003Y9zsV\"A-\u000b\u0005US&BA.N\u0003\u001d\u0019G.[3oiNL!!X-\u0003\u001b-\u000bgm[1Qe>$WoY3s!\ryt,Y\u0005\u0003A\u0002\u0013Q!\u0011:sCf\u0004\"a\u00102\n\u0005\r\u0004%\u0001\u0002\"zi\u0016\fA\u0002\u001d:pIV\u001cWM]0%KF$\"AZ5\u0011\u0005}:\u0017B\u00015A\u0005\u0011)f.\u001b;\t\u000f)l\u0011\u0011!a\u0001/\u0006\u0019\u0001\u0010J\u0019\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013\u0001C2p]N,X.\u001a:\u0016\u00039\u0004Ba\\9_=6\t\u0001O\u0003\u0002m5&\u0011!\u000f\u001d\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0002\u0019\r|gn];nKJ|F%Z9\u0015\u0005\u0019,\bb\u00026\u0011\u0003\u0003\u0005\rA\\\u0001\nG>t7/^7fe\u0002\nQ!\u00193nS:,\u0012!\u001f\t\u0003url\u0011a\u001f\u0006\u0003ojK!!`>\u0003\u000b\u0005#W.\u001b8\u0002\u0013\u0005$W.\u001b8`I\u0015\fHc\u00014\u0002\u0002!9!nEA\u0001\u0002\u0004I\u0018AB1e[&t\u0007%A\bhK:,'/\u0019;f\u0007>tg-[4t+\t\tI\u0001\u0005\u0004\u0002\f\u0005E\u0011QC\u0007\u0003\u0003\u001bQ1!a\u0004A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\tiAA\u0002TKF\u0004B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037\t\u0013AB:feZ,'/\u0003\u0003\u0002 \u0005e!aC&bM.\f7i\u001c8gS\u001e\fQa]3u+B$2AZA\u0013\u0011\u001d\t9C\u0006a\u0001\u0003S\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003W\t9$\u0004\u0002\u0002.)\u0019\u0001%a\f\u000b\t\u0005E\u00121G\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t)\u0004U\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003s\tiC\u0001\u0005UKN$\u0018J\u001c4pQ\r1\u0012Q\b\t\u0005\u0003W\ty$\u0003\u0003\u0002B\u00055\"A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u0001gQ\r9\u0012\u0011\n\t\u0005\u0003W\tY%\u0003\u0003\u0002N\u00055\"!C!gi\u0016\u0014X)Y2i\u0003]\"Xm\u001d;Ck6\u0004HK]1og\u0006\u001cG/[8oC2,\u0005o\\2i\u0003\u001a$XM]%om\u0006d\u0017\u000e\u001a)s_\u0012,8-\u001a:JI6\u000b\u0007\u000f]5oOR\u0019a-a\u0015\t\u000f\u0005U\u0003\u00041\u0001\u0002X\u00051\u0011/^8sk6\u0004B!!\u0017\u0002h9!\u00111LA2!\r\ti\u0006Q\u0007\u0003\u0003?R1!!\u0019$\u0003\u0019a$o\\8u}%\u0019\u0011Q\r!\u0002\rA\u0013X\rZ3g\u0013\rA\u0014\u0011\u000e\u0006\u0004\u0003K\u0002\u0005f\u0002\r\u0002n\u0005u\u0014q\u0010\t\u0005\u0003_\nI(\u0004\u0002\u0002r)!\u00111OA;\u0003!\u0001(o\u001c<jI\u0016\u0014(\u0002BA<\u0003_\ta\u0001]1sC6\u001c\u0018\u0002BA>\u0003c\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH\u0006BAA\u0003\u000b\u000b#!a!\u0002\u0005i\\\u0017EAAD\u0003\u0015Y'/\u00194uQ\u001dA\u00121RAJ\u0003+\u0003B!!$\u0002\u00106\u0011\u0011QO\u0005\u0005\u0003#\u000b)HA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011qS\u0001\u0019w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBj\u0018!\n;fgR$&/\u00198tC\u000e$\u0018n\u001c8BMR,'\u000f\u0015:pIV\u001cWM]%e\u000bb\u0004\u0018N]3t)\r1\u0017Q\u0014\u0005\b\u0003+J\u0002\u0019AA,Q\u001dI\u0012QNA?\u0003CcC!!!\u0002\u0006\":\u0011$a#\u0002\u0014\u0006U\u0015!\u00049s_\u0012,8-\u001a:Ti\u0006$X-\u0006\u0002\u0002*B1\u00111VA[\u0003wsA!!,\u00022:!\u0011QLAX\u0013\u0005\t\u0015bAAZ\u0001\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\\\u0003s\u0013A\u0001T5ti*\u0019\u00111\u0017!\u0011\u0007i\fi,C\u0002\u0002@n\u0014Q\u0002\u0015:pIV\u001cWM]*uCR,\u0017AI<bSR,f\u000e^5m)J\fgn]1di&|g.\u00197Ti\u0006$X-\u0012=qSJ,7/A\u0011xC&$XK\u001c;jYR\u0013\u0018M\\:bGRLwN\\1m'R\fG/Z#ySN$8/A\u0006tKJ4XM\u001d)s_B\u001cHCAAe!\u0011\tY-!5\u000e\u0005\u00055'bAAhk\u0005!Q\u000f^5m\u0013\u0011\t\u0019.!4\u0003\u0015A\u0013x\u000e]3si&,7\u000f")
public class TransactionsExpirationTest
extends KafkaServerTestHarness {
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final int replicationFactor;
    private final TopicPartition tp0 = new TopicPartition(this.topic1(), 0);
    private KafkaProducer<byte[], byte[]> producer;
    private KafkaConsumer<byte[], byte[]> consumer;
    private Admin admin;

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$4 -> {
            Properties fromProps_overrides = this.serverProps();
            return KafkaConfig$.MODULE$.fromProps(x$4, fromProps_overrides, true);
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", this.brokers(), 16384, 60000L, 60000L, 120000, 30000, 5));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$4 = "group";
        String x$5 = "earliest";
        int x$6 = 500;
        SecurityProtocol x$7 = SecurityProtocol.PLAINTEXT;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        ByteArrayDeserializer x$10 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$4, x$5, false, true, x$6, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11));
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties()));
        this.createTopic(this.topic1(), this.numPartitions(), 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.topic2(), this.numPartitions(), 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        if (this.consumer() != null) {
            this.consumer().close();
        }
        if (this.admin() != null) {
            this.admin().close();
        }
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBumpTransactionalEpochAfterInvalidProducerIdMapping(String quorum) {
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "2", "2", false));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(0), "4", "4", false));
        this.producer().abortTransaction();
        this.waitUntilTransactionalStateExists();
        this.waitUntilTransactionalStateExpires();
        this.producer().beginTransaction();
        Future failedFuture = this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "1", "1", false));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!failedFuture.isDone()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Producer future never completed.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TestUtils.assertFutureThrows((Future)failedFuture, InvalidPidMappingException.class);
        this.producer().abortTransaction();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(2), "4", "4", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "1", "1", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "3", "3", true));
        this.producer().commitTransaction();
        this.waitUntilTransactionalStateExists();
        this.consumer().subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(this.consumer(), 4, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTransactionAfterProducerIdExpires(String quorum) {
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "2", "2", false));
        this.producer().flush();
        List<ProducerState> pState = this.producerState();
        Assertions.assertEquals((int)1, (int)pState.size());
        long oldProducerId = ((ProducerState)pState.apply(0)).producerId();
        this.producer().abortTransaction();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionsExpirationTest.$anonfun$testTransactionAfterProducerIdExpires$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Producer IDs for topic1 did not expire.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", this.brokers(), 16384, 60000L, 60000L, 120000, 30000, 5));
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "3", "3", true));
        this.producer().commitTransaction();
        List<ProducerState> pState2 = this.producerState();
        Assertions.assertEquals((int)1, (int)pState2.size());
        long newProducerId = ((ProducerState)pState2.apply(0)).producerId();
        Assertions.assertEquals((long)oldProducerId, (long)newProducerId);
        this.consumer().subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.consumeRecords(this.consumer(), 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    private List<ProducerState> producerState() {
        java.util.List activeProducers = ((DescribeProducersResult.PartitionProducerState)this.admin().describeProducers(Collections.singletonList(this.tp0())).partitionResult(this.tp0()).get()).activeProducers();
        return CollectionConverters$.MODULE$.ListHasAsScala(activeProducers).asScala().toList();
    }

    private void waitUntilTransactionalStateExpires() {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionsExpirationTest.$anonfun$waitUntilTransactionalStateExpires$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Transaction state never expired.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilTransactionalStateExists() {
        KafkaFuture describeState = this.admin().describeTransactions(Collections.singletonList("transactionalProducer")).description("transactionalProducer");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!describeState.isDone()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Transactional state was never added.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Properties serverProps() {
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(3));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        serverProps.put(KafkaConfig$.MODULE$.TransactionalIdExpirationMsProp(), "1000");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsRemoveExpiredTransactionalIdCleanupIntervalMsProp(), "500");
        serverProps.put(KafkaConfig$.MODULE$.ProducerIdExpirationMsProp(), "500");
        serverProps.put(KafkaConfig$.MODULE$.ProducerIdExpirationCheckIntervalMsProp(), "500");
        return serverProps;
    }

    public static final /* synthetic */ boolean $anonfun$testBumpTransactionalEpochAfterInvalidProducerIdMapping$1(Future failedFuture$1) {
        return failedFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testBumpTransactionalEpochAfterInvalidProducerIdMapping$2() {
        return "Producer future never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionAfterProducerIdExpires$1(TransactionsExpirationTest $this) {
        return $this.producerState().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTransactionAfterProducerIdExpires$2() {
        return "Producer IDs for topic1 did not expire.";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilTransactionalStateExpires$1(TransactionsExpirationTest $this) {
        boolean removedTransactionState = false;
        try {
            $this.admin().describeTransactions(Collections.singletonList("transactionalProducer")).description("transactionalProducer").get();
        }
        catch (Exception exception) {
            removedTransactionState = exception.getCause() instanceof TransactionalIdNotFoundException;
        }
        return removedTransactionState;
    }

    public static final /* synthetic */ String $anonfun$waitUntilTransactionalStateExpires$2() {
        return "Transaction state never expired.";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilTransactionalStateExists$1(KafkaFuture describeState$1) {
        return describeState$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$waitUntilTransactionalStateExists$2() {
        return "Transactional state was never added.";
    }

    public TransactionsExpirationTest() {
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
        this.replicationFactor = 3;
    }
}

