/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.AbstractControllerBrokerRequestBatch;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.controller.ZkPartitionStateMachine;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.ZooKeeperClientException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u001a4\u0001aBQa\u0010\u0001\u0005\u0002\u0001C\u0011b\u0011\u0001A\u0002\u0003\u0007I\u0011\u0002#\t\u0013!\u0003\u0001\u0019!a\u0001\n\u0013I\u0005\"C(\u0001\u0001\u0004\u0005\t\u0015)\u0003F\u0011%\u0001\u0006\u00011AA\u0002\u0013%\u0011\u000bC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00053\"I1\f\u0001a\u0001\u0002\u0003\u0006KA\u0015\u0005\n9\u0002\u0001\r\u00111A\u0005\nuC\u0011\"\u0019\u0001A\u0002\u0003\u0007I\u0011\u00022\t\u0013\u0011\u0004\u0001\u0019!A!B\u0013q\u0006\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0003g\u0011%Q\u0007\u00011AA\u0002\u0013%1\u000eC\u0005n\u0001\u0001\u0007\t\u0011)Q\u0005O\"9a\u000e\u0001b\u0001\n\u0013y\u0007BB:\u0001A\u0003%\u0001\u000fC\u0004u\u0001\t\u0007I\u0011B;\t\rq\u0004\u0001\u0015!\u0003w\u0011\u001di\bA1A\u0005\n=DaA \u0001!\u0002\u0013\u0001\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005=\u0002\u0001)A\u0005\u0003?Aq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005]\u0003\u0001\"\u0001\u00024!9\u0011\u0011\r\u0001\u0005\u0002\u0005M\u0002bBA3\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003S\u0002A\u0011AA\u001a\u0011\u001d\ti\u0007\u0001C\u0001\u0003gAq!!\u001d\u0001\t\u0003\t\u0019\u0004C\u0004\u0002v\u0001!\t!a\r\t\u000f\u0005e\u0004\u0001\"\u0001\u00024!9\u0011Q\u0010\u0001\u0005\u0002\u0005M\u0002bBAA\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u000b\u0003A\u0011AA\u001a\u0011\u001d\tI\t\u0001C\u0001\u0003gAq!!$\u0001\t\u0003\t\u0019\u0004C\u0004\u0002\u0012\u0002!\t!a\r\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u0011q\u0019\u0001\u0005\u0002\u0005M\u0002bBAf\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u001f\u0004A\u0011AA\u001a\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003gAq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002t\u0002!\t!a\r\t\u000f\u0005]\b\u0001\"\u0001\u00024!9\u00111 \u0001\u0005\u0002\u0005M\u0002bBA\u0000\u0001\u0011%!\u0011\u0001\u0002\u001a!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f)\u0016\u001cHO\u0003\u00025k\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003Y\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A!\u0011\u0005\t\u0003Q\"A\u001a\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001F!\t\u0011e)\u0003\u0002Hg\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002+\r|g\u000e\u001e:pY2,'oQ8oi\u0016DHo\u0018\u0013fcR\u0011!*\u0014\t\u0003u-K!\u0001T\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\u000e\t\t\u00111\u0001F\u0003\rAH%M\u0001\u0013G>tGO]8mY\u0016\u00148i\u001c8uKb$\b%\u0001\u0007n_\u000e\\'l[\"mS\u0016tG/F\u0001S!\t\u0019f+D\u0001U\u0015\t)V'\u0001\u0002{W&\u0011q\u000b\u0016\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002!5|7m\u001b.l\u00072LWM\u001c;`I\u0015\fHC\u0001&[\u0011\u001dqe!!AA\u0002I\u000bQ\"\\8dWj[7\t\\5f]R\u0004\u0013\u0001I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\",\u0012A\u0018\t\u0003\u0005~K!\u0001Y\u001a\u00039\r{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0006!Sn\\2l\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i?\u0012*\u0017\u000f\u0006\u0002KG\"9a*CA\u0001\u0002\u0004q\u0016!I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\u0013!\u00069beRLG/[8o'R\fG/Z'bG\"Lg.Z\u000b\u0002OB\u0011!\t[\u0005\u0003SN\u0012Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW-A\rqCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3`I\u0015\fHC\u0001&m\u0011\u001dqE\"!AA\u0002\u001d\fa\u0003]1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\rI\u0001\tEJ|7.\u001a:JIV\t\u0001\u000f\u0005\u0002;c&\u0011!o\u000f\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003\u0019\u0019wN\u001c4jOV\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002zk\u000511/\u001a:wKJL!a\u001f=\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0017\u0001E2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002\u0004A!\u0011QAA\u000b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011AB2p[6|gNC\u00027\u0003\u001bQA!a\u0004\u0002\u0012\u00051\u0011\r]1dQ\u0016T!!a\u0005\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0018\u0005\u001d!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00039beRLG/[8ogV\u0011\u0011q\u0004\t\u0007\u0003C\tY#a\u0001\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005%2(\u0001\u0006d_2dWm\u0019;j_:LA!!\f\u0002$\t\u00191+Z9\u0002\u0017A\f'\u000f^5uS>t7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u0015\"\u001a\u0001$a\u000e\u0011\t\u0005e\u0012qI\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005\u0019\u0011\r]5\u000b\t\u0005\u0005\u00131I\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t)%!\u0005\u0002\u000b),h.\u001b;\n\t\u0005%\u00131\b\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017A\u00049beRLG/[8o'R\fG/\u001a\u000b\u0005\u0003\u001f\n)\u0006E\u0002C\u0003#J1!a\u00154\u00059\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016Daa`\rA\u0002\u0005\r\u0011\u0001\r;fgRtuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R{g*Z<QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002\u001b\u00037\u0002B!!\u000f\u0002^%!\u0011qLA\u001e\u0005\u0011!Vm\u001d;\u0002uQ,7\u000f^%om\u0006d\u0017\u000e\u001a(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t\u0007fA\u000e\u0002\\\u0005YD/Z:u\u0013:4\u0018\r\\5e\u001d>tW\r_5ti\u0016tG\u000fU1si&$\u0018n\u001c8U_>3g\r\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007q\tY&A\u0016uKN$h*Z<QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\ri\u00121L\u0001Ti\u0016\u001cHOT3x!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]j{wnS3fa\u0016\u00148\t\\5f]R,\u0005pY3qi&|gN\u0012:p[\u000e\u0013X-\u0019;f'R\fG/Z:)\u0007y\tY&\u0001#uKN$h*Z<QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8o\u000bJ\u0014xN]\"pI\u00164%o\\7De\u0016\fG/Z*uCR,7\u000fK\u0002 \u00037\nA\u0006^3ti:+w\u000fU1si&$\u0018n\u001c8U_>3g\r\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007\u0001\nY&A\u001cuKN$\u0018J\u001c<bY&$g*Z<QCJ$\u0018\u000e^5p]R{gj\u001c8fq&\u001cH/\u001a8u!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0004C\u0005m\u0013!\n;fgR|e\u000e\\5oKB\u000b'\u000f^5uS>tGk\\(oY&tW\r\u0016:b]NLG/[8oQ\r\u0011\u00131L\u0001;i\u0016\u001cHo\u00148mS:,\u0007+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3Ue\u0006t7/\u001b;j_:4uN]\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:D3aIA.\u0003\u0019\"Xm\u001d;P]2Lg.\u001a)beRLG/[8o)>|eM\u001a7j]\u0016$&/\u00198tSRLwN\u001c\u0015\u0004I\u0005m\u0013A\u000f;fgRLeN^1mS\u0012|e\u000e\\5oKB\u000b'\u000f^5uS>tGk\u001c(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\r)\u00131L\u00013i\u0016\u001cH/\u00138wC2LGm\u00148mS:,\u0007+\u0019:uSRLwN\u001c+p\u001d\u0016<\b+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aa%a\u0017\u0002_Q,7\u000f^(gM2Lg.\u001a)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007\u001d\nY&\u0001\u001cuKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c+p+:\u001cG.Z1o\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eF\u0002K\u00033Cq!a')\u0001\u0004\ti*A\rjg2+\u0017\rZ3s%\u0016\u001cwN^3ssN+\b\u000f]8si\u0016$\u0007c\u0001\u001e\u0002 &\u0019\u0011\u0011U\u001e\u0003\u000f\t{w\u000e\\3b]\":\u0001&!*\u00026\u0006]\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\taJ|g/\u001b3fe*!\u0011qVA \u0003\u0019\u0001\u0018M]1ng&!\u00111WAU\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]NdC!!/\u0002<f\t\u0011!G\u0001\u0001Q\rA\u0013q\u0018\t\u0005\u0003\u0003\f\u0019-\u0004\u0002\u0002.&!\u0011QYAW\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001Wi\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c.p_.+W\r]3s\u00072LWM\u001c;Fq\u000e,\u0007\u000f^5p]\u001a\u0013x.\\*uCR,Gj\\8lkBD3!KA.\u0003\u001d#Xm\u001d;PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8o\u000bJ\u0014xN]\"pI\u00164%o\\7Ti\u0006$X\rT8pWV\u0004\bf\u0001\u0016\u0002\\\u0005!D/Z:u\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$vNT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007-\nY&A\u001auKN$\u0018J\u001c<bY&$wJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c+p\u001d\u0016<\b+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aA&a\u0017\u0002KA\u0014X\r]1sK6{7m\u001b+p\u000b2,7\r\u001e'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:\u001cHc\u0001&\u0002\\\"9\u00111D\u0017A\u0002\u0005u\u0007CBAp\u0003_\f\u0019A\u0004\u0003\u0002b\u0006-h\u0002BAr\u0003Sl!!!:\u000b\u0007\u0005\u001dx'\u0001\u0004=e>|GOP\u0005\u0002y%\u0019\u0011Q^\u001e\u0002\u000fA\f7m[1hK&!\u0011QFAy\u0015\r\tioO\u0001#i\u0016\u001cH/\u00169eCRLgnZ(gM2Lg.\u001a)beRLG/[8og\u000e{WO\u001c;)\u00079\nY&\u0001\u001auKN$hj\\(gM2Lg.\u001a)beRLG/[8og\u000eC\u0017M\\4f\r>\u0014Hk\u001c9jGN\u0014U-\u001b8h\t\u0016dW\r^3eQ\ry\u00131L\u00016i\u0016\u001cH/\u00169eCRLgnZ(gM2Lg.\u001a)beRLG/[8og\u000e{WO\u001c;EkJLgn\u001a+pa&\u001cG)\u001a7fi&|g\u000eK\u00021\u00037\n\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u0011\u0011\u0019A!\u0003\u0011\u0007\t\u0013)!C\u0002\u0003\bM\u0012\u0011CU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0011\u001d\u0011Y!\ra\u0001\u0005\u001b\t\u0001B]3qY&\u001c\u0017m\u001d\t\u0006\u0003?\fy\u000f\u001d")
public class PartitionStateMachineTest {
    private ControllerContext controllerContext;
    private KafkaZkClient mockZkClient;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch;
    private PartitionStateMachine partitionStateMachine;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final scala.collection.immutable.Seq<TopicPartition> partitions = new .colon.colon((Object)this.partition(), (List)Nil$.MODULE$);

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    private void partitionStateMachine_$eq(PartitionStateMachine x$1) {
        this.partitionStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private scala.collection.immutable.Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    @BeforeEach
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)Mockito.mock(ControllerBrokerRequestBatch.class));
        this.partitionStateMachine_$eq((PartitionStateMachine)new ZkPartitionStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.controllerContext().partitionState(partition);
    }

    @Test
    public void testNonexistentPartitionToNewPartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOnlinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOfflinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransition() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), true);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromCreateStates() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenThrow(new Throwable[]{new ZooKeeperClientException("test")});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionErrorCodeFromCreateStates() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.NODEEXISTS, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOfflinePartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNewPartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransition() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransitionForControlledShutdown() {
        int otherBrokerId = this.brokerId() + 1;
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        objectArray[1] = TestUtils$.MODULE$.createBrokerAndEpoch(otherBrokerId, "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)this.brokerId()));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(otherBrokerId, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOfflineTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransition() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        Mockito.when((Object)this.mockZkClient().getLogConfigs(Predef$.MODULE$.Set().empty(), this.config().originals())).thenReturn((Object)new Tuple2(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition().topic()), (Object)LogConfig$.MODULE$.apply())})), (Object)Predef$.MODULE$.Map().empty()));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getLogConfigs((scala.collection.immutable.Set)ArgumentMatchers.any(), (java.util.Map)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOfflinePartitionToUncleanOnlinePartitionTransition(boolean isLeaderRecoverySupported) {
        MetadataVersion apiVersion = isLeaderRecoverySupported ? MetadataVersion.IBP_3_2_IV0 : MetadataVersion.IBP_3_1_IV0;
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        properties.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), apiVersion.toString());
        ZkPartitionStateMachine partitionStateMachine = new ZkPartitionStateMachine(KafkaConfig$.MODULE$.fromProps(properties), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch());
        int leaderBrokerId = this.brokerId() + 1;
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = isLeaderRecoverySupported ? leaderAndIsr.newRecoveringLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))) : leaderAndIsr.newLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withPartitionEpoch(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)package$.MODULE$.Seq().empty()));
        partitionStateMachine.handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromStateLookup() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenThrow(new Throwable[]{new ZooKeeperClientException("")});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionErrorCodeFromStateLookup() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.NONODE, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOfflinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    private void prepareMockToElectLeaderForPartitions(scala.collection.immutable.Seq<TopicPartition> partitions) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.prepareMockToGetTopicPartitionsStatesRaw$1(leaderAndIsr, partitions);
        this.prepareMockToGetLogConfigs$1();
        this.prepareMockToUpdateLeaderAndIsr$1(partitions, leaderAndIsr);
    }

    @Test
    public void testUpdatingOfflinePartitionsCount() {
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, SecurityProtocol.PLAINTEXT, 0L);
        this.controllerContext().setLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$5 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$1(topic, BoxesRunTime.unboxToInt((Object)x$5)));
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$2(this, partition);
            return BoxedUnit.UNIT;
        });
        this.prepareMockToElectLeaderForPartitions((scala.collection.immutable.Seq<TopicPartition>)partitions);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testNoOfflinePartitionsChangeForTopicsBeingDeleted() {
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$6 -> PartitionStateMachineTest.$anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(topic, BoxesRunTime.unboxToInt((Object)x$6)));
        this.controllerContext().topicsToBeDeleted().add((Object)topic);
        this.controllerContext().topicsWithDeletionStarted().add((Object)topic);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testUpdatingOfflinePartitionsCountDuringTopicDeletion() {
        scala.collection.immutable.Seq partitionIds = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)partitionIds.map((Function1 & Serializable)x$7 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(BoxesRunTime.unboxToInt((Object)x$7)));
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(this, partition);
            return BoxedUnit.UNIT;
        });
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(this.controllerContext(), false, true);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(this.controllerContext());
        DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);
        TopicDeletionManager topicDeletionManager = new TopicDeletionManager(this.config(), this.controllerContext(), (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, deletionClient);
        partitionStateMachine.handleStateChanges((Seq)partitions, (PartitionState)NewPartition$.MODULE$);
        partitionStateMachine.handleStateChanges((Seq)partitions, (PartitionState)OfflinePartition$.MODULE$);
        partitions.foreach((Function1 & Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(this, partition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        topicDeletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    private ReplicaAssignment replicaAssignment(scala.collection.immutable.Seq<Object> replicas) {
        Nil$ apply_removingReplicas = Nil$.MODULE$;
        Nil$ apply_addingReplicas = Nil$.MODULE$;
        return new ReplicaAssignment(replicas, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
    }

    private final void prepareMockToGetTopicPartitionsStatesRaw$1(LeaderAndIsr leaderAndIsr$1, scala.collection.immutable.Seq partitions$1) {
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr$1, this.controllerEpoch());
        scala.collection.immutable.Seq getDataResponses = (scala.collection.immutable.Seq)partitions$1.map((Function1 & Serializable)p -> new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some(p), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)));
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw((Seq)partitions$1)).thenReturn((Object)getDataResponses);
    }

    private final void prepareMockToGetLogConfigs$1() {
        Mockito.when((Object)this.mockZkClient().getLogConfigs(Predef$.MODULE$.Set().empty(), this.config().originals())).thenReturn((Object)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Map().empty()));
    }

    private final void prepareMockToUpdateLeaderAndIsr$1(scala.collection.immutable.Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        scala.collection.immutable.Map updatedLeaderAndIsr = ((IterableOnceOps)partitions$1.map((Function1 & Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)leaderAndIsr$1.newLeaderAndIsr(this.brokerId(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)updatedLeaderAndIsr, this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)updatedLeaderAndIsr.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition k = (TopicPartition)x0$1._1();
                LeaderAndIsr v = (LeaderAndIsr)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)package$.MODULE$.Right().apply((Object)v));
            }
            throw new MatchError(null);
        }), (Seq)package$.MODULE$.Seq().empty()));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCount$1(String topic$1, int x$5) {
        return new TopicPartition(topic$1, x$5);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCount$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.brokerId()}))));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(String topic$2, int x$6) {
        return new TopicPartition(topic$2, x$6);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(int x$7) {
        return new TopicPartition("test", x$7);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.brokerId()}))));
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(PartitionStateMachineTest $this, TopicPartition partition) {
        PartitionAndReplica replica = new PartitionAndReplica(partition, $this.brokerId());
        $this.controllerContext().putReplicaState(replica, (ReplicaState)OfflineReplica$.MODULE$);
    }

    public PartitionStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

