/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.LazyIndex;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TimestampOffset$;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011Ua\u0001B-[\u0001}C\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0001\u001c\u0005\tu\u0002\u0011\t\u0011)A\u0005[\"A1\u0010\u0001BC\u0002\u0013\u0005A\u0010C\u0005\u0002\n\u0001\u0011\t\u0011)A\u0005{\"Q\u00111\u0002\u0001\u0003\u0006\u0004%\t!!\u0004\t\u0015\u0005]\u0001A!A!\u0002\u0013\ty\u0001\u0003\u0006\u0002\u001a\u0001\u0011)\u0019!C\u0001\u00037A!\"a\t\u0001\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\t)\u0003\u0001BC\u0002\u0013\u0005\u0011q\u0005\u0005\u000b\u0003_\u0001!\u0011!Q\u0001\n\u0005%\u0002BCA\u0019\u0001\t\u0015\r\u0011\"\u0001\u00024!Q\u00111\b\u0001\u0003\u0002\u0003\u0006I!!\u000e\t\u0015\u0005u\u0002A!b\u0001\n\u0003\t9\u0003\u0003\u0006\u0002@\u0001\u0011\t\u0011)A\u0005\u0003SA!\"!\u0011\u0001\u0005\u000b\u0007I\u0011AA\"\u0011)\ty\u0005\u0001B\u0001B\u0003%\u0011Q\t\u0005\t\u0003#\u0002A\u0011\u0001.\u0002T!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!!%\u0001\t\u0003\t\u0019\nC\u0005\u0002\u001a\u0002\u0001\r\u0011\"\u0003\u0002(!I\u00111\u0014\u0001A\u0002\u0013%\u0011Q\u0014\u0005\t\u0003G\u0003\u0001\u0015)\u0003\u0002*!I\u0011Q\u0015\u0001A\u0002\u0013%\u00111\u0007\u0005\n\u0003O\u0003\u0001\u0019!C\u0005\u0003SC\u0001\"!,\u0001A\u0003&\u0011Q\u0007\u0005\n\u0003_\u0003\u0001\u0019!C\u0005\u0003cC\u0011\"!/\u0001\u0001\u0004%I!a/\t\u0011\u0005}\u0006\u0001)Q\u0005\u0003gC\u0011\"!3\u0001\u0001\u0004%I!a3\t\u0013\u0005M\u0007\u00011A\u0005\n\u0005U\u0007\u0002CAm\u0001\u0001\u0006K!!4\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\"9\u0011Q\u001d\u0001\u0005\u0002\u0005-\u0007bBAt\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003S\u0004A\u0011AA\u0014\u0011\u001d\ty\t\u0001C\u0001\u0003gAq!a;\u0001\t\u0003\ti\u000fC\u0004\u0002t\u0002!\t!!>\t\u000f\tU\u0001\u0001\"\u0003\u0003\u0018!9!1\u0004\u0001\u0005\n\tu\u0001b\u0002B\u0018\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005s\u0001A\u0011\u0001B\u001e\u0011\u001d\u0011i\u0005\u0001C\u0005\u0005\u001fB\u0001B!\u001a\u0001\t\u0003Q&q\r\u0005\u000b\u0005?\u0003\u0011\u0013!C\u00015\n\u0005\u0006b\u0002B\\\u0001\u0011\u0005!\u0011\u0018\u0005\n\u00053\u0004\u0011\u0013!C\u0001\u00057D\u0011Ba8\u0001#\u0003%\tA!9\t\u000f\t\u0015\b\u0001\"\u0001\u0003h\"9!q\u001f\u0001\u0005\u0002\te\b\"CB\t\u0001E\u0005I\u0011AB\n\u0011\u001d\u00199\u0002\u0001C\u0005\u00073Aqaa\u0007\u0001\t\u0003\u0019i\u0002C\u0004\u0004 \u0001!\ta!\t\t\u000f\rE\u0002\u0001\"\u0011\u00044!91Q\t\u0001\u0005\u0002\r\u001d\u0003bBB'\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0007#\u0002A\u0011AB\r\u0011\u001d\u0019)\u0006\u0001C\u0001\u0007/Bqa!\u001c\u0001\t\u0003\u0019y\u0007C\u0004\u0004z\u0001!\taa\u001f\t\u000f\r\u0005\u0005\u0001\"\u0001\u0004\u001a!911\u0011\u0001\u0005\n\re\u0001bBBC\u0001\u0011\u00051q\u0011\u0005\b\u0007#\u0003A\u0011ABJ\u0011\u001d\u0019)\n\u0001C\u0001\u0007/C\u0011b!+\u0001#\u0003%\tAa7\t\u000f\r-\u0006\u0001\"\u0001\u0004\u001a!91Q\u0016\u0001\u0005\u0002\re\u0001bBBX\u0001\u0011\u00051\u0011\u0004\u0005\b\u0007c\u0003A\u0011ABZ\u0011\u001d\u0019)\f\u0001C\u0001\u0003OAqaa.\u0001\t\u0003\t\t\fC\u0004\u0002~\u0002!\t!a\n\t\u000f\re\u0006\u0001\"\u0001\u0004<\u001e911\u001b.\t\u0002\rUgAB-[\u0011\u0003\u00199\u000eC\u0004\u0002RA#\ta!7\t\u000f\rm\u0007\u000b\"\u0001\u0004^\"I1q )\u0012\u0002\u0013\u0005!\u0011\u001d\u0005\n\t\u0003\u0001\u0016\u0013!C\u0001\u0005CC\u0011\u0002b\u0001Q#\u0003%\tA!9\t\u0013\u0011\u0015\u0001+%A\u0005\u0002\u0011\u001d\u0001bBBX!\u0012\u0005A1\u0002\u0005\n\t'\u0001\u0016\u0013!C\u0001\t\u000f\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\tYF,A\u0002m_\u001eT\u0011!X\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001M\u001a\t\u0003C\u0012l\u0011A\u0019\u0006\u0002G\u0006)1oY1mC&\u0011QM\u0019\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dTW\"\u00015\u000b\u0005%d\u0016!B;uS2\u001c\u0018BA6i\u0005\u001daunZ4j]\u001e,\u0012!\u001c\t\u0003]bl\u0011a\u001c\u0006\u0003aF\faA]3d_J$'B\u0001:t\u0003\u0019\u0019w.\\7p]*\u0011Q\f\u001e\u0006\u0003kZ\fa!\u00199bG\",'\"A<\u0002\u0007=\u0014x-\u0003\u0002z_\nYa)\u001b7f%\u0016\u001cwN\u001d3t\u0003\u0011awn\u001a\u0011\u0002\u001f1\f'0_(gMN,G/\u00138eKb,\u0012! \t\u0005}~\f\u0019!D\u0001[\u0013\r\t\tA\u0017\u0002\n\u0019\u0006T\u00180\u00138eKb\u00042A`A\u0003\u0013\r\t9A\u0017\u0002\f\u001f\u001a47/\u001a;J]\u0012,\u00070\u0001\tmCjLxJ\u001a4tKRLe\u000eZ3yA\u0005iA.\u0019>z)&lW-\u00138eKb,\"!a\u0004\u0011\ty|\u0018\u0011\u0003\t\u0004}\u0006M\u0011bAA\u000b5\nIA+[7f\u0013:$W\r_\u0001\u000fY\u0006T\u0018\u0010V5nK&sG-\u001a=!\u0003!!\bP\\%oI\u0016DXCAA\u000f!\rq\u0018qD\u0005\u0004\u0003CQ&\u0001\u0005+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3y\u0003%!\bP\\%oI\u0016D\b%\u0001\u0006cCN,wJ\u001a4tKR,\"!!\u000b\u0011\u0007\u0005\fY#C\u0002\u0002.\t\u0014A\u0001T8oO\u0006Y!-Y:f\u001f\u001a47/\u001a;!\u0003IIg\u000eZ3y\u0013:$XM\u001d<bY\nKH/Z:\u0016\u0005\u0005U\u0002cA1\u00028%\u0019\u0011\u0011\b2\u0003\u0007%sG/A\nj]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\b%\u0001\u0007s_2d'*\u001b;uKJl5/A\u0007s_2d'*\u001b;uKJl5\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002FA!\u0011qIA&\u001b\t\tIE\u0003\u0002jc&!\u0011QJA%\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\rqJg.\u001b;?)I\t)&a\u0016\u0002Z\u0005m\u0013QLA0\u0003C\n\u0019'!\u001a\u0011\u0005y\u0004\u0001\"B.\u0012\u0001\u0004i\u0007\"B>\u0012\u0001\u0004i\bbBA\u0006#\u0001\u0007\u0011q\u0002\u0005\b\u00033\t\u0002\u0019AA\u000f\u0011\u001d\t)#\u0005a\u0001\u0003SAq!!\r\u0012\u0001\u0004\t)\u0004C\u0004\u0002>E\u0001\r!!\u000b\t\u000f\u0005\u0005\u0013\u00031\u0001\u0002F\u0005YqN\u001a4tKRLe\u000eZ3y+\t\t\u0019!A\u0005uS6,\u0017J\u001c3fqV\u0011\u0011\u0011C\u0001\u000bg\"|W\u000f\u001c3S_2dG\u0003BA:\u0003s\u00022!YA;\u0013\r\t9H\u0019\u0002\b\u0005>|G.Z1o\u0011\u001d\tY\b\u0006a\u0001\u0003{\n!B]8mYB\u000b'/Y7t!\rq\u0018qP\u0005\u0004\u0003\u0003S&A\u0003*pY2\u0004\u0016M]1ng\u0006i!/Z:ju\u0016Le\u000eZ3yKN$B!a\"\u0002\u000eB\u0019\u0011-!#\n\u0007\u0005-%M\u0001\u0003V]&$\bbBAH+\u0001\u0007\u0011QG\u0001\u0005g&TX-A\u0006tC:LG/_\"iK\u000e\\G\u0003BAD\u0003+Cq!a&\u0017\u0001\u0004\t\u0019(A\ruS6,\u0017J\u001c3fq\u001aKG.\u001a(fo2L8I]3bi\u0016$\u0017aB2sK\u0006$X\rZ\u0001\fGJ,\u0017\r^3e?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0006}\u0005\"CAQ1\u0005\u0005\t\u0019AA\u0015\u0003\rAH%M\u0001\tGJ,\u0017\r^3eA\u0005A\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=\u00029\tLH/Z:TS:\u001cW\rT1ti&sG-\u001a=F]R\u0014\u0018p\u0018\u0013fcR!\u0011qQAV\u0011%\t\tkGA\u0001\u0002\u0004\t)$A\rcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef\u0004\u0013!\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e]\u000b\u0003\u0003g\u0003R!YA[\u0003SI1!a.c\u0005\u0019y\u0005\u000f^5p]\u0006I\"o\u001c7mS:<')Y:fIRKW.Z:uC6\u0004x\fJ3r)\u0011\t9)!0\t\u0013\u0005\u0005f$!AA\u0002\u0005M\u0016A\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e\u001d\u0011)\u0007}\t\u0019\rE\u0002b\u0003\u000bL1!a2c\u0005!1x\u000e\\1uS2,\u0017aG0nCb$\u0016.\\3ti\u0006l\u0007/\u00118e\u001f\u001a47/\u001a;T_\u001a\u000b'/\u0006\u0002\u0002NB\u0019a0a4\n\u0007\u0005E'LA\bUS6,7\u000f^1na>3gm]3u\u0003}yV.\u0019=US6,7\u000f^1na\u0006sGm\u00144gg\u0016$8k\u001c$be~#S-\u001d\u000b\u0005\u0003\u000f\u000b9\u000eC\u0005\u0002\"\u0006\n\t\u00111\u0001\u0002N\u0006ar,\\1y)&lWm\u001d;b[B\fe\u000eZ(gMN,GoU8GCJ\u0004\u0003f\u0001\u0012\u0002D\u0006qR.\u0019=US6,7\u000f^1na\u0006sGm\u00144gg\u0016$8k\u001c$be~#S-\u001d\u000b\u0005\u0003\u000f\u000b\t\u000fC\u0004\u0002d\u000e\u0002\r!!4\u0002\u001fQLW.Z:uC6\u0004xJ\u001a4tKR\f!$\\1y)&lWm\u001d;b[B\fe\u000eZ(gMN,GoU8GCJ\f\u0011#\\1y)&lWm\u001d;b[B\u001cvNR1s\u0003eygMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:\u00025\r\fgnQ8om\u0016\u0014H\u000fV8SK2\fG/\u001b<f\u001f\u001a47/\u001a;\u0015\t\u0005M\u0014q\u001e\u0005\b\u0003cD\u0003\u0019AA\u0015\u0003\u0019ygMZ:fi\u00061\u0011\r\u001d9f]\u0012$\"\"a\"\u0002x\u0006m\u0018q B\u0002\u0011\u001d\tI0\u000ba\u0001\u0003S\tQ\u0002\\1sO\u0016\u001cHo\u00144gg\u0016$\bbBA\u007fS\u0001\u0007\u0011\u0011F\u0001\u0011Y\u0006\u0014x-Z:u)&lWm\u001d;b[BDqA!\u0001*\u0001\u0004\tI#A\u000etQ\u0006dGn\\<PM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e\u001d\u0005\b\u0005\u000bI\u0003\u0019\u0001B\u0004\u0003\u001d\u0011XmY8sIN\u00042A\u001cB\u0005\u0013\r\u0011Ya\u001c\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:)\u0007%\u0012y\u0001E\u0002h\u0005#I1Aa\u0005i\u00055qwN\u001c;ie\u0016\fGm]1gK\u0006\u0019RM\\:ve\u0016|eMZ:fi&s'+\u00198hKR!\u0011q\u0011B\r\u0011\u001d\t\tP\u000ba\u0001\u0003S\t1#\u00199qK:$7\t[;oW\u001a\u0013x.\u001c$jY\u0016$\u0002\"!\u000e\u0003 \t\u0005\"Q\u0005\u0005\u0007\u0005\u000bY\u0003\u0019A7\t\u000f\t\r2\u00061\u0001\u00026\u0005A\u0001o\\:ji&|g\u000eC\u0004\u0003(-\u0002\rA!\u000b\u0002\u001d\t,hMZ3s'V\u0004\b\u000f\\5feB!\u0011q\tB\u0016\u0013\u0011\u0011i#!\u0013\u0003\u001d\t+hMZ3s'V\u0004\b\u000f\\5fe\u0006q\u0011\r\u001d9f]\u00124%o\\7GS2,GCBA\u001b\u0005g\u0011)\u0004\u0003\u0004\u0003\u00061\u0002\r!\u001c\u0005\b\u0005oa\u0003\u0019AA\u001b\u0003\u0015\u0019H/\u0019:u\u00039)\b\u000fZ1uKRCh.\u00138eKb$b!a\"\u0003>\t\u001d\u0003b\u0002B [\u0001\u0007!\u0011I\u0001\rG>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\t\u0004}\n\r\u0013b\u0001B#5\na1i\\7qY\u0016$X\r\u001a+y]\"9!\u0011J\u0017A\u0002\u0005%\u0012\u0001\u00057bgR\u001cF/\u00192mK>3gm]3uQ\ri#qB\u0001\u0014kB$\u0017\r^3Qe>$WoY3s'R\fG/\u001a\u000b\u0007\u0003\u000f\u0013\tFa\u0017\t\u000f\tMc\u00061\u0001\u0003V\u0005!\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u00042A B,\u0013\r\u0011IF\u0017\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\t\u000f\tuc\u00061\u0001\u0003`\u0005)!-\u0019;dQB\u0019aN!\u0019\n\u0007\t\rtNA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0017a\u0004;sC:\u001cH.\u0019;f\u001f\u001a47/\u001a;\u0015\r\t%$\u0011\u0013BJ!\u0011\u0011YGa#\u000f\t\t5$q\u0011\b\u0005\u0005_\u0012)I\u0004\u0003\u0003r\t\re\u0002\u0002B:\u0005\u0003sAA!\u001e\u0003\u00009!!q\u000fB?\u001b\t\u0011IHC\u0002\u0003|y\u000ba\u0001\u0010:p_Rt\u0014\"A<\n\u0005U4\u0018BA/u\u0013\t\u00118/\u0003\u0002qc&\u0019!\u0011R8\u0002\u0017\u0019KG.\u001a*fG>\u0014Hm]\u0005\u0005\u0005\u001b\u0013yIA\tM_\u001e|eMZ:fiB{7/\u001b;j_:T1A!#p\u0011\u001d\t\tp\fa\u0001\u0003SA\u0011B!&0!\u0003\u0005\r!!\u000e\u0002)M$\u0018M\u001d;j]\u001e4\u0015\u000e\\3Q_NLG/[8oQ\ry#\u0011\u0014\t\u0004O\nm\u0015b\u0001BOQ\nQA\u000f\u001b:fC\u0012\u001c\u0018MZ3\u00023Q\u0014\u0018M\\:mCR,wJ\u001a4tKR$C-\u001a4bk2$HEM\u000b\u0003\u0005GSC!!\u000e\u0003&.\u0012!q\u0015\t\u0005\u0005S\u0013\u0019,\u0004\u0002\u0003,*!!Q\u0016BX\u0003%)hn\u00195fG.,GMC\u0002\u00032\n\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)La+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003sK\u0006$GC\u0003B^\u0005\u000f\u0014YMa4\u0003TB!!Q\u0018Bb\u001b\t\u0011yLC\u0002\u0003Br\u000baa]3sm\u0016\u0014\u0018\u0002\u0002Bc\u0005\u007f\u0013QBR3uG\"$\u0015\r^1J]\u001a|\u0007b\u0002Bec\u0001\u0007\u0011\u0011F\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0003NF\u0002\r!!\u000e\u0002\u000f5\f\u0007pU5{K\"I!\u0011[\u0019\u0011\u0002\u0003\u0007\u0011\u0011F\u0001\f[\u0006D\bk\\:ji&|g\u000eC\u0005\u0003VF\u0002\n\u00111\u0001\u0002t\u0005iQ.\u001b8P]\u0016lUm]:bO\u0016D3!\rBM\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIM*\"A!8+\t\u0005%\"QU\u0001\u000fe\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019O\u000b\u0003\u0002t\t\u0015\u0016!\u00064fi\u000eDW\u000b\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r\u001e\u000b\u0007\u0003g\u0013IOa=\t\u000f\t-H\u00071\u0001\u0003n\u0006\u00192\u000f^1si>3gm]3u!>\u001c\u0018\u000e^5p]B\u0019aPa<\n\u0007\tE(L\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\t\u000f\tUH\u00071\u0001\u00026\u0005Ia-\u001a;dQNK'0Z\u0001\be\u0016\u001cwN^3s)\u0019\t)Da?\u0003~\"9!1K\u001bA\u0002\tU\u0003\"\u0003B\u0000kA\u0005\t\u0019AB\u0001\u0003AaW-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\rE\u0003b\u0003k\u001b\u0019\u0001\u0005\u0003\u0004\u0006\r-QBAB\u0004\u0015\u0011\u0019IAa0\u0002\u000b\u0015\u0004xn\u00195\n\t\r51q\u0001\u0002\u0015\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3)\u0007U\u0012y!A\tsK\u000e|g/\u001a:%I\u00164\u0017-\u001e7uII*\"a!\u0006+\t\r\u0005!QU\u0001\u0015Y>\fG\rT1sO\u0016\u001cH\u000fV5nKN$\u0018-\u001c9\u0015\u0005\u0005\u001d\u0015a\u00035bg>3XM\u001d4m_^,\"!a\u001d\u0002%\r|G\u000e\\3di\u0006\u0013wN\u001d;fIRChn\u001d\u000b\u0007\u0007G\u0019Ic!\f\u0011\u0007y\u001c)#C\u0002\u0004(i\u0013A\u0003\u0016=o\u0013:$W\r_*fCJ\u001c\u0007NU3tk2$\bbBB\u0016s\u0001\u0007\u0011\u0011F\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0004\u00040e\u0002\r!!\u000b\u0002!U\u0004\b/\u001a:C_VtGm\u00144gg\u0016$\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\rU\u0002\u0003BB\u001c\u0007\u007fqAa!\u000f\u0004<A\u0019!q\u000f2\n\u0007\ru\"-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007\u0003\u001a\u0019E\u0001\u0004TiJLgn\u001a\u0006\u0004\u0007{\u0011\u0017A\u0003;sk:\u001c\u0017\r^3U_R!\u0011QGB%\u0011\u001d\t\tp\u000fa\u0001\u0003SA3a\u000fB\b\u00039\u0011X-\u00193OKb$xJ\u001a4tKRD3\u0001\u0010BM\u0003\u00151G.^:iQ\ri$\u0011T\u0001\u0010kB$\u0017\r^3QCJ,g\u000e\u001e#jeR!\u0011qQB-\u0011\u001d\u0019YF\u0010a\u0001\u0007;\n1\u0001Z5s!\u0011\u0019yf!\u001b\u000e\u0005\r\u0005$\u0002BB2\u0007K\n!![8\u000b\u0005\r\u001d\u0014\u0001\u00026bm\u0006LAaa\u001b\u0004b\t!a)\u001b7f\u0003I\u0019\u0007.\u00198hK\u001aKG.Z*vM\u001aL\u00070Z:\u0015\r\u0005\u001d5\u0011OB;\u0011\u001d\u0019\u0019h\u0010a\u0001\u0007k\t\u0011b\u001c7e'V4g-\u001b=\t\u000f\r]t\b1\u0001\u00046\u0005Ia.Z<Tk\u001a4\u0017\u000e_\u0001\nQ\u0006\u001c8+\u001e4gSb$B!a\u001d\u0004~!91q\u0010!A\u0002\rU\u0012AB:vM\u001aL\u00070A\fp]\n+7m\\7f\u0013:\f7\r^5wKN+w-\\3oi\u00069Bn\\1e\r&\u00148\u000f\u001e\"bi\u000eDG+[7fgR\fW\u000e]\u0001\u0012i&lWmV1ji\u0016$gi\u001c:S_2dGCBA\u0015\u0007\u0013\u001bi\tC\u0004\u0004\f\u000e\u0003\r!!\u000b\u0002\u00079|w\u000fC\u0004\u0004\u0010\u000e\u0003\r!!\u000b\u0002!5,7o]1hKRKW.Z:uC6\u0004\u0018AF4fi\u001aK'o\u001d;CCR\u001c\u0007\u000eV5nKN$\u0018-\u001c9\u0015\u0005\u0005%\u0012!\u00064j]\u0012|eMZ:fi\nKH+[7fgR\fW\u000e\u001d\u000b\u0007\u00073\u001b\tk!*\u0011\u000b\u0005\f)la'\u0011\t\t-4QT\u0005\u0005\u0007?\u0013yI\u0001\nUS6,7\u000f^1na\u0006sGm\u00144gg\u0016$\bbBBR\u000b\u0002\u0007\u0011\u0011F\u0001\ni&lWm\u001d;b[BD\u0011ba*F!\u0003\u0005\r!!\u000b\u0002\u001dM$\u0018M\u001d;j]\u001e|eMZ:fi\u0006yb-\u001b8e\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0002\u000b\rdwn]3\u0002\u001b\rdwn]3IC:$G.\u001a:t\u00039!W\r\\3uK&3W\t_5tiN\fq\u0001Z3mKR,G\r\u0006\u0002\u0002t\u0005aA.Y:u\u001b>$\u0017NZ5fI\u00061B.\u0019:hKN$(+Z2pe\u0012$\u0016.\\3ti\u0006l\u0007/\u0001\tmCN$Xj\u001c3jM&,Gm\u0018\u0013fcR!1QXBg!\u0011\u0019yl!3\u000e\u0005\r\u0005'\u0002BBb\u0007\u000b\fAAZ5mK*!1qYB3\u0003\rq\u0017n\\\u0005\u0005\u0007\u0017\u001c\tM\u0001\u0003QCRD\u0007bBBh\u001d\u0002\u0007\u0011\u0011F\u0001\u0003[ND3\u0001\u0001B\b\u0003)aunZ*fO6,g\u000e\u001e\t\u0003}B\u001b\"\u0001\u00151\u0015\u0005\rU\u0017\u0001B8qK:$\"#!\u0016\u0004`\u000e\u000581]Bw\u0007_\u001c\u0019pa>\u0004|\"911\f*A\u0002\ru\u0003bBA\u0013%\u0002\u0007\u0011\u0011\u0006\u0005\b\u0007K\u0014\u0006\u0019ABt\u0003\u0019\u0019wN\u001c4jOB\u0019ap!;\n\u0007\r-(LA\u0005M_\u001e\u001cuN\u001c4jO\"9\u0011\u0011\t*A\u0002\u0005\u0015\u0003\"CBy%B\u0005\t\u0019AA:\u0003E1\u0017\u000e\\3BYJ,\u0017\rZ=Fq&\u001cHo\u001d\u0005\n\u0007k\u0014\u0006\u0013!a\u0001\u0003k\tA\"\u001b8ji\u001aKG.Z*ju\u0016D\u0011b!?S!\u0003\u0005\r!a\u001d\u0002\u0017A\u0014X-\u00197m_\u000e\fG/\u001a\u0005\n\u0007{\u0014\u0006\u0013!a\u0001\u0007k\t!BZ5mKN+hMZ5y\u00039y\u0007/\u001a8%I\u00164\u0017-\u001e7uIU\nab\u001c9f]\u0012\"WMZ1vYR$c'\u0001\bpa\u0016tG\u0005Z3gCVdG\u000fJ\u001c\u0002\u001d=\u0004XM\u001c\u0013eK\u001a\fW\u000f\u001c;%qU\u0011A\u0011\u0002\u0016\u0005\u0007k\u0011)\u000b\u0006\u0005\u0002\b\u00125Aq\u0002C\t\u0011\u001d\u0019Yf\u0016a\u0001\u0007;Bq!!\nX\u0001\u0004\tI\u0003C\u0005\u0004~^\u0003\n\u00111\u0001\u00046\u0005AB-\u001a7fi\u0016Le-\u0012=jgR\u001cH\u0005Z3gCVdG\u000fJ\u001a")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyIndex<OffsetIndex> lazyOffsetIndex;
    private final LazyIndex<TimeIndex> lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile TimestampOffset _maxTimestampAndOffsetSoFar;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return "";
    }

    public static String open$default$8() {
        return "";
    }

    public static boolean open$default$7() {
        return false;
    }

    public static int open$default$6() {
        return 0;
    }

    public static boolean open$default$5() {
        return false;
    }

    public static LogSegment open(File dir, long baseOffset, LogConfig config, Time time, boolean fileAlreadyExists, int initFileSize, boolean preallocate, String fileSuffix) {
        return LogSegment$.MODULE$.open(dir, baseOffset, config, time, fileAlreadyExists, initFileSize, preallocate, fileSuffix);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyIndex<OffsetIndex> lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyIndex<TimeIndex> lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs;
        boolean bl = reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (this.lazyOffsetIndex().file().exists()) {
            if (timeIndexFileNewlyCreated) {
                this.timeIndex().resize(0);
            }
            this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append(this.lazyOffsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private TimestampOffset _maxTimestampAndOffsetSoFar() {
        return this._maxTimestampAndOffsetSoFar;
    }

    private void _maxTimestampAndOffsetSoFar_$eq(TimestampOffset x$1) {
        this._maxTimestampAndOffsetSoFar = x$1;
    }

    public void maxTimestampAndOffsetSoFar_$eq(TimestampOffset timestampOffset) {
        this._maxTimestampAndOffsetSoFar_$eq(timestampOffset);
    }

    public TimestampOffset maxTimestampAndOffsetSoFar() {
        TimestampOffset timestampOffset = this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset$.MODULE$.Unknown();
        if (!(timestampOffset != null ? !((Object)timestampOffset).equals(timestampOffset2) : timestampOffset2 != null)) {
            this._maxTimestampAndOffsetSoFar_$eq(this.timeIndex().lastEntry());
        }
        return this._maxTimestampAndOffsetSoFar();
    }

    public long maxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().timestamp();
    }

    public long offsetOfMaxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().offset();
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Inserting ").append(records.sizeInBytes()).append(" bytes at end offset ").append(largestOffset).append(" at position ").append(this.log().sizeInBytes()).append(" ").append("with largest timestamp ").append(largestTimestamp).append(" at shallow offset ").append(shallowOffsetOfMaxTimestamp).toString());
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append(this.log().file()).append(" at end offset ").append(largestOffset).toString());
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(largestTimestamp, shallowOffsetOfMaxTimestamp));
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                TimeIndex qual$1 = this.timeIndex();
                long x$1 = this.maxTimestampSoFar();
                long x$2 = this.offsetOfMaxTimestampSoFar();
                boolean x$3 = qual$1.maybeAppend$default$3();
                qual$1.maybeAppend(x$1, x$2, x$3);
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
            return;
        }
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        CollectionConverters$.MODULE$.IterableHasAsScala(records.batchesFrom(position)).asScala().iterator().takeWhile((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1 & Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        if (completedTxn.isAborted()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn).append(" to transaction index, last stable offset is ").append(lastStableOffset).toString());
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
            return;
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, AppendOrigin$Replication$.MODULE$);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch, (Option<LogOffsetMetadata>)None$.MODULE$);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1 & Serializable)completedTxn -> {
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
                return BoxedUnit.UNIT;
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
        }
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        int n = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, false, (Option<List<FetchResponseData.AbortedTransaction>>)None$.MODULE$);
        }
        int fetchSize = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, (Option<List<FetchResponseData.AbortedTransaction>>)None$.MODULE$);
    }

    public long read$default$3() {
        return this.size();
    }

    public boolean read$default$4() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.maxTimestampAndOffsetSoFar_$eq(TimestampOffset$.MODULE$.Unknown());
        try {
            CollectionConverters$.MODULE$.IterableHasAsScala(this.log().batches()).asScala().foreach((Function1 & Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, validBytes, lastIndexEntry, leaderEpochCache, producerStateManager, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            if (throwable instanceof CorruptRecordException ? true : throwable instanceof InvalidRecordException) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s. %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes$1.elem), throwable.getMessage(), throwable.getCause()})));
            }
            throw throwable;
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append(this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampAndOffsetSoFar_$eq(lastTimeIndexEntry);
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
        FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(maxTimestampOffsetAfterLastEntry.timestamp, maxTimestampOffsetAfterLastEntry.offset));
            return;
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder(74).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(", lastModifiedTime=").append(this.lastModified()).append(", largestRecordTimestamp=").append(this.largestRecordTimestamp()).append(")").toString();
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        this.offsetIndex().truncateTo(offset);
        this.timeIndex().truncateTo(offset);
        this.txnIndex().truncateTo(offset);
        this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time().milliseconds());
            this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), this.log().sizeInBytes(), this.read$default$3(), this.read$default$4());
        if (fetchData == null) {
            return this.baseOffset();
        }
        return BoxesRunTime.unboxToLong((Object)CollectionConverters$.MODULE$.IterableHasAsScala(fetchData.records().batches()).asScala().lastOption().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.nextOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.baseOffset()));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(() -> {
            LogSegment.$anonfun$flush$1(this);
            return BoxedUnit.UNIT;
        });
    }

    public void updateParentDir(File dir) {
        this.log().updateParentDir(dir);
        this.lazyOffsetIndex().updateParentDir(dir);
        this.lazyTimeIndex().updateParentDir(dir);
        this.txnIndex().updateParentDir(dir);
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.lazyOffsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyOffsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.lazyTimeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyTimeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public boolean hasSuffix(String suffix) {
        return this.log().file().getName().endsWith(suffix) && this.lazyOffsetIndex().file().getName().endsWith(suffix) && this.lazyTimeIndex().file().getName().endsWith(suffix) && this.txnIndex().file().getName().endsWith(suffix);
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    private void loadFirstBatchTimestamp() {
        if (this.rollingBasedTimestamp().isEmpty()) {
            Iterator iter = this.log().batches().iterator();
            if (iter.hasNext()) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
                return;
            }
            return;
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        if (option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L) {
            return messageTimestamp - t;
        }
        return now - this.created();
    }

    public long getFirstBatchTimestamp() {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        if (option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L) {
            return t;
        }
        return Long.MAX_VALUE;
    }

    public Option<FileRecords.TimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        TimestampOffset timestampOffset = this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset$.MODULE$.Unknown();
        if (timestampOffset == null ? timestampOffset2 != null : !((Object)timestampOffset).equals(timestampOffset2)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true), this, Level.WARN);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyOffsetIndex().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyTimeIndex().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.log().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.txnIndex().close(), this, Level.WARN);
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyOffsetIndex().closeHandler(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyTimeIndex().closeHandler(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.log().closeHandlers(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.txnIndex().close(), this, Level.WARN);
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.log().file();
            String delete$1_fileType = "log";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$4(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyOffsetIndex().file();
            String delete$1_fileType = "offset index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$6(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyTimeIndex().file();
            String delete$1_fileType = "time index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$8(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = false;
            File delete$1_file = this.txnIndex().file();
            String delete$1_fileType = "transaction index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$10(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)Nil$.MODULE$)))));
    }

    public boolean deleted() {
        return !this.log().file().exists() && !this.lazyOffsetIndex().file().exists() && !this.lazyTimeIndex().file().exists() && !this.txnIndex().file().exists();
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public Option<Object> largestRecordTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.maxTimestampSoFar()));
        }
        return None$.MODULE$;
    }

    public long largestTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return this.maxTimestampSoFar();
        }
        return this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.lazyOffsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.lazyTimeIndex().file().toPath(), fileTime);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$1.lastStableOffset(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
        producerStateManager$1.completeTxn(completedTxn);
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        if (batch$1.partitionLeaderEpoch() >= 0 && cache.latestEpoch().forall((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> batch$1.partitionLeaderEpoch() > x$2)) {
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, IntRef validBytes$1, IntRef lastIndexEntry$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, FileLogInputStream.FileChannelRecordBatch batch) {
        batch.ensureValid();
        $this.ensureOffsetInRange(batch.lastOffset());
        if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
            $this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(batch.maxTimestamp(), batch.lastOffset()));
        }
        if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
            $this.offsetIndex().append(batch.lastOffset(), validBytes$1.elem);
            TimeIndex qual$1 = $this.timeIndex();
            long x$1 = $this.maxTimestampSoFar();
            long x$2 = $this.offsetOfMaxTimestampSoFar();
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
            lastIndexEntry$1.elem = validBytes$1.elem;
        }
        validBytes$1.elem += batch.sizeInBytes();
        if (batch.magic() >= 2) {
            leaderEpochCache$1.foreach((Function1 & Serializable)cache -> {
                LogSegment.$anonfun$recover$2(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$2, (RecordBatch)batch);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$flush$1(LogSegment $this) {
        $this.log().flush();
        $this.offsetIndex().flush();
        $this.timeIndex().flush();
        $this.txnIndex().flush();
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$4(LogSegment $this) {
        return $this.log().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$6(LogSegment $this) {
        return $this.lazyOffsetIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$8(LogSegment $this) {
        return $this.lazyTimeIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$10(LogSegment $this) {
        return $this.txnIndex().deleteIfExists();
    }

    public LogSegment(FileRecords log, LazyIndex<OffsetIndex> lazyOffsetIndex, LazyIndex<TimeIndex> lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this._maxTimestampAndOffsetSoFar = TimestampOffset$.MODULE$.Unknown();
    }
}

