/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.UnifiedLog;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Q3A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!9\u0011\u0004\u0001b\u0001\n\u0003Q\u0002B\u0002\u0015\u0001A\u0003%1\u0004C\u0004*\u0001\t\u0007I\u0011\u0001\u0016\t\rM\u0002\u0001\u0015!\u0003,\u0011\u0015!\u0004\u0001\"\u00116\u0011\u0015!\u0005\u0001\"\u0001F\u0005}9%o\\;q\u0007>|'\u000fZ5oCR|'/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0015-\t1!\u00199j\u0015\u0005a\u0011!B6bM.\f7\u0001A\n\u0003\u0001=\u0001\"\u0001E\n\u000e\u0003EQ!AE\u0006\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003)E\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003%\tAd\u001c4gg\u0016$8\u000fV8qS\u000e\u001cu.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7-F\u0001\u001c!\tab%D\u0001\u001e\u0015\tqr$\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003A\u0005\naaY8n[>t'B\u0001\u0007#\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\n\u0005\u001dj\"aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0002;=4gm]3ugR{\u0007/[2D_6\u0004(/Z:tS>t7i\u001c3fG\u0002\nqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005kRLGNC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\ta\u0007E\u00028yyj\u0011\u0001\u000f\u0006\u0003si\n!bY8mY\u0016\u001cG/[8o\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f9\u0005\r\u0019V-\u001d\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003.\taa]3sm\u0016\u0014\u0018BA\"A\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002uQ,7\u000f^$s_V\u00048i\\8sI&t\u0017\r^8s!J|\u0007/Y4bi\u0016\u001cxJ\u001a4tKR\u001cHk\u001c9jG\u000e{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cG#\u0001$\u0011\u0005\u001dCU\"\u0001\u001e\n\u0005%S$\u0001B+oSRD#aB&\u0011\u00051\u0013V\"A'\u000b\u0005)q%BA(Q\u0003\u001dQW\u000f]5uKJT!!\u0015\u0013\u0002\u000b),h.\u001b;\n\u0005Mk%\u0001\u0002+fgR\u0004")
public class GroupCoordinatorIntegrationTest
extends KafkaServerTestHarness {
    private final CompressionType offsetsTopicCompressionCodec = CompressionType.GZIP;
    private final Properties overridingProps = new Properties();

    public CompressionType offsetsTopicCompressionCodec() {
        return this.offsetsTopicCompressionCodec;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGroupCoordinatorPropagatesOffsetsTopicCompressionCodec() {
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(this.bootstrapServers(this.bootstrapServers$default$1()), "group", "earliest", true, false, 500, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArrayDeserializer(), new ByteArrayDeserializer());
        java.util.Map offsetMap = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__consumer_offsets", 0)), (Object)new OffsetAndMetadata(10L, ""))}))).asJava();
        consumer.commitSync(offsetMap);
        LogManager logManager = ((KafkaServer)this.servers().head()).getLogManager();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!GroupCoordinatorIntegrationTest.$anonfun$testGroupCoordinatorPropagatesOffsetsTopicCompressionCodec$1(logManager)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Commit message not appended in time");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Iterable incorrectCompressionCodecs = (Iterable)((IterableOps)((UnifiedLog)GroupCoordinatorIntegrationTest.getGroupMetadataLogOpt$1(logManager).get()).logSegments().flatMap((Function1 & Serializable)x$4 -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(x$4.log().batches()).asScala().map((Function1 & Serializable)x$5 -> x$5.compressionType()))).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorIntegrationTest.$anonfun$testGroupCoordinatorPropagatesOffsetsTopicCompressionCodec$7(this, x$6)));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)incorrectCompressionCodecs, (String)"Incorrect compression codecs should be empty");
        consumer.close();
    }

    private static final Option getGroupMetadataLogOpt$1(LogManager logManager$1) {
        return logManager$1.getLog(new TopicPartition("__consumer_offsets", 0), logManager$1.getLog$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$testGroupCoordinatorPropagatesOffsetsTopicCompressionCodec$3(LogSegment x$3) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(x$3.log().batches()).asScala().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testGroupCoordinatorPropagatesOffsetsTopicCompressionCodec$2(UnifiedLog x$2) {
        return x$2.logSegments().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorIntegrationTest.$anonfun$testGroupCoordinatorPropagatesOffsetsTopicCompressionCodec$3(x$3)));
    }

    public static final /* synthetic */ boolean $anonfun$testGroupCoordinatorPropagatesOffsetsTopicCompressionCodec$1(LogManager logManager$1) {
        return GroupCoordinatorIntegrationTest.getGroupMetadataLogOpt$1(logManager$1).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GroupCoordinatorIntegrationTest.$anonfun$testGroupCoordinatorPropagatesOffsetsTopicCompressionCodec$2(x$2)));
    }

    public static final /* synthetic */ String $anonfun$testGroupCoordinatorPropagatesOffsetsTopicCompressionCodec$4() {
        return "Commit message not appended in time";
    }

    public static final /* synthetic */ boolean $anonfun$testGroupCoordinatorPropagatesOffsetsTopicCompressionCodec$7(GroupCoordinatorIntegrationTest $this, CompressionType x$6) {
        CompressionType compressionType = x$6;
        CompressionType compressionType2 = $this.offsetsTopicCompressionCodec();
        return compressionType == null ? compressionType2 != null : !compressionType.equals(compressionType2);
    }

    public GroupCoordinatorIntegrationTest() {
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicCompressionCodecProp(), Integer.toString(this.offsetsTopicCompressionCodec().id));
    }
}

