/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.CorruptIndexException;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000554A\u0001F\u000b\u00015!)\u0011\u0005\u0001C\u0001E!IQ\u0005\u0001a\u0001\u0002\u0004%\tA\n\u0005\n_\u0001\u0001\r\u00111A\u0005\u0002AB\u0011B\u000e\u0001A\u0002\u0003\u0005\u000b\u0015B\u0014\t\u0013]\u0002\u0001\u0019!a\u0001\n\u0003A\u0004\"\u0003\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0001>\u0011%y\u0004\u00011A\u0001B\u0003&\u0011\bC\u0004A\u0001\t\u0007I\u0011A!\t\r\u0015\u0003\u0001\u0015!\u0003C\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015)\u0006\u0001\"\u0001H\u0011\u0015Q\u0006\u0001\"\u0001H\u0011\u0015y\u0006\u0001\"\u0001H\u0011\u0015\t\u0007\u0001\"\u0001H\u0011\u0015\u0019\u0007\u0001\"\u0001H\u0011\u0015)\u0007\u0001\"\u0001H\u0011\u00159\u0007\u0001\"\u0001H\u0011\u0015I\u0007\u0001\"\u0001H\u0011\u0015Y\u0007\u0001\"\u0001H\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010V3ti*\u0011acF\u0001\u0004Y><'\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005)\u0012\u0001\u00024jY\u0016,\u0012a\n\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\n!![8\u000b\u00031\nAA[1wC&\u0011a&\u000b\u0002\u0005\r&dW-\u0001\u0005gS2,w\fJ3r)\t\tD\u0007\u0005\u0002\u001de%\u00111'\b\u0002\u0005+:LG\u000fC\u00046\u0007\u0005\u0005\t\u0019A\u0014\u0002\u0007a$\u0013'A\u0003gS2,\u0007%A\u0003j]\u0012,\u00070F\u0001:!\t!#(\u0003\u0002<+\t\u0001BK]1og\u0006\u001cG/[8o\u0013:$W\r_\u0001\nS:$W\r_0%KF$\"!\r \t\u000fU2\u0011\u0011!a\u0001s\u00051\u0011N\u001c3fq\u0002\naa\u001c4gg\u0016$X#\u0001\"\u0011\u0005q\u0019\u0015B\u0001#\u001e\u0005\u0011auN\\4\u0002\u000f=4gm]3uA\u0005)1/\u001a;vaR\t\u0011\u0007\u000b\u0002\u000b\u0013B\u0011!jU\u0007\u0002\u0017*\u0011A*T\u0001\u0004CBL'B\u0001(P\u0003\u001dQW\u000f]5uKJT!\u0001U)\u0002\u000b),h.\u001b;\u000b\u0003I\u000b1a\u001c:h\u0013\t!6J\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003\u0017]\u0003\"A\u0013-\n\u0005e[%!C!gi\u0016\u0014X)Y2i\u0003\t\"Xm\u001d;Q_NLG/[8o'\u0016$8i\u001c:sK\u000e$H._,iK:|\u0005/\u001a8fI\"\u0012A\u0002\u0018\t\u0003\u0015vK!AX&\u0003\tQ+7\u000f^\u0001\u0010i\u0016\u001cHoU1oSRL8\t[3dW\"\u0012Q\u0002X\u0001\u001bi\u0016\u001cH\u000fT1ti>3gm]3u\u001bV\u001cH/\u00138de\u0016\f7/\u001a\u0015\u0003\u001dq\u000bA\u0004^3ti2\u000b7\u000f^(gMN,GoQ1o]>$H)Z2sK\u0006\u001cX\r\u000b\u0002\u00109\u0006qB/Z:u\u0007>dG.Z2u\u0003\n|'\u000f^3e)J\fgn]1di&|gn\u001d\u0015\u0003!q\u000bA\u0002^3tiR\u0013XO\\2bi\u0016D#!\u0005/\u0002'Q,7\u000f^!c_J$X\r\u001a+y]N+'\u000fZ3)\u0005Ia\u0016a\u0004;fgR\u0014VM\\1nK&sG-\u001a=)\u0005Ma\u0006")
public class TransactionIndexTest {
    private File file;
    private TransactionIndex index;
    private final long offset;

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public TransactionIndex index() {
        return this.index;
    }

    public void index_$eq(TransactionIndex x$1) {
        this.index = x$1;
    }

    public long offset() {
        return this.offset;
    }

    @BeforeEach
    public void setup() {
        this.file_$eq(TestUtils.tempFile((String)"kafka", (String)".tmp"));
        this.index_$eq(new TransactionIndex(this.offset(), this.file()));
    }

    @AfterEach
    public void teardown() {
        this.index().close();
    }

    @Test
    public void testPositionSetCorrectlyWhenOpened() {
        .colon.colon abortedTxns = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTxns.foreach(arg_0 -> TransactionIndexTest.$anonfun$testPositionSetCorrectlyWhenOpened$1$adapted(this.index(), arg_0));
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(0L, this.file());
        AbortedTxn anotherAbortedTxn = new AbortedTxn(3L, 50L, 60L, 55L);
        reopenedIndex.append(anotherAbortedTxn);
        Assertions.assertEquals((Object)abortedTxns.$plus$plus((IterableOnce)new .colon.colon((Object)anotherAbortedTxn, (List)Nil$.MODULE$)), (Object)reopenedIndex.allAbortedTxns());
    }

    @Test
    public void testSanityCheck() {
        new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$)))).foreach(arg_0 -> TransactionIndexTest.$anonfun$testSanityCheck$1$adapted(this.index(), arg_0));
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(100L, this.file());
        Assertions.assertThrows(CorruptIndexException.class, () -> reopenedIndex.sanityCheck());
    }

    @Test
    public void testLastOffsetMustIncrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.index().append(new AbortedTxn(0L, 0L, 15L, 11L)));
    }

    @Test
    public void testLastOffsetCannotDecrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.index().append(new AbortedTxn(0L, 0L, 10L, 11L)));
    }

    @Test
    public void testCollectAbortedTransactions() {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTransactions.foreach(arg_0 -> TransactionIndexTest.$anonfun$testCollectAbortedTransactions$1$adapted(this.index(), arg_0));
        TxnIndexSearchResult result = this.index().collectAbortedTxns(0L, 100L);
        Assertions.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assertions.assertFalse((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 32L);
        Assertions.assertEquals((Object)abortedTransactions.take(3), (Object)result.abortedTransactions());
        Assertions.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 35L);
        Assertions.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assertions.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(10L, 35L);
        Assertions.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assertions.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(11L, 35L);
        Assertions.assertEquals((Object)abortedTransactions.slice(1, 4), (Object)result.abortedTransactions());
        Assertions.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(20L, 41L);
        Assertions.assertEquals((Object)abortedTransactions.slice(2, 4), (Object)result.abortedTransactions());
        Assertions.assertFalse((boolean)result.isComplete());
    }

    @Test
    public void testTruncate() {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 2L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 16L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        abortedTransactions.foreach(arg_0 -> TransactionIndexTest.$anonfun$testTruncate$1$adapted(this.index(), arg_0));
        this.index().truncateTo(51L);
        Assertions.assertEquals((Object)abortedTransactions, (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().truncateTo(50L);
        Assertions.assertEquals((Object)abortedTransactions.take(3), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().reset();
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
    }

    @Test
    public void testAbortedTxnSerde() {
        long pid = 983493L;
        long firstOffset = 137L;
        long lastOffset = 299L;
        long lastStableOffset = 200L;
        AbortedTxn abortedTxn = new AbortedTxn(pid, firstOffset, lastOffset, lastStableOffset);
        Assertions.assertEquals((short)AbortedTxn$.MODULE$.CurrentVersion(), (short)abortedTxn.version());
        Assertions.assertEquals((long)pid, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)firstOffset, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)lastOffset, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)lastStableOffset, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRenameIndex() {
        File renamed = TestUtils.tempFile((String)"kafka", (String)".tmp");
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().renameTo(renamed);
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        List abortedTxns = this.index().collectAbortedTxns(0L, 100L).abortedTransactions();
        Assertions.assertEquals((int)2, (int)abortedTxns.size());
        Assertions.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.apply(0)).firstOffset());
        Assertions.assertEquals((long)5L, (long)((AbortedTxn)abortedTxns.apply(1)).firstOffset());
    }

    public TransactionIndexTest() {
        this.offset = 0L;
    }

    public static final /* synthetic */ Object $anonfun$testPositionSetCorrectlyWhenOpened$1$adapted(TransactionIndex eta$0$1$1, AbortedTxn abortedTxn) {
        eta$0$1$1.append(abortedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSanityCheck$1$adapted(TransactionIndex eta$0$1$2, AbortedTxn abortedTxn) {
        eta$0$1$2.append(abortedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCollectAbortedTransactions$1$adapted(TransactionIndex eta$0$1$3, AbortedTxn abortedTxn) {
        eta$0$1$3.append(abortedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncate$1$adapted(TransactionIndex eta$0$1$4, AbortedTxn abortedTxn) {
        eta$0$1$4.append(abortedTxn);
        return BoxedUnit.UNIT;
    }
}

