/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.login.Configuration;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.QuorumTestHarnessFaultHandlerFactory;
import kafka.server.SharedServer;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.tools.StorageTool$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\tug!B\u001e=\u0003\u0003\t\u0005\"\u0002(\u0001\t\u0003y\u0005b\u0002*\u0001\u0005\u0004%\ta\u0015\u0005\u0007/\u0002\u0001\u000b\u0011\u0002+\t\u000fa\u0003!\u0019!C\u0001'\"1\u0011\f\u0001Q\u0001\nQCqA\u0017\u0001C\u0002\u0013\u00051\u000b\u0003\u0004\\\u0001\u0001\u0006I\u0001\u0016\u0005\u00069\u0002!\t\"\u0018\u0005\bI\u0002\u0011\r\u0011\"\u0005f\u0011\u0019)\b\u0001)A\u0005M\")a\u000f\u0001C\to\"9\u0011Q\u0002\u0001\u0005\u0012\u0005=\u0001bCA\u000f\u0001\u0001\u0007\t\u0019!C\u0005\u0003?A1\"!\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00028!Y\u00111\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0011\u0011-\t)\u0005\u0001a\u0001\u0002\u0004%I!a\u0012\t\u0017\u0005=\u0003\u00011AA\u0002\u0013%\u0011\u0011\u000b\u0005\f\u0003+\u0002\u0001\u0019!A!B\u0013\tI\u0005C\u0005\u0002X\u0001\u0011\r\u0011\"\u0001\u0002Z!A\u0011Q\u000e\u0001!\u0002\u0013\tY\u0006C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005M\u0004\u0001\"\u0001\u0002r!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBA=\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003w\u0002A\u0011BA?\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fCq!a$\u0001\t\u0003\t\t\nC\u0004\u0002 \u0002!\t!!)\t\u000f\u0005%\u0006\u0001\"\u0001\u0002\"\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006BBA[\u0001\u0011\u00051\u000bC\u0004\u00028\u0002!\t!!/\t\u000f\u0005E\u0007\u0001\"\u0001\u0002:\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0007bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\n\u0003G\u0004!\u0019!C\u0001\u0003KD\u0001\"!<\u0001A\u0003%\u0011q\u001d\u0005\n\u0003_\u0004!\u0019!C\u0001\u0003cD\u0001\"a@\u0001A\u0003%\u00111\u001f\u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#A\u0011Ba\u000f\u0001#\u0003%\tA!\u0010\t\u0013\tM\u0003!%A\u0005\u0002\tU\u0003\"\u0003B-\u0001E\u0005I\u0011\u0001B.\u0011\u001d\u0011y\u0006\u0001C\u0001\u0003oBqA!\u0019\u0001\t\u0003\t9\bC\u0004\u0003d\u0001!IA!\u001a\t\u000f\t}\u0004\u0001\"\u0003\u0003\u0002\"9!Q\u0011\u0001\u0005\n\u0005u\u0004b\u0002BD\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0005#\u0003A\u0011\u0001BJ\u000f\u001d\u0011\t\f\u0010E\u0001\u0005g3aa\u000f\u001f\t\u0002\tU\u0006B\u0002(6\t\u0003\u00119\fC\u0005\u0003:V\u0012\r\u0011\"\u0001\u0003<\"A!qY\u001b!\u0002\u0013\u0011i\fC\u0004\u0003JV\"\t!a\u001e\t\u000f\tMW\u0007\"\u0001\u0002x\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u000b\u0005ur\u0014AB:feZ,'OC\u0001@\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\"I!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u0019\te.\u001f*fMB\u0011\u0011\nT\u0007\u0002\u0015*\u00111JP\u0001\u0006kRLGn]\u0005\u0003\u001b*\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002!B\u0011\u0011\u000bA\u0007\u0002y\u0005\u0019\"p[\"p]:,7\r^5p]RKW.Z8viV\tA\u000b\u0005\u0002D+&\u0011a\u000b\u0012\u0002\u0004\u0013:$\u0018\u0001\u0006>l\u0007>tg.Z2uS>tG+[7f_V$\b%\u0001\t{WN+7o]5p]RKW.Z8vi\u0006\t\"p[*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u0002+i\\W*\u0019=J]\u001ac\u0017n\u001a5u%\u0016\fX/Z:ug\u00061\"p['bq&sg\t\\5hQR\u0014V-];fgR\u001c\b%A\u0007{W\u0006\u001bGn]#oC\ndW\rZ\u000b\u0002=B\u00191iX1\n\u0005\u0001$%AB(qi&|g\u000e\u0005\u0002DE&\u00111\r\u0012\u0002\b\u0005>|G.Z1o\u0003\t\u001awN\u001c;s_2dWM\u001d'jgR,g.\u001a:TK\u000e,(/\u001b;z!J|Go\\2pYV\ta\r\u0005\u0002hg6\t\u0001N\u0003\u0002jU\u0006!\u0011-\u001e;i\u0015\tYG.\u0001\u0005tK\u000e,(/\u001b;z\u0015\tig.\u0001\u0004d_6lwN\u001c\u0006\u0003\u007f=T!\u0001]9\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0018aA8sO&\u0011A\u000f\u001b\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\f1eY8oiJ|G\u000e\\3s\u0019&\u001cH/\u001a8feN+7-\u001e:jif\u0004&o\u001c;pG>d\u0007%\u0001\fle\u00064GoQ8oiJ|G\u000e\\3s\u0007>tg-[4t)\u0005A\bcA=}}6\t!P\u0003\u0002|\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uT(aA*fcB\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tA!\u001e;jY*\u0011\u0011qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005\u0005!A\u0003)s_B,'\u000f^5fg\u0006yQ.\u001a;bI\u0006$\u0018MV3sg&|g.\u0006\u0002\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002n\u0003/Q!!\u00108\n\t\u0005m\u0011Q\u0003\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006AA/Z:u\u0013:4w.\u0006\u0002\u0002\"A!\u00111EA\u0019\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012aA1qS*!\u00111FA\u0017\u0003\u001dQW\u000f]5uKJT1!a\fr\u0003\u0015QWO\\5u\u0013\u0011\t\u0019$!\n\u0003\u0011Q+7\u000f^%oM>\fA\u0002^3ti&sgm\\0%KF$B!!\u000f\u0002@A\u00191)a\u000f\n\u0007\u0005uBI\u0001\u0003V]&$\b\"CA!\u001d\u0005\u0005\t\u0019AA\u0011\u0003\rAH%M\u0001\ni\u0016\u001cH/\u00138g_\u0002\na\"[7qY\u0016lWM\u001c;bi&|g.\u0006\u0002\u0002JA\u0019\u0011+a\u0013\n\u0007\u00055CH\u0001\u000bRk>\u0014X/\\%na2,W.\u001a8uCRLwN\\\u0001\u0013S6\u0004H.Z7f]R\fG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005M\u0003\"CA!#\u0005\u0005\t\u0019AA%\u0003=IW\u000e\u001d7f[\u0016tG/\u0019;j_:\u0004\u0013\u0001\u00052p_R\u001cHO]1q%\u0016\u001cwN\u001d3t+\t\tY\u0006\u0005\u0004\u0002^\u0005\r\u0014qM\u0007\u0003\u0003?R1!!\u0019{\u0003\u001diW\u000f^1cY\u0016LA!!\u001a\u0002`\tQA*[:u\u0005V4g-\u001a:\u0011\t\u0005M\u0011\u0011N\u0005\u0005\u0003W\n)B\u0001\u000bBa&lUm]:bO\u0016\fe\u000e\u001a,feNLwN\\\u0001\u0012E>|Go\u001d;sCB\u0014VmY8sIN\u0004\u0013aC5t\u0017J\u000bg\r\u001e+fgR$\u0012!Y\u0001\u0012SNT6.T5he\u0006$\u0018n\u001c8UKN$\u0018!D2iK\u000e\\\u0017j\u001d.L)\u0016\u001cH\u000f\u0006\u0002\u0002:\u0005\u00012\r[3dW&\u001b8JU1giR+7\u000f^\u0001\u0005CNT6\u000e\u0006\u0002\u0002\u0000A\u0019\u0011+!!\n\u0007\u0005\rEHA\u000f[_>\\U-\u001a9feF+xN];n\u00136\u0004H.Z7f]R\fG/[8o\u0003\u001d\t7o\u0013*bMR$\"!!#\u0011\u0007E\u000bY)C\u0002\u0002\u000er\u0012\u0011d\u0013*bMR\fVo\u001c:v[&k\u0007\u000f\\3nK:$\u0018\r^5p]\u0006I!p\\8lK\u0016\u0004XM]\u000b\u0003\u0003'\u0003B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033s\u0014A\u0001>l\u0013\u0011\ti*a&\u0003#\u0015k'-\u001a3eK\u0012Tvn\\6fKB,'/\u0001\u0005{W\u000ec\u0017.\u001a8u+\t\t\u0019\u000b\u0005\u0003\u0002\u0016\u0006\u0015\u0016\u0002BAT\u0003/\u0013QbS1gW\u0006T6n\u00117jK:$\u0018A\u0004>l\u00072LWM\u001c;Pe:+H\u000e\\\u0001\u000eC\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0016\u0005\u0005=\u0006\u0003BAK\u0003cKA!a-\u0002\u0018\ni\u0011\tZ7j]j[7\t\\5f]R\faA_6Q_J$\u0018!\u0003>l\u0007>tg.Z2u+\t\tY\f\u0005\u0003\u0002>\u0006-g\u0002BA`\u0003\u000f\u00042!!1E\u001b\t\t\u0019MC\u0002\u0002F\u0002\u000ba\u0001\u0010:p_Rt\u0014bAAe\t\u00061\u0001K]3eK\u001aLA!!4\u0002P\n11\u000b\u001e:j]\u001eT1!!3E\u0003=Q8nQ8o]\u0016\u001cGo\u0014:Ok2d\u0017\u0001E2p]R\u0014x\u000e\u001c7feN+'O^3s+\t\t9\u000eE\u0002R\u00033L1!a7=\u0005A\u0019uN\u001c;s_2dWM]*feZ,'/A\td_:$(o\u001c7mKJ\u001cVM\u001d<feN,\"!!9\u0011\ted\u0018q[\u0001\u0014M\u0006,H\u000e\u001e%b]\u0012dWM\u001d$bGR|'/_\u000b\u0003\u0003O\u00042!UAu\u0013\r\tY\u000f\u0010\u0002%#V|'/^7UKN$\b*\u0019:oKN\u001ch)Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ss\u0006!b-Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ss\u0002\nABZ1vYRD\u0015M\u001c3mKJ,\"!a=\u0011\t\u0005U\u00181`\u0007\u0003\u0003oTA!!?\u0002\u0018\u0005)a-Y;mi&!\u0011Q`A|\u0005AiunY6GCVdG\u000fS1oI2,'/A\u0007gCVdG\u000fS1oI2,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003s\u0011)\u0001C\u0004\u0002\u001e!\u0002\r!!\t)\u0007!\u0012I\u0001\u0005\u0003\u0002$\t-\u0011\u0002\u0002B\u0007\u0003K\u0011!BQ3g_J,W)Y2i\u00031\u0019'/Z1uK\n\u0013xn[3s))\u0011\u0019B!\u0007\u0003$\tE\"Q\u0007\t\u0004#\nU\u0011b\u0001B\fy\tY1*\u00194lC\n\u0013xn[3s\u0011\u001d\u0011Y\"\u000ba\u0001\u0005;\taaY8oM&<\u0007cA)\u0003 %\u0019!\u0011\u0005\u001f\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\n\u0005KI\u0003\u0013!a\u0001\u0005O\tA\u0001^5nKB!!\u0011\u0006B\u0017\u001b\t\u0011YC\u0003\u0002LY&!!q\u0006B\u0016\u0005\u0011!\u0016.\\3\t\u0011\tM\u0012\u0006%AA\u0002\u0005\fqa\u001d;beR,\b\u000fC\u0005\u00038%\u0002\n\u00111\u0001\u0003:\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0005\u0007~\u000bY,\u0001\fde\u0016\fG/\u001a\"s_.,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yD\u000b\u0003\u0003(\t\u00053F\u0001B\"!\u0011\u0011)Ea\u0014\u000e\u0005\t\u001d#\u0002\u0002B%\u0005\u0017\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t5C)\u0001\u0006b]:|G/\u0019;j_:LAA!\u0015\u0003H\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-\r\u0014X-\u0019;f\u0005J|7.\u001a:%I\u00164\u0017-\u001e7uIM*\"Aa\u0016+\u0007\u0005\u0014\t%\u0001\fde\u0016\fG/\u001a\"s_.,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iF\u000b\u0003\u0003:\t\u0005\u0013!E:ikR$wn\u001e8[_>\\U-\u001a9fe\u000692\u000f[;uI><hn\u0013*bMR\u001cuN\u001c;s_2dWM]\u0001\u0012M>\u0014X.\u0019;ESJ,7\r^8sS\u0016\u001cHCBA\u001d\u0005O\u0012)\bC\u0004\u0003j=\u0002\rAa\u001b\u0002\u0017\u0011L'/Z2u_JLWm\u001d\t\u0007\u0005[\u0012\u0019(a/\u000e\u0005\t=$b\u0001B9u\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0004{\n=\u0004b\u0002B<_\u0001\u0007!\u0011P\u0001\u000f[\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t!\r\t&1P\u0005\u0004\u0005{b$AD'fi\u0006\u0004&o\u001c9feRLWm]\u0001\u000f]\u0016<8JU1giF+xN];n)\u0011\tIIa!\t\u000f\u0005u\u0001\u00071\u0001\u0002\"\u0005\u0011b.Z<[_>\\U-\u001a9feF+xN];n\u0003!!X-\u0019:E_^t\u0007f\u0001\u001a\u0003\fB!\u00111\u0005BG\u0013\u0011\u0011y)!\n\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017aK2sK\u0006$XMW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e+p)JLwmZ3s'\u0016\u001c8/[8o\u000bb\u0004\u0018N]=\u0015\t\tU%q\u0014\t\u0005\u0005/\u0013Y*\u0004\u0002\u0003\u001a*\u0019\u0011qR8\n\t\tu%\u0011\u0014\u0002\n5>|7*Z3qKJDqA!)4\u0001\u0004\u0011)*A\u0005{_>\\U-\u001a9fe\":\u0001A!*\u0003,\n5\u0006\u0003BA\u0012\u0005OKAA!+\u0002&\t\u0019A+Y4\u0002\u000bY\fG.^3\"\u0005\t=\u0016aC5oi\u0016<'/\u0019;j_:\f\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t!\t\tVg\u0005\u00026\u0005R\u0011!1W\u0001\u001a5.\u001cE.[3oi\u00163XM\u001c;UQJ,\u0017\rZ*vM\u001aL\u00070\u0006\u0002\u0003>B!!q\u0018Bc\u001b\t\u0011\tM\u0003\u0003\u0003D\u0006\u0015\u0011\u0001\u00027b]\u001eLA!!4\u0003B\u0006Q\"l[\"mS\u0016tG/\u0012<f]R$\u0006N]3bIN+hMZ5yA\u0005Q1/\u001a;Va\u000ec\u0017m]:)\u0007e\u0012i\r\u0005\u0003\u0002$\t=\u0017\u0002\u0002Bi\u0003K\u0011\u0011BQ3g_J,\u0017\t\u001c7\u0002\u001bQ,\u0017M\u001d#po:\u001cE.Y:tQ\rQ$q\u001b\t\u0005\u0003G\u0011I.\u0003\u0003\u0003\\\u0006\u0015\"\u0001C!gi\u0016\u0014\u0018\t\u001c7")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests = Integer.MAX_VALUE;
    private final SecurityProtocol controllerListenerSecurityProtocol = SecurityProtocol.PLAINTEXT;
    private TestInfo testInfo;
    private QuorumImplementation implementation;
    private final ListBuffer<ApiMessageAndVersion> bootstrapRecords = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final QuorumTestHarnessFaultHandlerFactory faultHandlerFactory = new QuorumTestHarnessFaultHandlerFactory(new MockFaultHandler("quorumTestHarnessFaultHandler"));
    private final MockFaultHandler faultHandler = this.faultHandlerFactory().faultHandler();
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @AfterAll
    public static void tearDownClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@AfterAll");
    }

    @BeforeAll
    public static void setUpClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeAll");
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return this.controllerListenerSecurityProtocol;
    }

    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.latest();
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    private QuorumImplementation implementation() {
        return this.implementation;
    }

    private void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public ListBuffer<ApiMessageAndVersion> bootstrapRecords() {
        return this.bootstrapRecords;
    }

    public boolean isKRaftTest() {
        return TestInfoUtils$.MODULE$.isKRaft(this.testInfo());
    }

    public boolean isZkMigrationTest() {
        return TestInfoUtils$.MODULE$.isZkMigrationTest(this.testInfo());
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    public Seq<ControllerServer> controllerServers() {
        if (this.isKRaftTest()) {
            return new .colon.colon((Object)this.asKRaft().controllerServer(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public QuorumTestHarnessFaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public MockFaultHandler faultHandler() {
        return this.faultHandler;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String name = (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(testInfo.getTestMethod())).map((Function1 & Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable)() -> "[unspecified]");
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        return this.implementation().createBroker(config, time, startup, threadNamePrefix);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public Option<String> createBroker$default$4() {
        return None$.MODULE$;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = this.asKRaft();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), Level.WARN);
    }

    private void formatDirectories(scala.collection.immutable.Seq<String> directories, MetaProperties metaProperties) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = null;
        try {
            out = new PrintStream(stream);
            if (StorageTool$.MODULE$.formatCommand(out, directories, metaProperties, this.metadataVersion(), false) != 0) {
                throw new RuntimeException(stream.toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Formatted storage directory(ies) ").append(directories).toString());
        }
        catch (Throwable throwable) {
            if (out != null) {
                out.close();
            }
            stream.close();
            throw throwable;
        }
        out.close();
        stream.close();
    }

    private KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        Seq<Properties> propsList = this.kraftControllerConfigs();
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.apply(0);
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        if (props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()) == null) {
            props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1000");
        }
        int nodeId = Integer.parseInt(props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()));
        File metadataDir = TestUtils$.MODULE$.tempDir();
        MetaProperties metaProperties = new MetaProperties(Uuid.randomUuid().toString(), nodeId);
        this.formatDirectories((scala.collection.immutable.Seq<String>)new .colon.colon((Object)metadataDir.getAbsolutePath(), (List)Nil$.MODULE$), metaProperties);
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        String proto = this.controllerListenerSecurityProtocol().toString();
        props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(11).append("CONTROLLER:").append(proto).toString());
        props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
        props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        KafkaConfig config = new KafkaConfig((Map)props);
        CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, RaftConfig.AddressSpec>>();
        SharedServer sharedServer = new SharedServer(config, metaProperties, Time.SYSTEM, new Metrics(), Option$.MODULE$.apply((Object)new StringBuilder(11).append("Controller_").append(testInfo.getDisplayName()).toString()), controllerQuorumVotersFuture, (FaultHandlerFactory)this.faultHandlerFactory());
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            controllerServer.elem = new ControllerServer(sharedServer, KafkaRaftServer$.MODULE$.configSchema(), BootstrapMetadata.fromVersion((MetadataVersion)this.metadataVersion(), (String)"test harness"));
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(nodeId), new RaftConfig.InetAddressSpec(new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port)))));
            });
            ((ControllerServer)controllerServer.elem).startup();
        }
        catch (Throwable e2) {
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, Level.WARN);
            }
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> sharedServer.stopForController(), (Logging)this, Level.WARN);
            throw e2;
        }
        return new KRaftQuorumImplementation((ControllerServer)controllerServer.elem, this.faultHandlerFactory(), metadataDir, controllerQuorumVotersFuture, metaProperties.clusterId(), this, (FaultHandler)this.faultHandler());
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            zkClient.elem = KafkaZkClient$.MODULE$.apply(zkConnect, BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> JaasUtils.isZkSaslEnabled())), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "ZooKeeperTestHarness", new ZKClientConfig(), "kafka.server", "SessionExpireListener", false);
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem);
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> zookeeper.shutdown(), (Logging)this, Level.WARN);
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, Level.WARN);
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, zkConnect, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        TestUtils$.MODULE$.clearYammerMetrics();
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        this.faultHandler().maybeRethrowFirstException();
    }

    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return anotherZkClient;
    }

    public QuorumTestHarness() {
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
    }
}

