/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.controller.QueueItem;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001B\r\u001b\u0001}A\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\t]\u0001\u0011\t\u0011)A\u0005Q!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00054\u0001\t\u0015\r\u0011\"\u00015\u0011!\u0019\u0005A!A!\u0002\u0013)\u0004\u0002\u0003#\u0001\u0005\u000b\u0007I\u0011A#\t\u0011E\u0003!\u0011!Q\u0001\n\u0019C\u0001B\u0015\u0001\u0003\u0006\u0004%\ta\u0015\u0005\t5\u0002\u0011\t\u0011)A\u0005)\"A1\f\u0001BC\u0002\u0013\u0005A\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003^\u0011!!\u0007A!b\u0001\n\u0003)\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u00111\u0004!Q1A\u0005\u00025D\u0001B\u001f\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\tw\u0002\u0011)\u0019!C\u0001y\"I\u0011\u0011\u0001\u0001\u0003\u0002\u0003\u0006I! \u0005\r\u0003\u0007\u0001!\u0011!Q\u0001\n\u0005\u0015\u00111\u0004\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011!\t9\u0004\u0001b\u0001\n\u00139\u0003bBA\u001d\u0001\u0001\u0006I\u0001\u000b\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fBq!a\u0014\u0001\t\u0003\n9EA\tSKF,Xm\u001d;TK:$G\u000b\u001b:fC\u0012T!a\u0007\u000f\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u001e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rb\u0012!B;uS2\u001c\u0018BA\u0013#\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u00121!\u00138u\u00035\u0019wN\u001c;s_2dWM]%eA\u0005y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eE\u0002*c!J!A\r\u0016\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014!B9vKV,W#A\u001b\u0011\u0007Yjt(D\u00018\u0015\tA\u0014(\u0001\u0006d_:\u001cWO\u001d:f]RT!AO\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0002y\u0005!!.\u0019<b\u0013\tqtGA\u0007CY>\u001c7.\u001b8h#V,W/\u001a\t\u0003\u0001\u0006k\u0011AG\u0005\u0003\u0005j\u0011\u0011\"U;fk\u0016LE/Z7\u0002\rE,X-^3!\u00035qW\r^<pe.\u001cE.[3oiV\ta\t\u0005\u0002H\u001f6\t\u0001J\u0003\u0002J\u0015\u000691\r\\5f]R\u001c(BA\u000fL\u0015\taU*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005AC%!\u0004(fi^|'o[\"mS\u0016tG/\u0001\boKR<xN]6DY&,g\u000e\u001e\u0011\u0002\u0015\t\u0014xn[3s\u001d>$W-F\u0001U!\t)\u0006,D\u0001W\u0015\t9&*\u0001\u0004d_6lwN\\\u0005\u00033Z\u0013AAT8eK\u0006Y!M]8lKJtu\u000eZ3!\u0003\u0019\u0019wN\u001c4jOV\tQ\f\u0005\u0002_C6\tqL\u0003\u0002a9\u000511/\u001a:wKJL!AY0\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u0011!\u0018.\\3\u0016\u0003\u0019\u0004\"aZ5\u000e\u0003!T!a\t,\n\u0005)D'\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\naD]3rk\u0016\u001cHOU1uK\u0006sG-U;fk\u0016$\u0016.\\3NKR\u0014\u0018nY:\u0016\u00039\u0004\"a\u001c=\u000e\u0003AT!!\u001d:\u0002\t\r|'/\u001a\u0006\u0003gR\fq!\\3ue&\u001c7O\u0003\u0002vm\u00061\u00110Y7nKJT\u0011a^\u0001\u0004G>l\u0017BA=q\u0005\u0015!\u0016.\\3s\u0003}\u0011X-];fgR\u0014\u0016\r^3B]\u0012\fV/Z;f)&lW-T3ue&\u001c7\u000fI\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014X#A?\u0011\u0005\u0001s\u0018BA@\u001b\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u0001\u0013gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\b%\u0001\u0003oC6,\u0007\u0003BA\u0004\u0003+qA!!\u0003\u0002\u0012A\u0019\u00111\u0002\u0016\u000e\u0005\u00055!bAA\b=\u00051AH]8pizJ1!a\u0005+\u0003\u0019\u0001&/\u001a3fM&!\u0011qCA\r\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0003\u0016\n\u0007\u0005\rA%\u0001\u0004=S:LGO\u0010\u000b\u0017\u0003C\t\u0019#!\n\u0002(\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u00026A\u0011\u0001\t\u0001\u0005\u0006MM\u0001\r\u0001\u000b\u0005\u0006_M\u0001\r\u0001\r\u0005\u0006gM\u0001\r!\u000e\u0005\u0006\tN\u0001\rA\u0012\u0005\u0006%N\u0001\r\u0001\u0016\u0005\u00067N\u0001\r!\u0018\u0005\u0006IN\u0001\rA\u001a\u0005\u0006YN\u0001\rA\u001c\u0005\u0006wN\u0001\r! \u0005\b\u0003\u0007\u0019\u0002\u0019AA\u0003\u0003=\u0019xnY6fiRKW.Z8vi6\u001b\u0018\u0001E:pG.,G\u000fV5nK>,H/T:!\u0003\u0019!wnV8sWR\u0011\u0011q\b\t\u0004S\u0005\u0005\u0013bAA\"U\t!QK\\5u\u0003-\u0011'o\\6feJ+\u0017\rZ=\u0015\u0005\u0005%\u0003cA\u0015\u0002L%\u0019\u0011Q\n\u0016\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0012N\\5uS\u0006$Xm\u00155vi\u0012|wO\u001c")
public class RequestSendThread
extends ShutdownableThread {
    private final int controllerId;
    private final Function0<Object> controllerEpoch;
    private final BlockingQueue<QueueItem> queue;
    private final NetworkClient networkClient;
    private final Node brokerNode;
    private final KafkaConfig config;
    private final Time time;
    private final Timer requestRateAndQueueTimeMetrics;
    private final StateChangeLogger stateChangeLogger;
    private final int socketTimeoutMs;

    public int controllerId() {
        return this.controllerId;
    }

    public BlockingQueue<QueueItem> queue() {
        return this.queue;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public Node brokerNode() {
        return this.brokerNode;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public Timer requestRateAndQueueTimeMetrics() {
        return this.requestRateAndQueueTimeMetrics;
    }

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private int socketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doWork() {
        QueueItem queueItem = this.queue().take();
        if (queueItem == null) {
            throw new MatchError(null);
        }
        ApiKeys apiKey = queueItem.apiKey();
        AbstractControlRequest.Builder<? extends AbstractControlRequest> requestBuilder = queueItem.request();
        Function1<AbstractResponse, BoxedUnit> callback = queueItem.callback();
        long l = queueItem.enqueueTimeMs();
        this.requestRateAndQueueTimeMetrics().update(this.time().milliseconds() - l, TimeUnit.MILLISECONDS);
        ClientResponse clientResponse = null;
        try {
            boolean isSendSuccessful = false;
            while (this.isRunning() && !isSendSuccessful) {
                void var3_3;
                try {
                    if (!this.brokerReady()) {
                        isSendSuccessful = false;
                        this.pause(100L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    ClientRequest clientRequest = this.networkClient().newClientRequest(this.brokerNode().idString(), (AbstractRequest.Builder)var3_3, this.time().milliseconds(), true);
                    clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time());
                    isSendSuccessful = true;
                }
                catch (Throwable e) {
                    this.warn((Function0<String>)((Function0 & Serializable)() -> RequestSendThread.$anonfun$doWork$1(this, (AbstractControlRequest.Builder)var3_3)), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    this.networkClient().close(this.brokerNode().idString());
                    isSendSuccessful = false;
                    this.pause(100L, TimeUnit.MILLISECONDS);
                }
            }
            if (clientResponse != null) {
                void var4_4;
                ApiKeys api;
                RequestHeader requestHeader = clientResponse.requestHeader();
                ApiKeys apiKeys = api = requestHeader.apiKey();
                ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
                if (apiKeys == null ? apiKeys2 != null : !apiKeys.equals(apiKeys2)) {
                    ApiKeys apiKeys3 = api;
                    ApiKeys apiKeys4 = ApiKeys.STOP_REPLICA;
                    if (apiKeys3 == null ? apiKeys4 != null : !apiKeys3.equals(apiKeys4)) {
                        ApiKeys apiKeys5 = api;
                        ApiKeys apiKeys6 = ApiKeys.UPDATE_METADATA;
                        if (apiKeys5 == null ? apiKeys6 != null : !apiKeys5.equals(apiKeys6)) {
                            void var2_2;
                            throw new KafkaException(new StringBuilder(28).append("Unexpected apiKey received: ").append(var2_2).toString());
                        }
                    }
                }
                AbstractResponse response = clientResponse.responseBody();
                this.stateChangeLogger().withControllerEpoch(this.controllerEpoch.apply$mcI$sp()).trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Received response ").append(response).append(" for request ").append(api).append(" with correlation id ").append(requestHeader.correlationId()).append(" sent to broker ").append(this.brokerNode()).toString());
                if (var4_4 != null) {
                    var4_4.apply((Object)response);
                }
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Controller ").append(this.controllerId()).append(" fails to send a request to broker ").append(this.brokerNode()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
        }
    }

    private boolean brokerReady() {
        try {
            if (!NetworkClientUtils.isReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (long)this.time().milliseconds())) {
                if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.brokerNode(), (Time)this.time(), (long)this.socketTimeoutMs())) {
                    throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeoutMs()).append(" ms").toString());
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Controller ").append(this.controllerId()).append(" connected to ").append(this.brokerNode()).append(" for sending state change requests").toString());
            }
            return true;
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Controller ").append(this.controllerId()).append("'s connection to broker ").append(this.brokerNode()).append(" was unsuccessful").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.networkClient().close(this.brokerNode().idString());
            return false;
        }
    }

    @Override
    public boolean initiateShutdown() {
        if (super.initiateShutdown()) {
            this.networkClient().initiateClose();
            return true;
        }
        return false;
    }

    private final void backoff$1() {
        this.pause(100L, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ String $anonfun$doWork$1(RequestSendThread $this, AbstractControlRequest.Builder requestBuilder$1) {
        return new StringBuilder(77).append("Controller ").append($this.controllerId()).append(" epoch ").append($this.controllerEpoch.apply$mcI$sp()).append(" fails to send request ").append(requestBuilder$1).append(" ").append("to broker ").append($this.brokerNode()).append(". Reconnecting to broker.").toString();
    }

    public RequestSendThread(int controllerId, Function0<Object> controllerEpoch, BlockingQueue<QueueItem> queue, NetworkClient networkClient, Node brokerNode, KafkaConfig config, Time time, Timer requestRateAndQueueTimeMetrics, StateChangeLogger stateChangeLogger, String name) {
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.queue = queue;
        this.networkClient = networkClient;
        this.brokerNode = brokerNode;
        this.config = config;
        this.time = time;
        this.requestRateAndQueueTimeMetrics = requestRateAndQueueTimeMetrics;
        this.stateChangeLogger = stateChangeLogger;
        super(name, true);
        this.logIdent_$eq(new StringBuilder(34).append("[RequestSendThread controllerId=").append(controllerId).append("] ").toString());
        this.socketTimeoutMs = config.controllerSocketTimeoutMs();
    }
}

