/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupCoordinatorAdapter;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.LeaveMemberResponse;
import kafka.coordinator.group.MemberSummary;
import kafka.coordinator.group.SyncGroupResult;
import kafka.server.RequestLocal;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001\u0002\n\u0014\u0001iAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\n\u0019BQ!\u0011\u0001\u0005\u0002\tCQ!\u0015\u0001\u0005\u0002ICQA\u001b\u0001\u0005\u0002-DQA\u001d\u0001\u0005\u0002\tCQ\u0001\u001e\u0001\u0005\u0002\tCQ!\u001e\u0001\u0005\u0002\tCQ!\u001e\u0001\u0005\u0002]Da!a\n\u0001\t\u0003\u0011\u0005BBA\u0016\u0001\u0011\u0005!\t\u0003\u0004\u00020\u0001!\tA\u0011\u0005\u0007\u0003g\u0001A\u0011\u0001\"\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!1\u0011q\t\u0001\u0005\u0002\tCa!a\u0013\u0001\t\u0003\u0011\u0005BBA'\u0001\u0011\u0005!IA\u000eHe>,\boQ8pe\u0012Lg.\u0019;pe\u0006#\u0017\r\u001d;feR+7\u000f\u001e\u0006\u0003)U\tQa\u001a:pkBT!AF\f\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u00021\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011aE\u0001\f[\u0006\\WmQ8oi\u0016DH\u000fF\u0002(iq\u0002\"\u0001\u000b\u001a\u000e\u0003%R!AK\u0016\u0002\u0011I,\u0017/^3tiNT!\u0001L\u0017\u0002\r\r|W.\\8o\u0015\tAbF\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<\u0017BA\u001a*\u00059\u0011V-];fgR\u001cuN\u001c;fqRDQ!\u000e\u0002A\u0002Y\na!\u00199j\u0017\u0016L\bCA\u001c;\u001b\u0005A$BA\u001d,\u0003!\u0001(o\u001c;pG>d\u0017BA\u001e9\u0005\u001d\t\u0005/[&fsNDQ!\u0010\u0002A\u0002y\n!\"\u00199j-\u0016\u00148/[8o!\tar(\u0003\u0002A;\t)1\u000b[8si\u0006)B/Z:u\u0015>LgnQ8ogVlWM]$s_V\u0004H#A\"\u0011\u0005q!\u0015BA#\u001e\u0005\u0011)f.\u001b;)\u0005\r9\u0005C\u0001%P\u001b\u0005I%B\u0001&L\u0003\r\t\u0007/\u001b\u0006\u0003\u00196\u000bqA[;qSR,'O\u0003\u0002Oa\u0005)!.\u001e8ji&\u0011\u0001+\u0013\u0002\u0005)\u0016\u001cH/A\u0007uKN$(j\\5o\u000fJ|W\u000f\u001d\u000b\u0003\u0007NCQ\u0001\u0016\u0003A\u0002y\nqA^3sg&|g\u000e\u000b\u0003\u0005-Vr\u0006CA,]\u001b\u0005A&BA-[\u0003)\tgN\\8uCRLwN\u001c\u0006\u00037.\nQ!\u001e;jYNL!!\u0018-\u0003)\u0005\u0003\u0018nS3z-\u0016\u00148/[8ogN{WO]2fI\u0005y\u0016B\u00011b\u0003)Qu*\u0013(`\u000fJ{U\u000b\u0015\u0006\u0003Eb\nq!\u00119j\u0017\u0016L8\u000f\u000b\u0002\u0005IB\u0011Q\r[\u0007\u0002M*\u0011qmS\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005%4'!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006iA/Z:u'ft7m\u0012:pkB$\"a\u00117\t\u000bQ+\u0001\u0019\u0001 )\t\u00151VG\u001c\u0013\u0002_&\u0011\u0001/Y\u0001\u000b'fs5iX$S\u001fV\u0003\u0006FA\u0003e\u00035!Xm\u001d;IK\u0006\u0014HOY3bi\"\u0012aaR\u0001\u000fi\u0016\u001cH\u000fT3bm\u0016<%o\\;q\u00039!Xm\u001d;MSN$xI]8vaND#\u0001C$\u0015\t\rC\u0018Q\u0004\u0005\u0006s&\u0001\rA_\u0001\rgR\fG/Z:GS2$XM\u001d\t\u0006w\u0006\u001d\u0011Q\u0002\b\u0004y\u0006\rabA?\u0002\u00025\taP\u0003\u0002\u00003\u00051AH]8pizJ\u0011AH\u0005\u0004\u0003\u000bi\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\tYA\u0001\u0003MSN$(bAA\u0003;A!\u0011qBA\f\u001d\u0011\t\t\"a\u0005\u0011\u0005ul\u0012bAA\u000b;\u00051\u0001K]3eK\u001aLA!!\u0007\u0002\u001c\t11\u000b\u001e:j]\u001eT1!!\u0006\u001e\u0011\u001d\ty\"\u0003a\u0001\u0003C\tA#\u001a=qK\u000e$X\rZ*uCR,7OR5mi\u0016\u0014\bCBA\b\u0003G\ti!\u0003\u0003\u0002&\u0005m!aA*fi\u0006\tB/Z:u\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9)\u0005)9\u0015\u0001\u0005;fgR$U\r\\3uK\u001e\u0013x.\u001e9tQ\tYq)A\nuKN$h)\u001a;dQ\u0006cGn\u00144gg\u0016$8\u000f\u000b\u0002\r\u000f\u0006\u0001B/Z:u\r\u0016$8\r[(gMN,Go\u001d\u0015\u0003\u001b\u001d\u000b\u0011\u0003^3ti\u000e{W.\\5u\u001f\u001a47/\u001a;t)\r\u0019\u00151\b\u0005\u0006):\u0001\rA\u0010\u0015\u0006\u001dY+\u0014q\b\u0013\u0003\u0003\u0003J1!a\u0011b\u00035yeIR*F)~\u001bu*T'J)\"\u0012a\u0002Z\u0001\u001fi\u0016\u001cHoQ8n[&$HK]1og\u0006\u001cG/[8oC2|eMZ:fiND#aD$\u0002#Q,7\u000f\u001e#fY\u0016$Xm\u00144gg\u0016$8/\u0001\u0013uKN$H)\u001a7fi\u0016|eMZ:fiN<\u0016\u000e\u001e5He>,\b\u000fT3wK2,%O]8sQ\t\tr\t")
public class GroupCoordinatorAdapterTest {
    private RequestContext makeContext(ApiKeys apiKey, short apiVersion) {
        return new RequestContext(new RequestHeader(apiKey, apiVersion, "client", 0), "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
    }

    @Test
    public void testJoinConsumerGroup() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.CONSUMER_GROUP_HEARTBEAT, ApiKeys.CONSUMER_GROUP_HEARTBEAT.latestVersion());
        ConsumerGroupHeartbeatRequestData request = new ConsumerGroupHeartbeatRequestData().setGroupId("group");
        CompletableFuture future = adapter.consumerGroupHeartbeat(ctx, request);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, UnsupportedVersionException.class);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.JOIN_GROUP)
    public void testJoinGroup(short version) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.JOIN_GROUP, version);
        JoinGroupRequestData request = new JoinGroupRequestData().setGroupId("group").setMemberId("member").setProtocolType("consumer").setRebalanceTimeoutMs(1000).setSessionTimeoutMs(2000).setReason("reason").setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection(CollectionConverters$.MODULE$.IteratorHasAsJava(new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("first").setMetadata("first".getBytes()), (List)new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("second").setMetadata("second".getBytes()), (List)Nil$.MODULE$)).iterator()).asJava()));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.joinGroup(ctx, request, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedProtocols = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleJoinGroup((String)ArgumentMatchers.eq((Object)request.groupId()), (String)ArgumentMatchers.eq((Object)request.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((version >= 4 ? 1 : 0) != 0), ArgumentMatchers.eq((version >= 9 ? 1 : 0) != 0), (String)ArgumentMatchers.eq((Object)ctx.clientId()), (String)ArgumentMatchers.eq((Object)InetAddress.getLocalHost().toString()), ArgumentMatchers.eq((int)request.rebalanceTimeoutMs()), ArgumentMatchers.eq((int)request.sessionTimeoutMs()), (String)ArgumentMatchers.eq((Object)request.protocolType()), (List)capturedProtocols.capture(), (Function1)capturedCallback.capture(), (Option)ArgumentMatchers.eq((Object)new Some((Object)"reason")), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        Assertions.assertEquals((Object)new .colon.colon((Object)new Tuple2((Object)"first", (Object)"first"), (List)new .colon.colon((Object)new Tuple2((Object)"second", (Object)"second"), (List)Nil$.MODULE$)), (Object)((List)capturedProtocols.getValue()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                byte[] metadata = (byte[])x0$1._2();
                return new Tuple2((Object)name, (Object)new String(metadata));
            }
            throw new MatchError(null);
        }));
        ((Function1)capturedCallback.getValue()).apply((Object)new JoinGroupResult((List)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("member").setMetadata("member".getBytes()).setGroupInstanceId("instance"), (List)Nil$.MODULE$), "member", 10, (Option)new Some((Object)"consumer"), (Option)new Some((Object)"range"), "leader", true, Errors.UNKNOWN_MEMBER_ID));
        JoinGroupResponseData expectedData = new JoinGroupResponseData().setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("member").setMetadata("member".getBytes()).setGroupInstanceId("instance"), (List)Nil$.MODULE$)).asJava()).setMemberId("member").setGenerationId(10).setProtocolType("consumer").setProtocolName("range").setLeader("leader").setSkipAssignment(true).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.SYNC_GROUP)
    public void testSyncGroup(short version) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.SYNC_GROUP, version);
        SyncGroupRequestData data = new SyncGroupRequestData().setGroupId("group").setMemberId("member1").setGroupInstanceId("instance").setProtocolType("consumer").setProtocolName("range").setGenerationId(10).setAssignments(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId("member1").setAssignment("member1".getBytes()), (List)new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId("member2").setAssignment("member2".getBytes()), (List)Nil$.MODULE$))).asJava());
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.syncGroup(ctx, data, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedAssignment = ArgumentCaptor.forClass(scala.collection.immutable.Map.class);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleSyncGroup((String)ArgumentMatchers.eq((Object)data.groupId()), ArgumentMatchers.eq((int)data.generationId()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.protocolType())), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.protocolName())), (Option)ArgumentMatchers.eq((Object)new Some((Object)data.groupInstanceId())), (Map)capturedAssignment.capture(), (Function1)capturedCallback.capture(), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member1"), (Object)"member1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member2"), (Object)"member2")})), (Object)((MapOps)capturedAssignment.getValue()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String member = (String)x0$1._1();
                byte[] metadata = (byte[])x0$1._2();
                return new Tuple2((Object)member, (Object)new String(metadata));
            }
            throw new MatchError(null);
        }));
        Some x$2 = new Some((Object)"consumer");
        Some x$3 = new Some((Object)"range");
        byte[] x$4 = "member1".getBytes();
        ((Function1)capturedCallback.getValue()).apply((Object)new SyncGroupResult((Option)x$2, (Option)x$3, x$4, Errors.NONE));
        SyncGroupResponseData expectedResponseData = new SyncGroupResponseData().setErrorCode(Errors.NONE.code()).setProtocolType("consumer").setProtocolName("range").setAssignment("member1".getBytes());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedResponseData, future.get());
    }

    @Test
    public void testHeartbeat() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.HEARTBEAT, ApiKeys.HEARTBEAT.latestVersion());
        HeartbeatRequestData data = new HeartbeatRequestData().setGroupId("group").setMemberId("member1").setGenerationId(0);
        CompletableFuture future = adapter.heartbeat(ctx, data);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleHeartbeat((String)ArgumentMatchers.eq((Object)data.groupId()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((int)data.generationId()), (Function1)capturedCallback.capture());
        Assertions.assertFalse((boolean)future.isDone());
        ((Function1)capturedCallback.getValue()).apply((Object)Errors.NONE);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)new HeartbeatResponseData(), future.get());
    }

    public void testLeaveGroup() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.LEAVE_GROUP, ApiKeys.LEAVE_GROUP.latestVersion());
        LeaveGroupRequestData data = new LeaveGroupRequestData().setGroupId("group").setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new LeaveGroupRequestData.MemberIdentity().setMemberId("member-1").setGroupInstanceId("instance-1"), (List)new .colon.colon((Object)new LeaveGroupRequestData.MemberIdentity().setMemberId("member-2").setGroupInstanceId("instance-2"), (List)Nil$.MODULE$))).asJava());
        CompletableFuture future = adapter.leaveGroup(ctx, data);
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleLeaveGroup((String)ArgumentMatchers.eq((Object)data.groupId()), (List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.ListHasAsScala(data.members()).asScala().toList()), (Function1)capturedCallback.capture());
        Assertions.assertFalse((boolean)future.isDone());
        ((Function1)capturedCallback.getValue()).apply((Object)new LeaveGroupResult(Errors.NONE, (List)new .colon.colon((Object)new LeaveMemberResponse("member-1", (Option)new Some((Object)"instance-1"), Errors.NONE), (List)new .colon.colon((Object)new LeaveMemberResponse("member-2", (Option)new Some((Object)"instance-2"), Errors.NONE), (List)Nil$.MODULE$))));
        LeaveGroupResponseData expectedData = new LeaveGroupResponseData().setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new LeaveGroupResponseData.MemberResponse().setMemberId("member-1").setGroupInstanceId("instance-1"), (List)new .colon.colon((Object)new LeaveGroupResponseData.MemberResponse().setMemberId("member-2").setGroupInstanceId("instance-2"), (List)Nil$.MODULE$))).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @Test
    public void testListGroups() {
        this.testListGroups(null, (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
        this.testListGroups((List<String>)Nil$.MODULE$, (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
        this.testListGroups((List<String>)new .colon.colon((Object)"Stable", (List)Nil$.MODULE$), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Stable"}))));
    }

    public void testListGroups(List<String> statesFilter, scala.collection.immutable.Set<String> expectedStatesFilter) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.LIST_GROUPS, ApiKeys.LIST_GROUPS.latestVersion());
        ListGroupsRequestData data = new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava(statesFilter).asJava());
        Mockito.when((Object)groupCoordinator.handleListGroups(expectedStatesFilter)).thenReturn((Object)new Tuple2((Object)Errors.NOT_COORDINATOR, (Object)new .colon.colon((Object)new GroupOverview("group1", "protocol1", "Stable"), (List)new .colon.colon((Object)new GroupOverview("group2", "qwerty", "Empty"), (List)Nil$.MODULE$))));
        CompletableFuture future = adapter.listGroups(ctx, data);
        Assertions.assertTrue((boolean)future.isDone());
        ListGroupsResponseData expectedData = new ListGroupsResponseData().setErrorCode(Errors.NOT_COORDINATOR.code()).setGroups(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId("group1").setGroupState("Stable").setProtocolType("protocol1"), (List)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId("group2").setGroupState("Empty").setProtocolType("qwerty"), (List)Nil$.MODULE$))).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @Test
    public void testDescribeGroup() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        String groupId1 = "group-1";
        String groupId2 = "group-2";
        GroupSummary groupSummary1 = new GroupSummary("Stable", "consumer", "roundrobin", (List)new .colon.colon((Object)new MemberSummary("memberid", (Option)new Some((Object)"instanceid"), "clientid", "clienthost", "metadata".getBytes(), "assignment".getBytes()), (List)Nil$.MODULE$));
        Mockito.when((Object)groupCoordinator.handleDescribeGroup(groupId1)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)groupSummary1));
        Mockito.when((Object)groupCoordinator.handleDescribeGroup(groupId2)).thenReturn((Object)new Tuple2((Object)Errors.NOT_COORDINATOR, (Object)GroupCoordinator$.MODULE$.EmptyGroup()));
        RequestContext ctx = this.makeContext(ApiKeys.DESCRIBE_GROUPS, ApiKeys.DESCRIBE_GROUPS.latestVersion());
        CompletableFuture future = adapter.describeGroups(ctx, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)groupId1, (List)new .colon.colon((Object)groupId2, (List)Nil$.MODULE$))).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId1).setErrorCode(Errors.NONE.code()).setProtocolType(groupSummary1.protocolType()).setProtocolData(groupSummary1.protocol()).setGroupState(groupSummary1.state()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(((MemberSummary)groupSummary1.members().head()).memberId()).setGroupInstanceId((String)((MemberSummary)groupSummary1.members().head()).groupInstanceId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setClientId(((MemberSummary)groupSummary1.members().head()).clientId()).setClientHost(((MemberSummary)groupSummary1.members().head()).clientHost()).setMemberMetadata(((MemberSummary)groupSummary1.members().head()).metadata()).setMemberAssignment(((MemberSummary)groupSummary1.members().head()).assignment()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId2).setErrorCode(Errors.NOT_COORDINATOR.code()), (List)Nil$.MODULE$))).asJava(), future.get());
    }

    @Test
    public void testDeleteGroups() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        RequestContext ctx = this.makeContext(ApiKeys.DELETE_GROUPS, ApiKeys.DELETE_GROUPS.latestVersion());
        .colon.colon groupIds = new .colon.colon((Object)"group-1", (List)new .colon.colon((Object)"group-2", (List)new .colon.colon((Object)"group-3", (List)Nil$.MODULE$)));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        Mockito.when((Object)groupCoordinator.handleDeleteGroups((Set)groupIds.toSet(), new RequestLocal(bufferSupplier))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-1"), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-2"), (Object)Errors.NOT_COORDINATOR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-3"), (Object)Errors.INVALID_GROUP_ID)})));
        CompletableFuture future = adapter.deleteGroups(ctx, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)groupIds).asJava(), bufferSupplier);
        Assertions.assertTrue((boolean)future.isDone());
        DeleteGroupsResponseData.DeletableGroupResultCollection expectedResults = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        expectedResults.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-1").setErrorCode(Errors.NONE.code()));
        expectedResults.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-2").setErrorCode(Errors.NOT_COORDINATOR.code()));
        expectedResults.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-3").setErrorCode(Errors.INVALID_GROUP_ID.code()));
        Assertions.assertEquals((Object)expectedResults, future.get());
    }

    @Test
    public void testFetchAllOffsets() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        Mockito.when((Object)groupCoordinator.handleFetchOffsets("group", true, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)new OffsetFetchResponse.PartitionData(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "foo", Errors.NONE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), (Object)new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.UNKNOWN_TOPIC_OR_PARTITION)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)new OffsetFetchResponse.PartitionData(200L, Optional.empty(), "", Errors.NONE))}))));
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_FETCH, ApiKeys.OFFSET_FETCH.latestVersion());
        CompletableFuture future = adapter.fetchAllOffsets(ctx, "group", true);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(foo0.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo0.partition()).setCommittedOffset(100L).setCommittedLeaderEpoch(1).setMetadata("foo").setErrorCode(Errors.NONE.code()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo1.partition()).setCommittedOffset(200L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(bar1.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(bar1.partition()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).sortWith((Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(x$1.name()), x$2.name()))), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)future.get()).asScala().toList().sortWith((Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(x$3.name()), x$4.name()))));
    }

    @Test
    public void testFetchOffsets() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        Mockito.when((Object)groupCoordinator.handleFetchOffsets("group", true, (Option)new Some((Object)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar1, (List)Nil$.MODULE$)))))).thenReturn((Object)new Tuple2((Object)Errors.NONE, Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)new OffsetFetchResponse.PartitionData(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "foo", Errors.NONE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), (Object)new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.UNKNOWN_TOPIC_OR_PARTITION)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)new OffsetFetchResponse.PartitionData(200L, Optional.empty(), "", Errors.NONE))}))));
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_FETCH, ApiKeys.OFFSET_FETCH.latestVersion());
        CompletableFuture future = adapter.fetchOffsets(ctx, "group", CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(foo0.topic()).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(foo0.partition()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(foo1.partition()), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(bar1.topic()).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(bar1.partition()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$))).asJava(), true);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(foo0.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo0.partition()).setCommittedOffset(100L).setCommittedLeaderEpoch(1).setMetadata("foo").setErrorCode(Errors.NONE.code()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(foo1.partition()).setCommittedOffset(200L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(bar1.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(bar1.partition()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).sortWith((Function2 & Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(x$5.name()), x$6.name()))), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)future.get()).asScala().toList().sortWith((Function2 & Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(x$7.name()), x$8.name()))));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_COMMIT)
    public void testCommitOffsets(short version) {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        MockTime time = new MockTime();
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, (Time)time);
        long now = time.milliseconds();
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_COMMIT, version);
        OffsetCommitRequestData data = new OffsetCommitRequestData().setGroupId("group").setMemberId("member").setGenerationId(10).setRetentionTimeMs(1000L).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitRequestData.OffsetCommitRequestTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L).setCommitTimestamp(now).setCommittedLeaderEpoch(1), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.commitOffsets(ctx, data, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleCommitOffsets((String)ArgumentMatchers.eq((Object)data.groupId()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((int)data.generationId()), (scala.collection.immutable.Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)new OffsetAndMetadata(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "", now, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(now + 1000L)))))}))), (Function1)capturedCallback.capture(), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        ((Function1)capturedCallback.getValue()).apply(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)Errors.NONE)})));
        OffsetCommitResponseData expectedResponseData = new OffsetCommitResponseData().setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitResponseData.OffsetCommitResponseTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedResponseData, future.get());
    }

    @Test
    public void testCommitTransactionalOffsets() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        MockTime time = new MockTime();
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, (Time)time);
        long now = time.milliseconds();
        RequestContext ctx = this.makeContext(ApiKeys.TXN_OFFSET_COMMIT, ApiKeys.TXN_OFFSET_COMMIT.latestVersion());
        TxnOffsetCommitRequestData data = new TxnOffsetCommitRequestData().setGroupId("group").setMemberId("member").setGenerationId(10).setProducerEpoch((short)1).setProducerId(2L).setTransactionalId("transaction-id").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L).setCommittedLeaderEpoch(1), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        BufferSupplier bufferSupplier = BufferSupplier.create();
        CompletableFuture future = adapter.commitTransactionalOffsets(ctx, data, bufferSupplier);
        Assertions.assertFalse((boolean)future.isDone());
        ArgumentCaptor capturedCallback = ArgumentCaptor.forClass(Function1.class);
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).handleTxnCommitOffsets((String)ArgumentMatchers.eq((Object)data.groupId()), ArgumentMatchers.eq((long)data.producerId()), ArgumentMatchers.eq((short)data.producerEpoch()), (String)ArgumentMatchers.eq((Object)data.memberId()), (Option)ArgumentMatchers.eq((Object)None$.MODULE$), ArgumentMatchers.eq((int)data.generationId()), (scala.collection.immutable.Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)new OffsetAndMetadata(100L, Optional.of(Predef$.MODULE$.int2Integer(1)), "", now, (Option)None$.MODULE$))}))), (Function1)capturedCallback.capture(), (RequestLocal)ArgumentMatchers.eq((Object)new RequestLocal(bufferSupplier)));
        ((Function1)capturedCallback.getValue()).apply(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo")), (Object)Errors.NONE)})));
        TxnOffsetCommitResponseData expectedData = new TxnOffsetCommitResponseData().setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    public void testDeleteOffsets() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar0 = new TopicPartition("bar", 0);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_DELETE, ApiKeys.OFFSET_DELETE.latestVersion());
        OffsetDeleteRequestData data = new OffsetDeleteRequestData().setGroupId("group").setTopics(new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(1), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("bar").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(1), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$))).asJava().iterator()));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        Mockito.when((Object)groupCoordinator.handleDeleteOffsets(data.groupId(), (Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)new .colon.colon((Object)bar1, (List)Nil$.MODULE$)))), new RequestLocal(bufferSupplier))).thenReturn((Object)new Tuple2((Object)Errors.NONE, Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar0), (Object)Errors.GROUP_SUBSCRIBED_TO_TOPIC), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), (Object)Errors.GROUP_SUBSCRIBED_TO_TOPIC)}))));
        CompletableFuture future = adapter.deleteOffsets(ctx, data, bufferSupplier);
        OffsetDeleteResponseData expectedData = new OffsetDeleteResponseData().setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("foo").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()), (List)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(1).setErrorCode(Errors.NONE.code()), (List)Nil$.MODULE$))).asJava().iterator())), (List)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("bar").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code()), (List)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(1).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code()), (List)Nil$.MODULE$))).asJava().iterator())), (List)Nil$.MODULE$))).asJava().iterator()));
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedData, future.get());
    }

    @Test
    public void testDeleteOffsetsWithGroupLevelError() {
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        GroupCoordinatorAdapter adapter = new GroupCoordinatorAdapter(groupCoordinator, Time.SYSTEM);
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        RequestContext ctx = this.makeContext(ApiKeys.OFFSET_DELETE, ApiKeys.OFFSET_DELETE.latestVersion());
        OffsetDeleteRequestData data = new OffsetDeleteRequestData().setGroupId("group").setTopics(new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0), (List)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(1), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$)).asJava().iterator()));
        BufferSupplier bufferSupplier = BufferSupplier.create();
        Mockito.when((Object)groupCoordinator.handleDeleteOffsets(data.groupId(), (Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)Nil$.MODULE$)), new RequestLocal(bufferSupplier))).thenReturn((Object)new Tuple2((Object)Errors.INVALID_GROUP_ID, (Object)Predef$.MODULE$.Map().empty()));
        CompletableFuture future = adapter.deleteOffsets(ctx, data, bufferSupplier);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, InvalidGroupIdException.class);
    }
}

