/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import kafka.admin.BrokerMetadata;
import kafka.controller.StateChangeLogger;
import kafka.server.CachedControllerId;
import kafka.server.FinalizedFeaturesAndEpoch;
import kafka.server.KRaftCachedControllerId$;
import kafka.server.MetadataCache;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.MetadataVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rud\u0001\u0002\u001a4\u0001iB\u0001b\u0014\u0001\u0003\u0006\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0011)A\u0005#\")Q\u000b\u0001C\u0001-\"9\u0011\f\u0001a\u0001\n\u0013Q\u0006b\u00024\u0001\u0001\u0004%Ia\u001a\u0005\u0007[\u0002\u0001\u000b\u0015B.\t\u000fI\u0004!\u0019!C\u0005g\"1!\u0010\u0001Q\u0001\nQDQa\u001f\u0001\u0005\nqDq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBAm\u0001\u0011\u0005\u00131\u001c\u0005\n\u0003\u007f\u0004\u0011\u0013!C\u0001\u0005\u0003A\u0011Ba\u0006\u0001#\u0003%\tA!\u0001\t\u000f\te\u0001\u0001\"\u0011\u0003\u001c!9!Q\u0004\u0001\u0005B\t}\u0001b\u0002B\u0016\u0001\u0011\u0005#Q\u0006\u0005\b\u0005o\u0001A\u0011\tB\u001d\u0011\u001d\u0011\t\u0005\u0001C!\u0005\u0007BqAa\u0012\u0001\t\u0003\u0011I\u0005C\u0004\u0003N\u0001!\tAa\u0014\t\u000f\tM\u0003\u0001\"\u0011\u0003V!9!1\u000b\u0001\u0005\n\t%\u0004b\u0002B7\u0001\u0011\u0005#q\u000e\u0005\b\u0005k\u0002A\u0011\tB<\u0011\u001d\u0011i\b\u0001C!\u0005\u007fBqAa&\u0001\t\u0003\u0012I\nC\u0004\u0003 \u0002!\tE!)\t\u000f\t%\u0006\u0001\"\u0011\u0003,\"9!q\u0016\u0001\u0005B\tE\u0006b\u0002B]\u0001\u0011\u0005#1\u0018\u0005\b\u0005\u0007\u0004A\u0011\tBc\u0011\u001d\u0011\t\u000e\u0001C!\u0005'DqA!8\u0001\t\u0003\u0012y\u000eC\u0004\u0003b\u0002!IAa9\t\u000f\t\u001d\b\u0001\"\u0001\u0003j\"9!Q\u001f\u0001\u0005B\t]\bbBB\u0003\u0001\u0011\u00051q\u0001\u0005\b\u0007\u0013\u0001A\u0011AB\u0006\u0011\u001d\u0019\t\u0002\u0001C!\u0007'Aqa!\u0005\u0001\t\u0003\u001a9\u0002C\u0004\u0004\u001c\u0001!\ta!\b\t\u000f\r\r\u0002\u0001\"\u0011\u0004&!911\b\u0001\u0005\u0002\ru\u0002bBB)\u0001\u0011\u000511\u000b\u0005\b\u0007G\u0002A\u0011IB3\u0011\u001d\u0019\u0019\b\u0001C!\u0007k\u0012!c\u0013*bMRlU\r^1eCR\f7)Y2iK*\u0011A'N\u0001\t[\u0016$\u0018\rZ1uC*\u0011agN\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003a\nQa[1gW\u0006\u001c\u0001aE\u0003\u0001w\u0005+5\n\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0005\u000ek\u0011!N\u0005\u0003\tV\u0012Q\"T3uC\u0012\fG/Y\"bG\",\u0007C\u0001$J\u001b\u00059%B\u0001%8\u0003\u0015)H/\u001b7t\u0013\tQuIA\u0004M_\u001e<\u0017N\\4\u0011\u00051kU\"A\u001a\n\u00059\u001b$\u0001E\"p]\u001aLwMU3q_NLGo\u001c:z\u0003!\u0011'o\\6fe&#W#A)\u0011\u0005q\u0012\u0016BA*>\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\na\u0001P5oSRtDCA,Y!\ta\u0005\u0001C\u0003P\u0007\u0001\u0007\u0011+A\u0007`GV\u0014(/\u001a8u\u00136\fw-Z\u000b\u00027B\u0011A\fZ\u0007\u0002;*\u0011alX\u0001\u0006S6\fw-\u001a\u0006\u0003q\u0001T!!\u00192\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0017aA8sO&\u0011Q-\u0018\u0002\u000e\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\u0002#}\u001bWO\u001d:f]RLU.Y4f?\u0012*\u0017\u000f\u0006\u0002iWB\u0011A([\u0005\u0003Uv\u0012A!\u00168ji\"9A.BA\u0001\u0002\u0004Y\u0016a\u0001=%c\u0005qqlY;se\u0016tG/S7bO\u0016\u0004\u0003F\u0001\u0004p!\ta\u0004/\u0003\u0002r{\tAao\u001c7bi&dW-A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ,\u0012\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003o^\n!bY8oiJ|G\u000e\\3s\u0013\tIhOA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\f!c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3sA\u0005AR.Y=cK\u001aKG\u000e^3s\u00032Lg/\u001a*fa2L7-Y:\u0015\u0013u\f9\"!\u0007\u0002$\u0005]\u0002#\u0002@\u0002\b\u0005-Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0005kRLGN\u0003\u0002\u0002\u0006\u0005!!.\u0019<b\u0013\r\tIa \u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\u0011\t\t\"a\u0001\u0002\t1\fgnZ\u0005\u0005\u0003+\tyAA\u0004J]R,w-\u001a:\t\u000byK\u0001\u0019A.\t\u000f\u0005m\u0011\u00021\u0001\u0002\u001e\u00059!M]8lKJ\u001c\b\u0003\u0002\u001f\u0002 EK1!!\t>\u0005\u0015\t%O]1z\u0011\u001d\t)#\u0003a\u0001\u0003O\tA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0004oKR<xN]6\u000b\u0007\u0005Er,\u0001\u0004d_6lwN\\\u0005\u0005\u0003k\tYC\u0001\u0007MSN$XM\\3s\u001d\u0006lW\rC\u0004\u0002:%\u0001\r!a\u000f\u00025\u0019LG\u000e^3s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\u0011\u0007q\ni$C\u0002\u0002@u\u0012qAQ8pY\u0016\fg.\u0001\u0007dkJ\u0014XM\u001c;J[\u0006<W\rF\u0001\\\u0003Q9W\r\u001e)beRLG/[8o\u001b\u0016$\u0018\rZ1uCRa\u0011\u0011JAG\u0003\u001f\u000b\u0019+!*\u0002*B)A(a\u0013\u0002P%\u0019\u0011QJ\u001f\u0003\r=\u0003H/[8o!\u0019\t\t&!\u0019\u0002h9!\u00111KA/\u001d\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-s\u00051AH]8pizJ\u0011AP\u0005\u0004\u0003?j\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003G\n)G\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\ty&\u0010\t\u0005\u0003S\n9I\u0004\u0003\u0002l\u0005\u0005e\u0002BA7\u0003{rA!a\u001c\u0002|9!\u0011\u0011OA=\u001d\u0011\t\u0019(a\u001e\u000f\t\u0005U\u0013QO\u0005\u0002G&\u0011\u0011MY\u0005\u0003q\u0001L1!!\r`\u0013\u0011\ty(a\f\u0002\u000f5,7o]1hK&!\u00111QAC\u0003QiU\r^1eCR\f'+Z:q_:\u001cX\rR1uC*!\u0011qPA\u0018\u0013\u0011\tI)a#\u000335+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u0003\u0007\u000b)\tC\u0003_\u0017\u0001\u00071\fC\u0004\u0002\u0012.\u0001\r!a%\u0002\u0013Q|\u0007/[2OC6,\u0007\u0003BAK\u0003;sA!a&\u0002\u001aB\u0019\u0011QK\u001f\n\u0007\u0005mU(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\u000b\tK\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037k\u0004bBA\u0013\u0017\u0001\u0007\u0011q\u0005\u0005\b\u0003O[\u0001\u0019AA\u001e\u0003e)'O]8s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\t\u000f\u0005-6\u00021\u0001\u0002<\u0005IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t\u0003I9W\r^(gM2Lg.\u001a*fa2L7-Y:\u0015\u000fu\f\t,a-\u0002B\")a\f\u0004a\u00017\"9\u0011Q\u0017\u0007A\u0002\u0005]\u0016!\u00039beRLG/[8o!\u0011\tI,!0\u000e\u0005\u0005m&B\u0001\u001b`\u0013\u0011\ty,a/\u0003+A\u000b'\u000f^5uS>t'+Z4jgR\u0014\u0018\r^5p]\"9\u0011Q\u0005\u0007A\u0002\u0005\u001d\u0012\u0001E4fi\u0006c\u0017N^3F]\u0012\u0004x.\u001b8u)!\t9-!5\u0002T\u0006]\u0007#\u0002\u001f\u0002L\u0005%\u0007\u0003BAf\u0003\u001bl!!a\f\n\t\u0005=\u0017q\u0006\u0002\u0005\u001d>$W\rC\u0003_\u001b\u0001\u00071\f\u0003\u0004\u0002V6\u0001\r!U\u0001\u0003S\u0012Dq!!\n\u000e\u0001\u0004\t9#\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCRQ\u0011Q\\Ax\u0003s\fY0!@\u0011\r\u0005}\u0017Q]Au\u001b\t\t\tOC\u0002\u0002dv\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9/!9\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002j\u0005-\u0018\u0002BAw\u0003\u0017\u0013Q#T3uC\u0012\fG/\u0019*fgB|gn]3U_BL7\rC\u0004\u0002r:\u0001\r!a=\u0002\rQ|\u0007/[2t!\u0019\ty.!>\u0002\u0014&!\u0011q_Aq\u0005\r\u0019V\r\u001e\u0005\b\u0003Kq\u0001\u0019AA\u0014\u0011%\t9K\u0004I\u0001\u0002\u0004\tY\u0004C\u0005\u0002,:\u0001\n\u00111\u0001\u0002<\u0005Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0001\u0016\u0005\u0003w\u0011)a\u000b\u0002\u0003\bA!!\u0011\u0002B\n\u001b\t\u0011YA\u0003\u0003\u0003\u000e\t=\u0011!C;oG\",7m[3e\u0015\r\u0011\t\"P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u000b\u0005\u0017\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135\u000319W\r^!mYR{\u0007/[2t)\t\t\u00190\u0001\nhKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0002B\u0011\u0005S\u0001b!a8\u0002v\n\r\u0002\u0003BAf\u0005KIAAa\n\u00020\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAI%\u0001\u0007\u00111S\u0001\u000bO\u0016$Hk\u001c9jG&#G\u0003\u0002B\u0018\u0005k\u0001B!a3\u00032%!!1GA\u0018\u0005\u0011)V/\u001b3\t\u000f\u0005E5\u00031\u0001\u0002\u0014\u0006aq-\u001a;U_BL7MT1nKR!!1\bB\u001f!\u0015a\u00141JAJ\u0011\u001d\u0011y\u0004\u0006a\u0001\u0005_\tq\u0001^8qS\u000eLE-\u0001\biCN\fE.\u001b<f\u0005J|7.\u001a:\u0015\t\u0005m\"Q\t\u0005\u0006\u001fV\u0001\r!U\u0001\u000fSN\u0014%o\\6fe\u001a+gnY3e)\u0011\tYDa\u0013\t\u000b=3\u0002\u0019A)\u0002)%\u001c(I]8lKJ\u001c\u0006.\u001e;uS:<Gi\\<o)\u0011\tYD!\u0015\t\u000b=;\u0002\u0019A)\u0002\u001f\u001d,G/\u00117jm\u0016\u0014%o\\6feN$\"Aa\u0016\u0011\r\u0005E#\u0011\fB/\u0013\u0011\u0011Y&!\u001a\u0003\u0011%#XM]1cY\u0016\u0004BAa\u0018\u0003f5\u0011!\u0011\r\u0006\u0004\u0005G:\u0014!B1e[&t\u0017\u0002\u0002B4\u0005C\u0012aB\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0003X\t-\u0004\"\u00020\u001a\u0001\u0004Y\u0016AE4fi\u0006c\u0017N^3Ce>\\WM\u001d(pI\u0016$b!a2\u0003r\tM\u0004\"B(\u001b\u0001\u0004\t\u0006bBA\u00135\u0001\u0007\u0011qE\u0001\u0014O\u0016$\u0018\t\\5wK\n\u0013xn[3s\u001d>$Wm\u001d\u000b\u0005\u0005s\u0012Y\b\u0005\u0004\u0002`\u0006\u0015\u0018\u0011\u001a\u0005\b\u0003KY\u0002\u0019AA\u0014\u0003A9W\r\u001e)beRLG/[8o\u0013:4w\u000e\u0006\u0004\u0003\u0002\nE%1\u0013\t\u0006y\u0005-#1\u0011\t\u0005\u0005\u000b\u0013YI\u0004\u0003\u0002l\t\u001d\u0015\u0002\u0002BE\u0003\u000b\u000b\u0011$\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fR1uC&!!Q\u0012BH\u0005q)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016TAA!#\u0002\u0006\"9\u0011\u0011\u0013\u000fA\u0002\u0005M\u0005B\u0002BK9\u0001\u0007\u0011+A\u0006qCJ$\u0018\u000e^5p]&#\u0017!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003\u001c\nu\u0005\u0003\u0002\u001f\u0002LECq!!%\u001e\u0001\u0004\t\u0019*A\bu_BL7MT1nKN$v.\u00133t)\t\u0011\u0019\u000bE\u0004\u007f\u0005K\u000b\u0019Ja\f\n\u0007\t\u001dvPA\u0002NCB\fq\u0002^8qS\u000eLEm\u001d+p\u001d\u0006lWm\u001d\u000b\u0003\u0005[\u0003rA BS\u0005_\t\u0019*A\u0006u_BL7-\u00133J]\u001a|GC\u0001BZ!\u001da$Q\u0017BR\u0005[K1Aa.>\u0005\u0019!V\u000f\u001d7fe\u0005Qr-\u001a;QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b:$\u0007o\\5oiRA\u0011q\u0019B_\u0005\u007f\u0013\t\rC\u0004\u0002\u0012\u0006\u0002\r!a%\t\r\tU\u0015\u00051\u0001R\u0011\u001d\t)#\ta\u0001\u0003O\tAdZ3u!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006,e\u000e\u001a9pS:$8\u000f\u0006\u0004\u0003H\n-'q\u001a\t\b\u0003+\u0013I-UAe\u0013\u0011\u00119+!)\t\u000f\t5'\u00051\u0001\u0003$\u0005\u0011A\u000f\u001d\u0005\b\u0003K\u0011\u0003\u0019AA\u0014\u0003=9W\r^\"p]R\u0014x\u000e\u001c7fe&#WC\u0001Bk!\u0015a\u00141\nBl!\r\u0011%\u0011\\\u0005\u0004\u00057,$AE\"bG\",GmQ8oiJ|G\u000e\\3s\u0013\u0012\facZ3u%\u0006tGm\\7BY&4XM\u0011:pW\u0016\u0014\u0018\nZ\u000b\u0003\u00057\u000bAcZ3u%\u0006tGm\\7BY&4XM\u0011:pW\u0016\u0014H\u0003\u0002BN\u0005KDQAX\u0013A\u0002m\u000b1cZ3u\u00032Lg/\u001a\"s_.,'/\u00129pG\"$BAa;\u0003tB)A(a\u0013\u0003nB\u0019AHa<\n\u0007\tEXH\u0001\u0003M_:<\u0007\"B('\u0001\u0004\t\u0016AE4fi\u000ecWo\u001d;fe6+G/\u00193bi\u0006$bA!?\u0003\u0000\u000e\r\u0001\u0003BAf\u0005wLAA!@\u00020\t91\t\\;ti\u0016\u0014\bbBB\u0001O\u0001\u0007\u00111S\u0001\nG2,8\u000f^3s\u0013\u0012Dq!!\n(\u0001\u0004\t9#A\fti\u0006$Xm\u00115b]\u001e,GK]1dK\u0016s\u0017M\u00197fIR\u0011\u00111H\u0001\u0014Y><7\u000b^1uK\u000eC\u0017M\\4f)J\f7-\u001a\u000b\u0004Q\u000e5\u0001bBB\bS\u0001\u0007\u00111S\u0001\u0004gR\u0014\u0018\u0001C2p]R\f\u0017N\\:\u0015\t\u0005m2Q\u0003\u0005\b\u0003#S\u0003\u0019AAJ)\u0011\tYd!\u0007\t\u000f\t57\u00061\u0001\u0003$\u0005A1/\u001a;J[\u0006<W\rF\u0002i\u0007?Aaa!\t-\u0001\u0004Y\u0016\u0001\u00038fo&k\u0017mZ3\u0002\r\r|gNZ5h)\u0011\u00199c!\f\u0011\u0007y\u001cI#C\u0002\u0004,}\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0019y#\fa\u0001\u0007c\tabY8oM&<'+Z:pkJ\u001cW\r\u0005\u0003\u00044\r]RBAB\u001b\u0015\u0011\u0019\u0019#a\f\n\t\re2Q\u0007\u0002\u000f\u0007>tg-[4SKN|WO]2f\u0003Q!Wm]2sS\n,7\t\\5f]R\fVo\u001c;bgR!1qHB$!\u0011\u0019\tea\u0011\u000e\u0005\u0005\u0015\u0015\u0002BB#\u0003\u000b\u0013\u0001\u0005R3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001c(+Z:q_:\u001cX\rR1uC\"91\u0011\n\u0018A\u0002\r-\u0013a\u0002:fcV,7\u000f\u001e\t\u0005\u0007\u0003\u001ai%\u0003\u0003\u0004P\u0005\u0015%a\b#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7OU3rk\u0016\u001cH\u000fR1uC\u0006AB-Z:de&\u0014WmU2sC6\u001c%/\u001a3f]RL\u0017\r\\:\u0015\t\rU31\f\t\u0005\u0007\u0003\u001a9&\u0003\u0003\u0004Z\u0005\u0015%\u0001\u000b#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3ECR\f\u0007bBB%_\u0001\u00071Q\f\t\u0005\u0007\u0003\u001ay&\u0003\u0003\u0004b\u0005\u0015%a\n#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e#bi\u0006\fq\"\\3uC\u0012\fG/\u0019,feNLwN\u001c\u000b\u0003\u0007O\u0002Ba!\u001b\u0004p5\u001111\u000e\u0006\u0005\u0003c\u0019iG\u0003\u00027?&!1\u0011OB6\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017\u0001\u00034fCR,(/Z:\u0015\u0005\r]\u0004c\u0001\"\u0004z%\u001911P\u001b\u00033\u0019Kg.\u00197ju\u0016$g)Z1ukJ,7/\u00118e\u000bB|7\r\u001b")
public class KRaftMetadataCache
implements MetadataCache,
Logging,
ConfigRepository {
    private final int brokerId;
    private volatile MetadataImage _currentImage;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), (Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return new Some((Object)((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1 & Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition$1.leader).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            })).iterator());
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(image, offlineReplicas, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByName().keySet()).asScala();
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return (Set)Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return (Set)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().keySet()).asScala().map((Function1 & Serializable)x$2 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$2)));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsByName()).asScala().get((Object)topicName).map((Function1 & Serializable)x$3 -> x$3.id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsById()).asScala().get((Object)topicId).map((Function1 & Serializable)x$4 -> x$4.name());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$5))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.fenced()))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(b.rack()))));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).flatMap((Function1 & Serializable)x$9 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$9.node(listenerName.value()))));
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.fenced()))).flatMap((Function1 & Serializable)x$11 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$11.node(listenerName.value()))))).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch).setReplicas(Replicas.toList((int[])partition.replicas))));
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<Map<String, Uuid>, Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some((Object)Node.noNode());
                }
                if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    return new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(result, image, listenerName, topic);
            return BoxedUnit.UNIT;
        });
        return result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage()).map((Function1)KRaftCachedControllerId$.MODULE$);
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply(ThreadLocalRandom.current().nextInt(aliveBrokers.size()))).id()));
    }

    public Option<Object> getAliveBrokerEpoch(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.fenced())).map((Function1 & Serializable)brokerRegistration -> BoxesRunTime.boxToLong((long)brokerRegistration.epoch()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().entrySet().forEach(entry -> {
            Integer partitionId = (Integer)entry.getKey();
            PartitionRegistration partition = (PartitionRegistration)entry.getValue();
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(partitionId), KRaftMetadataCache.node$1(partition.leader, nodes), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getOfflineReplicas(image, partition, listenerName)).asScala().map((Function1 & Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    public boolean stateChangeTraceEnabled() {
        return this.stateChangeLogger().isTraceEnabled();
    }

    public void logStateChangeTrace(String str) {
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> str);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey(topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersion();
    }

    @Override
    public FinalizedFeaturesAndEpoch features() {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.Map features = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(image.features().finalizedVersions()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                Short level = (Short)x0$1._2();
                if (name != null && level != null) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)BoxesRunTime.boxToShort((short)Predef$.MODULE$.Short2short(level)));
                }
            }
            throw new MatchError(x0$1);
        });
        features.put((Object)"metadata.version", (Object)BoxesRunTime.boxToShort((short)image.features().metadataVersion().featureLevel()));
        return new FinalizedFeaturesAndEpoch((scala.collection.immutable.Map<String, Object>)features.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), image.highestOffsetAndEpoch().offset());
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(MetadataImage image$3, ArrayList offlineReplicas$1, ListenerName listenerName$3, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$3.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if (broker.fenced() || !broker.listeners().containsKey(listenerName$3.value())) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$5) {
        return !x$5.fenced();
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ Option $anonfun$getPartitionReplicaEndpoints$3(scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, int replicaId) {
        Node node;
        Integer n = BoxesRunTime.boxToInteger((int)replicaId);
        Option option = Option$.MODULE$.apply((Object)image$5.cluster().broker(replicaId));
        if (None$.MODULE$.equals(option)) {
            node = Node.noNode();
        } else if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            node = (Node)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName$8.value()))).getOrElse((Function0 & Serializable)() -> Node.noNode());
        } else {
            throw new MatchError((Object)option);
        }
        return result$1.put((Object)n, (Object)node);
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, TopicImage topic) {
        topic.partitions().values().forEach(partition -> ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)replicaId -> KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$3(result$1, image$5, listenerName$8, BoxesRunTime.unboxToInt((Object)replicaId)), ClassTag$.MODULE$.apply(Option.class)));
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable)() -> Node.noNode());
    }

    public KRaftMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

