/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.LogTestUtils$;
import kafka.log.LogTruncation;
import kafka.log.SegmentDeletionReason;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00115c\u0001\u00026l\u0001ADQa\u001e\u0001\u0005\u0002aD\u0011b\u001f\u0001A\u0002\u0003\u0007I\u0011\u0001?\t\u0017\u0005\u001d\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003+\u0001\u0001\u0019!A!B\u0013i\b\"CA\f\u0001\t\u0007I\u0011AA\r\u0011!\tY\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0017\u0001\t\u0007I\u0011AA\r\u0011!\ty\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0019\u0001\t\u0007I\u0011AA\u001a\u0011!\tY\u0005\u0001Q\u0001\n\u0005U\u0002\"CA'\u0001\t\u0007I\u0011AA(\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005E\u0003\"CA3\u0001\t\u0007I\u0011AA4\u0011!\t)\b\u0001Q\u0001\n\u0005%\u0004\u0002\u00037\u0001\u0005\u0004%\t!a\u001e\t\u0011\u0005}\u0004\u0001)A\u0005\u0003sBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\u001c\u0002!\t!a!\u0007\r\u0005\u0015\u0006\u0001QAT\u0011)\t9m\u0005BK\u0002\u0013\u0005\u0011\u0011\u001a\u0005\u000b\u00037\u001c\"\u0011#Q\u0001\n\u0005-\u0007BCAo'\tU\r\u0011\"\u0001\u0002J\"Q\u0011q\\\n\u0003\u0012\u0003\u0006I!a3\t\r]\u001cB\u0011AAq\u0011\u001d\tYo\u0005C\u0001\u0003[D\u0011Ba\u0003\u0014#\u0003%\tA!\u0004\t\u0013\t\r2#!A\u0005\u0002\t\u0015\u0002\"\u0003B\u0016'E\u0005I\u0011\u0001B\u0017\u0011%\u0011\tdEI\u0001\n\u0003\u0011i\u0003C\u0005\u00034M\t\t\u0011\"\u0011\u00036!I!\u0011I\n\u0002\u0002\u0013\u0005!1\t\u0005\n\u0005\u0017\u001a\u0012\u0011!C\u0001\u0005\u001bB\u0011Ba\u0016\u0014\u0003\u0003%\tE!\u0017\t\u0013\t\u001d4#!A\u0005\u0002\t%\u0004\"\u0003B:'\u0005\u0005I\u0011\tB;\u0011%\u0011IhEA\u0001\n\u0003\u0012Y\bC\u0005\u0003~M\t\t\u0011\"\u0011\u0003\u0000!I!\u0011Q\n\u0002\u0002\u0013\u0005#1Q\u0004\b\u0005\u000f\u0003\u0001\u0012\u0001BE\r\u001d\t)\u000b\u0001E\u0001\u0005\u0017Caa\u001e\u0015\u0005\u0002\tE\u0005b\u0002BJQ\u0011\u0005!Q\u0013\u0005\n\u0005?C\u0013\u0011!CA\u0005CC\u0011Ba*)\u0003\u0003%\tI!+\t\u000f\tm\u0006\u0001\"\u0003\u0003>\"9!1\u001a\u0001\u0005\n\t5\u0007b\u0002Bk\u0001\u0011%!q\u001b\u0005\n\u0005C\u0004\u0011\u0013!C\u0005\u0005GD\u0011Ba:\u0001#\u0003%IA!\u0004\t\u000f\t%\b\u0001\"\u0003\u0003l\"I11\u0003\u0001\u0012\u0002\u0013%!1\u001d\u0005\n\u0007+\u0001\u0011\u0013!C\u0005\u0005\u001bA\u0011ba\u0006\u0001#\u0003%Ia!\u0007\t\u0013\ru\u0001!%A\u0005\n\r}\u0001\"CB\u0012\u0001E\u0005I\u0011BB\u0013\u0011%\u0019I\u0003AI\u0001\n\u0013\u0019y\u0002C\u0004\u0004,\u0001!\t!a!\t\u000f\rU\u0002\u0001\"\u0001\u0002\u0004\"91\u0011\b\u0001\u0005\u0002\u0005\r\u0005bBB\u001f\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007\u0003\u0002A\u0011AAB\u0011\u001d\u0019)\u0005\u0001C\u0001\u0003\u0007Cqa!\u0013\u0001\t\u0003\t\u0019\tC\u0004\u0004N\u0001!\t!a!\t\u000f\rE\u0003\u0001\"\u0001\u0002\u0004\"91Q\u000b\u0001\u0005\u0002\u0005\r\u0005bBB-\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007;\u0002A\u0011AAB\u0011\u001d\u0019\t\u0007\u0001C\u0001\u0003\u0007Cqa!\u001a\u0001\t\u0013\u00199\u0007C\u0004\u0004n\u0001!\t!a!\t\u000f\rE\u0004\u0001\"\u0001\u0002\u0004\"91Q\u000f\u0001\u0005\n\r]\u0004bBB>\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007\u007f\u0002A\u0011AAB\u0011\u001d\u0019\u0019\t\u0001C\u0001\u0003\u0007Cqaa\"\u0001\t\u0003\t\u0019\tC\u0004\u0004\f\u0002!\t!a!\t\u000f\r=\u0005\u0001\"\u0001\u0002\u0004\"911\u0013\u0001\u0005\u0002\u0005\r\u0005bBBL\u0001\u0011\u0005\u00111\u0011\u0005\b\u00077\u0003A\u0011BBO\u0011\u001d\u00199\u000b\u0001C\u0001\u0003\u0007Cqaa+\u0001\t\u0003\t\u0019\tC\u0004\u00040\u0002!\t!a!\t\u000f\rM\u0006\u0001\"\u0001\u0002\u0004\"91q\u0017\u0001\u0005\u0002\u0005\r\u0005bBB^\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007\u007f\u0003A\u0011AAB\u0011\u001d\u0019\u0019\r\u0001C\u0001\u0003\u0007Cqaa2\u0001\t\u0003\t\u0019\tC\u0004\u0004L\u0002!\t!a!\t\u000f\r=\u0007\u0001\"\u0001\u0002\u0004\"911\u001b\u0001\u0005\u0002\u0005\r\u0005bBBl\u0001\u0011\u0005\u00111\u0011\u0005\b\u00077\u0004A\u0011AAB\u0011\u001d\u0019y\u000e\u0001C\u0005\u0007CD\u0011\u0002\"\n\u0001#\u0003%I\u0001b\n\t\u0013\u0011-\u0002!%A\u0005\n\u00115\u0002\"\u0003C\u0019\u0001E\u0005I\u0011\u0002B\u0007\u0011%!\u0019\u0004AI\u0001\n\u0013\u0019)\u0003C\u0005\u00056\u0001\t\n\u0011\"\u0003\u00058!IA1\b\u0001\u0012\u0002\u0013%AQ\b\u0005\n\t\u0003\u0002\u0011\u0013!C\u0005\t\u0007B\u0011\u0002b\u0012\u0001#\u0003%I\u0001\"\u0013\u0003\u00191{7-\u00197M_\u001e$Vm\u001d;\u000b\u00051l\u0017a\u00017pO*\ta.A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\bC\u0001:v\u001b\u0005\u0019(\"\u0001;\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001c(AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002sB\u0011!\u0010A\u0007\u0002W\u000611m\u001c8gS\u001e,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005Q.\u0001\u0004tKJ4XM]\u0005\u0004\u0003\u000by(aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\u0011\tY!!\u0005\u0011\u0007I\fi!C\u0002\u0002\u0010M\u0014A!\u00168ji\"A\u00111C\u0002\u0002\u0002\u0003\u0007Q0A\u0002yIE\nqaY8oM&<\u0007%\u0001\u0004u[B$\u0015N]\u000b\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0002j_*\u0011\u0011QE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0005}!\u0001\u0002$jY\u0016\fq\u0001^7q\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\"!!\u000e\u0011\t\u0005]\u0012qI\u0007\u0003\u0003sQA!a\u000f\u0002>\u000511m\\7n_:T1A\\A \u0015\u0011\t\t%a\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)%A\u0002pe\u001eLA!!\u0013\u0002:\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\t\t\t\u0006\u0005\u0003\u0002T\u0005}SBAA+\u0015\ra\u0017q\u000b\u0006\u0005\u00033\nY&A\u0005j]R,'O\\1mg*!\u0011QLA\u001f\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\u0019\u0002V\t!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\fQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007%\u0001\u0005n_\u000e\\G+[7f+\t\tI\u0007\u0005\u0003\u0002l\u0005ETBAA7\u0015\r\ty'\\\u0001\u0006kRLGn]\u0005\u0005\u0003g\niG\u0001\u0005N_\u000e\\G+[7f\u0003%iwnY6US6,\u0007%\u0006\u0002\u0002zA\u0019!0a\u001f\n\u0007\u0005u4N\u0001\u0005M_\u000e\fG\u000eT8h\u0003\u0011awn\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005-\u0001fA\t\u0002\bB!\u0011\u0011RAL\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015aA1qS*!\u0011\u0011SAJ\u0003\u001dQW\u000f]5uKJTA!!&\u0002D\u0005)!.\u001e8ji&!\u0011\u0011TAF\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a!#a(\u0011\t\u0005%\u0015\u0011U\u0005\u0005\u0003G\u000bYIA\u0005BMR,'/R1dQ\nA1*Z=WC2,Xm\u0005\u0004\u0014c\u0006%\u0016q\u0016\t\u0004e\u0006-\u0016bAAWg\n9\u0001K]8ek\u000e$\b\u0003BAY\u0003\u0003tA!a-\u0002>:!\u0011QWA^\u001b\t\t9LC\u0002\u0002:>\fa\u0001\u0010:p_Rt\u0014\"\u0001;\n\u0007\u0005}6/A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0017Q\u0019\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003\u007f\u001b\u0018aA6fsV\u0011\u00111\u001a\t\u0005\u0003\u001b\f)N\u0004\u0003\u0002P\u0006E\u0007cAA[g&\u0019\u00111[:\u0002\rA\u0013X\rZ3g\u0013\u0011\t9.!7\u0003\rM#(/\u001b8h\u0015\r\t\u0019n]\u0001\u0005W\u0016L\b%A\u0003wC2,X-\u0001\u0004wC2,X\r\t\u000b\u0007\u0003G\f9/!;\u0011\u0007\u0005\u00158#D\u0001\u0001\u0011\u001d\t9\r\u0007a\u0001\u0003\u0017Dq!!8\u0019\u0001\u0004\tY-\u0001\u0005u_J+7m\u001c:e)\u0011\ty/a?\u0011\t\u0005E\u0018q_\u0007\u0003\u0003gTA!!>\u0002:\u00051!/Z2pe\u0012LA!!?\u0002t\na1+[7qY\u0016\u0014VmY8sI\"I\u0011Q`\r\u0011\n\u0003\u0007\u0011q`\u0001\ni&lWm\u001d;b[B\u0004RA\u001dB\u0001\u0005\u000bI1Aa\u0001t\u0005!a$-\u001f8b[\u0016t\u0004c\u0001:\u0003\b%\u0019!\u0011B:\u0003\t1{gnZ\u0001\u0013i>\u0014VmY8sI\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0010)\"!Q\u0001B\tW\t\u0011\u0019\u0002\u0005\u0003\u0003\u0016\t}QB\u0001B\f\u0015\u0011\u0011IBa\u0007\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u000fg\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005\"q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001B2paf$b!a9\u0003(\t%\u0002\"CAd7A\u0005\t\u0019AAf\u0011%\tin\u0007I\u0001\u0002\u0004\tY-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t=\"\u0006BAf\u0005#\tabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005o\u0001BA!\u000f\u0003@5\u0011!1\b\u0006\u0005\u0005{\t\u0019#\u0001\u0003mC:<\u0017\u0002BAl\u0005w\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u0012\u0011\u0007I\u00149%C\u0002\u0003JM\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0014\u0003VA\u0019!O!\u0015\n\u0007\tM3OA\u0002B]fD\u0011\"a\u0005!\u0003\u0003\u0005\rA!\u0012\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0017\u0011\r\tu#1\rB(\u001b\t\u0011yFC\u0002\u0003bM\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ga\u0018\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005W\u0012\t\bE\u0002s\u0005[J1Aa\u001ct\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0005#\u0003\u0003\u0005\rAa\u0014\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005o\u00119\bC\u0005\u0002\u0014\r\n\t\u00111\u0001\u0003F\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003F\u0005AAo\\*ue&tw\r\u0006\u0002\u00038\u00051Q-];bYN$BAa\u001b\u0003\u0006\"I\u00111\u0003\u0014\u0002\u0002\u0003\u0007!qJ\u0001\t\u0017\u0016Lh+\u00197vKB\u0019\u0011Q\u001d\u0015\u0014\t!\n(Q\u0012\t\u0005\u0003;\u0011y)\u0003\u0003\u0002D\u0006}AC\u0001BE\u0003)1'o\\7SK\u000e|'\u000f\u001a\u000b\u0005\u0003G\u00149\nC\u0004\u0002v*\u0002\rA!'\u0011\t\u0005E(1T\u0005\u0005\u0005;\u000b\u0019P\u0001\u0004SK\u000e|'\u000fZ\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003G\u0014\u0019K!*\t\u000f\u0005\u001d7\u00061\u0001\u0002L\"9\u0011Q\\\u0016A\u0002\u0005-\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0005W\u00139\fE\u0003s\u0005[\u0013\t,C\u0002\u00030N\u0014aa\u00149uS>t\u0007c\u0002:\u00034\u0006-\u00171Z\u0005\u0004\u0005k\u001b(A\u0002+va2,'\u0007C\u0005\u0003:2\n\t\u00111\u0001\u0002d\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019-48\u000fV8SK\u000e|'\u000fZ:\u0015\t\t}&Q\u0019\t\u0007\u0003c\u0013\t-a<\n\t\t\r\u0017Q\u0019\u0002\t\u0013R,'/\u00192mK\"9!qY\u0017A\u0002\t%\u0017!C6fsZ\u000bG.^3t!\u0019\t\tL!1\u0002d\u0006a!/Z2pe\u0012\u001cHk\\&wgR!!\u0011\u001aBh\u0011\u001d\u0011\tN\fa\u0001\u0005'\fqA]3d_J$7\u000f\u0005\u0004\u00022\n\u0005'\u0011T\u0001\u000eCB\u0004XM\u001c3SK\u000e|'\u000fZ:\u0015\u0011\u0005-!\u0011\u001cBn\u0005;DqA!50\u0001\u0004\u0011y\f\u0003\u0005m_A\u0005\t\u0019AA=\u0011%\u0011yn\fI\u0001\u0002\u0004\u0011)!A\u0007j]&$\u0018.\u00197PM\u001a\u001cX\r^\u0001\u0018CB\u0004XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uII*\"A!:+\t\u0005e$\u0011C\u0001\u0018CB\u0004XM\u001c3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM\n1B]3bIJ+7m\u001c:egRq!Q\u001eBz\u0005k\u0014IPa@\u0004\u0004\r=\u0001\u0003BA*\u0005_LAA!=\u0002V\tia)\u001a;dQ\u0012\u000bG/Y%oM>D\u0001\u0002\u001c\u001a\u0011\u0002\u0003\u0007\u0011\u0011\u0010\u0005\n\u0005o\u0014\u0004\u0013!a\u0001\u0005\u000b\t1b\u001d;beR|eMZ:fi\"I!1 \u001a\u0011\n\u0003\u0007!Q`\u0001\n[\u0006DH*\u001a8hi\"\u0004RA\u001dB\u0001\u0005\u000bB\u0011b!\u00013!\u0003\u0005\rAa\u001b\u0002\u001b5Lgn\u00148f\u001b\u0016\u001c8/Y4f\u0011%\u0019)A\rI\u0005\u0002\u0004\u00199!A\tnCb|eMZ:fi6+G/\u00193bi\u0006\u0004RA\u001dB\u0001\u0007\u0013\u0001B!a\u0015\u0004\f%!1QBA+\u0005EaunZ(gMN,G/T3uC\u0012\fG/\u0019\u0005\n\u0007#\u0011\u0004\u0013!a\u0001\u0005W\n!#\u001b8dYV$W-\u00112peR,G\r\u0016=og\u0006)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\n\u0014!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$HEM\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019YB\u000b\u0003\u0003F\tE\u0011!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007CQCAa\u001b\u0003\u0012\u0005)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012*TCAB\u0014U\u0011\u0019IA!\u0005\u0002+I,\u0017\r\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005aB/Z:u\u0019><G)\u001a7fi\u0016\u001cVmZ7f]R\u001c8+^2dKN\u001c\bfA\u001d\u00040A!\u0011\u0011RB\u0019\u0013\u0011\u0019\u0019$a#\u0003\tQ+7\u000f^\u0001\u001bi\u0016\u001cHOU8mY\u0016k\u0007\u000f^=BGRLg/Z*fO6,g\u000e\u001e\u0015\u0004u\r=\u0012A\u000e;fgRdun\u001a#fY\u0016$X\rR5s'V\u001c7-Z:t/\",g.R7qif\fe\u000e\u001a$bS2,(/Z,iK:tuN\\#naRL\bfA\u001e\u00040\u0005\u0001B/Z:u+B$\u0017\r^3D_:4\u0017n\u001a\u0015\u0004y\r=\u0012\u0001\u0007;fgRdun\u001a#jeJ+g.Y7f)>tUm\u001e#je\"\u001aQha\f\u0002;Q,7\u000f\u001e'pO\u0012K'OU3oC6,Gk\\#ySN$\u0018N\\4ESJD3APB\u0018\u00031!Xm\u001d;M_\u001e4E.^:iQ\ry4qF\u0001\u000ei\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3)\u0007\u0001\u001by#A\nuKN$Hj\\4DY>\u001cXmU;dG\u0016\u001c8\u000fK\u0002B\u0007_\ta\u0003^3ti2{wm\u00117pg\u0016LE-Z7q_R,g\u000e\u001e\u0015\u0004\u0005\u000e=\u0012a\u000b;fgRdunZ\"m_N,g)Y5mkJ,w\u000b[3o\u0013:lU-\\8ss\n+hMZ3s\u00072|7/\u001a3)\u0007\r\u001by#\u0001\u000buKN$Hj\\4DY>\u001cX\rS1oI2,'o\u001d\u0015\u0004\t\u000e=\u0012A\b;fgRdunZ\"m_N,\u0007*\u00198eY\u0016\u00148/\u00133f[B|G/\u001a8uQ\r)5qF\u0001\u001ci\u0016\u001cHOU3n_Z,\u0017I\u001c3EK2,G/Z*fO6,g\u000e^:\u0015\t\u0005-1\u0011\u000e\u0005\b\u0007W2\u0005\u0019\u0001B6\u0003-\t7/\u001f8d\t\u0016dW\r^3\u0002?Q,7\u000f\u001e*f[>4X-\u00118e\t\u0016dW\r^3TK\u001elWM\u001c;t'ft7\rK\u0002H\u0007_\t\u0001\u0005^3tiJ+Wn\u001c<f\u0003:$G)\u001a7fi\u0016\u001cVmZ7f]R\u001c\u0018i]=oG\"\u001a\u0001ja\f\u0002-Q,7\u000f\u001e#fY\u0016$XmU3h[\u0016tGOR5mKN$B!a\u0003\u0004z!911N%A\u0002\t-\u0014A\u0007;fgR$U\r\\3uKN+w-\\3oi\u001aKG.Z:Ts:\u001c\u0007f\u0001&\u00040\u0005YB/Z:u\t\u0016dW\r^3TK\u001elWM\u001c;GS2,7/Q:z]\u000eD3aSB\u0018\u0003m!Xm\u001d;EK2,G/\u00192mKN+w-\\3oiN4\u0015\u000e\u001c;fe\"\u001aAja\f\u0002=Q,7\u000f\u001e#fY\u0016$\u0018M\u00197f'\u0016<W.\u001a8ug&#XM]1uS>t\u0007fA'\u00040\u0005QB/Z:u\u0007J,\u0017\r^3B]\u0012$U\r\\3uKN+w-\\3oi\"\u001aaja\f\u00027Q,7\u000f\u001e+sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!uQ\ry5qF\u0001\u000fi\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a+pQ\r\u00016qF\u0001\u001ai\u0016\u001cHOT8o\u0003\u000e$\u0018N^3TK\u001elWM\u001c;t\rJ|W\u000eK\u0002R\u0007_\t!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nKR1\u00111ZBP\u0007GCqa!)S\u0001\u0004\tY-A\u0003u_BL7\rC\u0004\u0004&J\u0003\r!a3\u0002\u0013A\f'\u000f^5uS>t\u0017a\u0007;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lW\rK\u0002T\u0007_\tA\u0007^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,w+\u001b;i!\u0016\u0014\u0018n\u001c3G_J$U\r\\3uK\u0012$v\u000e]5dQ\r!6qF\u0001(i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_J,U\u000e\u001d;z\u001d\u0006lW\rK\u0002V\u0007_\t!\u0005^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:Ok2d\u0007f\u0001,\u00040\u0005qC/Z:u!\u0006\u00148/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u00164uN]'jgNLgnZ*fa\u0006\u0014\u0018\r^8sQ\r96qF\u0001+i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_Jl\u0015n]:j]\u001e$v\u000e]5dQ\rA6qF\u0001/i\u0016\u001cH\u000fU1sg\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:t\u0015-\\3G_Jl\u0015n]:j]\u001e\u0004\u0016M\u001d;ji&|g\u000eK\u0002Z\u0007_\ta\u0006^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:J]Z\fG.\u001b3QCJ$\u0018\u000e^5p]\"\u001a!la\f\u0002aQ,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X\t_5ti&tw-\u00138wC2LG\rR5sQ\rY6qF\u0001\u0015i\u0016\u001cH\u000fT8h\t\u0016dW\r^3ESJt\u0015-\\3)\u0007q\u001by#\u0001\nuKN$xJ\u001a4tKR4%o\\7GS2,\u0007fA/\u00040\u0005\u0001C/Z:u%>dGnU3h[\u0016tG\u000f\u00165bi\u0006c'/Z1es\u0016C\u0018n\u001d;tQ\rq6qF\u0001\u0019i\u0016\u001cHOT3x'\u0016<W.\u001a8ug\u00063G/\u001a:S_2d\u0007fA0\u00040\u0005YC/Z:u%>dGnU3h[\u0016tG/\u0012:s_J<\u0006.\u001a8OKb$xJ\u001a4tKRL5/\u00137mK\u001e\fG\u000eK\u0002a\u0007_\tqd\u0019:fCR,Gj\\2bY2{wmV5uQ\u0006\u001bG/\u001b<f'\u0016<W.\u001a8u)Q\tIha9\u0004h\u000e=8\u0011`B\u007f\t\u0003!\u0019\u0002\"\t\u0005$!I1Q]1\u0011\u0002\u0003\u0007\u00111D\u0001\u0004I&\u0014\bBB>b\u0001\u0004\u0019I\u000f\u0005\u0003\u0002T\r-\u0018\u0002BBw\u0003+\u0012\u0011\u0002T8h\u0007>tg-[4\t\u0013\rE\u0018\r%AA\u0002\rM\u0018\u0001C:fO6,g\u000e^:\u0011\u0007i\u001c)0C\u0002\u0004x.\u00141\u0002T8h'\u0016<W.\u001a8ug\"I11`1\u0011\u0002\u0003\u0007!QA\u0001\u000ee\u0016\u001cwN^3ssB{\u0017N\u001c;\t\u0013\r}\u0018\r%AA\u0002\r%\u0011A\u00058fqR|eMZ:fi6+G/\u00193bi\u0006D\u0011\u0002b\u0001b!\u0003\u0005\r\u0001\"\u0002\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0003\u0002C\u0004\t\u001fi!\u0001\"\u0003\u000b\t\u0011-AQB\u0001\u0005kRLGN\u0003\u0003\u0002\u0002\u0005u\u0012\u0002\u0002C\t\t\u0013\u0011\u0011bU2iK\u0012,H.\u001a:\t\u0013\u0011U\u0011\r%AA\u0002\u0011]\u0011\u0001\u0002;j[\u0016\u0004B\u0001\"\u0007\u0005\u001e5\u0011A1\u0004\u0006\u0005\u0003_\nI$\u0003\u0003\u0005 \u0011m!\u0001\u0002+j[\u0016D\u0011\"!\rb!\u0003\u0005\r!!\u000e\t\u0013\u00055\u0013\r%AA\u0002\u0005E\u0013!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0005*)\"\u00111\u0004B\t\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011Aq\u0006\u0016\u0005\u0007g\u0014\t\"A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H\u0005N\u0001*GJ,\u0017\r^3M_\u000e\fG\u000eT8h/&$\b.Q2uSZ,7+Z4nK:$H\u0005Z3gCVdG\u000fJ\u001b\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t!ID\u000b\u0003\u0005\u0006\tE\u0011!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$s'\u0006\u0002\u0005@)\"Aq\u0003B\t\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%qU\u0011AQ\t\u0016\u0005\u0003k\u0011\t\"A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H%O\u000b\u0003\t\u0017RC!!\u0015\u0003\u0012\u0001")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config;
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var20_8 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var21_11 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var22_14 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "127.0.0.1:1", x$4, x$5, -1, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> kv.toRecord$default$1()));
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable)r -> this.KeyValue().fromRecord((Record)r));
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        boolean bl = false;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var5_6 = null;
        simpleRecordArray = null;
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((byte)2, (long)initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        List segmentsBeforeDelete = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testRollEmptyActiveSegment() {
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = oldConfig.segmentSize + 1;
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -1L;
        long x$5 = 0L;
        String x$6 = "delete";
        int x$7 = 0x10000C;
        int x$8 = 4096;
        int x$9 = 0xA00000;
        long x$10 = 60000L;
        boolean x$11 = false;
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testLogDirRenameToNewDir$1(newLogDir, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogAppend() {
        void readRecords_includeAbortedTxns;
        void readRecords_minOneMessage;
        void readRecords_startOffset;
        LocalLog x$2 = this.log();
        long x$3 = 0L;
        boolean x$4 = false;
        boolean x$6 = false;
        FetchDataInfo fetchDataInfoBeforeAppend = x$2.read(x$3, 1, x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfoBeforeAppend.records.records()).asScala().isEmpty());
        this.mockTime().sleep(1L);
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        LocalLog readRecords_log = this.log();
        Object var9_10 = null;
        FetchDataInfo fetchDataInfo = readRecords_log.read((long)readRecords_startOffset, this.readRecords$default$3(), (boolean)readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala()));
    }

    @Test
    public void testLogCloseSuccess() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseSuccess$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseHandlers$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)Nil$.MODULE$.$plus$plus(toDelete)));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = Nil$.MODULE$;
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        List toDelete = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        List toDelete = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testDeletableSegmentsFilter() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsFilter$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)10, (int)this.log().segments().numberOfSegments());
        Iterable deletable = this.log().deletableSegments((Function2 & Serializable)(segment, x$2) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$2(segment, x$2)));
        List expected = ((IterableOnceOps)this.log().segments().nonActiveLogSegmentsFrom(0L).filter((Function1 & Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$3(segment)))).toList();
        Assertions.assertEquals((int)6, (int)expected.length());
        Assertions.assertEquals((Object)expected, (Object)deletable.toList());
        Iterable deletable2 = this.log().deletableSegments((Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$4(x$3, x$4)));
        List expected2 = this.log().segments().nonActiveLogSegmentsFrom(0L).toList();
        Assertions.assertEquals((int)9, (int)expected2.length());
        Assertions.assertEquals((Object)expected2, (Object)deletable2.toList());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$42 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        LocalLog x$62 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$42, x$62, 9L);
        Iterable deletable3 = this.log().deletableSegments((Function2 & Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsFilter$5(x$5, x$6)));
        List expected3 = this.log().segments().values().toList();
        Assertions.assertEquals((int)10, (int)expected3.length());
        Assertions.assertEquals((Object)expected3, (Object)deletable3.toList());
    }

    @Test
    public void testDeletableSegmentsIteration() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeletableSegmentsIteration$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        IntRef offset2 = IntRef.create((int)0);
        Iterable deletableSegments = this.log().deletableSegments((Function2 & Serializable)(segment, nextSegmentOpt) -> BoxesRunTime.boxToBoolean((boolean)LocalLogTest.$anonfun$testDeletableSegmentsIteration$2(this, offset2, segment, nextSegmentOpt)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)this.log().segments().nonActiveLogSegmentsFrom(0L).toSeq(), (Object)deletableSegments.toSeq());
    }

    @Test
    public void testCreateAndDeleteSegment() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        long newOffset = this.log().segments().activeSegment().baseOffset() + 1L;
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        LogSegment newActiveSegment = this.log().createAndDeleteSegment(newOffset, this.log().segments().activeSegment(), true, (SegmentDeletionReason)new LogTruncation(this.log()));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)newActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertEquals((long)newOffset, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)newOffset, (long)this.log().logEndOffset());
        LocalLog x$2 = this.log();
        boolean x$4 = false;
        boolean x$6 = false;
        FetchDataInfo fetchDataInfo = x$2.read(newOffset, this.readRecords$default$3(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            .colon.colon x$4 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
            long x$5 = offset;
            LocalLog x$6 = this.log();
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values());
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        LocalLog x$8 = this.log();
        boolean x$10 = false;
        boolean x$12 = false;
        long readRecords_startOffset = 10L;
        FetchDataInfo fetchDataInfo = x$8.read(readRecords_startOffset, this.readRecords$default$3(), x$10, this.readRecords$default$5(), x$12);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
    }

    @Test
    public void testTruncateTo() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        List expected = (List)Nil$.MODULE$.$plus$plus((IterableOnce)this.log().segments().values(9L, this.log().logEndOffset() + 1L));
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        LocalLog x$5 = this.log();
        boolean x$7 = false;
        boolean x$9 = false;
        long readRecords_startOffset = 6L;
        FetchDataInfo fetchDataInfo = x$5.read(readRecords_startOffset, this.readRecords$default$3(), x$7, this.readRecords$default$5(), x$9);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().size());
        Assertions.assertEquals((Object)new .colon.colon((Object)new KeyValue(this, "", "a"), (List)Nil$.MODULE$), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala()));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$10 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        LocalLog x$12 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, 7L);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile_dir = this.tmpDir();
        Object var6_2 = null;
        File logFile = LogFileUtils.logFile((File)logFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)logFile));
        File offsetIndexFile_dir = this.tmpDir();
        Object var7_4 = null;
        File offsetIndexFile = LogFileUtils.offsetIndexFile((File)offsetIndexFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)offsetIndexFile));
        File timeIndexFile_dir = this.tmpDir();
        Object var8_6 = null;
        File timeIndexFile = LogFileUtils.timeIndexFile((File)timeIndexFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)timeIndexFile));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollSegmentThatAlreadyExists() {
        void readRecords_includeAbortedTxns;
        void readRecords_minOneMessage;
        void readRecords_startOffset;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        .colon.colon keyValues1 = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)Nil$.MODULE$);
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        .colon.colon keyValues2 = new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)Nil$.MODULE$);
        List x$1 = keyValues2.map((Function1 & Serializable)x$8 -> x$8.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> this.mockTime().milliseconds() + 10L));
        LocalLog x$3 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, 1L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        LocalLog readRecords_log = this.log();
        Object var6_8 = null;
        FetchDataInfo readResult = readRecords_log.read((long)readRecords_startOffset, this.readRecords$default$3(), (boolean)readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records.records()).asScala().size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((IterableOnce)keyValues2), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records.records()).asScala()));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable x$1 = (JFunction0.mcJ.sp & Serializable)() -> qual$1.toRecord$default$1();
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)qual$1.toRecord((Function0<Object>)x$1), (List)Nil$.MODULE$), this.log(), 0L);
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable x$2 = (JFunction0.mcJ.sp & Serializable)() -> qual$2.toRecord$default$1();
        .colon.colon x$3 = new .colon.colon((Object)qual$2.toRecord((Function0<Object>)x$2), (List)Nil$.MODULE$);
        LocalLog x$5 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, 1L);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)new .colon.colon((Object)new KeyValue(this, "k3", "v3"), (List)Nil$.MODULE$)));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        int x$5 = config.initFileSize();
        boolean x$6 = config.preallocate;
        boolean x$7 = false;
        String x$8 = "";
        segments.add(LogSegment$.MODULE$.open(dir, 0L, config, time, x$7, x$5, x$6, x$8));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler();
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testLogDirRenameToNewDir$1(File newLogDir$1, LogSegment segment) {
        Assertions.assertEquals((Object)newLogDir$1.getPath(), (Object)segment.log().file().getParentFile().getPath());
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testLogCloseSuccess$1(LocalLogTest $this, Seq keyValues$1) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$1);
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, 2L);
    }

    public static final /* synthetic */ void $anonfun$testLogCloseHandlers$1(LocalLogTest $this, Seq keyValues$2) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$2);
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, 2L);
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsFilter$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$2(LogSegment segment, Option x$2) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$3(LogSegment segment) {
        return segment.baseOffset() <= 5L;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$4(LogSegment x$3, Option x$4) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsFilter$5(LogSegment x$5, Option x$6) {
        return true;
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeletableSegmentsIteration$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$testDeletableSegmentsIteration$2(LocalLogTest $this, IntRef offset$1, LogSegment segment, Option nextSegmentOpt) {
        Assertions.assertEquals((long)offset$1.elem, (long)segment.baseOffset());
        Option floorSegmentOpt = $this.log().segments().floorSegment((long)offset$1.elem);
        Assertions.assertTrue((boolean)floorSegmentOpt.isDefined());
        Assertions.assertEquals((Object)floorSegmentOpt.get(), (Object)segment);
        if ((long)offset$1.elem == $this.log().logEndOffset()) {
            Assertions.assertFalse((boolean)nextSegmentOpt.isDefined());
        } else {
            Assertions.assertTrue((boolean)nextSegmentOpt.isDefined());
            Option higherSegmentOpt = $this.log().segments().higherSegment(segment.baseOffset());
            Assertions.assertTrue((boolean)higherSegmentOpt.isDefined());
            Assertions.assertEquals((long)(segment.baseOffset() + 1L), (long)((LogSegment)higherSegmentOpt.get()).baseOffset());
            Assertions.assertEquals((Object)higherSegmentOpt.get(), (Object)nextSegmentOpt.get());
        }
        ++offset$1.elem;
        return true;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$1, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue($this, Integer.toString(i), Integer.toString(i)), (List)Nil$.MODULE$);
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((IterableOnceOps)this.log().segments().nonActiveLogSegmentsFrom(startOffset).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.baseOffset()))).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(604800000L, 0x40000000, 604800000L, -1L, 0L, "delete", 0x10000C, 4096, 0xA00000, 60000L, false);
        File x$2 = this.logDir();
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long x$4 = 0L;
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        MockTime x$7 = this.mockTime();
        TopicPartition x$8 = this.topicPartition();
        LogDirFailureChannel x$9 = this.logDirFailureChannel();
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, x$4, x$5, x$6, (Time)x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "value";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof KeyValue && ((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() == this.kafka$log$LocalLogTest$KeyValue$$$outer())) break block3;
                    KeyValue keyValue = (KeyValue)x$1;
                    String string = this.key();
                    String string2 = keyValue.key();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.value();
                    String string4 = keyValue.value();
                    if ((string3 != null ? !string3.equals(string4) : string4 != null) || !keyValue.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

