/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestInfoUtils$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsRequest;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\t}e\u0001B\u0014)\u00015BQA\r\u0001\u0005\u0002MBq!\u000e\u0001A\u0002\u0013Ea\u0007C\u0004D\u0001\u0001\u0007I\u0011\u0003#\t\r5\u0003\u0001\u0015)\u00038\u0011\u0015q\u0005\u0001\"\u00157\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u001d\t\u0007A1A\u0005\n\tDa!\u001b\u0001!\u0002\u0013\u0019\u0007b\u00026\u0001\u0005\u0004%IA\u0019\u0005\u0007W\u0002\u0001\u000b\u0011B2\t\u000f1\u0004!\u0019!C\u0005[\"1a\u000f\u0001Q\u0001\n9Dqa\u001e\u0001C\u0002\u0013%Q\u000e\u0003\u0004y\u0001\u0001\u0006IA\u001c\u0005\bs\u0002\u0011\r\u0011\"\u0003n\u0011\u0019Q\b\u0001)A\u0005]\")1\u0010\u0001C\u0001y\"9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u00033\u0002A\u0011AA.\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002~\u0001!\t!a \t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003c\u0003A\u0011BAZ\u0011%\ti\u000eAI\u0001\n\u0013\ty\u000eC\u0004\u0002v\u0002!I!a>\t\u0013\t%\u0001!%A\u0005\n\u0005}\u0007b\u0002B\u0006\u0001\u0011%!Q\u0002\u0005\b\u00053\u0002A\u0011\u0002B.\u0011\u001d\u0011y\u0006\u0001C\u0005\u0005CBqA!\u001b\u0001\t\u0013\u0011Y\u0007C\u0004\u0003n\u0001!IAa\u001c\t\u000f\tU\u0004\u0001\"\u0003\u0003x!9!Q\u0012\u0001\u0005\n\t=\u0005b\u0002BK\u0001\u0011%!q\u0013\u0002%\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fV3ti*\u0011\u0011FK\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001]A\u0011q\u0006M\u0007\u0002Q%\u0011\u0011\u0007\u000b\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012\u0001\u000e\t\u0003_\u0001\t1\u0003^3ti6+G/\u00193bi\u00064VM]:j_:,\u0012a\u000e\t\u0003q\u0005k\u0011!\u000f\u0006\u0003um\naaY8n[>t'BA\u0015=\u0015\tYSH\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\":\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017a\u0006;fgRlU\r^1eCR\fg+\u001a:tS>tw\fJ3r)\t)5\n\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0003V]&$\bb\u0002'\u0004\u0003\u0003\u0005\raN\u0001\u0004q\u0012\n\u0014\u0001\u0006;fgRlU\r^1eCR\fg+\u001a:tS>t\u0007%A\bnKR\fG-\u0019;b-\u0016\u00148/[8o\u0003\u0015\u0019X\r^+q)\t)\u0015\u000bC\u0003S\r\u0001\u00071+\u0001\u0005uKN$\u0018J\u001c4p!\t!6,D\u0001V\u0015\t1v+A\u0002ba&T!\u0001W-\u0002\u000f),\b/\u001b;fe*\u0011!lP\u0001\u0006UVt\u0017\u000e^\u0005\u00039V\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0003\ry\u0003\"\u0001V0\n\u0005\u0001,&A\u0003\"fM>\u0014X-R1dQ\u0006\u00192/\u00197uK\u0012\u0004\u0016m]:x_J$')\u001f;fgV\t1\rE\u0002GI\u001aL!!Z$\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0019;\u0017B\u00015H\u0005\u0011\u0011\u0015\u0010^3\u0002)M\fG\u000e^3e!\u0006\u001c8o^8sI\nKH/Z:!\u0003%\u0019\u0018\r\u001c;CsR,7/\u0001\u0006tC2$()\u001f;fg\u0002\nQ!^:feF*\u0012A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fA\u0001\\1oO*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005\u0019\u0019FO]5oO\u00061Qo]3sc\u0001\nQ!^:feJ\na!^:feJ\u0002\u0013aC;oW:|wO\\+tKJ\fA\"\u001e8l]><h.V:fe\u0002\n\u0001\u0003^3ti\u0006cG/\u001a:O_RD\u0017N\\4\u0015\u0005\u0015k\b\"\u0002@\u0012\u0001\u0004y\u0018AB9v_J,X\u000e\u0005\u0003\u0002\u0002\u0005=a\u0002BA\u0002\u0003\u0017\u00012!!\u0002H\u001b\t\t9AC\u0002\u0002\n1\na\u0001\u0010:p_Rt\u0014bAA\u0007\u000f\u00061\u0001K]3eK\u001aL1!^A\t\u0015\r\tia\u0012\u0015\b#\u0005U\u0011QEA\u0014!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0003?9\u0016A\u00029be\u0006l7/\u0003\u0003\u0002$\u0005e!a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0003\u0002*\u00055\u0012EAA\u0016\u0003\u0015Y'/\u00194uC\t\ty#\u0001\u0002{W\":\u0011#a\r\u0002<\u0005u\u0002\u0003BA\u001b\u0003oi!!!\b\n\t\u0005e\u0012Q\u0004\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#!a\u0010\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T0A\fuKN$\u0018\t\u001c;feN\u000bW.\u001a+iS:<Gk^5dKR\u0019Q)!\u0012\t\u000by\u0014\u0002\u0019A@)\u000fI\t)\"!\n\u0002J1\"\u0011\u0011FA\u0017Q\u001d\u0011\u00121GA\u001e\u0003{\t!\u0003^3ti\u0006cG/\u001a:F[B$\u00180V:feR\u0019Q)!\u0015\t\u000by\u001c\u0002\u0019A@)\u000fM\t)\"!\n\u0002V1\"\u0011\u0011FA\u0017Q\u001d\u0019\u00121GA\u001e\u0003{\t\u0011\u0004^3ti\u0006cG/\u001a:V].twn\u001e8NK\u000eD\u0017M\\5t[R\u0019Q)!\u0018\t\u000by$\u0002\u0019A@)\u000fQ\t)\"!\n\u0002b1\"\u0011\u0011FA\u0017Q\u001d!\u00121GA\u001e\u0003{\t\u0011\u0004^3ti\u0006cG/\u001a:U_>4Um^%uKJ\fG/[8ogR\u0019Q)!\u001b\t\u000by,\u0002\u0019A@)\u000fU\t)\"!\n\u0002n1\"\u0011\u0011FA\u0017Q\u001d)\u00121GA\u001e\u0003{\t!\u0004^3ti\u0006cG/\u001a:U_>l\u0015M\\=Ji\u0016\u0014\u0018\r^5p]N$2!RA;\u0011\u0015qh\u00031\u0001\u0000Q\u001d1\u0012QCA\u0013\u0003sbC!!\u000b\u0002.!:a#a\r\u0002<\u0005u\u0012a\t;fgR$U\r\\3uKN{W.\u001a;iS:<G\u000b[1u\t>,7OT8u\u000bbL7\u000f\u001e\u000b\u0004\u000b\u0006\u0005\u0005\"\u0002@\u0018\u0001\u0004y\bfB\f\u0002\u0016\u0005\u0015\u0012Q\u0011\u0017\u0005\u0003S\ti\u0003K\u0004\u0018\u0003g\tY$!\u0010\u0002-Q,7\u000f^!mi\u0016\u0014hj\u001c;D_:$(o\u001c7mKJ$\u0012!\u0012\u0015\u00041\u0005=\u0005c\u0001+\u0002\u0012&\u0019\u00111S+\u0003\tQ+7\u000f^\u0001\u0015i\u0016\u001cH/\u00117uKJ\fe\u000e\u001a#fg\u000e\u0014\u0018NY3\u0015\u0007\u0015\u000bI\nC\u0003\u007f3\u0001\u0007q\u0010K\u0004\u001a\u0003+\t)#!(-\t\u0005%\u0012Q\u0006\u0015\b3\u0005M\u00121HA\u001f\u0003e!Xm\u001d;NKR\fG-\u0019;b-\u0016\u00148/[8o)>|Gj\\<\u0015\u0007\u0015\u000b)\u000bC\u0003\u007f5\u0001\u0007q\u0010K\u0004\u001b\u0003+\t)#!+-\u0005\u0005-\u0016EAAW\u00035Y'/\u00194u[%\u0013\u0005kX\u001a`i!:!$a\r\u0002<\u0005u\u0012\u0001J:f]\u0012\fE\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;\u0015\r\u0005U\u00161YAg!\u0011\t9,a0\u000e\u0005\u0005e&\u0002BA^\u0003{\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003uqJA!!1\u0002:\n\t\u0013\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001c\bo\u001c8tK\"9\u0011QY\u000eA\u0002\u0005\u001d\u0017a\u0002:fcV,7\u000f\u001e\t\u0005\u0003o\u000bI-\u0003\u0003\u0002L\u0006e&\u0001I!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgRD\u0011\"a4\u001c!\u0003\u0005\r!!5\u0002\u0019M|7m[3u'\u0016\u0014h/\u001a:\u0011\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+T1!a6+\u0003\u001dqW\r^<pe.LA!a7\u0002V\na1k\\2lKR\u001cVM\u001d<fe\u0006q3/\u001a8e\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tO\u000b\u0003\u0002R\u0006\r8FAAs!\u0011\t9/!=\u000e\u0005\u0005%(\u0002BAv\u0003[\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=x)\u0001\u0006b]:|G/\u0019;j_:LA!a=\u0002j\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002OM,g\u000e\u001a#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u000b\u0007\u0003s\fyPa\u0002\u0011\t\u0005]\u00161`\u0005\u0005\u0003{\fIL\u0001\u0013EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN\u0004xN\\:f\u0011\u001d\t)-\ba\u0001\u0005\u0003\u0001B!a.\u0003\u0004%!!QAA]\u0005\r\"Um]2sS\n,Wk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgRD\u0011\"a4\u001e!\u0003\u0005\r!!5\u0002cM,g\u000e\u001a#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%e\u0005\t3\r[3dW\u0006cG.\u0012:s_J\u001c\u0018\t\u001c;fe&twm\u0011:fI\u0016tG/[1mgR9QIa\u0004\u0003F\tU\u0003b\u0002B\t?\u0001\u0007!1C\u0001\u000fe\u0016\u001cX\u000f\u001c;t)>\u001c\u0005.Z2l!\u0019\u0011)Ba\u0007\u0003 5\u0011!q\u0003\u0006\u0004\u00053\u0011\u0018\u0001B;uS2LAA!\b\u0003\u0018\t!A*[:u!\u0011\u0011\tCa\u0010\u000f\t\t\r\"\u0011\b\b\u0005\u0005K\u0011)D\u0004\u0003\u0003(\tMb\u0002\u0002B\u0015\u0005cqAAa\u000b\u000309!\u0011Q\u0001B\u0017\u0013\u0005\u0001\u0015B\u0001 @\u0013\tYS(\u0003\u0002;y%!!qGA_\u0003\u001diWm]:bO\u0016LAAa\u000f\u0003>\u0005)\u0013\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u0005o\ti,\u0003\u0003\u0003B\t\r#aH!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm];mi*!!1\bB\u001f\u0011\u001d\u00119e\ba\u0001\u0005\u0013\nQ\"\u001a=qK\u000e$X\rZ#se>\u0014\b\u0003\u0002B&\u0005#j!A!\u0014\u000b\t\t=\u0013QX\u0001\taJ|Go\\2pY&!!1\u000bB'\u0005\u0019)%O]8sg\"1!qK\u0010A\u0002}\f!bY8oi\u0016DH/T:h\u0003\u0001\u001a\u0007.Z2l\u001d>,%O]8sg\u0006cG/\u001a:j]\u001e\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u0007\u0015\u0013i\u0006C\u0004\u0003\u0012\u0001\u0002\rAa\u0005\u0002=\rDWmY6Vg\u0016\u0014\u0018\t\u001d9fCJ\u001c\u0018J\\!mi\u0016\u0014(+Z:vYR\u001cH#B#\u0003d\t\u0015\u0004b\u0002B\tC\u0001\u0007!1\u0003\u0005\u0007\u0005O\n\u0003\u0019A@\u0002\tU\u001cXM]\u0001(I\u0016\u001c8M]5cK\u0006cGnV5uQ:{Gk\u001c9MKZ,G.\u0012:s_J\u001cuN\u001c4je6,G\r\u0006\u0002\u0002z\u0006I3\r[3dW:{Gk\u001c9MKZ,G.\u0012:s_J$Um]2sS\nLgnZ\"sK\u0012,g\u000e^5bYN$2!\u0012B9\u0011\u001d\u0011\u0019h\ta\u0001\u0003s\fqB]3ta>t7/\u001a+p\u0007\",7m[\u0001\u001bG\",7m[+tKJD\u0015m\u001d+x_\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0006\u000b\ne$1\u0012\u0005\b\u0005#!\u0003\u0019\u0001B>!\u0019\u0011)Ba\u0007\u0003~A!!q\u0010BC\u001d\u0011\u0011\u0019C!!\n\t\t\r%QH\u0001)\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0005\u000f\u0013II\u0001\u0012EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN,H\u000e\u001e\u0006\u0005\u0005\u0007\u0013i\u0004\u0003\u0004\u0003h\u0011\u0002\ra`\u0001-G\",7m\u001b$peNKgn\u001a7f'\"\fW'\r\u001aJi\u0016\u0014\u0018\r^5p]ND\u0014'\u000f\u001aDe\u0016$WM\u001c;jC2$R!\u0012BI\u0005'CqA!\u0005&\u0001\u0004\u0011Y\b\u0003\u0004\u0003h\u0015\u0002\ra`\u0001\u0016G\",7m\u001b#fg\u000e\u0014\u0018NY3G_J,%O]8s)\u001d)%\u0011\u0014BN\u0005;CqA!\u0005'\u0001\u0004\u0011Y\b\u0003\u0004\u0003h\u0019\u0002\ra \u0005\b\u0005\u000f2\u0003\u0019\u0001B%\u0001")
public class AlterUserScramCredentialsRequestTest
extends BaseRequestTest {
    private MetadataVersion testMetadataVersion = MetadataVersion.latest();
    private final byte[] saltedPasswordBytes = "saltedPassword".getBytes(StandardCharsets.UTF_8);
    private final byte[] saltBytes = "salt".getBytes(StandardCharsets.UTF_8);
    private final String user1;
    private final String user2;
    private final String unknownUser;

    public MetadataVersion testMetadataVersion() {
        return this.testMetadataVersion;
    }

    public void testMetadataVersion_$eq(MetadataVersion x$1) {
        this.testMetadataVersion = x$1;
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this.testMetadataVersion();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), StandardAuthorizer.class.getName());
            if (testInfo.getDisplayName().contains("quorum=kraft-IBP_3_4")) {
                this.testMetadataVersion_$eq(MetadataVersion.IBP_3_4_IV0);
            }
        } else {
            this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AlterCredentialsTest.TestAuthorizer.class.getName());
        }
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), AlterCredentialsTest.TestPrincipalBuilderReturningAuthorized.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        super.setUp(testInfo);
    }

    private byte[] saltedPasswordBytes() {
        return this.saltedPasswordBytes;
    }

    private byte[] saltBytes() {
        return this.saltBytes;
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    private String unknownUser() {
        return this.unknownUser;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterNothing(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterSameThingTwice(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletion2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion1 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertion2 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertion1, upsertion2))).build()), (List)Nil$.MODULE$).foreach((Function1 & Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$1(this, request);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletion1, deletion1)).setUpsertions(Arrays.asList(upsertion2, upsertion2))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletion1, deletion2)).setUpsertions(Arrays.asList(upsertion1, upsertion2))).build()), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterSameThingTwice$2(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterEmptyUser(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionEmpty = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName("").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionEmpty)).setUpsertions(new ArrayList())).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(Arrays.asList(upsertionEmpty))).build()), (List)new .colon.colon((Object)((AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionEmpty, deletionEmpty)).setUpsertions(Arrays.asList(upsertionEmpty))).build()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)request -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterEmptyUser$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterUnknownMechanism(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.UNKNOWN.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionValid1 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type());
        AlterUserScramCredentialsRequestData.ScramCredentialDeletion deletionUnknown2 = new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism((byte)10);
        String user3 = "user3";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown3 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user3).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionValid3 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user3).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user4 = "user4";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown4 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user4).setMechanism((byte)10).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        String user5 = "user5";
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionUnknown5 = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(user5).setMechanism(ScramMechanism.UNKNOWN.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(deletionUnknown1, deletionValid1, deletionUnknown2)).setUpsertions(Arrays.asList(upsertionUnknown3, upsertionValid3, upsertionUnknown4, upsertionUnknown5))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)5, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_SASL_MECHANISM, "when altering the credentials with unknown SCRAM mechanisms");
        CollectionConverters$.MODULE$.ListHasAsScala(results).asScala().foreach((Function1 & Serializable)result -> {
            AlterUserScramCredentialsRequestTest.$anonfun$testAlterUnknownMechanism$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterTooFewIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(1).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionTooFewIterations))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too few iterations");
        Assertions.assertEquals((Object)"Too few iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterTooManyIterations(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionTooFewIterations = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(Integer.MAX_VALUE).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionTooFewIterations))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering the credentials with too many iterations");
        Assertions.assertEquals((Object)"Too many iterations", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDeleteSomethingThatDoesNotExist(String quorum) {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(new ArrayList())).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.RESOURCE_NOT_FOUND, "when deleting a non-existing credential");
    }

    @Test
    public void testAlterNotController() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()))).setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.notControllerSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.NOT_CONTROLLER, "when routed incorrectly to a non-Controller broker");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testAlterAndDescribe(String quorum) {
        AlterUserScramCredentialsRequest request1_0 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(4096).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())))).build();
        java.util.List results1_0 = this.sendAlterUserScramCredentialsRequest(request1_0, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results1_0.size());
        this.checkNoErrorsAlteringCredentials(results1_0);
        this.checkUserAppearsInAlterResults(results1_0, this.user1());
        AlterUserScramCredentialsRequest request1_1 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setUpsertions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes()), new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes())))).build();
        java.util.List results1_1 = this.sendAlterUserScramCredentialsRequest(request1_1, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results1_1.size());
        this.checkNoErrorsAlteringCredentials(results1_1);
        this.checkUserAppearsInAlterResults(results1_1, this.user1());
        this.checkUserAppearsInAlterResults(results1_1, this.user2());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"describeAllWithNoTopLevelErrorConfirmed does not see 2 users");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List results2 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)2, (int)results2.size());
        this.checkUserHasTwoCredentials(results2, this.user1());
        this.checkForSingleSha512Iterations8192Credential(results2, this.user2());
        DescribeUserScramCredentialsRequest request3 = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1())))).build();
        DescribeUserScramCredentialsResponse response3 = this.sendDescribeUserScramCredentialsRequest(request3, this.adminSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(response3);
        java.util.List results3 = response3.data().results();
        Assertions.assertEquals((int)1, (int)results3.size());
        this.checkUserHasTwoCredentials(results3, this.user1());
        DescribeUserScramCredentialsRequest requestUnknown = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.unknownUser())))).build();
        DescribeUserScramCredentialsResponse responseUnknown = this.sendDescribeUserScramCredentialsRequest(requestUnknown, this.adminSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(responseUnknown);
        java.util.List resultsUnknown = responseUnknown.data().results();
        Assertions.assertEquals((int)2, (int)resultsUnknown.size());
        this.checkUserHasTwoCredentials(resultsUnknown, this.user1());
        this.checkDescribeForError(resultsUnknown, this.unknownUser(), Errors.RESOURCE_NOT_FOUND);
        DescribeUserScramCredentialsRequest requestDuplicateUser = (DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData().setUsers(Arrays.asList(new DescribeUserScramCredentialsRequestData.UserName().setName(this.user1()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2()), new DescribeUserScramCredentialsRequestData.UserName().setName(this.user2())))).build();
        DescribeUserScramCredentialsResponse responseDuplicateUser = this.sendDescribeUserScramCredentialsRequest(requestDuplicateUser, this.adminSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(responseDuplicateUser);
        java.util.List resultsDuplicateUser = responseDuplicateUser.data().results();
        Assertions.assertEquals((int)2, (int)resultsDuplicateUser.size());
        this.checkUserHasTwoCredentials(resultsDuplicateUser, this.user1());
        this.checkDescribeForError(resultsDuplicateUser, this.user2(), Errors.DUPLICATE_RESOURCE);
        AlterUserScramCredentialsRequest request4 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()), new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results4 = this.sendAlterUserScramCredentialsRequest(request4, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results4.size());
        this.checkNoErrorsAlteringCredentials(results4);
        this.checkUserAppearsInAlterResults(results4, this.user1());
        this.checkUserAppearsInAlterResults(results4, this.user2());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"describeAllWithNoTopLevelErrorConfirmed does not see only 1 user");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        java.util.List results5 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)1, (int)results5.size());
        this.checkForSingleSha512Iterations8192Credential(results5, this.user1());
        AlterUserScramCredentialsRequest request6 = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList(new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())))).build();
        java.util.List results6 = this.sendAlterUserScramCredentialsRequest(request6, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results6.size());
        this.checkNoErrorsAlteringCredentials(results6);
        this.checkUserAppearsInAlterResults(results6, this.user1());
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AlterUserScramCredentialsRequestTest.$anonfun$testAlterAndDescribe$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"describeAllWithNoTopLevelErrorConfirmed does not see empty user");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        java.util.List results7 = this.describeAllWithNoTopLevelErrorConfirmed().data().results();
        Assertions.assertEquals((int)0, (int)results7.size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft-IBP_3_4"})
    public void testMetadataVersionTooLow(String quorum) {
        AlterUserScramCredentialsRequestData.ScramCredentialUpsertion upsertionMetadataVersionTooLow = new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setIterations(8192).setSalt(this.saltBytes()).setSaltedPassword(this.saltedPasswordBytes());
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Collections.emptyList()).setUpsertions(Arrays.asList(upsertionMetadataVersionTooLow))).build();
        java.util.List results = this.sendAlterUserScramCredentialsRequest(request, this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.UNSUPPORTED_VERSION, "when altering the credentials on unsupported IPB version");
        Assertions.assertEquals((Object)"The current metadata version does not support SCRAM", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private DescribeUserScramCredentialsResponse sendDescribeUserScramCredentialsRequest(DescribeUserScramCredentialsRequest request, SocketServer socketServer) {
        return (DescribeUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private SocketServer sendDescribeUserScramCredentialsRequest$default$2() {
        return this.adminSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)))).size(), (String)new StringBuilder(49).append("Expected all '").append(expectedError.name()).append("' errors when altering credentials ").append(contextMsg).toString());
    }

    private void checkNoErrorsAlteringCredentials(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck) {
        Assertions.assertEquals((int)0, (int)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkNoErrorsAlteringCredentials$1(x$2)))).size(), (String)"Expected no error when altering credentials");
    }

    private void checkUserAppearsInAlterResults(java.util.List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserAppearsInAlterResults$1(user, x$3))), (String)new StringBuilder(29).append("Expected result to contain '").append(user).append("'").toString());
    }

    private DescribeUserScramCredentialsResponse describeAllWithNoTopLevelErrorConfirmed() {
        DescribeUserScramCredentialsResponse response = this.sendDescribeUserScramCredentialsRequest((DescribeUserScramCredentialsRequest)new DescribeUserScramCredentialsRequest.Builder(new DescribeUserScramCredentialsRequestData()).build(), this.adminSocketServer());
        this.checkNoTopLevelErrorDescribingCredentials(response);
        return response;
    }

    private void checkNoTopLevelErrorDescribingCredentials(DescribeUserScramCredentialsResponse responseToCheck) {
        Assertions.assertEquals((short)Errors.NONE.code(), (short)responseToCheck.data().errorCode(), (String)"Expected no top-level error when describing the credentials");
    }

    private void checkUserHasTwoCredentials(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$1(user, result))), (String)new StringBuilder(50).append("Expected result to contain '").append(user).append("' with 2 credentials: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$2(user, result))), (String)new StringBuilder(90).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_256/4096 and SCRAM_SHA_512/8192 credentials: ").append(resultsToCheck).toString());
    }

    private void checkForSingleSha512Iterations8192Credential(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$1(user, result))), (String)new StringBuilder(49).append("Expected result to contain '").append(user).append("' with 1 credential: ").append(resultsToCheck).toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$2(user, result))), (String)new StringBuilder(66).append("Expected result to contain '").append(user).append("' with SCRAM_SHA_512/8192 credential: ").append(resultsToCheck).toString());
    }

    private void checkDescribeForError(java.util.List<DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult> resultsToCheck, String user, Errors expectedError) {
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(resultsToCheck).asScala().exists((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkDescribeForError$1(user, expectedError, result))), (String)new StringBuilder(45).append("Expected result to contain '").append(user).append("' with a ").append(expectedError.name()).append(" error: ").append(resultsToCheck).toString());
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.adminSocketServer()).data().results();
        $this.checkNoErrorsAlteringCredentials(results);
    }

    public static final /* synthetic */ void $anonfun$testAlterSameThingTwice$2(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.DUPLICATE_RESOURCE, "when altering the same credential twice in a single request");
    }

    public static final /* synthetic */ void $anonfun$testAlterEmptyUser$1(AlterUserScramCredentialsRequestTest $this, AlterUserScramCredentialsRequest request) {
        java.util.List results = $this.sendAlterUserScramCredentialsRequest(request, $this.adminSocketServer()).data().results();
        Assertions.assertEquals((int)1, (int)results.size());
        $this.checkAllErrorsAlteringCredentials(results, Errors.UNACCEPTABLE_CREDENTIAL, "when altering an empty user");
        Assertions.assertEquals((Object)"Username must not be empty", (Object)((AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult)results.get(0)).errorMessage());
    }

    public static final /* synthetic */ void $anonfun$testAlterUnknownMechanism$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult result) {
        Assertions.assertEquals((Object)"Unknown SCRAM mechanism", (Object)result.errorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$1(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$2() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see 2 users";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$3(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$4() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see only 1 user";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAndDescribe$5(AlterUserScramCredentialsRequestTest $this) {
        return $this.describeAllWithNoTopLevelErrorConfirmed().data().results().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testAlterAndDescribe$6() {
        return "describeAllWithNoTopLevelErrorConfirmed does not see empty user";
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkNoErrorsAlteringCredentials$1(AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$2) {
        return x$2.errorCode() == Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$checkUserAppearsInAlterResults$1(String user$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$3) {
        String string = x$3.user();
        return !(string != null ? !string.equals(user$1) : user$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$1(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (result.credentialInfos().size() == 2 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_256.type() && info.iterations() == 4096;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$4(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkUserHasTwoCredentials$2(String user$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$2) : user$2 != null)) {
            if (CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$3(info))) && CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkUserHasTwoCredentials$4(info)))) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$1(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$3) : user$3 != null)) {
            if (result.credentialInfos().size() == 1 && result.errorCode() == Errors.NONE.code()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$3(DescribeUserScramCredentialsResponseData.CredentialInfo info) {
        return info.mechanism() == ScramMechanism.SCRAM_SHA_512.type() && info.iterations() == 8192;
    }

    public static final /* synthetic */ boolean $anonfun$checkForSingleSha512Iterations8192Credential$2(String user$3, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        return !(string != null ? !string.equals(user$3) : user$3 != null) && CollectionConverters$.MODULE$.ListHasAsScala(result.credentialInfos()).asScala().exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestTest.$anonfun$checkForSingleSha512Iterations8192Credential$3(info)));
    }

    public static final /* synthetic */ boolean $anonfun$checkDescribeForError$1(String user$4, Errors expectedError$2, DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult result) {
        String string = result.user();
        if (!(string != null ? !string.equals(user$4) : user$4 != null)) {
            if (result.credentialInfos().size() == 0 && result.errorCode() == expectedError$2.code()) {
                return true;
            }
        }
        return false;
    }

    public AlterUserScramCredentialsRequestTest() {
        this.user1 = "user1";
        this.user2 = "user2";
        this.unknownUser = "unknownUser";
    }
}

