/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.security.authorizer.AclEntry$;
import kafka.server.ConfigType$;
import kafka.server.ControllerMigrationSupport;
import kafka.server.ControllerServer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.EncryptingPasswordEncoder;
import kafka.utils.Logging;
import kafka.utils.NoOpPasswordEncoder;
import kafka.utils.PasswordEncoder;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import kafka.zk.TopicZNode;
import kafka.zk.ZkMigrationClient;
import kafka.zk.ZkMigrationClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.migration.MigrationDriverState;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ClusterTestExtensions.class})
@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\tEg\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0004\u0005{\u0001\u0001a\bC\u0003/\t\u0011\u0005q\bC\u0004C\t\t\u0007I\u0011A\"\t\r5#\u0001\u0015!\u0003E\u0011\u001dqE\u00011A\u0005\u0002=Cqa\u0015\u0003A\u0002\u0013\u0005A\u000b\u0003\u0004[\t\u0001\u0006K\u0001\u0015\u0005\u00067\u0012!\t\u0001\u0018\u0005\u0006_\u0012!\t\u0001\u001d\u0005\u0006s\u0002!\tA\u001f\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!a&\u0001\t\u0003\tI\nC\u0004\u0002(\u0002!\t!!+\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\"9\u00111\u0018\u0001\u0005\u0002\u0005u\u0006bBAc\u0001\u0011\u0005\u0011q\u0019\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_AqA!\u000e\u0001\t\u0003\u00119\u0004C\u0004\u0003B\u0001!\tAa\u0011\t\u000f\t5\u0003\u0001\"\u0001\u0003P!9!\u0011\f\u0001\u0005\u0002\tm\u0003b\u0002B3\u0001\u0011\u0005!q\r\u0005\b\u0005W\u0002A\u0011\u0001B7\u0011\u001d\u0011\t\b\u0001C\u0001\u0005gBqAa\u001e\u0001\t\u0003\u0011I\bC\u0004\u0003~\u0001!\tAa \t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\n\nQ\"l['jOJ\fG/[8o\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0005J\u0001\u0003u.T\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"!\r\u0001\u000e\u0003\t\n1\u0001\\8h+\u0005!\u0004CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0014aA8sO&\u00111H\u000e\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\r\t\u0002\u0016\u001b\u0016$\u0018\rZ1uC\u0012+G\u000e^1WKJLg-[3s'\t!\u0001\u0006F\u0001A!\t\tE!D\u0001\u0001\u00035iW\r^1eCR\fG)\u001a7uCV\tA\t\u0005\u0002F\u00176\taI\u0003\u0002H\u0011\u0006)\u0011.\\1hK*\u0011Q%\u0013\u0006\u0003\u0015b\na!\u00199bG\",\u0017B\u0001'G\u00055iU\r^1eCR\fG)\u001a7uC\u0006qQ.\u001a;bI\u0006$\u0018\rR3mi\u0006\u0004\u0013AB8gMN,G/F\u0001Q!\tI\u0013+\u0003\u0002SU\t\u0019\u0011J\u001c;\u0002\u0015=4gm]3u?\u0012*\u0017\u000f\u0006\u0002V1B\u0011\u0011FV\u0005\u0003/*\u0012A!\u00168ji\"9\u0011,CA\u0001\u0002\u0004\u0001\u0016a\u0001=%c\u00059qN\u001a4tKR\u0004\u0013AB1dG\u0016\u0004H\u000f\u0006\u0002V;\")al\u0003a\u0001?\u0006)!-\u0019;dQB\u0019\u0001-Z4\u000e\u0003\u0005T!AY2\u0002\tU$\u0018\u000e\u001c\u0006\u0002I\u0006!!.\u0019<b\u0013\t1\u0017M\u0001\u0003MSN$\bC\u00015n\u001b\u0005I'B\u00016l\u0003\u0019\u0019w.\\7p]*\u0011A\u000eS\u0001\u0007g\u0016\u0014h/\u001a:\n\u00059L'\u0001F!qS6+7o]1hK\u0006sGMV3sg&|g.\u0001\u0004wKJLg-\u001f\u000b\u0003+FDQA\u001d\u0007A\u0002M\f\u0001B^3sS\u001aLWM\u001d\t\u0005SQ4X+\u0003\u0002vU\tIa)\u001e8di&|g.\r\t\u0003\u000b^L!\u0001\u001f$\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0003=!Xm\u001d;NS\u001e\u0014\u0018\r^3BG2\u001cHCA+|\u0011\u0015aX\u00021\u0001~\u0003=\u0019G.^:uKJLen\u001d;b]\u000e,\u0007c\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002\u0011\nA\u0001^3ti&\u0019\u0011QA@\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016Ds#DA\u0005\u0003+\t9\"!\u0007\u0002\u001c\u0005\u0015\u0012qEA\u0019\u0003g\ti$a\u0010\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004\u0000\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\tiAA\u0006DYV\u001cH/\u001a:UKN$\u0018a\u00022s_.,'o]\u000f\u0002\u0007\u0005Y1\r\\;ti\u0016\u0014H+\u001f9fI\t\ti\"\u0003\u0003\u0002 \u0005\u0005\u0012A\u0001.L\u0015\u0011\t\u0019#!\u0004\u0002\tQK\b/Z\u0001\nCV$xn\u0015;beR$#!!\u000b\n\t\u0005-\u0012QF\u0001\u00043\u0016\u001b&\u0002BA\u0018\u0003\u001b\t\u0011\"Q;u_N#\u0018M\u001d;\u0002\u001f5,G/\u00193bi\u00064VM]:j_:$#!!\u000e\n\t\u0005]\u0012\u0011H\u0001\f\u0013\n\u0003vlM05?&3\u0006GC\u0002\u0002<%\fq\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u0011g\u0016\u0014h/\u001a:Qe>\u0004XM\u001d;jKNdC!!\u0011\u0002V-R\u00111IA%\u0003\u0017\ny%!\u0015\u0011\t\u0005-\u0011QI\u0005\u0005\u0003\u000f\niAA\u000bDYV\u001cH/\u001a:D_:4\u0017n\u001a)s_B,'\u000f^=\u0002\u0007-,\u00170\t\u0002\u0002N\u0005)\u0012-\u001e;i_JL'0\u001a:/G2\f7o\u001d\u0018oC6,\u0017!\u0002<bYV,\u0017EAA*\u0003\u001dZ\u0017MZ6b]M,7-\u001e:jift\u0013-\u001e;i_JL'0\u001a:/\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:,\u0015\u0005\r\u0013\u0011JA,\u0003\u001f\nY&\t\u0002\u0002Z\u0005Y1/\u001e9fe:*8/\u001a:tC\t\ti&\u0001\bVg\u0016\u0014((\u0011(P\u001dfku*V*\u0002?Q,7\u000f^*uCJ$(l\u001b\"s_.,'oV5uQ\u0006+H\u000f[8sSj,'\u000fF\u0002V\u0003GBa!!\u001a\u000f\u0001\u0004i\u0018!\u0003>l\u00072,8\u000f^3sQ]q\u0011\u0011BA\u000b\u0003/\tI\"a\u0007\u0002&\u0005\u001d\u0012\u0011GA\u001a\u0003{\tI\u0007\f\u0007\u0002B\u0005U\u00131NA;\u0003\u007f\n)i\u000b\u0006\u0002D\u0005%\u0013QNA(\u0003c\n#!a\u001c\u00025%tG/\u001a:/EJ|7.\u001a:/Y&\u001cH/\u001a8fe:r\u0017-\\3\"\u0005\u0005M\u0014\u0001C#Y)\u0016\u0013f*\u0011',\u0015\u0005\r\u0013\u0011JA<\u0003\u001f\nY(\t\u0002\u0002z\u0005IA.[:uK:,'o]\u0011\u0003\u0003{\na\u0006\u0015'B\u0013:#V\t\u0017+;_=bwnY1mQ>\u001cHO\u000f\u0019-\u000bb#VI\u0015(B\u0019jzs\u0006\\8dC2Dwn\u001d;;a-R\u00111IA%\u0003\u0003\u000by%a\u001f\"\u0005\u0005\r\u0015\u0001F1em\u0016\u0014H/[:fI:b\u0017n\u001d;f]\u0016\u00148o\u000b\u0006\u0002D\u0005%\u0013qQA(\u0003\u0017\u000b#!!#\u0002=1L7\u000f^3oKJt3/Z2ve&$\u0018P\f9s_R|7m\u001c7/[\u0006\u0004\u0018EAAG\u0003\u0019*\u0005\fV#S\u001d\u0006c%\b\u0015'B\u0013:#V\t\u0017+-!2\u000b\u0015J\u0014+F1RS\u0004\u000bT!J\u001dR+\u0005\fV\u0001\fi\u0016\u001cH/T5he\u0006$X\rF\u0002V\u0003'CQ\u0001`\bA\u0002uDsbDA\u0005\u0003+\t9\"!\u0007\u0002\u001c\u0005E\u00121G\u0001\u0013i\u0016\u001cH\u000fR;bY^\u0013\u0018\u000e^3TGJ\fW\u000eF\u0002V\u00037Ca!!\u001a\u0011\u0001\u0004i\bf\u0005\t\u0002\n\u0005e\u00111DA\u000b\u0003/\t\t$a(\u0002>\u0005\u0015FEAAQ\u0013\u0011\t\u0019+!\u000f\u0002\u0017%\u0013\u0005kX\u001a`k}KeK\r\u0017\t\u0003W\n)(a \u0002\u0006\u0006iA/Z:u\tV\fGn\u0016:ji\u0016$2!VAV\u0011\u0019\t)'\u0005a\u0001{\"\u001a\u0012#!\u0003\u0002\u001a\u0005m\u0011QCA\f\u0003c\t\u0019$!\u0010\u000202B\u00111NA;\u0003\u007f\n))\u0001\u000euKN$H)^1m/JLG/Z)v_R\f\u0017I\u001c3TGJ\fW\u000eF\u0002V\u0003kCa!!\u001a\u0013\u0001\u0004i\bf\u0005\n\u0002\n\u0005e\u00111DA\u000b\u0003/\t\t$a(\u0002>\u0005eF\u0006CA6\u0003k\ny(!\"\u0002EQ,7\u000f\u001e(fo\u0006sGm\u00115b]\u001e,G\rV8qS\u000e\u001c\u0018J\u001c#vC2<&/\u001b;f)\r)\u0016q\u0018\u0005\u0007\u0003K\u001a\u0002\u0019A?)'M\tI!!\u0007\u0002\u001c\u0005U\u0011qCA\u0019\u0003g\ti$a1-\u0011\u0005-\u0014QOA@\u0003\u000b\u000bAD^3sS\u001aLHk\u001c9jGB\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rF\u0004V\u0003\u0013\f\u0019/!@\t\u000f\u0005-G\u00031\u0001\u0002N\u0006IAo\u001c9jG:\u000bW.\u001a\t\u0005\u0003\u001f\fiN\u0004\u0003\u0002R\u0006e\u0007cAAjU5\u0011\u0011Q\u001b\u0006\u0004\u0003/4\u0013A\u0002\u001fs_>$h(C\u0002\u0002\\*\na\u0001\u0015:fI\u00164\u0017\u0002BAp\u0003C\u0014aa\u0015;sS:<'bAAnU!9\u0011Q\u001d\u000bA\u0002\u0005\u001d\u0018A\u00039beRLG/[8ogB1\u0011\u0011^Ax\u0003gl!!a;\u000b\u0007\u00055(&\u0001\u0006d_2dWm\u0019;j_:LA!!=\u0002l\n\u00191+Z9\u0011\t\u0005U\u0018\u0011`\u0007\u0003\u0003oT!A\u001b%\n\t\u0005m\u0018q\u001f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\ty\u0010\u0006a\u0001\u0005\u0003\t\u0001B_6DY&,g\u000e\u001e\t\u0004c\t\r\u0011b\u0001B\u0003E\ti1*\u00194lCj[7\t\\5f]R\f\u0011\u0002^8qS\u000e$Um]2\u0015\r\t-!\u0011\u0005B\u0013!\u0015I#Q\u0002B\t\u0013\r\u0011yA\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tM!QD\u0007\u0003\u0005+QAAa\u0006\u0003\u001a\u0005)\u0011\rZ7j]*\u0019!1\u0004%\u0002\u000f\rd\u0017.\u001a8ug&!!q\u0004B\u000b\u0005A!v\u000e]5d\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0003$U\u0001\r!!4\u0002\u000bQ|\u0007/[2\t\u000f\t]Q\u00031\u0001\u0003(A!!1\u0003B\u0015\u0013\u0011\u0011YC!\u0006\u0003\u000b\u0005#W.\u001b8\u0002%\u0005dGn\\2bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\u0004+\nE\u0002b\u0002B\u001a-\u0001\u0007\u0011QZ\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<feN\f1C]3bIB\u0013x\u000eZ;dKJLEM\u00117pG.$BA!\u000f\u0003@A\u0019\u0001Na\u000f\n\u0007\tu\u0012N\u0001\tQe>$WoY3s\u0013\u0012\u001c(\t\\8dW\"9\u0011q`\fA\u0002\t\u0005\u0011\u0001E1mi\u0016\u0014Hk\u001c9jG\u000e{gNZ5h)\u0011\u0011)Ea\u0013\u0011\t\tM!qI\u0005\u0005\u0005\u0013\u0012)B\u0001\nBYR,'oQ8oM&<7OU3tk2$\bb\u0002B\f1\u0001\u0007!qE\u0001\u0012C2$XM]\"mS\u0016tG/U;pi\u0006\u001cH\u0003\u0002B)\u0005/\u0002BAa\u0005\u0003T%!!Q\u000bB\u000b\u0005]\tE\u000e^3s\u00072LWM\u001c;Rk>$\u0018m\u001d*fgVdG\u000fC\u0004\u0003\u0018e\u0001\rAa\n\u00025\r\u0014X-\u0019;f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:\u0015\t\tu#1\r\t\u0005\u0005'\u0011y&\u0003\u0003\u0003b\tU!aH!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014Vm];mi\"9!q\u0003\u000eA\u0002\t\u001d\u0012!G1mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN$BA!\u0018\u0003j!9!qC\u000eA\u0002\t\u001d\u0012A\u0005<fe&4\u0017\u0010V8qS\u000e\u001cuN\u001c4jON$2!\u0016B8\u0011\u001d\ty\u0010\ba\u0001\u0005\u0003\t!C^3sS\u001aL8\t\\5f]R\fVo\u001c;bgR\u0019QK!\u001e\t\u000f\u0005}X\u00041\u0001\u0003\u0002\u0005Qb/\u001a:jMf,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1mgR\u0019QKa\u001f\t\u000f\u0005}h\u00041\u0001\u0003\u0002\u0005\u0001b/\u001a:jMf\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\u0006+\n\u0005%Q\u0011\u0005\b\u0005\u0007{\u0002\u0019\u0001B\u001d\u0003Q1\u0017N]:u!J|G-^2fe&#'\t\\8dW\"9\u0011q`\u0010A\u0002\t\u0005\u0011AE:ikR$wn\u001e8J]N+\u0017/^3oG\u0016$R!\u0016BF\u0005\u001bCa!!\u001a!\u0001\u0004i\bb\u0002BHA\u0001\u0007!\u0011S\u0001\rWJ\fg\r^\"mkN$XM\u001d\t\u0005\u0005'\u0013I*\u0004\u0002\u0003\u0016*\u0019!q\u0013\u0013\u0002\u000fQ,7\u000f^6ji&!!1\u0014BK\u0005MY\u0015MZ6b\u00072,8\u000f^3s)\u0016\u001cHoS5uQ\u001d\u0001!qTA(\u0005g\u0003BA!)\u000306\u0011!1\u0015\u0006\u0005\u0005K\u00139+A\u0002ba&TAA!+\u0003,\u00069!.\u001e9ji\u0016\u0014(b\u0001BWq\u0005)!.\u001e8ji&!!\u0011\u0017BR\u0005\u001d!\u0016.\\3pkRt\"!\u0001\u0017)\u000f\u0001\u00119,a\u0014\u0003DB!!\u0011\u0018B`\u001b\t\u0011YL\u0003\u0003\u0003>\n\r\u0016!C3yi\u0016t7/[8o\u0013\u0011\u0011\tMa/\u0003\u0015\u0015CH/\u001a8e/&$\b\u000e\f\u0002\u0003F\u000e\u0012!q\u0019\t\u0005\u0005\u0013\u0014i-\u0004\u0002\u0003L*\u0019!QV@\n\t\t='1\u001a\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8t\u0001")
public class ZkMigrationIntegrationTest {
    private final Logger log = LoggerFactory.getLogger(ZkMigrationIntegrationTest.class);

    public Logger log() {
        return this.log;
    }

    @ClusterTest(brokers=3, clusterType=Type.ZK, autoStart=AutoStart.YES, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer"), @ClusterConfigProperty(key="super.users", value="User:ANONYMOUS")})
    public void testMigrateAcls(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(wildcardPrincipal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        admin.createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava()).all().get();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, (PasswordEncoder)new NoOpPasswordEncoder());
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), x$1 -> {});
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrateAcls$3(acl1, acl2, acl3, acl4, image);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(brokers=3, clusterType=Type.ZK, autoStart=AutoStart.YES, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer"), @ClusterConfigProperty(key="super.users", value="User:ANONYMOUS"), @ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testStartZkBrokerWithAuthorizer(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testStartZkBrokerWithAuthorizer$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.inDualWrite$1(kraftCluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for dual-write mode");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(brokers=3, clusterType=Type.ZK, metadataVersion=MetadataVersion.IBP_3_4_IV0)
    public void testMigrate(ClusterInstance clusterInstance) {
        NoOpPasswordEncoder noOpPasswordEncoder;
        Admin admin = clusterInstance.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test-topic-1", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        newTopics.add(new NewTopic("test-topic-2", 1, (short)3));
        newTopics.add(new NewTopic("test-topic-3", 10, (short)3));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        admin.alterClientQuotas(quotas).all().get(60L, TimeUnit.SECONDS);
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        KafkaConfig kafkaConfig = ((KafkaServer)((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().servers().head()).config();
        Option option = kafkaConfig.passwordEncoderSecret();
        if (option instanceof Some) {
            void encrypting_iterations;
            void encrypting_keyLength;
            void encrypting_cipherAlgorithm;
            Password secret = (Password)((Some)option).value();
            int n = Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderIterations());
            int n2 = Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderKeyLength());
            String string = kafkaConfig.passwordEncoderCipherAlgorithm();
            Option encrypting_keyFactoryAlgorithm = kafkaConfig.passwordEncoderKeyFactoryAlgorithm();
            noOpPasswordEncoder = new EncryptingPasswordEncoder(secret, encrypting_keyFactoryAlgorithm, (String)encrypting_cipherAlgorithm, (int)encrypting_keyLength, (int)encrypting_iterations);
            Object var14_12 = null;
            string = null;
        } else if (None$.MODULE$.equals(option)) {
            noOpPasswordEncoder = new NoOpPasswordEncoder();
        } else {
            throw new MatchError((Object)option);
        }
        NoOpPasswordEncoder zkConfigEncoder = noOpPasswordEncoder;
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, (PasswordEncoder)zkConfigEncoder);
        ZkMigrationLeadershipState migrationState = migrationClient.getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState.EMPTY);
        migrationState = migrationState.withNewKRaftController(3000, 42);
        migrationState = migrationClient.claimControllerLeadership(migrationState);
        HashSet brokers = new HashSet();
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(brokers).asScala().toSeq());
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrate$3(image);
            return BoxedUnit.UNIT;
        });
        migrationClient.releaseControllerLeadership(migrationState);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_5_IV2, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_5_IV2).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteScram$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWrite(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        Properties propsBefore = zkClient.getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((Object)"102400", (Object)propsBefore.getProperty("segment.bytes"));
        Assertions.assertEquals((Object)"300000", (Object)propsBefore.getProperty("segment.ms"));
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.allocateProducerId(zkCluster.bootstrapServers());
            ProducerIdsBlock producerIdBlock = this.readProducerIdBlock(zkClient);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWrite$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterTopicConfig(admin).all().get(60L, TimeUnit.SECONDS);
            this.alterClientQuotas(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyTopicConfigs(zkClient);
            this.verifyClientQuotas(zkClient);
            this.allocateProducerId(zkCluster.bootstrapServers());
            this.verifyProducerId(producerIdBlock, zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_5_IV2, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteQuotaAndScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_5_IV2).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteQuotaAndScram$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.alterClientQuotas(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
            this.verifyClientQuotas(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testNewAndChangedTopicsInDualWrite(ClusterInstance zkCluster) {
        String topicName = "test";
        zkCluster.createAdminClient();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            void var12_20;
            Tuple2 tuple2;
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Create new topic with AdminClient");
            Admin admin = zkCluster.createAdminClient();
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
            newTopics.add(new NewTopic(topicName, 2, (short)3));
            admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
            .colon.colon existingPartitions = new .colon.colon((Object)new TopicPartition(topicName, 0), (List)new .colon.colon((Object)new TopicPartition(topicName, 1), (List)Nil$.MODULE$));
            this.verifyTopicPartitionMetadata(topicName, (Seq<TopicPartition>)existingPartitions, zkClient);
            int newPartitionCount = 3;
            this.log().info("Create new partitions with AdminClient");
            admin.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)NewPartitions.increaseTo((int)newPartitionCount))}))).asJava()).all().get(60L, TimeUnit.SECONDS);
            long l2 = 100L;
            long computeUntilTrue_waitTime = 15000L;
            long computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void computeUntilTrue_pause;
                Option<TopicDescription> computeUntilTrue_result;
                if (ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$4(newPartitionCount, computeUntilTrue_result = this.topicDesc(topicName, admin))) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    break;
                }
                if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
            }
            Object var27_18 = null;
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Option topicDescOpt = (Option)tuple22._1();
            Assertions.assertTrue((boolean)var12_20.isDefined());
            Buffer partitions = CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)var12_20.get()).partitions()).asScala();
            Assertions.assertEquals((int)newPartitionCount, (int)partitions.size());
            this.verifyTopicPartitionMetadata(topicName, (Seq<TopicPartition>)((Seq)existingPartitions.$plus$plus((IterableOnce)new .colon.colon((Object)new TopicPartition(topicName, 2), (List)Nil$.MODULE$))), zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void verifyTopicPartitionMetadata(String topicName, Seq<TopicPartition> partitions, KafkaZkClient zkClient) {
        void var5_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Option computeUntilTrue_result;
            if ((computeUntilTrue_result = ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$1(zkClient, topicName)).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$3(partitions$1, x$2)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Option topicIdReplicaAssignment = (Option)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Unable to find topic metadata in Zk");
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$4(zkClient, partitions, (Option)var5_9)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Unable to find topic partition metadata");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public Option<TopicDescription> topicDesc(String topic, Admin admin) {
        try {
            return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)admin.describeTopics(Collections.singleton(topic)).allTopicNames().get()).asScala().get((Object)topic);
        }
        catch (Throwable throwable) {
            return None$.MODULE$;
        }
    }

    public void allocateProducerId(String bootstrapServers) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrapServers);
        props.put("transactional.id", "some-transaction-id");
        KafkaProducer producer = new KafkaProducer(props, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(new ProducerRecord("test", (Object)"", (Object)"one"));
        producer.commitTransaction();
        producer.flush();
        producer.close();
    }

    /*
     * WARNING - void declaration
     */
    public ProducerIdsBlock readProducerIdBlock(KafkaZkClient zkClient) {
        void var3_3;
        Tuple2 tuple2 = zkClient.getDataAndVersion("/latest_producer_id_block");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        return (ProducerIdsBlock)var3_3.map((Function1 & Serializable)jsonData -> ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(jsonData)).get();
    }

    public AlterConfigsResult alterTopicConfig(Admin admin) {
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "test");
        Collection alterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.bytes", "204800"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.ms", null), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))).asJavaCollection();
        return admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource), (Object)alterConfigs)}))).asJava());
    }

    public AlterClientQuotasResult alterClientQuotas(Admin admin) {
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        return admin.alterClientQuotas(quotas);
    }

    public AlterUserScramCredentialsResult createUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8190), "password0"));
        return admin.alterUserScramCredentials(alterations);
    }

    public AlterUserScramCredentialsResult alterUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8191), "password1"));
        alterations.add(new UserScramCredentialUpsertion("user2", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8192), "password2"));
        return admin.alterUserScramCredentials(alterations);
    }

    public void verifyTopicConfigs(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyTopicConfigs$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyClientQuotas(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyClientQuotas$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyUserScramCredentials(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyUserScramCredentials$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void verifyProducerId(ProducerIdsBlock firstProducerIdBlock, KafkaZkClient zkClient) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyProducerId$1(this, zkClient, firstProducerIdBlock);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var9_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public void shutdownInSequence(ClusterInstance zkCluster, KafkaClusterTestKit kraftCluster) {
        zkCluster.brokerIds().forEach(x$5 -> zkCluster.shutdownBroker(Predef$.MODULE$.Integer2int(x$5)));
        kraftCluster.close();
        zkCluster.stop();
    }

    public static final /* synthetic */ void $anonfun$testMigrateAcls$3(AclBinding acl1$1, AclBinding acl2$1, AclBinding acl3$1, AclBinding acl4$1, MetadataImage image) {
        java.util.Map aclMap = image.acls().acls();
        Assertions.assertEquals((int)4, (int)aclMap.size());
        Assertions.assertTrue((boolean)aclMap.values().containsAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl1$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl2$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl3$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl4$1), (List)Nil$.MODULE$))))).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$testStartZkBrokerWithAuthorizer$1(KafkaZkClient zkClient$1) {
        return zkClient$1.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testStartZkBrokerWithAuthorizer$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    private static final boolean inDualWrite$1(KafkaClusterTestKit kraftCluster$1) {
        return ((MigrationDriverState)((ControllerMigrationSupport)kraftCluster$1.controllers().get(BoxesRunTime.boxToInteger((int)3000)).migrationSupport().get()).migrationDriver().migrationState().get(10L, TimeUnit.SECONDS)).allowDualWrite();
    }

    public static final /* synthetic */ boolean $anonfun$testStartZkBrokerWithAuthorizer$3(KafkaClusterTestKit kraftCluster$1) {
        return ZkMigrationIntegrationTest.inDualWrite$1(kraftCluster$1);
    }

    public static final /* synthetic */ String $anonfun$testStartZkBrokerWithAuthorizer$4() {
        return "Timed out waiting for dual-write mode";
    }

    public static final /* synthetic */ void $anonfun$testMigrate$3(MetadataImage image) {
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-1"));
        Assertions.assertEquals((int)2, (int)image.topics().getTopic("test-topic-1").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-2"));
        Assertions.assertEquals((int)1, (int)image.topics().getTopic("test-topic-2").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-3"));
        Assertions.assertEquals((int)10, (int)image.topics().getTopic("test-topic-3").partitions().size());
        java.util.Map clientQuotas = image.clientQuotas().entities();
        Assertions.assertEquals((int)3, (int)clientQuotas.size());
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteScram$1(KafkaZkClient zkClient$2) {
        return zkClient$2.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDualWrite$1(KafkaZkClient zkClient$3) {
        return zkClient$3.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWrite$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteQuotaAndScram$1(KafkaZkClient zkClient$4) {
        return zkClient$4.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteQuotaAndScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testNewAndChangedTopicsInDualWrite$1(KafkaZkClient zkClient$5) {
        return zkClient$5.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testNewAndChangedTopicsInDualWrite$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ Option $anonfun$testNewAndChangedTopicsInDualWrite$3(ZkMigrationIntegrationTest $this, String topicName$1, ObjectRef admin$1) {
        return $this.topicDesc(topicName$1, (Admin)admin$1.elem);
    }

    public static final /* synthetic */ boolean $anonfun$testNewAndChangedTopicsInDualWrite$4(int newPartitionCount$1, Option td) {
        return td.isDefined() && CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)td.get()).partitions()).asScala().size() == newPartitionCount$1;
    }

    public static final /* synthetic */ Option $anonfun$verifyTopicPartitionMetadata$1(KafkaZkClient zkClient$6, String topicName$2) {
        return zkClient$6.getReplicaAssignmentAndTopicIdForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName$2}))).headOption();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$3(Seq partitions$1, TopicZNode.TopicIdReplicaAssignment x$2) {
        return x$2.assignment().size() == partitions$1.size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$6(TopicPartition tp$1, LeaderIsrAndControllerEpoch lisr$1, TopicZNode.TopicIdReplicaAssignment x$4) {
        Seq seq = ((ReplicaAssignment)x$4.assignment().apply((Object)tp$1)).replicas();
        List list = lisr$1.leaderAndIsr().isr();
        return !(seq != null ? !seq.equals(list) : list != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$5(Option topicIdReplicaAssignment$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$1._2();
            return lisr.leaderAndIsr().leader() >= 0 && topicIdReplicaAssignment$1.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$6(tp, lisr, x$4)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$4(KafkaZkClient zkClient$6, Seq partitions$1, Option topicIdReplicaAssignment$1) {
        Map lisrMap = zkClient$6.getTopicPartitionStates((Seq)partitions$1.toSeq());
        return lisrMap.size() == partitions$1.size() && lisrMap.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$5(topicIdReplicaAssignment$1, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicPartitionMetadata$7() {
        return "Unable to find topic partition metadata";
    }

    public static final /* synthetic */ void $anonfun$verifyTopicConfigs$1(KafkaZkClient zkClient$7) {
        Properties propsAfter = zkClient$7.getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((Object)"204800", (Object)propsAfter.getProperty("segment.bytes"));
        Assertions.assertFalse((boolean)propsAfter.containsKey("segment.ms"));
    }

    public static final /* synthetic */ void $anonfun$verifyClientQuotas$1(KafkaZkClient zkClient$8) {
        Assertions.assertEquals((Object)"1000", (Object)zkClient$8.getEntityConfigs(ConfigType$.MODULE$.User(), "user1").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"800", (Object)zkClient$8.getEntityConfigs("users/user1/clients", "clientA").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"100", (Object)zkClient$8.getEntityConfigs("users/user1/clients", "clientA").getProperty("producer_byte_rate"));
        Assertions.assertEquals((Object)"10", (Object)zkClient$8.getEntityConfigs(ConfigType$.MODULE$.Ip(), "8.8.8.8").getProperty("connection_creation_rate"));
    }

    public static final /* synthetic */ void $anonfun$verifyUserScramCredentials$1(KafkaZkClient zkClient$9) {
        ScramCredential scramCredentials1 = ScramCredentialUtils.credentialFromString((String)zkClient$9.getEntityConfigs(ConfigType$.MODULE$.User(), "user1").getProperty("SCRAM-SHA-256"));
        Assertions.assertEquals((int)8191, (int)scramCredentials1.iterations());
        String propertyValue2 = zkClient$9.getEntityConfigs(ConfigType$.MODULE$.User(), "user2").getProperty("SCRAM-SHA-256");
        Assertions.assertNotNull((Object)propertyValue2);
        ScramCredential scramCredentials2 = ScramCredentialUtils.credentialFromString((String)propertyValue2);
        Assertions.assertEquals((int)8192, (int)scramCredentials2.iterations());
    }

    public static final /* synthetic */ void $anonfun$verifyProducerId$1(ZkMigrationIntegrationTest $this, KafkaZkClient zkClient$10, ProducerIdsBlock firstProducerIdBlock$1) {
        ProducerIdsBlock producerIdBlock = $this.readProducerIdBlock(zkClient$10);
        Assertions.assertTrue((firstProducerIdBlock$1.firstProducerId() < producerIdBlock.firstProducerId() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ Object $anonfun$testNewAndChangedTopicsInDualWrite$4$adapted(int newPartitionCount$1, Option td) {
        return BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$4(newPartitionCount$1, td));
    }

    public static final /* synthetic */ Object $anonfun$verifyTopicPartitionMetadata$2$adapted(Seq partitions$1, Option x) {
        return BoxesRunTime.boxToBoolean((boolean)x.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$3(partitions$1, x$2))));
    }

    public class MetadataDeltaVerifier {
        private final MetadataDelta metadataDelta;
        private int offset;

        public MetadataDelta metadataDelta() {
            return this.metadataDelta;
        }

        public int offset() {
            return this.offset;
        }

        public void offset_$eq(int x$1) {
            this.offset = x$1;
        }

        public void accept(java.util.List<ApiMessageAndVersion> batch) {
            batch.forEach(message -> {
                this.metadataDelta().replay(message.message());
                this.offset_$eq(this.offset() + 1);
            });
        }

        public void verify(Function1<MetadataImage, BoxedUnit> verifier) {
            MetadataImage image = this.metadataDelta().apply(new MetadataProvenance((long)this.offset(), 0, 0L));
            verifier.apply((Object)image);
        }

        public /* synthetic */ ZkMigrationIntegrationTest kafka$zk$ZkMigrationIntegrationTest$MetadataDeltaVerifier$$$outer() {
            return ZkMigrationIntegrationTest.this;
        }

        public MetadataDeltaVerifier() {
            if (ZkMigrationIntegrationTest.this == null) {
                throw null;
            }
            this.metadataDelta = new MetadataDelta(MetadataImage.EMPTY);
            this.offset = 0;
        }
    }
}

