/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.coordinator.transaction.ZkProducerIdManager;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000513Aa\u0004\t\u0001/!)A\u0004\u0001C\u0001;!)q\u0004\u0001C\u0001A!)A\u0007\u0001C\u0001A!)a\u0007\u0001C\u0001A!)\u0001\b\u0001C\u0001A!)!\b\u0001C\u0001A!)A\b\u0001C\u0001A!)a\b\u0001C\u0001A!)\u0001\t\u0001C\u0001A!)!\t\u0001C\u0001A!)A\t\u0001C\u0001A!)a\t\u0001C\u0001A!)\u0001\n\u0001C\u0001A!)!\n\u0001C\u0001A\t)\"l['jOJ\fG/[8o\u00072LWM\u001c;UKN$(BA\t\u0013\u0003%i\u0017n\u001a:bi&|gN\u0003\u0002\u0014)\u0005\u0011!p\u001b\u0006\u0002+\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0019!\tI\"$D\u0001\u0011\u0013\tY\u0002C\u0001\f[W6KwM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002\u001a\u0001\u0005\u0011B/Z:u\u001b&<'/\u0019;f\u000b6\u0004H/\u001f.l)\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#\u0001B+oSRD#A\u0001\u0015\u0011\u0005%\u0012T\"\u0001\u0016\u000b\u0005-b\u0013aA1qS*\u0011QFL\u0001\bUV\u0004\u0018\u000e^3s\u0015\ty\u0003'A\u0003kk:LGOC\u00012\u0003\ry'oZ\u0005\u0003g)\u0012A\u0001V3ti\u0006qA/Z:u\u000b6\u0004H/_,sSR,\u0007FA\u0002)\u0003q!Xm\u001d;Va\u0012\fG/Z#ySN$\u0018N\\4QCJ$\u0018\u000e^5p]ND#\u0001\u0002\u0015\u0002%Q,7\u000f^\"sK\u0006$XMT3x)>\u0004\u0018n\u0019\u0015\u0003\u000b!\n!\u0004^3ti&#W-\u001c9pi\u0016tGo\u0011:fCR,Gk\u001c9jGND#A\u0002\u0015\u00023Q,7\u000f^\"mC&l\u0017IY:f]R\u001cuN\u001c;s_2dWM\u001d\u0015\u0003\u000f!\n\u0001\u0005^3ti\u0016C\u0018n\u001d;j]\u001e\\%+\u00194u\u0007>tGO]8mY\u0016\u00148\t\\1j[\"\u0012\u0001\u0002K\u0001\u001ci\u0016\u001cHOT8o\u0013:\u001c'/Z1tS:<7JU1gi\u0016\u0003xn\u00195)\u0005%A\u0013!\n;fgR\u001cE.Y5n\u0003:$'+\u001a7fCN,W\t_5ti&twmQ8oiJ|G\u000e\\3sQ\tQ\u0001&\u0001\u000euKN$(+Z1e\u0003:$wK]5uKB\u0013x\u000eZ;dKJLE\r\u000b\u0002\fQ\u00059B/Z:u\u001b&<'/\u0019;f)>\u0004\u0018nY\"p]\u001aLwm\u001d\u0015\u0003\u0019!\nq\u0006^3tiR{\u0007/[2B]\u0012\u0014%o\\6fe\u000e{gNZ5hg6KwM]1uS>tw+\u001b;i':\f\u0007o\u001d5piND#!\u0004\u0015\u0002eQ,7\u000f^+qI\u0006$X-\u0012=jgRLgn\u001a+pa&\u001cw+\u001b;i\u001d\u0016<\u0018I\u001c3DQ\u0006tw-\u001a3QCJ$\u0018\u000e^5p]ND#A\u0004\u0015")
public class ZkMigrationClientTest
extends ZkMigrationTestHarness {
    @Test
    public void testMigrateEmptyZk() {
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().readAllMetadata(batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)0, (int)brokers.size());
        Assertions.assertEquals((int)0, (int)batches.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEmptyWrite() {
        void var3_3;
        void var2_2;
        Tuple2 tuple2 = this.zkClient().retryMigrationRequestsUntilConnected((Seq)Nil$.MODULE$, this.migrationState());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int zkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        Assertions.assertEquals((int)this.migrationState().migrationZkVersion(), (int)var2_2);
        Assertions.assertTrue((boolean)var3_3.isEmpty());
    }

    @Test
    public void testUpdateExistingPartitions() {
        Map assignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        this.zkClient().createTopicAssignment("test", (Option)new Some((Object)Uuid.randomUuid()), assignment);
        Map leaderAndIsrs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 0)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(0, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), LeaderRecoveryState.RECOVERED, -1), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test", 1)), (Object)new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, 5, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, -1), 1))}));
        this.zkClient().createTopicPartitionStatesRaw(leaderAndIsrs, 0);
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration(new int[]{0, 1, 2}, new int[]{1, 2}, (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), 1, LeaderRecoveryState.RECOVERED, 6, -1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{3}, (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), 3, LeaderRecoveryState.RECOVERED, 7, -1))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        this.migrationState_$eq(this.migrationClient().topicClient().updateTopicPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)partitions)}))).asJava(), this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        LeaderAndIsr partition0 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 0)).get()).leaderAndIsr();
        Assertions.assertEquals((int)1, (int)partition0.leader());
        Assertions.assertEquals((int)6, (int)partition0.leaderEpoch());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)partition0.isr());
        LeaderAndIsr partition1 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 1)).get()).leaderAndIsr();
        Assertions.assertEquals((int)3, (int)partition1.leader());
        Assertions.assertEquals((int)7, (int)partition1.leaderEpoch());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), (Object)partition1.isr());
        this.migrationState_$eq(this.migrationClient().topicClient().deleteTopic("test", this.migrationState()));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
    }

    @Test
    public void testCreateNewTopic() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration(new int[]{0, 1, 2}, new int[]{0, 1, 2}, (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), 0, LeaderRecoveryState.RECOVERED, 0, -1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), 1, LeaderRecoveryState.RECOVERED, 0, -1))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic("test", Uuid.randomUuid(), partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        LeaderAndIsr partition0 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 0)).get()).leaderAndIsr();
        Assertions.assertEquals((int)0, (int)partition0.leader());
        Assertions.assertEquals((int)0, (int)partition0.leaderEpoch());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)partition0.isr());
        LeaderAndIsr partition1 = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionState(new TopicPartition("test", 1)).get()).leaderAndIsr();
        Assertions.assertEquals((int)1, (int)partition1.leader());
        Assertions.assertEquals((int)0, (int)partition1.leaderEpoch());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)partition1.isr());
    }

    @Test
    public void testIdempotentCreateTopics() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration(new int[]{0, 1, 2}, new int[]{0, 1, 2}, (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), 0, LeaderRecoveryState.RECOVERED, 0, -1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), 1, LeaderRecoveryState.RECOVERED, 0, -1))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        Uuid topicId = Uuid.randomUuid();
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic("test", topicId, partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic("test", topicId, partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
    }

    @Test
    public void testClaimAbsentController() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().zkControllerEpochZkVersion());
    }

    @Test
    public void testExistingKRaftControllerClaim() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().zkControllerEpochZkVersion());
        ZkMigrationLeadershipState otherNodeState = ZkMigrationLeadershipState.EMPTY.withNewKRaftController(3001, 43).withKRaftMetadataOffsetAndEpoch(100L, 42);
        otherNodeState = this.migrationClient().claimControllerLeadership(otherNodeState);
        Assertions.assertEquals((int)2, (int)otherNodeState.zkControllerEpochZkVersion());
        Assertions.assertEquals((int)3001, (int)otherNodeState.kraftControllerId());
        Assertions.assertEquals((int)43, (int)otherNodeState.kraftControllerEpoch());
    }

    @Test
    public void testNonIncreasingKRaftEpoch() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, this.InitialControllerEpoch()));
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().zkControllerEpochZkVersion());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, this.InitialControllerEpoch() - 1));
        ControllerMovedException t1 = (ControllerMovedException)Assertions.assertThrows(ControllerMovedException.class, () -> this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((Object)"Cannot register KRaft controller 3001 with epoch 41 as the current controller register in ZK has the same or newer epoch 42.", (Object)t1.getMessage());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, this.InitialControllerEpoch()));
        ControllerMovedException t2 = (ControllerMovedException)Assertions.assertThrows(ControllerMovedException.class, () -> this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((Object)"Cannot register KRaft controller 3001 with epoch 42 as the current controller register in ZK has the same or newer epoch 42.", (Object)t2.getMessage());
        this.migrationState_$eq(this.migrationState().withNewKRaftController(3001, 100));
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)this.migrationState().kraftControllerEpoch(), (int)100);
        Assertions.assertEquals((int)this.migrationState().kraftControllerId(), (int)3001);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClaimAndReleaseExistingController() {
        void var10_10;
        void var9_9;
        Tuple2 tuple2;
        void var3_3;
        void var2_2;
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        Tuple2 tuple22 = this.zkClient().registerControllerAndIncrementControllerEpoch(100);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int epoch = tuple22._1$mcI$sp();
        int zkVersion = tuple22._2$mcI$sp();
        Assertions.assertEquals((int)var2_2, (int)2);
        Assertions.assertEquals((int)var3_3, (int)1);
        this.migrationState_$eq(this.migrationClient().claimControllerLeadership(this.migrationState()));
        Assertions.assertEquals((int)2, (int)this.migrationState().zkControllerEpochZkVersion());
        Option option = this.zkClient().getControllerEpoch();
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            int zkEpoch = tuple2._1$mcI$sp();
            Stat stat = (Stat)tuple2._2();
            Assertions.assertEquals((int)3, (int)zkEpoch);
            Assertions.assertEquals((int)2, (int)stat.getVersion());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail();
        } else {
            throw new MatchError((Object)option);
        }
        Assertions.assertEquals((int)3000, (int)BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get()));
        Assertions.assertThrows(ControllerMovedException.class, () -> this.zkClient().registerControllerAndIncrementControllerEpoch(100));
        this.migrationState_$eq(this.migrationClient().releaseControllerLeadership(this.migrationState()));
        Tuple2 tuple23 = this.zkClient().registerControllerAndIncrementControllerEpoch(100);
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        int epoch1 = tuple23._1$mcI$sp();
        int zkVersion1 = tuple23._2$mcI$sp();
        Assertions.assertEquals((int)var9_9, (int)4);
        Assertions.assertEquals((int)var10_10, (int)3);
    }

    @Test
    public void testReadAndWriteProducerId() {
        Assertions.assertEquals((long)0L, (long)this.generateNextProducerIdWithZkAndRead$1());
        this.migrationState_$eq(this.migrationClient().writeProducerId(6000L, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Assertions.assertEquals((long)7000L, (long)this.generateNextProducerIdWithZkAndRead$1());
    }

    @Test
    public void testMigrateTopicConfigs() {
        Properties props = new Properties();
        props.put("flush.ms", "60000");
        props.put("retention.ms", "300000");
        AdminZkClient qual$1 = this.adminZkClient();
        Map x$3 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        boolean x$52 = qual$1.createTopicWithAssignment$default$4();
        qual$1.createTopicWithAssignment("test", props, x$3, x$52, true);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateTopics(batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)1, (int)batches.size());
        scala.collection.immutable.Map configs = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)batches.get(0)).asScala().map((Function1 & Serializable)x$4 -> x$4.message())).filter((Function1 & Serializable)message -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClientTest.$anonfun$testMigrateTopicConfigs$4(message)))).map((Function1 & Serializable)x$5 -> (ConfigRecord)x$5)).map((Function1 & Serializable)record -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)record.name()), (Object)record.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertTrue((boolean)configs.contains((Object)"flush.ms"));
        Assertions.assertEquals((Object)"60000", (Object)configs.apply((Object)"flush.ms"));
        Assertions.assertTrue((boolean)configs.contains((Object)"retention.ms"));
        Assertions.assertEquals((Object)"300000", (Object)configs.apply((Object)"retention.ms"));
    }

    @Test
    public void testTopicAndBrokerConfigsMigrationWithSnapshots() {
        KRaftMigrationZkWriter kraftWriter = new KRaftMigrationZkWriter((MigrationClient)this.migrationClient());
        String topicName = "testTopic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topicName, partition);
        int leaderPartition = 1;
        int leaderEpoch = 100;
        int partitionEpoch = 10;
        String brokerId = "1";
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x)))).asJava();
        Uuid topicId = Uuid.randomUuid();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "1");
        props.put(KafkaConfig$.MODULE$.SslKeystorePasswordProp(), this.SECRET());
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        delta.replay(new TopicRecord().setTopicId(topicId).setName(topicName));
        delta.replay(new PartitionRecord().setTopicId(topicId).setIsr(replicas).setLeader(leaderPartition).setReplicas(replicas).setAddingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()).setRemovingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()).setLeaderEpoch(leaderEpoch).setPartitionEpoch(partitionEpoch).setPartitionId(partition).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()));
        CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ZkMigrationClientTest.$anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$2(delta, topicName, brokerId, x0$1);
            return BoxedUnit.UNIT;
        });
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        kraftWriter.handleSnapshot(image, (x$6, x$7, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Set topicIdReplicaAssignment = this.zkClient().getReplicaAssignmentAndTopicIdForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})));
        Assertions.assertEquals((int)1, (int)topicIdReplicaAssignment.size());
        topicIdReplicaAssignment.foreach((Function1 & Serializable)assignment -> {
            ZkMigrationClientTest.$anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$4(topicName, topicId, tp, replicas, assignment);
            return BoxedUnit.UNIT;
        });
        Option topicPartitionState = this.zkClient().getTopicPartitionState(tp);
        Assertions.assertTrue((boolean)topicPartitionState.isDefined());
        topicPartitionState.foreach((Function1 & Serializable)state -> {
            ZkMigrationClientTest.$anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$6(leaderPartition, leaderEpoch, replicas, state);
            return BoxedUnit.UNIT;
        });
        Properties brokerProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), brokerId);
        Properties topicProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), topicName);
        Assertions.assertEquals((int)2, (int)brokerProps.size());
        CollectionConverters$.MODULE$.PropertiesHasAsScala(brokerProps).asScala().foreach((Function1 & Serializable)x0$2 -> {
            ZkMigrationClientTest.$anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$8(this, props, x0$2);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.PropertiesHasAsScala(topicProps).asScala().foreach((Function1 & Serializable)x0$3 -> {
            ZkMigrationClientTest.$anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$9(this, props, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUpdateExistingTopicWithNewAndChangedPartitions() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        Uuid topicId = Uuid.randomUuid();
        java.util.Map partitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration(new int[]{0, 1, 2}, new int[]{0, 1, 2}, (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), 0, LeaderRecoveryState.RECOVERED, 0, -1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), 1, LeaderRecoveryState.RECOVERED, 0, -1))}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        this.migrationState_$eq(this.migrationClient().topicClient().createTopic("test", topicId, partitions, this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        java.util.Map changedPartitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new PartitionRegistration(new int[]{1, 2, 3}, new int[]{1, 2, 3}, (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), 0, LeaderRecoveryState.RECOVERED, 0, -1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new PartitionRegistration(new int[]{0, 1, 2}, new int[]{0, 1, 2}, (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), 1, LeaderRecoveryState.RECOVERED, 0, -1))}))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int k = x0$2._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        this.migrationState_$eq(this.migrationClient().topicClient().updateTopic("test", topicId, changedPartitions, this.migrationState()));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
        Set topicReplicaAssignmentFromZk = this.zkClient().getReplicaAssignmentAndTopicIdForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assertions.assertEquals((int)1, (int)topicReplicaAssignmentFromZk.size());
        Assertions.assertEquals((Object)new Some((Object)topicId), (Object)((TopicZNode.TopicIdReplicaAssignment)topicReplicaAssignmentFromZk.head()).topicId());
        ((TopicZNode.TopicIdReplicaAssignment)topicReplicaAssignmentFromZk.head()).assignment().foreach((Function1 & Serializable)x0$3 -> {
            ZkMigrationClientTest.$anonfun$testUpdateExistingTopicWithNewAndChangedPartitions$3(changedPartitions, x0$3);
            return BoxedUnit.UNIT;
        });
        java.util.Map newPartition = CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new PartitionRegistration(new int[]{2, 3, 4}, new int[]{2, 3, 4}, (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), 1, LeaderRecoveryState.RECOVERED, 0, -1))}))).map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                int k = x0$4._1$mcI$sp();
                PartitionRegistration v = (PartitionRegistration)x0$4._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(k)), (Object)v);
            }
            throw new MatchError(null);
        })).asJava();
        this.migrationState_$eq(this.migrationClient().topicClient().createTopicPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test"), (Object)newPartition)}))).asJava(), this.migrationState()));
        Assertions.assertEquals((int)3, (int)this.migrationState().migrationZkVersion());
        Option newPartitionFromZk = this.zkClient().getTopicPartitionState(new TopicPartition("test", 2));
        Assertions.assertTrue((boolean)newPartitionFromZk.isDefined());
        newPartitionFromZk.foreach((Function1 & Serializable)part -> {
            ZkMigrationClientTest.$anonfun$testUpdateExistingTopicWithNewAndChangedPartitions$5(newPartition, part);
            return BoxedUnit.UNIT;
        });
    }

    private final long generateNextProducerIdWithZkAndRead$1() {
        KafkaZkClient zk_zkClient = this.zkClient();
        int zk_brokerId = 1;
        Object var3_1 = null;
        new ZkProducerIdManager(zk_brokerId, zk_zkClient).generateProducerId();
        ArrayList records = new ArrayList();
        this.migrationClient().migrateProducerId(batch -> records.add(batch));
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((int)1, (int)((java.util.List)records.get(0)).size());
        return ((ProducerIdsRecord)((ApiMessageAndVersion)((java.util.List)records.get(0)).get(0)).message()).nextProducerId();
    }

    public static final /* synthetic */ boolean $anonfun$testMigrateTopicConfigs$4(ApiMessage message) {
        return MetadataRecordType.fromId((short)message.apiKey()).equals((Object)MetadataRecordType.CONFIG_RECORD);
    }

    public static final /* synthetic */ void $anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$2(MetadataDelta delta$1, String topicName$1, String brokerId$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            delta$1.replay(new ConfigRecord().setName(key).setValue(value).setResourceName(topicName$1).setResourceType(ConfigResource.Type.TOPIC.id()));
            delta$1.replay(new ConfigRecord().setName(key).setValue(value).setResourceName(brokerId$1).setResourceType(ConfigResource.Type.BROKER.id()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$4(String topicName$1, Uuid topicId$1, TopicPartition tp$1, java.util.List replicas$1, TopicZNode.TopicIdReplicaAssignment assignment) {
        Assertions.assertEquals((Object)topicName$1, (Object)assignment.topic());
        Assertions.assertEquals((Object)new Some((Object)topicId$1), (Object)assignment.topicId());
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)ReplicaAssignment$.MODULE$.apply((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicas$1).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)))).toSeq()))})), (Object)assignment.assignment());
    }

    public static final /* synthetic */ void $anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$6(int leaderPartition$1, int leaderEpoch$1, java.util.List replicas$1, LeaderIsrAndControllerEpoch state) {
        Assertions.assertEquals((int)leaderPartition$1, (int)state.leaderAndIsr().leader());
        Assertions.assertEquals((int)leaderEpoch$1, (int)state.leaderAndIsr().leaderEpoch());
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERED, (Object)state.leaderAndIsr().leaderRecoveryState());
        Assertions.assertEquals((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(replicas$1).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)))).toList(), (Object)state.leaderAndIsr().isr());
    }

    public static final /* synthetic */ void $anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$8(ZkMigrationClientTest $this, Properties props$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String key = (String)x0$2._1();
            String value = (String)x0$2._2();
            String string = key;
            String string2 = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Assertions.assertEquals((Object)$this.SECRET(), (Object)$this.encoder().decode(value).value());
                return;
            }
            Assertions.assertEquals((Object)props$1.getProperty(key), (Object)value);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testTopicAndBrokerConfigsMigrationWithSnapshots$9(ZkMigrationClientTest $this, Properties props$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String key = (String)x0$3._1();
            String value = (String)x0$3._2();
            String string = key;
            String string2 = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Assertions.assertEquals((Object)$this.SECRET(), (Object)$this.encoder().decode(value).value());
                return;
            }
            Assertions.assertEquals((Object)props$1.getProperty(key), (Object)value);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testUpdateExistingTopicWithNewAndChangedPartitions$3(java.util.Map changedPartitions$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            TopicPartition tp = (TopicPartition)x0$3._1();
            ReplicaAssignment assignment = (ReplicaAssignment)x0$3._2();
            int n = tp.partition();
            switch (n) {
                default: 
            }
            if (n <= 1) {
                Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(((PartitionRegistration)changedPartitions$1.get((Object)BoxesRunTime.boxToInteger((int)n))).replicas)), (Object)assignment.replicas());
                Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(((PartitionRegistration)changedPartitions$1.get((Object)BoxesRunTime.boxToInteger((int)n))).addingReplicas)), (Object)assignment.addingReplicas());
                Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(((PartitionRegistration)changedPartitions$1.get((Object)BoxesRunTime.boxToInteger((int)n))).removingReplicas)), (Object)assignment.removingReplicas());
                return;
            }
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(24).append("Found unknown partition ").append(n).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testUpdateExistingTopicWithNewAndChangedPartitions$5(java.util.Map newPartition$1, LeaderIsrAndControllerEpoch part) {
        PartitionRegistration expectedPartition = (PartitionRegistration)newPartition$1.get(BoxesRunTime.boxToInteger((int)2));
        Assertions.assertEquals((int)expectedPartition.leader, (int)part.leaderAndIsr().leader());
        Assertions.assertEquals((int)(expectedPartition.partitionEpoch + 1), (int)part.leaderAndIsr().partitionEpoch());
        Assertions.assertEquals((int)expectedPartition.leaderEpoch, (int)part.leaderAndIsr().leaderEpoch());
        Assertions.assertEquals((Object)expectedPartition.leaderRecoveryState, (Object)part.leaderAndIsr().leaderRecoveryState());
        Assertions.assertEquals((Object)Predef$.MODULE$.wrapIntArray(expectedPartition.isr).toList(), (Object)part.leaderAndIsr().isr());
    }
}

