/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleanerManagerTest;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogLoader;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r}b\u0001\u0002(P\u0001QCQ!\u0019\u0001\u0005\u0002\tDq!\u001a\u0001C\u0002\u0013\u0005a\r\u0003\u0004p\u0001\u0001\u0006Ia\u001a\u0005\ba\u0002\u0011\r\u0011\"\u0001g\u0011\u0019\t\b\u0001)A\u0005O\"9!\u000f\u0001b\u0001\n\u00031\u0007BB:\u0001A\u0003%q\rC\u0004u\u0001\t\u0007I\u0011\u00014\t\rU\u0004\u0001\u0015!\u0003h\u0011\u001d1\bA1A\u0005\u0002]Dq!a\u0002\u0001A\u0003%\u0001\u0010\u0003\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001x\u0011\u001d\tY\u0001\u0001Q\u0001\naD\u0011\"!\u0004\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005u\u0001\u0001)A\u0005\u0003#A\u0011\"a\b\u0001\u0005\u0004%\t!!\t\t\u0011\u0005U\u0002\u0001)A\u0005\u0003GA\u0011\"a\u000e\u0001\u0005\u0004%\t!!\u000f\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003wA\u0011\"a\u0011\u0001\u0005\u0004%\t!!\u0012\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000fB\u0011\"a\u0014\u0001\u0005\u0004%\t!!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'B\u0011\"a\u0017\u0001\u0005\u0004%\t!!\u0018\t\u0011\u0005U\u0004\u0001)A\u0005\u0003?2a!a\u001e\u0001\u0001\u0005e\u0004\u0002DAA5\t\u0005\t\u0015!\u0003\u0002\u0004\u0006m\u0005\u0002DAO5\t\u0005\t\u0015!\u0003\u0002 \u0006-\u0006\u0002DAW5\t\u0005\t\u0015!\u0003\u00020\u0006U\u0006BB1\u001b\t\u0003\t9\fC\u0004\u0002Dj!\t%!2\t\u000f\u0005U'\u0004\"\u0011\u0002X\"I\u0011\u0011 \u000e\u0012\u0002\u0013\u0005\u00111 \u0005\n\u0005#Q\u0012\u0013!C\u0001\u0005'AqAa\u0006\u0001\t\u0003\u0011I\u0002C\u0004\u00032\u0001!IAa\r\t\u000f\t\r\u0003\u0001\"\u0001\u0003\u001a!9!Q\n\u0001\u0005\u0002\te\u0001b\u0002B)\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005+\u0002A\u0011\u0001B\r\u0011\u001d\u0011I\u0006\u0001C\u0001\u00053AqA!\u0018\u0001\t\u0003\u0011I\u0002C\u0004\u0003b\u0001!\tA!\u0007\t\u000f\t\u0015\u0004\u0001\"\u0001\u0003\u001a!9!\u0011\u000e\u0001\u0005\u0002\te\u0001b\u0002B7\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005c\u0002A\u0011\u0001B\r\u0011\u001d\u0011)\b\u0001C\u0001\u00053AqA!\u001f\u0001\t\u0003\u0011I\u0002C\u0004\u0003~\u0001!\tA!\u0007\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003\u001a!9!Q\u0011\u0001\u0005\u0002\te\u0001b\u0002BE\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005\u001b\u0003A\u0011\u0001B\r\u0011\u001d\u0011\t\n\u0001C\u0001\u00053AqA!&\u0001\t\u0003\u0011I\u0002C\u0004\u0003\u001a\u0002!\tA!\u0007\t\u000f\tu\u0005\u0001\"\u0001\u0003\u001a!9!\u0011\u0015\u0001\u0005\u0002\te\u0001b\u0002BS\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005S\u0003A\u0011\u0001B\r\u0011\u001d\u0011i\u000b\u0001C\u0001\u00053AqA!-\u0001\t\u0003\u0011I\u0002C\u0004\u00036\u0002!\tA!\u0007\t\u000f\te\u0006\u0001\"\u0001\u0003\u001a!9!Q\u0018\u0001\u0005\u0002\te\u0001b\u0002Ba\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005\u000b\u0004A\u0011\u0002Bd\u0011\u001d\u0011Y\r\u0001C\u0005\u0005\u001bDqAa5\u0001\t\u0013\u0011)\u000eC\u0005\u0003h\u0002\t\n\u0011\"\u0003\u0003j\"9!Q\u001e\u0001\u0005\n\t=\bb\u0002B{\u0001\u0011%!q\u001f\u0005\b\u0007\u000f\u0001A\u0011BB\u0005\u0011\u001d\u0019\t\u0002\u0001C\u0005\u0007'A\u0011b!\b\u0001#\u0003%Iaa\b\t\u000f\r\r\u0002\u0001\"\u0003\u0004&\t)Bj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:UKN$(B\u0001)R\u0003\rawn\u001a\u0006\u0002%\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001V7B\u0011a+W\u0007\u0002/*\t\u0001,A\u0003tG\u0006d\u0017-\u0003\u0002[/\n1\u0011I\\=SK\u001a\u0004\"\u0001X0\u000e\u0003uS!AX)\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0001l&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0004\"\u0001\u001a\u0001\u000e\u0003=\u000ba\u0001^7q\t&\u0014X#A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017AA5p\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\5\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u001d!X\u000e\u001d#jeJ\n\u0001\u0002^7q\t&\u0014(\u0007I\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u00059An\\4ESJ\u0014\u0014\u0001\u00037pO\u0012K'O\r\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t\u0001\u0010E\u0002z\u0003\u0007i\u0011A\u001f\u0006\u0003wr\faaY8n[>t'B\u0001*~\u0015\tqx0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0003\t1a\u001c:h\u0013\r\t)A\u001f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u001a\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]J\u0002\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u0005\u0005E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]1.\u0001\u0003vi&d\u0017\u0002BA\u000e\u0003+\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%awn\u001a)s_B\u001c\b%A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u00111\u0005\t\u0005\u0003K\t\t$\u0004\u0002\u0002()\u0019\u0001+!\u000b\u000b\t\u0005-\u0012QF\u0001\nS:$XM\u001d8bYNT1!a\f}\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a\r\u0002(\tIAj\\4D_:4\u0017nZ\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0013\u0001\u0002;j[\u0016,\"!a\u000f\u0011\u0007q\u000bi$C\u0002\u0002@u\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0007_\u001a47/\u001a;\u0016\u0005\u0005\u001d\u0003c\u0001,\u0002J%\u0019\u00111J,\u0003\u0007%sG/A\u0004pM\u001a\u001cX\r\u001e\u0011\u00025A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0016\u0005\u0005M\u0003\u0003BA\u0013\u0003+JA!a\u0016\u0002(\tQ\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u001cuN\u001c4jO\u0006Y\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u001cuN\u001c4jO\u0002\n!c\u00197fC:,'o\u00115fG.\u0004x.\u001b8ugV\u0011\u0011q\f\t\b\u0003C\nY\u0007_A8\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003S:\u0016AC2pY2,7\r^5p]&!\u0011QNA2\u0005\ri\u0015\r\u001d\t\u0004-\u0006E\u0014bAA:/\n!Aj\u001c8h\u0003M\u0019G.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:!\u0005UaunZ\"mK\u0006tWM]'b]\u0006<WM]'pG.\u001c2AGA>!\r!\u0017QP\u0005\u0004\u0003\u007fz%!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe\u00069An\\4ESJ\u001c\b#BAC\u0003+;g\u0002BAD\u0003#sA!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0004\u0003\u001b\u001b\u0016A\u0002\u001fs_>$h(C\u0001Y\u0013\r\t\u0019jV\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9*!'\u0003\u0007M+\u0017OC\u0002\u0002\u0014^KA!!!\u0002~\u0005!An\\4t!\u0019a\u0016\u0011\u0015=\u0002&&\u0019\u00111U/\u0003\tA{w\u000e\u001c\t\u0004I\u0006\u001d\u0016bAAU\u001f\nQQK\\5gS\u0016$Gj\\4\n\t\u0005u\u0015QP\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0011\t\u0005\u0015\u0012\u0011W\u0005\u0005\u0003g\u000b9C\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0005\u0005\u0003[\u000bi\b\u0006\u0005\u0002:\u0006u\u0016qXAa!\r\tYLG\u0007\u0002\u0001!9\u0011\u0011\u0011\u0010A\u0002\u0005\r\u0005bBAO=\u0001\u0007\u0011q\u0014\u0005\b\u0003[s\u0002\u0019AAX\u0003U\tG\u000e\\\"mK\u0006tWM]\"iK\u000e\\\u0007o\\5oiN,\"!a2\u0011\u000f\u0005%\u0017\u0011\u001b=\u0002p9!\u00111ZAg!\r\tIiV\u0005\u0004\u0003\u001f<\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002n\u0005M'bAAh/\u0006\tR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:\u0015\u0011\u0005e\u0017q\\Ar\u0003g\u00042AVAn\u0013\r\tin\u0016\u0002\u0005+:LG\u000f\u0003\u0004\u0002b\u0002\u0002\raZ\u0001\bI\u0006$\u0018\rR5s\u0011%\t)\u000f\tI\u0001\u0002\u0004\t9/\u0001\fqCJ$\u0018\u000e^5p]R{W\u000b\u001d3bi\u0016|%/\u00113e!\u00151\u0016\u0011^Aw\u0013\r\tYo\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rY\u000by\u000f_A8\u0013\r\t\tp\u0016\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005U\b\u0005%AA\u0002\u0005]\u0018!\u00059beRLG/[8o)>\u0014V-\\8wKB!a+!;y\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q \u0016\u0005\u0003O\fyp\u000b\u0002\u0003\u0002A!!1\u0001B\u0007\u001b\t\u0011)A\u0003\u0003\u0003\b\t%\u0011!C;oG\",7m[3e\u0015\r\u0011YaV\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\b\u0005\u000b\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0003\u0016\u0005\u0003o\fy0\u0001\u0005uK\u0006\u0014Hi\\<o)\t\tI\u000eK\u0002$\u0005;\u0001BAa\b\u0003.5\u0011!\u0011\u0005\u0006\u0005\u0005G\u0011)#A\u0002ba&TAAa\n\u0003*\u00059!.\u001e9ji\u0016\u0014(b\u0001B\u0016\u007f\u0006)!.\u001e8ji&!!q\u0006B\u0011\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u000etKR,\b/\u00138de\u0016\f7/\u001b8hYf4\u0015\u000e\u001c;is2{wm\u001d\u000b\t\u0003?\u0013)Da\u000f\u0003@!9!q\u0007\u0013A\u0002\te\u0012A\u00039beRLG/[8ogB)\u0011QQAKq\"9!Q\b\u0013A\u0002\u0005\u001d\u0013aD:uCJ$h*^7CCR\u001c\u0007.Z:\t\u000f\t\u0005C\u00051\u0001\u0002H\u0005q!-\u0019;dQ&s7M]3nK:$\u0018\u0001\f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4UQJ|wo]#yG\u0016\u0004H/[8oQ\r)#q\t\t\u0005\u0005?\u0011I%\u0003\u0003\u0003L\t\u0005\"\u0001\u0002+fgR\f\u0001\b^3ti\u001e\u0013\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a*fiV\u0014hn\u001d'pO^KG\u000f\u001b#jeRLWm\u001d;SCRLw\u000eK\u0002'\u0005\u000f\n\u0011\b^3ti\u001e\u0013\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dunZ%h]>\u0014Xm]+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004O\t\u001d\u0013\u0001\u000f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4JO:|'/Z:J]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004Q\t\u001d\u0013\u0001\u0016;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4JO:|'/Z:C_RD\u0017J\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]N\fe\u000eZ+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004S\t\u001d\u0013!\u000b;fgR$\u0015N\u001d;z\u001f\u001a47/\u001a;SKN,G/\u00134MCJ<WM\u001d+iC:,e\u000eZ(gMN,G\u000fK\u0002+\u0005\u000f\nA\u0006^3ti\u0012K'\u000f^=PM\u001a\u001cX\r\u001e*fg\u0016$\u0018JZ*nC2dWM\u001d+iC:\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u0007-\u00129%A\u001auKN$Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$H*\u0019:hKJ$\u0006.\u00198BGRLg/Z*fO6,g\u000e\u001e\"bg\u0016|eMZ:fi\"\u001aAFa\u0012\u0002aQ,7\u000f\u001e#jeRLxJ\u001a4tKRd\u0015M]4feRC\u0017M\\!di&4XmU3h[\u0016tGOQ1tK>3gm]3uQ\ri#qI\u0001Ei\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3O_R\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf$U\r\\3uK2{wm\u001d\u0015\u0004]\t\u001d\u0013\u0001\u0013;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGmQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017pQ8na\u0006\u001cG\u000fR3mKR,Gj\\4tQ\ry#qI\u0001Ci\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;M_\u001e\u001c\bf\u0001\u0019\u0003H\u0005YC/Z:u\u0019><7/\u00168eKJ\u001cE.Z1okBLe.\u001a7jO&\u0014G.\u001a$pe\u000e{W\u000e]1di&|g\u000eK\u00022\u0005\u000f\nq\u0006^3tiV\u0003H-\u0019;f\u0007\",7m\u001b9pS:$8o\u00155pk2$\u0017\t\u001a3PM\u001a\u001cX\r\u001e+p!\u0006\u0014H/\u001b;j_:D3A\rB$\u00039\"Xm\u001d;Va\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN\u001c\u0006n\\;mIJ+Wn\u001c<f!\u0006\u0014H/\u001b;j_:$\u0015\r^1)\u0007M\u00129%A\u0017uKN$\b*\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKNCw.\u001e7e%\u0016lwN^3ESJ\fe\u000e\u001a#bi\u0006D3\u0001\u000eB$\u00035\"Xm\u001d;NCf\u0014W\r\u0016:v]\u000e\fG/Z\"iK\u000e\\\u0007o\\5oiNCw.\u001e7e)J,hnY1uK\u0012\u000bG/\u0019\u0015\u0004k\t\u001d\u0013\u0001\u0010;fgR\fE\u000e^3s\u0007\",7m\u001b9pS:$H)\u001b:TQ>,H\u000e\u001a*f[>4X\rR1uC&s7K]2ESJ\fe\u000eZ!eI&sg*Z<ESJD3A\u000eB$\u0003!\"Xm\u001d;D_:\u001cWO\u001d:f]RdunZ\"mK\u0006tW\u000f]!oI2{w\r\u0016:v]\u000e\fG/[8oQ\r9$qI\u0001)i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u0019><7\t\\3b]V\u0004\u0018I\u001c3U_BL7\rR3mKRLwN\u001c\u0015\u0004q\t\u001d\u0013A\u0011;fgRdunZ:XSRD7+Z4nK:$8\u000fV8EK2,G/Z*i_VdGMT8u\u0007>t7/\u001b3feVs7\r\\3b]\u0006\u0014G.\u001a)beRLG/[8og\"\u001a\u0011Ha\u0012\u00027Q,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\r>\u0014hj\u001c8fQ\rQ$qI\u0001\"i\u0016\u001cHo\u00117fC:\f'\r\\3PM\u001a\u001cX\r^:BGRLg/Z*fO6,g\u000e\u001e\u0015\u0004w\t\u001d\u0013a\u0007;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s)&lW\rK\u0002=\u0005\u000f\n\u0001\u0005^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001chi\u001c:TQ>\u0014H\u000fV5nK\"\u001aQHa\u0012\u0002QQ,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\u001d\u0016,Gm]\"iK\u000e\\\u0007o\\5oiJ+7/\u001a;)\u0007y\u00129%\u0001\u0016uKN$XK\u001c3fG&$W\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000eR1uC:{Go\u00117fC:\f'\r\\3)\u0007}\u00129%\u0001\tuKN$Hi\u001c8f\u00072,\u0017M\\5oO\"\u001a\u0001Ia\u0012\u0002!Q,7\u000f\u001e#p]\u0016$U\r\\3uS:<\u0007fA!\u0003H\u0005yC/Z:u\u0007\",7m\u001b9pS:$X\u000b\u001d3bi\u0016$gi\u001c:J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e(p\u00072,\u0017M\\5oO\"\u001a!Ia\u0012\u0002aQ,7\u000f^\"iK\u000e\\\u0007o\\5oiV\u0003H-\u0019;fI\u001a{'/\u00138wC2LGm\u00144gg\u0016$hj\u001c;TK2,7\r^3eQ\r\u0019%qI\u0001\u0015GJ,\u0017\r^3DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0015\t\u0005m$\u0011\u001a\u0005\u0007!\u0012\u0003\r!!*\u00021\r\u0014X-\u0019;f\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s\u001b>\u001c7\u000e\u0006\u0003\u0002:\n=\u0007b\u0002Bi\u000b\u0002\u0007\u0011qT\u0001\u0005a>|G.A\u0005de\u0016\fG/\u001a'pORA\u0011Q\u0015Bl\u00057\u0014)\u000fC\u0004\u0003Z\u001a\u0003\r!a\u0012\u0002\u0017M,w-\\3oiNK'0\u001a\u0005\b\u0005;4\u0005\u0019\u0001Bp\u00035\u0019G.Z1okB\u0004v\u000e\\5dsB!\u0011\u0011\u001aBq\u0013\u0011\u0011\u0019/a5\u0003\rM#(/\u001b8h\u0011\u001d1h\t%AA\u0002a\f1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uIM*\"Aa;+\u0007a\fy0A\u000ede\u0016\fG/\u001a'poJ+G/\u001a8uS>tGj\\4D_:4\u0017n\u001a\u000b\u0007\u0003G\u0011\tPa=\t\u000f\te\u0007\n1\u0001\u0002H!9!Q\u001c%A\u0002\t}\u0017\u0001D<sSR,'+Z2pe\u0012\u001cHCCAm\u0005s\u0014YPa@\u0004\u0004!1\u0001+\u0013a\u0001\u0003KCqA!@J\u0001\u0004\t9%\u0001\u0006ok6\u0014\u0015\r^2iKNDqa!\u0001J\u0001\u0004\t9%A\bsK\u000e|'\u000fZ:QKJ\u0014\u0015\r^2i\u0011\u001d\u0019)!\u0013a\u0001\u0003\u000f\n\u0011CY1uG\",7\u000fU3s'\u0016<W.\u001a8u\u00035\t\u0007\u000f]3oIJ+7m\u001c:egR1\u0011\u0011\\B\u0006\u0007\u001bAa\u0001\u0015&A\u0002\u0005\u0015\u0006bBB\b\u0015\u0002\u0007\u0011qI\u0001\u000b]Vl'+Z2pe\u0012\u001c\u0018aB7bW\u0016dun\u001a\u000b\u0007\u0003K\u001b)b!\u0007\t\u0011\r]1\n%AA\u0002\u001d\f1\u0001Z5s\u0011\u001d\u0019Yb\u0013a\u0001\u0003G\taaY8oM&<\u0017!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u00111\u0011\u0005\u0016\u0004O\u0006}\u0018a\u0002:fG>\u0014Hm\u001d\u000b\t\u0007O\u0019\u0019da\u000e\u0004<A!1\u0011FB\u0018\u001b\t\u0019YCC\u0002\u0004.i\faA]3d_J$\u0017\u0002BB\u0019\u0007W\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\bbBB\u001b\u001b\u0002\u0007\u0011qI\u0001\u0004W\u0016L\bbBB\u001d\u001b\u0002\u0007\u0011qI\u0001\u0006m\u0006dW/\u001a\u0005\b\u0007{i\u0005\u0019AA8\u0003%!\u0018.\\3ti\u0006l\u0007\u000f")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File tmpDir2 = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final File logDir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("log", 0);
    private final TopicPartition topicPartition2 = new TopicPartition("log2", 0);
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final int offset;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File tmpDir2() {
        return this.tmpDir2;
    }

    public File logDir() {
        return this.logDir;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public int offset() {
        return this.offset;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private Pool<TopicPartition, UnifiedLog> setupIncreasinglyFilthyLogs(scala.collection.immutable.Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)None$.MODULE$);
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, "compact");
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogSegments segments = new LogSegments(tp);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, this.topicPartition(), logDirFailureChannel, config.recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition(), tpDir, maxTransactionTimeoutMs, this.producerStateManagerConfig(), (Time)this.time());
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)this.time().scheduler(), (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, new ConcurrentHashMap()).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.time().scheduler(), (Time)this.time(), tp, logDirFailureChannel);
        public class Kafka_log_LogCleanerManagerTest$LogMock$1
        extends UnifiedLog {
            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }

            public Kafka_log_LogCleanerManagerTest$LogMock$1(LogCleanerManagerTest $outer, LoadedLogOffsets offsets$1, LocalLog localLog$1, int producerIdExpirationCheckIntervalMs$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$1) {
                super(offsets$1.logStartOffset, localLog$1, new BrokerTopicStats(), producerIdExpirationCheckIntervalMs$1, leaderEpochCache$1, producerStateManager$1, (Option)None$.MODULE$, true, false, (Option)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
            }
        }
        Kafka_log_LogCleanerManagerTest$LogMock$1 log = new Kafka_log_LogCleanerManagerTest$LogMock$1(null, offsets, localLog, producerIdExpirationCheckIntervalMs, leaderEpochCache, producerStateManager);
        this.writeRecords(log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions.assertThrows(LogCleaningException.class, () -> cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get());
        Assertions.assertEquals((Object)((Object)log), (Object)thrownException.log());
        Assertions.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((UnifiedLog)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((UnifiedLog)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        UnifiedLog log = this.createLog(2048, "compact", tp);
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        log.maybeIncrementLogStartOffset(2L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)None$.MODULE$);
        UnifiedLog log = this.createLog(2048, "compact", tp);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact,delete", this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog.size(), (String)"should have 1 logs ready to be deleted");
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(log.config().segmentSize));
        logProps.put("retention.ms", Predef$.MODULE$.long2Long(log.config().retentionMs));
        logProps.put("cleanup.policy", "compact");
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps);
        log.updateConfig(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)0, (int)Option$.MODULE$.option2Iterable(cleanable).size(), (String)"should have 0 logs ready to be compacted");
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable)x$2 -> (TopicPartition)x$2._1()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)1, (int)Option$.MODULE$.option2Iterable(cleanable2).size(), (String)"should have 1 logs ready to be compacted");
        logProps.put("cleanup.policy", "delete");
        LogConfig config2 = new LogConfig((Map)logProps);
        log.updateConfig(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)0, (int)deletableLog2.size(), (String)"should have 0 logs ready to be deleted");
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)((LogToClean)cleanable2.get()).topicPartition(), (List)Nil$.MODULE$));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog3.size(), (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testUpdateCheckpointsShouldAddOffsetToPartition() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertNotEquals((Object)BoxesRunTime.boxToInteger((int)this.offset()), (Object)cleanerManager.allCleanerCheckpoints().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testUpdateCheckpointsShouldRemovePartitionData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        File x$1 = this.logDir();
        Option x$2 = Option$.MODULE$.apply((Object)this.topicPartition());
        Option x$3 = cleanerManager.updateCheckpoints$default$2();
        cleanerManager.updateCheckpoints(x$1, x$3, x$2);
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testHandleLogDirFailureShouldRemoveDirAndData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        cleanerManager.updateCheckpoints(this.logDir2(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition2(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        cleanerManager.handleLogDirFailure(this.logDir().getAbsolutePath());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testMaybeTruncateCheckpointShouldTruncateData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        long lowerOffset = 1L;
        long higherOffset = 1000L;
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), higherOffset);
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), lowerOffset);
        Assertions.assertEquals((long)lowerOffset, (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testAlterCheckpointDirShouldRemoveDataInSrcDirAndAddInNewDir() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.alterCheckpointDir(this.topicPartition(), this.logDir(), this.logDir2());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.handleLogDirFailure(this.logDir2().getAbsolutePath());
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)new .colon.colon((Object)log.topicPartition(), (List)Nil$.MODULE$));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$3 -> (TopicPartition)x$3._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$4 -> (TopicPartition)x$4._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(50L);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.highWatermark(), (long)log.lastStableOffset(), (String)"The high watermark equals the last stable offset as no transactions are in progress");
        Assertions.assertEquals((long)log.lastStableOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset is bounded by the last stable offset.");
    }

    @Test
    public void testCleanableOffsetsActiveSegment() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the active segment.");
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the second block of log entries.");
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        log.updateHighWatermark(log.logEndOffset());
        this.time().sleep(compactionLag + 1);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with active segment.");
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)15L));
        Assertions.assertFalse((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset should not be reset if valid");
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if less than log start offset");
        lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)25L));
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if greater than log end offset");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        void withEndTransactionMarker_marker;
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_records2;
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())};
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var11_10 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())};
        int n = sequence + 2;
        CompressionType withTransactionalRecords_compressionType2 = CompressionType.NONE;
        Object var13_13 = null;
        simpleRecordArray2 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(3L);
        this.time().sleep(compactionLag + 1);
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        EndTransactionMarker endTransactionMarker = new EndTransactionMarker(ControlRecordType.ABORT, 15);
        long withEndTransactionMarker_timestamp = this.time().milliseconds();
        endTransactionMarker = null;
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)0L, (long)withEndTransactionMarker_timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)withEndTransactionMarker_marker), 0, AppendOrigin.COORDINATOR, log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        long endOffset = 1L;
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)), (Object)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact,delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)15L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog, (String)"Log should not be selected for cleaning");
        Assertions.assertEquals((long)20L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp)), (String)"Unselected log should have checkpoint offset updated");
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        ((UnifiedLog)logs.get((Object)tp0)).maybeIncrementLogStartOffset(15L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp0, (Object)BoxesRunTime.boxToLong((long)10L));
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition(), (String)"Dirtier log should be selected");
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp0)), (String)"Unselected log should have checkpoint offset updated");
    }

    private LogCleanerManager createCleanerManager(UnifiedLog log) {
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), logs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, UnifiedLog> pool) {
        return new LogCleanerManagerMock((scala.collection.immutable.Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), pool, null);
    }

    private UnifiedLog createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition) {
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy);
        File partitionDir = new File(this.logDir(), LocalLog$.MODULE$.logDirName(topicPartition));
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        ProducerStateManagerConfig x$9 = this.producerStateManagerConfig();
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        boolean x$16 = false;
        None$ x$17 = None$.MODULE$;
        LogOffsetsListener x$18 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        return UnifiedLog$.MODULE$.apply(partitionDir, config, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, x$10, x$11, x$14, (Option)x$12, true, x$15, x$16, (Option)x$17, x$18);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(1));
        logProps.put("cleanup.policy", cleanupPolicy);
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.double2Double(0.05));
        return new LogConfig((Map)logProps);
    }

    private void writeRecords(UnifiedLog log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1 & Serializable)i -> LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, BoxesRunTime.unboxToInt((Object)i)));
        log.roll(log.roll$default$1());
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(UnifiedLog log, int numRecords) {
        void withRecords_records;
        void withRecords_timestampType;
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(startOffset)).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var9_8 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private UnifiedLog makeLog(File dir, LogConfig config) {
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        ProducerStateManagerConfig x$9 = this.producerStateManagerConfig();
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        boolean x$16 = false;
        None$ x$17 = None$.MODULE$;
        LogOffsetsListener x$18 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        return UnifiedLog$.MODULE$.apply(dir, config, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, x$10, x$11, x$14, (Option)x$12, true, x$15, x$16, (Option)x$17, x$18);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records(int key, int value, long timestamp) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(timestamp, Integer.toString(key).getBytes(), Integer.toString(value).getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        UnifiedLog log = $this.createLog(2048, "compact", tp);
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, UnifiedLog log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll(log$2.roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public LogCleanerManagerTest() {
        this.logProps().put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("segment.index.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("cleanup.policy", "compact");
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime(1400000000000L, 1000L);
        this.offset = 999;
        this.producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        /*
         * WARNING - void declaration
         */
        public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
            void var5_5;
            Predef$.MODULE$.assert(partitionToRemove.isEmpty(), (Function0 & Serializable)() -> "partitionToRemove argument with value not yet handled");
            Tuple2 tuple2 = (Tuple2)partitionToUpdateOrAdd.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("partitionToUpdateOrAdd==None argument not yet handled");
            });
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put((Object)var5_5, (Object)BoxesRunTime.boxToLong((long)l));
        }

        public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
            return None$.MODULE$;
        }

        public Option<TopicPartition> updateCheckpoints$default$3() {
            return None$.MODULE$;
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(scala.collection.immutable.Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

