/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.UnifiedLog$;
import kafka.server.Defaults$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.SnapshotFile;
import org.apache.kafka.storage.internals.log.TxnMetadata;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u001dc\u0001\u0002*T\u0001aCQa\u0018\u0001\u0005\u0002\u0001D\u0011b\u0019\u0001A\u0002\u0003\u0007I\u0011\u00023\t\u00135\u0004\u0001\u0019!a\u0001\n\u0013q\u0007\"\u0003;\u0001\u0001\u0004\u0005\t\u0015)\u0003f\u0011%)\b\u00011AA\u0002\u0013%a\u000fC\u0006\u0002\f\u0001\u0001\r\u00111A\u0005\n\u00055\u0001BCA\t\u0001\u0001\u0007\t\u0011)Q\u0005o\"I\u00111\u0003\u0001C\u0002\u0013%\u0011Q\u0003\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011q\u0005\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002*!I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111\u0007\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u00026!I\u0011Q\b\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002B!I\u0011\u0011\n\u0001C\u0002\u0013%\u0011q\u0005\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002*!I\u0011Q\n\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002R!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA=\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003\u0007\u0003A\u0011AA1\u0011\u001d\ti\t\u0001C\u0001\u0003CBq!!%\u0001\t\u0003\t\t\u0007C\u0004\u0002\u0016\u0002!\t!!\u0019\t\u000f\u0005e\u0005\u0001\"\u0001\u0002b!9\u0011Q\u0014\u0001\u0005\u0002\u0005\u0005\u0004bBAQ\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003K\u0003A\u0011AA1\u0011\u001d\tI\u000b\u0001C\u0001\u0003CBq!!,\u0001\t\u0003\ty\u000bC\u0004\u0002.\u0002!\t!a3\t\u000f\u0005E\u0007\u0001\"\u0001\u0002b!9\u0011Q\u001b\u0001\u0005\u0002\u0005\u0005\u0004bBAm\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003;\u0004A\u0011AA1\u0011\u001d\t\t\u000f\u0001C\u0001\u0003CBq!!:\u0001\t\u0003\t\t\u0007C\u0004\u0002j\u0002!\t!!\u0019\t\u000f\u00055\b\u0001\"\u0001\u0002b!9\u0011\u0011\u001f\u0001\u0005\u0002\u0005\u0005\u0004bBA{\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003s\u0004A\u0011AA1\u0011\u001d\ti\u0010\u0001C\u0001\u0003CBqA!\u0001\u0001\t\u0003\t\t\u0007C\u0004\u0003\u0006\u0001!\t!!\u0019\t\u000f\t%\u0001\u0001\"\u0001\u0002b!9!Q\u0002\u0001\u0005\u0002\u0005\u0005\u0004b\u0002B\t\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005+\u0001A\u0011AA1\u0011\u001d\u0011I\u0002\u0001C\u0001\u0003CBqA!\b\u0001\t\u0003\t\t\u0007C\u0004\u0003\"\u0001!\t!!\u0019\t\u000f\t\u0015\u0002\u0001\"\u0001\u0002b!9!\u0011\u0006\u0001\u0005\u0002\u0005\u0005\u0004b\u0002B\u0017\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005c\u0001A\u0011AA1\u0011\u001d\u0011)\u0004\u0001C\u0001\u0003CBqA!\u000f\u0001\t\u0003\t\t\u0007C\u0004\u0003>\u0001!\t!!\u0019\t\u000f\t\u0005\u0003\u0001\"\u0001\u0002b!9!Q\t\u0001\u0005\u0002\u0005\u0005\u0004b\u0002B%\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005\u001b\u0002A\u0011AA1\u0011\u001d\u0011\t\u0006\u0001C\u0001\u0003CBqA!\u0016\u0001\t\u0003\t\t\u0007C\u0004\u0003Z\u0001!\t!!\u0019\t\u000f\tu\u0003\u0001\"\u0001\u0002b!9!\u0011\r\u0001\u0005\u0002\u0005\u0005\u0004b\u0002B3\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005S\u0002A\u0011AA1\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005_BqAa#\u0001\t\u0013\u0011i\tC\u0005\u0003H\u0002\t\n\u0011\"\u0003\u0003J\"I!q\u001c\u0001\u0012\u0002\u0013%!\u0011\u001d\u0005\b\u0005K\u0004A\u0011\u0002Bt\u0011%\u0019Y\u0001AI\u0001\n\u0013\u0011\t\u000fC\u0005\u0004\u000e\u0001\t\n\u0011\"\u0003\u0004\u0010!I11\u0003\u0001\u0012\u0002\u0013%1Q\u0003\u0005\b\u0005K\u0004A\u0011BB\r\u0011\u001d\u0019i\u0003\u0001C\u0005\u0007_\u0011\u0001\u0004\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014H+Z:u\u0015\t!V+A\u0002m_\u001eT\u0011AV\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\f\u0005\u0002[;6\t1LC\u0001]\u0003\u0015\u00198-\u00197b\u0013\tq6L\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0004\"A\u0019\u0001\u000e\u0003M\u000ba\u0001\\8h\t&\u0014X#A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017AA5p\u0015\u0005Q\u0017\u0001\u00026bm\u0006L!\u0001\\4\u0003\t\u0019KG.Z\u0001\u000bY><G)\u001b:`I\u0015\fHCA8s!\tQ\u0006/\u0003\u0002r7\n!QK\\5u\u0011\u001d\u00198!!AA\u0002\u0015\f1\u0001\u001f\u00132\u0003\u001dawn\u001a#je\u0002\nAb\u001d;bi\u0016l\u0015M\\1hKJ,\u0012a\u001e\t\u0004q\u0006\u001dQ\"A=\u000b\u0005QS(BA>}\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002~}\u000691\u000f^8sC\u001e,'B\u0001,\u0000\u0015\u0011\t\t!a\u0001\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)!A\u0002pe\u001eL1!!\u0003z\u0005Q\u0001&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u0006\u00012\u000f^1uK6\u000bg.Y4fe~#S-\u001d\u000b\u0004_\u0006=\u0001bB:\u0007\u0003\u0003\u0005\ra^\u0001\u000egR\fG/Z'b]\u0006<WM\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tWCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f}\u000611m\\7n_:LA!!\t\u0002\u001c\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u00039beRLG/[8oA\u0005Q\u0001O]8ek\u000e,'/\u00133\u0016\u0005\u0005%\u0002c\u0001.\u0002,%\u0019\u0011QF.\u0003\t1{gnZ\u0001\faJ|G-^2fe&#\u0007%A\fnCb$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;NgV\u0011\u0011Q\u0007\t\u00045\u0006]\u0012bAA\u001d7\n\u0019\u0011J\u001c;\u000215\f\u0007\u0010\u0016:b]N\f7\r^5p]RKW.Z8vi6\u001b\b%\u0001\u000eqe>$WoY3s'R\fG/Z'b]\u0006<WM]\"p]\u001aLw-\u0006\u0002\u0002BA\u0019\u00010a\u0011\n\u0007\u0005\u0015\u0013P\u0001\u000eQe>$WoY3s'R\fG/Z'b]\u0006<WM]\"p]\u001aLw-A\u000eqe>$WoY3s'R\fG/Z'b]\u0006<WM]\"p]\u001aLw\rI\u0001\u0019Y\u0006$X\r\u0016:b]N\f7\r^5p]RKW.Z8vi6\u001b\u0018!\u00077bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0002\nA\u0001^5nKV\u0011\u0011\u0011\u000b\t\u0005\u0003'\nI&\u0004\u0002\u0002V)!\u0011qKA\u000e\u0003\u0015)H/\u001b7t\u0013\u0011\tY&!\u0016\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nQa]3u+B$\u0012a\u001c\u0015\u0004)\u0005\u0015\u0004\u0003BA4\u0003kj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\u0004CBL'\u0002BA8\u0003c\nqA[;qSR,'O\u0003\u0003\u0002t\u0005\r\u0011!\u00026v]&$\u0018\u0002BA<\u0003S\u0012!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u000b\u0002~A!\u0011qMA@\u0013\u0011\t\t)!\u001b\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0005;fgR\u0014\u0015m]5d\u0013\u0012l\u0015\r\u001d9j]\u001eD3AFAD!\u0011\t9'!#\n\t\u0005-\u0015\u0011\u000e\u0002\u0005)\u0016\u001cH/\u0001\u0014uKN$\u0018\t\u001d9f]\u0012$\u0006P\\'be.,'oV5uQ:{\u0007K]8ek\u000e,'o\u0015;bi\u0016D3aFAD\u0003y!Xm\u001d;Qe>$WoY3s'\u0016\fX/\u001a8dK^\u0013\u0018\r]!s_VtG\rK\u0002\u0019\u0003\u000f\u000bQ\u0006^3tiB\u0013x\u000eZ;dKJ\u001cV-];f]\u000e,w+\u001b;i/J\f\u0007/\u0011:pk:$')\u0019;dQJ+7m\u001c:eQ\rI\u0012qQ\u0001&i\u0016\u001cH\u000f\u0015:pIV\u001cWM]*fcV,gnY3J]Z\fG.\u001b3Xe\u0006\u0004\u0018I]8v]\u0012D3AGAD\u0003)\"Xm\u001d;O_Z\u000bG.\u001b3bi&|gn\u00148GSJ\u001cH/\u00128uef<\u0006.\u001a8M_\u0006$\u0017N\\4M_\u001eD3aGAD\u0003\r\"Xm\u001d;D_:$(o\u001c7SK\u000e|'\u000f\u001a\"v[B\u001c\bK]8ek\u000e,'/\u00129pG\"D3\u0001HAD\u0003\u0001\"Xm\u001d;Uq:4\u0015N]:u\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a3)\u0007u\t9)A\ruKN$8k[5q\u000b6\u0004H/\u001f+sC:\u001c\u0018m\u0019;j_:\u001c\bf\u0001\u0010\u0002\b\u00069\u0012m]:feR$\u0006P\\'fi\u0006$\u0017\r^1FcV\fGn\u001d\u000b\u0006_\u0006E\u0016q\u0019\u0005\b\u0003g{\u0002\u0019AA[\u0003!)\u0007\u0010]3di\u0016$\u0007CBA\\\u0003{\u000b\t-\u0004\u0002\u0002:*\u0019\u00111X5\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u007f\u000bIL\u0001\u0003MSN$\bc\u0001=\u0002D&\u0019\u0011QY=\u0003\u0017QCh.T3uC\u0012\fG/\u0019\u0005\b\u0003\u0013|\u0002\u0019AA[\u0003\u0019\t7\r^;bYR)q.!4\u0002P\"9\u00111\u0017\u0011A\u0002\u0005\u0005\u0007bBAeA\u0001\u0007\u0011\u0011Y\u0001\u0017i\u0016\u001cH\u000fS1t\u0019\u0006$X\r\u0016:b]N\f7\r^5p]\"\u001a\u0011%a\"\u0002YQ,7\u000f\u001e%bg2\u000bG/\u001a+sC:\u001c\u0018m\u0019;j_:Le.\u001b;jC2L'0\u001a3BMR,'OU3m_\u0006$\u0007f\u0001\u0012\u0002\b\u0006\u0019D/Z:u\u0011\u0006\u001cH*\u0019;f)J\fgn]1di&|g.\u00169eCR,G-\u00114uKJ\u0004\u0016M\u001d;jC2$&/\u001e8dCRLwN\u001c\u0015\u0004G\u0005\u001d\u0015\u0001\r;fgRD\u0015m\u001d'bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8Va\u0012\fG/\u001a3BMR,'OR;mYR\u0013XO\\2bi&|g\u000eK\u0002%\u0003\u000f\u000b\u0001\u0005^3ti2\u000b7\u000f^*uC\ndWm\u00144gg\u0016$8i\\7qY\u0016$X\r\u001a+y]\"\u001aQ%a\"\u0002=Q,7\u000f\u001e)sKB\f'/Z+qI\u0006$X\rR8fg:{G/T;uCR,\u0007f\u0001\u0014\u0002\b\u0006qR\u000f\u001d3bi\u0016\u0004&o\u001c3vG\u0016\u0014HK]1og\u0006\u001cG/[8o'R\fG/\u001a\u0015\u0004O\u0005\u001d\u0015\u0001\f;fgR|U\u000f^(g'\u0016\fX/\u001a8dK\u00063G/\u001a:D_:$(o\u001c7SK\u000e|'\u000fZ#q_\u000eD')^7qQ\rA\u0013qQ\u00011i\u0016\u001cHOT8o)J\fgn]1di&|g.\u00197BaB,g\u000eZ,ji\"|enZ8j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8)\u0007%\n9)A\u0018uKN$HK];oG\u0006$X-\u00118e%\u0016dw.\u00193SK6|g/Z:PkR|eMU1oO\u0016\u001cf.\u00199tQ>$8\u000fK\u0002+\u0003\u000f\u000b\u0001\u0003^3tiR\u000b7.Z*oCB\u001c\bn\u001c;)\u0007-\n9)\u0001\u0017uKN$(+Z2pm\u0016\u0014hI]8n':\f\u0007o\u001d5piVsg-\u001b8jg\",G\r\u0016:b]N\f7\r^5p]\"\u001aA&a\"\u0002UQ,7\u000f\u001e*fG>4XM\u001d$s_6\u001cf.\u00199tQ>$h)\u001b8jg\",G\r\u0016:b]N\f7\r^5p]\"\u001aQ&a\"\u0002OQ,7\u000f\u001e*fG>4XM\u001d$s_6\u001cf.\u00199tQ>$X)\u001c9usR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004]\u0005\u001d\u0015\u0001\u000b;fgR\u0004&o\u001c3vG\u0016\u00148\u000b^1uK\u00063G/\u001a:GK:\u001c\u0017N\\4BE>\u0014H/T1sW\u0016\u0014\bfA\u0018\u0002\b\u0006iB/Z:u%\u0016lwN^3FqBL'/\u001a3QS\u0012\u001cxJ\u001c*fY>\fG\rK\u00021\u0003\u000f\u000bQ\u0006^3ti\u0006\u001b7-\u001a9u\u0003B\u0004XM\u001c3XSRDw.\u001e;Qe>$WoY3s'R\fG/Z(o%\u0016\u0004H.[2bQ\r\t\u0014qQ\u0001*i\u0016\u001cH/Q2dKB$\u0018\t\u001d9f]\u0012<\u0016\u000e\u001e5TKF,XM\\2f\u000f\u0006\u00048o\u00148SKBd\u0017nY1)\u0007I\n9)A\ruKN$H)\u001a7fi\u0016\u001cf.\u00199tQ>$8OQ3g_J,\u0007fA\u001a\u0002\b\u0006YB/Z:u)J,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003RD3\u0001NAD\u0003M!Xm\u001d;SK2|\u0017\rZ*oCB\u001c\bn\u001c;tQ\r)\u0014qQ\u0001'i\u0016\u001cHOR5sgR,fn\u001d;bE2,wJ\u001a4tKR\fe\r^3s)J,hnY1uS>t\u0007f\u0001\u001c\u0002\b\u0006qC/Z:u\u0019>\fGM\u0012:p[Ns\u0017\r]:i_R\u0014V\r^1j]NtuN\\#ya&\u0014X\r\u001a)s_\u0012,8-\u001a:tQ\r9\u0014qQ\u0001\"i\u0016\u001cHoU6jaNs\u0017\r]:i_RLem\u00144gg\u0016$XK\\2iC:<W\r\u001a\u0015\u0004q\u0005\u001d\u0015\u0001\u0007;fgR\u0004\u0016\u000eZ#ya&\u0014\u0018\r^5p]RKW.Z8vi\"\u001a\u0011(a\"\u0002/Q,7\u000f\u001e$jeN$XK\\:uC\ndWm\u00144gg\u0016$\bf\u0001\u001e\u0002\b\u0006qC/Z:u!J|G-^2feN<\u0016\u000e\u001e5P]\u001e|\u0017N\\4Ue\u0006t7/Y2uS>t7\u000fR8oi\u0016C\b/\u001b:fQ\rY\u0014qQ\u0001.i\u0016\u001cHoU3rk\u0016t7-\u001a(piZ\u000bG.\u001b3bi\u0016$gi\u001c:He>,\b/T3uC\u0012\fG/\u0019+pa&\u001c\u0007f\u0001\u001f\u0002\b\u0006aB/Z:u\u001f2$W\t]8dQ\u001a{'oQ8oiJ|GNU3d_J$\u0007fA\u001f\u0002\b\u00061B/Z:u\u0007>|'\u000fZ5oCR|'OR3oG&tw\rK\u0002?\u0003\u000f\u000b\u0001\u0005^3ti\u000e{wN\u001d3j]\u0006$xN\u001d$f]\u000e,G-\u00114uKJ\u0014V\r\\8bI\"\u001aq(a\"\u0002;Q,7\u000f\u001e'pC\u00124%o\\7F[B$\u0018p\u00158baNDw\u000e\u001e$jY\u0016D3\u0001QAD\u0003\u0005\"Xm\u001d;M_\u0006$gI]8n)J,hnY1uK\u0012\u001cf.\u00199tQ>$h)\u001b7fQ\r\t\u0015qQ\u0001 i\u0016\u001cH\u000fT8bI\u001a\u0013x.\\\"peJ,\b\u000f^*oCB\u001c\bn\u001c;GS2,\u0007f\u0001\"\u0002\b\u0006YB/Z:u\u0003B\u0004XM\u001c3F[B$\u0018pQ8oiJ|GNQ1uG\"D3aQAD\u0003E\"Xm\u001d;SK6|g/Z*ue\u0006L8K\\1qg\"|Go]&fKB\u001cE.Z1o'\",H\u000fZ8x]Ns\u0017\r]:i_RD3\u0001RAD\u0003m!Xm\u001d;SK6|g/Z!mYN#(/Y=T]\u0006\u00048\u000f[8ug\"\u001aQ)a\"\u0002IQ,7\u000f\u001e*f[>4X-\u00118e\u001b\u0006\u00148n\u00158baNDw\u000e\u001e$pe\u0012+G.\u001a;j_:D3ARAD\u0003I\"Xm\u001d;SK6|g/Z!oI6\u000b'o[*oCB\u001c\bn\u001c;G_J$U\r\\3uS>t\u0017\t\u001c:fC\u0012LH)\u001a7fi\u0016$\u0007fA$\u0002\b\u0006YB/Z:u\u0019>\fGM\u0012:p[\u000e{'O];qiNs\u0017\r]:i_R$2a\u001cB9\u0011\u001d\u0011\u0019\b\u0013a\u0001\u0005k\nq\"\\1lK\u001aKG.Z\"peJ,\b\u000f\u001e\t\u00075\n]$1P8\n\u0007\te4LA\u0005Gk:\u001cG/[8ocA!!Q\u0010BD\u001b\t\u0011yH\u0003\u0003\u0003\u0002\n\r\u0015\u0001C2iC:tW\r\\:\u000b\u0007\t\u0015\u0015.A\u0002oS>LAA!#\u0003\u0000\tYa)\u001b7f\u0007\"\fgN\\3m\u0003I\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0015!\t=%1\u0014BP\u0005C\u0013YKa/\u0003@\n\r\u0007#\u0002.\u0003\u0012\nU\u0015b\u0001BJ7\n1q\n\u001d;j_:\u00042\u0001\u001fBL\u0013\r\u0011I*\u001f\u0002\r\u0007>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\u0005\u0007\u0005;K\u0005\u0019A<\u0002\u000f5\f\u0007\u000f]5oO\"9\u0011QE%A\u0002\u0005%\u0002b\u0002BR\u0013\u0002\u0007!QU\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007i\u00139+C\u0002\u0003*n\u0013Qa\u00155peRDqA!,J\u0001\u0004\u0011y+A\u0006d_:$(o\u001c7UsB,\u0007\u0003\u0002BY\u0005ok!Aa-\u000b\t\tU\u00161D\u0001\u0007e\u0016\u001cwN\u001d3\n\t\te&1\u0017\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007b\u0002B_\u0013\u0002\u0007\u0011\u0011F\u0001\u0007_\u001a47/\u001a;\t\u0013\t\u0005\u0017\n%AA\u0002\u0005U\u0012\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011%\u0011)-\u0013I\u0001\u0002\u0004\tI#A\u0005uS6,7\u000f^1na\u0006a\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3sI\u0011,g-Y;mi\u00122TC\u0001BfU\u0011\t)D!4,\u0005\t=\u0007\u0003\u0002Bi\u00057l!Aa5\u000b\t\tU'q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!7\\\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005;\u0014\u0019NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA$\u00199qK:$WI\u001c3Uq:l\u0015M]6fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0003d*\"\u0011\u0011\u0006Bg\u0003\u0019\t\u0007\u000f]3oIR\trN!;\u0003l\n5(q\u001eBz\u0005k\u00149p!\u0001\t\u000bUd\u0005\u0019A<\t\u000f\u0005\u0015B\n1\u0001\u0002*!9!1\u0015'A\u0002\t\u0015\u0006b\u0002By\u0019\u0002\u0007\u0011QG\u0001\u0004g\u0016\f\bb\u0002B_\u0019\u0002\u0007\u0011\u0011\u0006\u0005\n\u0005\u000bd\u0005\u0013!a\u0001\u0003SA\u0011B!?M!\u0003\u0005\rAa?\u0002\u001f%\u001cHK]1og\u0006\u001cG/[8oC2\u00042A\u0017B\u007f\u0013\r\u0011yp\u0017\u0002\b\u0005>|G.Z1o\u0011%\u0019\u0019\u0001\u0014I\u0001\u0002\u0004\u0019)!\u0001\u0004pe&<\u0017N\u001c\t\u0004q\u000e\u001d\u0011bAB\u0005s\na\u0011\t\u001d9f]\u0012|%/[4j]\u0006\u0001\u0012\r\u001d9f]\u0012$C-\u001a4bk2$HEN\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uI]*\"a!\u0005+\t\tm(QZ\u0001\u0011CB\u0004XM\u001c3%I\u00164\u0017-\u001e7uIa*\"aa\u0006+\t\r\u0015!Q\u001a\u000b\f_\u000em1QDB\u0010\u0007C\u0019Y\u0003C\u0003v!\u0002\u0007q\u000fC\u0004\u0002&A\u0003\r!!\u000b\t\u000f\tu\u0006\u000b1\u0001\u0002*!911\u0005)A\u0002\r\u0015\u0012!\u00022bi\u000eD\u0007\u0003\u0002BY\u0007OIAa!\u000b\u00034\nY!+Z2pe\u0012\u0014\u0015\r^2i\u0011\u001d\u0019\u0019\u0001\u0015a\u0001\u0007\u000b\tacY;se\u0016tGo\u00158baNDw\u000e^(gMN,Go]\u000b\u0003\u0007c\u0001baa\r\u0004B\u0005%b\u0002BB\u001b\u0007{\u00012aa\u000e\\\u001b\t\u0019IDC\u0002\u0004<]\u000ba\u0001\u0010:p_Rt\u0014bAB 7\u00061\u0001K]3eK\u001aLAaa\u0011\u0004F\t\u00191+\u001a;\u000b\u0007\r}2\f")
public class ProducerStateManagerTest {
    private File logDir;
    private ProducerStateManager stateManager;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxTransactionTimeoutMs;
    private final ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
    private final long lateTransactionTimeoutMs = (long)this.maxTransactionTimeoutMs() + 300000L;
    private final MockTime time = new MockTime();

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private ProducerStateManager stateManager() {
        return this.stateManager;
    }

    private void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private long producerId() {
        return this.producerId;
    }

    private int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    private ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    private long lateTransactionTimeoutMs() {
        return this.lateTransactionTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time()));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, AppendOrigin.CLIENT);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, false, AppendOrigin.CLIENT));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, false, AppendOrigin.CLIENT));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, false, AppendOrigin.CLIENT);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, false, AppendOrigin.CLIENT));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).orElseThrow(() -> new RuntimeException("Expected last entry to be defined"));
        Assertions.assertEquals((short)producerEpoch, (short)firstEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assertions.assertEquals((int)-1, (int)firstEntry.lastSeq());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, false, AppendOrigin.CLIENT));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, false, AppendOrigin.CLIENT));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, false, AppendOrigin.CLIENT);
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).orElseThrow(() -> new RuntimeException("Expected last entry to be defined"));
        Assertions.assertEquals((short)producerEpoch, (short)secondEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assertions.assertEquals((int)0, (int)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)0, (int)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.REPLICATION);
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L), 2020L, false);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0x7FFFFFF5, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)9, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), false, AppendOrigin.CLIENT));
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        boolean x$8 = false;
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, AppendOrigin.REPLICATION);
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsProducerEpoch() {
        short producerEpoch = (short)0;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        short bumpedProducerEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedProducerEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Optional maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)bumpedProducerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((int)-1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)-1, (int)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedProducerEpoch, 0, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)0L)), this.stateManager().lastEntry(this.producerId()).map(x$3 -> BoxesRunTime.boxToLong((long)x$3.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry.empty((long)this.producerId()), AppendOrigin.CLIENT);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assertions.assertEquals(Optional.of(firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testSkipEmptyTransactions() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        ProducerAppendInfo firstAppend = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        this.appendData$1(16L, 20L, firstAppend, producerEpoch, seq);
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), 16L), (TxnMetadata)firstAppend.startedTransactions().get(0));
        this.stateManager().update(firstAppend);
        this.stateManager().onHighWatermarkUpdated(21L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(16L)), (Object)this.stateManager().firstUnstableOffset());
        ProducerAppendInfo secondAppend = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        Option firstCompletedTxn = this.appendEndTxn$1(ControlRecordType.COMMIT, 21L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertEquals((Object)new Some((Object)new CompletedTxn(this.producerId(), 16L, 21L, false)), (Object)firstCompletedTxn);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.COMMIT, 22L, secondAppend, coordinatorEpoch, producerEpoch));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 23L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(24L, 27L, secondAppend, producerEpoch, seq);
        Option secondCompletedTxn = this.appendEndTxn$1(ControlRecordType.ABORT, 28L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertTrue((boolean)secondCompletedTxn.isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 29L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(30L, 31L, secondAppend, producerEpoch, seq);
        int size = secondAppend.startedTransactions().size();
        Assertions.assertEquals((int)2, (int)size);
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), new LogOffsetMetadata(24L)), (TxnMetadata)secondAppend.startedTransactions().get(0));
        this.assertTxnMetadataEquals(new TxnMetadata(this.producerId(), new LogOffsetMetadata(30L)), (TxnMetadata)secondAppend.startedTransactions().get(size - 1));
        this.stateManager().update(secondAppend);
        this.stateManager().completeTxn((CompletedTxn)firstCompletedTxn.get());
        this.stateManager().completeTxn((CompletedTxn)secondCompletedTxn.get());
        this.stateManager().onHighWatermarkUpdated(32L);
        Assertions.assertEquals(Optional.of(new LogOffsetMetadata(30L)), (Object)this.stateManager().firstUnstableOffset());
    }

    public void assertTxnMetadataEquals(List<TxnMetadata> expected, List<TxnMetadata> actual) {
        Iterator<TxnMetadata> expectedIter = expected.iterator();
        Iterator<TxnMetadata> actualIter = actual.iterator();
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        while (expectedIter.hasNext() && actualIter.hasNext()) {
            this.assertTxnMetadataEquals(expectedIter.next(), actualIter.next());
        }
    }

    public void assertTxnMetadataEquals(TxnMetadata expected, TxnMetadata actual) {
        Assertions.assertEquals((long)expected.producerId, (long)actual.producerId);
        Assertions.assertEquals((Object)expected.firstOffset, (Object)actual.firstOffset);
        Assertions.assertEquals((Object)expected.lastOffset, (Object)actual.lastOffset);
    }

    @Test
    public void testHasLateTransaction() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId1, epoch1, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, producerId2, epoch2, 0, 150L, x$15, true, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() - 500L + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId1, epoch1, ControlRecordType.COMMIT, 200L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId2, epoch2, ControlRecordType.COMMIT, 250L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionInitializedAfterReload() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId1, epoch1, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, producerId2, epoch2, 0, 150L, x$15, true, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().takeSnapshot();
        this.time().sleep(this.lateTransactionTimeoutMs() - 500L + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, this.stateManager().mapEndOffset(), this.time().milliseconds());
        Assertions.assertTrue((boolean)reloadedStateManager.hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterPartialTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId, epoch, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateAndReload(0L, 80L, this.time().milliseconds());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterFullTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, producerId, epoch, 0, 100L, x$7, true, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(this.lateTransactionTimeoutMs() + 1L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateFullyAndStartAt(150L);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)startOffset2)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)startOffset2)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assertions.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L), 20L, false);
        Assertions.assertEquals(Optional.empty(), (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L), 30L, false);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), false, AppendOrigin.CLIENT);
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), AppendOrigin.CLIENT);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)OptionalLong.of(16L), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L)), appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)OptionalLong.of(16L), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L)), appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        Optional completedTxnOpt = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assertions.assertTrue((boolean)completedTxnOpt.isPresent());
        CompletedTxn completedTxn = (CompletedTxn)completedTxnOpt.get();
        Assertions.assertEquals((long)this.producerId(), (long)completedTxn.producerId);
        Assertions.assertEquals((long)16L, (long)completedTxn.firstOffset);
        Assertions.assertEquals((long)40L, (long)completedTxn.lastOffset);
        Assertions.assertFalse((boolean)completedTxn.isAborted);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((int)coordinatorEpoch, (int)lastEntry.coordinatorEpoch());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        this.assertTxnMetadataEquals(Arrays.asList(new TxnMetadata(this.producerId(), 16L)), appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            long x$23 = this.append$default$6();
            AppendOrigin x$24 = AppendOrigin.CLIENT;
            this.append(x$17, x$18, bumpedEpoch, 2, 2L, x$23, true, x$24);
        });
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            long x$31 = this.append$default$6();
            AppendOrigin x$32 = AppendOrigin.CLIENT;
            this.append(x$25, x$26, x$27, 2, 2L, x$31, true, x$32);
        });
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        long x$39 = this.append$default$6();
        AppendOrigin x$40 = AppendOrigin.CLIENT;
        this.append(x$33, x$34, bumpedEpoch, 0, 0L, x$39, true, x$40);
        Assertions.assertEquals((short)bumpedEpoch, (short)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        Assertions.assertThrows(InvalidTxnStateException.class, () -> {
            ProducerStateManager x$9 = this.stateManager();
            long x$10 = this.producerId();
            long x$15 = this.append$default$6();
            AppendOrigin x$16 = AppendOrigin.CLIENT;
            this.append(x$9, x$10, epoch, 1, 1L, x$15, false, x$16);
        });
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().list().length, (String)"Directory doesn't contain a single file as expected");
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())))), (String)"Snapshot file is empty");
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Optional loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)OptionalLong.of(0L), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        long x$23 = this.append$default$6();
        AppendOrigin x$24 = AppendOrigin.CLIENT;
        this.append(recoveredMapping, x$18, epoch, 2, 2L, x$23, true, x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, x$10, epoch, 1, 1L, x$15, true, x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Optional loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$7 = 0;
        this.appendEndTxnMarker(x$1, x$2, epoch, ControlRecordType.ABORT, 0L, x$7, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Optional lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertTrue((boolean)lastEntry.isPresent());
        Assertions.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, 0, 0L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, 0, this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, false, AppendOrigin.CLIENT);
        Assertions.assertEquals((int)1, (int)recoveredMapping.activeProducers().size());
        Assertions.assertEquals((int)2, (int)((ProducerStateEntry)recoveredMapping.activeProducers().values().iterator().next()).lastSeq());
        Assertions.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assertions.assertFalse((boolean)recoveredMapping.activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        boolean x$8 = false;
        this.append(recoveredMapping, x$2, epoch, sequence, 2L, 70001L, x$8, AppendOrigin.REPLICATION);
        Assertions.assertTrue((boolean)recoveredMapping.activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)recoveredMapping.activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertEquals((short)epoch, (short)producerStateEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        int outOfOrderSequence = 3;
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            boolean x$8 = false;
            this.append(x$1, x$2, epoch, outOfOrderSequence, 1L, 1L, x$8, AppendOrigin.CLIENT);
        });
        Assertions.assertTrue((boolean)this.stateManager().activeProducers().containsKey(BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)this.stateManager().activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertNotNull((Object)producerStateEntry);
        Assertions.assertEquals((long)0L, (long)producerStateEntry.lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        boolean x$16 = false;
        this.append(x$9, x$10, epoch, outOfOrderSequence, 1L, 1L, x$16, AppendOrigin.REPLICATION);
        ProducerStateEntry producerStateEntryForReplication = (ProducerStateEntry)this.stateManager().activeProducers().get(BoxesRunTime.boxToLong((long)this.producerId()));
        Assertions.assertNotNull((Object)producerStateEntryForReplication);
        Assertions.assertEquals((int)outOfOrderSequence, (int)producerStateEntryForReplication.lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncateFullyAndStartAt(0L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testReloadSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Object[] pathAndDataList = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> new Tuple2((Object)file.toPath(), (Object)Files.readAllBytes(file.toPath())), ClassTag$.MODULE$.apply(Tuple2.class));
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5})), this.currentSnapshotOffsets());
        this.stateManager().truncateAndReload(3L, 5L, this.time().milliseconds());
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})), this.currentSnapshotOffsets());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(pathAndDataList), (Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Path path = (Path)x0$1._1();
                byte[] data = (byte[])x0$1._2();
                return Files.write(path, data, new OpenOption[0]);
            }
            throw new MatchError(null);
        });
        this.stateManager().truncateFullyAndReloadSnapshots();
        Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, 0, this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        Optional entry1 = this.stateManager().lastEntry(pid1);
        Assertions.assertTrue((boolean)entry1.isPresent());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry1.get()).lastSeq());
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Optional entry2 = this.stateManager().lastEntry(pid2);
        Assertions.assertTrue((boolean)entry2.isPresent());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry2.get()).lastSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), false, AppendOrigin.CLIENT);
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)(sequence + 1), (int)((ProducerStateEntry)this.stateManager().activeProducers().values().iterator().next()).lastSeq());
        Assertions.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        long anotherPid = 2L;
        ProducerStateManager x$9 = this.stateManager();
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = AppendOrigin.CLIENT;
        this.append(x$9, anotherPid, epoch, sequence, 105L, x$15, true, x$16);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)OptionalLong.of(105L), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)99L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)105L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, 0, this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)105L)), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assertions.assertEquals(Optional.empty(), this.stateManager().firstUnstableOffset().map(x -> BoxesRunTime.boxToLong((long)x.messageOffset)));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.producerStateManagerConfig().producerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
        Assertions.assertEquals((Object)OptionalLong.of(99L), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isPresent());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        short epoch = (short)0;
        long x$2 = this.producerId();
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, -1, 99L, x$8, true, AppendOrigin.COORDINATOR);
        long x$10 = this.producerId();
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, -1, 100L, x$16, true, AppendOrigin.COORDINATOR);
    }

    @Test
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, epoch, sequence, 99L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Optional lastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), lastEntry.map(x -> BoxesRunTime.boxToInteger((int)x.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = AppendOrigin.CLIENT;
        this.append(x$1, x$2, producerEpoch, 0, 99L, x$7, true, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time()).truncateAndReload(0L, 2L, 70000L);
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)testLoadFromCorruptSnapshot_latestSnapshotOffset.getAsLong());
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertNotNull((Object)testLoadFromCorruptSnapshot_loadedProducerState);
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)Mockito.mock(RecordBatch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)batch.iterator()).thenReturn(Collections.emptyIterator());
        this.append(this.stateManager(), producerId, baseOffset, batch, AppendOrigin.CLIENT);
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    @Test
    public void testRemoveStraySnapshotsKeepCleanShutdownSnapshot() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)2L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots(Collections.singletonList(Predef$.MODULE$.long2Long(5L)));
        Assertions.assertEquals((Object)OptionalLong.of(42L), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)OptionalLong.of(5L), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{5L, 42L})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)this.logDir())).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.offset))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAllStraySnapshots() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)2L).toPath(), new FileAttribute[0]);
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)42L).toPath(), new FileAttribute[0]);
        this.stateManager().removeStraySnapshots(Collections.singletonList(Predef$.MODULE$.long2Long(42L)));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{42L})), (Object)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(ProducerStateManager.listSnapshotFiles((File)this.logDir())).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.offset))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletion() {
        Files.createFile(LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L).toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isPresent());
        Assertions.assertTrue((boolean)((Object)((SnapshotFile)manager.removeAndMarkSnapshotForDeletion(5L).get()).file().toPath()).toString().endsWith(".deleted"));
        Assertions.assertTrue((!manager.latestSnapshotOffset().isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletionAlreadyDeleted() {
        File file = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)5L);
        Files.createFile(file.toPath(), new FileAttribute[0]);
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isPresent());
        Files.delete(file.toPath());
        Assertions.assertTrue((!manager.removeAndMarkSnapshotForDeletion(5L).isPresent() ? 1 : 0) != 0);
        Assertions.assertTrue((!manager.latestSnapshotOffset().isPresent() ? 1 : 0) != 0);
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), false, AppendOrigin.CLIENT);
        this.stateManager().takeSnapshot();
        OptionalLong latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)OptionalLong.of(2L), (Object)latestSnapshotOffset);
        File snapshotToTruncate = LogFileUtils.producerSnapshotFile((File)this.logDir(), (long)latestSnapshotOffset.getAsLong());
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertNotNull((Object)loadedProducerState);
        Assertions.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Option<CompletedTxn> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, AppendOrigin.COORDINATOR);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        Option completedTxnOpt = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp)));
        mapping.update(producerAppendInfo);
        completedTxnOpt.foreach((Function1 & Serializable)x$1 -> {
            mapping.completeTxn(x$1);
            return BoxedUnit.UNIT;
        });
        mapping.updateMapEndOffset(offset + 1L);
        return completedTxnOpt;
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, long offset, RecordBatch batch, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.append(batch, Optional.empty());
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.CLIENT;
    }

    private Set<Object> currentSnapshotOffsets() {
        return Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)UnifiedLog$.MODULE$.offsetFromFile(file)), (ClassTag)ClassTag$.MODULE$.Long())).toSet();
    }

    private final Option appendEndTxn$1(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$1, short producerEpoch$2) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$1), producerEpoch$2, offset, this.time().milliseconds())));
    }

    private final void appendData$1(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$2, AtomicInteger seq$1) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$2, seq$1.get(), seq$1.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset), endOffset, true);
        seq$1.incrementAndGet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$3) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry.empty((long)producerId), AppendOrigin.CLIENT);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$3, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap(new byte[]{37}), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxTransactionTimeoutMs = 300000;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

