/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaState;
import kafka.server.TierStateMachine;
import kafka.server.Truncating$;
import kafka.utils.Implicits;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rua\u0001B\u00181\u0001UBQ\u0001\u0010\u0001\u0005\u0002uBQ\u0001\u0011\u0001\u0005\u0002\u0005CQA\u0015\u0001\u0005\nMCQ\u0001\u001a\u0001\u0005\u0002\u0005CQ!\u001b\u0001\u0005\u0002\u0005CQa\u001b\u0001\u0005\u0002\u0005CQ!\u001c\u0001\u0005\u0002\u0005CQa\u001c\u0001\u0005\u0002\u0005CQ!\u001d\u0001\u0005\u0002\u0005CQa\u001d\u0001\u0005\nQDqA \u0001\u0012\u0002\u0013%q\u0010C\u0004\u0002\u0016\u0001!I!a\u0006\t\u0013\u0005\r\u0003!%A\u0005\n\u0005\u0015\u0003bBA%\u0001\u0011%\u00111\n\u0004\u0007\u0003'\u0002A!!\u0016\t\u0015\u0005usB!A!\u0002\u0013\ty\u0006\u0003\u0004=\u001f\u0011\u0005\u00111\u000e\u0005\u0007\u0003gzA\u0011I!\t\r\u0005Ut\u0002\"\u0011B\u0011\u001d\t9h\u0004C!\u0003sBq!a\u001f\u0010\t\u0003\ni\bC\u0004\u0002&>!\t%a*\t\u000f\u0005uv\u0002\"\u0011\u0002@\"9\u0011QY\b\u0005B\u0005\u001d\u0007bBA\u007f\u001f\u0011\u0005\u0013q \u0005\n\u0005_y!\u0019!C!\u0005cA\u0001B!\u000f\u0010A\u0003%!1\u0007\u0005\b\u0005wyA\u0011\tB\u001f\r\u0019\u0011\u0019\u0005\u0001\u0003\u0003F!1A(\bC\u0001\u0005;BqA!\u0019\u001e\t\u0003\u0012\u0019\u0007C\u0004\u0003~u!\tEa \u0007\r\tE\u0005\u0001\u0002BJ\u0011)\ti&\tB\u0001B\u0003%\u0011q\f\u0005\u000b\u00057\u000b#\u0011!Q\u0001\n\tu\u0005B\u0003BRC\t\u0005\t\u0015!\u0003\u0003X!1A(\tC\u0001\u0005KCqAa,\"\t#\u0012\t\fC\u0004\u0003`\u0006\"\tF!9\t\u000f\t=\u0018\u0005\"\u0015\u0003r\"9!\u0011`\u0011\u0005R\tm\bbBB\u0001C\u0011E31\u0001\u0005\b\u0007\u000f\tC\u0011KB\u0005\u0011\u001d\u0019i!\tC)\u0007\u001fA\u0011b!\u0007\"\u0005\u0004%\tF!\r\t\u0011\rm\u0011\u0005)A\u0005\u0005g\u0011!$\u00112tiJ\f7\r\u001e$fi\u000eDWM]'b]\u0006<WM\u001d+fgRT!!\r\u001a\u0002\rM,'O^3s\u0015\u0005\u0019\u0014!B6bM.\f7\u0001A\n\u0003\u0001Y\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001?!\ty\u0004!D\u00011\u0003M\u0019G.Z1o\u001b\u0016$(/[2SK\u001eL7\u000f\u001e:z)\u0005\u0011\u0005CA\u001cD\u0013\t!\u0005H\u0001\u0003V]&$\bF\u0001\u0002G!\t9\u0005+D\u0001I\u0015\tI%*A\u0002ba&T!a\u0013'\u0002\u000f),\b/\u001b;fe*\u0011QJT\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u001f\u0006\u0019qN]4\n\u0005EC%A\u0003\"fM>\u0014X-R1dQ\u0006qq-\u001a;NKR\u0014\u0018n\u0019,bYV,GC\u0001+X!\t9T+\u0003\u0002Wq\t\u0019\u0011I\\=\t\u000ba\u001b\u0001\u0019A-\u0002\t9\fW.\u001a\t\u00035\u0006t!aW0\u0011\u0005qCT\"A/\u000b\u0005y#\u0014A\u0002\u001fs_>$h(\u0003\u0002aq\u00051\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u0001\u0007(A\ruKN$\u0018\t\u001a3B]\u0012\u0014V-\\8wKB\u000b'\u000f^5uS>t\u0007F\u0001\u0003g!\t9u-\u0003\u0002i\u0011\n!A+Z:u\u0003y!Xm\u001d;NKR\u0014\u0018n\u0019$bS2,G\rU1si&$\u0018n\u001c8D_VtG\u000f\u000b\u0002\u0006M\u0006IB/Z:u\t\u0016\fG\r\u00165sK\u0006$7i\\;oi6+GO]5dQ\t1a-A\fuKN$X*Y=cKV\u0003H-\u0019;f)>\u0004\u0018nY%eg\"\u0012qAZ\u0001\u0015i\u0016\u001cH/\u0012=qC:$G\u000b\u001b:fC\u0012\u0004vn\u001c7)\u0005!1\u0017\u0001\u0006;fgR\u001c\u0006N]5oWRC'/Z1e!>|G\u000e\u000b\u0002\nM\u0006!B/Z:u%\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$BAQ;{y\")aO\u0003a\u0001o\u0006\u00112-\u001e:sK:$h)\u001a;dQ\u0016\u00148+\u001b>f!\t9\u00040\u0003\u0002zq\t\u0019\u0011J\u001c;\t\u000bmT\u0001\u0019A<\u0002\u001d9,wOR3uG\",'oU5{K\"9QP\u0003I\u0001\u0002\u00049\u0018!\u00032s_.,'OT;n\u0003y!Xm\u001d;SKNL'0\u001a+ie\u0016\fG\rU8pY\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0002)\u001aq/a\u0001,\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u00049\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\tIAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!#\\1lKR{\u0007/[2QCJ$\u0018\u000e^5p]RA\u0011\u0011DA\u001c\u0003w\ty\u0004\u0005\u0004\u0002\u001c\u0005\u0005\u0012QE\u0007\u0003\u0003;Q1!a\b9\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\tiBA\u0002TKR\u0004B!a\n\u000245\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0004d_6lwN\u001c\u0006\u0004g\u0005=\"bAA\u0019\u001d\u00061\u0011\r]1dQ\u0016LA!!\u000e\u0002*\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BBA\u001d\u0019\u0001\u0007q/\u0001\u0005u_BL7MT;n\u0011\u0019\ti\u0004\u0004a\u0001o\u0006a\u0001/\u0019:uSRLwN\u001c(v[\"A\u0011\u0011\t\u0007\u0011\u0002\u0003\u0007\u0011,A\u0006u_BL7\r\u0015:fM&D\u0018\u0001H7bW\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000fR3!WA\u0002\u0003-9W\r\u001e\"s_.,'/\u00133\u0015\u000b]\fi%!\u0015\t\u000f\u0005=c\u00021\u0001\u0002&\u0005\u0011A\u000f\u001d\u0005\u0006{:\u0001\ra\u001e\u0002\u0013\u001b>\u001c7\u000eT3bI\u0016\u0014XI\u001c3Q_&tGo\u0005\u0003\u0010m\u0005]\u0003cA \u0002Z%\u0019\u00111\f\u0019\u0003\u001d1+\u0017\rZ3s\u000b:$\u0007k\\5oi\u0006a1o\\;sG\u0016\u0014%o\\6feB!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002fI\nqa\u00197vgR,'/\u0003\u0003\u0002j\u0005\r$A\u0004\"s_.,'/\u00128e!>Lg\u000e\u001e\u000b\u0005\u0003[\n\t\bE\u0002\u0002p=i\u0011\u0001\u0001\u0005\b\u0003;\n\u0002\u0019AA0\u00035Ig.\u001b;jCR,7\t\\8tK\u0006)1\r\\8tK\u0006q!M]8lKJ,e\u000e\u001a)pS:$HCAA0\u0003\u00151W\r^2i)\u0011\ty(!$\u0011\u0011\u0005m\u0011\u0011QA\u0013\u0003\u000bKA!a!\u0002\u001e\t\u0019Q*\u00199\u0011\t\u0005\u001d\u0015\u0011R\u0007\u0002\u001f%!\u00111RA-\u0005%1U\r^2i\t\u0006$\u0018\rC\u0004\u0002\u0010V\u0001\r!!%\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\u0005M\u0015q\u0014\b\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*!\u0011\u0011TA\u0015\u0003!\u0011X-];fgR\u001c\u0018\u0002BAO\u0003/\u000bABR3uG\"\u0014V-];fgRLA!!)\u0002$\n9!)^5mI\u0016\u0014(\u0002BAO\u0003/\u000b1CZ3uG\",\u0015M\u001d7jKN$xJ\u001a4tKR$b!!+\u00026\u0006e\u0006\u0003BAV\u0003ck!!!,\u000b\t\u0005-\u0012q\u0016\u0006\u0004c\u00055\u0012\u0002BAZ\u0003[\u0013ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000eC\u0004\u00028Z\u0001\r!!\n\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"1\u00111\u0018\fA\u0002]\f!cY;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQ\u0006\tb-\u001a;dQ2\u000bG/Z:u\u001f\u001a47/\u001a;\u0015\r\u0005%\u0016\u0011YAb\u0011\u001d\t9l\u0006a\u0001\u0003KAa!a/\u0018\u0001\u00049\u0018\u0001\u00064fi\u000eDW\t]8dQ\u0016sGm\u00144gg\u0016$8\u000f\u0006\u0003\u0002J\u0006E\b\u0003CA\u000e\u0003\u0003\u000b)#a3\u0011\t\u00055\u00171\u001e\b\u0005\u0003\u001f\f)O\u0004\u0003\u0002R\u0006\u0005h\u0002BAj\u0003?tA!!6\u0002^:!\u0011q[An\u001d\ra\u0016\u0011\\\u0005\u0002\u001f&\u0019\u0011\u0011\u0007(\n\u0007M\ny#\u0003\u0003\u0002,\u00055\u0012\u0002BAr\u0003S\tq!\\3tg\u0006<W-\u0003\u0003\u0002h\u0006%\u0018\u0001I(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3ta>t7/\u001a#bi\u0006TA!a9\u0002*%!\u0011Q^Ax\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRTA!a:\u0002j\"9\u00111\u001f\rA\u0002\u0005U\u0018A\u00039beRLG/[8ogBA\u00111DAA\u0003K\t9\u0010\u0005\u0003\u0002\b\u0006e\u0018\u0002BA~\u00033\u0012\u0011\"\u00129pG\"$\u0015\r^1\u0002\u0015\t,\u0018\u000e\u001c3GKR\u001c\u0007\u000e\u0006\u0003\u0003\u0002\t\r\u0002C\u0002B\u0002\u0005#\u00119B\u0004\u0003\u0003\u0006\t5a\u0002\u0002B\u0004\u0005\u0017q1\u0001\u0018B\u0005\u0013\u0005\u0019\u0014BA\u00193\u0013\r\u0011y\u0001M\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\u0011\u0011\u0019B!\u0006\u0003)I+7/\u001e7u/&$\b\u000eU1si&$\u0018n\u001c8t\u0015\r\u0011y\u0001\r\t\u0006o\te!QD\u0005\u0004\u00057A$AB(qi&|g\u000e\u0005\u0003\u0003\u0004\t}\u0011\u0002\u0002B\u0011\u0005+\u0011ABU3qY&\u001c\u0017MR3uG\"DqA!\n\u001a\u0001\u0004\u00119#\u0001\u0007qCJ$\u0018\u000e^5p]6\u000b\u0007\u000f\u0005\u0005\u0002\u001c\u0005\u0005\u0015Q\u0005B\u0015!\ry$1F\u0005\u0004\u0005[\u0001$a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0017\u0001H5t)J,hnY1uS>twJ\u001c$fi\u000eD7+\u001e9q_J$X\rZ\u000b\u0003\u0005g\u00012a\u000eB\u001b\u0013\r\u00119\u0004\u000f\u0002\b\u0005>|G.Z1o\u0003uI7\u000f\u0016:v]\u000e\fG/[8o\u001f:4U\r^2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013\u0001\u00074fi\u000eDW)\u0019:mS\u0016\u001cH\u000fT8dC2|eMZ:fiR1\u0011\u0011\u0016B \u0005\u0003Bq!a.\u001d\u0001\u0004\t)\u0003\u0003\u0004\u0002<r\u0001\ra\u001e\u0002\"\u001b>\u001c7NU3tSj,g)\u001a;dQ\u0016\u0014H+[3s'R\fG/Z'bG\"Lg.Z\n\u0006;\t\u001d#q\u000b\t\u0005\u0005\u0013\u0012\u0019&\u0004\u0002\u0003L)!!Q\nB(\u0003\u0011a\u0017M\\4\u000b\u0005\tE\u0013\u0001\u00026bm\u0006LAA!\u0016\u0003L\t1qJ\u00196fGR\u00042a\u0010B-\u0013\r\u0011Y\u0006\r\u0002\u0011)&,'o\u0015;bi\u0016l\u0015m\u00195j]\u0016$\"Aa\u0018\u0011\u0007\u0005=T$A\u0003ti\u0006\u0014H\u000f\u0006\u0005\u0003*\t\u0015$q\rB6\u0011\u001d\t9l\ba\u0001\u0003KAqA!\u001b \u0001\u0004\u0011I#A\tdkJ\u0014XM\u001c;GKR\u001c\u0007n\u0015;bi\u0016DqA!\u001c \u0001\u0004\u0011y'\u0001\ngKR\u001c\u0007\u000eU1si&$\u0018n\u001c8ECR\f\u0007\u0003\u0002B9\u0005orA!a4\u0003t%!!QOAu\u0003E1U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0005s\u0012YHA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0005k\nI/A\tnCf\u0014W-\u00113wC:\u001cWm\u0015;bi\u0016$bA!!\u0003\u000e\n=\u0005C\u0002BB\u0005\u0013\u0013I#\u0004\u0002\u0003\u0006*!!q\u0011B(\u0003\u0011)H/\u001b7\n\t\t-%Q\u0011\u0002\t\u001fB$\u0018n\u001c8bY\"9\u0011q\n\u0011A\u0002\u0005\u0015\u0002b\u0002B5A\u0001\u0007!\u0011\u0006\u0002\u0018)\u0016\u001cHOU3tSj,g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u001c2!\tBK!\ry$qS\u0005\u0004\u00053\u0003$!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u00042a\u0010BP\u0013\r\u0011\t\u000b\r\u0002\u0011\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\fQCZ3uG\"$\u0016.\u001a:Ti\u0006$X-T1dQ&tW\r\u0006\u0005\u0003(\n%&1\u0016BW!\r\ty'\t\u0005\b\u0003;*\u0003\u0019AA0\u0011\u001d\u0011Y*\na\u0001\u0005;CqAa)&\u0001\u0004\u00119&\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0005g\u0013IMa3\u0003VB)qG!\u0007\u00036B!!q\u0017Bc\u001b\t\u0011IL\u0003\u0003\u0003<\nu\u0016a\u00017pO*!!q\u0018Ba\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0003\u0003D\u00065\u0012aB:u_J\fw-Z\u0005\u0005\u0005\u000f\u0014ILA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0003o3\u0003\u0019AA\u0013\u0011\u001d\u0011iM\na\u0001\u0005\u001f\f1BZ3uG\"|eMZ:fiB\u0019qG!5\n\u0007\tM\u0007H\u0001\u0003M_:<\u0007b\u0002BlM\u0001\u0007!\u0011\\\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\tm'Q\\\u0007\u0002C%!\u00111\u0012BL\u0003!!(/\u001e8dCR,G#\u0002\"\u0003d\n\u0015\bbBA\\O\u0001\u0007\u0011Q\u0005\u0005\b\u0005O<\u0003\u0019\u0001Bu\u0003=!(/\u001e8dCRLwN\\*uCR,\u0007cA \u0003l&\u0019!Q\u001e\u0019\u0003+=3gm]3u)J,hnY1uS>t7\u000b^1uK\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0006\u0005\nM(Q\u001f\u0005\b\u0003oC\u0003\u0019AA\u0013\u0011\u001d\u00119\u0010\u000ba\u0001\u0005\u001f\faa\u001c4gg\u0016$\u0018a\u00037bi\u0016\u001cH/\u00129pG\"$BA!@\u0003\u0000B!qG!\u0007x\u0011\u001d\t9,\u000ba\u0001\u0003K\ta\u0002\\8h'R\f'\u000f^(gMN,G\u000f\u0006\u0003\u0003P\u000e\u0015\u0001bBA\\U\u0001\u0007\u0011QE\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u000b\u0005\u0005\u001f\u001cY\u0001C\u0004\u00028.\u0002\r!!\n\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0004\u0004\u0012\rM1Q\u0003\t\u0006o\te\u0011\u0011\u0016\u0005\b\u0003oc\u0003\u0019AA\u0013\u0011\u0019\u00199\u0002\fa\u0001o\u0006)Q\r]8dQ\u0006y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\u0002A%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G\r\t")
public class AbstractFetcherManagerTest {
    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAndRemovePartition() {
        void apply_lastFetchedEpoch;
        void apply_state;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        None$ none$ = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ apply_lag = None$.MODULE$;
        Object var9_10 = null;
        truncating$ = null;
        none$ = null;
        Mockito.when((Object)fetcher.fetchState(tp)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId, fetchOffset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})))).thenReturn(Map$.MODULE$.empty());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        ((Thread)Mockito.verify((Object)fetcher)).start();
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((int)1, (int)fetcherManager.deadThreadCount());
        ((Thread)Mockito.verify((Object)fetcher)).start();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertEquals((int)0, (int)fetcherManager.deadThreadCount());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeUpdateTopicIds() {
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_lastFetchedEpoch2;
        void apply_state2;
        void apply_lag;
        void apply_lastFetchedEpoch3;
        void apply_state3;
        void apply_lastFetchedEpoch4;
        void apply_state4;
        void apply_lag2;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$4;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$4;
            }
            {
                this.fetcher$4 = fetcher$4;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        TopicPartition unknownTp = new TopicPartition("topic2", 1);
        Some topicId1 = new Some((Object)Uuid.randomUuid());
        Some topicId2 = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState1 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        InitialFetchState initialFetchState2 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(1, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})));
        None$ none$ = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ none$2 = None$.MODULE$;
        None$ apply_topicId = None$.MODULE$;
        Object var16_15 = null;
        none$2 = null;
        truncating$ = null;
        none$ = null;
        None$ none$3 = None$.MODULE$;
        Truncating$ truncating$2 = Truncating$.MODULE$;
        None$ apply_lag3 = None$.MODULE$;
        Object var20_18 = null;
        truncating$2 = null;
        none$3 = null;
        Mockito.when((Object)fetcher.fetchState(tp1)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId, fetchOffset, (Option)apply_lag2, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state4, (Option)apply_lastFetchedEpoch4))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId1, fetchOffset, (Option)apply_lag3, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state3, (Option)apply_lastFetchedEpoch3)));
        None$ none$4 = None$.MODULE$;
        Truncating$ truncating$3 = Truncating$.MODULE$;
        None$ none$5 = None$.MODULE$;
        None$ apply_topicId2 = None$.MODULE$;
        Object var23_22 = null;
        none$5 = null;
        truncating$3 = null;
        none$4 = null;
        None$ none$6 = None$.MODULE$;
        Truncating$ truncating$4 = Truncating$.MODULE$;
        None$ apply_lag4 = None$.MODULE$;
        Object var27_25 = null;
        truncating$4 = null;
        none$6 = null;
        Mockito.when((Object)fetcher.fetchState(tp2)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId2, fetchOffset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state2, (Option)apply_lastFetchedEpoch2))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId2, fetchOffset, (Option)apply_lag4, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch)));
        Map topicIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)topicId2)}));
        Mockito.when((Object)fetcher.fetchState(unknownTp)).thenReturn((Object)None$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)None$.MODULE$);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)None$.MODULE$);
        Map partitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)initialFetchState2.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(partitionsToUpdate, (Function1)topicIds);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)topicId1);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)topicId2);
        Map invalidPartitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTp), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(invalidPartitionsToUpdate, (Function1)topicIds);
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownTp).isEmpty());
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownTp})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})), (Function1)topicIds);
    }

    @Test
    public void testExpandThreadPool() {
        this.testResizeThreadPool(10, 50, 6);
    }

    @Test
    public void testShrinkThreadPool() {
        this.testResizeThreadPool(50, 10, 6);
    }

    private void testResizeThreadPool(int currentFetcherSize, int newFetcherSize, int brokerNum) {
        Set<TopicPartition> fetchingTopicPartitions = this.makeTopicPartition(10, 100, "topic_");
        Set<TopicPartition> failedTopicPartitions = this.makeTopicPartition(2, 5, "topic_failed");
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, currentFetcherSize){
            private final /* synthetic */ AbstractFetcherManagerTest $outer;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.$outer.new TestResizeFetcherThread(sourceBroker, this.failedPartitions(), this.$outer.new MockResizeFetcherTierStateMachine());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("fetcher-manager", "fetcher-manager", currentFetcherSize$1);
            }
        };
        try {
            fetcherManager.addFetcherForPartitions((Map)((IterableOnceOps)fetchingTopicPartitions.map((Function1 & Serializable)tp -> {
                int brokerId = this.getBrokerId((TopicPartition)tp, brokerNum);
                BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, new StringBuilder(11).append("kafka-host-").append(brokerId).toString(), 9092);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new InitialFetchState((Option)None$.MODULE$, brokerEndPoint, 0, 0L));
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            ((IterableOnceOps)fetchingTopicPartitions.take(20)).foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$2$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            failedTopicPartitions.foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$3$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            fetcherManager.resizeThreadPool(newFetcherSize);
            scala.collection.mutable.Set ownedPartitions = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
            fetcherManager.fetcherThreadMap().foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((arg_0, arg_1) -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4$adapted(this, ownedPartitions, (AbstractFetcherManager)fetcherManager, brokerNum, arg_0, arg_1), arg_0, arg_1));
            Assertions.assertEquals(fetchingTopicPartitions, (Object)ownedPartitions);
            Assertions.assertEquals(failedTopicPartitions, (Object)fetcherManager.failedPartitions().partitions());
        }
        finally {
            fetcherManager.closeAllFetchers();
        }
    }

    private int testResizeThreadPool$default$3() {
        return 6;
    }

    private Set<TopicPartition> makeTopicPartition(int topicNum, int partitionNum, String topicPrefix) {
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), topicNum - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String topic = new StringBuilder(0).append(topicPrefix).append(i).toString();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), partitionNum - 1).foreach((Function1 & Serializable)j -> AbstractFetcherManagerTest.$anonfun$makeTopicPartition$2(res, topic, BoxesRunTime.unboxToInt((Object)j)));
        });
        return res.toSet();
    }

    private String makeTopicPartition$default$3() {
        return "topic_";
    }

    private int getBrokerId(TopicPartition tp, int brokerNum) {
        return Utils.abs((int)tp.hashCode()) % brokerNum;
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getName();
            return !(string != null ? !string.equals(name$1) : name$1 != null);
        }
        throw new MatchError(null);
    }

    private static final void verifyFetchState$1(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$5(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int fetcherId$1, int brokerNum$1, int brokerId$1, TopicPartition tp) {
        ownedPartitions$1.$plus$eq((Object)tp);
        Assertions.assertEquals((int)fetcherManager$1.getFetcherId(tp), (int)fetcherId$1);
        Assertions.assertEquals((int)$this.getBrokerId(tp, brokerNum$1), (int)brokerId$1);
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$4(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        int fetcherId = brokerIdAndFetcherId.fetcherId();
        int brokerId = brokerIdAndFetcherId.brokerId();
        fetcherThread.partitions().foreach((Function1 & Serializable)tp -> {
            AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$5($this, ownedPartitions$1, fetcherManager$1, fetcherId, brokerNum$1, brokerId, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$makeTopicPartition$2(scala.collection.mutable.Set res$1, String topic$1, int j) {
        return (scala.collection.mutable.Set)res$1.$plus$eq((Object)new TopicPartition(topic$1, j));
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$2$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$3$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$4$adapted(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4($this, ownedPartitions$1, fetcherManager$1, brokerNum$1, brokerIdAndFetcherId, fetcherThread);
        return BoxedUnit.UNIT;
    }

    private class MockLeaderEndPoint
    implements LeaderEndPoint {
        private final BrokerEndPoint sourceBroker;
        private final boolean isTruncationOnFetchSupported;
        public final /* synthetic */ AbstractFetcherManagerTest $outer;

        public void initiateClose() {
        }

        public void close() {
        }

        public BrokerEndPoint brokerEndPoint() {
            return this.sourceBroker;
        }

        public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
            return (Map)Map$.MODULE$.empty();
        }

        public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
            return (Map)Map$.MODULE$.empty();
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            return new AbstractFetcherThread.ResultWithPartitions((Object)None$.MODULE$, (Set)Set$.MODULE$.empty());
        }

        public boolean isTruncationOnFetchSupported() {
            return this.isTruncationOnFetchSupported;
        }

        public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockLeaderEndPoint$$$outer() {
            return this.$outer;
        }

        public MockLeaderEndPoint(AbstractFetcherManagerTest $outer, BrokerEndPoint sourceBroker) {
            this.sourceBroker = sourceBroker;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.isTruncationOnFetchSupported = false;
        }
    }

    private class MockResizeFetcherTierStateMachine
    implements TierStateMachine {
        public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
            throw new UnsupportedOperationException("Materializing tier state is not supported in this test.");
        }

        public Optional<PartitionFetchState> maybeAdvanceState(TopicPartition tp, PartitionFetchState currentFetchState) {
            return Optional.empty();
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockResizeFetcherTierStateMachine$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public MockResizeFetcherTierStateMachine() {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
        }
    }

    private class TestResizeFetcherThread
    extends AbstractFetcherThread {
        private final boolean isOffsetForLeaderEpochSupported;

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
            return None$.MODULE$;
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            return new Some((Object)new OffsetAndEpoch(1L, 0));
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return this.isOffsetForLeaderEpochSupported;
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$TestResizeFetcherThread$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public TestResizeFetcherThread(BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, TierStateMachine fetchTierStateMachine) {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            MockLeaderEndPoint x$3 = new MockLeaderEndPoint(AbstractFetcherManagerTest.this, sourceBroker);
            BrokerTopicStats x$7 = new BrokerTopicStats();
            boolean x$8 = true;
            super("test-resize-fetcher", "mock-fetcher", (LeaderEndPoint)x$3, failedPartitions, fetchTierStateMachine, 0, x$8, x$7);
            this.isOffsetForLeaderEpochSupported = false;
        }
    }
}

