/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.LogTestUtils$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.log.remote.RemoteLogManager;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.KafkaRaftServer$;
import kafka.server.RequestLocal;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg\u0001B\u0015+\u0001=BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004E\u0001\u0001\u0006I\u0001\u0010\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001<\u0011\u00191\u0005\u0001)A\u0005y!9q\t\u0001b\u0001\n\u0003A\u0005BB(\u0001A\u0003%\u0011\nC\u0004Q\u0001\t\u0007I\u0011\u0001%\t\rE\u0003\u0001\u0015!\u0003J\u0011\u001d\u0011\u0006A1A\u0005\u0002!Caa\u0015\u0001!\u0002\u0013I\u0005b\u0002+\u0001\u0005\u0004%\t\u0001\u0013\u0005\u0007+\u0002\u0001\u000b\u0011B%\t\u000fY\u0003!\u0019!C\u0001\u0011\"1q\u000b\u0001Q\u0001\n%Cq\u0001\u0017\u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004a\u0001\u0001\u0006IA\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0011\u0019q\u0007\u0001)A\u0005G\"Iq\u000e\u0001a\u0001\u0002\u0004%\t\u0001\u001d\u0005\nm\u0002\u0001\r\u00111A\u0005\u0002]D\u0011\" \u0001A\u0002\u0003\u0005\u000b\u0015B9\t\u000by\u0004A\u0011A@\t\r\u0005m\u0001\u0001\"\u0001\u0000\u0011\u0019\ti\u0002\u0001C\u0001\u007f\"1\u0011q\u0005\u0001\u0005\u0002}Da!!\r\u0001\t\u0003y\bBBA\u001b\u0001\u0011\u0005q\u0010\u0003\u0004\u0002:\u0001!\ta \u0005\u0007\u0003{\u0001A\u0011A@\t\r\u0005\u0005\u0003\u0001\"\u0001\u0000\u0011\u0019\t)\u0005\u0001C\u0001\u007f\"9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003BBA6\u0001\u0011\u0005q\u0010C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\"9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005bBAP\u0001\u0011%\u0011\u0011\u0015\u0005\b\u0003o\u0003A\u0011BA]\u0011\u0019\t)\r\u0001C\u0005\u007f\n\u0019B)^7q\u0019><7+Z4nK:$8\u000fV3ti*\u00111\u0006L\u0001\u0006i>|Gn\u001d\u0006\u0002[\u0005)1.\u00194lC\u000e\u00011C\u0001\u00011!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u000f\t\u0003s\u0001i\u0011AK\u0001\u0007i6\u0004H)\u001b:\u0016\u0003q\u0002\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u0005%|'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012AAR5mK\u00069A/\u001c9ESJ\u0004\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u0017M,w-\\3oi:\u000bW.Z\u000b\u0002\u0013B\u0011!*T\u0007\u0002\u0017*\u0011A\nQ\u0001\u0005Y\u0006tw-\u0003\u0002O\u0017\n11\u000b\u001e:j]\u001e\fAb]3h[\u0016tGOT1nK\u0002\n1\u0002\\8h\r&dW\rU1uQ\u0006aAn\\4GS2,\u0007+\u0019;iA\u0005a1O\\1qg\"|G\u000fU1uQ\u0006i1O\\1qg\"|G\u000fU1uQ\u0002\nQ\"\u001b8eKb4\u0015\u000e\\3QCRD\u0017AD5oI\u0016Dh)\u001b7f!\u0006$\b\u000eI\u0001\u0012i&lW-\u00138eKb4\u0015\u000e\\3QCRD\u0017A\u0005;j[\u0016Le\u000eZ3y\r&dW\rU1uQ\u0002\nA\u0001^5nKV\t!\f\u0005\u0002\\=6\tAL\u0003\u0002^Y\u0005)Q\u000f^5mg&\u0011q\f\u0018\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059!-\u0019;dQ\u0016\u001cX#A2\u0011\u0007\u0011L7.D\u0001f\u0015\t1w-A\u0004nkR\f'\r\\3\u000b\u0005!\u0014\u0014AC2pY2,7\r^5p]&\u0011!.\u001a\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0002:Y&\u0011QN\u000b\u0002\n\u0005\u0006$8\r[%oM>\f\u0001BY1uG\",7\u000fI\u0001\u0004Y><W#A9\u0011\u0005I$X\"A:\u000b\u0005=d\u0013BA;t\u0005))f.\u001b4jK\u0012dunZ\u0001\bY><w\fJ3r)\tA8\u0010\u0005\u00022s&\u0011!P\r\u0002\u0005+:LG\u000fC\u0004}+\u0005\u0005\t\u0019A9\u0002\u0007a$\u0013'\u0001\u0003m_\u001e\u0004\u0013!B:fiV\u0003H#\u0001=)\u0007]\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005]QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u000e\u0005=\u0011a\u00026va&$XM\u001d\u0006\u0005\u0003#\t\u0019\"A\u0003kk:LGO\u0003\u0002\u0002\u0016\u0005\u0019qN]4\n\t\u0005e\u0011q\u0001\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001E1eINKW\u000e\u001d7f%\u0016\u001cwN\u001d3t\u0003!!X-\u0019:E_^t\u0007fA\r\u0002\"A!\u0011QAA\u0012\u0013\u0011\t)#a\u0002\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\t;fgR\u0014\u0015\r^2i\u0003:$'+Z2pe\u0012lU\r^1eCR\fw*\u001e;qkRD3AGA\u0016!\u0011\t)!!\f\n\t\u0005=\u0012q\u0001\u0002\u0005)\u0016\u001cH/\u0001\tuKN$\bK]5oi\u0012\u000bG/\u0019'pO\"\u001a1$a\u000b\u0002/Q,7\u000f\u001e#v[BLe\u000eZ3y\u001b&\u001cX.\u0019;dQ\u0016\u001c\bf\u0001\u000f\u0002,\u00059B/Z:u\tVl\u0007\u000fV5nK&sG-\u001a=FeJ|'o\u001d\u0015\u0004;\u0005-\u0012a\u0006;fgR$U/\u001c9NKR\fG-\u0019;b%\u0016\u001cwN\u001d3tQ\rq\u00121F\u0001\u0019i\u0016\u001cH\u000fR;na6+G/\u00193bi\u0006\u001cf.\u00199tQ>$\bfA\u0010\u0002,\u0005\u0011B/Z:u\tVl\u0007/R7qifLe\u000eZ3yQ\r\u0001\u00131F\u0001\u0013eVtG)^7q\u0019><7+Z4nK:$8\u000f\u0006\u0003\u0002N\u0005\u0005\u0004\u0003BA(\u0003;rA!!\u0015\u0002ZA\u0019\u00111\u000b\u001a\u000e\u0005\u0005U#bAA,]\u00051AH]8pizJ1!a\u00173\u0003\u0019\u0001&/\u001a3fM&\u0019a*a\u0018\u000b\u0007\u0005m#\u0007C\u0004\u0002d\u0005\u0002\r!!\u001a\u0002\t\u0005\u0014xm\u001d\t\u0006c\u0005\u001d\u0014QJ\u0005\u0004\u0003S\u0012$!B!se\u0006L\u0018A\b;fgR\u0004&/\u001b8u\t\u0006$\u0018\rT8h!\u0006\u0014H/[1m\u0005\u0006$8\r[3tQ\r\u0011\u00131F\u0001\u0012e\u0016\fGMQ1uG\"lU\r^1eCR\fG\u0003BA:\u0003s\u0002R!MA;\u0003\u001bJ1!a\u001e3\u0005\u0019y\u0005\u000f^5p]\"9\u00111P\u0012A\u0002\u0005u\u0014!\u00027j]\u0016\u001c\bCBA@\u0003\u000b\u000bi%\u0004\u0002\u0002\u0002*\u0019\u00111\u0011!\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000f\u000b\tI\u0001\u0007MSN$\u0018\n^3sCR|'/A\fsK\u0006$\u0007+\u0019:uS\u0006d')\u0019;dQ\u0016\u001c()\u001f;fgR1\u0011QRAJ\u0003+\u00032!MAH\u0013\r\t\tJ\r\u0002\u0004\u0013:$\bbBA>I\u0001\u0007\u0011Q\u0010\u0005\b\u0003/#\u0003\u0019AAG\u0003\u0015a\u0017.\\5u\u00031\u0019w.\u001e8u\u0005\u0006$8\r[3t)\u0011\ti)!(\t\u000f\u0005mT\u00051\u0001\u0002~\u0005\u0001\"/Z1e\u0005\u0006$8\r\u001b*fG>\u0014Hm\u001d\u000b\u0005\u0003G\u000b)\f\u0005\u0004\u0002&\u0006=\u0016Q\n\b\u0005\u0003O\u000bYK\u0004\u0003\u0002T\u0005%\u0016\"A\u001a\n\u0007\u00055&'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00161\u0017\u0002\u0004'\u0016\f(bAAWe!9\u00111\u0010\u0014A\u0002\u0005u\u0014a\u00059beN,W*\u001a;bI\u0006$\u0018MR5fY\u0012\u001cH\u0003BA^\u0003\u0003\u0004\u0002\"a\u0014\u0002>\u00065\u0013QJ\u0005\u0005\u0003\u007f\u000byFA\u0002NCBDq!a1(\u0001\u0004\ti%\u0001\u0003mS:,\u0017aG1tg\u0016\u0014H\u000fR;na2{wMU3d_J$W*\u001a;bI\u0006$\u0018\r")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String snapshotPath = new StringBuilder(43).append(this.logDir()).append("/00000000000000000000-0000000000.checkpoint").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private UnifiedLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String snapshotPath() {
        return this.snapshotPath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public void log_$eq(UnifiedLog x$1) {
        this.log = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty("index.interval.bytes", "128");
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props);
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        boolean x$16 = false;
        None$ x$17 = None$.MODULE$;
        LogOffsetsListener x$18 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        this.log_$eq(UnifiedLog$.MODULE$.apply(x$1, x$2, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, x$10, x$11, x$14, (Option)x$12, true, x$15, x$16, (Option)x$17, x$18));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((scala.collection.immutable.Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable)batchInfo -> {
            void withRecords_records;
            void withRecords_partitionLeaderEpoch;
            UnifiedLog qual$1 = this.log();
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            boolean bl = false;
            CompressionType withRecords_compressionType = CompressionType.NONE;
            Object var7_5 = null;
            simpleRecordArray = null;
            MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
            RequestLocal x$5 = qual$1.appendAsLeader$default$5();
            return qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5);
        });
        this.log().flush(false);
    }

    @AfterEach
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBatchAndRecordMetadataOutput() {
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_producerEpoch;
        void withTransactionalRecords_producerId;
        void withIdempotentRecords_records;
        void withIdempotentRecords_baseSequence;
        void withIdempotentRecords_producerEpoch;
        void withIdempotentRecords_producerId;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        UnifiedLog qual$1 = this.log();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        boolean bl = false;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var30_4 = null;
        simpleRecordArray = null;
        MemoryRecords x$1 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3);
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5);
        UnifiedLog qual$2 = this.log();
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())};
        boolean bl2 = false;
        CompressionType withRecords_compressionType2 = CompressionType.GZIP;
        Object var33_12 = null;
        simpleRecordArray2 = null;
        MemoryRecords x$6 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2);
        AppendOrigin x$8 = qual$2.appendAsLeader$default$3();
        MetadataVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, 3, x$8, x$9, x$10);
        UnifiedLog qual$3 = this.log();
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())};
        boolean bl3 = false;
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        Object var36_20 = null;
        simpleRecordArray3 = null;
        MemoryRecords x$11 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        AppendOrigin x$13 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, 3, x$13, x$14, x$15);
        UnifiedLog qual$4 = this.log();
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("h".getBytes())};
        int n = 234123;
        short s = (short)15;
        long l = 29342342L;
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var39_30 = null;
        simpleRecordArray4 = null;
        MemoryRecords x$16 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withIdempotentRecords_producerId, (short)withIdempotentRecords_producerEpoch, (int)withIdempotentRecords_baseSequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        AppendOrigin x$18 = qual$4.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$4.appendAsLeader$default$4();
        RequestLocal x$20 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$16, 3, x$18, x$19, x$20);
        UnifiedLog qual$5 = this.log();
        SimpleRecord[] simpleRecordArray5 = new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())};
        int n2 = 266;
        short s2 = (short)99;
        long l2 = 98323L;
        CompressionType withTransactionalRecords_compressionType = CompressionType.GZIP;
        Object var45_40 = null;
        simpleRecordArray5 = null;
        MemoryRecords x$21 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)withTransactionalRecords_producerId, (short)withTransactionalRecords_producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        AppendOrigin x$23 = qual$5.appendAsLeader$default$3();
        MetadataVersion x$24 = qual$5.appendAsLeader$default$4();
        RequestLocal x$25 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$21, 5, x$23, x$24, x$25);
        UnifiedLog qual$6 = this.log();
        MemoryRecords x$26 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        MetadataVersion x$29 = qual$6.appendAsLeader$default$4();
        RequestLocal x$30 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$26, 7, AppendOrigin.COORDINATOR, x$29, x$30);
        this.assertDumpLogRecordMetadata();
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(false, new String[]{"--deep-iteration", "--files", this.logFilePath()});
        this.verifyNoRecordsInOutput$1(new String[]{"--files", this.logFilePath()});
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpMetadataRecords() {
        void withRecords_timestampType;
        void withRecords_records;
        void withRecords_timestampType2;
        void withRecords_timestampType3;
        MockTime mockTime = new MockTime();
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -1L;
        long x$5 = 0L;
        String x$6 = "delete";
        int x$7 = 0x10000C;
        int x$8 = 4096;
        int x$9 = 0xA00000;
        long x$10 = 60000L;
        boolean x$11 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, 0x100000, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        UnifiedLog log = LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), (Scheduler)mockTime.scheduler(), (Time)mockTime, 0L, 0L, 300000, LogTestUtils$.MODULE$.createLog$default$9(), Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>(), false, (Option<RemoteLogManager>)None$.MODULE$, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable)message -> {
            MetadataRecordSerde serde = MetadataRecordSerde.INSTANCE;
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        })).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var23_15 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType3, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.flush(false);
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("Log starting offset: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(null, buf.array())};
        CompressionType withRecords_compressionType2 = CompressionType.NONE;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var24_23 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType2, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        byte withRecords_magic3 = 2;
        TimestampType timestampType3 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset3 = 0L;
        timestampType3 = null;
        Object var26_27 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic3, (long)withRecords_initialOffset3, (CompressionType)withRecords_compressionType3, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.logFilePath()});
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("skipping"));
    }

    @Test
    public void testDumpMetadataSnapshot() {
        .colon.colon metadataRecords = new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0), (List)Nil$.MODULE$))));
        KafkaMetadataLog metadataLog = KafkaMetadataLog$.MODULE$.apply(KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.logDir(), (RecordSerde)MetadataRecordSerde.INSTANCE, (Time)this.time(), (Scheduler)this.time().scheduler(), new MetadataLogConfig(102400, 102400, 10000L, 102400L, 60000L, 0x800000, 0x800000, 60000L, 1));
        int lastContainedLogTimestamp = 10000;
        try (AutoCloseable resource_resource = (AutoCloseable)RecordsSnapshotWriter.createWithHeader(() -> metadataLog.createNewSnapshot(new OffsetAndEpoch(0L, 0)), (int)1024, (MemoryPool)MemoryPool.NONE, (Time)new MockTime(), (long)lastContainedLogTimestamp, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE).get();){
            SnapshotWriter snapshotWriter = (SnapshotWriter)resource_resource;
            DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2((scala.collection.immutable.Seq)metadataRecords, snapshotWriter);
        }
        Object var5_4 = null;
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertTrue((boolean)output.contains("SnapshotHeader"));
        Assertions.assertTrue((boolean)output.contains("SnapshotFooter"));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("\"lastContainedLogTimestamp\":").append(lastContainedLogTimestamp).toString()));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "--files", this.snapshotPath()});
        Assertions.assertTrue((boolean)output.contains("Snapshot end offset: 0, epoch: 0"));
        Assertions.assertTrue((boolean)output.contains("TOPIC_RECORD"));
        Assertions.assertTrue((boolean)output.contains("BROKER_RECORD"));
        Assertions.assertFalse((boolean)output.contains("SnapshotHeader"));
        Assertions.assertFalse((boolean)output.contains("SnapshotFooter"));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(29).append("\"lastContainedLogTimestamp\": ").append(lastContainedLogTimestamp).toString()));
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    @Test
    public void testPrintDataLogPartialBatches() {
        this.addSimpleRecords();
        int partialBatches = this.batches().size() / 2;
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesBytes = this.readPartialBatchesBytes(lines, partialBatches);
        ListIterator<String> partialLines = Arrays.asList(this.runDumpLogSegments(new String[]{"--max-bytes", Integer.toString(partialBatchesBytes), "--files", this.logFilePath()}).split("\n")).listIterator();
        int partialBatchesCount = this.countBatches(partialLines);
        Assertions.assertEquals((int)partialBatches, (int)partialBatchesCount);
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private int readPartialBatchesBytes(ListIterator<String> lines, int limit) {
        Regex sizePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".+?size:\\s(\\d+).+"));
        int batchesBytes = 0;
        int batchesCounter = 0;
        while (lines.hasNext()) {
            if (batchesCounter >= limit) {
                return batchesBytes;
            }
            String line = lines.next();
            if (!line.startsWith("baseOffset")) continue;
            Option option = sizePattern.unapplySeq((CharSequence)line);
            if (!option.isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String size = (String)((LinearSeqOps)option.get()).apply(0);
                batchesBytes += StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(size));
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Failed to parse and find size value for batch line: ").append(line).toString());
            }
            ++batchesCounter;
        }
        return batchesBytes;
    }

    private int countBatches(ListIterator<String> lines) {
        int countBatches = 0;
        while (lines.hasNext()) {
            if (!lines.next().startsWith("baseOffset")) continue;
            ++countBatches;
        }
        return countBatches;
    }

    private scala.collection.immutable.Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Iterator tokens = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+")), (Function1 & Serializable)x$4 -> x$4.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5))))));
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void assertDumpLogRecordMetadata() {
        FetchDataInfo logReadInfo = this.log().read(0L, Integer.MAX_VALUE, FetchIsolation.LOG_END, true);
        ListIterator<String> lines = Arrays.asList(this.runDumpLogSegments(new String[]{"--deep-iteration", "--files", this.logFilePath()}).split("\n")).listIterator();
        CollectionConverters$.MODULE$.IterableHasAsScala(logReadInfo.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((IterableOnceOps)this.batches().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$3) {
        return x$3.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.batches().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    public static final /* synthetic */ void $anonfun$testDumpMetadataSnapshot$2(scala.collection.immutable.Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        snapshotWriter.append(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)metadataRecords$1).asJava());
        snapshotWriter.freeze();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$15)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$16)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$17)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$18)))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$19)))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$6)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$7)))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$8)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$9)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$10)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$11)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$12)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$13)))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$14)))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }

    public static final /* synthetic */ Object $anonfun$testDumpMetadataSnapshot$2$adapted(scala.collection.immutable.Seq metadataRecords$1, SnapshotWriter snapshotWriter) {
        DumpLogSegmentsTest.$anonfun$testDumpMetadataSnapshot$2(metadataRecords$1, snapshotWriter);
        return BoxedUnit.UNIT;
    }
}

