/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.utils.timer.SystemTimer;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005q4A\u0001E\t\u00011!)q\u0004\u0001C\u0001A\u0019!1\u0005\u0001\u0003%\u0011!\u0001$A!b\u0001\n\u0003\n\u0004\u0002C\u001b\u0003\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011Y\u0012!\u0011!Q\u0001\n]B\u0001B\u000f\u0002\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0007\n\u0011\t\u0011)A\u0005\t\")qD\u0001C\u0001\u0019\"11K\u0001Q\u0001\nQCQA\u0017\u0002\u0005\u0002mC\u0011B\u0005\u0001A\u0002\u0003\u0005\u000b\u0015B0\t\u000b\t\u0004A\u0011A.\t\u000bA\u0004A\u0011A.\t\u000bU\u0004A\u0011A.\t\u000bi\u0004A\u0011A.\u0003\u0013QKW.\u001a:UKN$(B\u0001\n\u0014\u0003\u0015!\u0018.\\3s\u0015\t!R#A\u0003vi&d7OC\u0001\u0017\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\t\u0011C\u0001\u0005UKN$H+Y:l'\r\u0011Q%\f\t\u0003M-j\u0011a\n\u0006\u0003Q%\nA\u0001\\1oO*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u0005\u0019y%M[3diB\u0011!EL\u0005\u0003_E\u0011\u0011\u0002V5nKJ$\u0016m]6\u0002\u000f\u0011,G.Y=NgV\t!\u0007\u0005\u0002\u001bg%\u0011Ag\u0007\u0002\u0005\u0019>tw-\u0001\u0005eK2\f\u00170T:!\u0003\tIG\r\u0005\u0002\u001bq%\u0011\u0011h\u0007\u0002\u0004\u0013:$\u0018!\u00027bi\u000eD\u0007C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0001&\nA!\u001e;jY&\u0011!)\u0010\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0003\u0019yW\u000f\u001e9viB\u0019QIS\u001c\u000e\u0003\u0019S!a\u0012%\u0002\u000f5,H/\u00192mK*\u0011\u0011jG\u0001\u000bG>dG.Z2uS>t\u0017BA&G\u0005-\t%O]1z\u0005V4g-\u001a:\u0015\u000b5{\u0005+\u0015*\u0011\u00059\u0013Q\"\u0001\u0001\t\u000bAB\u0001\u0019\u0001\u001a\t\u000bYB\u0001\u0019A\u001c\t\u000biB\u0001\u0019A\u001e\t\u000b\rC\u0001\u0019\u0001#\u0002\u0013\r|W\u000e\u001d7fi\u0016$\u0007CA+Y\u001b\u00051&BA,>\u0003\u0019\tGo\\7jG&\u0011\u0011L\u0016\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0007I,h\u000eF\u0001]!\tQR,\u0003\u0002_7\t!QK\\5u!\t\u0011\u0003-\u0003\u0002b#\t)A+[7fe\u0006)1/\u001a;va\"\u0012A\u0002\u001a\t\u0003K:l\u0011A\u001a\u0006\u0003O\"\f1!\u00199j\u0015\tI'.A\u0004kkBLG/\u001a:\u000b\u0005-d\u0017!\u00026v]&$(\"A7\u0002\u0007=\u0014x-\u0003\u0002pM\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d3po:D#!\u0004:\u0011\u0005\u0015\u001c\u0018B\u0001;g\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\fuKN$\u0018\t\u001c:fC\u0012LX\t\u001f9je\u0016$G+Y:lQ\tqq\u000f\u0005\u0002fq&\u0011\u0011P\u001a\u0002\u0005)\u0016\u001cH/\u0001\nuKN$H+Y:l\u000bb\u0004\u0018N]1uS>t\u0007FA\bx\u0001")
public class TimerTest {
    private Timer timer;

    @BeforeEach
    public void setup() {
        this.timer = new SystemTimer("test", 1L, 3, Time.SYSTEM.hiResClockMs());
    }

    @AfterEach
    public void teardown() {
        this.timer.shutdown();
    }

    @Test
    public void testAlreadyExpiredTask() {
        ArrayBuffer output = new ArrayBuffer();
        IndexedSeq latches = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(-5), 0).map((Function1 & Serializable)i -> TimerTest.$anonfun$testAlreadyExpiredTask$1(this, output, BoxesRunTime.unboxToInt((Object)i)));
        this.timer.advanceClock(0L);
        ((IterableOnceOps)latches.take(5)).foreach((Function1 & Serializable)latch -> {
            TimerTest.$anonfun$testAlreadyExpiredTask$2(latch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-5, -4, -3, -2, -1})), (Object)output.toSet(), (String)"output of already expired tasks");
    }

    @Test
    public void testTaskExpiration() {
        ArrayBuffer output = new ArrayBuffer();
        ArrayBuffer tasks = new ArrayBuffer();
        ArrayBuffer ids = new ArrayBuffer();
        IndexedSeq latches = (IndexedSeq)((IterableOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> TimerTest.$anonfun$testTaskExpiration$1(this, tasks, output, ids, BoxesRunTime.unboxToInt((Object)i))).$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 100).map((Function1 & Serializable)i -> TimerTest.$anonfun$testTaskExpiration$2(this, tasks, output, ids, BoxesRunTime.unboxToInt((Object)i))))).$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(100), 500).map((Function1 & Serializable)i -> TimerTest.$anonfun$testTaskExpiration$3(this, tasks, output, ids, BoxesRunTime.unboxToInt((Object)i))));
        tasks.foreach((Function1 & Serializable)task -> {
            this.timer.add((TimerTask)task);
            return BoxedUnit.UNIT;
        });
        while (this.timer.advanceClock(2000L)) {
        }
        latches.foreach((Function1 & Serializable)latch -> {
            latch.await();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)ids.sorted((Ordering)Ordering.Int$.MODULE$), (Object)output.toSeq(), (String)"output should match");
    }

    public static final /* synthetic */ CountDownLatch $anonfun$testAlreadyExpiredTask$1(TimerTest $this, ArrayBuffer output$1, int i) {
        CountDownLatch latch = new CountDownLatch(1);
        $this.timer.add((TimerTask)new TestTask($this, i, i, latch, (ArrayBuffer<Object>)output$1));
        return latch;
    }

    public static final /* synthetic */ void $anonfun$testAlreadyExpiredTask$2(CountDownLatch latch) {
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)latch.await(3L, TimeUnit.SECONDS)), (String)"already expired tasks should run immediately");
    }

    public static final /* synthetic */ CountDownLatch $anonfun$testTaskExpiration$1(TimerTest $this, ArrayBuffer tasks$1, ArrayBuffer output$2, ArrayBuffer ids$1, int i) {
        CountDownLatch latch = new CountDownLatch(1);
        tasks$1.$plus$eq((Object)new TestTask($this, i, i, latch, (ArrayBuffer<Object>)output$2));
        ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
        return latch;
    }

    public static final /* synthetic */ CountDownLatch $anonfun$testTaskExpiration$2(TimerTest $this, ArrayBuffer tasks$1, ArrayBuffer output$2, ArrayBuffer ids$1, int i) {
        CountDownLatch latch = new CountDownLatch(2);
        tasks$1.$plus$eq((Object)new TestTask($this, i, i, latch, (ArrayBuffer<Object>)output$2));
        tasks$1.$plus$eq((Object)new TestTask($this, i, i, latch, (ArrayBuffer<Object>)output$2));
        ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
        ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
        return latch;
    }

    public static final /* synthetic */ CountDownLatch $anonfun$testTaskExpiration$3(TimerTest $this, ArrayBuffer tasks$1, ArrayBuffer output$2, ArrayBuffer ids$1, int i) {
        CountDownLatch latch = new CountDownLatch(1);
        tasks$1.$plus$eq((Object)new TestTask($this, i, i, latch, (ArrayBuffer<Object>)output$2));
        ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
        return latch;
    }

    private class TestTask
    implements TimerTask {
        private final long delayMs;
        private final int id;
        private final CountDownLatch latch;
        private final ArrayBuffer<Object> output;
        private final AtomicBoolean completed;
        private TimerTaskEntry kafka$utils$timer$TimerTask$$timerTaskEntry;
        public final /* synthetic */ TimerTest $outer;

        public void cancel() {
            TimerTask.cancel$((TimerTask)this);
        }

        public void setTimerTaskEntry(TimerTaskEntry entry) {
            TimerTask.setTimerTaskEntry$((TimerTask)this, (TimerTaskEntry)entry);
        }

        public TimerTaskEntry getTimerTaskEntry() {
            return TimerTask.getTimerTaskEntry$((TimerTask)this);
        }

        public TimerTaskEntry kafka$utils$timer$TimerTask$$timerTaskEntry() {
            return this.kafka$utils$timer$TimerTask$$timerTaskEntry;
        }

        public void kafka$utils$timer$TimerTask$$timerTaskEntry_$eq(TimerTaskEntry x$1) {
            this.kafka$utils$timer$TimerTask$$timerTaskEntry = x$1;
        }

        public long delayMs() {
            return this.delayMs;
        }

        public void run() {
            if (this.completed.compareAndSet(false, true)) {
                ArrayBuffer<Object> arrayBuffer = this.output;
                synchronized (arrayBuffer) {
                    ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.output.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.id));
                }
                this.latch.countDown();
                return;
            }
        }

        public /* synthetic */ TimerTest kafka$utils$timer$TimerTest$TestTask$$$outer() {
            return this.$outer;
        }

        public TestTask(TimerTest $outer, long delayMs, int id, CountDownLatch latch, ArrayBuffer<Object> output) {
            this.delayMs = delayMs;
            this.id = id;
            this.latch = latch;
            this.output = output;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.completed = new AtomicBoolean(false);
        }
    }
}

