/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.security.authorizer.AclEntry$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ConfigType$;
import kafka.server.ControllerMigrationSupport;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.EncryptingPasswordEncoder;
import kafka.utils.Logging;
import kafka.utils.NoOpPasswordEncoder;
import kafka.utils.PasswordEncoder;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import kafka.zk.TopicZNode;
import kafka.zk.ZkMigrationClient;
import kafka.zk.ZkMigrationClient$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.migration.MigrationDriverState;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ClusterTestExtensions.class})
@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\t]h\u0001\u0002\u0011\"\u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0004\u0005y\u0001\u0001Q\bC\u0003.\t\u0011\u0005a\bC\u0004B\t\t\u0007I\u0011\u0001\"\t\r1#\u0001\u0015!\u0003D\u0011\u001diE\u00011A\u0005\u00029CqA\u0015\u0003A\u0002\u0013\u00051\u000b\u0003\u0004Z\t\u0001\u0006Ka\u0014\u0005\u00065\u0012!\ta\u0017\u0005\u0006]\u0012!\ta\u001c\u0005\u0006q\u0002!\t!\u001f\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!&\u0001\t\u0003\t9\nC\u0004\u0002&\u0002!\t!a*\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0005gAqA!\u001b\u0001\t\u0003\u0011Y\u0007C\u0004\u0003v\u0001!\tAa\u001e\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003\u0004\"9!Q\u0012\u0001\u0005\u0002\t=\u0005b\u0002BM\u0001\u0011\u0005!1\u0014\u0005\b\u0005?\u0003A\u0011\u0001BQ\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005OCqAa+\u0001\t\u0003\u0011i\u000bC\u0004\u00032\u0002!\tAa-\u00035i[W*[4sCRLwN\\%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\t\u001a\u0013A\u0001>l\u0015\u0005!\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u001d\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00010!\t\u0001\u0004!D\u0001\"\u0003\rawnZ\u000b\u0002gA\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0006g24GG\u001b\u0006\u0002q\u0005\u0019qN]4\n\u0005i*$A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004#!F'fi\u0006$\u0017\r^1EK2$\u0018MV3sS\u001aLWM]\n\u0003\t\u001d\"\u0012a\u0010\t\u0003\u0001\u0012i\u0011\u0001A\u0001\u000e[\u0016$\u0018\rZ1uC\u0012+G\u000e^1\u0016\u0003\r\u0003\"\u0001\u0012&\u000e\u0003\u0015S!AR$\u0002\u000b%l\u0017mZ3\u000b\u0005\u0011B%BA%8\u0003\u0019\t\u0007/Y2iK&\u00111*\u0012\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u0012+G\u000e^1\u0002\u001d5,G/\u00193bi\u0006$U\r\u001c;bA\u00051qN\u001a4tKR,\u0012a\u0014\t\u0003QAK!!U\u0015\u0003\u0007%sG/\u0001\u0006pM\u001a\u001cX\r^0%KF$\"\u0001V,\u0011\u0005!*\u0016B\u0001,*\u0005\u0011)f.\u001b;\t\u000faK\u0011\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010J\u0019\u0002\u000f=4gm]3uA\u00051\u0011mY2faR$\"\u0001\u0016/\t\u000bu[\u0001\u0019\u00010\u0002\u000b\t\fGo\u00195\u0011\u0007}#g-D\u0001a\u0015\t\t'-\u0001\u0003vi&d'\"A2\u0002\t)\fg/Y\u0005\u0003K\u0002\u0014A\u0001T5tiB\u0011q\r\\\u0007\u0002Q*\u0011\u0011N[\u0001\u0007G>lWn\u001c8\u000b\u0005-<\u0015AB:feZ,'/\u0003\u0002nQ\n!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:\faA^3sS\u001aLHC\u0001+q\u0011\u0015\tH\u00021\u0001s\u0003!1XM]5gS\u0016\u0014\b\u0003\u0002\u0015tkRK!\u0001^\u0015\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001#w\u0013\t9XIA\u0007NKR\fG-\u0019;b\u00136\fw-Z\u0001\u0010i\u0016\u001cH/T5he\u0006$X-Q2mgR\u0011AK\u001f\u0005\u0006w6\u0001\r\u0001`\u0001\u0010G2,8\u000f^3s\u0013:\u001cH/\u00198dKB\u0019Q0!\u0001\u000e\u0003yT!a`\u0012\u0002\tQ,7\u000f^\u0005\u0004\u0003\u0007q(aD\"mkN$XM]%ogR\fgnY3)/5\t9!a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u0012\u0003K\ty#!\r\u0002<\u0005u\u0002\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055a0\u0001\u0006b]:|G/\u0019;j_:LA!!\u0005\u0002\f\tY1\t\\;ti\u0016\u0014H+Z:u\u0003\u001d\u0011'o\\6feNl\u0012aA\u0001\fG2,8\u000f^3s)f\u0004X\r\n\u0002\u0002\u001c%!\u0011QDA\u0010\u0003\tQ6J\u0003\u0003\u0002\"\u0005-\u0011\u0001\u0002+za\u0016\f\u0011\"Y;u_N#\u0018M\u001d;%\u0005\u0005\u001d\u0012\u0002BA\u0015\u0003W\t1!W#T\u0015\u0011\ti#a\u0003\u0002\u0013\u0005+Ho\\*uCJ$\u0018aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8%\u0005\u0005M\u0012\u0002BA\u001b\u0003o\t1\"\u0013\"Q?NzFgX%Wa)\u0019\u0011\u0011\b5\u0002\u001f5+G/\u00193bi\u00064VM]:j_:\f\u0001c]3sm\u0016\u0014\bK]8qKJ$\u0018.Z:-\t\u0005}\u00121K\u0016\u000b\u0003\u0003\n9%!\u0013\u0002N\u0005=\u0003\u0003BA\u0005\u0003\u0007JA!!\u0012\u0002\f\t)2\t\\;ti\u0016\u00148i\u001c8gS\u001e\u0004&o\u001c9feRL\u0018aA6fs\u0006\u0012\u00111J\u0001\u0016CV$\bn\u001c:ju\u0016\u0014hf\u00197bgNtc.Y7f\u0003\u00151\u0018\r\\;fC\t\t\t&A\u0014lC\u001a\\\u0017ML:fGV\u0014\u0018\u000e^=/CV$\bn\u001c:ju\u0016\u0014h&Q2m\u0003V$\bn\u001c:ju\u0016\u00148FCA!\u0003\u000f\n)&!\u0014\u0002Z\u0005\u0012\u0011qK\u0001\fgV\u0004XM\u001d\u0018vg\u0016\u00148/\t\u0002\u0002\\\u0005qQk]3su\u0005suJT-N\u001fV\u001b\u0016a\b;fgR\u001cF/\u0019:u5.\u0014%o\\6fe^KG\u000f[!vi\"|'/\u001b>feR\u0019A+!\u0019\t\r\u0005\rd\u00021\u0001}\u0003%Q8n\u00117vgR,'\u000fK\f\u000f\u0003\u000f\t\u0019\"!\u0006\u0002\u0018\u0005e\u00111EA\u0013\u0003_\t\t$a\u000f\u0002h1b\u0011qHA*\u0003S\n\u0019(! \u0002\u0004.R\u0011\u0011IA$\u0003W\ni%a\u001c\"\u0005\u00055\u0014AG5oi\u0016\u0014hF\u0019:pW\u0016\u0014h\u0006\\5ti\u0016tWM\u001d\u0018oC6,\u0017EAA9\u0003!)\u0005\fV#S\u001d\u0006c5FCA!\u0003\u000f\n)(!\u0014\u0002z\u0005\u0012\u0011qO\u0001\nY&\u001cH/\u001a8feN\f#!a\u001f\u0002]Ac\u0015)\u0013(U\u000bb#&hL\u0018m_\u000e\fG\u000e[8tij\u0002D&\u0012-U\u000bJs\u0015\t\u0014\u001e0_1|7-\u00197i_N$(\bM\u0016\u000b\u0003\u0003\n9%a \u0002N\u0005e\u0014EAAA\u0003Q\tGM^3si&\u001cX\r\u001a\u0018mSN$XM\\3sg.R\u0011\u0011IA$\u0003\u000b\u000bi%!#\"\u0005\u0005\u001d\u0015A\b7jgR,g.\u001a:/g\u0016\u001cWO]5us:\u0002(o\u001c;pG>dg&\\1qC\t\tY)\u0001\u0014F1R+%KT!MuAc\u0015)\u0013(U\u000bb#F\u0006\u0015'B\u0013:#V\t\u0017+;!2\u000b\u0015J\u0014+F1R\u000b1\u0002^3ti6KwM]1uKR\u0019A+!%\t\u000bm|\u0001\u0019\u0001?)\u001f=\t9!a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u0018\u0003c\t!\u0003^3ti\u0012+\u0018\r\\,sSR,7k\u0019:b[R\u0019A+!'\t\r\u0005\r\u0004\u00031\u0001}QM\u0001\u0012qAA\f\u00033\t\u0019\"!\u0006\u00020\u0005u\u00151HARI\t\ty*\u0003\u0003\u0002\"\u0006]\u0012aC%C!~\u001bt,N0J-Jb\u0003\"!\u001b\u0002t\u0005u\u00141Q\u0001\u000ei\u0016\u001cH\u000fR;bY^\u0013\u0018\u000e^3\u0015\u0007Q\u000bI\u000b\u0003\u0004\u0002dE\u0001\r\u0001 \u0015\u0014#\u0005\u001d\u0011qCA\r\u0003'\t)\"a\f\u00022\u0005m\u0012Q\u0016\u0017\t\u0003S\n\u0019(! \u0002\u0004\u0006QB/Z:u\tV\fGn\u0016:ji\u0016\fVo\u001c;b\u0003:$7k\u0019:b[R\u0019A+a-\t\r\u0005\r$\u00031\u0001}QM\u0011\u0012qAA\f\u00033\t\u0019\"!\u0006\u00020\u0005u\u00151HA\\Y!\tI'a\u001d\u0002~\u0005\r\u0015A\t;fgRtUm^!oI\u000eC\u0017M\\4fIR{\u0007/[2t\u0013:$U/\u00197Xe&$X\rF\u0002U\u0003{Ca!a\u0019\u0014\u0001\u0004a\bfE\n\u0002\b\u0005]\u0011\u0011DA\n\u0003+\ty#!\r\u0002<\u0005\u0005G\u0006CA5\u0003g\ni(a!\u00029Y,'/\u001b4z)>\u0004\u0018n\u0019)beRLG/[8o\u001b\u0016$\u0018\rZ1uCR9A+a2\u0002b\n\u0005\u0001bBAe)\u0001\u0007\u00111Z\u0001\ni>\u0004\u0018n\u0019(b[\u0016\u0004B!!4\u0002\\:!\u0011qZAl!\r\t\t.K\u0007\u0003\u0003'T1!!6&\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\\\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\ti.a8\u0003\rM#(/\u001b8h\u0015\r\tI.\u000b\u0005\b\u0003G$\u0002\u0019AAs\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007\u0003O\f\t0a>\u000f\t\u0005%\u0018Q\u001e\b\u0005\u0003#\fY/C\u0001+\u0013\r\ty/K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u00190!>\u0003\u0007M+\u0017OC\u0002\u0002p&\u0002B!!?\u0002~6\u0011\u00111 \u0006\u0003S\u001eKA!a@\u0002|\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B\u0002)\u0001\u0007!QA\u0001\tu.\u001cE.[3oiB\u0019\u0001Ga\u0002\n\u0007\t%\u0011EA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\ni>\u0004\u0018n\u0019#fg\u000e$bAa\u0004\u0003&\t%\u0002#\u0002\u0015\u0003\u0012\tU\u0011b\u0001B\nS\t1q\n\u001d;j_:\u0004BAa\u0006\u0003\"5\u0011!\u0011\u0004\u0006\u0005\u00057\u0011i\"A\u0003bI6LgNC\u0002\u0003 \u001d\u000bqa\u00197jK:$8/\u0003\u0003\u0003$\te!\u0001\u0005+pa&\u001cG)Z:de&\u0004H/[8o\u0011\u001d\u00119#\u0006a\u0001\u0003\u0017\fQ\u0001^8qS\u000eDqAa\u0007\u0016\u0001\u0004\u0011Y\u0003\u0005\u0003\u0003\u0018\t5\u0012\u0002\u0002B\u0018\u00053\u0011Q!\u00113nS:\fqc]3oI\u0006cGn\\2bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\nZ:\u0015\t\tU\"q\t\t\u0007\u0005o\u0011iD!\u0011\u000e\u0005\te\"b\u0001B\u001eA\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\t}\"\u0011\b\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007c\u0001\u0015\u0003D%\u0019!QI\u0015\u0003\t1{gn\u001a\u0005\b\u0005\u00132\u0002\u0019\u0001B&\u0003EQ8n\u00117vgR,'/\u00138ti\u0006t7-\u001a\t\u0005\u0005\u001b\u0012\u0019G\u0004\u0003\u0003P\tuc\u0002\u0002B)\u00053rAAa\u0015\u0003X9!\u0011\u0011\u001bB+\u0013\u0005!\u0013BA@$\u0013\r\u0011YF`\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005?\u0012\t'\u0001\u000e[W\u000ecWo\u001d;fe&sgo\\2bi&|gnQ8oi\u0016DHOC\u0002\u0003\\yLAA!\u001a\u0003h\t\t\"l[\"mkN$XM]%ogR\fgnY3\u000b\t\t}#\u0011M\u0001\u0014e\u0016\fG\r\u0015:pIV\u001cWM]%e\u00052|7m\u001b\u000b\u0005\u0005[\u0012\u0019\bE\u0002h\u0005_J1A!\u001di\u0005A\u0001&o\u001c3vG\u0016\u0014\u0018\nZ:CY>\u001c7\u000eC\u0004\u0003\u0004]\u0001\rA!\u0002\u0002!\u0005dG/\u001a:U_BL7mQ8oM&<G\u0003\u0002B=\u0005\u007f\u0002BAa\u0006\u0003|%!!Q\u0010B\r\u0005I\tE\u000e^3s\u0007>tg-[4t%\u0016\u001cX\u000f\u001c;\t\u000f\tm\u0001\u00041\u0001\u0003,\u0005\t\u0012\r\u001c;fe\u000ec\u0017.\u001a8u#V|G/Y:\u0015\t\t\u0015%1\u0012\t\u0005\u0005/\u00119)\u0003\u0003\u0003\n\ne!aF!mi\u0016\u00148\t\\5f]R\fVo\u001c;bgJ+7/\u001e7u\u0011\u001d\u0011Y\"\u0007a\u0001\u0005W\t!d\u0019:fCR,Wk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN$BA!%\u0003\u0018B!!q\u0003BJ\u0013\u0011\u0011)J!\u0007\u0003?\u0005cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgVdG\u000fC\u0004\u0003\u001ci\u0001\rAa\u000b\u00023\u0005dG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0005\u0005#\u0013i\nC\u0004\u0003\u001cm\u0001\rAa\u000b\u0002%Y,'/\u001b4z)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u0004)\n\r\u0006b\u0002B\u00029\u0001\u0007!QA\u0001\u0013m\u0016\u0014\u0018NZ=DY&,g\u000e^)v_R\f7\u000fF\u0002U\u0005SCqAa\u0001\u001e\u0001\u0004\u0011)!\u0001\u000ewKJLg-_+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7\u000fF\u0002U\u0005_CqAa\u0001\u001f\u0001\u0004\u0011)!\u0001\ntQV$Hm\\<o\u0013:\u001cV-];f]\u000e,G#\u0002+\u00036\n]\u0006BBA2?\u0001\u0007A\u0010C\u0004\u0003:~\u0001\rAa/\u0002\u0019-\u0014\u0018M\u001a;DYV\u001cH/\u001a:\u0011\t\tu&1Y\u0007\u0003\u0005\u007fS1A!1$\u0003\u001d!Xm\u001d;lSRLAA!2\u0003@\n\u00192*\u00194lC\u000ecWo\u001d;feR+7\u000f^&ji\":\u0001A!3\u0002N\tm\u0007\u0003\u0002Bf\u0005/l!A!4\u000b\t\t='\u0011[\u0001\u0004CBL'\u0002\u0002Bj\u0005+\fqA[;qSR,'OC\u0002\u0003\\]JAA!7\u0003N\n9A+[7f_V$hDA\u0001-Q\u001d\u0001!q\\A'\u0005W\u0004BA!9\u0003h6\u0011!1\u001d\u0006\u0005\u0005K\u0014i-A\u0005fqR,gn]5p]&!!\u0011\u001eBr\u0005))\u0005\u0010^3oI^KG\u000f\u001b\u0017\u0003\u0005[\u001c#Aa<\u0011\t\tE(1_\u0007\u0003\u0005CJAA!>\u0003b\t)2\t\\;ti\u0016\u0014H+Z:u\u000bb$XM\\:j_:\u001c\b")
public class ZkMigrationIntegrationTest {
    private final Logger log = LoggerFactory.getLogger(ZkMigrationIntegrationTest.class);

    public Logger log() {
        return this.log;
    }

    @ClusterTest(brokers=3, clusterType=Type.ZK, autoStart=AutoStart.YES, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer"), @ClusterConfigProperty(key="super.users", value="User:ANONYMOUS")})
    public void testMigrateAcls(ClusterInstance clusterInstance) {
        Admin admin = clusterInstance.createAdminClient();
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        String username = "alice";
        KafkaPrincipal principal = new KafkaPrincipal("User", username);
        KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(principal.toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(principal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(wildcardPrincipal.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        admin.createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava()).all().get();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, (PasswordEncoder)new NoOpPasswordEncoder());
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), x$1 -> {});
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrateAcls$3(acl1, acl2, acl3, acl4, image);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(brokers=3, clusterType=Type.ZK, autoStart=AutoStart.YES, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="authorizer.class.name", value="kafka.security.authorizer.AclAuthorizer"), @ClusterConfigProperty(key="super.users", value="User:ANONYMOUS"), @ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testStartZkBrokerWithAuthorizer(ClusterInstance zkCluster) {
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testStartZkBrokerWithAuthorizer$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.inDualWrite$1(kraftCluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for dual-write mode");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(brokers=3, clusterType=Type.ZK, metadataVersion=MetadataVersion.IBP_3_4_IV0)
    public void testMigrate(ClusterInstance clusterInstance) {
        NoOpPasswordEncoder noOpPasswordEncoder;
        Admin admin = clusterInstance.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test-topic-1", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        newTopics.add(new NewTopic("test-topic-2", 1, (short)3));
        newTopics.add(new NewTopic("test-topic-3", 10, (short)3));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        admin.alterClientQuotas(quotas).all().get(60L, TimeUnit.SECONDS);
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().zkClient();
        KafkaConfig kafkaConfig = ((KafkaServer)((ZkClusterInvocationContext.ZkClusterInstance)clusterInstance).getUnderlying().servers().head()).config();
        Option option = kafkaConfig.passwordEncoderSecret();
        if (option instanceof Some) {
            void encrypting_iterations;
            void encrypting_keyLength;
            void encrypting_cipherAlgorithm;
            Password secret = (Password)((Some)option).value();
            int n = Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderIterations());
            int n2 = Predef$.MODULE$.Integer2int(kafkaConfig.passwordEncoderKeyLength());
            String string = kafkaConfig.passwordEncoderCipherAlgorithm();
            Option encrypting_keyFactoryAlgorithm = kafkaConfig.passwordEncoderKeyFactoryAlgorithm();
            noOpPasswordEncoder = new EncryptingPasswordEncoder(secret, encrypting_keyFactoryAlgorithm, (String)encrypting_cipherAlgorithm, (int)encrypting_keyLength, (int)encrypting_iterations);
            Object var14_12 = null;
            string = null;
        } else if (None$.MODULE$.equals(option)) {
            noOpPasswordEncoder = new NoOpPasswordEncoder();
        } else {
            throw new MatchError((Object)option);
        }
        NoOpPasswordEncoder zkConfigEncoder = noOpPasswordEncoder;
        ZkMigrationClient migrationClient = ZkMigrationClient$.MODULE$.apply(zkClient, (PasswordEncoder)zkConfigEncoder);
        ZkMigrationLeadershipState migrationState = migrationClient.getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState.EMPTY);
        migrationState = migrationState.withNewKRaftController(3000, 42);
        migrationState = migrationClient.claimControllerLeadership(migrationState);
        HashSet brokers = new HashSet();
        MetadataDeltaVerifier verifier = new MetadataDeltaVerifier();
        migrationClient.readAllMetadata(batch -> verifier.accept((java.util.List<ApiMessageAndVersion>)batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((Object)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(brokers).asScala().toSeq());
        verifier.verify((Function1<MetadataImage, BoxedUnit>)(Function1 & Serializable)image -> {
            ZkMigrationIntegrationTest.$anonfun$testMigrate$3(image);
            return BoxedUnit.UNIT;
        });
        migrationClient.releaseControllerLeadership(migrationState);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_5_IV2, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_5_IV2).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteScram$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWrite(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic("test", 2, (short)3).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"102400"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"300000")}))).asJava()));
        admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        Properties propsBefore = zkClient.getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((Object)"102400", (Object)propsBefore.getProperty("segment.bytes"));
        Assertions.assertEquals((Object)"300000", (Object)propsBefore.getProperty("segment.ms"));
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            long nextProducerId = BoxesRunTime.unboxToLong((Object)this.sendAllocateProducerIds((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).get(30L, TimeUnit.SECONDS));
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWrite$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterTopicConfig(admin).all().get(60L, TimeUnit.SECONDS);
            this.alterClientQuotas(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyTopicConfigs(zkClient);
            this.verifyClientQuotas(zkClient);
            long nextKRaftProducerId = BoxesRunTime.unboxToLong((Object)this.sendAllocateProducerIds((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).get(30L, TimeUnit.SECONDS));
            Assertions.assertNotEquals((long)nextProducerId, (long)nextKRaftProducerId);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_5_IV2, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testDualWriteQuotaAndScram(ClusterInstance zkCluster) {
        Admin admin = zkCluster.createAdminClient();
        this.createUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
        admin.close();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_5_IV2).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testDualWriteQuotaAndScram$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Updating metadata with AdminClient");
            admin = zkCluster.createAdminClient();
            this.alterUserScramCredentials(admin).all().get(60L, TimeUnit.SECONDS);
            this.alterClientQuotas(admin).all().get(60L, TimeUnit.SECONDS);
            this.log().info("Verifying metadata changes with ZK");
            this.verifyUserScramCredentials(zkClient);
            this.verifyClientQuotas(zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.ZK, brokers=3, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="inter.broker.listener.name", value="EXTERNAL"), @ClusterConfigProperty(key="listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="advertised.listeners", value="PLAINTEXT://localhost:0,EXTERNAL://localhost:0"), @ClusterConfigProperty(key="listener.security.protocol.map", value="EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT")})
    public void testNewAndChangedTopicsInDualWrite(ClusterInstance zkCluster) {
        String topicName = "test";
        zkCluster.createAdminClient();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkClient();
        String clusterId = zkCluster.clusterId();
        KafkaClusterTestKit kraftCluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_4_IV0).setClusterId(Uuid.fromString((String)clusterId)).setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true").setConfigProp(KafkaConfig$.MODULE$.ZkConnectProp(), ((ZkClusterInvocationContext.ZkClusterInstance)zkCluster).getUnderlying().zkConnect()).build();
        try {
            void var12_20;
            Tuple2 tuple2;
            kraftCluster.format();
            kraftCluster.startup();
            CompletableFuture readyFuture = ((ControllerServer)CollectionConverters$.MODULE$.CollectionHasAsScala(kraftCluster.controllers().values()).asScala().head()).controller().waitForReadyBrokers(3);
            this.log().info("Restart brokers in migration mode");
            Object voters = kraftCluster.controllerClientProperties().get("controller.quorum.voters");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.MigrationEnabledProp(), "true");
            zkCluster.config().serverProperties().put("controller.quorum.voters", voters);
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
            zkCluster.config().serverProperties().put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            zkCluster.rollingBrokerRestart();
            zkCluster.waitForReadyBrokers();
            readyFuture.get(30L, TimeUnit.SECONDS);
            this.log().info("Waiting for ZK migration to begin");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 30000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$1(zkClient)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for KRaft controller to take over");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.log().info("Create new topic with AdminClient");
            Admin admin = zkCluster.createAdminClient();
            ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
            newTopics.add(new NewTopic(topicName, 2, (short)3));
            admin.createTopics(newTopics).all().get(60L, TimeUnit.SECONDS);
            .colon.colon existingPartitions = new .colon.colon((Object)new TopicPartition(topicName, 0), (List)new .colon.colon((Object)new TopicPartition(topicName, 1), (List)Nil$.MODULE$));
            this.verifyTopicPartitionMetadata(topicName, (scala.collection.immutable.Seq<TopicPartition>)existingPartitions, zkClient);
            int newPartitionCount = 3;
            this.log().info("Create new partitions with AdminClient");
            admin.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)NewPartitions.increaseTo((int)newPartitionCount))}))).asJava()).all().get(60L, TimeUnit.SECONDS);
            long l2 = 100L;
            long computeUntilTrue_waitTime = 15000L;
            long computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void computeUntilTrue_pause;
                Option<TopicDescription> computeUntilTrue_result;
                if (ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$4(newPartitionCount, computeUntilTrue_result = this.topicDesc(topicName, admin))) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    break;
                }
                if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    break;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
            }
            Object var27_18 = null;
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Option topicDescOpt = (Option)tuple22._1();
            Assertions.assertTrue((boolean)var12_20.isDefined());
            Buffer partitions = CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)var12_20.get()).partitions()).asScala();
            Assertions.assertEquals((int)newPartitionCount, (int)partitions.size());
            this.verifyTopicPartitionMetadata(topicName, (scala.collection.immutable.Seq<TopicPartition>)((scala.collection.immutable.Seq)existingPartitions.$plus$plus((IterableOnce)new .colon.colon((Object)new TopicPartition(topicName, 2), (List)Nil$.MODULE$))), zkClient);
        }
        finally {
            this.shutdownInSequence(zkCluster, kraftCluster);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void verifyTopicPartitionMetadata(String topicName, scala.collection.immutable.Seq<TopicPartition> partitions, KafkaZkClient zkClient) {
        void var5_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Option computeUntilTrue_result;
            if ((computeUntilTrue_result = ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$1(zkClient, topicName)).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$3(partitions$1, x$2)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Option topicIdReplicaAssignment = (Option)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Unable to find topic metadata in Zk");
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$4(zkClient, partitions, (Option)var5_9)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Unable to find topic partition metadata");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public Option<TopicDescription> topicDesc(String topic, Admin admin) {
        try {
            return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)admin.describeTopics(Collections.singleton(topic)).allTopicNames().get()).asScala().get((Object)topic);
        }
        catch (Throwable throwable) {
            return None$.MODULE$;
        }
    }

    public CompletableFuture<Object> sendAllocateProducerIds(ZkClusterInvocationContext.ZkClusterInstance zkClusterInstance) {
        BrokerToControllerChannelManager channel = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).clientToControllerChannelManager();
        int brokerId = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).config().brokerId();
        long brokerEpoch = ((KafkaBroker)zkClusterInstance.getUnderlying().brokers().head()).replicaManager().brokerEpochSupplier().apply$mcJ$sp();
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData().setBrokerId(brokerId).setBrokerEpoch(brokerEpoch));
        CompletableFuture<Object> producerIdStart = new CompletableFuture<Object>();
        channel.sendRequest((AbstractRequest.Builder)request, new ControllerRequestCompletionHandler(null, producerIdStart){
            private final CompletableFuture producerIdStart$1;

            public void onTimeout() {
                this.producerIdStart$1.completeExceptionally((Throwable)new TimeoutException("Request timed out"));
            }

            public void onComplete(ClientResponse response) {
                AllocateProducerIdsResponse body = (AllocateProducerIdsResponse)response.responseBody();
                this.producerIdStart$1.complete(BoxesRunTime.boxToLong((long)body.data().producerIdStart()));
            }
            {
                this.producerIdStart$1 = producerIdStart$1;
            }
        });
        return producerIdStart;
    }

    /*
     * WARNING - void declaration
     */
    public ProducerIdsBlock readProducerIdBlock(KafkaZkClient zkClient) {
        void var3_3;
        Tuple2 tuple2 = zkClient.getDataAndVersion("/latest_producer_id_block");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        return (ProducerIdsBlock)var3_3.map((Function1 & Serializable)jsonData -> ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(jsonData)).get();
    }

    public AlterConfigsResult alterTopicConfig(Admin admin) {
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "test");
        Collection alterConfigs = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.bytes", "204800"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.ms", null), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))).asJavaCollection();
        return admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource), (Object)alterConfigs)}))).asJava());
    }

    public AlterClientQuotasResult alterClientQuotas(Admin admin) {
        ArrayList<ClientQuotaAlteration> quotas = new ArrayList<ClientQuotaAlteration>();
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), (List)Nil$.MODULE$)).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(800.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(100.0)), (List)Nil$.MODULE$))).asJava()));
        quotas.add(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"8.8.8.8")}))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)), (List)Nil$.MODULE$)).asJava()));
        return admin.alterClientQuotas(quotas);
    }

    public AlterUserScramCredentialsResult createUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8190), "password0"));
        return admin.alterUserScramCredentials(alterations);
    }

    public AlterUserScramCredentialsResult alterUserScramCredentials(Admin admin) {
        ArrayList<UserScramCredentialUpsertion> alterations = new ArrayList<UserScramCredentialUpsertion>();
        alterations.add(new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8191), "password1"));
        alterations.add(new UserScramCredentialUpsertion("user2", new ScramCredentialInfo(ScramMechanism.SCRAM_SHA_256, 8192), "password2"));
        return admin.alterUserScramCredentials(alterations);
    }

    public void verifyTopicConfigs(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyTopicConfigs$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyClientQuotas(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyClientQuotas$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void verifyUserScramCredentials(KafkaZkClient zkClient) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ZkMigrationIntegrationTest.$anonfun$verifyUserScramCredentials$1(zkClient);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    Object var8_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += package$.MODULE$.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    public void shutdownInSequence(ClusterInstance zkCluster, KafkaClusterTestKit kraftCluster) {
        zkCluster.brokerIds().forEach(x$5 -> zkCluster.shutdownBroker(Predef$.MODULE$.Integer2int(x$5)));
        kraftCluster.close();
        zkCluster.stop();
    }

    public static final /* synthetic */ void $anonfun$testMigrateAcls$3(AclBinding acl1$1, AclBinding acl2$1, AclBinding acl3$1, AclBinding acl4$1, MetadataImage image) {
        java.util.Map aclMap = image.acls().acls();
        Assertions.assertEquals((int)4, (int)aclMap.size());
        Assertions.assertTrue((boolean)aclMap.values().containsAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl1$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl2$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl3$1), (List)new .colon.colon((Object)StandardAcl.fromAclBinding((AclBinding)acl4$1), (List)Nil$.MODULE$))))).asJava()));
    }

    public static final /* synthetic */ boolean $anonfun$testStartZkBrokerWithAuthorizer$1(KafkaZkClient zkClient$1) {
        return zkClient$1.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testStartZkBrokerWithAuthorizer$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    private static final boolean inDualWrite$1(KafkaClusterTestKit kraftCluster$1) {
        return ((MigrationDriverState)((ControllerMigrationSupport)kraftCluster$1.controllers().get(BoxesRunTime.boxToInteger((int)3000)).migrationSupport().get()).migrationDriver().migrationState().get(10L, TimeUnit.SECONDS)).allowDualWrite();
    }

    public static final /* synthetic */ boolean $anonfun$testStartZkBrokerWithAuthorizer$3(KafkaClusterTestKit kraftCluster$1) {
        return ZkMigrationIntegrationTest.inDualWrite$1(kraftCluster$1);
    }

    public static final /* synthetic */ String $anonfun$testStartZkBrokerWithAuthorizer$4() {
        return "Timed out waiting for dual-write mode";
    }

    public static final /* synthetic */ void $anonfun$testMigrate$3(MetadataImage image) {
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-1"));
        Assertions.assertEquals((int)2, (int)image.topics().getTopic("test-topic-1").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-2"));
        Assertions.assertEquals((int)1, (int)image.topics().getTopic("test-topic-2").partitions().size());
        Assertions.assertNotNull((Object)image.topics().getTopic("test-topic-3"));
        Assertions.assertEquals((int)10, (int)image.topics().getTopic("test-topic-3").partitions().size());
        java.util.Map clientQuotas = image.clientQuotas().entities();
        Assertions.assertEquals((int)3, (int)clientQuotas.size());
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteScram$1(KafkaZkClient zkClient$2) {
        return zkClient$2.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDualWrite$1(KafkaZkClient zkClient$3) {
        return zkClient$3.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWrite$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testDualWriteQuotaAndScram$1(KafkaZkClient zkClient$4) {
        return zkClient$4.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testDualWriteQuotaAndScram$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ boolean $anonfun$testNewAndChangedTopicsInDualWrite$1(KafkaZkClient zkClient$5) {
        return zkClient$5.getControllerId().contains((Object)BoxesRunTime.boxToInteger((int)3000));
    }

    public static final /* synthetic */ String $anonfun$testNewAndChangedTopicsInDualWrite$2() {
        return "Timed out waiting for KRaft controller to take over";
    }

    public static final /* synthetic */ Option $anonfun$testNewAndChangedTopicsInDualWrite$3(ZkMigrationIntegrationTest $this, String topicName$1, ObjectRef admin$1) {
        return $this.topicDesc(topicName$1, (Admin)admin$1.elem);
    }

    public static final /* synthetic */ boolean $anonfun$testNewAndChangedTopicsInDualWrite$4(int newPartitionCount$1, Option td) {
        return td.isDefined() && CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)td.get()).partitions()).asScala().size() == newPartitionCount$1;
    }

    public static final /* synthetic */ Option $anonfun$verifyTopicPartitionMetadata$1(KafkaZkClient zkClient$6, String topicName$2) {
        return zkClient$6.getReplicaAssignmentAndTopicIdForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName$2}))).headOption();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$3(scala.collection.immutable.Seq partitions$1, TopicZNode.TopicIdReplicaAssignment x$2) {
        return x$2.assignment().size() == partitions$1.size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$6(TopicPartition tp$1, LeaderIsrAndControllerEpoch lisr$1, TopicZNode.TopicIdReplicaAssignment x$4) {
        Seq seq = ((ReplicaAssignment)x$4.assignment().apply((Object)tp$1)).replicas();
        List list = lisr$1.leaderAndIsr().isr();
        return !(seq != null ? !seq.equals(list) : list != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$5(Option topicIdReplicaAssignment$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            LeaderIsrAndControllerEpoch lisr = (LeaderIsrAndControllerEpoch)x0$1._2();
            return lisr.leaderAndIsr().leader() >= 0 && topicIdReplicaAssignment$1.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$6(tp, lisr, x$4)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTopicPartitionMetadata$4(KafkaZkClient zkClient$6, scala.collection.immutable.Seq partitions$1, Option topicIdReplicaAssignment$1) {
        Map lisrMap = zkClient$6.getTopicPartitionStates((Seq)partitions$1.toSeq());
        return lisrMap.size() == partitions$1.size() && lisrMap.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$5(topicIdReplicaAssignment$1, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$verifyTopicPartitionMetadata$7() {
        return "Unable to find topic partition metadata";
    }

    public static final /* synthetic */ void $anonfun$verifyTopicConfigs$1(KafkaZkClient zkClient$7) {
        Properties propsAfter = zkClient$7.getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((Object)"204800", (Object)propsAfter.getProperty("segment.bytes"));
        Assertions.assertFalse((boolean)propsAfter.containsKey("segment.ms"));
    }

    public static final /* synthetic */ void $anonfun$verifyClientQuotas$1(KafkaZkClient zkClient$8) {
        Assertions.assertEquals((Object)"1000", (Object)zkClient$8.getEntityConfigs(ConfigType$.MODULE$.User(), "user1").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"800", (Object)zkClient$8.getEntityConfigs("users/user1/clients", "clientA").getProperty("consumer_byte_rate"));
        Assertions.assertEquals((Object)"100", (Object)zkClient$8.getEntityConfigs("users/user1/clients", "clientA").getProperty("producer_byte_rate"));
        Assertions.assertEquals((Object)"10", (Object)zkClient$8.getEntityConfigs(ConfigType$.MODULE$.Ip(), "8.8.8.8").getProperty("connection_creation_rate"));
    }

    public static final /* synthetic */ void $anonfun$verifyUserScramCredentials$1(KafkaZkClient zkClient$9) {
        ScramCredential scramCredentials1 = ScramCredentialUtils.credentialFromString((String)zkClient$9.getEntityConfigs(ConfigType$.MODULE$.User(), "user1").getProperty("SCRAM-SHA-256"));
        Assertions.assertEquals((int)8191, (int)scramCredentials1.iterations());
        String propertyValue2 = zkClient$9.getEntityConfigs(ConfigType$.MODULE$.User(), "user2").getProperty("SCRAM-SHA-256");
        Assertions.assertNotNull((Object)propertyValue2);
        ScramCredential scramCredentials2 = ScramCredentialUtils.credentialFromString((String)propertyValue2);
        Assertions.assertEquals((int)8192, (int)scramCredentials2.iterations());
    }

    public static final /* synthetic */ Object $anonfun$testNewAndChangedTopicsInDualWrite$4$adapted(int newPartitionCount$1, Option td) {
        return BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$testNewAndChangedTopicsInDualWrite$4(newPartitionCount$1, td));
    }

    public static final /* synthetic */ Object $anonfun$verifyTopicPartitionMetadata$2$adapted(scala.collection.immutable.Seq partitions$1, Option x) {
        return BoxesRunTime.boxToBoolean((boolean)x.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationIntegrationTest.$anonfun$verifyTopicPartitionMetadata$3(partitions$1, x$2))));
    }

    public class MetadataDeltaVerifier {
        private final MetadataDelta metadataDelta;
        private int offset;

        public MetadataDelta metadataDelta() {
            return this.metadataDelta;
        }

        public int offset() {
            return this.offset;
        }

        public void offset_$eq(int x$1) {
            this.offset = x$1;
        }

        public void accept(java.util.List<ApiMessageAndVersion> batch) {
            batch.forEach(message -> {
                this.metadataDelta().replay(message.message());
                this.offset_$eq(this.offset() + 1);
            });
        }

        public void verify(Function1<MetadataImage, BoxedUnit> verifier) {
            MetadataImage image = this.metadataDelta().apply(new MetadataProvenance((long)this.offset(), 0, 0L));
            verifier.apply((Object)image);
        }

        public /* synthetic */ ZkMigrationIntegrationTest kafka$zk$ZkMigrationIntegrationTest$MetadataDeltaVerifier$$$outer() {
            return ZkMigrationIntegrationTest.this;
        }

        public MetadataDeltaVerifier() {
            if (ZkMigrationIntegrationTest.this == null) {
                throw null;
            }
            this.metadataDelta = new MetadataDelta(MetadataImage.EMPTY);
            this.offset = 0;
        }
    }
}

