/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchSessionCache;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\n\u0014\u0001aA\u0001b\t\u0001\u0003\u0006\u0004%I\u0001\n\u0005\te\u0001\u0011\t\u0011)A\u0005K!A1\u0007\u0001BC\u0002\u0013%A\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u00036\u0011!I\u0004A!b\u0001\n\u0013Q\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011\t\u0003!Q1A\u0005\n\rC\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t1\u0002\u0011)\u0019!C\u00053\"AQ\f\u0001B\u0001B\u0003%!\f\u0003\u0005_\u0001\t\u0015\r\u0011\"\u0003Z\u0011!y\u0006A!A!\u0002\u0013Q\u0006\"\u00021\u0001\t\u0003\t\u0007\"B5\u0001\t\u0003R\u0007\"B:\u0001\t\u0003\"\b\"B?\u0001\t\u0003r\bbBA\u0011\u0001\u0011\u0005\u00131\u0005\u0002\u0011\rVdGNR3uG\"\u001cuN\u001c;fqRT!\u0001F\u000b\u0002\rM,'O^3s\u0015\u00051\u0012!B6bM.\f7\u0001A\n\u0004\u0001ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!C5\t1#\u0003\u0002#'\taa)\u001a;dQ\u000e{g\u000e^3yi\u0006!A/[7f+\u0005)\u0003C\u0001\u00141\u001b\u00059#B\u0001\u0015*\u0003\u0015)H/\u001b7t\u0015\tQ3&\u0001\u0004d_6lwN\u001c\u0006\u0003-1R!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO&\u0011\u0011g\n\u0002\u0005)&lW-A\u0003uS6,\u0007%A\u0003dC\u000eDW-F\u00016!\t\u0001c'\u0003\u00028'\t\tb)\u001a;dQN+7o]5p]\u000e\u000b7\r[3\u0002\r\r\f7\r[3!\u0003-\u0011X-]'fi\u0006$\u0017\r^1\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!AP\u0015\u0002\u0011I,\u0017/^3tiNL!\u0001Q\u001f\u0003\u001b\u0019+Go\u00195NKR\fG-\u0019;b\u00031\u0011X-]'fi\u0006$\u0017\r^1!\u0003%1W\r^2i\t\u0006$\u0018-F\u0001E!\u0011)%\n\u0014)\u000e\u0003\u0019S!a\u0012%\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0013\u0006!!.\u0019<b\u0013\tYeIA\u0002NCB\u0004\"!\u0014(\u000e\u0003%J!aT\u0015\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007CA)U\u001d\ta$+\u0003\u0002T{\u0005aa)\u001a;dQJ+\u0017/^3ti&\u0011QK\u0016\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\u0005Mk\u0014A\u00034fi\u000eDG)\u0019;bA\u0005aQo]3t)>\u0004\u0018nY%egV\t!\f\u0005\u0002\u001b7&\u0011Al\u0007\u0002\b\u0005>|G.Z1o\u00035)8/Z:U_BL7-\u00133tA\u0005q\u0011n\u001d$s_64u\u000e\u001c7po\u0016\u0014\u0018aD5t\rJ|WNR8mY><XM\u001d\u0011\u0002\rqJg.\u001b;?)\u001d\u00117\rZ3gO\"\u0004\"\u0001\t\u0001\t\u000b\rj\u0001\u0019A\u0013\t\u000bMj\u0001\u0019A\u001b\t\u000bej\u0001\u0019A\u001e\t\u000b\tk\u0001\u0019\u0001#\t\u000bak\u0001\u0019\u0001.\t\u000byk\u0001\u0019\u0001.\u0002\u001d\u001d,GOR3uG\"|eMZ:fiR\u00111.\u001d\t\u000451t\u0017BA7\u001c\u0005\u0019y\u0005\u000f^5p]B\u0011!d\\\u0005\u0003an\u0011A\u0001T8oO\")!O\u0004a\u0001\u0019\u0006!\u0001/\u0019:u\u0003A1wN]3bG\"\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0002vqB\u0011!D^\u0005\u0003on\u0011A!\u00168ji\")\u0011p\u0004a\u0001u\u0006\u0019a-\u001e8\u0011\u000biYH\nU;\n\u0005q\\\"!\u0003$v]\u000e$\u0018n\u001c83\u0003=9W\r\u001e*fgB|gn]3TSj,G#B@\u0002\u0006\u0005]\u0001c\u0001\u000e\u0002\u0002%\u0019\u00111A\u000e\u0003\u0007%sG\u000fC\u0004\u0002\bA\u0001\r!!\u0003\u0002\u000fU\u0004H-\u0019;fgB!\u00111BA\t\u001d\r\u0001\u0013QB\u0005\u0004\u0003\u001f\u0019\u0012\u0001\u0004$fi\u000eD7+Z:tS>t\u0017\u0002BA\n\u0003+\u0011\u0001BU#T!~k\u0015\t\u0015\u0006\u0004\u0003\u001f\u0019\u0002bBA\r!\u0001\u0007\u00111D\u0001\nm\u0016\u00148/[8o\u0013\u0012\u00042AGA\u000f\u0013\r\tyb\u0007\u0002\u0006'\"|'\u000f^\u0001\u001ekB$\u0017\r^3B]\u0012<UM\\3sCR,'+Z:q_:\u001cX\rR1uCR!\u0011QEA\u0016!\ra\u0014qE\u0005\u0004\u0003Si$!\u0004$fi\u000eD'+Z:q_:\u001cX\rC\u0004\u0002\bE\u0001\r!!\u0003")
public class FullFetchContext
implements FetchContext {
    private final Time time;
    private final FetchSessionCache cache;
    private final FetchMetadata reqMetadata;
    private final Map<TopicIdPartition, FetchRequest.PartitionData> fetchData;
    private final boolean usesTopicIds;
    private final boolean isFromFollower;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        return FetchContext.getThrottledResponse$(this, throttleTimeMs);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    private FetchMetadata reqMetadata() {
        return this.reqMetadata;
    }

    private Map<TopicIdPartition, FetchRequest.PartitionData> fetchData() {
        return this.fetchData;
    }

    private boolean usesTopicIds() {
        return this.usesTopicIds;
    }

    private boolean isFromFollower() {
        return this.isFromFollower;
    }

    @Override
    public Option<Object> getFetchOffset(TopicIdPartition part) {
        return Option$.MODULE$.apply((Object)this.fetchData().get(part)).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.fetchOffset));
    }

    @Override
    public void foreachPartition(Function2<TopicIdPartition, FetchRequest.PartitionData, BoxedUnit> fun) {
        this.fetchData().forEach((tp, data) -> fun.apply(tp, data));
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, short versionId) {
        return FetchResponse.sizeOf((short)versionId, updates.entrySet().iterator());
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates) {
        int responseSessionId = this.cache().maybeCreateSession(this.time().milliseconds(), this.isFromFollower(), updates.size(), this.usesTopicIds(), (Function0<ImplicitLinkedHashCollection<CachedPartition>>)(Function0 & Serializable)() -> this.createNewSession$1(updates));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Full fetch context with session id ").append(responseSessionId).append(" returning ").append(this.partitionsToLogString(updates.keySet())).toString());
        return FetchResponse.of((Errors)Errors.NONE, (int)0, (int)responseSessionId, updates);
    }

    private final ImplicitLinkedHashCollection createNewSession$1(LinkedHashMap updates$2) {
        ImplicitLinkedHashCollection cachedPartitions = new ImplicitLinkedHashCollection(updates$2.size());
        updates$2.forEach((part, respData) -> {
            FetchRequest.PartitionData reqData = this.fetchData().get(part);
            cachedPartitions.mustAdd((ImplicitLinkedHashCollection.Element)new CachedPartition((TopicIdPartition)part, reqData, (FetchResponseData.PartitionData)respData));
        });
        return cachedPartitions;
    }

    public FullFetchContext(Time time, FetchSessionCache cache, FetchMetadata reqMetadata, Map<TopicIdPartition, FetchRequest.PartitionData> fetchData, boolean usesTopicIds, boolean isFromFollower) {
        this.time = time;
        this.cache = cache;
        this.reqMetadata = reqMetadata;
        this.fetchData = fetchData;
        this.usesTopicIds = usesTopicIds;
        this.isFromFollower = isFromFollower;
    }
}

