/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$callback$1$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0005e!B\u0014)\u0003\u0003i\u0003\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0002\u001d\u0001\t\u0003I\u0004\"\u0003%\u0001\u0001\u0004\u0005\r\u0011\"\u0003J\u0011%i\u0006\u00011AA\u0002\u0013%a\fC\u0005e\u0001\u0001\u0007\t\u0011)Q\u0005\u0015\"9Q\r\u0001b\u0001\n\u00131\u0007BB:\u0001A\u0003%q\rC\u0005u\u0001\u0001\u0007\t\u0019!C\tk\"I1\u0010\u0001a\u0001\u0002\u0004%\t\u0002 \u0005\n}\u0002\u0001\r\u0011!Q!\nYD\u0001b \u0001C\u0002\u0013E\u0011\u0011\u0001\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\u0004!I\u0011Q\u0003\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u001a!9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003\u001f\u0002A\u0011CA)\u0011%\t)\tAI\u0001\n#\t9\tC\u0005\u0002\u001e\u0002\t\n\u0011\"\u0005\u0002\b\"I\u0011q\u0014\u0001\u0012\u0002\u0013E\u0011q\u0011\u0005\n\u0003C\u0003\u0011\u0013!C\t\u0003GC\u0011\"a*\u0001#\u0003%\t\"!+\t\u0013\u00055\u0006!%A\u0005\u0012\u0005%\u0006bBAX\u0001\u0011E\u0011\u0011\u0017\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u001d\tY\u000f\u0001C\u0001\u0003[Dq!a>\u0001\t\u0003\tI\u0010C\u0004\u0003\u0004\u0001!\tB!\u0002\t\u0013\t=\u0001!%A\u0005\u0012\u0005\u001d\u0005\"\u0003B\t\u0001E\u0005I\u0011CAU\u0011\u001d\u0011\u0019\u0002\u0001C\t\u0005+AqA!\f\u0001\t\u0003\u0011y\u0003C\u0004\u0003:\u0001!\tAa\u000f\t\u000f\t\u0015\u0003\u0001\"\u0001\u0003H!9!\u0011\u000b\u0001\u0005\u0002\tM\u0003b\u0002B/\u0001\u0011\u0005!q\f\u0005\b\u0005S\u0002A\u0011\u0001B6\u0011\u001d\u0011)\b\u0001C\u0001\u0005o\u0012ACQ1tKB\u0013x\u000eZ;dKJ\u001cVM\u001c3UKN$(BA\u0015+\u0003\r\t\u0007/\u001b\u0006\u0002W\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001/!\ty#'D\u00011\u0015\t\t$&A\u0006j]R,wM]1uS>t\u0017BA\u001a1\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u00017!\t9\u0004!D\u0001)\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001\u001e\u0011\u0007m\u0002%)D\u0001=\u0015\tid(\u0001\u0006d_2dWm\u0019;j_:T\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003r\u00121aU3r!\t\u0019e)D\u0001E\u0015\t)%&\u0001\u0004tKJ4XM]\u0005\u0003\u000f\u0012\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006A1m\u001c8tk6,'/F\u0001K!\u0011YEK\u0016,\u000e\u00031S!\u0001S'\u000b\u00059{\u0015aB2mS\u0016tGo\u001d\u0006\u0003WAS!!\u0015*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0016aA8sO&\u0011Q\u000b\u0014\u0002\t\u0007>t7/^7feB\u0019q\u000b\u0017.\u000e\u0003yJ!!\u0017 \u0003\u000b\u0005\u0013(/Y=\u0011\u0005][\u0016B\u0001/?\u0005\u0011\u0011\u0015\u0010^3\u0002\u0019\r|gn];nKJ|F%Z9\u0015\u0005}\u0013\u0007CA,a\u0013\t\tgH\u0001\u0003V]&$\bbB2\u0005\u0003\u0003\u0005\rAS\u0001\u0004q\u0012\n\u0014!C2p]N,X.\u001a:!\u0003%\u0001(o\u001c3vG\u0016\u00148/F\u0001h!\rA7.\\\u0007\u0002S*\u0011!\u000eP\u0001\b[V$\u0018M\u00197f\u0013\ta\u0017N\u0001\u0004Ck\u001a4WM\u001d\t\u0005]F4f+D\u0001p\u0015\t\u0001X*\u0001\u0005qe>$WoY3s\u0013\t\u0011xNA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM]\u0001\u000baJ|G-^2feN\u0004\u0013!B1e[&tW#\u0001<\u0011\u0005]LX\"\u0001=\u000b\u0005Ql\u0015B\u0001>y\u0005\u0015\tE-\\5o\u0003%\tG-\\5o?\u0012*\u0017\u000f\u0006\u0002`{\"91-CA\u0001\u0002\u00041\u0018AB1e[&t\u0007%A\u0003u_BL7-\u0006\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001\u00027b]\u001eT!!!\u0004\u0002\t)\fg/Y\u0005\u0005\u0003#\t9A\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u00159,XNU3d_J$7/\u0006\u0002\u0002\u001aA\u0019q+a\u0007\n\u0007\u0005uaHA\u0002J]R\f1B\\;n%\u0016\u001cwN\u001d3tA\u0005)1/\u001a;VaR\u0019q,!\n\t\u000f\u0005\u001dr\u00021\u0001\u0002*\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002,\u0005]RBAA\u0017\u0015\rI\u0013q\u0006\u0006\u0005\u0003c\t\u0019$A\u0004kkBLG/\u001a:\u000b\u0007\u0005U\"+A\u0003kk:LG/\u0003\u0003\u0002:\u00055\"\u0001\u0003+fgRLeNZ8)\u0007=\ti\u0004\u0005\u0003\u0002,\u0005}\u0012\u0002BA!\u0003[\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#A0)\u0007A\tI\u0005\u0005\u0003\u0002,\u0005-\u0013\u0002BA'\u0003[\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u001d\r\u0014X-\u0019;f!J|G-^2feRiQ.a\u0015\u0002X\u0005m\u0013qLA<\u0003\u0003C\u0011\"!\u0016\u0012!\u0003\u0005\r!!\u0007\u0002\u00111LgnZ3s\u001bND\u0011\"!\u0017\u0012!\u0003\u0005\r!!\u0007\u0002#\u0011,G.\u001b<fef$\u0016.\\3pkRl5\u000fC\u0005\u0002^E\u0001\n\u00111\u0001\u0002\u001a\u0005I!-\u0019;dQNK'0\u001a\u0005\n\u0003C\n\u0002\u0013!a\u0001\u0003G\nqbY8naJ,7o]5p]RK\b/\u001a\t\u0005\u0003K\n\u0019H\u0004\u0003\u0002h\u0005=\u0004cAA5}5\u0011\u00111\u000e\u0006\u0004\u0003[b\u0013A\u0002\u001fs_>$h(C\u0002\u0002ry\na\u0001\u0015:fI\u00164\u0017\u0002BA\t\u0003kR1!!\u001d?\u0011%\tI(\u0005I\u0001\u0002\u0004\tY(\u0001\u0006nCb\u0014En\\2l\u001bN\u00042aVA?\u0013\r\tyH\u0010\u0002\u0005\u0019>tw\rC\u0005\u0002\u0004F\u0001\n\u00111\u0001\u0002|\u0005Q!-\u001e4gKJ\u001c\u0016N_3\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\n*\"\u0011\u0011DAFW\t\ti\t\u0005\u0003\u0002\u0010\u0006eUBAAI\u0015\u0011\t\u0019*!&\u0002\u0013Ut7\r[3dW\u0016$'bAAL}\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0015\u0011\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002&*\"\u00111MAF\u0003a\u0019'/Z1uKB\u0013x\u000eZ;dKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003WSC!a\u001f\u0002\f\u0006A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0002!I,w-[:uKJ\u0004&o\u001c3vG\u0016\u0014HcA7\u00024\")\u0001\u000f\u0007a\u0001[\u0006qA/Z:u'\u0016tGm\u00144gg\u0016$HcA0\u0002:\"9\u00111X\rA\u0002\u0005\r\u0014AB9v_J,X\u000eK\u0004\u001a\u0003\u007f\u000by-!5\u0011\t\u0005\u0005\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006A\u0001O]8wS\u0012,'O\u0003\u0003\u0002J\u0006=\u0012A\u00029be\u0006l7/\u0003\u0003\u0002N\u0006\r'a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0003\u0002T\u0006]\u0017EAAk\u0003\tQ8.\t\u0002\u0002Z\u0006)1N]1gi\":\u0011$!8\u0002f\u0006\u001d\b\u0003BAp\u0003Cl!!a2\n\t\u0005\r\u0018q\u0019\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#!!;\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T0A\u0014uKN$8+\u001a8e\u0007>l\u0007O]3tg\u0016$W*Z:tC\u001e,w+\u001b;i\u0007J,\u0017\r^3US6,GcA0\u0002p\"9\u00111\u0018\u000eA\u0002\u0005\r\u0004f\u0002\u000e\u0002@\u0006=\u00171\u001f\u0017\u0005\u0003'\f9\u000eK\u0004\u001b\u0003;\f)/a:\u0002UQ,7\u000f^*f]\u0012tuN\\\"p[B\u0014Xm]:fI6+7o]1hK^KG\u000f[\"sK\u0006$X\rV5nKR\u0019q,a?\t\u000f\u0005m6\u00041\u0001\u0002d!:1$a0\u0002P\u0006}H\u0006BAj\u0003/DsaGAo\u0003K\f9/A\u0007tK:$\u0017I\u001c3WKJLg-\u001f\u000b\b?\n\u001d!\u0011\u0002B\u0006\u0011\u0015\u0001H\u00041\u0001n\u0011%\t)\u0002\bI\u0001\u0002\u0004\tI\u0002C\u0005\u0003\u000eq\u0001\n\u00111\u0001\u0002|\u0005IA/[7f_V$Xj]\u0001\u0018g\u0016tG-\u00118e-\u0016\u0014\u0018NZ=%I\u00164\u0017-\u001e7uII\nqc]3oI\u0006sGMV3sS\u001aLH\u0005Z3gCVdG\u000fJ\u001a\u0002-M,g\u000eZ!oIZ+'/\u001b4z)&lWm\u001d;b[B$Ra\u0018B\f\u00053AQ\u0001]\u0010A\u00025DqAa\u0007 \u0001\u0004\u0011i\"A\u0007uS6,7\u000f^1naRK\b/\u001a\t\u0005\u0005?\u0011I#\u0004\u0002\u0003\")!!1\u0005B\u0013\u0003\u0019\u0011XmY8sI*\u0019!qE(\u0002\r\r|W.\\8o\u0013\u0011\u0011YC!\t\u0003\u001bQKW.Z:uC6\u0004H+\u001f9f\u0003%!Xm\u001d;DY>\u001cX\rF\u0002`\u0005cAq!a/!\u0001\u0004\t\u0019\u0007K\u0004!\u0003\u007f\u000byM!\u000e-\t\u0005M\u0017q\u001b\u0015\bA\u0005u\u0017Q]At\u0003M!Xm\u001d;TK:$Gk\u001c)beRLG/[8o)\ry&Q\b\u0005\b\u0003w\u000b\u0003\u0019AA2Q\u001d\t\u0013qXAh\u0005\u0003bC!a5\u0002X\":\u0011%!8\u0002f\u0006\u001d\u0018a\u000e;fgR\u001cVM\u001c3U_B\u000b'\u000f^5uS>tw+\u001b;i\r>dGn\\<feNCW\u000f\u001e3po:\u001c\u0006n\\;mI:{G\u000fV5nK>,H\u000fF\u0002`\u0005\u0013Bq!a/#\u0001\u0004\t\u0019\u0007K\u0004#\u0003\u007f\u000byM!\u0014-\t\u0005M\u0017q\u001b\u0015\u0004E\u0005u\u0017\u0001\u000b;fgR\u001cVM\u001c3CK\u001a|'/Z!oI\u00063G/\u001a:QCJ$\u0018\u000e^5p]\u0016C\b/\u00198tS>tGcA0\u0003V!9\u00111X\u0012A\u0002\u0005\r\u0004fB\u0012\u0002@\u0006='\u0011\f\u0017\u0005\u0003'\f9\u000eK\u0004$\u0003;\f)/a:\u0002\u0013Q,7\u000f\u001e$mkNDGcA0\u0003b!9\u00111\u0018\u0013A\u0002\u0005\r\u0004f\u0002\u0013\u0002@\u0006='Q\r\u0017\u0005\u0003'\f9\u000eK\u0004%\u0003;\f)/a:\u0002QQ,7\u000f^\"m_N,w+\u001b;i5\u0016\u0014x\u000eV5nK>,HO\u0012:p[\u000e\u000bG\u000e\\3s)\"\u0014X-\u00193\u0015\u0007}\u0013i\u0007C\u0004\u0002<\u0016\u0002\r!a\u0019)\u000f\u0015\ny,a4\u0003r1\"\u00111[AlQ\u001d)\u0013Q\\As\u0003O\f\u0001\u0006^3ti\u000ecwn]3XSRD',\u001a:p)&lWm\\;u\rJ|WnU3oI\u0016\u0014H\u000b\u001b:fC\u0012$2a\u0018B=\u0011\u001d\tYL\na\u0001\u0003GBsAJA`\u0003\u001f\u0014i\b\f\u0003\u0002T\u0006]\u0007f\u0002\u0014\u0002^\u0006\u0015\u0018q\u001d")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private Consumer<byte[], byte[]> consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private Admin admin;
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(4));
        String x$2 = this.zkConnectOrNull();
        Some x$4 = new Some((Object)this.securityProtocol());
        Option<File> x$5 = this.trustStoreFile();
        Option<Properties> x$6 = this.serverSaslProperties();
        boolean x$7 = true;
        boolean x$8 = true;
        boolean x$9 = false;
        boolean x$10 = false;
        boolean x$11 = false;
        Map x$12 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int x$13 = 1;
        boolean x$14 = false;
        int x$15 = 1;
        short x$16 = 1;
        int x$17 = 0;
        boolean x$18 = false;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(numServers, x$2, true, x$7, (Option<SecurityProtocol>)x$4, x$5, x$6, x$8, x$9, x$10, x$11, (Map<Object, String>)x$12, x$13, x$14, x$15, x$16, x$17, x$18).map((Function1 & Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, overridingProps));
    }

    private Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(Consumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), TestUtils$.MODULE$.securityConfigs(Mode.CLIENT, this.securityProtocol(), this.trustStoreFile(), "adminClient", TestUtils$.MODULE$.SslCertificateCn(), this.clientSaslProperties(), TestSslUtils.DEFAULT_TLS_PROTOCOL_FOR_TESTS, (Option<Object>)None$.MODULE$)));
        String x$1 = this.bootstrapServers(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        String x$3 = "group";
        String x$4 = "earliest";
        boolean x$5 = true;
        boolean x$6 = false;
        int x$7 = 500;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        ByteArrayDeserializer x$10 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$3, x$4, x$5, x$6, x$7, SecurityProtocol.PLAINTEXT, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.consumer().close();
        this.producers().foreach((Function1 & Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        this.admin().close();
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(int lingerMs, int deliveryTimeoutMs, int batchSize, String compressionType, long maxBlockMs, long bufferSize) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$3 = this.securityProtocol();
        Option<File> x$4 = this.trustStoreFile();
        Option<Properties> x$5 = this.clientSaslProperties();
        int x$11 = -1;
        int x$12 = Integer.MAX_VALUE;
        int x$13 = 20000;
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, x$11, maxBlockMs, bufferSize, x$12, deliveryTimeoutMs, lingerMs, batchSize, compressionType, x$13, x$3, x$4, x$5, x$14, x$15, x$16);
        return this.registerProducer(producer);
    }

    public int createProducer$default$1() {
        return 0;
    }

    public int createProducer$default$2() {
        return 120000;
    }

    public int createProducer$default$3() {
        return 16384;
    }

    public String createProducer$default$4() {
        return "none";
    }

    public long createProducer$default$5() {
        return 60000L;
    }

    public long createProducer$default$6() {
        return 0x100000L;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendOffset(String quorum) {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 1, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 0");
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assertions.assertEquals((long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 1");
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 2");
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 3");
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable)x$5 -> producer.send(record0, (Callback)this.callback$2(callback$module, partition)));
            Assertions.assertEquals((long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords() + 4).toString());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendCompressedMessageWithCreateTime(String quorum) {
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, x$4, "gzip", x$5, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendNonCompressedMessageWithCreateTime(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 1, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            IndexedSeq futures = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerify$1(this, partition, producer, BoxesRunTime.unboxToInt((Object)i)));
            producer.close(Duration.ofMillis(timeoutMs));
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)BaseProducerSendTest.$anonfun$sendAndVerify$2(this, partition, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assertions.assertEquals((int)numRecords, (int)lastOffset);
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
                topicProps.setProperty("message.timestamp.type", "LogAppendTime");
            } else {
                topicProps.setProperty("message.timestamp.type", "CreateTime");
            }
            Admin x$1 = this.admin();
            String x$2 = this.topic();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Map x$7 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, 1, 2, (Map<Object, Seq<Object>>)x$7, topicProps);
            IndexedSeq recordAndFutures = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$1(this, partition, baseTimestamp, producer, callback$module, timestampType, startTime, BoxesRunTime.unboxToInt((Object)i)));
            producer.close(Duration.ofSeconds(20L));
            recordAndFutures.foreach((Function1 & Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$2(timestampType, startTime, x0$1);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset(), (String)new StringBuilder(47).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).append(" but only successfully sent ").append(this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset()).toString());
        }
        finally {
            producer.close();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClose(String quorum) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 1, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable)x$6 -> producer.send(record0));
            Future response0 = producer.send(record0);
            producer.close();
            Assertions.assertTrue((boolean)response0.isDone(), (String)"The last message should be acked before producer is shutdown");
            Assertions.assertEquals((long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset(), (String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).toString());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendToPartition(String quorum) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            int partition = 1;
            long now = System.currentTimeMillis();
            ((IterableOps)((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), Predef$.MODULE$.long2Long(now), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)))).map((Function1 & Serializable)x$7 -> (RecordMetadata)x$7.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()))).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendToPartition$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$8 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$4(this, partition, x$8);
                return BoxedUnit.UNIT;
            });
            this.consumer().assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
            ((IterableOnceOps)TestUtils$.MODULE$.consumeRecords(this.consumer(), this.kafka$api$BaseProducerSendTest$$numRecords(), 15000L).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$5(this, partition, now, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testSendToPartitionWithFollowerShutdownShouldNotTimeout(String quorum) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        int follower = 1;
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, follower}));
        try {
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 1, 3, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)replicas)}))), new Properties());
            int partition = 0;
            long now = System.currentTimeMillis();
            IndexedSeq futures = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), Predef$.MODULE$.long2Long(now), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))));
            this.killBroker(follower);
            ((IterableOnceOps)futures.zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()))).foreach((Function1 & Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$testSendToPartitionWithFollowerShutdownShouldNotTimeout$2(this, partition, x0$1);
                return BoxedUnit.UNIT;
            });
            this.consumer().assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
            ((IterableOnceOps)TestUtils$.MODULE$.consumeRecords(this.consumer(), this.kafka$api$BaseProducerSendTest$$numRecords(), 15000L).zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
                BaseProducerSendTest.$anonfun$testSendToPartitionWithFollowerShutdownShouldNotTimeout$3(this, partition, now, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            producer.close();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSendBeforeAndAfterPartitionExpansion(String quorum) {
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        String x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$5, 5000L, x$6);
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 1, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        int partition0 = 0;
        ((IterableOps)((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)))).map((Function1 & Serializable)x$9 -> (RecordMetadata)x$9.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()))).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$10 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$4(this, partition0, x$10);
            return BoxedUnit.UNIT;
        });
        int partition1 = 1;
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get());
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        this.admin().createPartitions(Collections.singletonMap(this.topic(), NewPartitions.increaseTo((int)2))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), 0, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), 1, 15000L);
        ((IterableOps)((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)))).map((Function1 & Serializable)x$11 -> (RecordMetadata)x$11.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()))).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$8(check$ifrefutable$3))).foreach((Function1 & Serializable)x$12 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$9(this, partition1, x$12);
            return BoxedUnit.UNIT;
        });
        ((IterableOps)((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)))).map((Function1 & Serializable)x$13 -> (RecordMetadata)x$13.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.kafka$api$BaseProducerSendTest$$numRecords()), 2 * this.kafka$api$BaseProducerSendTest$$numRecords()))).withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$12(check$ifrefutable$4))).foreach((Function1 & Serializable)x$14 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$13(this, partition0, x$14);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFlush(String quorum) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$18 -> {
                IndexedSeq responses = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)x$15 -> producer.send(record));
                Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testFlush$3(x$16))), (String)"No request is complete.");
                producer.flush();
                Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.isDone())), (String)"All requests are complete.");
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCloseWithZeroTimeoutFromCallerThread(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        int partition = 0;
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$21 -> {
            KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
            IndexedSeq responses = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)x$19 -> producer.send(record0));
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$3(x$20))), (String)"No request is complete.");
            producer.close(Duration.ZERO);
            responses.foreach((Function1 & Serializable)future -> {
                BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$4(future);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((int)0, (int)this.consumer().poll(Duration.ofMillis(50L)).count(), (String)"Fetch response should have no message returned.");
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCloseWithZeroTimeoutFromSenderThread(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), 1, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        int partition = 0;
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$1(this, record, BoxesRunTime.unboxToInt((Object)i)));
    }

    private final /* synthetic */ BaseProducerSendTest$callback$1$ callback$lzycompute$1(LazyRef callback$module$1, int partition$1) {
        synchronized (callback$module$1) {
            BaseProducerSendTest$callback$1$ baseProducerSendTest$callback$1$ = callback$module$1.initialized() ? (BaseProducerSendTest$callback$1$)callback$module$1.value() : (BaseProducerSendTest$callback$1$)callback$module$1.initialize((Object)new BaseProducerSendTest$callback$1$(this, partition$1));
            return baseProducerSendTest$callback$1$;
        }
    }

    private final BaseProducerSendTest$callback$1$ callback$2(LazyRef callback$module$1, int partition$1) {
        if (callback$module$1.initialized()) {
            return (BaseProducerSendTest$callback$1$)callback$module$1.value();
        }
        return this.callback$lzycompute$1(callback$module$1, partition$1);
    }

    public static final /* synthetic */ Future $anonfun$sendAndVerify$1(BaseProducerSendTest $this, int partition$2, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$2), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$sendAndVerify$2(BaseProducerSendTest $this, int partition$2, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)partition$2, (int)recordMetadata.partition());
        Assertions.assertEquals((long)offset, (long)recordMetadata.offset());
        return offset + 1;
    }

    private final /* synthetic */ BaseProducerSendTest$callback$3$ callback$lzycompute$2(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        synchronized (callback$module$2) {
            BaseProducerSendTest$callback$3$ baseProducerSendTest$callback$3$ = callback$module$2.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$2.value() : (BaseProducerSendTest$callback$3$)callback$module$2.initialize((Object)new BaseProducerSendTest$callback$3$(this, timestampType$1, baseTimestamp$1, startTime$1, partition$3));
            return baseProducerSendTest$callback$3$;
        }
    }

    private final BaseProducerSendTest$callback$3$ callback$4(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        if (callback$module$2.initialized()) {
            return (BaseProducerSendTest$callback$3$)callback$module$2.value();
        }
        return this.callback$lzycompute$2(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3);
    }

    public static final /* synthetic */ Tuple2 $anonfun$sendAndVerifyTimestamp$1(BaseProducerSendTest $this, int partition$3, long baseTimestamp$1, KafkaProducer producer$3, LazyRef callback$module$2, TimestampType timestampType$1, long startTime$1, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$3), Predef$.MODULE$.long2Long(baseTimestamp$1 + (long)i), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return new Tuple2((Object)record, (Object)producer$3.send(record, (Callback)$this.callback$4(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3)));
    }

    public static final /* synthetic */ void $anonfun$sendAndVerifyTimestamp$2(TimestampType timestampType$1, long startTime$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ProducerRecord record = (ProducerRecord)x0$1._1();
            RecordMetadata recordMetadata = (RecordMetadata)((Future)x0$1._2()).get();
            TimestampType timestampType = timestampType$1;
            TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assertions.assertTrue((recordMetadata.timestamp() >= startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                return;
            }
            Assertions.assertEquals((Long)record.timestamp(), (long)recordMetadata.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testSendToPartition$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$4(BaseProducerSendTest $this, int partition$4, Tuple2 x$8) {
        if (x$8 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$8._1();
            Assertions.assertEquals((long)x$8._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition$4, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$5(BaseProducerSendTest $this, int partition$4, long now$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord record = (ConsumerRecord)x0$1._1();
            int i = x0$1._2$mcI$sp();
            Assertions.assertEquals((Object)$this.topic(), (Object)record.topic());
            Assertions.assertEquals((int)partition$4, (int)record.partition());
            Assertions.assertEquals((long)i, (long)record.offset());
            Assertions.assertNull((Object)record.key());
            Assertions.assertEquals((Object)new StringBuilder(5).append("value").append(i + 1).toString(), (Object)new String((byte[])record.value()));
            Assertions.assertEquals((long)now$1, (long)record.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendToPartitionWithFollowerShutdownShouldNotTimeout$2(BaseProducerSendTest $this, int partition$5, Tuple2 x0$1) {
        if (x0$1 != null) {
            Future future = (Future)x0$1._1();
            int offset = x0$1._2$mcI$sp();
            RecordMetadata recordMetadata = (RecordMetadata)future.get(30L, TimeUnit.SECONDS);
            Assertions.assertEquals((long)offset, (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition$5, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendToPartitionWithFollowerShutdownShouldNotTimeout$3(BaseProducerSendTest $this, int partition$5, long now$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            ConsumerRecord record = (ConsumerRecord)x0$2._1();
            int i = x0$2._2$mcI$sp();
            Assertions.assertEquals((Object)$this.topic(), (Object)record.topic());
            Assertions.assertEquals((int)partition$5, (int)record.partition());
            Assertions.assertEquals((long)i, (long)record.offset());
            Assertions.assertNull((Object)record.key());
            Assertions.assertEquals((Object)new StringBuilder(5).append("value").append(i + 1).toString(), (Object)new String((byte[])record.value()));
            Assertions.assertEquals((long)now$2, (long)record.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$4(BaseProducerSendTest $this, int partition0$1, Tuple2 x$10) {
        if (x$10 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$10._1();
            Assertions.assertEquals((long)x$10._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition0$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$8(Tuple2 check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$9(BaseProducerSendTest $this, int partition1$1, Tuple2 x$12) {
        if (x$12 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$12._1();
            Assertions.assertEquals((long)x$12._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition1$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$12(Tuple2 check$ifrefutable$4) {
        return check$ifrefutable$4 != null;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$13(BaseProducerSendTest $this, int partition0$1, Tuple2 x$14) {
        if (x$14 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$14._1();
            Assertions.assertEquals((long)x$14._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition0$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFlush$3(Future x$16) {
        return !x$16.isDone();
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromCallerThread$3(Future x$20) {
        return !x$20.isDone();
    }

    public static final /* synthetic */ void $anonfun$testCloseWithZeroTimeoutFromCallerThread$4(Future future) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get());
        Assertions.assertEquals(KafkaException.class, e.getCause().getClass());
    }

    public static final /* synthetic */ Future $anonfun$testCloseWithZeroTimeoutFromSenderThread$2(BaseProducerSendTest $this, KafkaProducer producer$10, ProducerRecord record$2, int i) {
        public class Kafka_api_BaseProducerSendTest$CloseCallback$1
        implements Callback {
            private final KafkaProducer<byte[], byte[]> producer;
            private final boolean sendRecords;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final ProducerRecord record$2;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (this.sendRecords) {
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable)x$22 -> Kafka_api_BaseProducerSendTest$CloseCallback$1.$anonfun$onCompletion$1(this, BoxesRunTime.unboxToInt((Object)x$22)));
                }
                this.producer.close(Duration.ZERO);
                this.producer.close();
            }

            public static final /* synthetic */ Future $anonfun$onCompletion$1(Kafka_api_BaseProducerSendTest$CloseCallback$1 $this, int x$22) {
                return $this.producer.send($this.record$2);
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_api_BaseProducerSendTest$CloseCallback$1(KafkaProducer<byte[], byte[]> producer, boolean sendRecords) {
                void var4_4;
                this.producer = producer;
                this.sendRecords = sendRecords;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = var4_4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onCompletion$1$adapted(kafka.api.BaseProducerSendTest$CloseCallback$1 java.lang.Object )}, serializedLambda);
            }
        }
        return producer$10.send(record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1($this, producer$10, i == 0, record$2));
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromSenderThread$3(Future x$23) {
        return !x$23.isDone();
    }

    public static final /* synthetic */ Seq $anonfun$testCloseWithZeroTimeoutFromSenderThread$1(BaseProducerSendTest $this, ProducerRecord record$2, int i2) {
        Seq<ConsumerRecord<byte[], byte[]>> seq;
        try (KafkaProducer<byte[], byte[]> producer = $this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, $this.createProducer$default$3(), $this.createProducer$default$4(), $this.createProducer$default$5(), $this.createProducer$default$6());){
            IndexedSeq responses = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$2($this, producer, record$2, BoxesRunTime.unboxToInt((Object)i)));
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$3(x$23))), (String)"No request is complete.");
            producer.flush();
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)x$24.isDone())), (String)"All requests are complete.");
            seq = TestUtils$.MODULE$.pollUntilAtLeastNumRecords($this.consumer(), $this.kafka$api$BaseProducerSendTest$$numRecords(), 15000L);
        }
        return seq;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

