/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import kafka.server.MetadataCache;
import kafka.server.MetadataCacheTest$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-x!B\r\u001b\u0011\u0003yb!B\u0011\u001b\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003\"B\u0016\u0002\t\u0003a\u0003\"\u0002\u001e\u0002\t\u0003a\u0003\"B\u001e\u0002\t\u0003ad\u0001B\u0011\u001b\u0001ECQ!\u000b\u0004\u0005\u0002ICq\u0001\u0016\u0004C\u0002\u0013\u0005Q\u000b\u0003\u0004Z\r\u0001\u0006IA\u0016\u0005\u00065\u001a!\ta\u0017\u0005\u0006e\u001a!\ta\u001d\u0005\u0006q\u001a!\t!\u001f\u0005\u0006}\u001a!\ta \u0005\b\u0003\u00131A\u0011BA\u0006\u0011\u001d\t\u0019I\u0002C\u0001\u0003\u000bCq!a$\u0007\t\u0003\t\t\nC\u0004\u0002\u001c\u001a!\t!!(\t\u000f\u0005\u001df\u0001\"\u0001\u0002*\"9\u00111\u0017\u0004\u0005\u0002\u0005U\u0006bBAa\r\u0011\u0005\u00111\u0019\u0005\b\u0003'4A\u0011AAb\u0011\u001d\t9N\u0002C\u0001\u0003\u0007Dq!a7\u0007\t\u0003\t\u0019\rC\u0004\u0002`\u001a!\t!!9\u0002#5+G/\u00193bi\u0006\u001c\u0015m\u00195f)\u0016\u001cHO\u0003\u0002\u001c9\u000511/\u001a:wKJT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001!\t\u0001\u0013!D\u0001\u001b\u0005EiU\r^1eCR\f7)Y2iKR+7\u000f^\n\u0003\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001 \u0003=Q8nQ1dQ\u0016\u0004&o\u001c<jI\u0016\u0014H#A\u0017\u0011\u00079*t'D\u00010\u0015\t\u0001\u0014'\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003eM\nA!\u001e;jY*\tA'\u0001\u0003kCZ\f\u0017B\u0001\u001c0\u0005\u0019\u0019FO]3b[B\u0011\u0001\u0005O\u0005\u0003si\u0011Q\"T3uC\u0012\fG/Y\"bG\",\u0017!D2bG\",\u0007K]8wS\u0012,'/A\u0006va\u0012\fG/Z\"bG\",GcA\u001fA\u0005B\u0011AEP\u0005\u0003\u007f\u0015\u0012A!\u00168ji\")\u0011)\u0002a\u0001o\u0005)1-Y2iK\")1)\u0002a\u0001\t\u00069!/Z9vKN$\bCA#P\u001b\u00051%BA$I\u0003!\u0011X-];fgR\u001c(BA%K\u0003\u0019\u0019w.\\7p]*\u0011Qd\u0013\u0006\u0003\u00196\u000ba!\u00199bG\",'\"\u0001(\u0002\u0007=\u0014x-\u0003\u0002Q\r\n)R\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$8C\u0001\u0004$)\u0005\u0019\u0006C\u0001\u0011\u0007\u0003-\u0011'o\\6fe\u0016\u0003xn\u00195\u0016\u0003Y\u0003\"\u0001J,\n\u0005a+#\u0001\u0002'p]\u001e\fAB\u0019:pW\u0016\u0014X\t]8dQ\u0002\n\u0011eZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1O_:,\u00050[:uS:<Gk\u001c9jGN$\"!\u0010/\t\u000b\u0005S\u0001\u0019A\u001c)\t)q&n\u001b\t\u0003?\"l\u0011\u0001\u0019\u0006\u0003C\n\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003G\u0012\fa\u0001]1sC6\u001c(BA3g\u0003\u001dQW\u000f]5uKJT!aZ'\u0002\u000b),h.\u001b;\n\u0005%\u0004'\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&\u00017\"\u0003iB#A\u00038\u0011\u0005=\u0004X\"\u00012\n\u0005E\u0014'!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\u0003{QDQ!Q\u0006A\u0002]BCa\u00030km2\nA\u000e\u000b\u0002\f]\u0006Ys-\u001a;U_BL7-T3uC\u0012\fG/\u0019)beRLG/[8o\u0019\u0016\fG-\u001a:O_R\fe/Y5mC\ndW\r\u0006\u0002>u\")\u0011\t\u0004a\u0001o!\"AB\u00186}Y\u0005a\u0007F\u0001\u0007o\u0003U:W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8MSN$XM\\3s\u001d>$\u0018I^1jY\u0006\u0014G.Z(o\u0019\u0016\fG-\u001a:\u0015\u0007u\n\t\u0001C\u0003B\u001b\u0001\u0007q\u0007K\u0003\u000e=*\f)\u0001L\u0001mQ\tia.\u0001\u001dwKJLg-\u001f+pa&\u001cW*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8MK\u0006$WM](s\u000b:$\u0007o\\5oi:{G/\u0011<bS2\f'\r\\3\u0015\u001fu\ni!a\u0004\u0002\u001a\u0005U\u0013QMA5\u0003sBQ!\u0011\bA\u0002]Bq!!\u0005\u000f\u0001\u0004\t\u0019\"A\u000bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\"s_.,'/\u00133\u0011\u0007\u0011\n)\"C\u0002\u0002\u0018\u0015\u00121!\u00138u\u0011\u001d\tYB\u0004a\u0001\u0003;\tqA\u0019:pW\u0016\u00148\u000f\u0005\u0004\u0002 \u0005\u0015\u0012\u0011F\u0007\u0003\u0003CQ1!a\t&\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\t\tCA\u0002TKF\u0004B!a\u000b\u0002P9!\u0011QFA%\u001d\u0011\ty#!\u0012\u000f\t\u0005E\u00121\t\b\u0005\u0003g\t\tE\u0004\u0003\u00026\u0005}b\u0002BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005mb$\u0001\u0004=e>|GOP\u0005\u0002\u001d&\u0011A*T\u0005\u0003;-K!!\u0013&\n\u0007\u0005\u001d\u0003*A\u0004nKN\u001c\u0018mZ3\n\t\u0005-\u0013QJ\u0001\u001a+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\t\u0006$\u0018MC\u0002\u0002H!KA!!\u0015\u0002T\t!R\u000b\u001d3bi\u0016lU\r^1eCR\f'I]8lKJTA!a\u0013\u0002N!9\u0011q\u000b\bA\u0002\u0005e\u0013\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}\u0003*A\u0004oKR<xN]6\n\t\u0005\r\u0014Q\f\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\u0003Or\u0001\u0019AA\n\u0003\u0019aW-\u00193fe\"9\u00111\u000e\bA\u0002\u00055\u0014!D3ya\u0016\u001cG/\u001a3FeJ|'\u000f\u0005\u0003\u0002p\u0005UTBAA9\u0015\r\t\u0019\bS\u0001\taJ|Go\\2pY&!\u0011qOA9\u0005\u0019)%O]8sg\"9\u00111\u0010\bA\u0002\u0005u\u0014!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u0019&\u001cH/\u001a8feN\u00042\u0001JA@\u0013\r\t\t)\n\u0002\b\u0005>|G.Z1o\u0003\r:W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018MU3qY&\u001c\u0017MT8u\u0003Z\f\u0017\u000e\\1cY\u0016$2!PAD\u0011\u0015\tu\u00021\u00018Q\u0015yaL[AFY\u0005a\u0007FA\bo\u0003}9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018-S:s\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0004{\u0005M\u0005\"B!\u0011\u0001\u00049\u0004&\u0002\t_U\u0006]E&\u00017)\u0005Aq\u0017\u0001M4fiR{\u0007/[2NKR\fG-\u0019;b/&$\bNT8o'V\u0004\bo\u001c:uK\u0012\u001cVmY;sSRL\bK]8u_\u000e|G\u000eF\u0002>\u0003?CQ!Q\tA\u0002]BS!\u00050k\u0003Gc\u0013\u0001\u001c\u0015\u0003#9\fafZ3u\u00032Lg/\u001a\"s_.,'o]*i_VdGMT8u\u0005\u0016lU\u000f^1uK\u0012\u0014\u00150\u00169eCR,7)Y2iKR\u0019Q(a+\t\u000b\u0005\u0013\u0002\u0019A\u001c)\u000bIq&.a,-\u00031D#A\u00058\u0002SQ,7\u000f^$fi\u000ecWo\u001d;fe6+G/\u00193bi\u0006<\u0016\u000e\u001e5PM\u001ad\u0017N\\3SKBd\u0017nY1t)\ri\u0014q\u0017\u0005\u0006\u0003N\u0001\ra\u000e\u0015\u0006'yS\u00171\u0018\u0017\u0003\u0003{\u000b\u0013a\u000b\u0015\u0003'9\f!\u0003^3ti&\u001b(I]8lKJ4UM\\2fIR\tQ\bK\u0002\u0015\u0003\u000f\u0004B!!3\u0002P6\u0011\u00111\u001a\u0006\u0004\u0003\u001b$\u0017aA1qS&!\u0011\u0011[Af\u0005\u0011!Vm\u001d;\u0002GQ,7\u000f^$fi\u0006c\u0017N^3Ce>\\WM]:XSRD'I]8lKJ4UM\\2fI\"\u001aQ#a2\u0002AQ,7\u000f^%t\u0005J|7.\u001a:J]\u000e{g\u000e\u001e:pY2,Gm\u00155vi\u0012|wO\u001c\u0015\u0004-\u0005\u001d\u0017A\u0006;fgR<U\r\u001e'jm\u0016\u0014%o\\6fe\u0016\u0003xn\u00195)\u0007]\t9-\u0001\u000buKN$x)\u001a;QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u0004{\u0005\r\b\"B!\u0019\u0001\u00049\u0004&\u0002\r_U\u0006\u001dH&\u00017)\u0005aq\u0007")
public class MetadataCacheTest {
    private final long brokerEpoch;

    public static void updateCache(MetadataCache cache, UpdateMetadataRequest request) {
        MetadataCacheTest$.MODULE$.updateCache(cache, request);
    }

    public static Stream<MetadataCache> cacheProvider() {
        return MetadataCacheTest$.MODULE$.cacheProvider();
    }

    public static Stream<MetadataCache> zkCacheProvider() {
        return MetadataCacheTest$.MODULE$.zkCacheProvider();
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataNonExistingTopics(MetadataCache cache) {
        String topic = "topic";
        Assertions.assertTrue((boolean)cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4()).isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadata(MetadataCache cache) {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4))), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3))), (List)Nil$.MODULE$)));
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), topicIds).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        new .colon.colon((Object)SecurityProtocol.PLAINTEXT, (List)new .colon.colon((Object)SecurityProtocol.SSL, (List)Nil$.MODULE$)).foreach(arg_0 -> MetadataCacheTest.$anonfun$getTopicMetadata$2$adapted(cache, topicIds, (Seq)partitionStates, topic0, topic1, arg_0));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionLeaderNotAvailable(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader(MetadataCache cache) {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        .colon.colon broker0Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value()), (List)Nil$.MODULE$));
        .colon.colon broker1Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)Nil$.MODULE$);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker0Endpoints).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)broker1Endpoints).asJava()), (List)Nil$.MODULE$));
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(MetadataCache cache, int metadataCacheBrokerId, Seq<UpdateMetadataRequestData.UpdateMetadataBroker> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0))).setZkVersion(zkVersion).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(0))), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        boolean x$4 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$1, listenerName, x$4, errorUnavailableListeners);
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)expectedError.code(), (short)partitionMetadata.errorCode());
        Assertions.assertFalse((boolean)partitionMetadata.isrNodes().isEmpty());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataReplicaNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataIsrNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.isrNodes()).asScala().toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.replicaNodes()).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadataWithError.isrNodes()).asScala().toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataWithNonSupportedSecurityProtocol(MetadataCache cache) {
        String topic = "topic";
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadata.size());
        Assertions.assertEquals((int)1, (int)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size());
        Assertions.assertEquals((int)-1, (int)((MetadataResponseData.MetadataResponsePartition)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().get(0)).leaderId());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache(MetadataCache cache) {
        String topic = "topic";
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topic, cache);
        Iterable aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3), topic, cache);
        Assertions.assertEquals((Object)initialBrokerIds.toSet(), (Object)((IterableOnceOps)aliveBrokersFromCache.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id))).toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"zkCacheProvider"})
    public void testGetClusterMetadataWithOfflineReplicas(MetadataCache cache) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("r").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava()), (List)Nil$.MODULE$));
        int controllerEpoch = 1;
        int leader = 1;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        java.util.List<Integer> offline = Arrays.asList(Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(topicPartition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas).setOfflineReplicas(offline), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Node expectedNode0 = new Node(0, "foo", 9092, "r");
        Node expectedNode1 = new Node(1, "", -1);
        Cluster cluster = cache.getClusterMetadata("clusterId", listenerName);
        Assertions.assertEquals((Object)expectedNode0, (Object)cluster.nodeById(0));
        Assertions.assertNull((Object)cluster.nodeById(1));
        Assertions.assertEquals((Object)expectedNode1, (Object)cluster.leaderFor(topicPartition));
        PartitionInfo partitionInfo = cluster.partition(topicPartition);
        Assertions.assertEquals((Object)expectedNode1, (Object)partitionInfo.leader());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.inSyncReplicas())));
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.offlineReplicas())));
    }

    @Test
    public void testIsBrokerFenced() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setFenced((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(0));
    }

    @Test
    public void testGetAliveBrokersWithBrokerFenced() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        String listenerName = "listener";
        RegisterBrokerRecord.BrokerEndpointCollection endpoints = new RegisterBrokerRecord.BrokerEndpointCollection();
        endpoints.add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setName(listenerName).setHost("foo").setPort(123).setSecurityProtocol((short)0));
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false).setEndPoints(endpoints));
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setFenced(false).setEndPoints(endpoints));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(1).setFenced((byte)1));
        MetadataImage metadataImage = delta.apply(MetadataProvenance.EMPTY);
        metadataCache.setImage(metadataImage);
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(1));
        scala.collection.immutable.Set aliveBrokers = ((IterableOnceOps)metadataCache.getAliveBrokers().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id))).toSet();
        metadataImage.cluster().brokers().forEach((brokerId, registration) -> {
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!registration.fenced() ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)aliveBrokers.contains((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId)))));
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)aliveBrokers.contains((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId)))), (Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.getAliveBrokerNode(Predef$.MODULE$.Integer2int(brokerId), new ListenerName(listenerName)).isDefined()));
        });
    }

    @Test
    public void testIsBrokerInControlledShutdown() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setInControlledShutdown(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerShuttingDown(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setInControlledShutdown((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerShuttingDown(0));
    }

    @Test
    public void testGetLiveBrokerEpoch() {
        int kRaftMetadataCache_brokerId = 0;
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(kRaftMetadataCache_brokerId);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false));
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(101L).setFenced(true));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertEquals((long)100L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(0).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(1).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void testGetPartitionInfo(MetadataCache cache) {
        String topic = "topic";
        int partitionIndex = 0;
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0));
        int zkVersion = 3;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(4));
        java.util.List<Integer> offlineReplicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(partitionIndex).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas).setOfflineReplicas(offlineReplicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        int controllerId = 2;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava(), Collections.emptyMap(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)cache.getPartitionInfo(topic, partitionIndex).get();
        Assertions.assertEquals((Object)topic, (Object)partitionState.topicName());
        Assertions.assertEquals((int)partitionIndex, (int)partitionState.partitionIndex());
        if (cache instanceof ZkMetadataCache) {
            Assertions.assertEquals((int)controllerEpoch, (int)partitionState.controllerEpoch());
        } else {
            Assertions.assertEquals((int)-1, (int)partitionState.controllerEpoch());
        }
        Assertions.assertEquals((int)leader, (int)partitionState.leader());
        Assertions.assertEquals((int)leaderEpoch, (int)partitionState.leaderEpoch());
        Assertions.assertEquals(isr, (Object)partitionState.isr());
        Assertions.assertEquals((int)zkVersion, (int)partitionState.zkVersion());
        Assertions.assertEquals(replicas, (Object)partitionState.replicas());
        if (cache instanceof ZkMetadataCache) {
            Assertions.assertEquals(offlineReplicas, (Object)partitionState.offlineReplicas());
            return;
        }
    }

    private static final Seq endpoints$2(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getTopicMetadata$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava(MetadataCacheTest.endpoints$2(brokerId)).asJava()).setRack("rack1");
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3(String topic$2, UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        return !(string != null ? !string.equals(topic$2) : topic$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$6(int partitionId$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$3) {
        return x$3.partitionIndex() == partitionId$1;
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$5(Seq topicPartitionStates$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)x0$1._1();
            int partitionId = x0$1._2$mcI$sp();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
            Assertions.assertEquals((int)partitionId, (int)partitionMetadata.partitionIndex());
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)topicPartitionStates$1.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$6(partitionId, x$3))).getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(45).append("Unable to find partition state for partition ").append(partitionId).toString()));
            Assertions.assertEquals((int)partitionState.leader(), (int)partitionMetadata.leaderId());
            Assertions.assertEquals((int)partitionState.leaderEpoch(), (int)partitionMetadata.leaderEpoch());
            Assertions.assertEquals((Object)partitionState.isr(), (Object)partitionMetadata.isrNodes());
            Assertions.assertEquals((Object)partitionState.replicas(), (Object)partitionMetadata.replicaNodes());
            return;
        }
        throw new MatchError(null);
    }

    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, HashMap topicIds$1, Seq partitionStates$1) {
        Seq topicMetadatas = cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, cache$1.getTopicMetadata$default$3(), cache$1.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        Assertions.assertEquals((Object)topic, (Object)topicMetadata.name());
        Assertions.assertEquals(topicIds$1.get(topic), (Object)topicMetadata.topicId());
        Seq topicPartitionStates = (Seq)partitionStates$1.filter((Function1 & Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$3(topic, ps)));
        Buffer partitionMetadatas = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitions()).asScala().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partitionIndex()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)topicPartitionStates.size(), (int)partitionMetadatas.size(), (String)new StringBuilder(37).append("Unexpected partition count for topic ").append(topic).toString());
        ((IterableOnceOps)partitionMetadatas.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$5(topicPartitionStates, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$2(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, topicIds$1, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, topicIds$1, partitionStates$1);
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava());
    }

    private final void updateCache$1(Seq brokerIds, String topic$3, MetadataCache cache$2) {
        Seq brokers = (Seq)brokerIds.map((Function1 & Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(BoxesRunTime.unboxToInt((Object)brokerId)));
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Integer> replicas = Arrays.asList(Predef$.MODULE$.int2Integer(0));
        java.util.List<Integer> isr = Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1));
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic$3).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache$2, updateMetadataRequest);
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
    }

    public static final /* synthetic */ Object $anonfun$getTopicMetadata$2$adapted(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        MetadataCacheTest.$anonfun$getTopicMetadata$2(cache$1, topicIds$1, partitionStates$1, topic0$1, topic1$1, securityProtocol);
        return BoxedUnit.UNIT;
    }
}

