/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import kafka.api.DelegationTokenEndToEndAuthorizationTest;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001B\u0010!\u0001\u0015BQA\u000b\u0001\u0005\u0002-BQ!\f\u0001\u0005\u00029BQ\u0001\u0010\u0001\u0005\u0002uBQa\u0013\u0001\u0005\u00029BQ\u0001\u0014\u0001\u0005\u0002uBQ!\u0014\u0001\u0005\u00029BQA\u0014\u0001\u0005B=Cq\u0001\u0017\u0001C\u0002\u0013%\u0011\f\u0003\u0004c\u0001\u0001\u0006IA\u0017\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019i\u0007\u0001)A\u0005K\"9a\u000e\u0001b\u0001\n\u0013I\u0006BB8\u0001A\u0003%!\fC\u0004q\u0001\t\u0007I\u0011\u00023\t\rE\u0004\u0001\u0015!\u0003f\u0011\u001d\u0011\bA1A\u0005\neCaa\u001d\u0001!\u0002\u0013Q\u0006b\u0002;\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007k\u0002\u0001\u000b\u0011B3\t\u000fY\u0004!\u0019!C\u00053\"1q\u000f\u0001Q\u0001\niCq\u0001\u001f\u0001C\u0002\u0013%A\r\u0003\u0004z\u0001\u0001\u0006I!\u001a\u0005\u0006u\u0002!\te\u001f\u0005\u0007\u0003\u0003\u0001A\u0011I>\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003k\u0002A\u0011AA<\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007\u0013\u0011\u0007R3mK\u001e\fG/[8o)>\\WM\\#oIR{WI\u001c3BkRDwN]5{CRLwN\\,ji\"|uO\\3s)\u0016\u001cHO\u0003\u0002\"E\u0005\u0019\u0011\r]5\u000b\u0003\r\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001MA\u0011q\u0005K\u0007\u0002A%\u0011\u0011\u0006\t\u0002)\t\u0016dWmZ1uS>tGk\\6f]\u0016sG\rV8F]\u0012\fU\u000f\u001e5pe&T\u0018\r^5p]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"a\n\u0001\u0002\u001d\u0005\u001bG\u000eV8lK:\u001c%/Z1uKV\tq\u0006\u0005\u00021u5\t\u0011G\u0003\u00023g\u0005\u0019\u0011m\u00197\u000b\u0005Q*\u0014AB2p[6|gN\u0003\u0002$m)\u0011q\u0007O\u0001\u0007CB\f7\r[3\u000b\u0003e\n1a\u001c:h\u0013\tY\u0014G\u0001\u0006BG2\u0014\u0015N\u001c3j]\u001e\fa\u0002V8lK:\u001c%/Z1uK\u0006\u001bG.F\u0001?!\ryd\tS\u0007\u0002\u0001*\u0011\u0011IQ\u0001\nS6lW\u000f^1cY\u0016T!a\u0011#\u0002\u0015\r|G\u000e\\3di&|gNC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9\u0005IA\u0002TKR\u0004\"\u0001M%\n\u0005)\u000b$AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uef\f\u0001#Q2m)>\\WM\u001c#fg\u000e\u0014\u0018NY3\u0002!Q{7.\u001a8EKN\u001c'/\u001b2f\u0003\u000ed\u0017!F!dYR{7.\u001a8Pi\",'\u000fR3tGJL'-Z\u0001\u001dGJ,\u0017\r^3EK2,w-\u0019;j_:$vn[3o\u001fB$\u0018n\u001c8t)\u0005\u0001\u0006CA)W\u001b\u0005\u0011&BA*U\u0003\u0015\tG-\\5o\u0015\t)V'A\u0004dY&,g\u000e^:\n\u0005]\u0013&\u0001H\"sK\u0006$X\rR3mK\u001e\fG/[8o)>\\WM\\(qi&|gn]\u0001\u0018i>\\WM\u001c*fcV,7\u000f^3s!JLgnY5qC2,\u0012A\u0017\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000bA!Y;uQ*\u0011qlM\u0001\tg\u0016\u001cWO]5us&\u0011\u0011\r\u0018\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003a!xn[3o%\u0016\fX/Z:uKJ\u0004&/\u001b8dSB\fG\u000eI\u0001\u0017i>\\WM\u001c*fcV,7\u000f^3s!\u0006\u001c8o^8sIV\tQ\r\u0005\u0002gW6\tqM\u0003\u0002iS\u0006!A.\u00198h\u0015\u0005Q\u0017\u0001\u00026bm\u0006L!\u0001\\4\u0003\rM#(/\u001b8h\u0003]!xn[3o%\u0016\fX/Z:uKJ\u0004\u0016m]:x_J$\u0007%\u0001\u000bpi\",'o\u00117jK:$\bK]5oG&\u0004\u0018\r\\\u0001\u0016_RDWM]\"mS\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197!\u0003MyG\u000f[3s\u00072LWM\u001c;QCN\u001cxo\u001c:e\u0003QyG\u000f[3s\u00072LWM\u001c;QCN\u001cxo\u001c:eA\u0005ir\u000e\u001e5fe\u000ec\u0017.\u001a8u%\u0016\fX/Z:uKJ\u0004&/\u001b8dSB\fG.\u0001\u0010pi\",'o\u00117jK:$(+Z9vKN$XM\u001d)sS:\u001c\u0017\u000e]1mA\u0005ar\u000e\u001e5fe\u000ec\u0017.\u001a8u%\u0016\fX/Z:uKJ\u0004\u0016m]:x_J$\u0017!H8uQ\u0016\u00148\t\\5f]R\u0014V-];fgR,'\u000fU1tg^|'\u000f\u001a\u0011\u00025\u0011,7o\u0019:jE\u0016$vn[3o\r\u0006LG\u000e\u0015:j]\u000eL\u0007/\u00197\u00027\u0011,7o\u0019:jE\u0016$vn[3o\r\u0006LG\u000e\u0015:j]\u000eL\u0007/\u00197!\u0003e!Wm]2sS\n,Gk\\6f]\u001a\u000b\u0017\u000e\u001c)bgN<xN\u001d3\u00025\u0011,7o\u0019:jE\u0016$vn[3o\r\u0006LG\u000eU1tg^|'\u000f\u001a\u0011\u0002E\r|gNZ5hkJ,7+Z2ve&$\u00180\u00114uKJ\u001cVM\u001d<feN\u001cF/\u0019:u)\u0005a\bCA?\u007f\u001b\u0005!\u0015BA@E\u0005\u0011)f.\u001b;\u0002]\r\u0014X-\u0019;f\u0003\u0012$\u0017\u000e^5p]\u0006d7I]3eK:$\u0018.\u00197t\u0003\u001a$XM]*feZ,'o]*uCJ$X\rZ\u0001\fCN\u001cXM\u001d;U_.,g\u000eF\u0002}\u0003\u000fAq!!\u0003\u001b\u0001\u0004\tY!A\u0003u_.,g\u000e\u0005\u0003\u0002\u000e\u0005UQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0015\u0011,G.Z4bi&|gNC\u0002\u0002\nyKA!a\u0006\u0002\u0010\tyA)\u001a7fO\u0006$\u0018n\u001c8U_.,g.A\u0010de\u0016\fG/\u001a+pW\u0016t'+Z9vKN$XM]!e[&t7\t\\5f]R$\"!!\b\u0011\u0007E\u000by\"C\u0002\u0002\"I\u0013Q!\u00113nS:\f\u0001\u0005^3ti\u000e\u0013X-\u0019;f)>\\WM\u001c$pe>#\b.\u001a:Vg\u0016\u0014h)Y5mgR\u0019A0a\n\t\u000f\u0005%B\u00041\u0001\u0002,\u00051\u0011/^8sk6\u0004B!!\f\u0002<9!\u0011qFA\u001c!\r\t\t\u0004R\u0007\u0003\u0003gQ1!!\u000e%\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\b#\u0002\rA\u0013X\rZ3g\u0013\ra\u0017Q\b\u0006\u0004\u0003s!\u0005f\u0002\u000f\u0002B\u0005e\u00131\f\t\u0005\u0003\u0007\n)&\u0004\u0002\u0002F)!\u0011qIA%\u0003!\u0001(o\u001c<jI\u0016\u0014(\u0002BA&\u0003\u001b\na\u0001]1sC6\u001c(\u0002BA(\u0003#\nqA[;qSR,'OC\u0002\u0002Ta\nQA[;oSRLA!a\u0016\u0002F\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!!\u0018\u0002b\u0005\u0012\u0011qL\u0001\u0006WJ\fg\r^\u0011\u0003\u0003G\n!A_6)\u000fq\t9'a\u001c\u0002rA!\u0011\u0011NA6\u001b\t\tI%\u0003\u0003\u0002n\u0005%#!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\t\u0019(\u0001\r|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|au\f!\u0005^3ti\u0012+7o\u0019:jE\u0016$vn[3o\r>\u0014x\n\u001e5feV\u001bXM\u001d$bS2\u001cHc\u0001?\u0002z!9\u0011\u0011F\u000fA\u0002\u0005-\u0002fB\u000f\u0002B\u0005e\u0013Q\u0010\u0017\u0005\u0003;\n\t\u0007K\u0004\u001e\u0003O\ny'!\u001d\u0002GQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3U_.,gNR8s\u001fRDWM]+tKJ\u0004\u0016m]:fgR\u0019A0!\"\t\u000f\u0005%b\u00041\u0001\u0002,!:a$!\u0011\u0002Z\u0005%E\u0006BA/\u0003CBsAHA4\u0003_\n\t\b")
public class DelegationTokenEndToEndAuthorizationWithOwnerTest
extends DelegationTokenEndToEndAuthorizationTest {
    private final KafkaPrincipal tokenRequesterPrincipal = new KafkaPrincipal("User", JaasTestUtils$.MODULE$.KafkaScramUser2());
    private final String tokenRequesterPassword = JaasTestUtils$.MODULE$.KafkaScramPassword2();
    private final KafkaPrincipal otherClientPrincipal = new KafkaPrincipal("User", "other-client-principal");
    private final String otherClientPassword;
    private final KafkaPrincipal otherClientRequesterPrincipal = new KafkaPrincipal("User", "other-client-requester-principal");
    private final String otherClientRequesterPassword;
    private final KafkaPrincipal describeTokenFailPrincipal = new KafkaPrincipal("User", "describe-token-fail-principal");
    private final String describeTokenFailPassword;

    public AclBinding AclTokenCreate() {
        return new AclBinding(new ResourcePattern(ResourceType.USER, this.clientPrincipal().toString(), PatternType.LITERAL), new AccessControlEntry(this.tokenRequesterPrincipal().toString(), "*", AclOperation.CREATE_TOKENS, AclPermissionType.ALLOW));
    }

    public Set<AccessControlEntry> TokenCreateAcl() {
        return (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.tokenRequesterPrincipal().toString(), "*", AclOperation.CREATE_TOKENS, AclPermissionType.ALLOW)}));
    }

    public AclBinding AclTokenDescribe() {
        return new AclBinding(new ResourcePattern(ResourceType.USER, this.clientPrincipal().toString(), PatternType.LITERAL), new AccessControlEntry(this.tokenRequesterPrincipal().toString(), "*", AclOperation.DESCRIBE_TOKENS, AclPermissionType.ALLOW));
    }

    public Set<AccessControlEntry> TokenDescribeAcl() {
        return (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.tokenRequesterPrincipal().toString(), "*", AclOperation.DESCRIBE_TOKENS, AclPermissionType.ALLOW)}));
    }

    public AclBinding AclTokenOtherDescribe() {
        return new AclBinding(new ResourcePattern(ResourceType.USER, this.otherClientPrincipal().toString(), PatternType.LITERAL), new AccessControlEntry(this.otherClientRequesterPrincipal().toString(), "*", AclOperation.DESCRIBE_TOKENS, AclPermissionType.ALLOW));
    }

    @Override
    public CreateDelegationTokenOptions createDelegationTokenOptions() {
        return new CreateDelegationTokenOptions().owner(this.clientPrincipal());
    }

    private KafkaPrincipal tokenRequesterPrincipal() {
        return this.tokenRequesterPrincipal;
    }

    private String tokenRequesterPassword() {
        return this.tokenRequesterPassword;
    }

    private KafkaPrincipal otherClientPrincipal() {
        return this.otherClientPrincipal;
    }

    private String otherClientPassword() {
        return this.otherClientPassword;
    }

    private KafkaPrincipal otherClientRequesterPrincipal() {
        return this.otherClientRequesterPrincipal;
    }

    private String otherClientRequesterPassword() {
        return this.otherClientRequesterPassword;
    }

    private KafkaPrincipal describeTokenFailPrincipal() {
        return this.describeTokenFailPrincipal;
    }

    private String describeTokenFailPassword() {
        return this.describeTokenFailPassword;
    }

    @Override
    public void configureSecurityAfterServersStart() {
        Admin superuserAdminClient = this.createPrivilegedAdminClient();
        superuserAdminClient.createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.AclTokenOtherDescribe(), (List)new .colon.colon((Object)this.AclTokenCreate(), (List)new .colon.colon((Object)this.AclTokenDescribe(), (List)Nil$.MODULE$)))).asJava()).values();
        this.brokers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)this.TokenCreateAcl().$plus$plus(this.TokenDescribeAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new ResourcePattern(ResourceType.USER, this.clientPrincipal().toString(), PatternType.LITERAL), AccessControlEntryFilter.ANY);
            return BoxedUnit.UNIT;
        });
        superuserAdminClient.close();
        super.configureSecurityAfterServersStart();
    }

    @Override
    public void createAdditionalCredentialsAfterServersStarted() {
        this.createScramCredentialsViaPrivilegedAdminClient(this.tokenRequesterPrincipal().getName(), this.tokenRequesterPassword());
        this.createScramCredentialsViaPrivilegedAdminClient(this.otherClientPrincipal().getName(), this.otherClientPassword());
        this.createScramCredentialsViaPrivilegedAdminClient(this.otherClientRequesterPrincipal().getName(), this.otherClientRequesterPassword());
        this.createScramCredentialsViaPrivilegedAdminClient(this.describeTokenFailPrincipal().getName(), this.describeTokenFailPassword());
    }

    @Override
    public void assertToken(DelegationToken token) {
        this.assertTokenOwner(this.clientPrincipal(), token);
        this.assertTokenRequester(this.tokenRequesterPrincipal(), token);
    }

    @Override
    public Admin createTokenRequesterAdminClient() {
        return this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.tokenRequesterPrincipal().getName(), this.tokenRequesterPassword());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testCreateTokenForOtherUserFails(String quorum) {
        Assertions.assertTrue((boolean)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.createDelegationTokens((Function0<CreateDelegationTokenOptions>)(Function0 & Serializable)() -> new CreateDelegationTokenOptions().owner(this.otherClientPrincipal()), false))).getMessage().contains("Delegation Token authorization failed"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDescribeTokenForOtherUserFails(String quorum) {
        Admin describeTokenFailAdminClient = this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.describeTokenFailPrincipal().getName(), this.describeTokenFailPassword());
        Admin otherClientAdminClient = this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.otherClientPrincipal().getName(), this.otherClientPassword());
        try {
            otherClientAdminClient.createDelegationToken().delegationToken().get();
            Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)describeTokenFailAdminClient.describeDelegationToken(new DescribeDelegationTokenOptions().owners(Collections.singletonList(this.otherClientPrincipal()))).delegationTokens().get()).asScala().isEmpty());
        }
        finally {
            describeTokenFailAdminClient.close();
            otherClientAdminClient.close();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testDescribeTokenForOtherUserPasses(String quorum) {
        try (Admin adminClient = this.createTokenRequesterAdminClient();){
            Buffer tokens = CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)adminClient.describeDelegationToken(new DescribeDelegationTokenOptions().owners(Collections.singletonList(this.clientPrincipal()))).delegationTokens().get()).asScala();
            Assertions.assertTrue((boolean)tokens.nonEmpty());
            tokens.foreach((Function1 & Serializable)t -> {
                DelegationTokenEndToEndAuthorizationWithOwnerTest.$anonfun$testDescribeTokenForOtherUserPasses$1(this, t);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$testDescribeTokenForOtherUserPasses$1(DelegationTokenEndToEndAuthorizationWithOwnerTest $this, DelegationToken t) {
        Assertions.assertTrue((boolean)t.tokenInfo().owner().equals((Object)$this.clientPrincipal()));
        Assertions.assertTrue((boolean)t.tokenInfo().tokenRequester().equals((Object)$this.tokenRequesterPrincipal()));
    }

    public DelegationTokenEndToEndAuthorizationWithOwnerTest() {
        this.otherClientPassword = "other-client-password";
        this.otherClientRequesterPassword = "other-client-requester-password";
        this.describeTokenFailPassword = "describe-token-fail-password";
    }
}

