/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.LogCleaner;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.utils.Implicits;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t}d!\u0002\u001a4\u0003\u0003A\u0004\"B \u0001\t\u0003\u0001\u0005\"C\"\u0001\u0001\u0004\u0005\r\u0011\"\u0001E\u0011%A\u0005\u00011AA\u0002\u0013\u0005\u0011\nC\u0005P\u0001\u0001\u0007\t\u0011)Q\u0005\u000b\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006B\u0002.\u0001A\u0003%!\u000bC\u0004\\\u0001\t\u0007I\u0011\u0002/\t\r!\u0004\u0001\u0015!\u0003^\u0011\u001dI\u0007A1A\u0005\n)DaA\u001c\u0001!\u0002\u0013Y\u0007bB8\u0001\u0005\u0004%I\u0001\u001d\u0005\u0007i\u0002\u0001\u000b\u0011B9\t\u000fU\u0004!\u0019!C\u0005m\"1!\u0010\u0001Q\u0001\n]Dqa\u001f\u0001C\u0002\u0013%!\u000e\u0003\u0004}\u0001\u0001\u0006Ia\u001b\u0005\b{\u0002\u0011\r\u0011\"\u0003k\u0011\u0019q\b\u0001)A\u0005W\"9q\u0010\u0001b\u0001\n\u00131\bbBA\u0001\u0001\u0001\u0006Ia\u001e\u0005\b\u0003\u0007\u0001a\u0011AA\u0003\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!a\u000f\u0001\t\u0003\ti\u0004C\u0005\u0002f\u0001\t\n\u0011\"\u0001\u0002h!I\u0011Q\u0010\u0001\u0012\u0002\u0013\u0005\u0011q\u0010\u0005\n\u0003\u0007\u0003\u0011\u0013!C\u0001\u0003\u000bC\u0011\"!#\u0001#\u0003%\t!a#\t\u0013\u0005=\u0005!%A\u0005\u0002\u0005-\u0005\"CAI\u0001E\u0005I\u0011AAC\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+C\u0011\"a8\u0001#\u0003%\t!a \t\u0013\u0005\u0005\b!%A\u0005\u0002\u0005-\u0005\"CAr\u0001E\u0005I\u0011AAC\u0011%\t)\u000fAI\u0001\n\u0003\tY\tC\u0005\u0002h\u0002\t\n\u0011\"\u0001\u0002\u0006\"I\u0011\u0011\u001e\u0001\u0012\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003W\u0004\u0011\u0013!C\u0001\u0003\u0017C\u0011\"!<\u0001#\u0003%\t!!\"\t\u0013\u0005=\b!%A\u0005\u0002\u0005E\b\"CA{\u0001E\u0005I\u0011AA4\u0011!\t9\u0010\u0001a\u0001\n\u0013Q\u0007\"CA}\u0001\u0001\u0007I\u0011BA~\u0011\u001d\ty\u0010\u0001Q!\n-DaA!\u0001\u0001\t\u0003Q\u0007b\u0002B\u0002\u0001\u0011\u0005\u00111\u0005\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011%\u0011y\u0005AI\u0001\n\u0003\tY\tC\u0005\u0003R\u0001\t\n\u0011\"\u0001\u0003T!9!q\u000b\u0001\u0005\u0002\te#!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\u001b6\u0003\rawn\u001a\u0006\u0002m\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0011\t\u0003\u0005\u0002i\u0011aM\u0001\bG2,\u0017M\\3s+\u0005)\u0005C\u0001\"G\u0013\t95G\u0001\u0006M_\u001e\u001cE.Z1oKJ\f1b\u00197fC:,'o\u0018\u0013fcR\u0011!*\u0014\t\u0003u-K!\u0001T\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\u000e\t\t\u00111\u0001F\u0003\rAH%M\u0001\tG2,\u0017M\\3sA\u00051An\\4ESJ,\u0012A\u0015\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000b!![8\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0016\u0002\u0005\r&dW-A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\t1|wm]\u000b\u0002;B\u0019alY3\u000e\u0003}S!\u0001Y1\u0002\u000f5,H/\u00192mK*\u0011!mO\u0001\u000bG>dG.Z2uS>t\u0017B\u00013`\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0003\u0005\u001aL!aZ\u001a\u0003\u0015Us\u0017NZ5fI2{w-A\u0003m_\u001e\u001c\b%A\u000beK\u001a\fW\u000f\u001c;NCblUm]:bO\u0016\u001c\u0016N_3\u0016\u0003-\u0004\"A\u000f7\n\u00055\\$aA%oi\u00061B-\u001a4bk2$X*\u0019=NKN\u001c\u0018mZ3TSj,\u0007%A\u000feK\u001a\fW\u000f\u001c;NS:\u001cE.Z1oC\ndW\rR5sif\u0014\u0016\r^5p+\u0005\t\bC\u0001\u001es\u0013\t\u00198HA\u0003GY>\fG/\u0001\u0010eK\u001a\fW\u000f\u001c;NS:\u001cE.Z1oC\ndW\rR5sif\u0014\u0016\r^5pA\u0005IB-\u001a4bk2$X*\u001b8D_6\u0004\u0018m\u0019;j_:d\u0015mZ'T+\u00059\bC\u0001\u001ey\u0013\tI8H\u0001\u0003M_:<\u0017A\u00073fM\u0006,H\u000e^'j]\u000e{W\u000e]1di&|g\u000eT1h\u001bN\u0003\u0013A\u00053fM\u0006,H\u000e\u001e#fY\u0016$X\rR3mCf\f1\u0003Z3gCVdG\u000fR3mKR,G)\u001a7bs\u0002\n!\u0003Z3gCVdGoU3h[\u0016tGoU5{K\u0006\u0019B-\u001a4bk2$8+Z4nK:$8+\u001b>fA\u0005IB-\u001a4bk2$X*\u0019=D_6\u0004\u0018m\u0019;j_:d\u0015mZ't\u0003i!WMZ1vYRl\u0015\r_\"p[B\f7\r^5p]2\u000bw-T:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003;i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0005kRLGN\u0003\u0003\u0002\u0012\u0005M\u0011AB:feZ,'OC\u00027\u0003+QA!a\u0006\u0002\u001a\u00051\u0011\r]1dQ\u0016T!!a\u0007\u0002\u0007=\u0014x-\u0003\u0003\u0002 \u0005-!\u0001C'pG.$\u0016.\\3\u0002\u0011Q,\u0017M\u001d3po:$\u0012A\u0013\u0015\u0004-\u0005\u001d\u0002\u0003BA\u0015\u0003oi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0004CBL'\u0002BA\u0019\u0003g\tqA[;qSR,'O\u0003\u0003\u00026\u0005e\u0011!\u00026v]&$\u0018\u0002BA\u001d\u0003W\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002'1|wmQ8oM&<\u0007K]8qKJ$\u0018.Z:\u0015!\u0005}\u0012\u0011JA'\u0003#\n)&!\u0017\u0002^\u0005\u0005\u0004\u0003BA!\u0003\u000bj!!a\u0011\u000b\u0007\u00055a+\u0003\u0003\u0002H\u0005\r#A\u0003)s_B,'\u000f^5fg\"I\u00111J\f\u0011\u0002\u0003\u0007\u0011qH\u0001\u0012aJ|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001c\bBBA(/\u0001\u00071.\u0001\bnCblUm]:bO\u0016\u001c\u0016N_3\t\u0011\u0005Ms\u0003%AA\u0002E\fa#\\5o\u00072,\u0017M\\1cY\u0016$\u0015N\u001d;z%\u0006$\u0018n\u001c\u0005\t\u0003/:\u0002\u0013!a\u0001o\u0006\u0011R.\u001b8D_6\u0004\u0018m\u0019;j_:d\u0015mZ't\u0011!\tYf\u0006I\u0001\u0002\u0004Y\u0017a\u00033fY\u0016$X\rR3mCfD\u0001\"a\u0018\u0018!\u0003\u0005\ra[\u0001\fg\u0016<W.\u001a8u'&TX\r\u0003\u0005\u0002d]\u0001\n\u00111\u0001x\u0003Ii\u0017\r_\"p[B\f7\r^5p]2\u000bw-T:\u0002;1|wmQ8oM&<\u0007K]8qKJ$\u0018.Z:%I\u00164\u0017-\u001e7uIE*\"!!\u001b+\t\u0005}\u00121N\u0016\u0003\u0003[\u0002B!a\u001c\u0002z5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n)(A\u0005v]\u000eDWmY6fI*\u0019\u0011qO\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002|\u0005E$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006iBn\\4D_:4\u0017n\u001a)s_B,'\u000f^5fg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0002*\u001a\u0011/a\u001b\u0002;1|wmQ8oM&<\u0007K]8qKJ$\u0018.Z:%I\u00164\u0017-\u001e7uIQ*\"!a\"+\u0007]\fY'A\u000fm_\u001e\u001cuN\u001c4jOB\u0013x\u000e]3si&,7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tiIK\u0002l\u0003W\nQ\u0004\\8h\u0007>tg-[4Qe>\u0004XM\u001d;jKN$C-\u001a4bk2$HEN\u0001\u001eY><7i\u001c8gS\u001e\u0004&o\u001c9feRLWm\u001d\u0013eK\u001a\fW\u000f\u001c;%o\u0005YQ.Y6f\u00072,\u0017M\\3s)])\u0015qSA`\u0003\u0003\f)-!3\u0002L\u00065\u0017qZAi\u0003'\fi\u000eC\u0004\u0002\u001az\u0001\r!a'\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0002\u001e\u00065\u00161\u0017\b\u0005\u0003?\u000bIK\u0004\u0003\u0002\"\u0006\u001dVBAAR\u0015\r\t)kN\u0001\u0007yI|w\u000e\u001e \n\u0003qJ1!a+<\u0003\u001d\u0001\u0018mY6bO\u0016LA!a,\u00022\nA\u0011\n^3sC\ndWMC\u0002\u0002,n\u0002B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000b\u0019\"\u0001\u0004d_6lwN\\\u0005\u0005\u0003{\u000b9L\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0011\u0005Mc\u0004%AA\u0002ED\u0001\"a1\u001f!\u0003\u0005\ra[\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001c\b\u0002CAd=A\u0005\t\u0019A<\u0002\u0013\t\f7m[8gM6\u001b\b\u0002CA(=A\u0005\t\u0019A6\t\u0011\u0005]c\u0004%AA\u0002]D\u0001\"a\u0017\u001f!\u0003\u0005\ra\u001b\u0005\t\u0003?r\u0002\u0013!a\u0001W\"A\u00111\r\u0010\u0011\u0002\u0003\u0007q\u000fC\u0005\u0002Vz\u0001\n\u00111\u0001\u0002X\u0006\u00192\r\\3b]\u0016\u0014\u0018j\u001c\"vM\u001a,'oU5{KB!!(!7l\u0013\r\tYn\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005-c\u0004%AA\u0002\u0005}\u0012!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$HEM\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIQ\nQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$S'A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%o\u0005)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012B\u0014!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$H%O\u0001\u0017[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00132aU\u0011\u00111\u001f\u0016\u0005\u0003/\fY'\u0001\fnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00192\u0003\r\u0019GO]\u0001\bGR\u0014x\fJ3r)\rQ\u0015Q \u0005\b\u001d*\n\t\u00111\u0001l\u0003\u0011\u0019GO\u001d\u0011\u0002\u000f\r|WO\u001c;fe\u0006Q\u0011N\\2D_VtG/\u001a:\u0002\u0013]\u0014\u0018\u000e^3EkB\u001cHC\u0004B\u0005\u0005O\u0011YCa\f\u00032\t\u0005#Q\t\t\u0007\u0005\u0017\u0011iA!\u0005\u000e\u0003\u0005L1Aa\u0004b\u0005\r\u0019V-\u001d\t\bu\tM1Na\u0006x\u0013\r\u0011)b\u000f\u0002\u0007)V\u0004H.Z\u001a\u0011\t\te!\u0011\u0005\b\u0005\u00057\u0011i\u0002E\u0002\u0002\"nJ1Aa\b<\u0003\u0019\u0001&/\u001a3fM&!!1\u0005B\u0013\u0005\u0019\u0019FO]5oO*\u0019!qD\u001e\t\r\t%b\u00061\u0001l\u0003\u001dqW/\\&fsNDaA!\f/\u0001\u0004Y\u0017a\u00028v[\u0012+\bo\u001d\u0005\u0006i9\u0002\r!\u001a\u0005\b\u0005gq\u0003\u0019\u0001B\u001b\u0003\u0015\u0019w\u000eZ3d!\u0011\u00119D!\u0010\u000e\u0005\te\"\u0002\u0002B\u001e\u0003o\u000baA]3d_J$\u0017\u0002\u0002B \u0005s\u0011qbQ8naJ,7o]5p]RK\b/\u001a\u0005\t\u0005\u0007r\u0003\u0013!a\u0001W\u0006A1\u000f^1si.+\u0017\u0010C\u0005\u0003H9\u0002\n\u00111\u0001\u0003J\u0005QQ.Y4jGZ\u000bG.^3\u0011\u0007i\u0012Y%C\u0002\u0003Nm\u0012AAQ=uK\u0006\u0019rO]5uK\u0012+\bo\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005\u0019rO]5uK\u0012+\bo\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!Q\u000b\u0016\u0005\u0005\u0013\nY'A\u000ede\u0016\fG/\u001a'be\u001e,7+\u001b8hY\u0016lUm]:bO\u0016\u001cV\r\u001e\u000b\t\u00057\u00129Ga\u001b\u0003pA9!H!\u0018\u0003\u0018\t\u0005\u0014b\u0001B0w\t1A+\u001e9mKJ\u0002BAa\u000e\u0003d%!!Q\rB\u001d\u00055iU-\\8ssJ+7m\u001c:eg\"1!\u0011N\u0019A\u0002-\f1a[3z\u0011\u001d\u0011i'\ra\u0001\u0005\u0013\nA#\\3tg\u0006<WMR8s[\u0006$h+\u001a:tS>t\u0007b\u0002B\u001ac\u0001\u0007!Q\u0007\u0015\b\u0001\tM$\u0011\u0010B>!\u0011\tIC!\u001e\n\t\t]\u00141\u0006\u0002\u0004)\u0006<\u0017!\u0002<bYV,\u0017E\u0001B?\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8")
public abstract class AbstractLogCleanerIntegrationTest {
    private LogCleaner cleaner;
    private final File logDir = TestUtils.tempDirectory(null, null);
    private final ListBuffer<UnifiedLog> logs = ListBuffer$.MODULE$.empty();
    private final int defaultMaxMessageSize;
    private final float defaultMinCleanableDirtyRatio;
    private final long defaultMinCompactionLagMS;
    private final int defaultDeleteDelay;
    private final int defaultSegmentSize;
    private final long defaultMaxCompactionLagMs = Long.MAX_VALUE;
    private int ctr = 0;

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(LogCleaner x$1) {
        this.cleaner = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    private ListBuffer<UnifiedLog> logs() {
        return this.logs;
    }

    private int defaultMaxMessageSize() {
        return this.defaultMaxMessageSize;
    }

    private float defaultMinCleanableDirtyRatio() {
        return this.defaultMinCleanableDirtyRatio;
    }

    private long defaultMinCompactionLagMS() {
        return this.defaultMinCompactionLagMS;
    }

    private int defaultDeleteDelay() {
        return this.defaultDeleteDelay;
    }

    private int defaultSegmentSize() {
        return this.defaultSegmentSize;
    }

    private long defaultMaxCompactionLagMs() {
        return this.defaultMaxCompactionLagMs;
    }

    public abstract MockTime time();

    @AfterEach
    public void teardown() {
        if (this.cleaner() != null) {
            this.cleaner().shutdown();
        }
        this.time().scheduler.shutdown();
        this.logs().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    public Properties logConfigProperties(Properties propertyOverrides, int maxMessageSize, float minCleanableDirtyRatio, long minCompactionLagMs, int deleteDelay, int segmentSize, long maxCompactionLagMs) {
        Properties props = new Properties();
        props.put("max.message.bytes", Predef$.MODULE$.int2Integer(maxMessageSize));
        props.put("segment.bytes", Predef$.MODULE$.int2Integer(segmentSize));
        props.put("segment.index.bytes", Predef$.MODULE$.int2Integer(102400));
        props.put("file.delete.delay.ms", Predef$.MODULE$.int2Integer(deleteDelay));
        props.put("cleanup.policy", "compact");
        props.put("min.cleanable.dirty.ratio", Predef$.MODULE$.float2Float(minCleanableDirtyRatio));
        props.put("min.compaction.lag.ms", Predef$.MODULE$.long2Long(minCompactionLagMs));
        props.put("max.compaction.lag.ms", Predef$.MODULE$.long2Long(maxCompactionLagMs));
        new Implicits.PropertiesOps(props).$plus$plus$eq(propertyOverrides);
        return props;
    }

    public Properties logConfigProperties$default$1() {
        return new Properties();
    }

    public float logConfigProperties$default$3() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public long logConfigProperties$default$4() {
        return this.defaultMinCompactionLagMS();
    }

    public int logConfigProperties$default$5() {
        return this.defaultDeleteDelay();
    }

    public int logConfigProperties$default$6() {
        return this.defaultSegmentSize();
    }

    public long logConfigProperties$default$7() {
        return this.defaultMaxCompactionLagMs();
    }

    public LogCleaner makeCleaner(Iterable<TopicPartition> partitions, float minCleanableDirtyRatio, int numThreads, long backoffMs, int maxMessageSize, long minCompactionLagMs, int deleteDelay, int segmentSize, long maxCompactionLagMs, Option<Object> cleanerIoBufferSize, Properties propertyOverrides) {
        Pool logMap = new Pool((Option)None$.MODULE$);
        partitions.foreach((Function1 & Serializable)partition -> {
            File dir = new File(this.logDir(), new StringBuilder(1).append(partition.topic()).append("-").append(partition.partition()).toString());
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            LogConfig logConfig = new LogConfig((Map)this.logConfigProperties(propertyOverrides, maxMessageSize, minCleanableDirtyRatio, minCompactionLagMs, deleteDelay, segmentSize, maxCompactionLagMs));
            MockScheduler x$5 = $this.time().scheduler;
            MockTime x$6 = this.time();
            BrokerTopicStats x$7 = new BrokerTopicStats(Optional.empty());
            ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
            int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
            None$ x$12 = None$.MODULE$;
            boolean x$14 = true;
            ConcurrentHashMap x$15 = new ConcurrentHashMap();
            boolean x$16 = false;
            LogOffsetsListener x$17 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
            UnifiedLog log = UnifiedLog$.MODULE$.apply(dir, logConfig, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, x$10, x$11, x$14, (Option)x$12, true, x$15, x$16, x$17);
            logMap.put(partition, (Object)log);
            return (ListBuffer)this.logs().$plus$eq((Object)log);
        });
        CleanerConfig cleanerConfig = new CleanerConfig(numThreads, 0x400000L, 0.9, BoxesRunTime.unboxToInt((Object)cleanerIoBufferSize.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> maxMessageSize / 2)), maxMessageSize, Double.MAX_VALUE, backoffMs, true);
        return new LogCleaner(cleanerConfig, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), logMap, new LogDirFailureChannel(1), (Time)this.time());
    }

    public float makeCleaner$default$2() {
        return this.defaultMinCleanableDirtyRatio();
    }

    public int makeCleaner$default$3() {
        return 1;
    }

    public long makeCleaner$default$4() {
        return 15000L;
    }

    public int makeCleaner$default$5() {
        return this.defaultMaxMessageSize();
    }

    public long makeCleaner$default$6() {
        return this.defaultMinCompactionLagMS();
    }

    public int makeCleaner$default$7() {
        return this.defaultDeleteDelay();
    }

    public int makeCleaner$default$8() {
        return this.defaultSegmentSize();
    }

    public long makeCleaner$default$9() {
        return this.defaultMaxCompactionLagMs();
    }

    public Option<Object> makeCleaner$default$10() {
        return None$.MODULE$;
    }

    public Properties makeCleaner$default$11() {
        return new Properties();
    }

    private int ctr() {
        return this.ctr;
    }

    private void ctr_$eq(int x$1) {
        this.ctr = x$1;
    }

    public int counter() {
        return this.ctr();
    }

    public void incCounter() {
        this.ctr_$eq(this.ctr() + 1);
    }

    public Seq<Tuple3<Object, String, Object>> writeDups(int numKeys, int numDups, UnifiedLog log, CompressionType codec, int startKey, byte magicValue) {
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$3 -> AbstractLogCleanerIntegrationTest.$anonfun$writeDups$1(this, startKey, numKeys, log, codec, magicValue, BoxesRunTime.unboxToInt((Object)x$3)));
    }

    public int writeDups$default$5() {
        return 0;
    }

    public byte writeDups$default$6() {
        return 2;
    }

    public Tuple2<String, MemoryRecords> createLargeSingleMessageSet(int key, byte messageFormatVersion, CompressionType codec) {
        String value = AbstractLogCleanerIntegrationTest.messageValue$1(128);
        byte[] x$1 = value.getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        long x$5 = -1L;
        MemoryRecords messageSet = TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec, x$5, messageFormatVersion);
        return new Tuple2((Object)value, (Object)messageSet);
    }

    public static final /* synthetic */ Tuple3 $anonfun$writeDups$2(AbstractLogCleanerIntegrationTest $this, UnifiedLog log$1, CompressionType codec$1, byte magicValue$1, int key) {
        String value = Integer.toString($this.counter());
        byte[] x$1 = value.getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        long x$5 = -1L;
        LogAppendInfo appendInfo = log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, x$5, magicValue$1), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5(), log$1.appendAsLeader$default$6());
        log$1.updateHighWatermark(log$1.logEndOffset());
        $this.incCounter();
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)appendInfo.firstOffset().get()).messageOffset));
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeDups$1(AbstractLogCleanerIntegrationTest $this, int startKey$1, int numKeys$1, UnifiedLog log$1, CompressionType codec$1, byte magicValue$1, int x$3) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable)key -> AbstractLogCleanerIntegrationTest.$anonfun$writeDups$2($this, log$1, codec$1, magicValue$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    private static final String messageValue$1(int length) {
        Random random = new Random(0);
        return new String((char[])random.alphanumeric().take(length).toArray((ClassTag)ClassTag$.MODULE$.Char()));
    }

    public AbstractLogCleanerIntegrationTest() {
        this.defaultMaxMessageSize = 128;
        this.defaultMinCleanableDirtyRatio = 0.0f;
        this.defaultMinCompactionLagMS = 0L;
        this.defaultDeleteDelay = 1000;
        this.defaultSegmentSize = 2048;
    }
}

