/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.log.LocalLog$;
import kafka.log.LogSegment;
import kafka.log.UnifiedLog;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLogTest$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.MetadataLogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r%a\u0001\u0002\"D\u0005!CQa\u0014\u0001\u0005\u0002AC\u0011b\u0015\u0001A\u0002\u0003\u0007I\u0011\u0001+\t\u0013u\u0003\u0001\u0019!a\u0001\n\u0003q\u0006\"\u00033\u0001\u0001\u0004\u0005\t\u0015)\u0003V\u0011\u001d)\u0007A1A\u0005\u0002\u0019Da\u0001\u001e\u0001!\u0002\u00139\u0007\"B;\u0001\t\u00031\bBBA\u0003\u0001\u0011\u0005a\u000f\u0003\u0004\u0002\u0010\u0001!\tA\u001e\u0005\u0007\u00033\u0001A\u0011\u0001<\t\r\u0005u\u0001\u0001\"\u0001w\u0011\u0019\t\t\u0003\u0001C\u0001m\"1\u0011Q\u0005\u0001\u0005\u0002YDa!!\u000b\u0001\t\u00031\bBBA\u0017\u0001\u0011\u0005a\u000f\u0003\u0004\u00022\u0001!\tA\u001e\u0005\u0007\u0003k\u0001A\u0011\u0001<\t\r\u0005e\u0002\u0001\"\u0001w\u0011\u0019\ti\u0004\u0001C\u0001m\"1\u0011\u0011\t\u0001\u0005\u0002YDa!!\u0012\u0001\t\u00031\bBBA%\u0001\u0011\u0005a\u000f\u0003\u0004\u0002N\u0001!\tA\u001e\u0005\u0007\u0003#\u0002A\u0011\u0001<\t\r\u0005U\u0003\u0001\"\u0001w\u0011\u0019\tI\u0006\u0001C\u0001m\"9\u0011Q\f\u0001\u0005\n\u0005}\u0003bBA3\u0001\u0011%\u0011q\r\u0005\u0007\u0003w\u0002A\u0011\u0001<\t\r\u0005}\u0004\u0001\"\u0001w\u0011\u0019\t\u0019\t\u0001C\u0001m\"1\u0011q\u0011\u0001\u0005\u0002YDa!a#\u0001\t\u00031\bBBAH\u0001\u0011\u0005a\u000fC\u0004\u0002\u0014\u0002!I!!&\t\r\u0005e\u0006\u0001\"\u0001w\u0011\u0019\ti\f\u0001C\u0001m\"1\u0011\u0011\u0019\u0001\u0005\u0002YDa!!2\u0001\t\u00031\bBBAe\u0001\u0011\u0005a\u000f\u0003\u0004\u0002N\u0002!\tA\u001e\u0005\u0007\u0003#\u0004A\u0011\u0001<\t\r\u0005U\u0007\u0001\"\u0001w\u0011\u0019\tI\u000e\u0001C\u0001m\"1\u0011Q\u001c\u0001\u0005\u0002YDa!!9\u0001\t\u00031\bBBAs\u0001\u0011\u0005a\u000f\u0003\u0004\u0002j\u0002!\tA^\u0004\b\u0003[\u001c\u0005\u0012AAx\r\u0019\u00115\t#\u0001\u0002r\"1qJ\rC\u0001\u0003g4a!!>3\u0001\u0005]\bBB(5\t\u0003\u0011y\u0002C\u0004\u00024R\"\tE!\n\t\u000f\tmB\u0007\"\u0011\u0003>!9!Q\n\u001b\u0005B\t=\u0003\"\u0003B0e\t\u0007I\u0011\u0001B1\u0011!\u0011IG\rQ\u0001\n\t\r\u0004b\u0002B6e\u0011\u0005!Q\u000e\u0005\n\u0005+\u0013\u0014\u0013!C\u0001\u0005/CqA!,3\t\u0003\u0011y\u000bC\u0005\u00038J\n\n\u0011\"\u0001\u0003\u0018\"9!\u0011\u0018\u001a\u0005\u0002\tm\u0006b\u0002B]e\u0011\u0005!Q\u001b\u0005\b\u0005S\u0014D\u0011\u0002Bv\u0005QY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\rV3ti*\u0011A)R\u0001\u0005e\u00064GOC\u0001G\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A%\u0011\u0005)kU\"A&\u000b\u00031\u000bQa]2bY\u0006L!AT&\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u000b\u0005\u0002S\u00015\t1)A\u0004uK6\u0004H)\u001b:\u0016\u0003U\u0003\"AV.\u000e\u0003]S!\u0001W-\u0002\u0005%|'\"\u0001.\u0002\t)\fg/Y\u0005\u00039^\u0013AAR5mK\u0006YA/Z7q\t&\u0014x\fJ3r)\ty&\r\u0005\u0002KA&\u0011\u0011m\u0013\u0002\u0005+:LG\u000fC\u0004d\u0007\u0005\u0005\t\u0019A+\u0002\u0007a$\u0013'\u0001\u0005uK6\u0004H)\u001b:!\u0003!iwnY6US6,W#A4\u0011\u0005!\u0014X\"A5\u000b\u0005)\\\u0017\u0001B;uS2T!\u0001\\7\u0002\rM,'O^3s\u0015\t1eN\u0003\u0002pa\u00061\u0011\r]1dQ\u0016T\u0011!]\u0001\u0004_J<\u0017BA:j\u0005!iunY6US6,\u0017!C7pG.$\u0016.\\3!\u0003\u0015\u0019X\r^+q)\u0005y\u0006FA\u0004y!\rI\u0018\u0011A\u0007\u0002u*\u00111\u0010`\u0001\u0004CBL'BA?\u007f\u0003\u001dQW\u000f]5uKJT!a 9\u0002\u000b),h.\u001b;\n\u0007\u0005\r!P\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004\u0011\u0005%\u0001cA=\u0002\f%\u0019\u0011Q\u0002>\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0003;fgR\u001cuN\u001c4jO\"\u001a\u0011\"a\u0005\u0011\u0007e\f)\"C\u0002\u0002\u0018i\u0014A\u0001V3ti\u0006QB/Z:u+:,\u0007\u0010]3di\u0016$\u0017\t\u001d9f]\u0012|eMZ:fi\"\u001a!\"a\u0005\u0002%Q,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e\u001e\u0015\u0004\u0017\u0005M\u0011a\b;fgR\u001c%/Z1uKNs\u0017\r]:i_R4%o\\7F]\u0012|eMZ:fi\"\u001aA\"a\u0005\u0002QQ,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e\u001e'bi\u0016\u0014H\u000b[1o\u0011&<\u0007nV1uKJl\u0017M]6)\u00075\t\u0019\"\u0001\u0011uKN$8I]3bi\u0016\u001cf.\u00199tQ>$X*^2i\u0019\u0006$XM]#q_\u000eD\u0007f\u0001\b\u0002\u0014\u00051C/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\u0005\u00164wN]3M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u0007=\t\u0019\"\u0001\u0011uKN$8I]3bi\u0016\u001cf.\u00199tQ>$H)\u001b<fe\u001eLgnZ#q_\u000eD\u0007f\u0001\t\u0002\u0014\u0005aB/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\u001f2$WM]#q_\u000eD\u0007fA\t\u0002\u0014\u0005\u0011C/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u/&$\b.T5tg&tw-\u00129pG\"D3AEA\n\u0003i!Xm\u001d;De\u0016\fG/Z#ySN$\u0018N\\4T]\u0006\u00048\u000f[8uQ\r\u0019\u00121C\u0001\fi\u0016\u001cH\u000fV8qS\u000eLE\rK\u0002\u0015\u0003'\tq\u0003^3tiJ+\u0017\rZ'jgNLgnZ*oCB\u001c\bn\u001c;)\u0007U\t\u0019\"A\u000fuKN$H)\u001a7fi\u0016tuN\\#ySN$XM\u001c;T]\u0006\u00048\u000f[8uQ\r1\u00121C\u0001\"i\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a$vY2LHk\u001c'bi\u0016\u001cHo\u00158baNDw\u000e\u001e\u0015\u0004/\u0005M\u0011a\t;fgR$&/\u001e8dCR,w+\u001b7m%\u0016lwN^3PY\u0012,'o\u00158baNDw\u000e\u001e\u0015\u00041\u0005M\u0011a\t;fgR\u001cF/\u0019:ukB<\u0016\u000e\u001e5J]Z\fG.\u001b3T]\u0006\u00048\u000f[8u'R\fG/\u001a\u0015\u00043\u0005M\u0011\u0001\f;fgR\u001cf.\u00199tQ>$H)\u001a7fi&|gnV5uQ&sg/\u00197jINs\u0017\r]:i_R\u001cF/\u0019;fQ\rQ\u00121C\u0001\u000f[\u0016$\u0018\rZ1uC2{w\rR5s)\r)\u0016\u0011\r\u0005\u0007\u0003GZ\u0002\u0019A+\u0002\r1|w\rR5s\u0003I9(/\u001b;f\u000b6\u0004H/_*oCB\u001c\bn\u001c;\u0015\u000b}\u000bI'!\u001c\t\r\u0005-D\u00041\u0001V\u0003-iW\r^1eCR\fG)\u001b:\t\u000f\u0005=D\u00041\u0001\u0002r\u0005Q1O\\1qg\"|G/\u00133\u0011\t\u0005M\u0014qO\u0007\u0003\u0003kR!\u0001R7\n\t\u0005e\u0014Q\u000f\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0003]!Xm\u001d;E_\u0016\u001ch\u000e\u001e+sk:\u001c\u0017\r^3Gk2d\u0017\u0010K\u0002\u001e\u0003'\t1\u0004^3ti\u000ecW-\u00198vaB\u000b'\u000f^5bYNs\u0017\r]:i_R\u001c\bf\u0001\u0010\u0002\u0014\u0005IB/Z:u\u00072,\u0017M\\;q\u001f2$WM]*oCB\u001c\bn\u001c;tQ\ry\u00121C\u0001&i\u0016\u001cHo\u0011:fCR,'+\u001a9mS\u000e\fG/\u001a3M_\u001e$&/\u001e8dCR,7OR;mYfD3\u0001IA\n\u0003A!Xm\u001d;NCb\u0014\u0015\r^2i'&TX\rK\u0002\"\u0003'\ta\u0004^3tiR\u0013XO\\2bi\u0016\u0014U\r\\8x\u0011&<\u0007nV1uKJl\u0017M]6)\u0007\t\n\u0019\"\u0001\bck&dGMR;mY\n\u000bGo\u00195\u0015\u0011\u0005]\u0015qUAY\u0003k\u0003B!!'\u0002$6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0004\u0003Ck\u0017AB2p[6|g.\u0003\u0003\u0002&\u0006m%!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0002*\u000e\u0002\r!a+\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\t\u0004\u0015\u00065\u0016bAAX\u0017\n\u0019\u0011J\u001c;\t\u000f\u0005M6\u00051\u0001\u0002,\u0006Q!/Z2pe\u0012\u001c\u0016N_3\t\u000f\u0005]6\u00051\u0001\u0002,\u0006\u0019R.\u0019=CCR\u001c\u0007nU5{K&s')\u001f;fg\u0006QC/Z:u-\u0006d\u0017\u000eZ1uK\u0016\u0003xn\u00195He\u0016\fG/\u001a:UQ\u0006tG*Y:u\u0017:|wO\\#q_\u000eD\u0007f\u0001\u0013\u0002\u0014\u0005aC/Z:u-\u0006d\u0017\u000eZ1uK\u0016\u0003xn\u00195MKN\u001cH\u000b[1o\u001f2$Wm\u001d;T]\u0006\u00048\u000f[8u\u000bB|7\r\u001b\u0015\u0004K\u0005M\u0011A\f;fgR4\u0016\r\\5eCR,wJ\u001a4tKRdUm]:UQ\u0006tw\n\u001c3fgR\u001cf.\u00199tQ>$xJ\u001a4tKRD3AJA\n\u00035\"Xm\u001d;WC2LG-\u0019;f\u001f\u001a47/\u001a;FcV\fG\u000eV8PY\u0012,7\u000f^*oCB\u001c\bn\u001c;PM\u001a\u001cX\r\u001e\u0015\u0004O\u0005M\u0011A\u0011;fgR4\u0016\r\\5eCR,WK\\6o_^tW\t]8dQ2+7o\u001d+iC:d\u0015m\u001d;L]><hn\u0012:fCR,'\u000f\u00165b]>cG-Z:u':\f\u0007o\u001d5pi\"\u001a\u0001&a\u0005\u0002QQ,7\u000f\u001e,bY&$\u0017\r^3Fa>\u001c\u0007\u000eT3tgRC\u0017M\u001c$jeN$X\t]8dQ&sGj\\4)\u0007%\n\u0019\"\u0001\u0013uKN$h+\u00197jI\u0006$Xm\u00144gg\u0016$xI]3biRC\u0017M\\#oI>3gm]3uQ\rQ\u00131C\u0001\u001ei\u0016\u001cHOV1mS\u0012\fG/Z(gMN,G\u000fT3tgRC\u0017M\u001c'F\u001f\"\u001a1&a\u0005\u0002?Q,7\u000f\u001e,bY&$\u0017\r^3WC2LG-\u00129pG\"\fe\u000eZ(gMN,G\u000fK\u0002-\u0003'\ta\u0005^3ti\u0006#g/\u00198dK2{wm\u0015;beR|eMZ:fi\u00063G/\u001a:DY\u0016\fg.\u001b8hQ\ri\u00131C\u0001\u0014i\u0016\u001cH\u000fR3mKR,7K\\1qg\"|Go\u001d\u0015\u0004]\u0005M\u0011A\u0006;fgR\u001cvN\u001a;SKR,g\u000e^5p]2KW.\u001b;)\u0007=\n\u0019\"\u0001\u0012uKN$8+Z4nK:$8\u000fT3tgRC\u0017M\u001c'bi\u0016\u001cHo\u00158baNDw\u000e\u001e\u0015\u0004a\u0005M\u0011\u0001F&bM.\fW*\u001a;bI\u0006$\u0018\rT8h)\u0016\u001cH\u000f\u0005\u0002SeM\u0011!'\u0013\u000b\u0003\u0003_\u0014aBQ=uK\u0006\u0013(/Y=TKJ$WmE\u00035\u0003s\u0014)\u0001\u0005\u0003\u0002|\n\u0005QBAA\u007f\u0015\r\ty0W\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u0004\u0005u(AB(cU\u0016\u001cG\u000f\u0005\u0004\u0003\b\t=!1C\u0007\u0003\u0005\u0013QAAa\u0003\u0003\u000e\u0005i1/\u001a:jC2L'0\u0019;j_:T1!!)l\u0013\u0011\u0011\tB!\u0003\u0003\u0017I+7m\u001c:e'\u0016\u0014H-\u001a\t\u0006\u0015\nU!\u0011D\u0005\u0004\u0005/Y%!B!se\u0006L\bc\u0001&\u0003\u001c%\u0019!QD&\u0003\t\tKH/\u001a\u000b\u0003\u0005C\u00012Aa\t5\u001b\u0005\u0011DCBAV\u0005O\u0011Y\u0003C\u0004\u0003*Y\u0002\rAa\u0005\u0002\t\u0011\fG/\u0019\u0005\b\u0005[1\u0004\u0019\u0001B\u0018\u0003I\u0019XM]5bY&T\u0018\r^5p]\u000e\u000b7\r[3\u0011\t\tE\"qG\u0007\u0003\u0005gQAA!\u000e\u0002 \u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0003:\tM\"\u0001G(cU\u0016\u001cGoU3sS\u0006d\u0017N_1uS>t7)Y2iK\u0006)qO]5uKR9qLa\u0010\u0003B\t\r\u0003b\u0002B\u0015o\u0001\u0007!1\u0003\u0005\b\u0005[9\u0004\u0019\u0001B\u0018\u0011\u001d\u0011)e\u000ea\u0001\u0005\u000f\n1a\\;u!\u0011\u0011\tD!\u0013\n\t\t-#1\u0007\u0002\t/JLG/\u00192mK\u0006!!/Z1e)\u0019\u0011\u0019B!\u0015\u0003\\!9!1\u000b\u001dA\u0002\tU\u0013!B5oaV$\b\u0003\u0002B\u0019\u0005/JAA!\u0017\u00034\tA!+Z1eC\ndW\rC\u0004\u0003^a\u0002\r!a+\u0002\tML'0Z\u0001\u0019\t\u00164\u0017-\u001e7u\u001b\u0016$\u0018\rZ1uC2{wmQ8oM&<WC\u0001B2!\r\u0011&QM\u0005\u0004\u0005O\u001a%!E'fi\u0006$\u0017\r^1M_\u001e\u001cuN\u001c4jO\u0006IB)\u001a4bk2$X*\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4!\u0003Y\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC2{w-\u00118e\t&\u0014H\u0003\u0003B8\u0005\u0017\u0013iI!%\u0011\u0013)\u0013\tH!\u001e\u0003\u0006\n\r\u0014b\u0001B:\u0017\n1A+\u001e9mKN\u0002BAa\u001e\u0003\u00026\u0011!\u0011\u0010\u0006\u0005\u0005w\u0012i(\u0001\u0003gS2,'b\u0001B@3\u0006\u0019a.[8\n\t\t\r%\u0011\u0010\u0002\u0005!\u0006$\b\u000eE\u0002S\u0005\u000fK1A!#D\u0005AY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\rC\u0003Tw\u0001\u0007Q\u000b\u0003\u0004\u0003\u0010n\u0002\raZ\u0001\u0005i&lW\rC\u0005\u0003\u0014n\u0002\n\u00111\u0001\u0003d\u0005\tR.\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4\u0002A\t,\u0018\u000e\u001c3NKR\fG-\u0019;b\u0019><\u0017I\u001c3ESJ$C-\u001a4bk2$HeM\u000b\u0003\u00053SCAa\u0019\u0003\u001c.\u0012!Q\u0014\t\u0005\u0005?\u0013I+\u0004\u0002\u0003\"*!!1\u0015BS\u0003%)hn\u00195fG.,GMC\u0002\u0003(.\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YK!)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\tck&dG-T3uC\u0012\fG/\u0019'pORA!Q\u0011BY\u0005g\u0013)\fC\u0003T{\u0001\u0007Q\u000b\u0003\u0004\u0003\u0010v\u0002\ra\u001a\u0005\n\u0005'k\u0004\u0013!a\u0001\u0005G\n!DY;jY\u0012lU\r^1eCR\fGj\\4%I\u00164\u0017-\u001e7uIM\na!\u00199qK:$G\u0003\u0003B_\u0005\u0007\u0014iM!5\u0011\t\u0005M$qX\u0005\u0005\u0005\u0003\f)HA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0005\u000b|\u0004\u0019\u0001Bd\u0003\rawn\u001a\t\u0005\u0003g\u0012I-\u0003\u0003\u0003L\u0006U$!\u0004*fa2L7-\u0019;fI2{w\rC\u0004\u0003P~\u0002\r!a+\u0002\u001f9,XNY3s\u001f\u001a\u0014VmY8sINDqAa5@\u0001\u0004\tY+A\u0003fa>\u001c\u0007\u000eF\u0003`\u0005/\u00149\u000fC\u0004\u0003Z\u0002\u0003\rAa7\u0002\u001dMt\u0017\r]:i_R<&/\u001b;feB!!Q\u001cBr\u001b\t\u0011yNC\u0002\u0003b6\f\u0001b\u001d8baNDw\u000e^\u0005\u0005\u0005K\u0014yNA\tSC^\u001cf.\u00199tQ>$xK]5uKJDqAa4A\u0001\u0004\tY+\u0001\nde\u0016\fG/\u001a'pO\u0012K'/Z2u_JLH#B+\u0003n\n=\bBBA2\u0003\u0002\u0007Q\u000bC\u0004\u0003r\u0006\u0003\rAa=\u0002\u00151|w\rR5s\u001d\u0006lW\r\u0005\u0003\u0003v\u000e\ra\u0002\u0002B|\u0005\u007f\u00042A!?L\u001b\t\u0011YPC\u0002\u0003~\u001e\u000ba\u0001\u0010:p_Rt\u0014bAB\u0001\u0017\u00061\u0001K]3eK\u001aLAa!\u0002\u0004\b\t11\u000b\u001e:j]\u001eT1a!\u0001L\u0001")
public final class KafkaMetadataLogTest {
    private File tempDir;
    private final MockTime mockTime = new MockTime();

    public static void append(RawSnapshotWriter snapshotWriter, int numberOfRecords) {
        KafkaMetadataLogTest$.MODULE$.append(snapshotWriter, numberOfRecords);
    }

    public static LogAppendInfo append(ReplicatedLog log, int numberOfRecords, int epoch) {
        return KafkaMetadataLogTest$.MODULE$.append(log, numberOfRecords, epoch);
    }

    public static MetadataLogConfig buildMetadataLog$default$3() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public static KafkaMetadataLog buildMetadataLog(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog(tempDir, time, metadataLogConfig);
    }

    public static MetadataLogConfig buildMetadataLogAndDir$default$3() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public static Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> buildMetadataLogAndDir(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(tempDir, time, metadataLogConfig);
    }

    public static MetadataLogConfig DefaultMetadataLogConfig() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        this.tempDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tempDir());
    }

    @Test
    public void testConfig() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), Arrays.asList("broker"));
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9093");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), BoxesRunTime.boxToInteger((int)2));
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMillisProp(), BoxesRunTime.boxToInteger((int)10240));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
            KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
        });
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp(), BoxesRunTime.boxToInteger((int)10240));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply((AbstractConfig)kafkaConfig, 0x800000, 0x800000);
        KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnexpectedAppendOffset() {
        void withRecords_records;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        SimpleRecord recordFoo = new SimpleRecord("foo".getBytes());
        int currentEpoch = 3;
        long initialOffset = log.endOffset().offset;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var6_6 = null;
        simpleRecordArray = null;
        log.appendAsLeader((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        Assertions.assertThrows(RuntimeException.class, () -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
            CompressionType withRecords_compressionType = CompressionType.NONE;
            Object var5_5 = null;
            simpleRecordArray = null;
            log.appendAsLeader((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        });
        Assertions.assertThrows(RuntimeException.class, () -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
            CompressionType withRecords_compressionType = CompressionType.NONE;
            Object var5_5 = null;
            simpleRecordArray = null;
            log.appendAsFollower((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        });
    }

    @Test
    public void testCreateSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var5_5 = null;
        Assertions.assertEquals((long)0L, (long)((RawSnapshotReader)log.readSnapshot(snapshotId).get()).sizeInBytes());
    }

    @Test
    public void testCreateSnapshotFromEndOffset() {
        int numberOfRecords = 10;
        int firstEpoch = 1;
        int secondEpoch = 3;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)(2 * numberOfRecords)));
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords - 1), firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch(1L, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords - 1), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), secondEpoch)).get()).close();
    }

    @Test
    public void testCreateSnapshotLaterThanHighWatermark() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), epoch)));
    }

    @Test
    public void testCreateSnapshotMuchLaterEpoch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, epoch + 1)));
    }

    @Test
    public void testCreateSnapshotBeforeLogStartOffset() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 4), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var5_5 = null;
        log.log().maybeIncrementLogStartOffset(snapshotId.offset() - 1L, LogStartOffsetIncrementReason.SegmentDeletion);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset() - 2L, snapshotId.epoch())));
    }

    @Test
    public void testCreateSnapshotDivergingEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotOlderEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var5_5 = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotWithMissingEpoch() {
        int firstBatchRecords = 5;
        int firstEpoch = 1;
        int missingEpoch = firstEpoch + 1;
        int secondBatchRecords = 5;
        int secondEpoch = missingEpoch + 1;
        int numberOfRecords = firstBatchRecords + secondBatchRecords;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, firstBatchRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, secondBatchRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(1L, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)firstBatchRecords, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)secondBatchRecords, missingEpoch)));
    }

    @Test
    public void testCreateExistingSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var5_5 = null;
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(snapshotId), (String)"Creating an existing snapshot should not do anything");
    }

    @Test
    public void testTopicId() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopicId(), (Object)log.topicId());
    }

    @Test
    public void testReadMissingSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals(Optional.empty(), (Object)log.readSnapshot(new OffsetAndEpoch(10L, 0)));
    }

    @Test
    public void testDeleteNonExistentSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 10;
        int epoch = 0;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch(2L, epoch)));
        Assertions.assertEquals((long)0L, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset);
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset);
    }

    @Test
    public void testTruncateFullyToLatestSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch sameEpochSnapshotId = new OffsetAndEpoch((long)(2 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(sameEpochSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)sameEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.endOffset().offset);
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.highWatermark().offset);
        OffsetAndEpoch greaterEpochSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(greaterEpochSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var8_8 = null;
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)greaterEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.endOffset().offset);
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.highWatermark().offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateWillRemoveOlderSnapshot() {
        void var2_2;
        void var4_4;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId1).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var11_8 = null;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId2).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var13_11 = null;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId3).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var15_14 = null;
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(greaterSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var17_17 = null;
        Assertions.assertNotEquals((Object)var3_3.earliestSnapshotId(), (Object)var3_3.latestSnapshotId());
        Assertions.assertTrue((boolean)var3_3.truncateToLatestSnapshot());
        Assertions.assertEquals((Object)var3_3.earliestSnapshotId(), (Object)var3_3.latestSnapshotId());
        var3_3.close();
        this.mockTime().sleep(var4_4.fileDeleteDelayMs());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$3 -> x$3.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$7((KafkaMetadataLog)var3_3, arg_0));
    }

    @Test
    public void testStartupWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        UnifiedLog qual$1 = log.log();
        Option x$2 = qual$1.truncateFullyAndStartAt$default$2();
        qual$1.truncateFullyAndStartAt(100L, x$2);
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(50L, 1));
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(100L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        UnifiedLog qual$2 = log.log();
        Option x$4 = qual$2.truncateFullyAndStartAt$default$2();
        qual$2.truncateFullyAndStartAt(200L, x$4);
        log.close();
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(500L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((long)500L, (long)log.log().logStartOffset());
    }

    @Test
    public void testSnapshotDeletionWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.log().truncateFullyAndStartAt(100L, log.log().truncateFullyAndStartAt$default$2());
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(100L, 1);
        this.writeEmptySnapshot(metadataDir, snapshotId);
        Path deletedPath = Snapshots.markForDelete((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId);
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
    }

    private File metadataLogDir(File logDir) {
        TopicPartition logDirName_topicPartition = KafkaRaftServer$.MODULE$.MetadataPartition();
        Object var2_2 = null;
        return new File(logDir.getAbsolutePath(), LocalLog$.MODULE$.logDirName(logDirName_topicPartition));
    }

    private void writeEmptySnapshot(File metadataDir, OffsetAndEpoch snapshotId) {
        try (FileRawSnapshotWriter writer = FileRawSnapshotWriter.create((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId, Optional.empty());){
            writer.freeze();
        }
    }

    @Test
    public void testDoesntTruncateFully() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderEpochSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch - 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(olderEpochSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderOffsetSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(olderOffsetSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var8_8 = null;
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupPartialSnapshots() {
        void var2_2;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(1L, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var8_7 = null;
        var3_3.close();
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(0L, epoch - 1));
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(1L, epoch));
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(2L, epoch + 1));
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)0L, (long)var3_3.startOffset());
        Assertions.assertEquals((int)epoch, (int)var3_3.lastFetchedEpoch());
        Assertions.assertEquals((long)numberOfRecords, (long)var3_3.endOffset().offset);
        Assertions.assertEquals((long)0L, (long)secondLog.highWatermark().offset);
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$6 -> x$6.isPresent()).forEach(path -> Assertions.assertFalse((boolean)((SnapshotPath)path.get()).partial));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupOlderSnapshots() {
        void var2_2;
        void var4_4;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId1).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var12_8 = null;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId2).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var14_11 = null;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(oldSnapshotId3).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var16_14 = null;
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)var3_3.storeSnapshot(greaterSnapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var18_17 = null;
        var3_3.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)greaterSnapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)(3 * numberOfRecords), (long)secondLog.startOffset());
        Assertions.assertEquals((int)epoch, (int)secondLog.lastFetchedEpoch());
        this.mockTime().sleep(var4_4.fileDeleteDelayMs());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$8 -> x$8.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$7((KafkaMetadataLog)var3_3, arg_0));
    }

    @Test
    public void testCreateReplicatedLogTruncatesFully() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords + 1), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        log.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.startOffset());
        Assertions.assertEquals((int)snapshotId.epoch(), (int)secondLog.lastFetchedEpoch());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.endOffset().offset);
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.highWatermark().offset);
    }

    @Test
    public void testMaxBatchSize() {
        int leaderEpoch = 5;
        int maxBatchSizeInBytes = 16384;
        int recordSize = 64;
        int x$2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$1();
        int x$3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$2();
        long x$4 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$3();
        long x$5 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$4();
        long x$6 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$5();
        int x$7 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7();
        long x$8 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8();
        int x$9 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9();
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(x$2, x$3, x$4, x$5, x$6, maxBatchSizeInBytes, x$7, x$8, x$9));
        MemoryRecords oversizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes + recordSize);
        Assertions.assertThrows(RecordTooLargeException.class, () -> log.appendAsLeader((Records)oversizeBatch, leaderEpoch));
        MemoryRecords undersizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes);
        LogAppendInfo appendInfo = log.appendAsLeader((Records)undersizeBatch, leaderEpoch);
        Assertions.assertEquals((long)0L, (long)appendInfo.firstOffset);
    }

    @Test
    public void testTruncateBelowHighWatermark() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numRecords = 10;
        int epoch = 5;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numRecords, epoch);
        Assertions.assertEquals((long)numRecords, (long)log.endOffset().offset);
        log.updateHighWatermark(new LogOffsetMetadata((long)numRecords));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.truncateTo(5L));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset);
    }

    private MemoryRecords buildFullBatch(int leaderEpoch, int recordSize, int maxBatchSizeInBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(maxBatchSizeInBytes);
        BatchBuilder batchBuilder = new BatchBuilder(buffer, (RecordSerde)new ByteArraySerde(), CompressionType.NONE, 0L, this.mockTime().milliseconds(), false, leaderEpoch, maxBatchSizeInBytes);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        List<byte[]> records = Collections.singletonList(new byte[recordSize]);
        while (!batchBuilder.bytesNeeded(records, serializationCache).isPresent()) {
            batchBuilder.appendRecord((Object)records.get(0), serializationCache);
        }
        return batchBuilder.build();
    }

    @Test
    public void testValidateEpochGreaterThanLastKnownEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch + 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanOldestSnapshotEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch - 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanOldestSnapshotOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        log.log().maybeIncrementLogStartOffset((long)offset, LogStartOffsetIncrementReason.SegmentDeletion);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(offset - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetEqualToOldestSnapshotOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        try (AutoCloseable resource_resource = (AutoCloseable)log.createNewSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)offset, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 4);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 3);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(20L, 2), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanFirstEpochInLog() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var6_5 = null;
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 3);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 2);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetGreatThanEndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords + 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanLEO() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch + 1);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(11L, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(10L, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateValidEpochAndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 5;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)(numberOfRecords - 1), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testAdvanceLogStartOffsetAfterCleaning() {
        MetadataLogConfig config = new MetadataLogConfig(512, 512, 10000L, 256L, 60000L, 512, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().maxFetchSizeInBytes(), 60000L, 1);
        config.copy(config.copy$default$1(), config.copy$default$2(), config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$9 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 47, 1));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since HW was still 0");
        log.updateHighWatermark(new LogOffsetMetadata(4000L));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since no snapshots exist");
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId1).get();){
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2((RawSnapshotWriter)resource_resource);
        }
        Object var9_4 = null;
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId2).get();){
            KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3((RawSnapshotWriter)resource_resource);
        }
        Object var11_7 = null;
        long lsoBefore = log.startOffset();
        Assertions.assertTrue((boolean)log.maybeClean(), (String)"Expected to clean since there was at least one snapshot");
        long lsoAfter = log.startOffset();
        Assertions.assertTrue((lsoAfter > lsoBefore ? 1 : 0) != 0, (String)"Log Start Offset should have increased after cleaning");
        Assertions.assertTrue((lsoAfter == snapshotId2.offset() ? 1 : 0) != 0, (String)"Expected the Log Start Offset to be less than or equal to the snapshot offset");
    }

    @Test
    public void testDeleteSnapshots() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(1024, 1024, 10000L, 1024L, 60000L, 100, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1000).foreach((Function1 & Serializable)x$10 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(1001L));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 200, 300, 400, 500, 600})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
            try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId).get();){
                KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3((RawSnapshotWriter)resource_resource);
            }
        });
        Assertions.assertEquals((int)6, (int)log.snapshotCount());
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected only one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$4((OffsetAndEpoch)assertOptional_optional.get());
        } else {
            Assertions.fail((String)"Missing value from Optional");
        }
        Object var3_3 = null;
        Assertions.assertEquals((long)log.startOffset(), (long)600L);
    }

    @Test
    public void testSoftRetentionLimit() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 100, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable)x$11 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(2000L));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId1).get();){
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2((RawSnapshotWriter)resource_resource);
        }
        Object var5_4 = null;
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId2).get();){
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3((RawSnapshotWriter)resource_resource);
        }
        Object var7_7 = null;
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$4(log, config, offsetAndEpoch);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    @Test
    public void testSegmentsLessThanLatestSnapshot() {
        MetadataLogConfig config = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy(10240, 10240, 10000L, 10240L, 60000L, 200, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$7(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$8(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().copy$default$9());
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable)x$12 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 10, 1));
        log.updateHighWatermark(new LogOffsetMetadata(log.endOffset().offset));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(((LogSegment)((IterableOps)log.log().logSegments().drop(1)).head()).baseOffset(), 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId1).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var9_4 = null;
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(((LogSegment)((IterableOps)log.log().logSegments().drop(2)).head()).baseOffset(), 1);
        try (AutoCloseable resource_resource = (AutoCloseable)log.storeSnapshot(snapshotId2).get();){
            ((RawSnapshotWriter)resource_resource).freeze();
        }
        Object var11_7 = null;
        long defaultLogRetentionMs = 1209600000L;
        this.mockTime().sleep(defaultLogRetentionMs);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount());
        Assertions.assertTrue((log.startOffset() > 0L ? 1 : 0) != 0, (String)new StringBuilder(23).append(log.startOffset()).append(" must be greater than 0").toString());
        long latestSnapshotOffset = ((OffsetAndEpoch)log.latestSnapshotId().get()).offset();
        Assertions.assertTrue((latestSnapshotOffset >= log.startOffset() ? 1 : 0) != 0, (String)new StringBuilder(56).append("latest snapshot offset (").append(latestSnapshotOffset).append(") must be >= log start offset (").append(log.startOffset()).append(")").toString());
    }

    public static final /* synthetic */ void $anonfun$testTruncateWillRemoveOlderSnapshot$7(KafkaMetadataLog log$7, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$7.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanupOlderSnapshots$7(KafkaMetadataLog log$8, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$8.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$2(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testAdvanceLogStartOffsetAfterCleaning$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 100);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 10);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$4(OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)600L, (long)snapshotId.offset());
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$2(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$5(KafkaMetadataLog log$13, MetadataLogConfig config$1, RawSnapshotReader reader) {
        Assertions.assertTrue((reader.sizeInBytes() + log$13.log().size() > config$1.retentionMaxBytes() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$4(KafkaMetadataLog log$13, MetadataLogConfig config$1, OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)2000L, (long)snapshotId.offset(), (String)"Unexpected offset for latest snapshot");
        Optional assertOptional_optional = log$13.readSnapshot(snapshotId);
        if (assertOptional_optional.isPresent()) {
            RawSnapshotReader rawSnapshotReader = (RawSnapshotReader)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$5(log$13, config$1, rawSnapshotReader);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotBeforeLogStartOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateSnapshotOlderEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateExistingSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyToLatestSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateWillRemoveOlderSnapshot$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$writeEmptySnapshot$1$adapted(FileRawSnapshotWriter x$4) {
        x$4.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDoesntTruncateFully$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupPartialSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCleanupOlderSnapshots$4$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateReplicatedLogTruncatesFully$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanOldestSnapshotEpoch$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetLessThanOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateOffsetEqualToOldestSnapshotOffset$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateEpochLessThanFirstEpochInLog$1$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$2$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$2(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAdvanceLogStartOffsetAfterCleaning$3$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testAdvanceLogStartOffsetAfterCleaning$3(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$2$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSoftRetentionLimit$3$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3(snapshot);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSegmentsLessThanLatestSnapshot$2$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSegmentsLessThanLatestSnapshot$3$adapted(RawSnapshotWriter snapshot) {
        snapshot.freeze();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testDeleteSnapshots$3$adapted(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3(snapshot);
        return BoxedUnit.UNIT;
    }

    public static class ByteArraySerde
    implements RecordSerde<byte[]> {
        public int recordSize(byte[] data, ObjectSerializationCache serializationCache) {
            return data.length;
        }

        public void write(byte[] data, ObjectSerializationCache serializationCache, Writable out) {
            out.writeByteArray(data);
        }

        public byte[] read(Readable input, int size) {
            return input.readArray(size);
        }
    }
}

