/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaNetworkChannelTest$;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.RaftResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\tEd\u0001B\u0016-\u0001EBQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u0019a\u0005\u0001)A\u0005\u0013\"9Q\n\u0001b\u0001\n\u0013q\u0005B\u0002/\u0001A\u0003%q\nC\u0004^\u0001\t\u0007I\u0011\u00020\t\r\u0015\u0004\u0001\u0015!\u0003`\u0011\u001d1\u0007A1A\u0005\n\u001dDa\u0001\u001c\u0001!\u0002\u0013A\u0007bB7\u0001\u0005\u0004%IA\u001c\u0005\u0007e\u0002\u0001\u000b\u0011B8\t\u000fM\u0004!\u0019!C\u0005i\"1\u0001\u0010\u0001Q\u0001\nUDQ!\u001f\u0001\u0005\u0002iDa!a\u0005\u0001\t\u0003Q\bBBA\u000f\u0001\u0011\u0005!\u0010\u0003\u0004\u0002\"\u0001!\tA\u001f\u0005\u0007\u0003K\u0001A\u0011\u0001>\t\r\u0005%\u0002\u0001\"\u0001{\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aa!!\u000e\u0001\t\u0003Q\bBBA\u001d\u0001\u0011\u0005!\u0010C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z!9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005bBAV\u0001\u0011%\u0011Q\u0016\u0005\b\u0003o\u0003A\u0011BA]\u0011\u001d\t)\r\u0001C\u0005\u0003\u000fDq!!4\u0001\t\u0013\ty\rC\u0004\u0002V\u0002!\t!a6\b\u000f\u0005%H\u0006#\u0001\u0002l\u001a11\u0006\fE\u0001\u0003[Da\u0001\u000f\u0012\u0005\u0002\u0005=\b\"CAyE\t\u0007I\u0011AAz\u0011!\u0011)A\tQ\u0001\n\u0005UhA\u0002B\u0004E\u0011\u0011I\u0001\u0003\u00049M\u0011\u0005!Q\u0007\u0005\b\u0005w1C\u0011\tB\u001f\u0011\u001d\u0011\tF\nC!\u0005'BqAa\u0017'\t\u0003\u0012iFA\fLC\u001a\\\u0017MT3uo>\u00148n\u00115b]:,G\u000eV3ti*\u0011QFL\u0001\u0005e\u00064GOC\u00010\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\b\u0005\u0002<\u00015\tA&A\u0005dYV\u001cH/\u001a:JIV\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006!A.\u00198h\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012!\u0003\rM#(/\u001b8h\u0003)\u0019G.^:uKJLE\rI\u0001\u0011e\u0016\fX/Z:u)&lWm\\;u\u001bN,\u0012!\u0013\t\u0003g)K!a\u0013\u001b\u0003\u0007%sG/A\tsKF,Xm\u001d;US6,w.\u001e;Ng\u0002\nA\u0001^5nKV\tq\n\u0005\u0002Q56\t\u0011K\u0003\u0002S'\u0006)Q\u000f^5mg*\u0011A+V\u0001\u0007G>lWn\u001c8\u000b\u0005=2&BA,Y\u0003\u0019\t\u0007/Y2iK*\t\u0011,A\u0002pe\u001eL!aW)\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\naa\u00197jK:$X#A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t,\u0016aB2mS\u0016tGo]\u0005\u0003I\u0006\u0014!\"T8dW\u000ec\u0017.\u001a8u\u0003\u001d\u0019G.[3oi\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001i!\tI'.D\u0001T\u0013\tY7K\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nq\u0001^8qS\u000eLE-F\u0001p!\tI\u0007/\u0003\u0002r'\n!Q+^5e\u0003!!x\u000e]5d\u0013\u0012\u0004\u0013aB2iC:tW\r\\\u000b\u0002kB\u00111H^\u0005\u0003o2\u00121cS1gW\u0006tU\r^<pe.\u001c\u0005.\u00198oK2\f\u0001b\u00195b]:,G\u000eI\u0001\u0013g\u0016$X\u000f]*vaB|'\u000f^3e\u0003BL7\u000fF\u0001|!\t\u0019D0\u0003\u0002~i\t!QK\\5uQ\t\u0001r\u0010\u0005\u0003\u0002\u0002\u0005=QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\n\u0005-\u0011a\u00026va&$XM\u001d\u0006\u0004\u0003\u001bA\u0016!\u00026v]&$\u0018\u0002BA\t\u0003\u0007\u0011!BQ3g_J,W)Y2i\u0003q!Xm\u001d;TK:$Gk\\+oW:|wO\u001c#fgRLg.\u0019;j_:D3!EA\f!\u0011\t\t!!\u0007\n\t\u0005m\u00111\u0001\u0002\u0005)\u0016\u001cH/A\u0010uKN$8+\u001a8e)>\u0014E.Y2lK\u0012|U\u000f\u001e#fgRLg.\u0019;j_:D3AEA\f\u0003Y!Xm\u001d;XC.,W\u000f]\"mS\u0016tGo\u00148TK:$\u0007fA\n\u0002\u0018\u0005)B/Z:u'\u0016tG-\u00118e\t&\u001c8m\u001c8oK\u000e$\bf\u0001\u000b\u0002\u0018\u0005iB/Z:u'\u0016tG-\u00118e\r\u0006LG.Q;uQ\u0016tG/[2bi&|g\u000eK\u0002\u0016\u0003/\t\u0001$Y:tKJ$(I]8lKJtu\u000e^!wC&d\u0017M\u00197f)\rY\u0018\u0011\u0007\u0005\u0007\u0003g1\u0002\u0019A%\u0002\u001b\u0011,7\u000f^5oCRLwN\\%e\u0003\u0005\"Xm\u001d;TK:$\u0017I\u001c3SK\u000e,\u0017N^3PkR\u0014w.\u001e8e%\u0016\fX/Z:uQ\r9\u0012qC\u0001\u001ci\u0016\u001cH/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u0016\u0013(o\u001c:)\u0007a\t9\"A\ruKN$h)\u001a;dQJ+\u0017/^3ti\u0012{wO\\4sC\u0012,GcA>\u0002B!9\u00111I\rA\u0002\u0005\u0015\u0013a\u0002<feNLwN\u001c\t\u0004g\u0005\u001d\u0013bAA%i\t)1\u000b[8si\":\u0011$!\u0014\u0002Z\u0005m\u0003\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005M\u0013+\u0001\u0006b]:|G/\u0019;j_:LA!a\u0016\u0002R\t!\u0012\t]5LKf4VM]:j_:\u001c8k\\;sG\u0016\fa!\u00199j\u0017\u0016LHEAA/\u0013\u0011\ty&!\u0019\u0002\u000b\u0019+Ek\u0011%\u000b\t\u0005\r\u0014QM\u0001\b\u0003BL7*Z=t\u0015\r\t9gU\u0001\taJ|Go\\2pY\"\u001a\u0011$a\u001b\u0011\t\u00055\u00141O\u0007\u0003\u0003_RA!!\u001d\u0002\b\u00051\u0001/\u0019:b[NLA!!\u001e\u0002p\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\u001fM,g\u000e\u001a+fgR\u0014V-];fgR$b!a\u001f\u0002\u000e\u0006]\u0005\u0003BA?\u0003\u000fsA!a \u0002\u00046\u0011\u0011\u0011\u0011\u0006\u0003[UKA!!\"\u0002\u0002\u0006Y!+\u00194u%\u0016\fX/Z:u\u0013\u0011\tI)a#\u0003\u0011=+HOY8v]\u0012TA!!\"\u0002\u0002\"9\u0011\u0011\f\u000eA\u0002\u0005=\u0005\u0003BAI\u0003'k!!!\u001a\n\t\u0005U\u0015Q\r\u0002\b\u0003BL7*Z=t\u0011\u0019\t\u0019D\u0007a\u0001\u0013\u00069\u0012m]:feR\u0014Vm\u001d9p]N,7i\\7qY\u0016$X\r\u001a\u000b\u0006w\u0006u\u0015\u0011\u0015\u0005\b\u0003?[\u0002\u0019AA>\u0003\u001d\u0011X-];fgRDq!a)\u001c\u0001\u0004\t)+A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\t\u0005\u0003#\u000b9+\u0003\u0003\u0002*\u0006\u0015$AB#se>\u00148/\u0001\u000etK:$\u0017I\u001c3BgN,'\u000f^#se>\u0014(+Z:q_:\u001cX\rF\u0004|\u0003_\u000b\t,a-\t\u000f\u0005eC\u00041\u0001\u0002\u0010\"1\u00111\u0007\u000fA\u0002%Cq!!.\u001d\u0001\u0004\t)+A\u0003feJ|'/\u0001\tck&dG\rV3tiJ+\u0017/^3tiR!\u00111XAa!\u0011\t\t*!0\n\t\u0005}\u0016Q\r\u0002\u000b\u0003BLW*Z:tC\u001e,\u0007bBAb;\u0001\u0007\u0011qR\u0001\u0004W\u0016L\u0018A\u00062vS2$G+Z:u\u000bJ\u0014xN\u001d*fgB|gn]3\u0015\r\u0005m\u0016\u0011ZAf\u0011\u001d\t\u0019M\ba\u0001\u0003\u001fCq!!.\u001f\u0001\u0004\t)+\u0001\u0007fqR\u0014\u0018m\u0019;FeJ|'\u000f\u0006\u0003\u0002&\u0006E\u0007bBAj?\u0001\u0007\u00111X\u0001\te\u0016\u001c\bo\u001c8tK\u0006i!-^5mIJ+7\u000f]8og\u0016$B!!7\u0002fB!\u00111\\Aq\u001b\t\tiNC\u0002\u0002`N\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003G\fiN\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\"9\u0011q\u001d\u0011A\u0002\u0005m\u0016\u0001\u0004:fgB|gn]3ECR\f\u0017aF&bM.\fg*\u001a;x_J\\7\t[1o]\u0016dG+Z:u!\tY$e\u0005\u0002#eQ\u0011\u00111^\u0001\t%\u00064G/\u00119jgV\u0011\u0011Q\u001f\t\u0007\u0003o\u0014\t!a$\u000e\u0005\u0005e(\u0002BA~\u0003{\f\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005}H'\u0001\u0006d_2dWm\u0019;j_:LAAa\u0001\u0002z\n\u00191+Z9\u0002\u0013I\u000bg\r^!qSN\u0004#aE*uk\nlU\r^1eCR\fW\u000b\u001d3bi\u0016\u00148#\u0002\u0014\u0003\f\tE\u0001cA \u0003\u000e%\u0019!q\u0002!\u0003\r=\u0013'.Z2u!\u0011\u0011\u0019Ba\f\u000f\t\tU!1\u0006\b\u0005\u0005/\u0011IC\u0004\u0003\u0003\u001a\t\u001db\u0002\u0002B\u000e\u0005KqAA!\b\u0003$5\u0011!q\u0004\u0006\u0004\u0005C\u0001\u0014A\u0002\u001fs_>$h(C\u0001Z\u0013\t9\u0006,\u0003\u00020-&\u0011!-V\u0005\u0004\u0005[\t\u0017AC'pG.\u001cE.[3oi&!!\u0011\u0007B\u001a\u0005MiunY6NKR\fG-\u0019;b+B$\u0017\r^3s\u0015\r\u0011i#\u0019\u000b\u0003\u0005o\u00012A!\u000f'\u001b\u0005\u0011\u0013A\u00034fi\u000eDgj\u001c3fgR\u0011!q\b\t\u0007\u0005\u0003\u00129Ea\u0013\u000e\u0005\t\r#b\u0001B#\u0005\u0006!Q\u000f^5m\u0013\u0011\u0011IEa\u0011\u0003\t1K7\u000f\u001e\t\u0004S\n5\u0013b\u0001B('\n!aj\u001c3f\u00039I7/\u00169eCR,g*Z3eK\u0012$\"A!\u0016\u0011\u0007M\u00129&C\u0002\u0003ZQ\u0012qAQ8pY\u0016\fg.\u0001\u0004va\u0012\fG/\u001a\u000b\u0006w\n}#q\r\u0005\u0007\u001b*\u0002\rA!\u0019\u0011\u0007A\u0013\u0019'C\u0002\u0003fE\u0013A\u0001V5nK\"9!1\f\u0016A\u0002\t%\u0004\u0003\u0002B6\u0005[r1\u0001\u0019B\u0016\u0013\u0011\u0011yGa\r\u0003\u001d5+G/\u00193bi\u0006,\u0006\u000fZ1uK\u0002")
public class KafkaNetworkChannelTest {
    private final String clusterId;
    private final int requestTimeoutMs;
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time(), (MockClient.MockMetadataUpdater)new StubMetadataUpdater());
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final Uuid topicId = Uuid.randomUuid();
    private final KafkaNetworkChannel kafka$raft$KafkaNetworkChannelTest$$channel = new KafkaNetworkChannel((Time)this.time(), (KafkaClient)this.client(), this.requestTimeoutMs(), "test-raft");

    public static scala.collection.immutable.Seq<ApiKeys> RaftApis() {
        return KafkaNetworkChannelTest$.MODULE$.RaftApis();
    }

    private String clusterId() {
        return this.clusterId;
    }

    private int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    public KafkaNetworkChannel kafka$raft$KafkaNetworkChannelTest$$channel() {
        return this.kafka$raft$KafkaNetworkChannelTest$$channel;
    }

    @BeforeEach
    public void setupSupportedApis() {
        scala.collection.immutable.Seq supportedApis = (scala.collection.immutable.Seq)KafkaNetworkChannelTest$.MODULE$.RaftApis().map((Function1 & Serializable)x$1 -> ApiVersionsResponse.toApiVersion((ApiKeys)x$1));
        this.client().setNodeApiVersions(NodeApiVersions.create((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)supportedApis).asJava()));
    }

    @Test
    public void testSendToUnknownDestination() {
        int destinationId = 2;
        this.assertBrokerNotAvailable(destinationId);
    }

    @Test
    public void testSendToBlackedOutDestination() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        this.client().backoff(destinationNode, 500L);
        this.assertBrokerNotAvailable(destinationId);
    }

    @Test
    public void testWakeupClientOnSend() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        this.client().enableBlockingUntilWakeup(1);
        Thread ioThread = new Thread(this){
            private final /* synthetic */ KafkaNetworkChannelTest $outer;

            public void run() {
                this.$outer.kafka$raft$KafkaNetworkChannelTest$$channel().pollOnce();
                this.$outer.kafka$raft$KafkaNetworkChannelTest$$channel().pollOnce();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        AbstractResponse response = this.buildResponse(this.buildTestErrorResponse(ApiKeys.FETCH, Errors.INVALID_REQUEST));
        this.client().prepareResponseFrom(response, destinationNode, false);
        ioThread.start();
        RaftRequest.Outbound request = this.sendTestRequest(ApiKeys.FETCH, destinationId);
        ioThread.join();
        this.assertResponseCompleted(request, Errors.INVALID_REQUEST);
    }

    @Test
    public void testSendAndDisconnect() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndDisconnect$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSendAndFailAuthentication() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndFailAuthentication$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    private void assertBrokerNotAvailable(int destinationId) {
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable)apiKey -> {
            this.sendAndAssertErrorResponse(apiKey, destinationId, Errors.BROKER_NOT_AVAILABLE);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSendAndReceiveOutboundRequest() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testSendAndReceiveOutboundRequest$1(this, destinationNode, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUnsupportedVersionError() {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        KafkaNetworkChannelTest$.MODULE$.RaftApis().foreach((Function1 & Serializable)apiKey -> {
            KafkaNetworkChannelTest.$anonfun$testUnsupportedVersionError$1(this, destinationId, apiKey);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.FETCH)
    public void testFetchRequestDowngrade(short version) {
        int destinationId = 2;
        Node destinationNode = new Node(destinationId, "127.0.0.1", 9092);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().updateEndpoint(destinationId, new RaftConfig.InetAddressSpec(new InetSocketAddress(destinationNode.host(), destinationNode.port())));
        this.sendTestRequest(ApiKeys.FETCH, destinationId);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().pollOnce();
        Assertions.assertEquals((int)1, (int)this.client().requests().size());
        AbstractRequest request = ((ClientRequest)this.client().requests().peek()).requestBuilder().build(version);
        if (version < 15) {
            Assertions.assertTrue((((FetchRequest)request).data().replicaId() == 1 ? 1 : 0) != 0);
            Assertions.assertTrue((((FetchRequest)request).data().replicaState().replicaId() == -1 ? 1 : 0) != 0);
            return;
        }
        Assertions.assertTrue((((FetchRequest)request).data().replicaId() == -1 ? 1 : 0) != 0);
        Assertions.assertTrue((((FetchRequest)request).data().replicaState().replicaId() == 1 ? 1 : 0) != 0);
    }

    private RaftRequest.Outbound sendTestRequest(ApiKeys apiKey, int destinationId) {
        int correlationId = this.kafka$raft$KafkaNetworkChannelTest$$channel().newCorrelationId();
        long createdTimeMs = this.time().milliseconds();
        ApiMessage apiRequest = this.buildTestRequest(apiKey);
        RaftRequest.Outbound request = new RaftRequest.Outbound(correlationId, apiRequest, destinationId, createdTimeMs);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().send(request);
        return request;
    }

    private void assertResponseCompleted(RaftRequest.Outbound request, Errors expectedError) {
        Assertions.assertTrue((boolean)request.completion.isDone());
        RaftResponse.Inbound response = (RaftResponse.Inbound)request.completion.get();
        Assertions.assertEquals((int)request.destinationId(), (int)response.sourceId());
        Assertions.assertEquals((int)request.correlationId(), (int)response.correlationId());
        Assertions.assertEquals((short)request.data().apiKey(), (short)response.data().apiKey());
        Assertions.assertEquals((Object)expectedError, (Object)this.extractError(response.data()));
    }

    private void sendAndAssertErrorResponse(ApiKeys apiKey, int destinationId, Errors error) {
        RaftRequest.Outbound request = this.sendTestRequest(apiKey, destinationId);
        this.kafka$raft$KafkaNetworkChannelTest$$channel().pollOnce();
        this.assertResponseCompleted(request, error);
    }

    /*
     * WARNING - void declaration
     */
    private ApiMessage buildTestRequest(ApiKeys key) {
        int leaderEpoch = 5;
        int leaderId = 1;
        if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(key)) {
            return BeginQuorumEpochRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)leaderEpoch, (int)leaderId);
        }
        if (ApiKeys.END_QUORUM_EPOCH.equals(key)) {
            return EndQuorumEpochRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)leaderId, (int)leaderEpoch, Collections.singletonList(Predef$.MODULE$.int2Integer(2)));
        }
        if (ApiKeys.VOTE.equals(key)) {
            int lastEpoch = 4;
            return VoteRequest.singletonRequest((TopicPartition)this.topicPartition(), (String)this.clusterId(), (int)leaderEpoch, (int)leaderId, (int)lastEpoch, (long)329L);
        }
        if (ApiKeys.FETCH.equals(key)) {
            void singletonFetchRequest_topicId;
            Uuid uuid = this.topicId();
            TopicPartition singletonFetchRequest_topicPartition = this.topicPartition();
            FetchRequestData.FetchPartition singletonFetchRequest_fetchPartition = new FetchRequestData.FetchPartition().setPartition(singletonFetchRequest_topicPartition.partition());
            KafkaNetworkChannelTest.$anonfun$buildTestRequest$1(singletonFetchRequest_fetchPartition);
            FetchRequestData.FetchTopic singletonFetchRequest_fetchTopic = new FetchRequestData.FetchTopic().setTopic(singletonFetchRequest_topicPartition.topic()).setTopicId((Uuid)singletonFetchRequest_topicId).setPartitions(Collections.singletonList(singletonFetchRequest_fetchPartition));
            Object var5_6 = null;
            uuid = null;
            Object var7_7 = null;
            Object var8_8 = null;
            return new FetchRequestData().setTopics(Collections.singletonList(singletonFetchRequest_fetchTopic)).setReplicaState(new FetchRequestData.ReplicaState().setReplicaId(1));
        }
        throw new AssertionError((Object)new StringBuilder(15).append("Unexpected api ").append(key).toString());
    }

    private ApiMessage buildTestErrorResponse(ApiKeys key, Errors error) {
        if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(key)) {
            return new BeginQuorumEpochResponseData().setErrorCode(error.code());
        }
        if (ApiKeys.END_QUORUM_EPOCH.equals(key)) {
            return new EndQuorumEpochResponseData().setErrorCode(error.code());
        }
        if (ApiKeys.VOTE.equals(key)) {
            return VoteResponse.singletonResponse((Errors)error, (TopicPartition)this.topicPartition(), (Errors)Errors.NONE, (int)1, (int)5, (boolean)false);
        }
        if (ApiKeys.FETCH.equals(key)) {
            return new FetchResponseData().setErrorCode(error.code());
        }
        throw new AssertionError((Object)new StringBuilder(15).append("Unexpected api ").append(key).toString());
    }

    private Errors extractError(ApiMessage response) {
        short s;
        if (response instanceof BeginQuorumEpochResponseData) {
            s = ((BeginQuorumEpochResponseData)response).errorCode();
        } else if (response instanceof EndQuorumEpochResponseData) {
            s = ((EndQuorumEpochResponseData)response).errorCode();
        } else if (response instanceof FetchResponseData) {
            s = ((FetchResponseData)response).errorCode();
        } else if (response instanceof VoteResponseData) {
            s = ((VoteResponseData)response).errorCode();
        } else {
            throw new MatchError((Object)response);
        }
        return Errors.forCode((short)s);
    }

    public AbstractResponse buildResponse(ApiMessage responseData) {
        if (responseData instanceof VoteResponseData) {
            VoteResponseData voteResponseData = (VoteResponseData)responseData;
            return new VoteResponse(voteResponseData);
        }
        if (responseData instanceof BeginQuorumEpochResponseData) {
            BeginQuorumEpochResponseData beginQuorumEpochResponseData = (BeginQuorumEpochResponseData)responseData;
            return new BeginQuorumEpochResponse(beginQuorumEpochResponseData);
        }
        if (responseData instanceof EndQuorumEpochResponseData) {
            EndQuorumEpochResponseData endQuorumEpochResponseData = (EndQuorumEpochResponseData)responseData;
            return new EndQuorumEpochResponse(endQuorumEpochResponseData);
        }
        if (responseData instanceof FetchResponseData) {
            FetchResponseData fetchResponseData = (FetchResponseData)responseData;
            return new FetchResponse(fetchResponseData);
        }
        throw new IllegalArgumentException(new StringBuilder(34).append("Unexpected type for responseData: ").append(responseData).toString());
    }

    public static final /* synthetic */ void $anonfun$testSendAndDisconnect$1(KafkaNetworkChannelTest $this, Node destinationNode$1, int destinationId$1, ApiKeys apiKey) {
        AbstractResponse response = $this.buildResponse($this.buildTestErrorResponse(apiKey, Errors.INVALID_REQUEST));
        $this.client().prepareResponseFrom(response, destinationNode$1, true);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$1, Errors.BROKER_NOT_AVAILABLE);
    }

    public static final /* synthetic */ void $anonfun$testSendAndFailAuthentication$1(KafkaNetworkChannelTest $this, Node destinationNode$2, int destinationId$2, ApiKeys apiKey) {
        $this.client().createPendingAuthenticationError(destinationNode$2, 100L);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$2, Errors.NETWORK_EXCEPTION);
        $this.client().reset();
    }

    public static final /* synthetic */ void $anonfun$testSendAndReceiveOutboundRequest$1(KafkaNetworkChannelTest $this, Node destinationNode$3, int destinationId$4, ApiKeys apiKey) {
        Errors expectedError = Errors.INVALID_REQUEST;
        AbstractResponse response = $this.buildResponse($this.buildTestErrorResponse(apiKey, expectedError));
        $this.client().prepareResponseFrom(response, destinationNode$3);
        $this.sendAndAssertErrorResponse(apiKey, destinationId$4, expectedError);
    }

    public static final /* synthetic */ void $anonfun$testUnsupportedVersionError$1(KafkaNetworkChannelTest $this, int destinationId$5, ApiKeys apiKey) {
        $this.client().prepareUnsupportedVersionResponse(request -> {
            ApiKeys apiKeys = request.apiKey();
            return !(apiKeys != null ? !apiKeys.equals(apiKey) : apiKey != null);
        });
        $this.sendAndAssertErrorResponse(apiKey, destinationId$5, Errors.UNSUPPORTED_VERSION);
    }

    public static final /* synthetic */ void $anonfun$buildTestRequest$1(FetchRequestData.FetchPartition fetchPartition) {
        fetchPartition.setCurrentLeaderEpoch(5).setFetchOffset(333L).setLastFetchedEpoch(5);
    }

    public KafkaNetworkChannelTest() {
        this.clusterId = "clusterId";
        this.requestTimeoutMs = 30000;
    }

    private static class StubMetadataUpdater
    implements MockClient.MockMetadataUpdater {
        public void updateWithCurrentMetadata(Time x$1) {
            super.updateWithCurrentMetadata(x$1);
        }

        public void close() {
            super.close();
        }

        public List<Node> fetchNodes() {
            return Collections.emptyList();
        }

        public boolean isUpdateNeeded() {
            return false;
        }

        public void update(Time time, MockClient.MetadataUpdate update) {
        }
    }
}

